/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.HttpUserAuthentication;
import com.mojang.authlib.UserType;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.request.AuthenticationRequest;
import com.mojang.authlib.yggdrasil.request.RefreshRequest;
import com.mojang.authlib.yggdrasil.response.AuthenticationResponse;
import com.mojang.authlib.yggdrasil.response.RefreshResponse;
import com.mojang.authlib.yggdrasil.response.User;
import com.teamextreme.fyre.a;
import com.teamextreme.fyre.b;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class YggdrasilUserAuthentication
extends HttpUserAuthentication {
    private static final a LOGGER = b.ad();
    private static final String BASE_URL = "https://authserver.mojang.com/";
    private static final URL ROUTE_AUTHENTICATE = HttpAuthenticationService.constantURL("https://authserver.mojang.com/authenticate");
    private static final URL ROUTE_REFRESH = HttpAuthenticationService.constantURL("https://authserver.mojang.com/refresh");
    private static final URL ROUTE_VALIDATE = HttpAuthenticationService.constantURL("https://authserver.mojang.com/validate");
    private static final URL ROUTE_INVALIDATE = HttpAuthenticationService.constantURL("https://authserver.mojang.com/invalidate");
    private static final URL ROUTE_SIGNOUT = HttpAuthenticationService.constantURL("https://authserver.mojang.com/signout");
    private static final String STORAGE_KEY_ACCESS_TOKEN = "accessToken";
    private final Agent agent;
    private GameProfile[] profiles;
    private String accessToken;
    private boolean isOnline;

    public YggdrasilUserAuthentication(YggdrasilAuthenticationService yggdrasilAuthenticationService, Agent agent) {
        super(yggdrasilAuthenticationService);
        this.agent = agent;
    }

    @Override
    public boolean canLogIn() {
        return !this.canPlayOnline() && StringUtils.isNotBlank(this.getUsername()) && (StringUtils.isNotBlank(this.getPassword()) || StringUtils.isNotBlank(this.getAuthenticatedToken()));
    }

    @Override
    public void logIn() throws AuthenticationException {
        if (StringUtils.isBlank(this.getUsername())) {
            throw new InvalidCredentialsException("Invalid username");
        }
        if (StringUtils.isNotBlank(this.getAuthenticatedToken())) {
            this.logInWithToken();
            return;
        }
        if (StringUtils.isNotBlank(this.getPassword())) {
            this.logInWithPassword();
            return;
        }
        throw new InvalidCredentialsException("Invalid password");
    }

    protected void logInWithPassword() throws AuthenticationException {
        if (StringUtils.isBlank(this.getUsername())) {
            throw new InvalidCredentialsException("Invalid username");
        }
        if (StringUtils.isBlank(this.getPassword())) {
            throw new InvalidCredentialsException("Invalid password");
        }
        LOGGER.log("Logging in with username & password");
        Object object = new AuthenticationRequest(this, this.getUsername(), this.getPassword());
        object = this.getAuthenticationService().makeRequest(ROUTE_AUTHENTICATE, object, AuthenticationResponse.class);
        if (!((AuthenticationResponse)object).getClientToken().equals(this.getAuthenticationService().getClientToken())) {
            throw new AuthenticationException("Server requested we change our client token. Don't know how to handle this!");
        }
        if (((AuthenticationResponse)object).getSelectedProfile() != null) {
            this.setUserType(((AuthenticationResponse)object).getSelectedProfile().isLegacy() ? UserType.LEGACY : UserType.MOJANG);
        } else if (ArrayUtils.isNotEmpty(((AuthenticationResponse)object).getAvailableProfiles())) {
            this.setUserType(((AuthenticationResponse)object).getAvailableProfiles()[0].isLegacy() ? UserType.LEGACY : UserType.MOJANG);
        }
        User user = ((AuthenticationResponse)object).getUser();
        if (user != null && user.getId() != null) {
            this.setUserid(user.getId());
        } else {
            this.setUserid(this.getUsername());
        }
        this.isOnline = true;
        this.accessToken = ((AuthenticationResponse)object).getAccessToken();
        this.profiles = ((AuthenticationResponse)object).getAvailableProfiles();
        this.setSelectedProfile(((AuthenticationResponse)object).getSelectedProfile());
        this.getModifiableUserProperties().clear();
        this.updateUserProperties(user);
    }

    protected void updateUserProperties(User user) {
        if (user == null) {
            return;
        }
        if (user.getProperties() != null) {
            this.getModifiableUserProperties().putAll(user.getProperties());
        }
    }

    protected void logInWithToken() throws AuthenticationException {
        if (StringUtils.isBlank(this.getUserID())) {
            if (StringUtils.isBlank(this.getUsername())) {
                this.setUserid(this.getUsername());
            } else {
                throw new InvalidCredentialsException("Invalid uuid & username");
            }
        }
        if (StringUtils.isBlank(this.getAuthenticatedToken())) {
            throw new InvalidCredentialsException("Invalid access token");
        }
        LOGGER.log("Logging in with access token");
        Object object = new RefreshRequest(this);
        object = this.getAuthenticationService().makeRequest(ROUTE_REFRESH, object, RefreshResponse.class);
        if (!((RefreshResponse)object).getClientToken().equals(this.getAuthenticationService().getClientToken())) {
            throw new AuthenticationException("Server requested we change our client token. Don't know how to handle this!");
        }
        if (((RefreshResponse)object).getSelectedProfile() != null) {
            this.setUserType(((RefreshResponse)object).getSelectedProfile().isLegacy() ? UserType.LEGACY : UserType.MOJANG);
        } else if (ArrayUtils.isNotEmpty(((RefreshResponse)object).getAvailableProfiles())) {
            this.setUserType(((RefreshResponse)object).getAvailableProfiles()[0].isLegacy() ? UserType.LEGACY : UserType.MOJANG);
        }
        if (((RefreshResponse)object).getUser() != null && ((RefreshResponse)object).getUser().getId() != null) {
            this.setUserid(((RefreshResponse)object).getUser().getId());
        } else {
            this.setUserid(this.getUsername());
        }
        this.isOnline = true;
        this.accessToken = ((RefreshResponse)object).getAccessToken();
        this.profiles = ((RefreshResponse)object).getAvailableProfiles();
        this.setSelectedProfile(((RefreshResponse)object).getSelectedProfile());
        this.getModifiableUserProperties().clear();
        this.updateUserProperties(((RefreshResponse)object).getUser());
    }

    @Override
    public void logOut() {
        super.logOut();
        this.accessToken = null;
        this.profiles = null;
        this.isOnline = false;
    }

    @Override
    public GameProfile[] getAvailableProfiles() {
        return this.profiles;
    }

    @Override
    public boolean isLoggedIn() {
        return StringUtils.isNotBlank(this.accessToken);
    }

    @Override
    public boolean canPlayOnline() {
        return this.isLoggedIn() && this.getSelectedProfile() != null && this.isOnline;
    }

    @Override
    public void selectGameProfile(GameProfile object) throws AuthenticationException {
        if (!this.isLoggedIn()) {
            throw new AuthenticationException("Cannot change game profile whilst not logged in");
        }
        if (this.getSelectedProfile() != null) {
            throw new AuthenticationException("Cannot change game profile. You must log out and back in.");
        }
        if (object == null || !ArrayUtils.contains(this.profiles, object)) {
            throw new IllegalArgumentException("Invalid profile '" + object + "'");
        }
        object = new RefreshRequest(this, (GameProfile)object);
        object = this.getAuthenticationService().makeRequest(ROUTE_REFRESH, object, RefreshResponse.class);
        if (!((RefreshResponse)object).getClientToken().equals(this.getAuthenticationService().getClientToken())) {
            throw new AuthenticationException("Server requested we change our client token. Don't know how to handle this!");
        }
        this.isOnline = true;
        this.accessToken = ((RefreshResponse)object).getAccessToken();
        this.setSelectedProfile(((RefreshResponse)object).getSelectedProfile());
    }

    @Override
    public void loadFromStorage(Map<String, Object> map) {
        super.loadFromStorage(map);
        this.accessToken = String.valueOf(map.get(STORAGE_KEY_ACCESS_TOKEN));
    }

    @Override
    public Map<String, Object> saveForStorage() {
        Map<String, Object> map = super.saveForStorage();
        if (StringUtils.isNotBlank(this.getAuthenticatedToken())) {
            map.put(STORAGE_KEY_ACCESS_TOKEN, this.getAuthenticatedToken());
        }
        return map;
    }

    @Deprecated
    public String getSessionToken() {
        if (this.isLoggedIn() && this.getSelectedProfile() != null && this.canPlayOnline()) {
            return String.format("token:%s:%s", this.getAuthenticatedToken(), this.getSelectedProfile().getId());
        }
        return null;
    }

    @Override
    public String getAuthenticatedToken() {
        return this.accessToken;
    }

    public Agent getAgent() {
        return this.agent;
    }

    @Override
    public String toString() {
        return "YggdrasilAuthenticationService{agent=" + this.agent + ", profiles=" + Arrays.toString(this.profiles) + ", selectedProfile=" + this.getSelectedProfile() + ", username='" + this.getUsername() + '\'' + ", isLoggedIn=" + this.isLoggedIn() + ", userType=" + (Object)((Object)this.getUserType()) + ", canPlayOnline=" + this.canPlayOnline() + ", accessToken='" + this.accessToken + '\'' + ", clientToken='" + this.getAuthenticationService().getClientToken() + '\'' + '}';
    }

    @Override
    public YggdrasilAuthenticationService getAuthenticationService() {
        return (YggdrasilAuthenticationService)super.getAuthenticationService();
    }
}

