/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.launcher.updater;

import com.mojang.launcher.versions.Version;
import com.teamextreme.fyre.d;

@d
public class VersionSyncInfo {
    private final Version localVersion;
    private final Version remoteVersion;
    private final boolean isInstalled;
    private final boolean isUpToDate;

    public VersionSyncInfo(Version version, Version version2, boolean bl, boolean bl2) {
        this.localVersion = version;
        this.remoteVersion = version2;
        this.isInstalled = bl;
        this.isUpToDate = bl2;
    }

    public Version getLocalVersion() {
        return this.localVersion;
    }

    public Version getRemoteVersion() {
        return this.remoteVersion;
    }

    public Version getLatestVersion() {
        if (this.getLatestSource() == VersionSource.REMOTE) {
            return this.remoteVersion;
        }
        return this.localVersion;
    }

    public VersionSource getLatestSource() {
        if (this.getLocalVersion() == null) {
            return VersionSource.REMOTE;
        }
        if (this.getRemoteVersion() == null) {
            return VersionSource.LOCAL;
        }
        if (this.getRemoteVersion().getUpdatedTime().after(this.getLocalVersion().getUpdatedTime())) {
            return VersionSource.REMOTE;
        }
        return VersionSource.LOCAL;
    }

    public boolean isInstalled() {
        return this.isInstalled;
    }

    public boolean isOnRemote() {
        return this.remoteVersion != null;
    }

    public boolean isUpToDate() {
        return this.isUpToDate;
    }

    public String toString() {
        return "VersionSyncInfo{localVersion=" + this.localVersion + ", remoteVersion=" + this.remoteVersion + ", isInstalled=" + this.isInstalled + ", isUpToDate=" + this.isUpToDate + '}';
    }

    @d
    public static enum VersionSource {
        REMOTE,
        LOCAL;

    }
}

