/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.launcher.updater.download;

import com.mojang.launcher.updater.download.Downloadable;
import com.teamextreme.fyre.a;
import com.teamextreme.fyre.b;
import com.teamextreme.fyre.d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.apache.commons.lang3.time.StopWatch;

@d
public class DownloadJob {
    private static final a LOGGER = b.ad();
    private static final int MAX_ATTEMPTS_PER_FILE = 5;
    private static final int ASSUMED_AVERAGE_FILE_SIZE = 0x500000;
    private final Queue<Downloadable> remainingFiles = new ConcurrentLinkedQueue<Downloadable>();
    private final List<Downloadable> allFiles = Collections.synchronizedList(new ArrayList());
    private final List<Downloadable> failures = Collections.synchronizedList(new ArrayList());
    private final List<Downloadable> successful = Collections.synchronizedList(new ArrayList());
    private final com.mojang.launcher.a.a listener$3b98a42a;
    private final String name;
    private final boolean ignoreFailures;
    private final AtomicInteger remainingThreads = new AtomicInteger();
    private final StopWatch stopWatch = new StopWatch();
    private boolean started;

    public DownloadJob(String string, boolean bl, com.mojang.launcher.a.a a2, Collection<Downloadable> collection) {
        this.name = string;
        this.ignoreFailures = bl;
        this.listener$3b98a42a = a2;
        if (collection != null) {
            this.addDownloadables(collection);
        }
    }

    public DownloadJob(String string, boolean bl, com.mojang.launcher.a.a a2) {
        this(string, bl, a2, null);
    }

    public void addDownloadables(Collection<Downloadable> object) {
        if (this.started) {
            throw new IllegalStateException("Cannot add to download job that has already started");
        }
        this.allFiles.addAll((Collection<Downloadable>)object);
        this.remainingFiles.addAll((Collection<Downloadable>)object);
        Iterator<Downloadable> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((Downloadable)object).getExpectedSize() == 0L) {
                ((Downloadable)object).getMonitor().a(0x500000L);
            } else {
                ((Downloadable)object).getMonitor().a(((Downloadable)object).getExpectedSize());
            }
            ((Downloadable)object).getMonitor().c(this);
        }
    }

    public void addDownloadables(Downloadable ... object) {
        if (this.started) {
            throw new IllegalStateException("Cannot add to download job that has already started");
        }
        Downloadable[] downloadableArray = object;
        int n = ((Downloadable[])object).length;
        int n2 = 0;
        while (n2 < n) {
            object = downloadableArray[n2];
            this.allFiles.add((Downloadable)object);
            this.remainingFiles.add((Downloadable)object);
            if (((Downloadable)object).getExpectedSize() == 0L) {
                ((Downloadable)object).getMonitor().a(0x500000L);
            } else {
                ((Downloadable)object).getMonitor().a(((Downloadable)object).getExpectedSize());
            }
            ((Downloadable)object).getMonitor().c(this);
            ++n2;
        }
    }

    public void startDownloading(ThreadPoolExecutor threadPoolExecutor) {
        if (this.started) {
            throw new IllegalStateException("Cannot start download job that has already started");
        }
        this.started = true;
        this.stopWatch.start();
        if (this.allFiles.isEmpty()) {
            LOGGER.a("Download job '%s' skipped as there are no files to download", this.name);
            this.listener$3b98a42a.b(this);
            return;
        }
        int n = threadPoolExecutor.getMaximumPoolSize();
        this.remainingThreads.set(n);
        LOGGER.a("Download job '%s' started (%s threads, %s files)", this.name, n, this.allFiles.size());
        int n2 = 0;
        while (n2 < n) {
            threadPoolExecutor.submit(new Runnable(this){
                private /* synthetic */ DownloadJob T;
                {
                    this.T = downloadJob;
                }

                @Override
                public final void run() {
                    this.T.popAndDownload();
                }
            });
            ++n2;
        }
    }

    private void popAndDownload() {
        Downloadable downloadable;
        while ((downloadable = this.remainingFiles.poll()) != null) {
            if (downloadable.getStartTime() == 0L) {
                downloadable.setStartTime(System.currentTimeMillis());
            }
            if (downloadable.getNumAttempts() > 5) {
                if (!this.ignoreFailures) {
                    this.failures.add(downloadable);
                }
                LOGGER.a(Level.SEVERE, "Gave up trying to download %s for job '%s'", downloadable.getUrl(), this.name);
                continue;
            }
            try {
                LOGGER.a("Attempting to download %s for job '%s'... (try %s)", downloadable.getTarget(), this.name, downloadable.getNumAttempts());
                String string = downloadable.download();
                this.successful.add(downloadable);
                downloadable.setEndTime(System.currentTimeMillis());
                downloadable.getMonitor().setCurrent(downloadable.getMonitor().p);
                LOGGER.a("Finished downloading %s for job '%s': %s", downloadable.getTarget(), this.name, string);
            }
            catch (Throwable throwable) {
                LOGGER.a(Level.WARNING, throwable, "Couldn't download %s for job '%s'", downloadable.getUrl(), this.name);
                downloadable.getMonitor().setCurrent(downloadable.getMonitor().p);
                this.remainingFiles.add(downloadable);
            }
        }
        if (this.remainingThreads.decrementAndGet() <= 0) {
            this.listener$3b98a42a.b(this);
        }
    }

    public boolean shouldIgnoreFailures() {
        return this.ignoreFailures;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isComplete() {
        return this.started && this.remainingFiles.isEmpty() && this.remainingThreads.get() == 0;
    }

    public int getFailures() {
        return this.failures.size();
    }

    public int getSuccessful() {
        return this.successful.size();
    }

    public String getName() {
        return this.name;
    }

    public void updateProgress() {
        this.listener$3b98a42a.x();
    }

    public List<Downloadable> getAllFiles() {
        return this.allFiles;
    }

    public StopWatch getStopWatch() {
        return this.stopWatch;
    }
}

