/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.launcher.updater.download;

import com.mojang.launcher.updater.download.e;
import com.teamextreme.fyre.a;
import com.teamextreme.fyre.b;
import com.teamextreme.fyre.d;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@d
public abstract class Downloadable {
    private static final a LOGGER = b.ad();
    private final URL url;
    private final File target;
    private final boolean forceDownload;
    private final Proxy proxy;
    private final e monitor;
    private long startTime;
    public int numAttempts;
    private long expectedSize;
    private long endTime;

    public Downloadable(Proxy proxy, URL uRL, File file, boolean bl) {
        this.proxy = proxy;
        this.url = uRL;
        this.target = file;
        this.forceDownload = bl;
        this.monitor = new e();
    }

    public e getMonitor() {
        return this.monitor;
    }

    public long getExpectedSize() {
        return this.expectedSize;
    }

    public void setExpectedSize(long l) {
        this.expectedSize = l;
    }

    public static String getDigest(File object, String string, int n) {
        DigestInputStream digestInputStream = null;
        try {
            try {
                digestInputStream = new DigestInputStream(new FileInputStream((File)object), MessageDigest.getInstance(string));
                object = new byte[65536];
                while (digestInputStream.read((byte[])object) > 0) {
                }
            }
            catch (Exception exception) {
                Downloadable.closeSilently(digestInputStream);
                return null;
            }
        }
        catch (Throwable throwable) {
            Downloadable.closeSilently(digestInputStream);
            throw throwable;
        }
        Downloadable.closeSilently(digestInputStream);
        return String.format("%1$0" + n + "x", new BigInteger(1, digestInputStream.getMessageDigest().digest()));
    }

    public abstract String download() throws IOException;

    public void updateExpectedSize(HttpURLConnection httpURLConnection) {
        if (this.expectedSize == 0L) {
            this.monitor.a(httpURLConnection.getContentLength());
            this.setExpectedSize(httpURLConnection.getContentLength());
            return;
        }
        this.monitor.a(this.expectedSize);
    }

    public HttpURLConnection makeConnection(URL object) throws IOException {
        object = (HttpURLConnection)((URL)object).openConnection(this.proxy);
        ((URLConnection)object).setUseCaches(false);
        ((URLConnection)object).setDefaultUseCaches(false);
        ((URLConnection)object).setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
        ((URLConnection)object).setRequestProperty("Expires", "0");
        ((URLConnection)object).setRequestProperty("Pragma", "no-cache");
        ((URLConnection)object).setConnectTimeout(5000);
        ((URLConnection)object).setReadTimeout(30000);
        return object;
    }

    public URL getUrl() {
        return this.url;
    }

    public File getTarget() {
        return this.target;
    }

    public boolean shouldIgnoreLocal() {
        return this.forceDownload;
    }

    public int getNumAttempts() {
        return this.numAttempts;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static String copyAndDigest(InputStream inputStream, OutputStream outputStream, String string, int n) throws IOException {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Downloadable.closeSilently(inputStream);
            Downloadable.closeSilently(outputStream);
            throw new RuntimeException("Missing Digest." + string, noSuchAlgorithmException);
        }
        byte[] byArray = new byte[65536];
        try {
            int n2 = inputStream.read(byArray);
            while (n2 > 0) {
                messageDigest.update(byArray, 0, n2);
                outputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
        }
        finally {
            Downloadable.closeSilently(inputStream);
            Downloadable.closeSilently(outputStream);
        }
        return String.format("%1$0" + n + "x", new BigInteger(1, messageDigest.digest()));
    }

    public void ensureFileWritable(File file) {
        if (file.getParentFile() != null && !file.getParentFile().isDirectory()) {
            LOGGER.log("Making directory " + file.getParentFile());
            if (!file.getParentFile().mkdirs() && !file.getParentFile().isDirectory()) {
                throw new RuntimeException("Could not create directory " + file.getParentFile());
            }
        }
        if (file.isFile() && !file.canWrite()) {
            throw new RuntimeException("Do not have write permissions for " + file + " - aborting!");
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public String getStatus() {
        return "Downloading " + this.getTarget().getName();
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long l) {
        this.endTime = l;
    }
}

