/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.launcher.updater.download.assets;

import com.mojang.launcher.updater.download.Downloadable;
import com.mojang.launcher.updater.download.assets.AssetIndex;
import com.mojang.launcher.updater.download.d;
import com.teamextreme.fyre.a;
import com.teamextreme.fyre.b;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public final class AssetDownloadable
extends Downloadable {
    private static final a LOGGER = b.ad();
    private final String name;
    private final AssetIndex.AssetObject V;
    private final String W;
    private final File X;
    private Status Y = Status.DOWNLOADING;

    public AssetDownloadable(Proxy proxy, String string, AssetIndex.AssetObject assetObject, String string2, File file) throws MalformedURLException {
        super(proxy, new URL(String.valueOf(string2) + AssetDownloadable.f(assetObject.getHash())), new File(file, AssetDownloadable.f(assetObject.getHash())), false);
        this.name = string;
        this.V = assetObject;
        this.W = string2;
        this.X = file;
    }

    private static String f(String string) {
        return String.valueOf(string.substring(0, 2)) + "/" + string;
    }

    @Override
    public final String download() throws IOException {
        Object object;
        this.Y = Status.DOWNLOADING;
        ++this.numAttempts;
        File file = this.getTarget();
        File file2 = this.V.hasCompressedAlternative() ? new File(this.X, AssetDownloadable.f(this.V.getCompressedHash())) : null;
        URL uRL = this.getUrl();
        Object object2 = this.V.hasCompressedAlternative() ? new URL(String.valueOf(this.W) + AssetDownloadable.f(this.V.getCompressedHash())) : null;
        this.ensureFileWritable(file);
        if (file2 != null) {
            this.ensureFileWritable(file2);
        }
        if (file.isFile()) {
            if (FileUtils.sizeOf(file) == this.V.getSize()) {
                return "Have local file and it's the same size; assuming it's okay!";
            }
            LOGGER.a(Level.WARNING, "Had local file but it was the wrong size... had %s but expected %s", FileUtils.sizeOf(file), this.V.getSize());
            FileUtils.deleteQuietly(file);
            this.Y = Status.DOWNLOADING;
        }
        if (file2 != null && file2.isFile()) {
            object = AssetDownloadable.getDigest(file2, "SHA", 40);
            if (((String)object).equalsIgnoreCase(this.V.getCompressedHash())) {
                return this.a(file, file2);
            }
            LOGGER.a(Level.WARNING, "Had local compressed but it was the wrong hash... expected %s but had %s", this.V.getCompressedHash(), object);
            FileUtils.deleteQuietly(file2);
        }
        if (object2 != null && file2 != null) {
            object = this.makeConnection((URL)object2);
            int n = ((HttpURLConnection)object).getResponseCode();
            if (n / 100 == 2) {
                this.updateExpectedSize((HttpURLConnection)object);
                Object object3 = new d(((URLConnection)object).getInputStream(), this.getMonitor());
                object2 = new FileOutputStream(file2);
                object3 = AssetDownloadable.copyAndDigest((InputStream)object3, (OutputStream)object2, "SHA", 40);
                if (((String)object3).equalsIgnoreCase(this.V.getCompressedHash())) {
                    return this.a(file, file2);
                }
                FileUtils.deleteQuietly(file2);
                throw new RuntimeException(String.format("Hash did not match downloaded compressed asset (Expected %s, downloaded %s)", this.V.getCompressedHash(), object3));
            }
            throw new RuntimeException("Server responded with " + n);
        }
        object = this.makeConnection(uRL);
        int n = ((HttpURLConnection)object).getResponseCode();
        if (n / 100 == 2) {
            this.updateExpectedSize((HttpURLConnection)object);
            Object object4 = new d(((URLConnection)object).getInputStream(), this.getMonitor());
            object2 = new FileOutputStream(file);
            object4 = AssetDownloadable.copyAndDigest((InputStream)object4, (OutputStream)object2, "SHA", 40);
            if (((String)object4).equalsIgnoreCase(this.V.getHash())) {
                return "Downloaded asset and hash matched successfully";
            }
            FileUtils.deleteQuietly(file);
            throw new RuntimeException(String.format("Hash did not match downloaded asset (Expected %s, downloaded %s)", this.V.getHash(), object4));
        }
        throw new RuntimeException("Server responded with " + n);
    }

    @Override
    public final String getStatus() {
        return String.valueOf(this.Y.name) + " " + this.name;
    }

    private String a(File file, File object) throws IOException {
        String string;
        this.Y = Status.EXTRACTING;
        FileOutputStream fileOutputStream = FileUtils.openOutputStream(file);
        object = new GZIPInputStream(FileUtils.openInputStream((File)object));
        try {
            string = AssetDownloadable.copyAndDigest((InputStream)object, fileOutputStream, "SHA", 40);
        }
        finally {
            IOUtils.closeQuietly(fileOutputStream);
            IOUtils.closeQuietly((InputStream)object);
        }
        this.Y = Status.DOWNLOADING;
        if (string.equalsIgnoreCase(this.V.getHash())) {
            return "Had local compressed asset, unpacked successfully and hash matched";
        }
        FileUtils.deleteQuietly(file);
        throw new RuntimeException("Had local compressed asset but unpacked hash did not match (expected " + this.V.getHash() + " but had " + string + ")");
    }

    @com.teamextreme.fyre.d
    static enum Status {
        DOWNLOADING("Downloading"),
        EXTRACTING("Extracting");

        private final String name;

        private Status(String string2) {
            this.name = string2;
        }
    }
}

