/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.launcher.updater.download.assets;

import com.google.common.collect.Maps;
import com.teamextreme.fyre.d;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@d
public class AssetIndex {
    public static final String DEFAULT_ASSET_NAME = "legacy";
    private Map<String, AssetObject> objects = new LinkedHashMap<String, AssetObject>();
    private boolean virtual;

    public Map<String, AssetObject> getFileMap() {
        return this.objects;
    }

    public Map<AssetObject, String> getUniqueObjects() {
        HashMap<AssetObject, String> hashMap = Maps.newHashMap();
        for (Map.Entry<String, AssetObject> entry : this.objects.entrySet()) {
            hashMap.put(entry.getValue(), entry.getKey());
        }
        return hashMap;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    @d
    public class AssetObject {
        private String hash;
        private long size;
        private boolean reconstruct;
        private String compressedHash;
        private long compressedSize;

        public String getHash() {
            return this.hash;
        }

        public long getSize() {
            return this.size;
        }

        public boolean shouldReconstruct() {
            return this.reconstruct;
        }

        public boolean hasCompressedAlternative() {
            return this.compressedHash != null;
        }

        public String getCompressedHash() {
            return this.compressedHash;
        }

        public long getCompressedSize() {
            return this.compressedSize;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            object = (AssetObject)object;
            if (this.compressedSize != ((AssetObject)object).compressedSize) {
                return false;
            }
            if (this.reconstruct != ((AssetObject)object).reconstruct) {
                return false;
            }
            if (this.size != ((AssetObject)object).size) {
                return false;
            }
            if (this.compressedHash != null ? !this.compressedHash.equals(((AssetObject)object).compressedHash) : ((AssetObject)object).compressedHash != null) {
                return false;
            }
            return !(this.hash != null ? !this.hash.equals(((AssetObject)object).hash) : ((AssetObject)object).hash != null);
        }

        public int hashCode() {
            return ((((this.hash != null ? this.hash.hashCode() : 0) * 31 + (int)(this.size ^ this.size >>> 32)) * 31 + (this.reconstruct ? 1 : 0)) * 31 + (this.compressedHash != null ? this.compressedHash.hashCode() : 0)) * 31 + (int)(this.compressedSize ^ this.compressedSize >>> 32);
        }
    }
}

