/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.launcher.updater.download;

import com.mojang.launcher.updater.download.Downloadable;
import com.mojang.launcher.updater.download.d;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;

public final class c
extends Downloadable {
    public c(Proxy proxy, URL uRL, File file) {
        super(proxy, uRL, file, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final String download() throws IOException {
        ++this.numAttempts;
        this.ensureFileWritable(this.getTarget());
        try {
            Object object = this.makeConnection(this.getUrl());
            int n = ((HttpURLConnection)object).getResponseCode();
            if (n == 304) {
                return "Used own copy as it matched etag";
            }
            if (n / 100 == 2) {
                this.updateExpectedSize((HttpURLConnection)object);
                Object object2 = new d(((URLConnection)object).getInputStream(), this.getMonitor());
                FileOutputStream fileOutputStream = new FileOutputStream(this.getTarget());
                object2 = c.copyAndDigest((InputStream)object2, fileOutputStream, "MD5", 32);
                object = ((URLConnection)object).getHeaderField("ETag");
                if (object == null) {
                    object = "-";
                } else if (((String)object).startsWith("\"") && ((String)object).endsWith("\"")) {
                    object = ((String)object).substring(1, ((String)object).length() - 1);
                }
                if (((String)object).contains("-")) {
                    return "Didn't have etag so assuming our copy is good";
                }
                if (((String)object).equalsIgnoreCase((String)object2)) {
                    return "Downloaded successfully and etag matched";
                }
                throw new RuntimeException(String.format("E-tag did not match downloaded MD5 (ETag was %s, downloaded %s)", object, object2));
            }
            if (this.getTarget().isFile()) {
                return "Couldn't connect to server (responded with " + n + ") but have local file, assuming it's good";
            }
            throw new RuntimeException("Server responded with " + n);
        }
        catch (IOException iOException) {
            if (this.getTarget().isFile()) {
                return "Couldn't connect to server (" + iOException.getClass().getSimpleName() + ": '" + iOException.getMessage() + "') but have local file, assuming it's good";
            }
            throw iOException;
        }
    }

    @Override
    protected final HttpURLConnection makeConnection(URL object) throws IOException {
        object = super.makeConnection((URL)object);
        if (!this.shouldIgnoreLocal() && this.getTarget().isFile()) {
            ((URLConnection)object).setRequestProperty("If-None-Match", c.getDigest(this.getTarget(), "MD5", 32));
        }
        return object;
    }

    private static String e(String string) {
        if (string == null) {
            string = "-";
        } else if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }
}

