/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.launcher.versions;

import com.mojang.launcher.d;
import java.util.regex.Pattern;

@com.teamextreme.fyre.d
public class CompatibilityRule {
    private Action action = Action.ALLOW;
    private OSRestriction os;

    public CompatibilityRule() {
    }

    public CompatibilityRule(CompatibilityRule compatibilityRule) {
        this.action = compatibilityRule.action;
        if (compatibilityRule.os != null) {
            this.os = new OSRestriction(compatibilityRule.os);
        }
    }

    public Action getAppliedAction() {
        if (this.os != null && !this.os.isCurrentOperatingSystem()) {
            return null;
        }
        return this.action;
    }

    public Action getAction() {
        return this.action;
    }

    public OSRestriction getOs() {
        return this.os;
    }

    public String toString() {
        return "Rule{action=" + (Object)((Object)this.action) + ", os=" + this.os + '}';
    }

    @com.teamextreme.fyre.d
    public static enum Action {
        ALLOW,
        DISALLOW;

    }

    @com.teamextreme.fyre.d
    public class OSRestriction {
        private d name;
        private String version;

        public OSRestriction() {
        }

        public d getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public OSRestriction(OSRestriction oSRestriction) {
            this.name = oSRestriction.name;
            this.version = oSRestriction.version;
        }

        public boolean isCurrentOperatingSystem() {
            if (this.name != null && this.name != d.k()) {
                return false;
            }
            if (this.version != null) {
                try {
                    if (!Pattern.compile(this.version).matcher(System.getProperty("os.version")).matches()) {
                        return false;
                    }
                }
                catch (Throwable throwable) {}
            }
            return true;
        }

        public String toString() {
            return "OSRestriction{name=" + (Object)((Object)this.name) + ", version='" + this.version + '\'' + '}';
        }
    }
}

