/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.Agent;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.launcher.d;
import com.mojang.launcher.updater.DateTypeAdapter;
import com.mojang.launcher.updater.VersionSyncInfo;
import com.mojang.launcher.updater.download.assets.AssetIndex;
import com.mojang.launcher.versions.CompleteVersion;
import com.teamextreme.fyre.Options;
import com.teamextreme.fyre.d.f;
import com.teamextreme.fyre.e;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.minecraft.launcher.MinecraftUserInterface;
import net.minecraft.launcher.a.c;
import net.minecraft.launcher.b.b;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.profile.ProfileManager$RawProfileList;
import net.minecraft.launcher.updater.CompleteMinecraftVersion;
import net.minecraft.launcher.updater.Library;
import net.minecraft.launcher.updater.LocalVersionList;
import net.minecraft.launcher.updater.RemoteVersionList;
import net.minecraft.launcher.updater.a;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class Launcher {
    private final Gson gson = new Gson();
    public UUID clientToken = UUID.randomUUID();
    public static final com.teamextreme.fyre.a LOGGER = com.teamextreme.fyre.b.ad();
    public final com.mojang.launcher.b bw;
    public final MinecraftUserInterface bx;
    public final com.teamextreme.fyre.c by;
    private static final List<String> aa;
    private static Launcher bz;
    public final Options bA;
    public final f bB;
    public boolean loaded = false;

    static {
        new ArrayList();
    }

    public Launcher(JFrame object, File file, Proxy proxy, PasswordAuthentication passwordAuthentication, String[] stringArray) {
        bz = this;
        net.minecraft.bootstrap.b.aI();
        JFrame jFrame = object;
        object = this;
        this.bx = new net.minecraft.launcher.b((Launcher)object, jFrame);
        LOGGER.a("Launcher %s started on %s...", "3.4", d.k().name);
        LOGGER.log("Current time is " + DateFormat.getDateTimeInstance(2, 2, Locale.US).format(new Date()));
        if (!d.k().isSupported()) {
            LOGGER.log(Level.WARNING, "This operating system is unknown or unsupported, we cannot guarantee that the game will launch.");
        }
        LOGGER.a("System.getProperty('os.name') == '%s'", System.getProperty("os.name"));
        LOGGER.a("System.getProperty('os.version') == '%s'", System.getProperty("os.version"));
        LOGGER.a("System.getProperty('os.arch') == '%s'", System.getProperty("os.arch"));
        LOGGER.a("System.getProperty('java.version') == '%s'", System.getProperty("java.version"));
        LOGGER.a("System.getProperty('java.vendor') == '%s'", System.getProperty("java.vendor"));
        LOGGER.a("System.getProperty('sun.arch.data.model') == '%s'", System.getProperty("sun.arch.data.model"));
        this.bw = new com.mojang.launcher.b(this.bx, file, proxy, passwordAuthentication, new a(new LocalVersionList(file), new RemoteVersionList("https://s3.amazonaws.com/Minecraft.Download/", proxy)), Agent.MINECRAFT, new net.minecraft.launcher.a.a(this, stringArray), c.bo());
        this.bA = Options.load();
        this.by = new com.teamextreme.fyre.c(this);
        this.bB = new f(this);
        try {
            SwingUtilities.invokeAndWait(new Runnable(this){
                private /* synthetic */ Launcher bC;
                {
                    this.bC = launcher;
                }

                @Override
                public final void run() {
                    net.minecraft.launcher.b b2 = (net.minecraft.launcher.b)this.bC.bx;
                    b2.bF.getContentPane().removeAll();
                    b2.bF.setTitle("TeamExtreme Minecraft Launcher 3.4");
                    b2.bF.setPreferredSize(new Dimension(900, 580));
                    b2.bF.setDefaultCloseOperation(2);
                    b2.bF.addWindowListener(new WindowAdapter(b2){
                        private /* synthetic */ net.minecraft.launcher.b B;
                        {
                            this.B = b2;
                        }

                        public final void windowClosing(WindowEvent windowEvent) {
                            Launcher.bc().bA.save();
                            net.minecraft.launcher.b.b(this.B).setVisible(false);
                            net.minecraft.launcher.b.b(this.B).dispose();
                            net.minecraft.launcher.b.c((net.minecraft.launcher.b)this.B).bw.g.getExecutorService().shutdown();
                        }
                    });
                    try {
                        b2.bF.setIconImage(e.af());
                    }
                    catch (IOException iOException) {}
                    b2.bE = new b(b2.bD);
                    b2.bF.add(b2.bE);
                    b2.bF.pack();
                    com.teamextreme.fyre.b.start();
                }
            });
        }
        catch (Exception exception) {}
        object = this;
        ((Launcher)object).bw.g.getExecutorService().submit(new Runnable((Launcher)object){
            private /* synthetic */ Launcher bC;
            {
                this.bC = launcher;
            }

            @Override
            public final void run() {
                try {
                    this.bC.bw.g.refreshVersions();
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.SEVERE, "Unexpected exception refreshing version list", throwable);
                }
                try {
                    com.teamextreme.fyre.c c2 = this.bC.by;
                    c2.profiles.clear();
                    c2.selectedProfile = null;
                    if (c2.G.isFile()) {
                        Object object = c2.F.parse(FileUtils.readFileToString(c2.G)).getAsJsonObject();
                        if (((JsonObject)object).has("clientToken")) {
                            c2.launcher.clientToken = c2.gson.fromJson(((JsonObject)object).get("clientToken"), UUID.class);
                        }
                        object = c2.gson.fromJson((JsonElement)object, ProfileManager$RawProfileList.class);
                        c2.profiles.putAll(((ProfileManager$RawProfileList)object).profiles);
                        c2.selectedProfile = ((ProfileManager$RawProfileList)object).selectedProfile;
                        c2.I = ((ProfileManager$RawProfileList)object).authenticationDatabase;
                    }
                    c2.O();
                    LOGGER.a("Loaded %s profile(s); selected '%s'", ((Launcher)this.bC).by.profiles.size(), this.bC.by.P().getName());
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.SEVERE, "Unexpected exception refreshing profile list", throwable);
                }
                this.bC.loaded = true;
                this.bC.aS();
            }
        });
    }

    private void aQ() {
        this.bw.g.getExecutorService().submit(new /* invalid duplicate definition of identical inner class */);
    }

    private MinecraftUserInterface a(JFrame jFrame) {
        return new net.minecraft.launcher.b(this, jFrame);
    }

    private com.mojang.launcher.b U() {
        return this.bw;
    }

    private MinecraftUserInterface aR() {
        return this.bx;
    }

    public final void aS() {
        Profile profile = this.by.P();
        UserAuthentication userAuthentication = null;
        if (this.bA.shouldStayLoggedIn()) {
            if (!this.bA.isPremiumMode()) {
                userAuthentication = new com.teamextreme.fyre.a.d();
                userAuthentication.setUsername(this.bA.getLastLogin());
                net.minecraft.launcher.b.b.a.b.a(userAuthentication);
            } else {
                userAuthentication = this.by.I.getByUUID(profile.getPlayerUUID());
            }
        }
        if (userAuthentication == null) {
            this.bx.n();
        } else if (!userAuthentication.isLoggedIn()) {
            if (userAuthentication.canLogIn() || userAuthentication instanceof com.teamextreme.fyre.a.d) {
                try {
                    userAuthentication.logIn();
                    try {
                        this.by.M();
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.SEVERE, "Couldn't save profiles after refreshing auth!", iOException);
                    }
                    this.by.O();
                }
                catch (AuthenticationException authenticationException) {
                    LOGGER.log(Level.SEVERE, "Exception whilst logging into profile", authenticationException);
                    this.bx.n();
                }
            } else {
                this.bx.n();
            }
        } else if (!userAuthentication.canPlayOnline()) {
            try {
                LOGGER.log("Refreshing auth...");
                userAuthentication.logIn();
                try {
                    this.by.M();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.SEVERE, "Couldn't save profiles after refreshing auth!", iOException);
                }
                this.by.O();
            }
            catch (InvalidCredentialsException invalidCredentialsException) {
                this.bx.n();
            }
            catch (AuthenticationException authenticationException) {
                LOGGER.log(Level.SEVERE, "Exception whilst logging into profile", authenticationException);
                this.bx.n();
            }
        }
        this.bx.setVisible(true);
    }

    private UUID aT() {
        return this.clientToken;
    }

    private void a(UUID uUID) {
        this.clientToken = uUID;
    }

    /*
     * WARNING - void declaration
     */
    private void aU() throws IOException {
        Object object;
        File file = new File(this.bw.e, "assets");
        File file2 = new File(file, "indexes");
        file = new File(file, "objects");
        HashSet<String> hashSet = Sets.newHashSet();
        if (!file.isDirectory()) {
            return;
        }
        for (VersionSyncInfo n2 : this.bw.g.getInstalledVersions()) {
            if (!(n2.getLocalVersion() instanceof CompleteMinecraftVersion)) continue;
            CompleteMinecraftVersion completeMinecraftVersion = (CompleteMinecraftVersion)n2.getLocalVersion();
            String string = completeMinecraftVersion.getAssets() == null ? "legacy" : completeMinecraftVersion.getAssets();
            object = new File(file2, String.valueOf(string) + ".json");
            for (AssetIndex.AssetObject assetObject : this.gson.fromJson(FileUtils.readFileToString((File)object, Charsets.UTF_8), AssetIndex.class).getUniqueObjects().keySet()) {
                hashSet.add(assetObject.getHash().toLowerCase());
            }
        }
        File[] fileArray = file.listFiles(DirectoryFileFilter.DIRECTORY);
        if (fileArray != null) {
            void var4_11;
            object = fileArray;
            int n = fileArray.length;
            boolean bl = false;
            while (var4_11 < n) {
                File[] fileArray2 = object[var4_11].listFiles(FileFileFilter.FILE);
                if (fileArray2 != null) {
                    File[] fileArray3 = fileArray2;
                    int n3 = fileArray2.length;
                    int n2 = 0;
                    while (n2 < n3) {
                        File file3 = fileArray3[n2];
                        if (!hashSet.contains(file3.getName().toLowerCase())) {
                            LOGGER.a("Cleaning up orphaned object %s", file3.getName());
                            FileUtils.deleteQuietly(file3);
                        }
                        ++n2;
                    }
                }
                ++var4_11;
            }
        }
        Launcher.e(file);
    }

    private void aV() throws IOException {
        File file = new File(this.bw.e, "libraries");
        HashSet<File> hashSet = Sets.newHashSet();
        if (!file.isDirectory()) {
            return;
        }
        for (VersionSyncInfo versionSyncInfo : this.bw.g.getInstalledVersions()) {
            if (!(versionSyncInfo.getLocalVersion() instanceof CompleteMinecraftVersion)) continue;
            for (Library library : ((CompleteMinecraftVersion)versionSyncInfo.getLocalVersion()).getRelevantLibraries()) {
                String string = null;
                if (library.getNatives() != null) {
                    String string2 = library.getNatives().get((Object)d.k());
                    if (string2 != null) {
                        string = library.getArtifactPath(string2);
                    }
                } else {
                    string = library.getArtifactPath();
                }
                if (string == null) continue;
                hashSet.add(new File(file, string));
                hashSet.add(new File(file, String.valueOf(string) + ".sha"));
            }
        }
        Collection<File> collection = FileUtils.listFiles(file, TrueFileFilter.TRUE, TrueFileFilter.TRUE);
        if (collection != null) {
            for (File file2 : collection) {
                if (hashSet.contains(file2)) continue;
                LOGGER.a("Cleaning up orphaned library %s", file2);
                FileUtils.deleteQuietly(file2);
            }
        }
        Launcher.e(file);
    }

    private void aW() {
        File file = new File(this.bw.e, "assets");
        if (!(file = new File(file, "skins")).isDirectory()) {
            return;
        }
        Collection<File> collection2 = FileUtils.listFiles(file, new AgeFileFilter(System.currentTimeMillis() - 604800000L), TrueFileFilter.TRUE);
        if (collection2 != null) {
            for (File file2 : collection2) {
                LOGGER.a("Cleaning up old skin %s", file2.getName());
                FileUtils.deleteQuietly(file2);
            }
        }
        Launcher.e(file);
    }

    private void aX() throws IOException {
        File file = new File(this.bw.e, "assets");
        file = new File(file, "virtual");
        DateTypeAdapter dateTypeAdapter = new DateTypeAdapter();
        Comparable<Calendar> comparable = Calendar.getInstance();
        ((Calendar)comparable).add(5, -5);
        comparable = ((Calendar)comparable).getTime();
        if (!file.isDirectory()) {
            return;
        }
        Object object = file.listFiles(DirectoryFileFilter.DIRECTORY);
        if (object != null) {
            File[] fileArray = object;
            int n = ((File[])object).length;
            int n2 = 0;
            while (n2 < n) {
                object = fileArray[n2];
                Comparable<File> comparable2 = new File((File)object, ".lastused");
                if (comparable2.isFile()) {
                    if (((Date)comparable).after((Date)(comparable2 = dateTypeAdapter.deserializeToDate(FileUtils.readFileToString(comparable2))))) {
                        LOGGER.a("Cleaning up old virtual directory %s", object);
                        FileUtils.deleteQuietly((File)object);
                    }
                } else {
                    LOGGER.a("Cleaning up strange virtual directory %s", object);
                    FileUtils.deleteQuietly((File)object);
                }
                ++n2;
            }
        }
        Launcher.e(file);
    }

    private void aY() {
        File[] fileArray = new File(this.bw.e, "versions/");
        LOGGER.log("Looking for old natives & assets to clean up...");
        AgeFileFilter ageFileFilter = new AgeFileFilter(System.currentTimeMillis() - 3600000L);
        if (!fileArray.isDirectory()) {
            return;
        }
        if ((fileArray = fileArray.listFiles(DirectoryFileFilter.DIRECTORY)) != null) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File[] fileArray3 = fileArray2[n2];
                if ((fileArray3 = fileArray3.listFiles(FileFilterUtils.and(new PrefixFileFilter(String.valueOf(fileArray3.getName()) + "-natives-"), ageFileFilter))) != null) {
                    File[] fileArray4 = fileArray3;
                    int n3 = fileArray3.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        FileUtils.deleteQuietly(fileArray4[n4]);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private void aZ() {
        LOGGER.log("Looking for orphaned versions to clean up...");
        HashSet<String> hashSet = Sets.newHashSet();
        for (Profile object2 : this.by.profiles.values()) {
            String string = object2.getLastVersionId();
            Object object = null;
            if (string != null) {
                object = this.bw.g.getVersionSyncInfo(string);
            }
            if (object == null || ((VersionSyncInfo)object).getLatestVersion() == null) {
                object = this.bw.g.getVersions(object2.getVersionFilter()).get(0);
            }
            if (object == null) continue;
            hashSet.add(((VersionSyncInfo)object).getLatestVersion().getId());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        Date date = calendar.getTime();
        for (VersionSyncInfo versionSyncInfo : this.bw.g.getInstalledVersions()) {
            CompleteVersion completeVersion;
            if (!(versionSyncInfo.getLocalVersion() instanceof CompleteMinecraftVersion) || hashSet.contains((completeVersion = (CompleteVersion)versionSyncInfo.getLocalVersion()).getId()) || completeVersion.getType() != net.minecraft.launcher.a.b.bU) continue;
            if (versionSyncInfo.isOnRemote()) {
                LOGGER.a("Deleting orphaned version %s because it's a snapshot available on remote", completeVersion.getId());
                try {
                    this.bw.g.uninstallVersion(completeVersion);
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, "Couldn't uninstall version " + completeVersion.getId(), iOException);
                }
                continue;
            }
            if (!completeVersion.getUpdatedTime().before(date)) continue;
            LOGGER.a("Deleting orphaned version %s because it's an unsupported old snapshot", completeVersion.getId());
            try {
                this.bw.g.uninstallVersion(completeVersion);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Couldn't uninstall version " + completeVersion.getId(), iOException);
            }
        }
    }

    private static Collection<File> d(File object) {
        ArrayList<File> arrayList = Lists.newArrayList();
        if ((object = ((File)object).listFiles()) != null) {
            File[] fileArray = object;
            int n = ((File[])object).length;
            int n2 = 0;
            while (n2 < n) {
                object = fileArray[n2];
                if (((File)object).isDirectory()) {
                    File[] fileArray2 = ((File)object).listFiles();
                    if (fileArray2 == null || fileArray2.length == 0) {
                        arrayList.add((File)object);
                    } else {
                        arrayList.addAll(Launcher.d((File)object));
                    }
                }
                ++n2;
            }
        }
        return arrayList;
    }

    private static void e(File file) {
        block0: while (true) {
            Object object;
            if ((object = Launcher.d(file)).isEmpty()) {
                return;
            }
            Iterator<File> iterator = object.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                object = iterator.next();
                if (!FileUtils.deleteQuietly((File)object)) break block0;
                LOGGER.a("Deleted empty directory %s", object);
            }
            break;
        }
    }

    public final void ba() throws IOException {
        Launcher launcher = this;
        LOGGER.log("Looking for orphaned versions to clean up...");
        HashSet<String> hashSet = Sets.newHashSet();
        for (Profile object2 : launcher.by.profiles.values()) {
            String string = object2.getLastVersionId();
            Object object = null;
            if (string != null) {
                object = launcher.bw.g.getVersionSyncInfo(string);
            }
            if (object == null || ((VersionSyncInfo)object).getLatestVersion() == null) {
                object = launcher.bw.g.getVersions(object2.getVersionFilter()).get(0);
            }
            if (object == null) continue;
            hashSet.add(((VersionSyncInfo)object).getLatestVersion().getId());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        Date date = calendar.getTime();
        for (VersionSyncInfo versionSyncInfo : launcher.bw.g.getInstalledVersions()) {
            CompleteVersion completeVersion;
            if (!(versionSyncInfo.getLocalVersion() instanceof CompleteMinecraftVersion) || hashSet.contains((completeVersion = (CompleteVersion)versionSyncInfo.getLocalVersion()).getId()) || completeVersion.getType() != net.minecraft.launcher.a.b.bU) continue;
            if (versionSyncInfo.isOnRemote()) {
                LOGGER.a("Deleting orphaned version %s because it's a snapshot available on remote", completeVersion.getId());
                try {
                    launcher.bw.g.uninstallVersion(completeVersion);
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, "Couldn't uninstall version " + completeVersion.getId(), iOException);
                }
                continue;
            }
            if (!completeVersion.getUpdatedTime().before(date)) continue;
            LOGGER.a("Deleting orphaned version %s because it's an unsupported old snapshot", completeVersion.getId());
            try {
                launcher.bw.g.uninstallVersion(completeVersion);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Couldn't uninstall version " + completeVersion.getId(), iOException);
            }
        }
        this.aU();
        this.aW();
        this.aY();
        this.aX();
    }

    private com.teamextreme.fyre.c bb() {
        return this.by;
    }

    public static Launcher bc() {
        return bz;
    }

    private Options bd() {
        return this.bA;
    }

    private void be() {
        f f2 = this.bB;
        f2.setLocationRelativeTo(((net.minecraft.launcher.b)f2.launcher.bx).bF);
        f2.setVisible(true);
    }
}

