/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.a;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.UserType;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import com.mojang.launcher.b;
import com.mojang.launcher.c;
import com.mojang.launcher.d;
import com.mojang.launcher.updater.DateTypeAdapter;
import com.mojang.launcher.updater.VersionSyncInfo;
import com.mojang.launcher.updater.download.Downloadable;
import com.mojang.launcher.updater.download.assets.AssetIndex;
import com.mojang.launcher.versions.ExtractRules;
import com.mojang.util.UUIDTypeAdapter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.updater.CompleteMinecraftVersion;
import net.minecraft.launcher.updater.Library;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;

public final class a
extends com.mojang.launcher.b.b.a
implements com.mojang.launcher.a.a {
    private static final String bN = "#@!@#";
    private final Gson gson = new Gson();
    private final DateTypeAdapter bO = new DateTypeAdapter();
    private final Launcher bD;
    private final String[] bP;
    private final com.mojang.launcher.b.a.d bQ = new com.mojang.launcher.b.a.d();
    private File bR;
    public net.minecraft.launcher.profile.a bS = net.minecraft.launcher.profile.a.ce;

    public a(Launcher launcher, String[] stringArray) {
        this.bD = launcher;
        this.bP = stringArray;
    }

    @Override
    protected final void a(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bR != null) {
                LOGGER.log("Deleting " + this.bR);
                if (!this.bR.isDirectory() || FileUtils.deleteQuietly(this.bR)) {
                    this.bR = null;
                } else {
                    LOGGER.log(Level.WARNING, "Couldn't delete " + this.bR + " - scheduling for deletion upon exit");
                    try {
                        FileUtils.forceDeleteOnExit(this.bR);
                    }
                    catch (Throwable throwable) {}
                }
            }
            super.a(bl);
            return;
        }
    }

    @Override
    protected final b U() {
        return this.bD.bw;
    }

    @Override
    protected final void b(VersionSyncInfo versionSyncInfo) {
        Object object = this;
        object = new File(((a)object).bD.bw.e, "assets");
        File file = new File((File)object, "objects");
        if (((File)object).isDirectory()) {
            IOFileFilter object22 = FileFilterUtils.notFileFilter(FileFilterUtils.or(FileFilterUtils.nameFileFilter("indexes"), FileFilterUtils.nameFileFilter("objects"), FileFilterUtils.nameFileFilter("virtual"), FileFilterUtils.nameFileFilter("skins")));
            for (File file2 : new TreeSet<File>(FileUtils.listFiles((File)object, TrueFileFilter.TRUE, object22))) {
                String string = Downloadable.getDigest(file2, "SHA-1", 40);
                File file3 = new File(file, String.valueOf(string.substring(0, 2)) + "/" + string);
                if (!file3.exists()) {
                    LOGGER.a("Migrated old asset %s into %s", file2, file3);
                    try {
                        FileUtils.copyFile(file2, file3);
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.SEVERE, "Couldn't migrate old asset", iOException);
                    }
                }
                FileUtils.deleteQuietly(file2);
            }
            File[] fileArray = ((File)object).listFiles();
            if (fileArray != null) {
                File[] fileArray2 = fileArray;
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file4 = fileArray2[n2];
                    if (!(file4.getName().equals("indexes") || file4.getName().equals("objects") || file4.getName().equals("virtual") || file4.getName().equals("skins"))) {
                        LOGGER.a("Cleaning up old assets directory %s after migration", file4);
                        FileUtils.deleteQuietly(file4);
                    }
                    ++n2;
                }
            }
        }
        super.b(versionSyncInfo);
    }

    @Override
    protected final void W() throws IOException {
        Object object;
        LOGGER.log("Launching game");
        Profile profile = this.bD.by.P();
        if ((CompleteMinecraftVersion)this.L == null) {
            LOGGER.log(Level.SEVERE, "Aborting launch; version is null?");
            return;
        }
        this.bR = new File(this.bD.bw.e, "versions/" + ((CompleteMinecraftVersion)this.L).getId() + "/" + ((CompleteMinecraftVersion)this.L).getId() + "-natives-" + System.nanoTime());
        if (!this.bR.isDirectory()) {
            this.bR.mkdirs();
        }
        LOGGER.log("Unpacking natives to " + this.bR);
        try {
            this.f(this.bR);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Couldn't unpack natives!", iOException);
            return;
        }
        try {
            object = this.bk();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Couldn't unpack natives!", iOException);
            return;
        }
        Object object2 = profile.getGameDir() == null ? this.bD.bw.e : profile.getGameDir();
        LOGGER.log("Launching in " + object2);
        if (!((File)object2).exists()) {
            if (!((File)object2).mkdirs()) {
                LOGGER.log(Level.SEVERE, "Aborting launch; couldn't create game directory");
            }
        } else if (!((File)object2).isDirectory()) {
            LOGGER.log(Level.SEVERE, "Aborting launch; game directory is not actually a directory");
            return;
        }
        String string = profile.getJavaPath();
        d.k();
        com.mojang.launcher.b.a.c c2 = new com.mojang.launcher.b.a.c(Objects.firstNonNull(string, d.j()));
        new com.mojang.launcher.b.a.c(Objects.firstNonNull(string, d.j())).t = new Predicate<String>(){
            private /* synthetic */ a bT;

            private static boolean m(String string) {
                return string.contains(a.bN);
            }

            @Override
            public final /* synthetic */ boolean apply(Object object) {
                return ((String)object).contains(a.bN);
            }
        };
        c2.w = object2;
        Object object3 = d.k();
        if (((Enum)object3).equals((Object)d.j)) {
            String[] stringArray = new String[2];
            String string2 = "icons/minecraft.icns";
            object3 = this;
            File file = new File(((a)object3).bD.bw.e, "assets");
            File file2 = new File(file, "indexes");
            file = new File(file, "objects");
            String string3 = ((CompleteMinecraftVersion)((a)object3).L).getAssets() == null ? "legacy" : ((CompleteMinecraftVersion)((a)object3).L).getAssets();
            file2 = new File(file2, String.valueOf(string3) + ".json");
            object3 = ((a)object3).gson.fromJson(FileUtils.readFileToString(file2, Charsets.UTF_8), AssetIndex.class).getFileMap().get(string2).getHash();
            stringArray[0] = "-Xdock:icon=" + new File(file, String.valueOf(((String)object3).substring(0, 2)) + "/" + (String)object3).getAbsolutePath();
            stringArray[1] = "-Xdock:name=Minecraft";
            c2.a(stringArray);
        } else if (((Enum)object3).equals((Object)d.i)) {
            c2.a("-XX:HeapDumpPath=MojangTricksIntelDriversForPerformance_javaw.exe_minecraft.exe.heapdump");
        }
        object3 = profile.getJavaArgs();
        if (object3 != null) {
            c2.a(((String)object3).split(" "));
        } else {
            object3 = "32".equals(System.getProperty("sun.arch.data.model")) ? "-Xmx512M" : "-Xmx1G";
            c2.a(((String)object3).split(" "));
        }
        c2.a("-Djava.library.path=" + this.bR.getAbsolutePath());
        c2.a("-cp", this.a((CompleteMinecraftVersion)this.L));
        c2.a(((CompleteMinecraftVersion)this.L).getMainClass());
        LOGGER.log("Half command: " + StringUtils.join(c2.J(), " "));
        object3 = this.bD.by.I.getByUUID(profile.getPlayerUUID());
        object3 = this.a((CompleteMinecraftVersion)this.L, profile, (File)object2, (File)object, (UserAuthentication)object3);
        if (object3 == null) {
            return;
        }
        c2.a((String[])object3);
        object = this.bD.bw.proxy;
        object2 = this.bD.bw.c;
        if (!((Proxy)object).equals(Proxy.NO_PROXY)) {
            object = (InetSocketAddress)((Proxy)object).address();
            c2.a("--proxyHost", ((InetSocketAddress)object).getHostName());
            c2.a("--proxyPort", Integer.toString(((InetSocketAddress)object).getPort()));
            if (object2 != null) {
                c2.a("--proxyUser", ((PasswordAuthentication)object2).getUserName());
                c2.a("--proxyPass", new String(((PasswordAuthentication)object2).getPassword()));
            }
        }
        c2.a(this.bP);
        if (profile.getResolution() != null) {
            c2.a("--width", String.valueOf(profile.getResolution().getWidth()));
            c2.a("--height", String.valueOf(profile.getResolution().getHeight()));
        }
        try {
            this.bQ.a(c2).a(this);
            if (this.bS != net.minecraft.launcher.profile.a.cf) {
                this.bD.bx.setVisible(false);
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Couldn't launch game", iOException);
            this.a(false);
            return;
        }
        this.bD.bA.save();
        this.bD.ba();
    }

    private CompleteMinecraftVersion bj() {
        return (CompleteMinecraftVersion)this.L;
    }

    private File l(String string) throws IOException {
        File file = new File(this.bD.bw.e, "assets");
        File file2 = new File(file, "indexes");
        file = new File(file, "objects");
        String string2 = ((CompleteMinecraftVersion)this.L).getAssets() == null ? "legacy" : ((CompleteMinecraftVersion)this.L).getAssets();
        file2 = new File(file2, String.valueOf(string2) + ".json");
        string = this.gson.fromJson(FileUtils.readFileToString(file2, Charsets.UTF_8), AssetIndex.class).getFileMap().get(string).getHash();
        return new File(file, String.valueOf(string.substring(0, 2)) + "/" + string);
    }

    private File bk() throws IOException {
        File file = new File(this.bD.bw.e, "assets");
        File object2 = new File(file, "indexes");
        File file2 = new File(file, "objects");
        String string = ((CompleteMinecraftVersion)this.L).getAssets() == null ? "legacy" : ((CompleteMinecraftVersion)this.L).getAssets();
        File file3 = new File(object2, String.valueOf(string) + ".json");
        file = new File(new File(file, "virtual"), string);
        if (!file3.isFile()) {
            LOGGER.log(Level.WARNING, "No assets index file " + file + "; can't reconstruct assets");
            return file;
        }
        AssetIndex assetIndex = this.gson.fromJson(FileUtils.readFileToString(file3, Charsets.UTF_8), AssetIndex.class);
        if (assetIndex.isVirtual()) {
            LOGGER.log("Reconstructing virtual assets folder at " + file);
            for (Map.Entry entry : assetIndex.getFileMap().entrySet()) {
                File file4 = new File(file, (String)entry.getKey());
                File file5 = new File(new File(file2, ((AssetIndex.AssetObject)entry.getValue()).getHash().substring(0, 2)), ((AssetIndex.AssetObject)entry.getValue()).getHash());
                if (file4.isFile()) continue;
                FileUtils.copyFile(file5, file4, false);
            }
            FileUtils.writeStringToFile(new File(file, ".lastused"), this.bO.serializeToString(new Date()));
        }
        return file;
    }

    private String[] a(CompleteMinecraftVersion completeMinecraftVersion, Profile profile, File file, File file2, UserAuthentication userAuthentication) {
        if (completeMinecraftVersion.getMinecraftArguments() == null) {
            LOGGER.log(Level.SEVERE, "Can't run version, missing minecraftArguments");
            this.a(false);
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StrSubstitutor strSubstitutor = new StrSubstitutor(hashMap);
        String[] stringArray = completeMinecraftVersion.getMinecraftArguments().split(" ");
        if (userAuthentication == null) {
            userAuthentication = net.minecraft.launcher.b.b.a.b.bE();
        }
        hashMap.put("auth_access_token", userAuthentication.getAuthenticatedToken());
        hashMap.put("user_properties", new GsonBuilder().registerTypeAdapter((Type)((Object)PropertyMap.class), new c()).create().toJson(userAuthentication.getUserProperties()));
        hashMap.put("user_property_map", new GsonBuilder().registerTypeAdapter((Type)((Object)PropertyMap.class), new PropertyMap.Serializer()).create().toJson(userAuthentication.getUserProperties()));
        if (userAuthentication.isLoggedIn() && userAuthentication.canPlayOnline()) {
            if (userAuthentication instanceof YggdrasilUserAuthentication) {
                hashMap.put("auth_session", String.format("token:%s:%s", userAuthentication.getAuthenticatedToken(), UUIDTypeAdapter.fromUUID(userAuthentication.getSelectedProfile().getId())));
            } else {
                hashMap.put("auth_session", userAuthentication.getAuthenticatedToken());
            }
        } else {
            hashMap.put("auth_session", "-");
        }
        if (userAuthentication.getSelectedProfile() != null) {
            hashMap.put("auth_player_name", userAuthentication.getSelectedProfile().getName());
            hashMap.put("auth_uuid", UUIDTypeAdapter.fromUUID(userAuthentication.getSelectedProfile().getId()));
            hashMap.put("user_type", userAuthentication.getUserType().getName());
        } else {
            hashMap.put("auth_player_name", "Player");
            hashMap.put("auth_uuid", new UUID(0L, 0L).toString());
            hashMap.put("user_type", UserType.LEGACY.getName());
        }
        hashMap.put("profile_name", profile.getName());
        hashMap.put("version_name", completeMinecraftVersion.getId());
        hashMap.put("game_directory", file.getAbsolutePath());
        hashMap.put("game_assets", file2.getAbsolutePath());
        hashMap.put("assets_root", new File(this.bD.bw.e, "assets").getAbsolutePath());
        hashMap.put("assets_index_name", completeMinecraftVersion.getAssets() == null ? "legacy" : completeMinecraftVersion.getAssets());
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = strSubstitutor.replace(stringArray[n]);
            ++n;
        }
        return stringArray;
    }

    private void bl() {
        File file = new File(this.bD.bw.e, "assets");
        File file2 = new File(file, "objects");
        if (!file.isDirectory()) {
            return;
        }
        IOFileFilter object2 = FileFilterUtils.notFileFilter(FileFilterUtils.or(FileFilterUtils.nameFileFilter("indexes"), FileFilterUtils.nameFileFilter("objects"), FileFilterUtils.nameFileFilter("virtual"), FileFilterUtils.nameFileFilter("skins")));
        for (File file3 : new TreeSet<File>(FileUtils.listFiles(file, TrueFileFilter.TRUE, object2))) {
            String string = Downloadable.getDigest(file3, "SHA-1", 40);
            File file4 = new File(file2, String.valueOf(string.substring(0, 2)) + "/" + string);
            if (!file4.exists()) {
                LOGGER.a("Migrated old asset %s into %s", file3, file4);
                try {
                    FileUtils.copyFile(file3, file4);
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.SEVERE, "Couldn't migrate old asset", iOException);
                }
            }
            FileUtils.deleteQuietly(file3);
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file5 = fileArray2[n2];
                if (!(file5.getName().equals("indexes") || file5.getName().equals("objects") || file5.getName().equals("virtual") || file5.getName().equals("skins"))) {
                    LOGGER.a("Cleaning up old assets directory %s after migration", file5);
                    FileUtils.deleteQuietly(file5);
                }
                ++n2;
            }
        }
    }

    private void f(File file) throws IOException {
        d d2 = d.k();
        for (Library library : ((CompleteMinecraftVersion)this.L).getRelevantLibraries()) {
            Map<d, String> map = library.getNatives();
            if (map == null || map.get((Object)d2) == null) continue;
            map = new File(this.bD.bw.e, "libraries/" + library.getArtifactPath(map.get((Object)d2)));
            map = new ZipFile((File)((Object)map));
            ExtractRules extractRules = library.getExtractRules();
            try {
                Enumeration<? extends ZipEntry> enumeration = ((ZipFile)((Object)map)).entries();
                while (enumeration.hasMoreElements()) {
                    Object object = enumeration.nextElement();
                    if (extractRules != null && !extractRules.shouldExtract(((ZipEntry)object).getName())) continue;
                    Object object2 = new File(file, ((ZipEntry)object).getName());
                    if (((File)object2).getParentFile() != null) {
                        ((File)object2).getParentFile().mkdirs();
                    }
                    if (((ZipEntry)object).isDirectory()) continue;
                    object = new BufferedInputStream(((ZipFile)((Object)map)).getInputStream((ZipEntry)object));
                    byte[] byArray = new byte[2048];
                    object2 = new FileOutputStream((File)object2);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object2);
                    try {
                        int n;
                        while ((n = ((BufferedInputStream)object).read(byArray, 0, 2048)) != -1) {
                            bufferedOutputStream.write(byArray, 0, n);
                        }
                    }
                    finally {
                        Downloadable.closeSilently(bufferedOutputStream);
                        Downloadable.closeSilently((Closeable)object2);
                        Downloadable.closeSilently((Closeable)object);
                    }
                }
            }
            finally {
                ((ZipFile)((Object)map)).close();
            }
        }
    }

    private String a(CompleteMinecraftVersion object) {
        StringBuilder stringBuilder = new StringBuilder();
        object = ((CompleteMinecraftVersion)object).getClassPath(d.k(), this.bD.bw.e);
        String string = System.getProperty("path.separator");
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (File)iterator.next();
            if (!((File)object).isFile()) {
                throw new RuntimeException("Classpath file not found: " + object);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(((File)object).getAbsolutePath());
        }
        return stringBuilder.toString();
    }

    @Override
    public final void b(com.mojang.launcher.a.a object) {
        block17: {
            int n = object.u();
            if (n == 0) {
                LOGGER.log("Game ended with no troubles detected (exit code " + n + ")");
                if (this.bS == net.minecraft.launcher.profile.a.ce) {
                    LOGGER.log("Following visibility rule and exiting launcher as the game has ended");
                    this.bD.bw.h();
                } else if (this.bS == net.minecraft.launcher.profile.a.cd) {
                    LOGGER.log("Following visibility rule and showing launcher as the game has ended");
                    this.bD.bx.setVisible(true);
                }
            } else {
                Object object2;
                LOGGER.log(Level.SEVERE, "Game ended with bad state (exit code " + n + ")");
                LOGGER.log("Ignoring visibility rule and showing launcher due to a game crash");
                this.bD.bx.setVisible(true);
                String string = null;
                Collection<String> collection = object.r();
                object = collection.toArray(new String[collection.size()]);
                int n2 = ((String[])object).length - 1;
                while (n2 >= 0) {
                    object2 = object[n2];
                    int n3 = ((String)object2).lastIndexOf(bN);
                    if (n3 >= 0 && n3 < ((String)object2).length() - 5 - 1) {
                        string = ((String)object2).substring(n3 + 5).trim();
                        break;
                    }
                    --n2;
                }
                if (string != null) {
                    File file = new File(string);
                    if (file.isFile()) {
                        LOGGER.log("Crash report detected, opening: " + string);
                        object2 = null;
                        try {
                            try {
                                object2 = new FileInputStream(file);
                                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object2));
                                object = new StringBuilder();
                                while ((string = bufferedReader.readLine()) != null) {
                                    if (((StringBuilder)object).length() > 0) {
                                        ((StringBuilder)object).append("\n");
                                    }
                                    ((StringBuilder)object).append(string);
                                }
                                bufferedReader.close();
                                this.bD.bx.a((CompleteMinecraftVersion)this.L, file, ((StringBuilder)object).toString());
                            }
                            catch (IOException iOException) {
                                LOGGER.log(Level.SEVERE, "Couldn't open crash report", iOException);
                                Downloadable.closeSilently((Closeable)object2);
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            Downloadable.closeSilently((Closeable)object2);
                            throw throwable;
                        }
                        Downloadable.closeSilently((Closeable)object2);
                    } else {
                        LOGGER.log(Level.SEVERE, "Crash report detected, but unknown format: " + string);
                    }
                }
            }
        }
        this.a(false);
    }

    private void a(net.minecraft.launcher.profile.a a2) {
        this.bS = a2;
    }
}

