/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.profile;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.authlib.Agent;
import com.mojang.authlib.AuthenticationService;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.teamextreme.fyre.d;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.launcher.Launcher;

@d
public class AuthenticationDatabase {
    public static final String DEMO_UUID_PREFIX = "demo-";
    private final Map<String, UserAuthentication> authById;
    private final AuthenticationService authenticationService;

    public AuthenticationDatabase(AuthenticationService authenticationService) {
        this(new HashMap<String, UserAuthentication>(), authenticationService);
    }

    public AuthenticationDatabase(Map<String, UserAuthentication> map, AuthenticationService authenticationService) {
        this.authById = map;
        this.authenticationService = authenticationService;
    }

    public UserAuthentication getByName(String string) {
        if (string == null) {
            return null;
        }
        for (Map.Entry<String, UserAuthentication> entry : this.authById.entrySet()) {
            GameProfile gameProfile = entry.getValue().getSelectedProfile();
            if (gameProfile != null && gameProfile.getName().equals(string)) {
                return entry.getValue();
            }
            if (gameProfile != null || !AuthenticationDatabase.getUserFromDemoUUID(entry.getKey()).equals(string)) continue;
            return entry.getValue();
        }
        return null;
    }

    public UserAuthentication getByUUID(String string) {
        return this.authById.get(string);
    }

    public Collection<String> getKnownNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, UserAuthentication> entry : this.authById.entrySet()) {
            GameProfile gameProfile = entry.getValue().getSelectedProfile();
            if (gameProfile != null) {
                arrayList.add(gameProfile.getName());
                continue;
            }
            arrayList.add(AuthenticationDatabase.getUserFromDemoUUID(entry.getKey()));
        }
        return arrayList;
    }

    public void register(String string, UserAuthentication userAuthentication) {
        this.authById.put(string, userAuthentication);
    }

    public Set<String> getknownUUIDs() {
        return this.authById.keySet();
    }

    public void removeUUID(String string) {
        this.authById.remove(string);
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public static String getUserFromDemoUUID(String string) {
        if (string.startsWith(DEMO_UUID_PREFIX) && string.length() > 5) {
            return "Demo User " + string.substring(5);
        }
        return "Demo User";
    }

    @d
    public static class Serializer
    implements JsonDeserializer<AuthenticationDatabase>,
    JsonSerializer<AuthenticationDatabase> {
        @Override
        public AuthenticationDatabase deserialize(JsonElement entry2, Type object, JsonDeserializationContext object2) throws JsonParseException {
            object = new HashMap();
            entry2 = this.deserializeCredentials((JsonObject)((Object)entry2), (JsonDeserializationContext)object2);
            object2 = new YggdrasilAuthenticationService(Launcher.bc().bw.proxy, Launcher.bc().clientToken.toString());
            for (Map.Entry entry2 : entry2.entrySet()) {
                UserAuthentication userAuthentication = ((YggdrasilAuthenticationService)object2).createUserAuthentication(Agent.MINECRAFT);
                userAuthentication.loadFromStorage((Map)entry2.getValue());
                object.put((String)entry2.getKey(), userAuthentication);
            }
            return new AuthenticationDatabase((Map<String, UserAuthentication>)object, (AuthenticationService)object2);
        }

        protected Map<String, Map<String, Object>> deserializeCredentials(JsonObject object3, JsonDeserializationContext object2) {
            LinkedHashMap<String, Map<String, Object>> linkedHashMap = new LinkedHashMap<String, Map<String, Object>>();
            for (Map.Entry<String, JsonElement> entry : ((JsonObject)object3).entrySet()) {
                LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
                for (Map.Entry<String, JsonElement> entry2 : ((JsonObject)entry.getValue()).entrySet()) {
                    linkedHashMap2.put(entry2.getKey(), this.deserializeCredential(entry2.getValue()));
                }
                linkedHashMap.put(entry.getKey(), linkedHashMap2);
            }
            return linkedHashMap;
        }

        private Object deserializeCredential(JsonElement object2) {
            if (object2 instanceof JsonObject) {
                LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
                for (Map.Entry<String, JsonElement> entry : ((JsonObject)object2).entrySet()) {
                    linkedHashMap.put(entry.getKey(), this.deserializeCredential(entry.getValue()));
                }
                return linkedHashMap;
            }
            if (object2 instanceof JsonArray) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (JsonElement jsonElement : (JsonArray)object2) {
                    arrayList.add(this.deserializeCredential(jsonElement));
                }
                return arrayList;
            }
            return ((JsonElement)object2).getAsString();
        }

        @Override
        public JsonElement serialize(AuthenticationDatabase entry2, Type object, JsonSerializationContext jsonSerializationContext) {
            entry2 = ((AuthenticationDatabase)((Object)entry2)).authById;
            object = new HashMap();
            for (Map.Entry entry2 : entry2.entrySet()) {
                object.put((String)entry2.getKey(), ((UserAuthentication)entry2.getValue()).saveForStorage());
            }
            return jsonSerializationContext.serialize(object);
        }
    }
}

