/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.profile;

import com.google.common.collect.Sets;
import com.mojang.launcher.updater.c;
import com.teamextreme.fyre.d;
import java.io.File;
import java.util.Set;
import net.minecraft.launcher.a.b;
import net.minecraft.launcher.profile.a;

@d
public class Profile
implements Comparable<Profile> {
    public static final String DEFAULT_JRE_ARGUMENTS_64BIT = "-Xmx1G";
    public static final String DEFAULT_JRE_ARGUMENTS_32BIT = "-Xmx512M";
    public static final Resolution DEFAULT_RESOLUTION = new Resolution(854, 480);
    public static final a DEFAULT_LAUNCHER_VISIBILITY = a.ce;
    public static final Set<b> DEFAULT_RELEASE_TYPES = Sets.newHashSet(b.bV);
    private String name;
    private File gameDir;
    private String lastVersionId;
    private String javaDir;
    private String javaArgs;
    private Resolution resolution;
    private Set<b> allowedReleaseTypes;
    private String playerUUID;
    private Boolean useHopperCrashService;
    private a launcherVisibilityOnGameClose;

    public Profile() {
    }

    public Profile(Profile profile) {
        this.name = profile.name;
        this.gameDir = profile.gameDir;
        this.playerUUID = profile.playerUUID;
        this.lastVersionId = profile.lastVersionId;
        this.javaDir = profile.javaDir;
        this.javaArgs = profile.javaArgs;
        this.resolution = profile.resolution == null ? null : new Resolution(profile.resolution);
        this.allowedReleaseTypes = profile.allowedReleaseTypes == null ? null : Sets.newHashSet(profile.allowedReleaseTypes);
        this.useHopperCrashService = profile.useHopperCrashService;
        this.launcherVisibilityOnGameClose = profile.launcherVisibilityOnGameClose;
    }

    public Profile(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public File getGameDir() {
        return this.gameDir;
    }

    public void setGameDir(File file) {
        this.gameDir = file;
    }

    public void setLastVersionId(String string) {
        this.lastVersionId = string;
    }

    public void setJavaDir(String string) {
        this.javaDir = string;
    }

    public void setJavaArgs(String string) {
        this.javaArgs = string;
    }

    public String getLastVersionId() {
        return this.lastVersionId;
    }

    public String getJavaArgs() {
        return this.javaArgs;
    }

    public String getJavaPath() {
        return this.javaDir;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
    }

    public String getPlayerUUID() {
        return this.playerUUID;
    }

    public void setPlayerUUID(String string) {
        this.playerUUID = string;
    }

    public Set<b> getAllowedReleaseTypes() {
        return this.allowedReleaseTypes;
    }

    public void setAllowedReleaseTypes(Set<b> set) {
        this.allowedReleaseTypes = set;
    }

    public boolean getUseHopperCrashService() {
        return this.useHopperCrashService == null;
    }

    public void setUseHopperCrashService(boolean bl) {
        this.useHopperCrashService = bl ? null : Boolean.valueOf(false);
    }

    public c<b> getVersionFilter() {
        c<b> c2 = new c<b>(net.minecraft.launcher.a.c.bo());
        new c<b>(net.minecraft.launcher.a.c.bo()).R = Integer.MAX_VALUE;
        if (this.allowedReleaseTypes == null) {
            c2.a(DEFAULT_RELEASE_TYPES.toArray(new b[DEFAULT_RELEASE_TYPES.size()]));
        } else {
            c2.a(this.allowedReleaseTypes.toArray(new b[this.allowedReleaseTypes.size()]));
        }
        return c2;
    }

    public a getLauncherVisibilityOnGameClose() {
        return this.launcherVisibilityOnGameClose;
    }

    public void setLauncherVisibilityOnGameClose(a a2) {
        this.launcherVisibilityOnGameClose = a2;
    }

    @Override
    public int compareTo(Profile profile) {
        if (profile == null) {
            return -1;
        }
        return this.getName().compareTo(profile.getName());
    }

    public String toString() {
        return this.getName();
    }

    @d
    public static class Resolution {
        private int width;
        private int height;

        public Resolution() {
        }

        public Resolution(Resolution resolution) {
            this(resolution.getWidth(), resolution.getHeight());
        }

        public Resolution(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

