/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import com.mojang.launcher.updater.download.Downloadable;
import com.mojang.launcher.updater.download.a;
import com.mojang.launcher.versions.CompatibilityRule;
import com.mojang.launcher.versions.CompleteVersion;
import com.mojang.launcher.versions.ReleaseType;
import com.mojang.launcher.versions.Version;
import com.teamextreme.fyre.d;
import java.io.File;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launcher.updater.Library;

@d
public class CompleteMinecraftVersion
implements CompleteVersion {
    private String id;
    private Date time;
    private Date releaseTime;
    private ReleaseType type;
    private String minecraftArguments;
    private List<Library> libraries;
    private String mainClass;
    private int minimumLauncherVersion;
    private String incompatibilityReason;
    private String assets;
    private List<CompatibilityRule> compatibilityRules;
    private transient boolean synced = false;

    public CompleteMinecraftVersion() {
    }

    public CompleteMinecraftVersion(String string, Date date, Date date2, ReleaseType releaseType, String string2, String string3) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("ID cannot be null or empty");
        }
        if (date == null) {
            throw new IllegalArgumentException("Release time cannot be null");
        }
        if (date2 == null) {
            throw new IllegalArgumentException("Update time cannot be null");
        }
        if (releaseType == null) {
            throw new IllegalArgumentException("Release type cannot be null");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Main class cannot be null or empty");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Process arguments cannot be null or empty");
        }
        this.id = string;
        this.releaseTime = date;
        this.time = date2;
        this.type = releaseType;
        this.mainClass = string2;
        this.libraries = new ArrayList<Library>();
        this.minecraftArguments = string3;
    }

    public CompleteMinecraftVersion(CompleteMinecraftVersion object2) {
        this(((CompleteMinecraftVersion)object2).getId(), ((CompleteMinecraftVersion)object2).getReleaseTime(), ((CompleteMinecraftVersion)object2).getUpdatedTime(), ((CompleteMinecraftVersion)object2).getType(), ((CompleteMinecraftVersion)object2).getMainClass(), ((CompleteMinecraftVersion)object2).getMinecraftArguments());
        this.minimumLauncherVersion = ((CompleteMinecraftVersion)object2).minimumLauncherVersion;
        this.incompatibilityReason = ((CompleteMinecraftVersion)object2).incompatibilityReason;
        for (Library library : ((CompleteMinecraftVersion)object2).getLibraries()) {
            this.libraries.add(new Library(library));
        }
    }

    public CompleteMinecraftVersion(Version version, String string, String string2) {
        this(version.getId(), version.getReleaseTime(), version.getUpdatedTime(), version.getType(), string, string2);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ReleaseType getType() {
        return this.type;
    }

    @Override
    public Date getUpdatedTime() {
        return this.time;
    }

    @Override
    public Date getReleaseTime() {
        return this.releaseTime;
    }

    public List<Library> getLibraries() {
        return this.libraries;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setUpdatedTime(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Time cannot be null");
        }
        this.time = date;
    }

    public void setReleaseTime(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Time cannot be null");
        }
        this.releaseTime = date;
    }

    public void setType(ReleaseType releaseType) {
        if (releaseType == null) {
            throw new IllegalArgumentException("Release type cannot be null");
        }
        this.type = releaseType;
    }

    public void setMainClass(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Main class cannot be null or empty");
        }
        this.mainClass = string;
    }

    public Collection<Library> getRelevantLibraries() {
        ArrayList<Library> arrayList = new ArrayList<Library>();
        for (Library library : this.libraries) {
            if (!library.appliesToCurrentEnvironment()) continue;
            arrayList.add(library);
        }
        return arrayList;
    }

    public Collection<File> getClassPath(com.mojang.launcher.d object, File file) {
        object = this.getRelevantLibraries();
        ArrayList<File> arrayList = new ArrayList<File>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (Library)iterator.next();
            if (((Library)object).getNatives() != null) continue;
            arrayList.add(new File(file, "libraries/" + ((Library)object).getArtifactPath()));
        }
        arrayList.add(new File(file, "versions/" + this.getId() + "/" + this.getId() + ".jar"));
        return arrayList;
    }

    public Collection<String> getExtractFiles(com.mojang.launcher.d d2) {
        Object object = this.getRelevantLibraries();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Library> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            Map<com.mojang.launcher.d, String> map = ((Library)object).getNatives();
            if (map == null || !map.containsKey((Object)d2)) continue;
            arrayList.add("libraries/" + ((Library)object).getArtifactPath(map.get((Object)d2)));
        }
        return arrayList;
    }

    public Set<String> getRequiredFiles(com.mojang.launcher.d d2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Library library : this.getRelevantLibraries()) {
            if (library.getNatives() != null) {
                String string = library.getNatives().get((Object)d2);
                if (string == null) continue;
                hashSet.add("libraries/" + library.getArtifactPath(string));
                continue;
            }
            hashSet.add("libraries/" + library.getArtifactPath());
        }
        return hashSet;
    }

    public Set<Downloadable> getRequiredDownloadables(com.mojang.launcher.d d2, Proxy proxy, File file, boolean bl) throws MalformedURLException {
        HashSet<Downloadable> hashSet = new HashSet<Downloadable>();
        for (Library library : this.getRelevantLibraries()) {
            Object object;
            Object object2 = null;
            if (library.getNatives() != null) {
                object = library.getNatives().get((Object)d2);
                if (object != null) {
                    object2 = library.getArtifactPath((String)object);
                }
            } else {
                object2 = library.getArtifactPath();
            }
            if (object2 == null) continue;
            object = new URL(String.valueOf(library.getDownloadUrl()) + (String)object2);
            if (((File)(object2 = new File(file, "libraries/" + (String)object2))).isFile() && library.hasCustomUrl()) continue;
            hashSet.add(new a(proxy, (URL)object, (File)object2, bl));
        }
        return hashSet;
    }

    public String toString() {
        return "CompleteVersion{id='" + this.id + '\'' + ", updatedTime=" + this.time + ", releasedTime=" + this.time + ", type=" + this.type + ", libraries=" + this.libraries + ", mainClass='" + this.mainClass + '\'' + ", minimumLauncherVersion=" + this.minimumLauncherVersion + '}';
    }

    public String getMinecraftArguments() {
        return this.minecraftArguments;
    }

    public void setMinecraftArguments(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Process arguments cannot be null or empty");
        }
        this.minecraftArguments = string;
    }

    @Override
    public int getMinimumLauncherVersion() {
        return this.minimumLauncherVersion;
    }

    public void setMinimumLauncherVersion(int n) {
        this.minimumLauncherVersion = n;
    }

    @Override
    public boolean appliesToCurrentEnvironment() {
        if (this.compatibilityRules == null) {
            return true;
        }
        CompatibilityRule.Action action = CompatibilityRule.Action.DISALLOW;
        Iterator<CompatibilityRule> iterator = this.compatibilityRules.iterator();
        while (iterator.hasNext()) {
            CompatibilityRule.Action action2 = iterator.next().getAppliedAction();
            if (action2 == null) continue;
            action = action2;
        }
        return action == CompatibilityRule.Action.ALLOW;
    }

    public void setIncompatibilityReason(String string) {
        this.incompatibilityReason = string;
    }

    @Override
    public String getIncompatibilityReason() {
        return this.incompatibilityReason;
    }

    @Override
    public boolean isSynced() {
        return this.synced;
    }

    @Override
    public void setSynced(boolean bl) {
        this.synced = bl;
    }

    public String getAssets() {
        return this.assets;
    }

    public void setAssets(String string) {
        this.assets = string;
    }
}

