/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import com.mojang.launcher.versions.CompatibilityRule;
import com.mojang.launcher.versions.ExtractRules;
import com.teamextreme.fyre.d;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.text.StrSubstitutor;

@d
public class Library {
    private static final StrSubstitutor SUBSTITUTOR;
    private String name;
    private List<CompatibilityRule> rules;
    private Map<com.mojang.launcher.d, String> natives;
    private ExtractRules extract;
    private String url;

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("arch", System.getProperty("sun.arch.data.model"));
        SUBSTITUTOR = new StrSubstitutor(hashMap);
    }

    public Library() {
    }

    public Library(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Library name cannot be null or empty");
        }
        this.name = string;
    }

    public Library(Library library) {
        this.name = library.name;
        this.url = library.url;
        if (library.extract != null) {
            this.extract = new ExtractRules(library.extract);
        }
        if (library.rules != null) {
            this.rules = new ArrayList<CompatibilityRule>();
            for (CompatibilityRule object : library.rules) {
                this.rules.add(new CompatibilityRule(object));
            }
        }
        if (library.natives != null) {
            this.natives = new LinkedHashMap<com.mojang.launcher.d, String>();
            for (Map.Entry entry : library.getNatives().entrySet()) {
                this.natives.put((com.mojang.launcher.d)((Object)entry.getKey()), (String)entry.getValue());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Library addNative(com.mojang.launcher.d d2, String string) {
        if (d2 == null || !d2.isSupported()) {
            throw new IllegalArgumentException("Cannot add native for unsupported OS");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Cannot add native for null or empty name");
        }
        if (this.natives == null) {
            this.natives = new EnumMap<com.mojang.launcher.d, String>(com.mojang.launcher.d.class);
        }
        this.natives.put(d2, string);
        return this;
    }

    public List<CompatibilityRule> getRules() {
        return this.rules;
    }

    public boolean appliesToCurrentEnvironment() {
        if (this.rules == null) {
            return true;
        }
        CompatibilityRule.Action action = CompatibilityRule.Action.DISALLOW;
        Iterator<CompatibilityRule> iterator = this.rules.iterator();
        while (iterator.hasNext()) {
            CompatibilityRule.Action action2 = iterator.next().getAppliedAction();
            if (action2 == null) continue;
            action = action2;
        }
        return action == CompatibilityRule.Action.ALLOW;
    }

    public Map<com.mojang.launcher.d, String> getNatives() {
        return this.natives;
    }

    public ExtractRules getExtractRules() {
        return this.extract;
    }

    public Library setExtractRules(ExtractRules extractRules) {
        this.extract = extractRules;
        return this;
    }

    public String getArtifactBaseDir() {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact dir of empty/blank artifact");
        }
        String[] stringArray = this.name.split(":", 3);
        return String.format("%s/%s/%s", stringArray[0].replaceAll("\\.", "/"), stringArray[1], stringArray[2]);
    }

    public String getArtifactPath() {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact path of empty/blank artifact");
        }
        return String.format("%s/%s", this.getArtifactBaseDir(), this.getArtifactFilename());
    }

    public String getArtifactPath(String string) {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact path of empty/blank artifact");
        }
        return String.format("%s/%s", this.getArtifactBaseDir(), this.getArtifactFilename(string));
    }

    public String getArtifactFilename() {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact filename of empty/blank artifact");
        }
        Object object = this.name.split(":", 3);
        object = String.format("%s-%s.jar", object[1], object[2]);
        return SUBSTITUTOR.replace((String)object);
    }

    public String getArtifactFilename(String string) {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact filename of empty/blank artifact");
        }
        String[] stringArray = this.name.split(":", 3);
        string = String.format("%s-%s%s.jar", stringArray[1], stringArray[2], "-" + string);
        return SUBSTITUTOR.replace(string);
    }

    public String toString() {
        return "Library{name='" + this.name + '\'' + ", rules=" + this.rules + ", natives=" + this.natives + ", extract=" + this.extract + '}';
    }

    public boolean hasCustomUrl() {
        return this.url != null;
    }

    public String getDownloadUrl() {
        if (this.url != null) {
            return this.url;
        }
        return "https://libraries.minecraft.net/";
    }
}

