/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import com.google.gson.JsonSyntaxException;
import com.mojang.launcher.versions.CompleteVersion;
import com.mojang.launcher.versions.Version;
import com.teamextreme.fyre.a;
import com.teamextreme.fyre.d;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.logging.Level;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.a.b;
import net.minecraft.launcher.updater.CompleteMinecraftVersion;
import net.minecraft.launcher.updater.FileBasedVersionList;
import org.apache.commons.io.FileUtils;

@d
public class LocalVersionList
extends FileBasedVersionList {
    private static final a LOGGER = com.teamextreme.fyre.b.ad();
    private final File baseDirectory;
    private final File baseVersionsDir;

    public LocalVersionList(File file) {
        if (file == null || !file.isDirectory()) {
            throw new IllegalArgumentException("Base directory is not a folder!");
        }
        this.baseDirectory = file;
        this.baseVersionsDir = new File(this.baseDirectory, "versions");
        if (!this.baseVersionsDir.isDirectory()) {
            this.baseVersionsDir.mkdirs();
        }
    }

    @Override
    protected InputStream getFileInputStream(String string) throws FileNotFoundException {
        return new FileInputStream(new File(this.baseDirectory, string));
    }

    @Override
    public void refreshVersions() throws IOException {
        this.clearCache();
        File[] object2 = this.baseVersionsDir.listFiles();
        if (object2 == null) {
            return;
        }
        File[] fileArray = object2;
        int n = object2.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String string = file.getName();
            File file2 = new File(file, String.valueOf(string) + ".json");
            if (file.isDirectory() && file2.exists()) {
                try {
                    String string2 = "versions/" + string + "/" + string + ".json";
                    CompleteVersion completeVersion = this.gson.fromJson(this.getContent(string2), CompleteMinecraftVersion.class);
                    if (completeVersion.getType() == null) {
                        LOGGER.a(Level.WARNING, "Ignoring: %s; it has an invalid version specified", string2);
                        return;
                    }
                    if (completeVersion.getId().equals(string)) {
                        this.addVersion(completeVersion);
                    } else if (Launcher.bc() != null) {
                        LOGGER.a(Level.WARNING, "Ignoring: %s; it contains id: '%s' expected '%s'", string2, completeVersion.getId(), string);
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (Launcher.bc() != null) {
                        LOGGER.log(Level.SEVERE, "Couldn't load local version " + file2.getAbsolutePath(), runtimeException);
                    }
                    throw new JsonSyntaxException("Loading file: " + file2.toString(), runtimeException);
                }
            }
            ++n2;
        }
        for (Version version : this.getVersions()) {
            b b2 = (b)version.getType();
            if (this.getLatestVersion(b2) != null && !this.getLatestVersion(b2).getUpdatedTime().before(version.getUpdatedTime())) continue;
            this.setLatestVersion(version);
        }
    }

    public void saveVersionList() throws IOException {
        String string = this.serializeVersionList();
        PrintWriter printWriter = new PrintWriter(new File(this.baseVersionsDir, "versions.json"));
        printWriter.print(string);
        printWriter.close();
    }

    public void saveVersion(CompleteVersion object) throws IOException {
        String string = this.serializeVersion((CompleteVersion)object);
        if (((File)(object = new File(this.baseVersionsDir, String.valueOf(object.getId()) + "/" + object.getId() + ".json"))).getParentFile() != null) {
            ((File)object).getParentFile().mkdirs();
        }
        object = new PrintWriter((File)object);
        ((PrintWriter)object).print(string);
        ((PrintWriter)object).close();
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    @Override
    public boolean hasAllFiles(CompleteMinecraftVersion object3, com.mojang.launcher.d object2) {
        Iterator<String> iterator;
        for (String string : ((CompleteMinecraftVersion)object3).getRequiredFiles((com.mojang.launcher.d)((Object)iterator))) {
            if (new File(this.baseDirectory, string).isFile()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void uninstallVersion(Version object) {
        super.uninstallVersion((Version)object);
        object = new File(this.baseVersionsDir, object.getId());
        if (((File)object).isDirectory()) {
            FileUtils.deleteQuietly((File)object);
        }
    }
}

