/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import com.mojang.launcher.versions.ReleaseType;
import com.mojang.launcher.versions.Version;
import com.teamextreme.fyre.d;
import java.util.Date;

@d
public class PartialVersion
implements Version {
    private String id;
    private Date time;
    private Date releaseTime;
    private ReleaseType type;

    public PartialVersion() {
    }

    public PartialVersion(String string, Date date, Date date2, ReleaseType releaseType) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("ID cannot be null or empty");
        }
        if (date == null) {
            throw new IllegalArgumentException("Release time cannot be null");
        }
        if (date2 == null) {
            throw new IllegalArgumentException("Update time cannot be null");
        }
        if (releaseType == null) {
            throw new IllegalArgumentException("Release type cannot be null");
        }
        this.id = string;
        this.releaseTime = date;
        this.time = date2;
        this.type = releaseType;
    }

    public PartialVersion(Version version) {
        this(version.getId(), version.getReleaseTime(), version.getUpdatedTime(), version.getType());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ReleaseType getType() {
        return this.type;
    }

    @Override
    public Date getUpdatedTime() {
        return this.time;
    }

    public void setUpdatedTime(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Time cannot be null");
        }
        this.time = date;
    }

    @Override
    public Date getReleaseTime() {
        return this.releaseTime;
    }

    public void setReleaseTime(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Time cannot be null");
        }
        this.releaseTime = date;
    }

    public void setType(ReleaseType releaseType) {
        if (releaseType == null) {
            throw new IllegalArgumentException("Release type cannot be null");
        }
        this.type = releaseType;
    }

    public String toString() {
        return "PartialVersion{id='" + this.id + '\'' + ", updateTime=" + this.time + ", releaseTime=" + this.releaseTime + ", type=" + this.type + '}';
    }
}

