/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.launcher.updater.DateTypeAdapter;
import com.mojang.launcher.updater.LowerCaseEnumTypeAdapterFactory;
import com.mojang.launcher.versions.CompleteVersion;
import com.mojang.launcher.versions.ReleaseType;
import com.mojang.launcher.versions.ReleaseTypeAdapterFactory;
import com.mojang.launcher.versions.Version;
import com.teamextreme.fyre.d;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.launcher.a.b;
import net.minecraft.launcher.a.c;
import net.minecraft.launcher.updater.CompleteMinecraftVersion;
import net.minecraft.launcher.updater.PartialVersion;

@d
public abstract class VersionList {
    protected final Gson gson;
    private final Map<String, Version> versionsByName = new HashMap<String, Version>();
    private final List<Version> versions = new ArrayList<Version>();
    private final Map<b, Version> latestVersions = Maps.newEnumMap(b.class);

    public VersionList() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
        gsonBuilder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        gsonBuilder.registerTypeAdapter((Type)((Object)ReleaseType.class), new ReleaseTypeAdapterFactory<b>(c.bo()));
        gsonBuilder.enableComplexMapKeySerialization();
        gsonBuilder.setPrettyPrinting();
        this.gson = gsonBuilder.create();
    }

    public Collection<Version> getVersions() {
        return this.versions;
    }

    public Version getLatestVersion(b b2) {
        if (b2 == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        return this.latestVersions.get(b2);
    }

    public Version getVersion(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return this.versionsByName.get(string);
    }

    public CompleteMinecraftVersion getCompleteVersion(String object) throws IOException {
        if (object == null || ((String)object).length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if ((object = this.getVersion((String)object)) == null) {
            throw new IllegalArgumentException("Unknown version - cannot get complete version of null");
        }
        return this.getCompleteVersion((Version)object);
    }

    public CompleteMinecraftVersion getCompleteVersion(Version version) throws IOException {
        if (version instanceof CompleteMinecraftVersion) {
            return (CompleteMinecraftVersion)version;
        }
        if (version == null) {
            throw new IllegalArgumentException("Version cannot be null");
        }
        CompleteMinecraftVersion completeMinecraftVersion = this.gson.fromJson(this.getContent("versions/" + version.getId() + "/" + version.getId() + ".json"), CompleteMinecraftVersion.class);
        b b2 = (b)version.getType();
        Collections.replaceAll(this.versions, version, completeMinecraftVersion);
        this.versionsByName.put(version.getId(), completeMinecraftVersion);
        if (this.latestVersions.get(b2) == version) {
            this.latestVersions.put(b2, completeMinecraftVersion);
        }
        return completeMinecraftVersion;
    }

    protected void clearCache() {
        this.versionsByName.clear();
        this.versions.clear();
        this.latestVersions.clear();
    }

    public void refreshVersions() throws IOException {
        this.clearCache();
        RawVersionList rawVersionList = this.gson.fromJson(this.getContent("versions/versions.json"), RawVersionList.class);
        for (Version object : rawVersionList.getVersions()) {
            this.versions.add(object);
            this.versionsByName.put(object.getId(), object);
        }
        b[] bArray = b.values();
        int n = bArray.length;
        int n2 = 0;
        while (n2 < n) {
            b b2 = bArray[n2];
            this.latestVersions.put(b2, this.versionsByName.get(rawVersionList.getLatestVersions().get(b2)));
            ++n2;
        }
    }

    public CompleteVersion addVersion(CompleteVersion completeVersion) {
        if (completeVersion.getId() == null) {
            throw new IllegalArgumentException("Cannot add blank version");
        }
        if (this.getVersion(completeVersion.getId()) != null) {
            throw new IllegalArgumentException("Version '" + completeVersion.getId() + "' is already tracked");
        }
        this.versions.add(completeVersion);
        this.versionsByName.put(completeVersion.getId(), completeVersion);
        return completeVersion;
    }

    public void removeVersion(String object) {
        if (object == null || ((String)object).length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if ((object = this.getVersion((String)object)) == null) {
            throw new IllegalArgumentException("Unknown version - cannot remove null");
        }
        this.removeVersion((Version)object);
    }

    public void removeVersion(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Cannot remove null version");
        }
        this.versions.remove(version);
        this.versionsByName.remove(version.getId());
        b[] bArray = b.values();
        int n = bArray.length;
        int n2 = 0;
        while (n2 < n) {
            b b2 = bArray[n2];
            if (this.getLatestVersion(b2) == version) {
                this.latestVersions.remove(b2);
            }
            ++n2;
        }
    }

    public void setLatestVersion(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Cannot set latest version to null");
        }
        this.latestVersions.put((b)version.getType(), version);
    }

    public void setLatestVersion(String object) {
        if (object == null || ((String)object).length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if ((object = this.getVersion((String)object)) == null) {
            throw new IllegalArgumentException("Unknown version - cannot set latest version to null");
        }
        this.setLatestVersion((Version)object);
    }

    public String serializeVersionList() {
        RawVersionList rawVersionList = new RawVersionList();
        b[] bArray = b.values();
        int n = bArray.length;
        int n2 = 0;
        while (n2 < n) {
            b object = bArray[n2];
            Version version = this.getLatestVersion(object);
            if (version != null) {
                rawVersionList.getLatestVersions().put(object, version.getId());
            }
            ++n2;
        }
        for (Version version : this.getVersions()) {
            PartialVersion partialVersion = version instanceof PartialVersion ? (PartialVersion)version : new PartialVersion(version);
            rawVersionList.getVersions().add(partialVersion);
        }
        return this.gson.toJson(rawVersionList);
    }

    public String serializeVersion(CompleteVersion completeVersion) {
        if (completeVersion == null) {
            throw new IllegalArgumentException("Cannot serialize null!");
        }
        return this.gson.toJson(completeVersion);
    }

    public abstract boolean hasAllFiles(CompleteMinecraftVersion var1, com.mojang.launcher.d var2);

    protected abstract String getContent(String var1) throws IOException;

    public abstract URL getUrl(String var1) throws MalformedURLException;

    public void uninstallVersion(Version version) {
        this.removeVersion(version);
    }

    @d
    static class RawVersionList {
        private List<PartialVersion> versions = new ArrayList<PartialVersion>();
        private Map<b, String> latest = Maps.newEnumMap(b.class);

        private RawVersionList() {
        }

        public List<PartialVersion> getVersions() {
            return this.versions;
        }

        public Map<b, String> getLatestVersions() {
            return this.latest;
        }
    }
}

