/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.mojang.launcher.d;
import com.mojang.launcher.updater.VersionManager;
import com.mojang.launcher.updater.VersionSyncInfo;
import com.mojang.launcher.updater.c;
import com.mojang.launcher.updater.download.DownloadJob;
import com.mojang.launcher.updater.download.Downloadable;
import com.mojang.launcher.updater.download.assets.AssetDownloadable;
import com.mojang.launcher.updater.download.assets.AssetIndex;
import com.mojang.launcher.versions.CompleteVersion;
import com.mojang.launcher.versions.ReleaseType;
import com.mojang.launcher.versions.Version;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.minecraft.launcher.a.b;
import net.minecraft.launcher.updater.CompleteMinecraftVersion;
import net.minecraft.launcher.updater.LocalVersionList;
import net.minecraft.launcher.updater.RemoteVersionList;
import net.minecraft.launcher.updater.VersionList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public final class a
implements VersionManager {
    private static final com.teamextreme.fyre.a LOGGER = com.teamextreme.fyre.b.ad();
    public final VersionList fq;
    private final VersionList fr;
    private final ThreadPoolExecutor fs = new com.mojang.launcher.updater.b(4, 8, TimeUnit.SECONDS);
    private final List<com.mojang.launcher.a.a> ft = Collections.synchronizedList(new ArrayList());
    private final Object fu = new Object();
    private boolean fv;
    private final Gson gson = new Gson();

    public a(VersionList versionList, VersionList versionList2) {
        this.fq = versionList;
        this.fr = versionList2;
    }

    @Override
    public final void refreshVersions() throws IOException {
        Object object = this.fu;
        synchronized (object) {
            this.fv = true;
        }
        try {
            LOGGER.log("Refreshing local version list...");
            this.fq.refreshVersions();
            LOGGER.log("Refreshing remote version list...");
            this.fr.refreshVersions();
        }
        catch (IOException iOException) {
            Object object2 = this.fu;
            synchronized (object2) {
                this.fv = false;
            }
            throw iOException;
        }
        LOGGER.log("Refresh complete.");
        object = this.fu;
        synchronized (object) {
            this.fv = false;
        }
        Iterator<com.mojang.launcher.a.a> iterator = Lists.newArrayList(this.ft).iterator();
        while (iterator.hasNext()) {
            iterator.next().a(this);
        }
    }

    @Override
    public final List<VersionSyncInfo> getVersions() {
        return this.getVersions(null);
    }

    @Override
    public final List<VersionSyncInfo> getVersions(c<? extends ReleaseType> c2) {
        ArrayList<VersionSyncInfo> arrayList = this.fu;
        synchronized (arrayList) {
            if (this.fv) {
                return new ArrayList<VersionSyncInfo>();
            }
        }
        arrayList = new ArrayList<VersionSyncInfo>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        EnumMap<b, Integer> enumMap = Maps.newEnumMap(b.class);
        Object object = b.values();
        int n = ((b[])object).length;
        int n2 = 0;
        while (n2 < n) {
            b object2 = object[n2];
            enumMap.put(object2, 0);
            ++n2;
        }
        for (Version version : this.fq.getVersions()) {
            b b2 = (b)version.getType();
            if (c2 != null && (!c2.Q.contains(b2) || (Integer)enumMap.get(b2) >= c2.R)) continue;
            object = this.getVersionSyncInfo(version, this.fr.getVersion(version.getId()));
            hashMap.put(version.getId(), object);
            arrayList.add((VersionSyncInfo)object);
        }
        for (Version version : this.fr.getVersions()) {
            b b3 = (b)version.getType();
            if (hashMap.containsKey(version.getId()) || c2 != null && (!c2.Q.contains(b3) || (Integer)enumMap.get(b3) >= c2.R)) continue;
            object = this.getVersionSyncInfo(this.fq.getVersion(version.getId()), version);
            hashMap.put(version.getId(), object);
            arrayList.add((VersionSyncInfo)object);
            if (c2 == null) continue;
            enumMap.put(b3, (Integer)enumMap.get(version.getType()) + 1);
        }
        if (arrayList.isEmpty()) {
            for (Version version : this.fq.getVersions()) {
                if (version.getType() == null || version.getUpdatedTime() == null) continue;
                VersionSyncInfo versionSyncInfo = this.getVersionSyncInfo(version, this.fr.getVersion(version.getId()));
                hashMap.put(version.getId(), versionSyncInfo);
                arrayList.add(versionSyncInfo);
            }
        }
        Collections.sort(arrayList, new Comparator<VersionSyncInfo>(){
            private /* synthetic */ a fw;

            private static int a(VersionSyncInfo object, VersionSyncInfo object2) {
                object = ((VersionSyncInfo)object).getLatestVersion();
                object2 = ((VersionSyncInfo)object2).getLatestVersion();
                if (object.getReleaseTime() != null && object2.getReleaseTime() != null) {
                    return object2.getReleaseTime().compareTo(object.getReleaseTime());
                }
                return object2.getUpdatedTime().compareTo(object.getUpdatedTime());
            }

            @Override
            public final /* synthetic */ int compare(Object object, Object object2) {
                object2 = (VersionSyncInfo)object2;
                object = ((VersionSyncInfo)object).getLatestVersion();
                object2 = ((VersionSyncInfo)object2).getLatestVersion();
                if (object.getReleaseTime() != null && object2.getReleaseTime() != null) {
                    return object2.getReleaseTime().compareTo(object.getReleaseTime());
                }
                return object2.getUpdatedTime().compareTo(object.getUpdatedTime());
            }
        });
        return arrayList;
    }

    @Override
    public final VersionSyncInfo getVersionSyncInfo(Version version) {
        return this.getVersionSyncInfo(version.getId());
    }

    @Override
    public final VersionSyncInfo getVersionSyncInfo(String string) {
        return this.getVersionSyncInfo(this.fq.getVersion(string), this.fr.getVersion(string));
    }

    @Override
    public final VersionSyncInfo getVersionSyncInfo(Version version, Version version2) {
        boolean bl = version != null;
        boolean bl2 = bl;
        if (bl && version2 != null) {
            boolean bl3 = bl2 = !version2.getUpdatedTime().after(version.getUpdatedTime());
        }
        if (version instanceof CompleteMinecraftVersion) {
            bl2 &= this.fq.hasAllFiles((CompleteMinecraftVersion)version, d.k());
        }
        return new VersionSyncInfo(version, version2, bl, bl2);
    }

    @Override
    public final List<VersionSyncInfo> getInstalledVersions() {
        ArrayList<VersionSyncInfo> arrayList = new ArrayList<VersionSyncInfo>();
        for (Version version : this.fq.getVersions()) {
            if (version.getType() == null && version.getUpdatedTime() == null) continue;
            VersionSyncInfo versionSyncInfo = this.getVersionSyncInfo(version, this.fr.getVersion(version.getId()));
            arrayList.add(versionSyncInfo);
        }
        return arrayList;
    }

    private VersionList ct() {
        return this.fr;
    }

    private VersionList cu() {
        return this.fq;
    }

    private CompleteMinecraftVersion d(VersionSyncInfo versionSyncInfo) throws IOException {
        if (versionSyncInfo.getLatestSource() == VersionSyncInfo.VersionSource.REMOTE) {
            CompleteMinecraftVersion completeMinecraftVersion = null;
            Object var3_3 = null;
            try {
                completeMinecraftVersion = this.fr.getCompleteVersion(versionSyncInfo.getLatestVersion());
            }
            catch (IOException iOException) {
                try {
                    completeMinecraftVersion = this.fq.getCompleteVersion(versionSyncInfo.getLatestVersion());
                }
                catch (IOException iOException2) {}
            }
            if (completeMinecraftVersion != null) {
                return completeMinecraftVersion;
            }
            throw var3_3;
        }
        return this.fq.getCompleteVersion(versionSyncInfo.getLatestVersion());
    }

    @Override
    public final DownloadJob downloadVersion(VersionSyncInfo object, DownloadJob downloadJob) throws IOException {
        if (!(this.fq instanceof LocalVersionList)) {
            throw new IllegalArgumentException("Cannot download if local repo isn't a LocalVersionList");
        }
        if (!(this.fr instanceof RemoteVersionList)) {
            throw new IllegalArgumentException("Cannot download if local repo isn't a RemoteVersionList");
        }
        object = this.d((VersionSyncInfo)object);
        File file = ((LocalVersionList)this.fq).getBaseDirectory();
        Proxy proxy = ((RemoteVersionList)this.fr).getProxy();
        downloadJob.addDownloadables(((CompleteMinecraftVersion)object).getRequiredDownloadables(d.k(), proxy, file, false));
        object = "versions/" + ((CompleteMinecraftVersion)object).getId() + "/" + ((CompleteMinecraftVersion)object).getId() + ".jar";
        downloadJob.addDownloadables(new com.mojang.launcher.updater.download.c(proxy, this.fr.getUrl((String)object), new File(file, (String)object)));
        return downloadJob;
    }

    @Override
    public final DownloadJob downloadResources(DownloadJob downloadJob, CompleteVersion completeVersion) throws IOException {
        File file = ((LocalVersionList)this.fq).getBaseDirectory();
        downloadJob.addDownloadables(this.a(((RemoteVersionList)this.fr).getProxy(), file, (CompleteMinecraftVersion)completeVersion));
        return downloadJob;
    }

    private Set<Downloadable> a(Proxy proxy, File object2, CompleteMinecraftVersion iterator) {
        HashSet<Downloadable> hashSet;
        block7: {
            Object object;
            hashSet = new HashSet<Downloadable>();
            InputStream inputStream = null;
            File file = new File((File)object2, "assets");
            File file2 = new File(file, "objects");
            File file3 = new File(file, "indexes");
            object = ((CompleteMinecraftVersion)object).getAssets();
            System.nanoTime();
            if (object == null) {
                object = "legacy";
            }
            File file4 = new File(file3, String.valueOf(object) + ".json");
            try {
                try {
                    inputStream = this.fr.getUrl("indexes/" + (String)object + ".json").openConnection(proxy).getInputStream();
                    object = IOUtils.toString(inputStream);
                    FileUtils.writeStringToFile(file4, (String)object);
                    for (Map.Entry entry : this.gson.fromJson((String)object, AssetIndex.class).getUniqueObjects().entrySet()) {
                        AssetIndex.AssetObject assetObject = (AssetIndex.AssetObject)entry.getKey();
                        Object object3 = String.valueOf(assetObject.getHash().substring(0, 2)) + "/" + assetObject.getHash();
                        if (((File)(object3 = new File(file2, (String)object3))).isFile() && FileUtils.sizeOf((File)object3) == assetObject.getSize()) continue;
                        AssetDownloadable assetDownloadable = new AssetDownloadable(proxy, (String)entry.getValue(), assetObject, "http://resources.download.minecraft.net/", file2);
                        assetDownloadable.setExpectedSize(assetObject.getSize());
                        hashSet.add(assetDownloadable);
                    }
                    System.nanoTime();
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, "Couldn't download resources", exception);
                    IOUtils.closeQuietly(inputStream);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(inputStream);
        }
        return hashSet;
    }

    @Override
    public final ThreadPoolExecutor getExecutorService() {
        return this.fs;
    }

    @Override
    public final void addRefreshedVersionsListener(com.mojang.launcher.a.a a2) {
        this.ft.add(a2);
    }

    @Override
    public final void removeRefreshedVersionsListener(com.mojang.launcher.a.a a2) {
        this.ft.remove(a2);
    }

    @Override
    public final VersionSyncInfo syncVersion(VersionSyncInfo versionSyncInfo) throws IOException {
        CompleteMinecraftVersion completeMinecraftVersion = this.fr.getCompleteVersion(versionSyncInfo.getRemoteVersion());
        this.fq.removeVersion(versionSyncInfo.getLocalVersion());
        this.fq.addVersion(completeMinecraftVersion);
        ((LocalVersionList)this.fq).saveVersion(completeMinecraftVersion);
        return this.getVersionSyncInfo(completeMinecraftVersion);
    }

    @Override
    public final void installVersion(CompleteVersion completeVersion) throws IOException {
        VersionList versionList = this.fq;
        if (versionList.getVersion(completeVersion.getId()) != null) {
            versionList.removeVersion(completeVersion.getId());
        }
        versionList.addVersion(completeVersion);
        if (versionList instanceof LocalVersionList) {
            ((LocalVersionList)versionList).saveVersion(completeVersion);
        }
        LOGGER.log("Installed " + completeVersion);
    }

    @Override
    public final void uninstallVersion(CompleteVersion completeVersion) throws IOException {
        VersionList versionList = this.fq;
        if (versionList instanceof LocalVersionList) {
            versionList.uninstallVersion(completeVersion);
            LOGGER.log("Uninstalled " + completeVersion);
        }
    }

    @Override
    public final /* synthetic */ CompleteVersion getLatestCompleteVersion(VersionSyncInfo versionSyncInfo) throws IOException {
        return this.d(versionSyncInfo);
    }
}

