﻿--RazerOrbweaver, a World of Warcraft® user interface addon.

local R = RazerOrbweaver

local L = LibStub("AceLocale-3.0"):GetLocale("RazerOrbweaver")

local BROKER = LibStub:GetLibrary("LibDataBroker-1.1")

BROKER:NewDataObject("RazerOrbweaver", {

	type = "launcher",
	text = " "..L.RAZERONE,
	label = L.RAZERONE,
	icon = "Interface\\AddOns\\RazerOrbweaver\\Images\\RazerOrbweaver_Logo",
	OnClick = function(self, button, down)

		PlaySound("igChatScrollDown")

		if (InCombatLockdown()) then return end

		if (IsShiftKeyDown()) then

			R.ToggleBindings()

		else

			if (R.GamePad:IsVisible()) then

				R.GamePad:Hide()

				R.ToggleBindings(nil, true)

				if (R.GUI) then
					R.GUI:Hide()
				end
			else
				R.GamePad:Show()
			end
		end
	end,
	OnTooltipShow = function(tooltip)
		if not tooltip or not tooltip.AddLine then return end
		tooltip:AddLine(L.RAZERONE)
		tooltip:AddLine("")
	end,
})