﻿--RazerOrbweaver, a World of Warcraft® user interface addon.

local R, DB, PEW, ROS, player, realm, btnGDB, btnCDB = RazerOrbweaver

local BUTTON = setmetatable({}, { __index = CreateFrame("CheckButton") })

local BTNIndex = R.BTNIndex

local L = LibStub("AceLocale-3.0"):GetLocale("RazerOrbweaver")

local KeyMap, MacroDrag, StartDrag, ItemCache = R.KeyMap, R.MacroDrag, R.StartDrag

--local copies of often used globals
local gmatch = string.gmatch
local floor = math.floor
local ceil = math.ceil
local select = _G.select
local tonumber = _G.tonumber
local unpack = _G.unpack
local next = _G.next
local pi, cos, sin = math.pi, cos, sin

local HasAction = _G.HasAction
local GetTime = _G.GetTime
local UnitAura = _G.UnitAura
local UnitMana = _G.UnitMana
local UnitHasVehicleUI = _G.UnitHasVehicleUI
local InCombatLockdown = _G.InCombatLockdown
local SecureCmdOptionParse = _G.SecureCmdOptionParse
local QueryCastSequence = _G.QueryCastSequence
local SetCVar = _G.SetCVar
local UIErrorsFrame = _G.UIErrorsFrame

local GetNumShapeshiftForms = _G.GetNumShapeshiftForms
local GetShapeshiftFormInfo = _G.GetShapeshiftFormInfo
local GetContainerNumSlots = _G.GetContainerNumSlots
local GetComboPoints = _G.GetComboPoints

local GetCursorInfo = _G.GetCursorInfo

local GetActionInfo = _G.GetActionInfo
local IsActionInRange = _G.IsActionInRange

local GetMacroInfo = _G.GetMacroInfo

local GetSpellCooldown = _G.GetSpellCooldown
local GetSpellTexture = _G.GetSpellTexture
local GetSpellCount = _G.GetSpellCount
local IsCurrentSpell = _G.IsCurrentSpell
local IsAutoRepeatSpell = _G.IsAutoRepeatSpell
local IsAttackSpell = _G.IsAttackSpell
local IsSpellInRange = _G.IsSpellInRange

local GetInventoryItemLink = _G.GetInventoryItemLink
local GetItemCooldown = _G.GetItemCooldown
local GetItemInfo = _G.GetItemInfo
local GetItemCount = _G.GetItemCount
local GetItemIcon = _G.GetItemIcon
local IsCurrentItem = _G.IsCurrentItem
local IsItemInRange = _G.IsItemInRange
local IsEquippableItem = _G.IsEquippableItem

local GetPetActionInfo = _G.GetPetActionInfo
local GetPetActionsUsable = _G.GetPetActionsUsable
local GetPetActionSlotUsable = _G.GetPetActionSlotUsable
local GetPetActionCooldown = _G.GetPetActionCooldown

local GetPossessInfo = _G.GetPossessInfo

local ShowOverlayGlow = ActionButton_ShowOverlayGlow
local HideOverlayGlow = ActionButton_HideOverlayGlow

local CopyTable = CopyTable
local sIndex = R.sIndex
local cIndex = R.cIndex
local iIndex = R.iIndex
local GetChildrenAndRegions = R.GetChildrenAndRegions

local STANDARD_TEXT_FONT = STANDARD_TEXT_FONT

local tooltipScan = RazerOrbweaverTooltipScan
local tooltipScanTextLeft2 = RazerOrbweaverTooltipScanTextLeft2

local currMacro = {}

local buttonKeybinds = {

	hotKeys = ":",
	hotKeyText = ":",
}

local stateData = {

	macro_Text = "",
	macro_Icon = false,
	macro_Name = "",
	macro_Auto = false,
	macro_Watch = false,
	macro_Equip = false,
}

local specKeyData = {

	move = false,
	keymap = false,
	vehicle = false,
}

local buttonData = { [1] = { homestate = CopyTable(stateData) } }

R.RazerActions = {
	[1] = { "Interface\\Icons\\misc_arrowlup", "MOVEFORWARD" },
	[2] = { "Interface\\Icons\\misc_arrowdown", "MOVEBACKWARD" },
	[3] = { "Interface\\AddOns\\RazerOrbweaver\\Images\\rotate_left.tga", "TURNLEFT" },
	[4] = { "Interface\\AddOns\\RazerOrbweaver\\Images\\rotate_right.tga", "TURNRIGHT" },
	[5] = { "Interface\\Icons\\misc_arrowleft", "STRAFELEFT" },
	[6] = { "Interface\\Icons\\misc_arrowright", "STRAFERIGHT" },
	[7] = { "Interface\\Icons\\ACHIEVEMENT_GUILDPERK_FASTTRACK", "JUMP" },
	[8] = { "Interface\\MacroFrame\\MacroFrame-Icon", "" },
	[9] = { "Interface\\ICONS\\Spell_Nature_WispSplodeGreen", "" },
}

--R.SpecialActions = { vehicle = "Interface\\AddOns\\RazerOrbweaver\\Images\\vehicle_exit", possess = "Interface\\Icons\\Spell_Shadow_SacrificialShield", default = "Interface\\ICONS\\INV_Misc_EngGizmos_27" }
R.SpecialActions = { vehicle = "Interface\\Vehicles\\UI-Vehicles-Button-Exit-Up", possess = "Interface\\Icons\\Spell_Shadow_SacrificialShield", default = "Interface\\ICONS\\INV_Misc_EngGizmos_27" }

local RazerActions, SpecialActions = R.RazerActions, R.SpecialActions

-- Moonfire: 8921
-- Solar Eclipse: 48517
-- Sunfire: 93402

-- Holy Word: Chastise: 88625
-- Chakra: 14751
-- Chakra: Prayer of Healing: 81206 - 88685
-- Chakra: Renew: 81207 - 88682
-- Chakra: Heal: 81208 - 88684

local morphSpells = {
	[8921] = false,
	[88625] = false,
}

local unitAuras = { player = {}, target = {}, focus = {} }

local alphaTimer, alphaDir = 0, 0

local autoCast = { speeds = { 2, 4, 6, 8 }, timers = { 0, 0, 0, 0 }, circle = { 0, 22, 44, 66 }, shines = {}, r = 0.95, g = 0.95, b = 0.32 }

local cooldowns, cdAlphas = {}, {}

local movers = {}

local function MoveForward_Down()

	if (movers[1]) then
		movers[1]:SetButtonState("PUSHED", 1)
	end

end

local function MoveForward_Up()

	if (movers[1]) then
		movers[1]:SetButtonState("NORMAL")
	end

end

local function MoveBackward_Down()

	if (movers[2]) then
		movers[2]:SetButtonState("PUSHED", 1)
	end

end

local function MoveBackward_Up()

	if (movers[2]) then
		movers[2]:SetButtonState("NORMAL")
	end

end

local function TurnLeft_Down()

	if (movers[3]) then
		movers[3]:SetButtonState("PUSHED", 1)
	end

end

local function TurnLeft_Up()

	if (movers[3]) then
		movers[3]:SetButtonState("NORMAL")
	end

end

local function TurnRight_Down()

	if (movers[4]) then
		movers[4]:SetButtonState("PUSHED", 1)
	end

end

local function TurnRight_Up()

	if (movers[4]) then
		movers[4]:SetButtonState("NORMAL")
	end

end

local function StrafeLeft_Down()

	if (movers[5]) then
		movers[5]:SetButtonState("PUSHED", 1)
	end

end

local function StrafeLeft_Up()

	if (movers[5]) then
		movers[5]:SetButtonState("NORMAL")
	end

end

local function StrafeRight_Down()

	if (movers[6]) then
		movers[6]:SetButtonState("PUSHED", 1)
	end

end

local function StrafeRight_Up()

	if (movers[6]) then
		movers[6]:SetButtonState("NORMAL")
	end

end

local function JumpOrAscend_Down()

	if (movers[7]) then
		movers[7]:SetButtonState("PUSHED", 1)
	end

end

local function JumpOrAscend_Up()

	if (movers[7]) then
		movers[7]:SetButtonState("NORMAL")
	end

end

local function AutoCastStart(shine, r, g, b)

	autoCast.shines[shine] = shine

	if (not r) then
		r, g, b = autoCast.r, autoCast.g, autoCast.b
	end

	for _,sparkle in pairs(shine.sparkles) do
		sparkle:Show(); sparkle:SetVertexColor(r, g, b)
	end
end

local function AutoCastStop(shine)

	autoCast.shines[shine] = nil

	for _,sparkle in pairs(shine.sparkles) do
		sparkle:Hide()
	end
end

local function controlOnUpdate(self, elapsed)

	for i in next,autoCast.timers do

		autoCast.timers[i] = autoCast.timers[i] + elapsed

		if ( autoCast.timers[i] > autoCast.speeds[i]*4 ) then
			autoCast.timers[i] = 0
		end

	end

	for i in next,autoCast.circle do

		autoCast.circle[i] = autoCast.circle[i] - i

		if ( autoCast.circle[i] < 0 ) then
			autoCast.circle[i] = 359
		end

	end

	for shine in next, autoCast.shines do

		local distance, radius = shine:GetWidth(), shine:GetWidth()/2.7

		for i=1,4 do

			local timer, speed, degree, x, y, position = autoCast.timers[i], autoCast.speeds[i], autoCast.circle[i]

			if ( timer <= speed ) then

				if (shine.shape == "round") then

					x = ((radius)*(4/pi))*(cos(degree)); y = ((radius)*(4/pi))*(sin(degree))
					shine.sparkles[0+i]:SetPoint("CENTER", shine, "CENTER", x, y)

					x = ((radius)*(4/pi))*(cos(degree-90)); y = ((radius)*(4/pi))*(sin(degree-90))
					shine.sparkles[4+i]:SetPoint("CENTER", shine, "CENTER", x, y)

					x = ((radius)*(4/pi))*(cos(degree-180)); y = ((radius)*(4/pi))*(sin(degree-180))
					shine.sparkles[8+i]:SetPoint("CENTER", shine, "CENTER", x, y)

					x = ((radius)*(4/pi))*(cos(degree-270)); y = ((radius)*(4/pi))*(sin(degree-270))
					shine.sparkles[12+i]:SetPoint("CENTER", shine, "CENTER", x, y)

				else

					position = timer/speed*distance

					shine.sparkles[0+i]:SetPoint("CENTER", shine, "TOPLEFT", position, 0)
					shine.sparkles[4+i]:SetPoint("CENTER", shine, "BOTTOMRIGHT", -position, 0)
					shine.sparkles[8+i]:SetPoint("CENTER", shine, "TOPRIGHT", 0, -position)
					shine.sparkles[12+i]:SetPoint("CENTER", shine, "BOTTOMLEFT", 0, position)
				end

			elseif (timer <= speed*2) then

				if (shine.shape == "round") then

					x = ((radius)*(4/pi))*(cos(degree)); y = ((radius)*(4/pi))*(sin(degree))
					shine.sparkles[0+i]:SetPoint("CENTER", shine, "CENTER", x, y)

					x = ((radius)*(4/pi))*(cos(degree+90)); y = ((radius)*(4/pi))*(sin(degree+90))
					shine.sparkles[4+i]:SetPoint("CENTER", shine, "CENTER", x, y)

					x = ((radius)*(4/pi))*(cos(degree+180)); y = ((radius)*(4/pi))*(sin(degree+180))
					shine.sparkles[8+i]:SetPoint("CENTER", shine, "CENTER", x, y)

					x = ((radius)*(4/pi))*(cos(degree+270)); y = ((radius)*(4/pi))*(sin(degree+270))
					shine.sparkles[12+i]:SetPoint("CENTER", shine, "CENTER", x, y)

				else

					position = (timer-speed)/speed*distance

					shine.sparkles[0+i]:SetPoint("CENTER", shine, "TOPRIGHT", 0, -position)
					shine.sparkles[4+i]:SetPoint("CENTER", shine, "BOTTOMLEFT", 0, position)
					shine.sparkles[8+i]:SetPoint("CENTER", shine, "BOTTOMRIGHT", -position, 0)
					shine.sparkles[12+i]:SetPoint("CENTER", shine, "TOPLEFT", position, 0)

				end

			elseif (timer <= speed*3) then

				if (shine.shape == "round") then

					x = ((radius)*(4/pi))*(cos(degree)); y = ((radius)*(4/pi))*(sin(degree))
					shine.sparkles[0+i]:SetPoint("CENTER", shine, "CENTER", x, y)

					x = ((radius)*(4/pi))*(cos(degree+90)); y = ((radius)*(4/pi))*(sin(degree+90))
					shine.sparkles[4+i]:SetPoint("CENTER", shine, "CENTER", x, y)

					x = ((radius)*(4/pi))*(cos(degree+180)); y = ((radius)*(4/pi))*(sin(degree+180))
					shine.sparkles[8+i]:SetPoint("CENTER", shine, "CENTER", x, y)

					x = ((radius)*(4/pi))*(cos(degree+270)); y = ((radius)*(4/pi))*(sin(degree+270))
					shine.sparkles[12+i]:SetPoint("CENTER", shine, "CENTER", x, y)

				else

					position = (timer-speed*2)/speed*distance

					shine.sparkles[0+i]:SetPoint("CENTER", shine, "BOTTOMRIGHT", -position, 0)
					shine.sparkles[4+i]:SetPoint("CENTER", shine, "TOPLEFT", position, 0)
					shine.sparkles[8+i]:SetPoint("CENTER", shine, "BOTTOMLEFT", 0, position)
					shine.sparkles[12+i]:SetPoint("CENTER", shine, "TOPRIGHT", 0, -position)

				end

			else

				if (shine.shape == "round") then

					x = ((radius)*(4/pi))*(cos(degree)); y = ((radius)*(4/pi))*(sin(degree))
					shine.sparkles[0+i]:SetPoint("CENTER", shine, "CENTER", x, y)

					x = ((radius)*(4/pi))*(cos(degree+90)); y = ((radius)*(4/pi))*(sin(degree+90))
					shine.sparkles[4+i]:SetPoint("CENTER", shine, "CENTER", x, y)

					x = ((radius)*(4/pi))*(cos(degree+180)); y = ((radius)*(4/pi))*(sin(degree+180))
					shine.sparkles[8+i]:SetPoint("CENTER", shine, "CENTER", x, y)

					x = ((radius)*(4/pi))*(cos(degree+270)); y = ((radius)*(4/pi))*(sin(degree+270))
					shine.sparkles[12+i]:SetPoint("CENTER", shine, "CENTER", x, y)

				else

					position = (timer-speed*3)/speed*distance

					shine.sparkles[0+i]:SetPoint("CENTER", shine, "BOTTOMLEFT", 0, position)
					shine.sparkles[4+i]:SetPoint("CENTER", shine, "TOPRIGHT", 0, -position)
					shine.sparkles[8+i]:SetPoint("CENTER", shine, "TOPLEFT", position, 0)
					shine.sparkles[12+i]:SetPoint("CENTER", shine, "BOTTOMRIGHT", -position, 0)

				end
			end
		end
	end

	alphaTimer = alphaTimer + elapsed * 2.5

	if (alphaDir == 1) then
		if (1-alphaTimer <= 0) then
			alphaDir = 0; alphaTimer = 0
		end
	else
		if (alphaTimer >= 1) then
			alphaDir = 1; alphaTimer = 0
		end
	end

	if (MacroDrag[0]) then
		SetCursor(MacroDrag.texture)
	end
end

local function cooldownsOnUpdate(self, elapsed)

	local coolDown, formatted, size

	for cd in next,cooldowns do

		coolDown = floor(cd.duration-(GetTime()-cd.start))
		formatted, size = coolDown, cd.button:GetWidth()*0.45

		if (coolDown < 1) then

			if (coolDown < 0) then

				cooldowns[cd] = nil

				cd.timer:Hide()
				cd.timer:SetText("")
				cd.timerCD = nil
				cd.expirecolor = nil
				cd.cdsize = nil
				cd.active = nil
				cd.expiry = nil

			elseif (coolDown >= 0) then

				cd.timer:SetAlpha(cd.duration-(GetTime()-cd.start))

				if (cd.alphafade) then
					cd:SetAlpha(cd.duration-(GetTime()-cd.start))
				end

			end

		elseif (cd.timer:IsShown() and coolDown ~= cd.timerCD) then

			if (coolDown >= 86400) then
				formatted = ceil(coolDown/86400)
				formatted = formatted.."d"; size = cd.button:GetWidth()*0.3
			elseif (coolDown >= 3600) then
				formatted = ceil(coolDown/3600)
				formatted = formatted.."h"; size = cd.button:GetWidth()*0.3
			elseif (coolDown >= 60) then
				formatted = ceil(coolDown/60)
				formatted = formatted.."m"; size = cd.button:GetWidth()*0.3
			elseif (coolDown < 6) then
				size = cd.button:GetWidth()*0.6
				if (cd.expirecolor) then
					cd.timer:SetTextColor(cd.expirecolor[1], cd.expirecolor[2], cd.expirecolor[3]); cd.expirecolor = nil
					cd.expiry = true
				end
			end

			if (not cd.cdsize or cd.cdsize ~= size) then
				cd.timer:SetFont(STANDARD_TEXT_FONT, size, "OUTLINE"); cd.cdsize = size
			end

			cd.timerCD = coolDown
			cd.timer:SetAlpha(1)
			cd.timer:SetText(formatted)

		end
	end

	for cd in next,cdAlphas do

		coolDown = ceil(cd.duration-(GetTime()-cd.start))

		if (coolDown < 1) then

			cdAlphas[cd] = nil
			cd.button:SetAlpha(1)
			cd.alphaOn = nil

		elseif (not cd.alphaOn) then

			cd.button:SetAlpha(cd.button.cdAlpha)
			cd.alphaOn = true
		end
	end

end

-- Moonfire: 8921
-- Solar Eclipse: 48517
-- Sunfire: 93402

-- Holy Word: Chastise: 88625
-- Chakra: 14751
-- Chakra: Prayer of Healing: 81206 - 88685
-- Chakra: Renew: 81207 - 88682
-- Chakra: Heal: 81208 - 88684

local morphSpells = {
	[8921] = false,
	[88625] = false,
}

local function updateAuraInfo(unit)

	local index, _, spell, count, duration, timeLeft, caster, spellID = 1

	wipe(unitAuras[unit])

	repeat
		spell, _, _, count, _, duration, timeLeft, caster, _, _, spellID = UnitAura(unit, index, "HELPFUL")

		if (duration and (caster == "player" or caster == "pet")) then
			unitAuras[unit][spell:lower()] = "buff"..":"..duration..":"..timeLeft..":"..count
			unitAuras[unit][spell:lower().."()"] = "buff"..":"..duration..":"..timeLeft..":"..count
		end

		-- temp fix to detect mighty morphing power spells
		    if (spellID == 48517) then morphSpells[8921] = 93402
		elseif (spellID == 81206) then morphSpells[88625] = 88685
		elseif (spellID == 81207) then morphSpells[88625] = 88682
		elseif (spellID == 81208) then morphSpells[88625] = 88684
		end

		index = index + 1

   	until (not spell)

	index = 1

	repeat

		spell, _, _, count, _, duration, timeLeft, caster = UnitAura(unit, index, "HARMFUL")

		if (duration and (caster == "player" or caster == "pet")) then
			unitAuras[unit][spell:lower()] = "debuff"..":"..duration..":"..timeLeft..":"..count
			unitAuras[unit][spell:lower().."()"] = "debuff"..":"..duration..":"..timeLeft..":"..count
		end

		index = index + 1

	until (not spell)
end

local function isActiveShapeshiftSpell(spell)

	local shapeshift, texture, name, isActive = spell:match("^[^(]+")

	if (shapeshift) then
		for i=1, GetNumShapeshiftForms() do
			texture, name, isActive = GetShapeshiftFormInfo(i)
			if (isActive and name:lower() == shapeshift:lower()) then
				return texture
			end
		end
	end
end

local function checkCursor(self, button)

	if (MacroDrag[0]) then

		if (button == "LeftButton" or button == "RightButton") then

			MacroDrag[0] = false; SetCursor(nil); PlaySound("igSpellBookSpellIconDrop")
		else
			SetCursor(MacroDrag.texture)
		end
	end
end

function BUTTON:SetTimer(cd, start, duration, enable, timer, color1, color2, cdAlpha)

	if ( start and start > 0 and duration > 0 and enable > 0) then

		cd:SetAlpha(1)

		CooldownFrame_SetTimer(cd, start, duration, enable)

		if (duration >= DB.timerLimit) then

			cd.duration = duration
			cd.start = start
			cd.active = true

			if (timer) then
				cd.timer:Show()
				if (not cd.expiry) then
					cd.timer:SetTextColor(color1[1], color1[2], color1[3])
				end
				cd.expirecolor = color2
			end

			cooldowns[cd] = true

			if (cdAlpha) then
				cdAlphas[cd] = true
			end

		elseif (cooldowns[cd]) then
			cd.duration = 1
		end
	else
		cd.duration = 0; cd.start = 0; CooldownFrame_SetTimer(cd, 0, 0, 0)
	end
end

function BUTTON:MACRO_HasAction()

	local hasAction = self.data.macro_Text

	if (hasAction and #hasAction>0) then
		return true
	elseif (self.sdata.move or self.sdata.keymap or self.actionID) then
		return true
	else
		return false
	end
end

function BUTTON:MACRO_GetDragAction()

	if (self.sdata.move) then
		return "move_"..self.sdata.move
	elseif (self.sdata.keymap) then
		return "keymap_"..self.sdata.keymap
	else
		return "macro"
	end
end

function BUTTON:MACRO_CheckVehicleKeys(action, index)

	for _,button in pairs(BTNIndex) do

		if (button.sdata and button.sdata[action] == index and button ~= self) then

			button.sdata[action] = false
			button.keymaptext:SetText("")
			button.keymaptext:Hide()
			button:SetType(true)

		end
	end
end

function BUTTON:MACRO_CheckSpecialKeys(action, index)

	if (action == "macro") then
		self.sdata.move = false; self.sdata.keymap = false; return
	elseif (action == "move") then
		self.sdata.keymap = false
	elseif (action == "keymap") then
		self.sdata.move = false
	end

	if (index) then

		for _,button in pairs(BTNIndex) do
			if (button.sdata and button.sdata[action] == index and button ~= self) then

				button.sdata[action] = false
				button.keymaptext:SetText("")
				button.keymaptext:Hide()
				button:SetType(true)
				if (action == "move") then
					button.binder:ApplyBindings(button)
				end
			end
		end

		if (self.sdata.move) then
			self.binder:ApplyBindings(self)
		end
	end
end

function BUTTON:MACRO_UpdateSpecialKeys()

	local texture

	if (self.vehicle_edit) then

		if (self.sdata.move) then

			local index = tonumber(self.sdata.move)

			if (index) then
				movers[index] = nil
			end
		end

		texture = "Interface\\BUTTONS\\UI-GroupLoot-Pass-Down"

		self.iconframeicon:SetVertexColor(1,1,1)

		self.keymaptext:SetText("")
		self.keymaptext:Hide()

	elseif (self.sdata.move) then

		local index = tonumber(self.sdata.move)

		if (index) then

			texture = RazerActions[index][1]

			movers[index] = self
		end

	elseif (self.sdata.keymap) then

		if (tonumber(self.sdata.keymap) == KeyMap:GetAttribute("keymap")) then
			texture = RazerActions[9][1]
			self.iconframeicon:SetVertexColor(1,1,1)
		else
			texture = RazerActions[8][1]
			self.iconframeicon:SetVertexColor(0,0.5,0)
		end

		self.keymaptext:SetText(self.sdata.keymap)
		self.keymaptext:Show()
	end

	self:SetChecked(nil)

	self.iconframeicon:SetTexCoord(0.05,0.95,0.05,0.95)
	self.iconframeicon:SetTexture(texture or "")
	self.iconframeicon:Show()

end

function BUTTON:MACRO_UpdateData(...)

	if (self.macroparse) then

		local parse, spell, spellcmd, show, showcmd, item, target, _ = self.macroparse

		for cmd, options in gmatch(parse, "(%c%p%a+)(%C+)") do

			--after gmatch, remove unneeded characters
			if (cmd) then cmd = cmd:gsub("^%c+", "") end
			if (options) then options = options:gsub("^%s+", "") end

			--find #show option!
			if (not show and cmd:find("^#show")) then
				show = SecureCmdOptionParse(options); showcmd = cmd
			--sometimes SecureCmdOptionParse will return "" since that is not what we want, keep looking
			elseif (show and #show < 1 and cmd:find("^#show")) then
				show = SecureCmdOptionParse(options); showcmd = cmd
			end

			--find the spell!
			if (not spell and cmdSlash[cmd]) then
				spell, target = SecureCmdOptionParse(options); spellcmd = cmd
			elseif (spell and #spell < 1) then
				spell, target = SecureCmdOptionParse(options); spellcmd = cmd
			end
   		end

   		if (spell and spellcmd:find("/castsequence")) then
     			_, item, spell = QueryCastSequence(spell)
     		elseif (spell) then
     		     	if (#spell < 1) then
     				spell = nil
     			elseif(GetItemInfo(spell) or ItemCache[spell]) then
     				item = spell; spell = nil
     			elseif(tonumber(spell) and GetInventoryItemLink("player", spell)) then
     				item = GetInventoryItemLink("player", spell); spell = nil
     			end
     		end

     		self.unit = target or "target"

		if (spell) then
			self.macroitem = nil
			if (spell ~= self.macrospell) then
				spell = spell:gsub("!", ""); self.macrospell = spell

				if (sIndex[spell:lower()]) then
					self.spellID = sIndex[spell:lower()].spellID
				else
					self.spellID = nil
				end
			end
		else
			self.macrospell = nil; self.spellID = nil
		end

		if (show and showcmd:find("#showicon")) then
			if (show ~= self.macroicon) then
     				if(tonumber(show) and GetInventoryItemLink("player", show)) then
     					show = GetInventoryItemLink("player", show)
     				end
				self.macroicon = show; self.macroshow = nil
			end
		elseif (show) then
			if (show ~= self.macroshow) then
     				if(tonumber(show) and GetInventoryItemLink("player", show)) then
     					show = GetInventoryItemLink("player", show)
     				end
				self.macroshow = show; self.macroicon = nil
			end
		else
			self.macroshow = nil; self.macroicon = nil
		end

		if (item) then
			self.macrospell = nil; self.spellID = nil
			if (item ~= self.macroitem) then
				self.macroitem = item
			end
		else
			self.macroitem = nil
		end
	end
end

function BUTTON:MACRO_SetSpellIcon(spell)

	local _, texture

	if (not self.data.macro_Icon) then

		spell = (spell):lower()

		if (sIndex[spell]) then

			local spell_id = sIndex[spell].spellID

			if (morphSpells[spell_id]) then
				texture = GetSpellTexture(morphSpells[spell_id])
			elseif spell_id then
				texture = GetSpellTexture(spell_id)
			end

		elseif (cIndex[spell]) then

			texture = cIndex[spell].icon

		elseif (spell) then
			texture = GetSpellTexture(spell)
		end

		if (texture) then

			local shapeshift = isActiveShapeshiftSpell(spell)

			if (shapeshift) then
				self.iconframeicon:SetTexture(shapeshift)
			else
				self.iconframeicon:SetTexture(texture)

			end

			self.iconframeicon:Show()
		else
			self.iconframeicon:SetTexture("")
			self.iconframeicon:Hide()
		end

	else

		if (self.data.macro_Watch) then
			_, texture = GetMacroInfo(self.data.macro_Watch)

		end

		if (self.data.macro_Equip) then
			texture = GetEquipmentSetInfoByName(self.data.macro_Equip)

		end

		if (texture) then
			self.iconframeicon:SetTexture(texture)
		else
			self.iconframeicon:SetTexture("INTERFACE\\ICONS\\INV_MISC_QUESTIONMARK")
		end

	end

	return texture

end

function BUTTON:MACRO_SetItemIcon(item)

	local _,texture, link, itemID

	if (IsEquippedItem(item)) then

		self.border:SetVertexColor(0, 1.0, 0, 0.5)
		self.border:Show()

	else
		self.border:Hide()
	end

	if (not self.data.macro_Icon) then

		_, link, _, _, _, _, _, _, _, texture = GetItemInfo(item)

		if (link and not ItemCache[item]) then

			_, itemID = (":"):split(link)

			if (itemID) then
				ItemCache[item] = itemID
			end
		end

		if (not texture) then

			if (ItemCache[item]) then
				texture = GetItemIcon("item:"..ItemCache[item]..":0:0:0:0:0:0:0")
			end
		end

		if (texture) then

			self.iconframeicon:SetTexture(texture)
			self.iconframeicon:Show()
		else

			self.iconframeicon:SetTexture("")
			self.iconframeicon:Hide()
		end
	else

		self.iconframeicon:SetTexture("")
		self.iconframeicon:Hide()
	end

	return texture

end

function BUTTON:ACTION_SetIcon(action)

	local actionID = tonumber(action)

	if (actionID) then

		local texcoord

		if (actionID == 0) then

			if (SpecialActions[self:GetAttribute("SpecialAction")]) then
				self.iconframeicon:SetTexture(SpecialActions[self:GetAttribute("SpecialAction")])

				if (self:GetAttribute("SpecialAction") == "vehicle") then
					self.iconframeicon:SetTexCoord(0.140625,0.859375,0.140625,0.859375); texcoord = true
				end
			else
				self.iconframeicon:SetTexture(0,0,0)
			end

		else
			self.macroname:SetText(GetActionText(actionID))

			if (HasAction(actionID)) then
				self.iconframeicon:SetTexture(GetActionTexture(actionID))
			else
				self.iconframeicon:SetTexture(0,0,0)
			end
		end

		self.iconframeicon:Show()

		if (not texcoord) then
			self.iconframeicon:SetTexCoord(0,1,0,1)
		end
	else
		self.iconframeicon:SetTexture("")
		self.iconframeicon:Hide()
	end

	return self.iconframeicon:GetTexture()

end

function BUTTON:MACRO_UpdateIcon(...)

	self.updateMacroIcon = nil

	local spell, item, show, texture = self.macrospell, self.macroitem, self.macroshow or self.macroicon

	if (self.vehicle_edit) then

		if (self.sdata.vehicle) then

			local texcoord
			local action = tonumber(self.sdata.vehicle)

			if (action) then
				self.iconframeicon:SetTexture(SpecialActions.default)
				self.keymaptext:SetText(action)
				self.keymaptext:Show()
			elseif (self.sdata.vehicle == "exit") then
				self.iconframeicon:SetTexture(SpecialActions.vehicle)
				self.iconframeicon:SetTexCoord(0.140625,0.859375,0.140625,0.859375); texcoord = true
			else
				self.iconframeicon:SetTexture(0,0,0)
			end

			self:MACRO_UpdateTexture(true)

			if (not texcoord) then
				self.iconframeicon:SetTexCoord(0,1,0,1)
			end
		else
			self.iconframeicon:SetTexture(0,0,0)
		end

		self.iconframeicon:Show()

		return ""

	elseif (self.actionID) then

		texture = self:ACTION_SetIcon(self.actionID)

	elseif (show and #show>0) then

    		if(GetItemInfo(show) or ItemCache[show]) then
			texture = self:MACRO_SetItemIcon(show)
    		else
			texture = self:MACRO_SetSpellIcon(show)
    		end

	elseif (spell and #spell>0) then

		texture = self:MACRO_SetSpellIcon(spell)

	elseif (item and #item>0) then

		texture = self:MACRO_SetItemIcon(item)

	elseif (#self.data.macro_Text > 0) then

		local equipset = self.data.macro_Text:match("/equipset%s+(%C+)")

		if (equipset) then

			equipset = equipset:gsub("%pnobtn:2%p ", "")

			local icon, _, isEquipped = GetEquipmentSetInfoByName(equipset)

			if (isEquipped) then
				self.border:Show()
			else
				self.border:Hide()
			end

			if (icon) then
				self.iconframeicon:SetTexture("INTERFACE\\ICONS\\"..icon:upper())
			end

		elseif (self.data.macro_Icon) then

			self.iconframeicon:SetTexture(self.data.macro_Icon)

		else

			self.iconframeicon:SetTexture("INTERFACE\\ICONS\\INV_MISC_QUESTIONMARK")
		end

		self.iconframeicon:Show()

    	elseif (self.sdata.move or self.sdata.keymap) then

    		--do nothing

	else
		self.iconframeicon:SetTexture("")
		self.iconframeicon:Hide()
		self.border:Hide()
	end

	if (self.spellID and IsSpellOverlayed(self.spellID)) then
		self:MACRO_StartGlow()
	elseif (self.glowing) then
		self:MACRO_StopGlow()
	end

	return texture
end

function BUTTON:MACRO_StartGlow()

	if (self.spellGlowDef) then
		ShowOverlayGlow(self)
	elseif (self.spellGlowAlt) then
		AutoCastStart(self.shine)
	end

	self.glowing = true

end

function BUTTON:MACRO_StopGlow()

	if (self.spellGlowDef) then
		HideOverlayGlow(self)
	elseif (self.spellGlowAlt) then
		AutoCastStop(self.shine)
	end

	self.glowing = nil
end


function BUTTON:MACRO_SetSpellState(spell)

	if (self.vehicle_edit) then
		self.count:SetText("")
		self:SetChecked(nil)
		self.mac_flash = false
		return
	end

	if (GetSpellCount(spell) and  GetSpellCount(spell) > 1) then

		self.count:SetText(GetSpellCount(spell))
	else
		self.count:SetText("")
	end

	if (cIndex[spell:lower()]) then

		spell = cIndex[spell:lower()].spellID

		if (IsCurrentSpell(spell) or IsAutoRepeatSpell(spell)) then
			self:SetChecked(1)
		else
			self:SetChecked(nil)
		end
	else

		if (IsCurrentSpell(spell) or IsAutoRepeatSpell(spell) or isActiveShapeshiftSpell(spell:lower())) then
			self:SetChecked(1)
		else
			self:SetChecked(nil)
		end
	end

	if ((IsAttackSpell(spell) and IsCurrentSpell(spell)) or IsAutoRepeatSpell(spell)) then
		self.mac_flash = true
	else
		self.mac_flash = false
	end
end

function BUTTON:MACRO_SetItemState(item)

	if (GetItemCount(item,nil,true) and  GetItemCount(item,nil,true) > 1) then
		self.count:SetText(GetItemCount(item,nil,true))
	else
		self.count:SetText("")
	end

	if(IsCurrentItem(item)) then
		self:SetChecked(1)
	else
		self:SetChecked(nil)
	end
end

function BUTTON:ACTION_UpdateState(action)

	local actionID = tonumber(action)

	self.count:SetText("")

	if (actionID) then

		if (IsCurrentAction(actionID) or IsAutoRepeatAction(actionID)) then
			self:SetChecked(1)
		else
			self:SetChecked(nil)
		end

		if ((IsAttackAction(actionID) and IsCurrentAction(actionID)) or IsAutoRepeatAction(actionID)) then
			self.mac_flash = true
		else
			self.mac_flash = false
		end
	else
		self:SetChecked(nil)
		self.mac_flash = false
	end
end

function BUTTON:MACRO_UpdateState(...)

	local spell, item, show = self.macrospell, self.macroitem, self.macroshow

	self.macroname:SetText(self.data.macro_Name)

	if (self.actionID) then

		self:ACTION_UpdateState(self.actionID)

	elseif (show and #show>0) then

    		if(GetItemInfo(show) or ItemCache[show]) then
			self:MACRO_SetItemState(show)
    		else
			self:MACRO_SetSpellState(show)
    		end

	elseif (spell and #spell>0) then

		self:MACRO_SetSpellState(spell)

	elseif (item and #item>0) then

		self:MACRO_SetItemState(item)

	elseif (self:GetAttribute("macroShow")) then

		show = self:GetAttribute("macroShow")

    		if(GetItemInfo(show) or ItemCache[show]) then
			self:MACRO_SetItemState(show)
    		else
			self:MACRO_SetSpellState(show)
    		end
	else
		self:SetChecked(nil)
		self.count:SetText("")
	end
end

function BUTTON:MACRO_UpdateAuraWatch(unit, spell)

	if (self.vehicle_edit) then
		self:SetTimer(self.iconframeaurawatch, 0, 0, 0, self.auraText)
		return
	end

	if (spell and (unit == self.unit or unit == "player")) then

		if (self.spellID and morphSpells[self.spellID]) then
			spell = GetSpellInfo(morphSpells[self.spellID])
		end

		spell = spell:gsub("%s*%(.+%)", ""):lower()

		if (unitAuras[unit][spell]) then

			uaw_auraType, uaw_duration, uaw_timeLeft, uaw_count = (":"):split(unitAuras[unit][spell])

			uaw_duration = tonumber(uaw_duration); uaw_timeLeft = tonumber(uaw_timeLeft)

			if (self.auraInd) then

				self.auraBorder = true

				if (uaw_auraType == "buff") then
					self.border:SetVertexColor(self.buffcolor[1], self.buffcolor[2], self.buffcolor[3], 1.0)
				elseif (uaw_auraType == "debuff" and unit == "target") then
					self.border:SetVertexColor(self.debuffcolor[1], self.debuffcolor[2], self.debuffcolor[3], 1.0)
				end

				self.border:Show()
			else
				self.border:Hide()
			end

			uaw_color = self.auracolor1

			if (self.auraText) then

				if (uaw_auraType == "debuff" and (unit == "target" or (unit == "focus" and UnitIsEnemy("player", "focus")))) then
					uaw_color = self.auracolor2
				end

				self.iconframeaurawatch.queueinfo = unit..":"..spell
			else

			end

			if (self.iconframecooldown.timer:IsShown()) then
				self.auraQueue = unit..":"..spell; self.iconframeaurawatch.uaw_duration = 0; self.iconframeaurawatch:Hide()
			elseif (self.auraText) then
				self:SetTimer(self.iconframecooldown, 0, 0, 0)
				self:SetTimer(self.iconframeaurawatch, uaw_timeLeft-uaw_duration, uaw_duration, 1, self.auraText, uaw_color)
			else
				self:SetTimer(self.iconframeaurawatch, 0, 0, 0)
			end

			self.auraWatchUnit = unit

		elseif (self.auraWatchUnit == unit) then

			self.iconframeaurawatch.uaw_duration = 0
			self.iconframeaurawatch:Hide()
			self.iconframeaurawatch.timer:SetText("")
			self.border:Hide()
			self.auraBorder = nil
			self.auraWatchUnit = nil
			self.auraTimer = nil
			self.auraQueue = nil
		end

	elseif (not spell) then
		self:SetTimer(self.iconframeaurawatch, 0, 0, 0)
	end
end

function BUTTON:MACRO_SetSpellCooldown(spell)

	local start, duration, enable

	spell = (spell):lower()

	if (cIndex[spell]) then

		start, duration, enable = GetSpellCooldown(spell)

	elseif (sIndex[spell]) then

		local spell_id = sIndex[spell].spellID

		if (morphSpells[spell_id]) then
			start, duration, enable = GetSpellCooldown(morphSpells[spell_id])
		elseif spell_id then
			start, duration, enable = GetSpellCooldown(spell_id)
		end
	end

	if (duration and duration >= DB.timerLimit and self.iconframeaurawatch.active) then
		self.auraQueue = self.iconframeaurawatch.queueinfo
		self.iconframeaurawatch.duration = 0
		self.iconframeaurawatch:Hide()
	end

	self:SetTimer(self.iconframecooldown, start, duration, enable, self.cdText, self.cdcolor1, self.cdcolor2, self.cdAlpha)

end

function BUTTON:MACRO_SetItemCooldown(item)

	local id = ItemCache[item]

	if (id) then

		local start, duration, enable = GetItemCooldown(id)

		if (duration and duration >= DB.timerLimit and self.iconframeaurawatch.active) then
			self.auraQueue = self.iconframeaurawatch.queueinfo
			self.iconframeaurawatch.duration = 0
			self.iconframeaurawatch:Hide()
		end

		self:SetTimer(self.iconframecooldown, start, duration, enable, self.cdText, self.cdcolor1, self.cdcolor2, self.cdAlpha)
	end
end

function BUTTON:ACTION_SetCooldown(action)

	local actionID = tonumber(action)

	if (actionID) then

		if (HasAction(actionID)) then

			local start, duration, enable = GetActionCooldown(actionID)

			if (duration and duration >= DB.timerLimit and self.iconframeaurawatch.active) then
				self.auraQueue = self.iconframeaurawatch.queueinfo
				self.iconframeaurawatch.duration = 0
				self.iconframeaurawatch:Hide()
			end

			self:SetTimer(self.iconframecooldown, start, duration, enable, self.cdText, self.cdcolor1, self.cdcolor2, self.cdAlpha)
		end
	end
end

function BUTTON:MACRO_UpdateCooldown(update)

	if (self.vehicle_edit) then
		self:SetTimer(self.iconframecooldown, 0, 0, 0, self.cdText, self.cdcolor1, self.cdcolor2, self.cdAlpha)
		return
	end

	local spell, item, show = self.macrospell, self.macroitem, self.macroshow

	if (self.actionID) then

		self:ACTION_SetCooldown(self.actionID)

	elseif (show and #show>0) then

    		if(GetItemInfo(show) or ItemCache[show]) then
			self:MACRO_SetItemCooldown(show)
    		else
			self:MACRO_SetSpellCooldown(show)
    		end

	elseif (spell and #spell>0) then

		self:MACRO_SetSpellCooldown(spell)

	elseif (item and #item>0) then

		self:MACRO_SetItemCooldown(item)

	else

		self:SetTimer(self.iconframecooldown, 0, 0, 0, self.cdText, self.cdcolor1, self.cdcolor2, self.cdAlpha)

	end
end

function BUTTON:MACRO_UpdateTimers(...)

	self:MACRO_UpdateCooldown()

	for k in pairs(unitAuras) do
		self:MACRO_UpdateAuraWatch(k, self.macrospell)
	end

end

function BUTTON:MACRO_UpdateTexture(force)

	local hasAction = self:MACRO_HasAction()

	if (not self:SetSkinned()) then

		if (hasAction or force) then
			self:SetNormalTexture(self.hasAction or "")
			self:GetNormalTexture():SetVertexColor(1,1,1,1)
		else
			self:SetNormalTexture(self.noAction or "")
			self:GetNormalTexture():SetVertexColor(1,1,1,0.5)
		end
	end
end

function BUTTON:MACRO_UpdateAll(updateTexture)

	if (self.sdata.move or self.sdata.keymap) then
		self:MACRO_UpdateSpecialKeys()
	else
		self:MACRO_UpdateData()
		self:MACRO_UpdateButton()
		self:MACRO_UpdateIcon()
		self:MACRO_UpdateState()
		self:MACRO_UpdateTimers()
	end

	if (updateTexture) then
		self:MACRO_UpdateTexture()
	end
end


function BUTTON:MACRO_ACTIONBAR_UPDATE_COOLDOWN(...)

	self:MACRO_UpdateTimers(...)

end

BUTTON.MACRO_RUNE_POWER_UPDATE = BUTTON.MACRO_ACTIONBAR_UPDATE_COOLDOWN


function BUTTON:MACRO_ACTIONBAR_UPDATE_STATE(...)

	self:MACRO_UpdateState(...)

end

BUTTON.MACRO_COMPANION_UPDATE = BUTTON.MACRO_ACTIONBAR_UPDATE_STATE
BUTTON.MACRO_TRADE_SKILL_SHOW = BUTTON.MACRO_ACTIONBAR_UPDATE_STATE
BUTTON.MACRO_TRADE_SKILL_CLOSE = BUTTON.MACRO_ACTIONBAR_UPDATE_STATE
BUTTON.MACRO_ARCHAEOLOGY_CLOSED = BUTTON.MACRO_ACTIONBAR_UPDATE_STATE


function BUTTON:MACRO_BAG_UPDATE_COOLDOWN(...)

	if (self.macroitem) then
		self:MACRO_UpdateState(...)
	end

end

BUTTON.MACRO_BAG_UPDATE = BUTTON.MACRO_BAG_UPDATE_COOLDOWN


function BUTTON:MACRO_UNIT_AURA(...)

	local unit = select(2, ...)

	if (unitAuras[unit]) then

		self:MACRO_UpdateAuraWatch(unit, self.macrospell)

		if (unit == "player") then
			self:MACRO_UpdateData(...)
			self:MACRO_UpdateIcon(...)
		end
	end
end

BUTTON.MACRO_UPDATE_MOUSEOVER_UNIT = BUTTON.MACRO_UNIT_AURA


function BUTTON:MACRO_UNIT_SPELLCAST_INTERRUPTED(...)

	local unit = select(1, ...)

	if ((unit == "player" or unit == "pet") and spell and self.macrospell) then

		self:MACRO_UpdateTimers(...)
	end

end

BUTTON.MACRO_UNIT_SPELLCAST_FAILED = BUTTON.MACRO_UNIT_SPELLCAST_INTERRUPTED
BUTTON.MACRO_UNIT_PET = BUTTON.MACRO_UNIT_SPELLCAST_INTERRUPTED
BUTTON.MACRO_UNIT_ENTERED_VEHICLE = BUTTON.MACRO_UNIT_SPELLCAST_INTERRUPTED
BUTTON.MACRO_UNIT_ENTERING_VEHICLE = BUTTON.MACRO_UNIT_SPELLCAST_INTERRUPTED
BUTTON.MACRO_UNIT_EXITED_VEHICLE = BUTTON.MACRO_UNIT_SPELLCAST_INTERRUPTED


function BUTTON:MACRO_SPELL_ACTIVATION_OVERLAY_GLOW_SHOW(...)

	local spellID = select(2, ...)

	if (self.spellGlow and self.spellID and spellID == self.spellID) then

		self:MACRO_UpdateTimers(...)

		self:MACRO_StartGlow()
	end
end

function BUTTON:MACRO_SPELL_ACTIVATION_OVERLAY_GLOW_HIDE(...)

	local spellID = select(2, ...)

	if ((self.overlay or self.spellGlow) and self.spellID and spellID == self.spellID) then

		self:MACRO_StopGlow()

	end
end

function BUTTON:MACRO_ACTIVE_TALENT_GROUP_CHANGED(...)

	local spec = select(2,...)

	self:LoadData(spec, self:GetParent():GetAttribute("activestate") or "homestate")
	self:SetType()
end

function BUTTON:MACRO_PLAYER_ENTERING_WORLD(...)

	self:MACRO_Reset()
	self:MACRO_UpdateAll(true)

end

function BUTTON:MACRO_MODIFIER_STATE_CHANGED(...)
	self:MACRO_UpdateAll(true)
end

function BUTTON:MACRO_ACTIONBAR_SLOT_CHANGED(...)
	if (self.data.macro_Watch or self.data.macro_Equip) then
		self:MACRO_UpdateIcon()
	end
end

function BUTTON:MACRO_PLAYER_TARGET_CHANGED(...)
	self:MACRO_UpdateTimers()
end

BUTTON.MACRO_PLAYER_FOCUS_CHANGED = BUTTON.MACRO_PLAYER_TARGET_CHANGED

function BUTTON:MACRO_ITEM_LOCK_CHANGED(...)

end

function BUTTON:MACRO_ACTIONBAR_SHOWGRID(...)

end

function BUTTON:MACRO_ACTIONBAR_HIDEGRID(...)

end

function BUTTON:MACRO_UPDATE_MACROS(...)

	if (PEW and not InCombatLockdown() and self.data.macro_Watch) then
		self:MACRO_PlaceBlizzMacro(self.data.macro_Watch)
	end
end

function BUTTON:MACRO_EQUIPMENT_SETS_CHANGED(...)

	if (PEW and not InCombatLockdown() and self.data.macro_Equip) then
		self:MACRO_PlaceBlizzEquipSet(self.data.macro_Equip)
	end
end

function BUTTON:MACRO_PLAYER_EQUIPMENT_CHANGED(...)

	if (self.data.macro_Equip) then
		self:MACRO_UpdateIcon()
	end
end

function BUTTON:MACRO_UPDATE_VEHICLE_ACTIONBAR(...)

	if (self.actionID) then
		self:MACRO_UpdateAll(true)
	end
end

BUTTON.MACRO_UPDATE_POSSESS_BAR = BUTTON.MACRO_UPDATE_VEHICLE_ACTIONBAR
BUTTON.MACRO_UPDATE_OVERRIDE_ACTIONBAR = BUTTON.MACRO_UPDATE_VEHICLE_ACTIONBAR
BUTTON.MACRO_UPDATE_EXTRA_ACTIONBAR = BUTTON.MACRO_UPDATE_VEHICLE_ACTIONBAR

--for 4.x compatibility
BUTTON.MACRO_UPDATE_BONUS_ACTIONBAR = BUTTON.MACRO_UPDATE_VEHICLE_ACTIONBAR

function BUTTON:MACRO_OnEvent(...)

	local event = "MACRO_"..select(1,...)

	if (BUTTON[event]) then
		BUTTON[event](self, ...)
	else
		self:MACRO_UpdateTimers()
	end
end

function BUTTON:MACRO_UpdateUsableSpell(spell)

	local isUsable, notEnoughMana = IsUsableSpell(spell)

	if (notEnoughMana) then

		self.iconframeicon:SetVertexColor(self.manacolor[1], self.manacolor[2], self.manacolor[3])

	elseif (isUsable) then

		if (self.rangeInd and IsSpellInRange(spell, self.unit) == 0) then
			self.iconframeicon:SetVertexColor(self.rangecolor[1], self.rangecolor[2], self.rangecolor[3])
		else
			self.iconframeicon:SetVertexColor(1.0, 1.0, 1.0)
		end

	else
		if (sIndex[(spell):lower()]) then

			self.iconframeicon:SetVertexColor(0.4, 0.4, 0.4)
		else
			self.iconframeicon:SetVertexColor(1.0, 1.0, 1.0)
		end
	end

end

function BUTTON:MACRO_UpdateUsableItem(item)

      local isUsable, notEnoughMana = IsUsableItem(item)

	if (notEnoughMana and self.manacolor) then

		self.iconframeicon:SetVertexColor(self.manacolor[1], self.manacolor[2], self.manacolor[3])

	elseif (isUsable) then

		if (self.rangeInd and IsItemInRange(spell, self.unit) == 0) then
			self.iconframeicon:SetVertexColor(self.rangecolor[1], self.rangecolor[2], self.rangecolor[3])
		else
			self.iconframeicon:SetVertexColor(1.0, 1.0, 1.0)
		end
	else
		self.iconframeicon:SetVertexColor(0.4, 0.4, 0.4)
	end
end

function BUTTON:ACTION_UpdateUsable(action)

	local actionID = tonumber(action)

	if (actionID) then

		if (actionID == 0) then

			self.iconframeicon:SetVertexColor(1.0, 1.0, 1.0)
		else

			local isUsable, notEnoughMana = IsUsableAction(actionID)

			if (isUsable) then

				if (IsActionInRange(action, self.unit) == 0) then
					self.iconframeicon:SetVertexColor(self.rangecolor[1], self.rangecolor[2], self.rangecolor[3])
				else
					self.iconframeicon:SetVertexColor(1.0, 1.0, 1.0)
				end

			elseif (notEnoughMana and self.manacolor) then

				self.iconframeicon:SetVertexColor(self.manacolor[1], self.manacolor[2], self.manacolor[3])

			else
				self.iconframeicon:SetVertexColor(0.4, 0.4, 0.4)
			end
		end

	else
		self.iconframeicon:SetVertexColor(1.0, 1.0, 1.0)
	end
end

function BUTTON:MACRO_UpdateButton(...)

	local spell, item, show = self.macrospell, self.macroitem, self.macroshow

	if (self.vehicle_edit) then

		self.iconframeicon:SetVertexColor(1.0, 1.0, 1.0)

	elseif (self.editmode) then

		self.iconframeicon:SetVertexColor(0.2, 0.2, 0.2)

	elseif (self.actionID) then

		self:ACTION_UpdateUsable(self.actionID)

	elseif (show and #show>0) then

    		if(GetItemInfo(show) or ItemCache[show]) then
			self:MACRO_UpdateUsableItem(show)
    		else
			self:MACRO_UpdateUsableSpell(show)
    		end

	elseif (spell and #spell>0) then

		self:MACRO_UpdateUsableSpell(spell)

	elseif (item and #item>0) then

		self:MACRO_UpdateUsableItem(item)

	else
		self.iconframeicon:SetVertexColor(1.0, 1.0, 1.0)
	end
end

function BUTTON:MACRO_OnUpdate(elapsed)

	if (self.mac_flash) then

		self.mac_flashing = true

		if (alphaDir == 1) then
			if ((1-(alphaTimer)) >= 0) then
				self.iconframeflash:Show()
			end
		elseif (alphaDir == 0) then
			if ((alphaTimer) <= 1) then
				self.iconframeflash:Hide()
			end
		end

	elseif (self.mac_flashing) then

		self.iconframeflash:Hide()
		self.mac_flashing = false
	end

	self.elapsed = self.elapsed + elapsed

	if (self.elapsed > DB.throttle and not self.sdata.keymap) then
		self:MACRO_UpdateButton()
	end

	if (self.auraQueue and not self.iconframecooldown.active) then
		local unit, spell = (":"):split(self.auraQueue)
		if (unit and spell) then
			self.auraQueue = nil; self:MACRO_UpdateAuraWatch(unit, spell)
		end
	end

end

function BUTTON:MACRO_PlaceVehicle()

	if (MacroDrag[0]) then

		local action, index = ("_"):split(MacroDrag[0])

		self.sdata[action] = index

		self:MACRO_CheckVehicleKeys(action, index)

		if (not self.cursor) then
			self:SetType(true)
		end

		self:MACRO_UpdateTexture(true)

		MacroDrag[0] = false

		ClearCursor(); SetCursor(nil)
	end
end

function BUTTON:MACRO_PlaceMacro()

	local action, index = ("_"):split(MacroDrag[0])

	if (action and index) then

		self.sdata.move = MacroDrag[8]
		self.sdata.keymap = MacroDrag[9]

		self.sdata[action] = index

	else
		self.data.macro_Text = MacroDrag[2]
		self.data.macro_Icon = MacroDrag[3]
		self.data.macro_Name = MacroDrag[4]
		self.data.macro_Auto = MacroDrag[5]
		self.data.macro_Watch = MacroDrag[6]
		self.data.macro_Equip = MacroDrag[7]
		self.sdata.move = false
		self.sdata.keymap = false
	end

	self:MACRO_CheckSpecialKeys(action, index)

	if (not self.cursor) then
		self:SetType(true)
	end

	MacroDrag[0] = false

	ClearCursor(); SetCursor(nil)
end

function BUTTON:MACRO_PlaceSpell(action1, action2, hasAction)

	local _, modifier, spell, subName, spellID, texture = " "

	if (action1 == 0) then
		return
	else
	 	_, subName = GetSpellBookItemName(action1, action2)
	 	_, spellID = GetSpellBookItemInfo(action1, action2)

	 	spell = GetSpellInfo(spellID)

	 	self.data.macro_Text = self:AutoWriteMacro(spell, subName)
	 	self.data.macro_Auto = spell..";"..subName
	 	self.data.macro_Icon = false
		self.data.macro_Name = ""
		self.data.macro_Watch = false
		self.data.macro_Equip = false
		self.sdata.move = false
		self.sdata.keymap = false

		if (not self.cursor) then
			self:SetType(true)
		end

		MacroDrag[0] = false

		ClearCursor(); SetCursor(nil)
	end
end

function BUTTON:MACRO_PlaceItem(action1, action2, hasAction)

	local item, link = GetItemInfo(action2)

	if (IsEquippableItem(item)) then
		self.data.macro_Text = "/equip "..item.."\n/use "..item
	else
		self.data.macro_Text = "/use "..item
	end

	self.data.macro_Icon = false
	self.data.macro_Name = ""
	self.data.macro_Auto = false
	self.data.macro_Watch = false
	self.data.macro_Equip = false
	self.sdata.move = false
	self.sdata.keymap = false

	if (not self.cursor) then
		self:SetType(true)
	end

	MacroDrag[0] = false

	ClearCursor(); SetCursor(nil)

end

function BUTTON:MACRO_PlaceBlizzMacro(action1)

	if (action1 == 0) then
		return
	else

	 	local name, icon, body = GetMacroInfo(action1)

	 	if (body) then

	 		self.data.macro_Text = body
	 		self.data.macro_Name = name
	 		self.data.macro_Watch = name
	 		self.data.macro_Icon = icon:upper()
	 	else
	 		self.data.macro_Text = ""
	 		self.data.macro_Name = ""
	 		self.data.macro_Watch = false
	 		self.data.macro_Icon = false
	 	end

		self.data.macro_Equip = false
		self.data.macro_Auto = false
		self.sdata.move = false
		self.sdata.keymap = false

		if (not self.cursor) then
			self:SetType(true)
		end

		MacroDrag[0] = false

		ClearCursor(); SetCursor(nil)
	end
end

function BUTTON:MACRO_PlaceBlizzEquipSet(action1)

	if (action1 == 0) then
		return
	else

	 	local icon = GetEquipmentSetInfoByName(action1)

	 	if (icon) then

	 		self.data.macro_Text = "/equipset "..action1
	 		self.data.macro_Equip = action1
	 		self.data.macro_Icon = iIndex[icon:upper()] or "INTERFACE\\ICONS\\"..icon:upper()
	 	else
	 		self.data.macro_Text = ""
			self.data.macro_Equip = false
	 		self.data.macro_Icon = false
	 	end

 		self.data.macro_Name = ""
 		self.data.macro_Watch = false
		self.data.macro_Auto = false
		self.sdata.move = false
		self.sdata.keymap = false

		if (not self.cursor) then
			self:SetType(true)
		end

		MacroDrag[0] = false

		ClearCursor(); SetCursor(nil)
	end
end

function BUTTON:MACRO_PlaceCompanion(action1, action2, hasAction)

	if (action1 == 0) then
		return
	else

		local _, _, spellID = GetCompanionInfo(action2, action1)
	 	local name = GetSpellInfo(spellID)

	 	if (name) then

	 		self.data.macro_Text = self:AutoWriteMacro(name)
	 		self.data.macro_Auto = name
	 	else
	 		self.data.macro_Text = ""
	 		self.data.macro_Auto = false
	 	end

		self.data.macro_Icon = false
		self.data.macro_Name = ""
		self.data.macro_Watch = false
		self.data.macro_Equip = false

		self.sdata.move = false
		self.sdata.keymap = false

		if (not self.cursor) then
			self:SetType(true)
		end

		MacroDrag[0] = false

		ClearCursor(); SetCursor(nil)
	end
end

function BUTTON:MACRO_PlaceFlyout(action1, action2, hasAction)

	MacroDrag[0] = false

	ClearCursor(); SetCursor(nil)

end

function BUTTON:MACRO_PlaceBattlePet(action1, action2, hasAction)

	local _, petName

	if (action1 == 0) then
		return
	else
	 	_, _, _, _, _, _, petName = C_PetJournal.GetPetInfoByPetID(action1)

	 	self.data.macro_Text = self:AutoWriteMacro(petName)
	 	self.data.macro_Auto = petName..";"
	 	self.data.macro_Icon = false
		self.data.macro_Name = ""
		self.data.macro_Watch = false
		self.data.macro_Equip = false

		self.sdata.move = false
		self.sdata.keymap = false

		if (not self.cursor) then
			self:SetType(true)
		end

		MacroDrag[0] = false

		ClearCursor(); SetCursor(nil)
	end

end

function BUTTON:MACRO_PickUpMacro()

	local pickup = nil

	if (not self.bar.cdata.barLock) then
		pickup = true
	elseif (self.bar.cdata.barLockAlt and IsAltKeyDown()) then
		pickup = true
	elseif (self.bar.cdata.barLockCtrl and IsControlKeyDown()) then
		pickup = true
	elseif (self.bar.cdata.barLockShift and IsShiftKeyDown()) then
		pickup = true
	end

	if (pickup or currMacro[0]) then

		local texture, move = self.iconframeicon:GetTexture()

		if (self.sdata.keymap) then
			texture = RazerActions[8][1]; self.keymaptext:SetText("")
			self.keymaptext:SetText(""); self.keymaptext:Hide()
		end

		if (self.sdata.move) then
			move = self.sdata.move

			if (self.sdata.move == "3" or self.sdata.move == "4") then
				texture = RazerActions[tonumber(self.sdata.move)+2][1]
			end
		end

		wipe(MacroDrag)

		if (currMacro[0]) then

			for k,v in pairs(currMacro) do
				MacroDrag[k] = v
			end

			wipe(currMacro)

			if (MacroDrag[8] == "3" or MacroDrag[8] == "4") then
				MacroDrag.texture = RazerActions[tonumber(MacroDrag[8])+2][1]
			end

			SetCursor(MacroDrag.texture)

		elseif (self:MACRO_HasAction()) then

			MacroDrag[0] = self:MACRO_GetDragAction()
			MacroDrag[1] = self
			MacroDrag[2] = self.data.macro_Text
			MacroDrag[3] = self.data.macro_Icon
			MacroDrag[4] = self.data.macro_Name
			MacroDrag[5] = self.data.macro_Auto
			MacroDrag[6] = self.data.macro_Watch
			MacroDrag[7] = self.data.macro_Equip
			MacroDrag[8] = self.sdata.move
			MacroDrag[9] = self.sdata.keymap
			MacroDrag.texture = texture

			self.data.macro_Text = ""
			self.data.macro_Icon = false
			self.data.macro_Name = ""
			self.data.macro_Auto = false
			self.data.macro_Watch = false
			self.data.macro_Equip = false

			self.sdata.move = false
			self.sdata.keymap = false

			self.macrospell = nil
			self.spellID = nil
			self.macroitem = nil
			self.macroshow = nil
			self.macroicon = nil

			self:SetType(true)

			SetCursor(MacroDrag.texture)
		end

		if (MacroDrag[0]) then

			local action, index = ("_"):split(MacroDrag[0])

			if (action and index and action == "move") then
				self.binder:ApplyBindings(self)
				movers[tonumber(index)] = nil
			end
		end
	end
end

function BUTTON:MACRO_OnReceiveDrag(preclick)

	if (InCombatLockdown()) then UIErrorsFrame:AddMessage(L.DRAG_LOCKED, 1.0, 1.0, 1.0, 1.0, UIERRORS_HOLD_TIME) return end

	if (self.vehicle_edit) then

		if (self.sdata.move or self.sdata.keymap) then

			MacroDrag[0] = false

			ClearCursor(); SetCursor(nil)

		else
			self:MACRO_PlaceVehicle()
		end

	else

		local cursorType, action1, action2, move = GetCursorInfo()

		local texture = self.iconframeicon:GetTexture()

		if (self.sdata.keymap) then
			texture = RazerActions[8][1]
		end

		if (self:MACRO_HasAction()) then

			wipe(currMacro)

			currMacro[0] = self:MACRO_GetDragAction()
			currMacro[1] = self
			currMacro[2] = self.data.macro_Text
			currMacro[3] = self.data.macro_Icon
			currMacro[4] = self.data.macro_Name
			currMacro[5] = self.data.macro_Auto
			currMacro[6] = self.data.macro_Watch
			currMacro[7] = self.data.macro_Equip
			currMacro[8] = self.sdata.move
			currMacro[9] = self.sdata.keymap
			currMacro.texture = texture

			if (self.sdata.move) then
				move = true
			end

		end

		if  (action1 == 0) then

			-- do nothing for now

		else

			if (MacroDrag[0]) then

				self:MACRO_PlaceMacro(); PlaySound("igSpellBookSpellIconDrop")

			elseif (cursorType == "spell") then

				self:MACRO_PlaceSpell(action1, action2, self:MACRO_HasAction())

			elseif (cursorType == "item") then

				self:MACRO_PlaceItem(action1, action2, self:MACRO_HasAction())

			elseif (cursorType == "macro") then

				self:MACRO_PlaceBlizzMacro(action1)

			elseif (cursorType == "equipmentset") then

				self:MACRO_PlaceBlizzEquipSet(action1)

			elseif (cursorType == "companion") then

				self:MACRO_PlaceCompanion(action1, action2, self:MACRO_HasAction())

			elseif (cursorType == "flyout") then

				self:MACRO_PlaceFlyout(action1, action2, self:MACRO_HasAction())

			elseif (cursorType == "battlepet") then

				self:MACRO_PlaceBattlePet(action1, action2, self:MACRO_HasAction())

			end

			--self:MACRO_SetTooltip()

		end

		if (StartDrag and currMacro[0]) then

			self.keymaptext:SetText("")
			self.keymaptext:Hide()

			if (move) then
				self.binder:ApplyBindings(self)
			end

			self:MACRO_PickUpMacro()
		end

		self:MACRO_UpdateAll(true)

	end

	self.elapsed = 0.2

	StartDrag = false

end

function BUTTON:MACRO_OnDragStart(button)

	if (InCombatLockdown() or not self.bar or self.vehicle_edit or self.actionID) then
		if (InCombatLockdown()) then
			UIErrorsFrame:AddMessage(L.DRAG_LOCKED, 1.0, 1.0, 1.0, 1.0, UIERRORS_HOLD_TIME)
		end
		StartDrag = false; return
	end

	self.drag = nil

	if (not self.bar.cdata.barLock) then
		self.drag = true
	elseif (self.bar.cdata.barLockAlt and IsAltKeyDown()) then
		self.drag = true
	elseif (self.bar.cdata.barLockCtrl and IsControlKeyDown()) then
		self.drag = true
	elseif (self.bar.cdata.barLockShift and IsShiftKeyDown()) then
		self.drag = true
	end

	if (self.drag) then

		StartDrag = self:GetParent():GetAttribute("activestate")

		self.dragbutton = button

		self:MACRO_PickUpMacro()

		if (MacroDrag[0]) then

			PlaySound("igSpellBookSpellIconPickup"); self.sound = true

			if (MacroDrag[1] ~= self) then
				self.dragbutton = nil
			end
		else
			self.dragbutton = nil
		end

		self:MACRO_UpdateAll()

		self.iconframecooldown.duration = 0
		self.iconframecooldown.timer:SetText("")
		self.iconframecooldown:Hide()

		self.iconframeaurawatch.duration = 0
		self.iconframeaurawatch.timer:SetText("")
		self.iconframeaurawatch:Hide()

		self.keymaptext:SetText("")
		self.keymaptext:Hide()

		self.macrospell = nil
		self.spellID = nil
		self.macroitem = nil
		self.macroshow = nil
		self.macroicon = nil

		self.auraQueue = nil

		self.border:Hide()

	else
		StartDrag = false
	end
end

function BUTTON:MACRO_OnDragStop(self)
	self.drag = nil
end

function BUTTON:MACRO_PreClick(...)

	self.cursor = nil

	if (not InCombatLockdown() and not self.sdata.move and not self.sdata.keymap) then

		local cursorType = GetCursorInfo()

		if (cursorType or MacroDrag[0]) then

			self.cursor = true
			StartDrag = self:GetParent():GetAttribute("activestate")

			self:SetType(true, true)
			self:MACRO_OnReceiveDrag(true)
		end
	end
end

function BUTTON:MACRO_PostClick(...)

	if (not InCombatLockdown()) then
		if (self.cursor) then
			self.cursor = nil
			self:SetType(true)
		end
	end

	if (self.sdata.keymap) then
		PlaySound("igMainMenuQuit")
	end

	self:MACRO_UpdateState()
	self:MACRO_UpdateTimers()

end

function BUTTON:MACRO_SetSpellTooltip(spell)

	if (sIndex[spell]) then

		local spell_id = sIndex[spell].spellID

		if (morphSpells[spell_id]) then

			if (self.UberTooltips) then
				GameTooltip:SetHyperlink("spell:"..morphSpells[spell_id])
			else
				local spell = GetSpellInfo(morphSpells[spell_id])
				GameTooltip:SetText(spell, 1, 1, 1)
			end

		elseif (self.UberTooltips) then
			GameTooltip:SetSpellBookItem(sIndex[spell].index, sIndex[spell].booktype)
		else
			GameTooltip:SetText(sIndex[spell].spellName, 1, 1, 1)
		end

		self.UpdateTooltip = macroButton_SetTooltip

	elseif (cIndex[spell]) then

		if (self.UberTooltips) then
			GameTooltip:SetHyperlink("spell:"..cIndex[spell].spellID)
		else
			GameTooltip:SetText(cIndex[spell].creatureName, 1, 1, 1)
		end

		self.UpdateTooltip = nil
	end
end

function BUTTON:MACRO_SetItemTooltip(item)

	local name, link = GetItemInfo(item)

	if (link) then

		if (self.UberTooltips) then
			GameTooltip:SetHyperlink(link)
		else
			GameTooltip:SetText(name, 1, 1, 1)
		end

	elseif (ItemCache[item]) then

		if (self.UberTooltips) then
			GameTooltip:SetHyperlink("item:"..ItemCache[item]..":0:0:0:0:0:0:0")
		else
			GameTooltip:SetText(ItemCache[item], 1, 1, 1)
		end
	end
end

function BUTTON:ACTION_SetTooltip(action)

	local actionID = tonumber(action)

	if (actionID) then

		self.UpdateTooltip = nil

		if (HasAction(actionID)) then
			GameTooltip:SetAction(actionID)
		end

	elseif (action == "exit") then

		if (UnitHasVehicleUI("player")) then
			GameTooltip:SetText(LEAVE_VEHICLE, 1, 1, 1)
		else
			GameTooltip:SetText(CANCEL, 1, 1, 1)
		end

	elseif (action == "up") then

		GameTooltip:SetText(AIM_UP, 1, 1, 1)

	elseif (action == "down") then

		GameTooltip:SetText(AIM_DOWN, 1, 1, 1)

	end
end

function BUTTON:MACRO_SetTooltip(edit)

	self.UpdateTooltip = nil

	local spell, item, show = self.macrospell, self.macroitem, self.macroshow

	if (self.actionID) then

		self:ACTION_SetTooltip(self.actionID)

	elseif (show and #show>0) then

		if(GetItemInfo(show) or ItemCache[show]) then
			self:MACRO_SetItemTooltip(show)
		else
			self:MACRO_SetSpellTooltip(show:lower())
		end

	elseif (spell and #spell>0) then

		self:MACRO_SetSpellTooltip(spell:lower())

	elseif (item and #item>0) then

		self:MACRO_SetItemTooltip(item)

	elseif (self.data.macro_Text and #self.data.macro_Text > 0) then

		local equipset = self.data.macro_Text:match("/equipset%s+(%C+)")

		if (equipset) then
			GameTooltip:SetEquipmentSet(equipset)
		end
	else
		if (#self.data.macro_Name>0) then
			GameTooltip:SetText(self.data.macro_Name)
		end
	end
end

function BUTTON:MACRO_OnEnter(...)

	if (self.bar) then

		if (self.bar.cdata.tooltipsCombat and InCombatLockdown()) then
			return
		end

		if (self.bar.cdata.tooltips) then

			if (self.bar.cdata.tooltipsEnhanced) then
				self.UberTooltips = true
				GameTooltip_SetDefaultAnchor(GameTooltip, self)
			else
				self.UberTooltips = false
				GameTooltip:SetOwner(self, "ANCHOR_RIGHT")
			end

			self:MACRO_SetTooltip()

			GameTooltip:Show()
		end
	end
end

function BUTTON:MACRO_OnLeave(...)

	self.UpdateTooltip = nil

	GameTooltip:Hide()

end

function BUTTON:MACRO_OnShow(...)

	self:RegisterEvent("ACTIONBAR_SLOT_CHANGED")
	self:RegisterEvent("ACTIONBAR_UPDATE_COOLDOWN")
	self:RegisterEvent("ACTIONBAR_UPDATE_STATE")

	self:RegisterEvent("RUNE_POWER_UPDATE")

	self:RegisterEvent("TRADE_SKILL_SHOW")
	self:RegisterEvent("TRADE_SKILL_CLOSE")
	self:RegisterEvent("ARCHAEOLOGY_CLOSED")

	self:RegisterEvent("UPDATE_MOUSEOVER_UNIT")

	self:RegisterEvent("MODIFIER_STATE_CHANGED")

	self:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED")
	self:RegisterEvent("UNIT_SPELLCAST_FAILED")
	self:RegisterEvent("UNIT_PET")
	self:RegisterEvent("UNIT_AURA")
	self:RegisterEvent("UNIT_ENTERED_VEHICLE")
	self:RegisterEvent("UNIT_ENTERING_VEHICLE")
	self:RegisterEvent("UNIT_EXITED_VEHICLE")

	self:RegisterEvent("PLAYER_TARGET_CHANGED")
	self:RegisterEvent("PLAYER_FOCUS_CHANGED")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
	self:RegisterEvent("PLAYER_ENTER_COMBAT")
	self:RegisterEvent("PLAYER_LEAVE_COMBAT")
	self:RegisterEvent("PLAYER_CONTROL_LOST")
	self:RegisterEvent("PLAYER_CONTROL_GAINED")
	self:RegisterEvent("PLAYER_EQUIPMENT_CHANGED")

	self:RegisterEvent("UNIT_INVENTORY_CHANGED")
	self:RegisterEvent("BAG_UPDATE_COOLDOWN")
	self:RegisterEvent("BAG_UPDATE")
	self:RegisterEvent("COMPANION_UPDATE")
	self:RegisterEvent("PET_STABLE_UPDATE")
	self:RegisterEvent("PET_STABLE_SHOW")

	self:RegisterEvent("SPELL_ACTIVATION_OVERLAY_GLOW_SHOW")
	self:RegisterEvent("SPELL_ACTIVATION_OVERLAY_GLOW_HIDE")

	self:RegisterEvent("UPDATE_VEHICLE_ACTIONBAR")
	self:RegisterEvent("UPDATE_POSSESS_BAR")
	self:RegisterEvent("UPDATE_OVERRIDE_ACTIONBAR")
	self:RegisterEvent("UPDATE_EXTRA_ACTIONBAR")
	self:RegisterEvent("UPDATE_BONUS_ACTIONBAR")

end

function BUTTON:MACRO_OnHide(...)

	self:UnregisterEvent("ACTIONBAR_SLOT_CHANGED")
	self:UnregisterEvent("ACTIONBAR_UPDATE_COOLDOWN")
	self:UnregisterEvent("ACTIONBAR_UPDATE_STATE")

	self:UnregisterEvent("RUNE_POWER_UPDATE")

	self:UnregisterEvent("TRADE_SKILL_SHOW")
	self:UnregisterEvent("TRADE_SKILL_CLOSE")
	self:UnregisterEvent("ARCHAEOLOGY_CLOSED")

	self:UnregisterEvent("UPDATE_MOUSEOVER_UNIT")

	self:UnregisterEvent("MODIFIER_STATE_CHANGED")

	self:UnregisterEvent("UNIT_SPELLCAST_INTERRUPTED")
	self:UnregisterEvent("UNIT_SPELLCAST_FAILED")
	self:UnregisterEvent("UNIT_PET")
	self:UnregisterEvent("UNIT_AURA")
	self:UnregisterEvent("UNIT_ENTERED_VEHICLE")
	self:UnregisterEvent("UNIT_ENTERING_VEHICLE")
	self:UnregisterEvent("UNIT_EXITED_VEHICLE")

	self:UnregisterEvent("PLAYER_TARGET_CHANGED")
	self:UnregisterEvent("PLAYER_FOCUS_CHANGED")
	self:UnregisterEvent("PLAYER_REGEN_ENABLED")
	self:UnregisterEvent("PLAYER_REGEN_DISABLED")
	self:UnregisterEvent("PLAYER_ENTER_COMBAT")
	self:UnregisterEvent("PLAYER_LEAVE_COMBAT")
	self:UnregisterEvent("PLAYER_CONTROL_LOST")
	self:UnregisterEvent("PLAYER_CONTROL_GAINED")
	self:UnregisterEvent("PLAYER_EQUIPMENT_CHANGED")

	self:UnregisterEvent("UNIT_INVENTORY_CHANGED")
	self:UnregisterEvent("BAG_UPDATE_COOLDOWN")
	self:UnregisterEvent("BAG_UPDATE")
	self:UnregisterEvent("COMPANION_UPDATE")
	self:UnregisterEvent("PET_STABLE_UPDATE")
	self:UnregisterEvent("PET_STABLE_SHOW")

	self:UnregisterEvent("SPELL_ACTIVATION_OVERLAY_GLOW_SHOW")
	self:UnregisterEvent("SPELL_ACTIVATION_OVERLAY_GLOW_HIDE")

	self:UnregisterEvent("UPDATE_VEHICLE_ACTIONBAR")
	self:UnregisterEvent("UPDATE_POSSESS_BAR")
	self:UnregisterEvent("UPDATE_OVERRIDE_ACTIONBAR")
	self:UnregisterEvent("UPDATE_EXTRA_ACTIONBAR")
	self:UnregisterEvent("UPDATE_BONUS_ACTIONBAR")

end

function BUTTON:MACRO_OnAttributeChanged(name, value)

	if (value and self.data) then

		if (name == "activestate") then

			if (value:find("vehicle") or value:find("possess") or value:find("override")) then

				self.actionID = self:GetAttribute("*action*")

			else

				local keymap = KeyMap:GetAttribute("keymap")

				if (not self.keymapdata[keymap]) then
					self.keymapdata[keymap] = { homestate = CopyTable(stateData) }
				end

				if (not self.keymapdata[keymap][value]) then
					self.keymapdata[keymap][value] = CopyTable(stateData)
				end

				self.data = self.keymapdata[keymap][value]

				self:MACRO_UpdateParse()

				self:MACRO_Reset()

				self.actionID = nil

			end

			self:MACRO_UpdateAll(true)
		end

		if (name == "update") then
			self:MACRO_UpdateAll(true)
		end
	end
end

function BUTTON:BuildStateData()

	for keymap, statedate in pairs(self.keymapdata) do
		for state, data in pairs(statedate) do
			self:SetAttribute("keymap"..keymap.."-"..state.."-macro_Text", data.macro_Text)
		end
	end
end

function BUTTON:MACRO_Reset()

	self.macrospell = nil
	self.spellID = nil
	self.macroitem = nil
	self.macroshow = nil
	self.macroicon = nil

end

function BUTTON:MACRO_UpdateParse()

	self.macroparse = self.data.macro_Text

	if (#self.macroparse > 0) then
		self.macroparse = "\n"..self.macroparse.."\n"
		self.macroparse = (self.macroparse):gsub("(%c+)", " %1")
	else
		self.macroparse = nil
	end

end

function BUTTON:Reset()

	self:SetAttribute("unit", nil)
	self:SetAttribute("useparent-unit", nil)
	self:SetAttribute("type", nil)
	self:SetAttribute("type1", nil)
	self:SetAttribute("type2", nil)
	self:SetAttribute("*action*", nil)
	self:SetAttribute("*macrotext*", nil)
	self:SetAttribute("*action1", nil)
	self:SetAttribute("*macrotext2", nil)

	self:UnregisterEvent("ITEM_LOCK_CHANGED")
	self:UnregisterEvent("ACTIONBAR_SHOWGRID")
	self:UnregisterEvent("ACTIONBAR_HIDEGRID")
	self:UnregisterEvent("PET_BAR_SHOWGRID")
	self:UnregisterEvent("PET_BAR_HIDEGRID")
	self:UnregisterEvent("PET_BAR_UPDATE")
	self:UnregisterEvent("PET_BAR_UPDATE_COOLDOWN")
	self:UnregisterEvent("UNIT_FLAGS")
	self:UnregisterEvent("ACTIVE_TALENT_GROUP_CHANGED")
	self:UnregisterEvent("UPDATE_MACROS")
	self:UnregisterEvent("PLAYER_EQUIPMENT_CHANGED")
	self:UnregisterEvent("EQUIPMENT_SETS_CHANGED")

	KeyMap:UnwrapScript(self, "OnClick")

	self:MACRO_Reset()
end

function BUTTON:SetType(save, kill)

	local state

	if (self:GetAttribute("activestate")) then
		state = self:GetAttribute("activestate")
	else
		state = self:GetParent():GetAttribute("activestate")
	end

	self:Reset()

	if (kill) then

		self:SetScript("OnEvent", function() end)
		self:SetScript("OnUpdate", function() end)
		self:SetScript("OnAttributeChanged", function() end)

	else

		self:RegisterEvent("ITEM_LOCK_CHANGED")
		self:RegisterEvent("ACTIONBAR_SHOWGRID")
		self:RegisterEvent("ACTIONBAR_HIDEGRID")
		self:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED")
		self:RegisterEvent("UPDATE_MACROS")
		self:RegisterEvent("PLAYER_EQUIPMENT_CHANGED")
		self:RegisterEvent("EQUIPMENT_SETS_CHANGED")

		self:MACRO_UpdateParse()

		self:SetAttribute("type", "macro")
		self:SetAttribute("*macrotext*", self.macroparse)
		self:SetAttribute("movekey", self.sdata.move)
		self:SetAttribute("keymapkey", self.sdata.keymap)
		self:SetAttribute("vehicle", self.sdata.vehicle)

		if (self.sdata.keymap) then
			KeyMap:WrapScript(self, "OnClick", [[ self:GetParent():GetParent():SetAttribute("state-keymap", self:GetAttribute("keymapkey"))]])
		end

		self:SetScript("OnEvent", BUTTON.MACRO_OnEvent)
		self:SetScript("PreClick", BUTTON.MACRO_PreClick)
		self:SetScript("PostClick", BUTTON.MACRO_PostClick)
		self:SetScript("OnReceiveDrag", BUTTON.MACRO_OnReceiveDrag)
		self:SetScript("OnDragStart", BUTTON.MACRO_OnDragStart)
		self:SetScript("OnUpdate", BUTTON.MACRO_OnUpdate)
		self:SetScript("OnEnter", BUTTON.MACRO_OnEnter)
		self:SetScript("OnLeave", BUTTON.MACRO_OnLeave)
		self:SetScript("OnShow", BUTTON.MACRO_OnShow)
		self:SetScript("OnHide", BUTTON.MACRO_OnHide)
		self:SetScript("OnAttributeChanged", BUTTON.MACRO_OnAttributeChanged)

		self:MACRO_UpdateAll(true)
		self:MACRO_OnShow()

	end

	if (save) then
		self:SaveData(state)
	end
end

function BUTTON:SetSkinned()

	if (self.__MSQ_NormalTexture) then

		local Skin = self.__MSQ_NormalSkin

		if (Skin) then

			self.hasAction = Skin.Texture or false
			self.noAction = Skin.EmptyTexture or false

			if (self.__MSQ_Shape) then
				self.shape = self.__MSQ_Shape:lower()
			else
				self.shape = "square"
			end
		else
			self.hasAction = false
			self.noAction = false
			self.shape = "square"
		end

		self.shine.shape = self.shape

		return true
	else
		self.hasAction = "Interface\\Buttons\\UI-Quickslot2"
		self.noAction = "Interface\\Buttons\\UI-Quickslot"

		return false
	end
end

function BUTTON:SetData(bar)

	if (bar) then

		self.bar = bar

		self.spellGlow = bar.cdata.spellGlow
		self.spellGlowDef = bar.cdata.spellGlowDef
		self.spellGlowAlt = bar.cdata.spellGlowAlt

		self.bindText = bar.cdata.bindText
		self.macroText = bar.cdata.macroText
		self.countText = bar.cdata.countText

		self.cdText = bar.cdata.cdText

		if (bar.cdata.cdAlpha) then
			self.cdAlpha = 0.2
		else
			self.cdAlpha = 1
		end

		self.auraText = bar.cdata.auraText
		self.auraInd = bar.cdata.auraInd

		self.upClicks = bar.cdata.upClicks
		self.downClicks = bar.cdata.downClicks

		self.rangeInd = bar.cdata.rangeInd

	end

	if (self.bindText) then self.hotkey:Show() else self.hotkey:Hide() end
	if (self.macroText) then self.macroname:Show() else self.macroname:Hide() end
	if (self.countText) then self.count:Show() else self.count:Hide() end

	local down, up = "", ""

	if (self.upClicks) then up = up.."AnyUp" end
	if (self.downClicks) then down = down.."AnyDown" end

	self:RegisterForClicks(down, up)

	self.equipcolor = { 0.1, 1, 0.1, 1 }
	self.cdcolor1 = { 1, 0.82, 0, 1 }
	self.cdcolor2 = { 1, 0.1, 0.1, 1 }
	self.auracolor1 = { 0, 0.82, 0, 1 }
	self.auracolor2 = { 1, 0.1, 0.1, 1 }
	self.buffcolor = { 0, 0.8, 0, 1 }
	self.debuffcolor = { 0.8, 0, 0, 1 }
	self.manacolor = { 0.5, 0.5, 1.0 }
	self.rangecolor = { 0.7, 0.15, 0.15, 1 }

	self:SetFrameLevel(4)
	self.iconframe:SetFrameLevel(2)
	self.iconframecooldown:SetFrameLevel(3)
	self.iconframeaurawatch:SetFrameLevel(3)

	self:SetSkinned()
end

function BUTTON:SetBindingDefaults()

	local index = self.id

	if (index and R.Defaults.buttons[index]) then
		for keys,data in pairs(R.Defaults.buttons[index]) do
			for key,value in pairs(data) do
				self[keys][key] = value
			end
		end
	end
end

function BUTTON:SetDefaults()

	if (DB.firstRun[R.realm][R.player] == true) then

		local index = self.id

		if (index and R.Defaults.buttons[index]) then
			for keys,data in pairs(R.Defaults.buttons[index]) do
				if (self[keys].loaded == nil) then
					for key,value in pairs(data) do
						self[keys][key] = value
					end
				end
				self[keys].loaded = true
			end
		end
	end
end

function BUTTON:SaveData(state)

	local index, keymap, spec = self.id, KeyMap:GetAttribute("keymap"), GetActiveSpecGroup()

	if (not state) then
		state = self:GetParent():GetAttribute("activestate")
	end

	if (index and spec and keymap and state) then

		if (not btnCDB[index][spec][keymap]) then
			btnCDB[index][spec][keymap] = { homestate = CopyTable(stateData) }
		end

		if (not btnCDB[index][spec][keymap][state]) then
			btnCDB[index][spec][keymap][state] = CopyTable(stateData)
		end

		for key,value in pairs(self.data) do
			btnCDB[index][spec][keymap][state][key] = value
		end

		if (not btnGDB[index].keys) then
			btnGDB[index].keys = CopyTable(buttonKeybinds)
		end

		for key,value in pairs(self.keys) do
			btnGDB[index].keys[key] = value
		end

		for key,value in pairs(self.sdata) do
			btnCDB[index].sdata[key] = value
		end

		self:BuildStateData()

	else
		print("DEBUG: Bad Save Data for "..self:GetName().." ?")
		print(index); print(spec); print(keymap);	print(state)
	end
end

function BUTTON:LoadData(spec, state)

	local index, keymap = self.id, KeyMap:GetAttribute("keymap")

	if (not btnCDB[index]) then
		btnCDB[index] = { [1] = { [1] = { homestate = CopyTable(stateData) } }, [2] = { [1] = { homestate = CopyTable(stateData) } } }
	end

	if (not btnGDB[index].keys) then
		btnGDB[index].keys = CopyTable(buttonKeybinds)
	end

	if (not btnCDB[index].sdata) then
		btnCDB[index].sdata = CopyTable(specKeyData)
	end

	if (not btnCDB[index][spec]) then
		btnCDB[index][spec] = { [1] = { homestate = CopyTable(stateData) } }
	end

	if (not btnCDB[index][spec][keymap]) then
		btnCDB[index][spec][keymap] = { homestate = CopyTable(stateData) }
	end

	if (not btnCDB[index][spec][keymap][state]) then
		btnCDB[index][spec][keymap][state] = CopyTable(stateData)
	end

	for spec,keymaps in pairs(btnCDB[index]) do
		for keymap,states in pairs(keymaps) do
			if (type(states) == "table") then
				for state,data in pairs(states) do
					if (type(data) == "table") then
						R.UpdateData(data, stateData)
					end
				end
			end
		end
	end

	self.keymapdata = btnCDB[index][spec]

	self.data = self.keymapdata[keymap][state]

	self.keys = btnGDB[index].keys

	self.sdata = btnCDB[index].sdata

	self:BuildStateData()

end

function BUTTON:AutoWriteMacro(spell, subName)

	local modifier, modkey = " "

	if (DB.selfCast) then
		modKey = ((DB.selfCast):match("^%a+")):lower(); modifier = modifier.."[@player,mod:"..modKey.."]"
	end

	if (DB.focusCast) then
		modKey = ((DB.focusCast):match("^%a+")):lower(); modifier = modifier.."[@focus,mod:"..modKey.."]"
	end

	if (DB.rightClickTarget) then
		modKey = DB.rightClickTarget; modifier = modifier.."[@"..modKey..",btn:2]"
	end

	if (modKey) then
		modifier = modifier.."[] "
	end

	if (subName and #subName > 0) then
		return "#autowrite\n/cast"..modifier..spell.."("..subName..")"
	else
		return "#autowrite\n/cast"..modifier..spell.."()"
	end
end

function BUTTON:SetFauxState(state)

	if (state)  then

		local msg = (":"):split(state)

		if (msg and not self:GetAttribute("movekey") and not self:GetAttribute("keymapkey"))  then

			if (msg:find("vehicle") or msg:find("possess") or msg:find("override")) then

				if (self:GetAttribute("vehicle")) then

					local action = tonumber(self:GetAttribute("vehicle"))

					if (action) then

						self:SetAttribute("type", "action")

						if (msg:find("override")) then
							self:SetAttribute("*action*", action + self:GetAttribute("overrideID_Offset"))
						else
							self:SetAttribute("*action*", action + self:GetAttribute("vehicleID_Offset"))
						end

					elseif (self:GetAttribute("vehicle") == "exit") then

						self:SetAttribute("type", "macro")

						if (msg:find("possess")) then
							self:SetAttribute("*macrotext*", self:GetAttribute("possessExit_Macro"))
						else
							self:SetAttribute("*macrotext*", self:GetAttribute("vehicleExit_Macro"))
						end

						self:SetAttribute("*action*", 0)
					end
				end
			else

				local keymap = self:GetParent():GetParent():GetAttribute("keymap")

				self:SetAttribute("type", "macro")

				self:SetAttribute("*macrotext*", self:GetAttribute("keymap"..keymap.."-"..msg.."-macro_Text"))

				self:SetAttribute("*action*", nil)

			end

			self:SetAttribute("useparent-unit", nil)

		elseif (msg) then

			self:SetAttribute("update", true)

		end

		self:SetAttribute("activestate", msg)
	end
end

local BUTTON_MT = { __index = BUTTON }

function R.CreateButton(index)

	local button = CreateFrame("CheckButton", "RazerOrbweaverButton"..index, UIParent, "RazerOrbweaverActionButtonTemplate")

	setmetatable(button, BUTTON_MT)

	button.elapsed = 0

	local objects = GetChildrenAndRegions(button)

	for k,v in pairs(objects) do
		local name = (v):gsub(button:GetName(), "")
		button[name:lower()] = _G[v]
	end

	button.id = index
	button:SetID(0)
	button:RegisterForDrag("LeftButton", "RightButton")
	button:RegisterEvent("PLAYER_ENTERING_WORLD")

	button.normaltexture:SetVertexColor(1,1,1,0.5)

	--new action ID's for vehicle 133-138
	--new action ID's for possess 133-138
	--new action ID's for override 157-162

	button:SetAttribute("overrideID_Offset", 156)
	button:SetAttribute("vehicleID_Offset", 132)
	button:SetAttribute("vehicleExit_Macro", "/click OverrideActionBarLeaveFrameLeaveButton")
	button:SetAttribute("possessExit_Macro", "/click PossessButton2")

	button:SetAttribute("_childupdate", [[

			if (message and not self:GetAttribute("movekey") and not self:GetAttribute("keymapkey"))  then

				if (message:find("vehicle") or message:find("possess") or message:find("override")) then

					if (self:GetAttribute("vehicle")) then

						local action = tonumber(self:GetAttribute("vehicle"))

						if (action) then

							self:SetAttribute("type", "action")

							if (message:find("override")) then
								self:SetAttribute("*action*", action + self:GetAttribute("overrideID_Offset"))
							else
								self:SetAttribute("*action*", action + self:GetAttribute("vehicleID_Offset"))
							end

							self:SetAttribute("SpecialAction", nil)

						elseif (self:GetAttribute("vehicle") == "exit") then

							self:SetAttribute("type", "macro")

							if (message:find("possess")) then
								self:SetAttribute("*macrotext*", self:GetAttribute("possessExit_Macro"))
							else
								self:SetAttribute("*macrotext*", self:GetAttribute("vehicleExit_Macro"))
							end

							self:SetAttribute("SpecialAction", message:match("%a+"))

							self:SetAttribute("*action*", 0)
						end
					end
				else

					local keymap = self:GetParent():GetParent():GetAttribute("keymap")

					self:SetAttribute("type", "macro")

					self:SetAttribute("*macrotext*", self:GetAttribute("keymap"..keymap.."-"..message.."-macro_Text"))

					self:SetAttribute("*action*", nil)

					self:SetAttribute("SpecialAction", nil)

				end

				self:SetAttribute("useparent-unit", nil)

				self:SetAttribute("activestate", message)

			elseif (message) then

				self:SetAttribute("update", true)

			end

		]])


	SecureHandler_OnLoad(button)

	if (not btnGDB[index]) then
		btnGDB[index] = { keys = CopyTable(buttonKeybinds) }
	end

	if (not btnCDB[index]) then
		btnCDB[index] = { [1] = { [1] = { homestate = CopyTable(stateData) } }, [2] = { [1] = { homestate = CopyTable(stateData) } } }
	end

	BTNIndex[index] = button

	return button

end

local function controlOnEvent(self, event, ...)

	if (event:find("UNIT_")) then

		if (unitAuras[select(1,...)]) then
			if (... == "player") then
				for k,v in pairs(morphSpells) do
					morphSpells[k] = false
				end
			end
			updateAuraInfo(select(1,...))
		end

	elseif (event == "PLAYER_TARGET_CHANGED") then

		for k in pairs(unitAuras) do
			updateAuraInfo(k)
		end

	elseif (event == "ADDON_LOADED" and ... == "RazerOrbweaver") then

		player, realm = UnitName("player"), GetRealmName()

		DB = RazerOrbweaverDB

		if (not DB.buttons[realm]) then
			DB.buttons[realm] = {}
		end

		if (not DB.buttons[realm][player]) then
			DB.buttons[realm][player] = {}
		end

		btnGDB = DB.buttons

		btnCDB = DB.buttons[realm][player]

		ItemCache = RazerOrbweaverItemCache

		cmdSlash = {
			[SLASH_CAST1] = true,
			[SLASH_CAST2] = true,
			[SLASH_CAST3] = true,
			[SLASH_CAST4] = true,
			[SLASH_CASTRANDOM1] = true,
			[SLASH_CASTRANDOM2] = true,
			[SLASH_CASTSEQUENCE1] = true,
			[SLASH_CASTSEQUENCE2] = true,
			[SLASH_EQUIP1] = true,
			[SLASH_EQUIP2] = true,
			[SLASH_EQUIP3] = true,
			[SLASH_EQUIP4] = true,
			[SLASH_EQUIP_TO_SLOT1] = true,
			[SLASH_EQUIP_TO_SLOT2] = true,
			[SLASH_USE1] = true,
			[SLASH_USE2] = true,
			[SLASH_USERANDOM1] = true,
			[SLASH_USERANDOM2] = true,
			["/cast"] = true,
			["/castrandom"] = true,
			["/castsequence"] = true,
			["/spell"] = true,
			["/equip"] = true,
			["/eq"] = true,
			["/equipslot"] = true,
			["/use"] = true,
			["/userandom"] = true,
		}

		hooksecurefunc("MoveForwardStart", MoveForward_Down)
		hooksecurefunc("MoveForwardStop", MoveForward_Up)

		hooksecurefunc("MoveBackwardStart", MoveBackward_Down)
		hooksecurefunc("MoveBackwardStop", MoveBackward_Up)

		hooksecurefunc("TurnLeftStart", TurnLeft_Down)
		hooksecurefunc("TurnLeftStop", TurnLeft_Up)

		hooksecurefunc("TurnRightStart", TurnRight_Down)
		hooksecurefunc("TurnRightStop", TurnRight_Up)

		hooksecurefunc("StrafeLeftStart", StrafeLeft_Down)
		hooksecurefunc("StrafeLeftStop", StrafeLeft_Up)

		hooksecurefunc("StrafeRightStart", StrafeRight_Down)
		hooksecurefunc("StrafeRightStop", StrafeRight_Up)

		hooksecurefunc("JumpOrAscendStart", JumpOrAscend_Down)
		hooksecurefunc("AscendStop", JumpOrAscend_Up)

	elseif (event == "VARIABLES_LOADED") then


	elseif (event == "PLAYER_LOGIN") then

		ROS = RazerOrbweaverSpec[R.realm][R.player]

		for k in pairs(unitAuras) do
			updateAuraInfo(k)
		end

		WorldFrame:HookScript("OnMouseUp", checkCursor)
		WorldFrame:HookScript("OnMouseDown", checkCursor)

	elseif (event == "PLAYER_ENTERING_WORLD" and not PEW) then

		PEW = true

	elseif (event == "ACTIONBAR_SHOWGRID") then

		StartDrag = true

	end
end

local frame = CreateFrame("Frame", nil, UIParent)
frame:SetScript("OnUpdate", cooldownsOnUpdate)

frame = CreateFrame("Frame", nil, UIParent)
frame:SetScript("OnEvent", controlOnEvent)
frame:SetScript("OnUpdate", controlOnUpdate)
frame:RegisterEvent("ADDON_LOADED")
frame:RegisterEvent("VARIABLES_LOADED")
frame:RegisterEvent("PLAYER_LOGIN")
frame:RegisterEvent("PLAYER_ENTERING_WORLD")
frame:RegisterEvent("PLAYER_TARGET_CHANGED")
frame:RegisterEvent("ACTIONBAR_SHOWGRID")
frame:RegisterEvent("UNIT_AURA")
frame:RegisterEvent("UNIT_SPELLCAST_SENT")
frame:RegisterEvent("UNIT_SPELLCAST_START")
frame:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
frame:RegisterEvent("UNIT_SPELLCAST_CHANNEL_START")