--RazerOrbweaver, a World of Warcraft® user interface addon.

RazerOrbweaver = {
	SlashCommands = {},
	SlashHelp = {},
	sIndex = {},
	iIndex = { [1] = "INTERFACE\\ICONS\\INV_MISC_QUESTRMARK" },
	cIndex = {},
	StanceIndex = {},
	ShowGrids = {},
	HideGrids = {},
	BARIndex = {},
	BTNIndex = {},
	BINDIndex = {},
	MacroDrag = {},
	StartDrag = false,
	maxActionID = 132,
	maxPetID = 10,
	OpDep = false,
}

RazerOrbweaverDB = {

	bars = {},
	buttons = {},
	firstRun = {},

	layout = 1,
	strata = "BACKGROUND",
	scale = 1,

	pad_main = 6,
	pad_d = -18,
	pad_thumb = 20,

	buttonLoc = { -0.85, -111.45 },
	buttonRadius = 87.5,

	selfCast = false,
	focusCast = false,

	throttle = 0.2,
	timerLimit = 4,

	mainbar = true,

	razerBindings = true,

	useVehicle = false,

	dpadState = true,

	KeyMap = 1,

	fix08082012 = "",

	debug = {},

}

RazerOrbweaverSpec = {}

RazerOrbweaverItemCache = {}

local L = LibStub("AceLocale-3.0"):GetLocale("RazerOrbweaver")

local R = RazerOrbweaver

local ICONS = R.iIndex

local icons = {}

R.GameVersion, R.GameBuild, R.GameDate, R.TOCVersion = GetBuildInfo()

R.GameVersion = tonumber(R.GameVersion); R.TOCVersion = tonumber(R.TOCVersion)

R.Points = { R = "RIGHT", L = "LEFT", T = "TOP", B = "BOTTOM", TL = "TOPLEFT", TR = "TOPRIGHT", BL = "BOTTOMLEFT", BR = "BOTTOMRIGHT", C = "CENTER" }

R.Stratas = { "BACKGROUND", "LOW", "MEDIUM", "HIGH", "DIALOG", "TOOLTIP" }

R.KeyMap = CreateFrame("Frame", nil, UIParent, "SecureHandlerStateTemplate"); R.KeyMap:SetAttribute("keymap", 1)

R.STATES = {

	homestate = L.HOMESTATE,
	laststate = L.LASTSTATE,
	pagedbar1 = L.PAGEDBAR1,
	pagedbar2 = L.PAGEDBAR2,
	pagedbar3 = L.PAGEDBAR3,
	pagedbar4 = L.PAGEDBAR4,
	pagedbar5 = L.PAGEDBAR5,
	pagedbar6 = L.PAGEDBAR6,
	companion0 = L.COMPANION0,
	companion1 = L.COMPANION1,
	alt1 = L.ALT1,
	ctrl1 = L.CTRL1,
	shift1 = L.SHIFT1,
	reaction1 = L.REACTION1,
	combat1 = L.COMBAT1,
	group1 = L.GROUP1,
	group2 = L.GROUP2,
	fishing1 = L.FISHING1,
	vehicle1 = L.VEHICLE1,
	custom = L.CUSTOM,

}

local handler = CreateFrame("Frame", nil, UIParent, "SecureHandlerStateTemplate")

local opDepList = { "BarKeep", "Bartender4", "Dominos", "MagnetButtons", "nMainbar", "rActionBarStyler", "Orbs", "RazerNaga", "StellarBars", "Tukui", "XBar" }, false

local specDefaults = { cSpec = 1 }

local stanceStringsUpdated, PEW

function R.GetChildrenAndRegions(frame)

	if (frame == nil) then
		return
	end

	local data, childData = {}, {}
	local children, regions = { frame:GetChildren() }, { frame:GetRegions() }

	for k,v in pairs(children) do
		tinsert(data, v:GetName())
		childData = R.GetChildrenAndRegions(v)
		for key,value in pairs(childData) do
			tinsert(data, value)
		end
	end

	for k,v in pairs(regions) do
		tinsert(data, v:GetName())
	end

	return data
end

local defaultDB, DB, ROS = CopyTable(RazerOrbweaverDB), CopyTable(RazerOrbweaverDB)

-- "()" indexes added because the Blizzard macro parser uses that to determine the difference of a spell versus a usable item if the two happen to have the same name.
-- I forgot this fact and removed using "()" and it made some macros not represent the right spell /sigh. This note is here so I do not forget again :P

function R:UpdateSpellIndex()

	local sIndexMax = 0

	for i=1,8 do

		local _, _, _, numSlots = GetSpellTabInfo(i)

		sIndexMax = sIndexMax + numSlots
	end

	local spellName, subName, altName, spellID, tempID, spellType, spellLvl, isPassive, icon, cost, powerType, curSpell, link, _

	for i = 1,sIndexMax do

		spellName, subName = GetSpellBookItemName(i, BOOKTYPE_SPELL)
		spellType, spellID = GetSpellBookItemInfo(i, BOOKTYPE_SPELL)
		spellLvl = GetSpellAvailableLevel(i, BOOKTYPE_SPELL)
		icon = GetSpellBookItemTexture(i, BOOKTYPE_SPELL)
		isPassive = IsPassiveSpell(i, BOOKTYPE_SPELL)

		if (spellName and spellType ~= "FUTURESPELL") then

			link = GetSpellLink(spellName)

			if (link) then
				_, spellID = link:match("(spell:)(%d+)")
				tempID = tonumber(spellID)
				if (tempID) then
					spellID = tempID
				end
			end

			altName, _, _, cost, _, powerType = GetSpellInfo(spellID)

			if (subName and #subName > 0) then

				if (not R.sIndex[(spellName.."("..subName..")"):lower()]) then
					R.sIndex[(spellName.."("..subName..")"):lower()] = {}
				end

				curSpell = R.sIndex[(spellName.."("..subName..")"):lower()]

				curSpell.index = i
				curSpell.booktype = BOOKTYPE_SPELL
				curSpell.spellName = spellName
				curSpell.spellID = spellID
				curSpell.icon = icon

			else

				if (not R.sIndex[(spellName):lower()]) then
					R.sIndex[(spellName):lower()] = {}
				end

				curSpell = R.sIndex[(spellName):lower()]

				curSpell.index = i
				curSpell.booktype = BOOKTYPE_SPELL
				curSpell.spellName = spellName
				curSpell.spellID = spellID
				curSpell.icon = icon

				if (not R.sIndex[(spellName):lower().."()"]) then
					R.sIndex[(spellName):lower().."()"] = {}
				end

				curSpell = R.sIndex[(spellName):lower().."()"]

				curSpell.index = i
				curSpell.booktype = BOOKTYPE_SPELL
				curSpell.spellName = spellName
				curSpell.spellID = spellID
				curSpell.icon = icon
			end

			if (altName and altName ~= spellName) then

				if (subName and #subName > 0) then

					if (not R.sIndex[(altName.."("..subName..")"):lower()]) then
						R.sIndex[(altName.."("..subName..")"):lower()] = {}
					end

					curSpell = R.sIndex[(altName.."("..subName..")"):lower()]

					curSpell.index = i
					curSpell.booktype = BOOKTYPE_SPELL
					curSpell.spellName = spellName
					curSpell.spellID = spellID
					curSpell.icon = icon

				else

					if (not R.sIndex[(altName):lower()]) then
						R.sIndex[(altName):lower()] = {}
					end

					curSpell = R.sIndex[(altName):lower()]

					curSpell.index = i
					curSpell.booktype = BOOKTYPE_SPELL
					curSpell.spellName = spellName
					curSpell.spellID = spellID
					curSpell.icon = icon

					if (not R.sIndex[(altName):lower().."()"]) then
						R.sIndex[(altName):lower().."()"] = {}
					end

					curSpell = R.sIndex[(altName):lower().."()"]

					curSpell.index = i
					curSpell.booktype = BOOKTYPE_SPELL
					curSpell.spellName = spellName
					curSpell.spellID = spellID
					curSpell.icon = icon
				end
			end

			if (spellID) then

				if (not R.sIndex[spellID]) then
					R.sIndex[spellID] = {}
				end

				curSpell = R.sIndex[spellID]

				curSpell.index = i
				curSpell.booktype = BOOKTYPE_SPELL
				curSpell.spellName = spellName
				curSpell.spellID = spellID
				curSpell.icon = icon
			end

	   		if (icon and not icons[icon:upper()]) then
	   			ICONS[#ICONS+1] = icon:upper(); icons[icon:upper()] = true
	   		end
   		end

   	end

	-- maybe a temp fix to get the Sunfire spell to show for balance druids
	if (R.class == "DRUID") then

		local spellName, _, icon = GetSpellInfo(93402)

		if (R.sIndex[8921]) then

			if (not R.sIndex[(spellName):lower()]) then
				R.sIndex[(spellName):lower()] = {}
			end

			curSpell = R.sIndex[(spellName):lower()]

			curSpell.index = R.sIndex[8921].index
			curSpell.booktype = R.sIndex[8921].booktype
			curSpell.spellName = spellName
			curSpell.spellID = 93402
			curSpell.icon = icon

			if (not R.sIndex[(spellName):lower().."()"]) then
				R.sIndex[(spellName):lower().."()"] = {}
			end

			curSpell = R.sIndex[(spellName):lower().."()"]

			curSpell.index = R.sIndex[8921].index
			curSpell.booktype = R.sIndex[8921].booktype
			curSpell.spellName = spellName
			curSpell.spellID = 93402
			curSpell.icon = icon

			if (not R.sIndex[93402]) then
				R.sIndex[93402] = {}
			end

			curSpell = R.sIndex[(spellName):lower().."()"]

			curSpell.index = R.sIndex[8921].index
			curSpell.booktype = R.sIndex[8921].booktype
			curSpell.spellName = spellName
			curSpell.spellID = 93402
			curSpell.icon = icon
		end
	end

	for i = 1, select("#", GetProfessions()) do

		local index = select(i, GetProfessions())

		if (index) then

			local _, _, _, _, numSpells, spelloffset = GetProfessionInfo(index)

			for i=1,numSpells do

				spellName, subName = GetSpellBookItemName(i+spelloffset, BOOKTYPE_PROFESSION)
				spellType, spellID = GetSpellBookItemInfo(i+spelloffset, BOOKTYPE_PROFESSION)
				spellLvl = GetSpellAvailableLevel(i+spelloffset, BOOKTYPE_PROFESSION)
				icon = GetSpellBookItemTexture(i+spelloffset, BOOKTYPE_PROFESSION)
				isPassive = IsPassiveSpell(i+spelloffset, BOOKTYPE_PROFESSION)

				if (spellName and spellType ~= "FUTURESPELL") then

					link = GetSpellLink(spellName)

					if (link) then
						_, spellID = link:match("(spell:)(%d+)")
						tempID = tonumber(spellID)
						if (tempID) then
							spellID = tempID
						end
					end

					altName, _, _, cost, _, powerType = GetSpellInfo(spellID)

					if (subName and #subName > 0) then

						if (not R.sIndex[(spellName.."("..subName..")"):lower()]) then
							R.sIndex[(spellName.."("..subName..")"):lower()] = {}
						end

						curSpell = R.sIndex[(spellName.."("..subName..")"):lower()]

						curSpell.index = i+spelloffset
						curSpell.booktype = BOOKTYPE_PROFESSION
						curSpell.spellName = spellName
						curSpell.spellID = spellID
						curSpell.icon = icon

					else

						if (not R.sIndex[(spellName):lower()]) then
							R.sIndex[(spellName):lower()] = {}
						end

						curSpell = R.sIndex[(spellName):lower()]

						curSpell.index = i+spelloffset
						curSpell.booktype = BOOKTYPE_PROFESSION
						curSpell.spellName = spellName
						curSpell.spellID = spellID
						curSpell.icon = icon

						if (not R.sIndex[(spellName):lower().."()"]) then
							R.sIndex[(spellName):lower().."()"] = {}
						end

						curSpell = R.sIndex[(spellName):lower().."()"]

						curSpell.index = i+spelloffset
						curSpell.booktype = BOOKTYPE_PROFESSION
						curSpell.spellName = spellName
						curSpell.spellID = spellID
						curSpell.icon = icon
					end

					if (altName and altName ~= spellName) then

						if (subName and #subName > 0) then

							if (not R.sIndex[(altName.."("..subName..")"):lower()]) then
								R.sIndex[(altName.."("..subName..")"):lower()] = {}
							end

							curSpell = R.sIndex[(altName.."("..subName..")"):lower()]

							curSpell.index = i+spelloffset
							curSpell.booktype = BOOKTYPE_PROFESSION
							curSpell.spellName = spellName
							curSpell.spellID = spellID
							curSpell.icon = icon

						else

							if (not R.sIndex[(altName):lower()]) then
								R.sIndex[(altName):lower()] = {}
							end

							curSpell = R.sIndex[(altName):lower()]

							curSpell.index = i+spelloffset
							curSpell.booktype = BOOKTYPE_PROFESSION
							curSpell.spellName = spellName
							curSpell.spellID = spellID
							curSpell.icon = icon

							if (not R.sIndex[(altName):lower().."()"]) then
								R.sIndex[(altName):lower().."()"] = {}
							end

							curSpell = R.sIndex[(altName):lower().."()"]

							curSpell.index = i+spelloffset
							curSpell.booktype = BOOKTYPE_PROFESSION
							curSpell.spellName = spellName
							curSpell.spellID = spellID
							curSpell.icon = icon
						end
					end

					if (spellID) then

						if (not R.sIndex[spellID]) then
							R.sIndex[spellID] = {}
						end

						curSpell = R.sIndex[spellID]

						curSpell.index = i+spelloffset
						curSpell.booktype = BOOKTYPE_PROFESSION
						curSpell.spellName = spellName
						curSpell.spellID = spellID
						curSpell.icon = icon
					end

			   		if (icon and not icons[icon:upper()]) then
			   			ICONS[#ICONS+1] = icon:upper(); icons[icon:upper()] = true
			   		end
   				end
			end
		end
	end
end

function R:UpdatePetSpellIndex()

	local numPetSpells = HasPetSpells() or 0

	local spellName, subName, altName, spellID, tempID, spellType, spellLvl, isPassive, icon, cost, powerType, curSpell, link, _

	for i=1,numPetSpells do

		spellName, subName = GetSpellBookItemName(i, BOOKTYPE_PET)
		spellType, spellID = GetSpellBookItemInfo(i, BOOKTYPE_PET)
		spellLvl = GetSpellAvailableLevel(i, BOOKTYPE_PET)
		icon = GetSpellBookItemTexture(i, BOOKTYPE_PET)
		isPassive = IsPassiveSpell(i, BOOKTYPE_PET)

		if (spellName and spellType ~= "FUTURESPELL") then

			link = GetSpellLink(spellName)

			if (link) then
				_, spellID = link:match("(spell:)(%d+)")
				tempID = tonumber(spellID)
				if (tempID) then
					spellID = tempID
				end
			end

			_, _, icon, cost, _, powerType = GetSpellInfo(spellName)

			if (subName and #subName > 0) then

				if (not R.sIndex[(spellName.."("..subName..")"):lower()]) then
					R.sIndex[(spellName.."("..subName..")"):lower()] = {}
				end

				curSpell = R.sIndex[(spellName.."("..subName..")"):lower()]

				curSpell.index = i
				curSpell.booktype = BOOKTYPE_PET
				curSpell.spellName = spellName
				curSpell.spellID = spellID
				curSpell.icon = icon

			else

				if (not R.sIndex[(spellName):lower()]) then
					R.sIndex[(spellName):lower()] = {}
				end

				curSpell = R.sIndex[(spellName):lower()]

				curSpell.index = i
				curSpell.booktype = BOOKTYPE_PET
				curSpell.spellName = spellName
				curSpell.spellID = spellID
				curSpell.icon = icon

				if (not R.sIndex[(spellName):lower().."()"]) then
					R.sIndex[(spellName):lower().."()"] = {}
				end

				curSpell = R.sIndex[(spellName):lower().."()"]

				curSpell.index = i
				curSpell.booktype = BOOKTYPE_PET
				curSpell.spellName = spellName
				curSpell.spellID = spellID
				curSpell.icon = icon
			end

			if (spellID) then

				if (not R.sIndex[spellID]) then
					R.sIndex[spellID] = {}
				end

				curSpell = R.sIndex[spellID]

				curSpell.index = i
				curSpell.booktype = BOOKTYPE_PET
				curSpell.spellName = spellName
				curSpell.spellID = spellID
				curSpell.icon = icon
			end

	   		if (icon and not icons[icon:upper()]) then
	   			ICONS[#ICONS+1] = icon:upper(); icons[icon:upper()] = true
	   		end
   		end

	end

	-- a lot of work to associate the Call Pet spell with the pet's name so that tooltips work on Call Pet spells. /sigh
	local _, _, numSlots, isKnown = GetFlyoutInfo(9)
	local petIndex, petName

	for i=1, numSlots do

		spellID, isKnown = GetFlyoutSlotInfo(9, i)
		petIndex, petName = GetCallPetSpellInfo(spellID)

		if (isKnown and petIndex and petName and #petName > 0) then

			spellName = GetSpellInfo(spellID)

			for k,v in pairs(R.sIndex) do

				if (v.spellName:find(petName.."$")) then

					if (not R.sIndex[(spellName):lower()]) then
						R.sIndex[(spellName):lower()] = {}
					end

					curSpell = R.sIndex[(spellName):lower()]

					curSpell.index = v.index
					curSpell.booktype = v.booktype
					curSpell.spellName = v.spellName
					curSpell.spellID = spellID
					curSpell.icon = v.icon

					if (not R.sIndex[(spellName):lower().."()"]) then
						R.sIndex[(spellName):lower().."()"] = {}
					end

					curSpell = R.sIndex[(spellName):lower().."()"]

					curSpell.index = v.index
					curSpell.booktype = v.booktype
					curSpell.spellName = v.spellName
					curSpell.spellID = spellID
					curSpell.icon = v.icon

					if (not R.sIndex[spellID]) then
						R.sIndex[spellID] = {}
					end

					curSpell = R.sIndex[spellID]

					curSpell.index = v.index
					curSpell.booktype = v.booktype
					curSpell.spellName = v.spellName
					curSpell.spellID = spellID
					curSpell.icon = v.icon

				end
			end
		end
	end
end

function R:UpdateCompanionData()

	local creatureID, creatureName, spellID, icon, spell, curComp

	for i=1,GetNumCompanions("CRITTER") do

		creatureID, creatureName, spellID, icon = GetCompanionInfo("CRITTER", i)

		if (spellID) then

			spell = GetSpellInfo(spellID)

			if (spell) then

				if (not R.cIndex[spell:lower()]) then
					R.cIndex[spell:lower()] = {}
				end

				curComp = R.cIndex[spell:lower()]

				curComp.creatureType = "CRITTER"
				curComp.index = i
				curComp.creatureID = creatureID
				curComp.creatureName = creatureName
				curComp.spellID = spellID
				curComp.icon = icon

				if (not R.cIndex[spell:lower().."()"]) then
					R.cIndex[spell:lower().."()"] = {}
				end

				curComp = R.cIndex[spell:lower().."()"]

				curComp.creatureType = "CRITTER"
				curComp.index = i
				curComp.creatureID = creatureID
				curComp.creatureName = creatureName
				curComp.spellID = spellID
				curComp.icon = icon

				if (not R.cIndex[spellID]) then
					R.cIndex[spellID] = {}
				end

				curComp = R.cIndex[spellID]

				curComp.creatureType = "CRITTER"
				curComp.index = i
				curComp.creatureID = creatureID
				curComp.creatureName = creatureName
				curComp.spellID = spellID
				curComp.icon = icon

		   		if (icon and not icons[icon:upper()]) then
		   			ICONS[#ICONS+1] = icon:upper(); icons[icon:upper()] = true
		   		end
			end
		end
	end

	for i=1,GetNumCompanions("MOUNT") do

		creatureID, creatureName, spellID, icon = GetCompanionInfo("MOUNT", i)

		if (spellID) then

			spell = GetSpellInfo(spellID)

			if (spell) then

				if (not R.cIndex[spell:lower()]) then
					R.cIndex[spell:lower()] = {}
				end

				curComp = R.cIndex[spell:lower()]

				curComp.creatureType = "MOUNT"
				curComp.index = i
				curComp.creatureID = creatureID
				curComp.creatureName = creatureName
				curComp.spellID = spellID
				curComp.icon = icon

				if (not R.cIndex[spell:lower().."()"]) then
					R.cIndex[spell:lower().."()"] = {}
				end

				curComp = R.cIndex[spell:lower().."()"]

				curComp.creatureType = "MOUNT"
				curComp.index = i
				curComp.creatureID = creatureID
				curComp.creatureName = creatureName
				curComp.spellID = spellID
				curComp.icon = icon

				if (not R.cIndex[spellID]) then
					R.cIndex[spellID] = {}
				end

				curComp = R.cIndex[spellID]

				curComp.creatureType = "MOUNT"
				curComp.index = i
				curComp.creatureID = creatureID
				curComp.creatureName = creatureName
				curComp.spellID = spellID
				curComp.icon = icon

		   		if (icon and not icons[icon:upper()]) then
		   			ICONS[#ICONS+1] = icon:upper(); icons[icon:upper()] = true
		   		end
			end
		end
	end
end

local temp = {}

function R:UpdateIconIndex()

	local icon

	wipe(temp)

	GetMacroIcons(temp)

	for k,v in ipairs(temp) do

		icon = "INTERFACE\\ICONS\\"..v:upper()

   		if (not icons[icon:upper()]) then
   			ICONS[#ICONS+1] = icon:upper(); icons[icon:upper()] = true
   		end
   	end

	--wipe(temp)

	--GetMacroItemIcons(temp)

	--for k,v in ipairs(temp) do

	--	icon = "INTERFACE\\ICONS\\"..v:upper()

   	--	if (not icons[icon:upper()]) then
   	--		ICONS[#ICONS+1] = icon:upper(); icons[icon:upper()] = true
   	--	end
   	--end
end

function R:UpdateShapeshiftStrings()

	if (R.class == "DRUID" or
	    R.class == "MONK" or
	    R.class == "PRIEST" or
	    R.class == "ROGUE" or
	    R.class == "WARRIOR" or
	    R.class == "WARLOCK") then

		local _, name, catform

		local states = "[stance:0] stance0; "

		for i=1,8 do
			R.STATES["stance"..i] = nil
		end

		for i=1,GetNumShapeshiftForms() do

			_, name = GetShapeshiftFormInfo(i)

			if (name) then

				link = GetSpellLink(name)

				if (link) then

					_, spellID = link:match("(spell:)(%d+)")

					spellID = tonumber(spellID)

					if (spellID) then

						R.StanceIndex[i] = spellID

						if (R.class == "DRUID" and spellID == 768) then
							catform = i
						end

						if (spellID ~= 1066 and spellID ~= 783 and spellID ~= 40120 and spellID ~= 33943) then

							R.STATES["stance"..i] = name

							states = states.."[stance:"..i.."] stance"..i.."; "
						end
					end
				end
			end
		end

		states = states:gsub("; $", "")

		if (not stanceStringsUpdated) then

			if (R.class == "DRUID") then

				R.STATES.stance0 = L.DRUID_CASTER

				R.STATES.prowl = L.DRUID_PROWL

				if (catform) then
					states = "[stance:"..catform..",stealth] prowl; "..states
				end

			end

			if (R.class == "MONK") then

				R.STATES.stance0 = ATTRIBUTE_NOOP

				R.MS.stance.homestate = "stance1"
			end

			if (R.class == "PRIEST") then

				R.STATES.stance0 = L.PRIEST_HEALER

			end

			if (R.class == "ROGUE") then

				R.STATES.stance0 = L.ROGUE_MELEE

				states = states.."[stance:3] stance1; "

			end

			if (R.class == "WARLOCK") then

				R.STATES.stance0 = L.WARLOCK_CASTER

			end

			if (R.class == "WARRIOR") then

				R.STATES.stance0 = ATTRIBUTE_NOOP

				R.MS.stance.homestate = "stance1"
			end

			stanceStringsUpdated = true
		end

		R.MS.stance.states = states
	end
end

local function printSlashHelp()

	DEFAULT_CHAT_FRAME:AddMessage(L.SLASH_HINT1)
	DEFAULT_CHAT_FRAME:AddMessage(L.SLASH_HINT2)

	for k,v in ipairs(R.SlashHelp) do
		DEFAULT_CHAT_FRAME:AddMessage(v)
	end
end

local function slashHandler(msg)

	R.ToggleBars()

end


function R.EditBox_PopUpInitialize(popupFrame, data)

	popupFrame.func = R.PopUp_Update
	popupFrame.data = data

	R.PopUp_Update(popupFrame)
end

function R.PopUp_Update(popupFrame)

	local data, columns, optionText = popupFrame.data, 1
	local count, height, width, widthMult, option, lastOption, lastAnchor = 1,0, popupFrame:GetParent():GetWidth(), 1, nil, nil, nil

	if (popupFrame.options) then
		for k,v in pairs(popupFrame.options) do
			v:Hide()
		end
	end

	popupFrame.array = {}

	if (not data) then
		return
	end

	for k,v in pairs(data) do

		if (type(v) == "string") then
			popupFrame.array[count] = k..","..v
		else
			popupFrame.array[count] = k
		end

		count = count + 1
	end

	table.sort(popupFrame.array)

	count = 1

	columns = (math.ceil(#popupFrame.array/20)) or 1

	for i=1,#popupFrame.array do

		popupFrame.array[i] = gsub(popupFrame.array[i], "%s+", " ")
		popupFrame.array[i] = gsub(popupFrame.array[i], "^%s+", "")

		if (not popupFrame.options[i]) then
			option = CreateFrame("Button", popupFrame:GetName().."Option"..i, popupFrame, "RazerOrbweaverPopupButtonTemplate")
			option:SetHeight(14)

			popupFrame.options[i] = option
		else
			option = _G[popupFrame:GetName().."Option"..i]
			popupFrame.options[i] = option
		end

		optionText = _G[option:GetName().."Text"]

		local text = popupFrame.array[i]:match("^[^,]+") or ""

		text = text:gsub("^%d+_", "")

		optionText:SetText(text)

		option.value = popupFrame.array[i]:match("[^,]+$")

		if (optionText:GetWidth()+20 > width and optionText:GetWidth()+20 < 250) then
			width = _G[option:GetName().."Text"]:GetWidth() + 20
		end

		option:ClearAllPoints()

		if (count == 1) then
			if (lastAnchor) then
				option:SetPoint("LEFT", lastAnchor, "RIGHT", 0, 0)
				lastOption = option
				lastAnchor = option

			else
				option:SetPoint("TOPLEFT", popupFrame, "TOPLEFT", 0, -5)
				lastOption = option
				lastAnchor = option
			end
		else
			option:SetPoint("TOP", lastOption, "BOTTOM", 0, -1)
			lastOption = option
		end

		if (widthMult == 1) then
			height = height + 15
		end

		count = count + 1

		if (count > math.ceil(#popupFrame.array/columns) and widthMult < columns and columns > 1) then
			widthMult = widthMult + 1
			count = 1
		end

		option:Show()
	end

	if (popupFrame.options) then
		for k,v in pairs(popupFrame.options) do
			v:SetWidth(width)
		end
	end

	popupFrame:SetWidth(width * widthMult)

	if (popupFrame:GetParent():GetHeight() > height + 10) then
		popupFrame:SetHeight(popupFrame:GetParent():GetHeight())
	else
		popupFrame:SetHeight(height + 10)
	end
end

--From wowwiki.com
local minimapShapes = {

	-- quadrant booleans (same order as SetTexCoord)
	-- {upper-left, lower-left, upper-right, lower-right}
	-- true = rounded, false = squared

	["ROUND"] 			= {true, true, true, true},
	["SQUARE"] 			= {false, false, false, false},
	["CORNER-TOPLEFT"] 		= {true, false, false, false},
	["CORNER-TOPRIGHT"] 		= {false, false, true, false},
	["CORNER-BOTTOMLEFT"] 		= {false, true, false, false},
	["CORNER-BOTTOMRIGHT"]	 	= {false, false, false, true},
	["SIDE-LEFT"] 			= {true, true, false, false},
	["SIDE-RIGHT"] 			= {false, false, true, true},
	["SIDE-TOP"] 			= {true, false, true, false},
	["SIDE-BOTTOM"] 		= {false, true, false, true},
	["TRICORNER-TOPLEFT"] 		= {true, true, true, false},
	["TRICORNER-TOPRIGHT"] 		= {true, false, true, true},
	["TRICORNER-BOTTOMLEFT"] 	= {true, true, false, true},
	["TRICORNER-BOTTOMRIGHT"] 	= {false, true, true, true},
}

function R.DragFrame_OnUpdate(x, y)

	local pos, quad, round, radius = nil, nil, nil, DB.buttonRadius - RazerOrbweaverMinimapButton:GetWidth()/math.pi
	local sqRad = sqrt(2*(radius)^2)

	local xmin, ymin = Minimap:GetLeft(), Minimap:GetBottom()

	local minimapShape = GetMinimapShape and GetMinimapShape() or "ROUND"
	local quadTable = minimapShapes[minimapShape]

	local xpos, ypos = x, y

	if (not xpos or not ypos) then
		xpos, ypos = GetCursorPosition()
	end

	xpos = xmin - xpos / Minimap:GetEffectiveScale() + radius
	ypos = ypos / Minimap:GetEffectiveScale() - ymin - radius

	pos = math.deg(math.atan2(ypos,xpos))

	xpos = cos(pos)
	ypos = sin(pos)

	if (xpos > 0 and ypos > 0) then
		quad = 1 --topleft
	elseif (xpos > 0 and ypos < 0) then
		quad = 2 --bottomleft
	elseif (xpos < 0 and ypos > 0) then
		quad = 3 --topright
	elseif (xpos < 0 and ypos < 0) then
		quad = 4 --bottomright
	end

	round = quadTable[quad]

	if (round) then
		xpos = xpos * radius
		ypos = ypos * radius
	else
		xpos = max(-radius, min(xpos * sqRad, radius))
		ypos = max(-radius, min(ypos * sqRad, radius))
	end

	RazerOrbweaverMinimapButton:SetPoint("TOPLEFT", "Minimap", "TOPLEFT", 52-xpos, ypos-55)

	DB.buttonLoc = { 52-xpos, ypos-55 }
end

function R.MinimapButton_OnLoad(minimap)

	minimap:RegisterForClicks("AnyUp")
	minimap:RegisterForDrag("LeftButton")
	minimap:RegisterEvent("PLAYER_LOGIN")
	minimap.elapsed = 0
	minimap.x = 0
	minimap.y = 0
	minimap.count = 1
	minimap.angle = 0
	minimap:SetFrameStrata(MinimapCluster:GetFrameStrata())
	minimap:SetFrameLevel(MinimapCluster:GetFrameLevel()+3)

end

function R.MinimapButton_OnEvent(minimap)

	R.MinimapButton_OnDragStop(minimap)

end

function R.MinimapButton_OnDragStart(minimap)

	minimap:LockHighlight()
	minimap:StartMoving()
	RazerOrbweaverMinimapButtonDragFrame:Show()
end

function R.MinimapButton_OnDragStop(minimap)

	minimap:UnlockHighlight()
	minimap:StopMovingOrSizing()
	minimap:SetUserPlaced(false)
	minimap:ClearAllPoints()
	if (DB and DB.buttonLoc) then
		minimap:SetPoint("TOPLEFT", "Minimap","TOPLEFT", DB.buttonLoc[1], DB.buttonLoc[2])
	end
	RazerOrbweaverMinimapButtonDragFrame:Hide()
end

function R.MinimapButton_OnShow(minimap)

	if (DB) then
		R.MinimapButton_OnDragStop(minimap)
	end
end

function R.MinimapButton_OnHide(minimap)

	minimap:UnlockHighlight()
	RazerOrbweaverMinimapButtonDragFrame:Hide()
end

function R.MinimapButton_OnEnter(minimap)


	GameTooltip:Show()
end

function R.MinimapButton_OnLeave(minimap)

	GameTooltip:Hide()
end

function R.RazerNagaConfig(lock)
	if (InCombatLockdown()) then return end

	if (lock) then
		R.GamePad:Hide()

		if (not IsShiftKeyDown()) then
			R.ToggleBindings(nil, true)
		end

		if (R.GUI) then
			R.GUI:Hide()
		end

	else
		R.GamePad:Show()
	end
end

function R.RazerNagaTooltip()

	local text = GameTooltipTextLeft1:GetText()

	if (text) then

		text = text:gsub("RazerNaga", "RazerNaga + RazerOrbweaver")

		GameTooltipTextLeft1:SetText(text)
	end
end

function R.RazerNagaOnClick()
	if IsShiftKeyDown() then
		R.ToggleBindings()
	end
end

function R.MinimapButton_OnClick(minimap, button)

	PlaySound("igChatScrollDown")

	if (InCombatLockdown()) then return end

	if (IsShiftKeyDown()) then

		R.ToggleBindings()

	else

		if (R.GamePad:IsVisible()) then

			R.GamePad:Hide()

			R.ToggleBindings(nil, true)

			if (R.GUI) then
				R.GUI:Hide()
			end
		else
			R.GamePad:Show()
		end
	end
end

function R.MinimapMenuClose()
	RazerOrbweaverMinimapButton.popup:Hide()
end

function R.UpdateData(data, defaults)

	-- Add new vars
	for key,value in pairs(defaults) do

		if (data[key] == nil) then

			if (data[key:lower()] ~= nil) then

				data[key] = data[key:lower()]
				data[key:lower()] = nil
			else
				data[key] = value
			end
		end
	end
	-- Add new vars

	-- Var fixes

		--none

	-- Var fixes

	-- Kill old vars
	for key,value in pairs(data) do

		if (defaults[key] == nil) then
			data[key] = nil
		end

		if (not DB.fix08082012:find(R.realm..":"..R.player) and key == "macro_Icon" and data[key] == "INTERFACE\\ICONS\\INV_MISC_QUESTIONMARK") then
			data[key] = false
		end
	end
	-- Kill old vars
end

function R:ToggleBlizzBar(on)

	if (R.OpDep) then return end

	if (on) then

		local button

		for i=1, NUM_OVERRIDE_BUTTONS do
			button = _G["OverrideActionBarButton"..i]
			handler:WrapScript(button, "OnShow", [[
				local key = GetBindingKey("ACTIONBUTTON"..self:GetID())
				if (key) then
					self:SetBindingClick(true, key, self:GetName())
				end
			]])
			handler:WrapScript(button, "OnHide", [[
				local key = GetBindingKey("ACTIONBUTTON"..self:GetID())
				if (key) then
					self:ClearBinding(key)
				end
			]])
		end

		TextStatusBar_Initialize(MainMenuExpBar)
		MainMenuExpBar:RegisterEvent("PLAYER_ENTERING_WORLD")
		MainMenuExpBar:RegisterEvent("PLAYER_XP_UPDATE")
		MainMenuExpBar.textLockable = 1
		MainMenuExpBar.cvar = "xpBarText"
		MainMenuExpBar.cvarLabel = "XP_BAR_TEXT"
		MainMenuExpBar.alwaysPrefix = true
		MainMenuExpBar_SetWidth(1024)

		MainMenuBar_OnLoad(MainMenuBarArtFrame)
		MainMenuBarVehicleLeaveButton_OnLoad(MainMenuBarVehicleLeaveButton)

		MainMenuBar:SetPoint("BOTTOM", 0, 0)
		MainMenuBar:Show()

		OverrideActionBar_OnLoad(OverrideActionBar)
		OverrideActionBar:SetPoint("BOTTOM", 0, 0)

	else

		local button

		for i=1, NUM_OVERRIDE_BUTTONS do
			button = _G["OverrideActionBarButton"..i]
			handler:UnwrapScript(button, "OnShow")
			handler:UnwrapScript(button, "OnHide")
		end

		MainMenuExpBar:UnregisterAllEvents()
		MainMenuBarArtFrame:UnregisterAllEvents()
		MainMenuBarArtFrame:RegisterEvent("CURRENCY_DISPLAY_UPDATE")
		MainMenuBarArtFrame:RegisterEvent("UNIT_LEVEL")
		MainMenuBarVehicleLeaveButton:UnregisterAllEvents()

		MainMenuBar:SetPoint("BOTTOM", 0, -200)
		MainMenuBar:Hide()

		OverrideActionBar:UnregisterAllEvents()
		OverrideActionBar:SetPoint("BOTTOM", 0, -200)
		OverrideActionBar:Hide()

	end
end

function R:BlizzBar()

	if (DB.mainbar) then
		DB.mainbar = false
	else
		DB.mainbar = true
	end

	R:ToggleBlizzBar(DB.mainbar)

end

function R:CreateBar(index, class, id)

	local data, show = R.RegisteredBarData[class]

	if (data) then

		if (not id) then

			id = 1

			for _ in ipairs(data.DB) do
				id = id + 1
			end

			newBar = true
		end

		local bar

		if (_G["Ion"..data.barType..id]) then
			bar = _G["Ion"..data.barType..id]
		else
			bar = CreateFrame("CheckButton", "Ion"..data.barType..id, UIParent, "IonBarTemplate")
		end

		for key,value in pairs(data) do
			bar[key] = value
		end

		setmetatable(bar, { __index = BAR })

		bar.index = index
		bar.class = class
		bar.stateschanged = true
		bar.vischanged =true
		bar.elapsed = 0
		bar.click = nil
		bar.dragged = false
		bar.selected = false
		bar.toggleframe = bar
		bar.microAdjust = false
		bar.vis = {}
		bar.text:Hide()
		bar.message:Hide()
		bar.messagebg:Hide()

		bar:SetID(id)
		bar:SetWidth(375)
		bar:SetHeight(40)
		bar:SetBackdrop({ bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		                  edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		                  tile = true, tileSize = 16, edgeSize = 12,
		                  insets = { left = 4, right = 4, top = 4, bottom = 4 } })
		bar:SetBackdropColor(0,0,0,0.4)
		bar:SetBackdropBorderColor(0,0,0,0)
		bar:SetFrameLevel(2)
		bar:RegisterForClicks("AnyDown", "AnyUp")
		bar:RegisterForDrag("LeftButton")
		bar:SetMovable(true)
		bar:EnableKeyboard(false)
		bar:SetPoint("CENTER", "UIParent", "CENTER", 0, 0)

		bar:SetScript("OnClick", BAR.OnClick)
		bar:SetScript("OnDragStart", BAR.OnDragStart)
		bar:SetScript("OnDragStop", BAR.OnDragStop)
		bar:SetScript("OnEnter", BAR.OnEnter)
		bar:SetScript("OnLeave", BAR.OnLeave)
		bar:SetScript("OnEvent", BAR.OnEvent)
		bar:SetScript("OnKeyDown", BAR.OnKeyDown)
		bar:SetScript("OnKeyUp", BAR.OnKeyUp)
		bar:SetScript("OnMouseWheel", BAR.OnMouseWheel)
		bar:SetScript("OnShow", BAR.OnShow)
		bar:SetScript("OnHide", BAR.OnHide)
		bar:SetScript("OnUpdate", BAR.OnUpdate)

		bar:RegisterEvent("ACTIONBAR_SHOWGRID")
		bar:RegisterEvent("ACTIONBAR_HIDEGRID")
		bar:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED")

		bar:CreateDriver()
		bar:CreateHandler()
		bar:CreateWatcher()

		bar:LoadData()

		if (not newBar) then
			bar:Hide()
		end

		BARIndex[index] = bar

		BARNameIndex[bar:GetName()] = bar

		return bar, newBar
	end
end

function R.Inititialize()


end

local events = {}

local firstevent = false

function R.Control_OnEvent(self, event, ...)

	--if (not RazerOrbweaverDB.debug.events) then RazerOrbweaverDB.debug.events = {}
	--elseif (not firstevent) then wipe(RazerOrbweaverDB.debug.events) firstevent = true end
	--tinsert(RazerOrbweaverDB.debug.events, { event, GetActiveSpecGroup() })

	R.CurrEvent = event

	if (event == "ADDON_LOADED" and ... == "RazerOrbweaver") then

		R.player, R.class, R.level, R.realm = UnitName("player"), select(2, UnitClass("player")), UnitLevel("player"), GetRealmName()

		for k,v in pairs(opDepList) do
			if (IsAddOnLoaded(v)) then
				R.OpDep = true
			end
		end

		if IsAddOnLoaded("RazerNaga") then	
			hooksecurefunc(RazerNaga, 'SetLock', function(self, lock) R.RazerNagaConfig(lock); end)
		
			local hookNagaButton = function()
				local LDB = LibStub:GetLibrary('LibDataBroker-1.1', true)			
				
				local RazerNagaButton = LDB and LDB:GetDataObjectByName('RazerNaga')
				
				if RazerNagaButton then
					hooksecurefunc(RazerNagaButton, 'OnClick', R.RazerNagaOnClick)
					hooksecurefunc(RazerNagaButton, 'OnTooltipShow', R.RazerNagaTooltip)
					RazerOrbweaverMinimapButton:Hide()
					
					return true
				end
				
				return false				
			end
			
			if not hookNagaButton() then
				hooksecurefunc(RazerNaga, 'CreateDataBrokerPlugin', hookNagaButton)
			end
		end

		DB = RazerOrbweaverDB

		for k,v in pairs(defaultDB) do
			if (DB[k] == nil) then
				DB[k] = v
			end
		end

		if (DB.firstRun[R.realm] == nil) then
			DB.firstRun[R.realm] = {}
		end

		if (DB.firstRun[R.realm][R.player] == nil) then
			DB.firstRun[R.realm][R.player] = true
		end

		if (RazerOrbweaverSpec[R.realm] == nil) then
			RazerOrbweaverSpec[R.realm] = {}
		end

		if (RazerOrbweaverSpec[R.realm][R.player] == nil) then
			RazerOrbweaverSpec[R.realm][R.player] = { cSpec = 1 }
		end

		ROS = RazerOrbweaverSpec[R.realm][R.player]

		for k,v in pairs(specDefaults) do
			if (ROS[k] == nil) then
				ROS[k] = v
			end
		end

		R:UpdateShapeshiftStrings()

		R.KeyMap:SetAttribute("_onstate-keymap", [[

					local keymap = tonumber(self:GetAttribute("state-keymap"))

					if (keymap) then
						self:SetAttribute("keymap", keymap)
						control:ChildUpdate("keymap", self:GetAttribute("keymap"))
					end

					]])

		R.KeyMap:HookScript("OnAttributeChanged", function(self, name, value) if (name == "keymap") then DB.KeyMap = value end end)

		RegisterStateDriver(R.KeyMap, "keymap", "keymap")

	elseif (event == "VARIABLES_LOADED") then

		local index, button, texture = 1

		SlashCmdList["RAZERONE"] = slashHandler
		SLASH_RAZERONE1 = L.SLASH1
		SLASH_RAZERONE2 = L.SLASH2

		--because for some silly reason the Ace3 "BetterBlizzOptions" library changes the strata
		--this puts it back where Blizz put it
		InterfaceOptionsFrame:SetFrameStrata("HIGH")

	elseif (event == "PLAYER_LOGIN") then

		R.Inititialize()

	elseif (event == "PLAYER_ENTERING_WORLD" and not PEW) then

		DB.firstRun[R.realm][R.player] = false

		R:UpdateSpellIndex()
		R:UpdatePetSpellIndex()
		R:UpdateShapeshiftStrings()
		R:UpdateCompanionData()
		R:UpdateIconIndex()

		R:ToggleBlizzBar(DB.mainbar)

		if (not DB.fix08082012:find(R.realm..":"..R.player)) then
			DB.fix08082012 = DB.fix08082012..R.realm..":"..R.player..";"
		end

		collectgarbage(); PEW = true

	elseif (event == "PLAYER_SPECIALIZATION_CHANGED" or event == "PLAYER_TALENT_UPDATE" or event == "PLAYER_LOGOUT" or event == "PLAYER_LEAVING_WORLD") then

		ROS.cSpec = GetActiveSpecGroup()

	elseif (event == "ACTIVE_TALENT_GROUP_CHANGED") then

		R.KeyMap:SetAttribute("state-keymap", 1)

		R:UpdateSpellIndex()
		R:UpdateShapeshiftStrings()

	elseif (event == "LEARNED_SPELL_IN_TAB" or event == "CHARACTER_POINTS_CHANGED") then

		R:UpdateSpellIndex()
		R:UpdateShapeshiftStrings()

	elseif (event == "PET_UI_CLOSE" or event == "COMPANION_LEARNED" or event == "COMPANION_UPDATE") then

		R:UpdateCompanionData()

	elseif (event == "UNIT_PET" and ... == "player") then

		R:UpdatePetSpellIndex()

	end
end

local frame = CreateFrame("Frame", "RazerOrbweaverControl", UIParent)

frame.elapsed = 0
frame:SetScript("OnEvent", R.Control_OnEvent)
frame:RegisterEvent("ADDON_LOADED")
frame:RegisterEvent("VARIABLES_LOADED")
frame:RegisterEvent("PLAYER_LOGIN")
frame:RegisterEvent("PLAYER_LOGOUT")
frame:RegisterEvent("PLAYER_ENTERING_WORLD")
frame:RegisterEvent("PLAYER_LEAVING_WORLD")
frame:RegisterEvent("PLAYER_SPECIALIZATION_CHANGED")
frame:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED")
frame:RegisterEvent("SKILL_LINES_CHANGED")
frame:RegisterEvent("CHARACTER_POINTS_CHANGED")
frame:RegisterEvent("LEARNED_SPELL_IN_TAB")
frame:RegisterEvent("CURSOR_UPDATE")
frame:RegisterEvent("PET_UI_CLOSE")
frame:RegisterEvent("COMPANION_LEARNED")
frame:RegisterEvent("COMPANION_UPDATE")
frame:RegisterEvent("UNIT_PET")
--frame:RegisterAllEvents()

frame = CreateFrame("GameTooltip", "RazerOrbweaverTooltipScan", UIParent, "GameTooltipTemplate")
frame:SetOwner(UIParent, "ANCHOR_NONE")
frame:SetFrameStrata("TOOLTIP")
frame:Hide()

