﻿--RazerOrbweaver, a World of Warcraft® user interface addon.

local R, DB, PEW, GP, player, realm, barGDB, barCDB = RazerOrbweaver

local BAR = setmetatable({}, { __index = CreateFrame("CheckButton") })

local HANDLER = setmetatable({}, { __index = CreateFrame("Frame") })

local L = LibStub("AceLocale-3.0"):GetLocale("RazerOrbweaver")

local	SKIN = LibStub("Masque", true)

local KeyMap = R.KeyMap

local BARIndex, BTNIndex = R.BARIndex, R.BTNIndex

local MS = R.MS

local gsub = string.gsub
local find = string.find
local match = string.match
local gmatch = string.gmatch
local format = string.format
local lower = string.lower
local upper = string.upper
local floor = math.floor
local ceil = math.ceil
local mod = mod

local InCombatLockdown = _G.InCombatLockdown

local dpadswap = {}

local barLayouts = {

	[1] = {
		[1] = "0;100",
		[2] = "0;-100",
	},

	[2] = {
		[1] = "0;100",
		[2] = "0;-100",
	},
}

local barGData = {

	[1] = {
		shape = 1,
		count = 20,
		columns = 5,
		buttonList = "101;102;103;104;105;106;107;108;109;110;111;112;113;114;115;116;117;118;119;120",
	},

	[2] = {
		shape = 2,
		count = 10,
		columns = 1,
		buttonList = "201;202;203;204;205;206;207;208;209;210",
	},
}

local barGlobalDefaults = {

	name = "",

	shape = 1,
	count = 1,
	columns = 1,

	buttonList = "",
	pad = 0,
	scale = 1,

	yom = 0,

}

local barCharDefaults = {

	barLock = false,
	barLockAlt = false,
	barLockCtrl = false,
	barLockShift = false,

	tooltips = true,
	tooltipsEnhanced = true,
	tooltipsCombat = false,

	spellGlow = true,
	spellGlowDef = true,
	spellGlowAlt = false,

	bindText = true,
	macroText = true,
	countText = true,

	cdText = false,
	cdAlpha = false,
	auraText = false,
	auraInd = false,

	upClicks = true,
	downClicks = false,

	rangeInd = true,

	currentstate = "homestate",
	laststate = "homestate",

	homestate = true,
	pagedbar = false,
	stance = false,
	prowl = false,
	stealth = false,
	reaction = false,
	combat = false,
	group = false,
	companion = false,
	fishing = false,
	alt = false,
	ctrl = false,
	shift = false,
	vehicle = false,
	possess = false,
	override = false,

	custom = false,
	customRange = false,
	customNames = false,

	remap = false,
}

local function round(num, idp)

      local mult = 10^(idp or 0)
      return math.floor(num * mult + 0.5) / mult

end

function HANDLER:BuildStateMap(bar, remapState)

	local statemap, state, map, remap, homestate = "", gsub(remapState, "pagedbar", "bar")

	for states in gmatch(bar.cdata.remap, "[^;]+") do

		map, remap = (":"):split(states)

		if (remapState == "stance" and R.class == "ROGUE" and map == "2") then
			map = "3"
		end

		if (not homestate) then
			statemap = statemap.."["..state..":"..map.."] homestate; "; homestate = true
		else
			local newstate = remapState..remap

			if (MS[remapState] and
			    MS[remapState].homestate and
			    MS[remapState].homestate == newstate) then
				statemap = statemap.."["..state..":"..map.."] homestate; "
			else
				statemap = statemap.."["..state..":"..map.."] "..newstate.."; "
			end
		end

		if (map == "1" and bar.cdata.prowl and remapState == "stance") then
			statemap = statemap.."[stance:2/3,stealth] stance8; "
		end
	end

	statemap = gsub(statemap, "; $", "")

	return statemap
end

function HANDLER:AddStates(bar, state, conditions)

	if (MS[state]) then
		RegisterStateDriver(self, state, conditions)
	end

	if (MS[state].homestate) then
		self:SetAttribute("handler-homestate", MS[state].homestate)
	end

	bar[state].registered = true

end

function HANDLER:ClearStates(bar, state)

	local clearState

	if (state ~= "homestate") then

		if (MS[state].homestate) then
			self:SetAttribute("handler-homestate", nil)
		end

		self:SetAttribute("state-"..state, nil)

		UnregisterStateDriver(self, state)

		bar[state].registered = false
	end

	self:SetAttribute("state-current", "homestate")
	self:SetAttribute("state-last", "homestate")

end

function HANDLER:UpdateStates(bar)

	for state, values in pairs(MS) do

		if (bar.cdata[state]) then

			if (not bar[state] or not bar[state].registered) then

				local statemap

				if (not bar[state]) then
					bar[state] = {}
				end

				if (bar.cdata.remap) then
					if (state == "pagedbar" or state == "stance") then
						statemap = self:BuildStateMap(self.bar, state)
					end
				end

				if (state == "custom" and bar.cdata.custom) then

					self:AddStates(self.bar, state, bar.cdata.custom)

				elseif (statemap) then

					self:AddStates(self.bar, state, statemap)

				else
					self:AddStates(self.bar, state, values.states)

				end
			end

		elseif (bar[state] and bar[state].registered) then

			self:ClearStates(self.bar, state)

		end
	end
end

local HANDLER_MT = { __index = HANDLER }

function BAR:CreateHandler()

	local handler = CreateFrame("Frame", "RazerOrbweaverBarHandler"..self:GetID(), R.KeyMap, "SecureHandlerStateTemplate")

	setmetatable(handler, HANDLER_MT)

	handler:SetID(self:GetID())

	handler:SetAttribute("_onstate-pagedbar", [[

						if (self:GetAttribute("statestack")) then
							if (self:GetAttribute("statestack"):find("pagedbar")) then
								self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("pagedbar%d+", self:GetAttribute("state-pagedbar") or "homestate"))
							elseif (self:GetAttribute("statestack"):find("homestate")) then
								self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("homestate", self:GetAttribute("state-pagedbar") or "homestate"))
							elseif (self:GetAttribute("state-pagedbar")) then
								self:SetAttribute("statestack", self:GetAttribute("statestack")..";"..self:GetAttribute("state-pagedbar"))
							end
						else
							self:SetAttribute("statestack", self:GetAttribute("state-pagedbar"))
						end

						if (self:GetAttribute("statestack"):find("^pagedbar") or self:GetAttribute("statestack"):find("^homestate")) then

							self:SetAttribute("assertstate", "pagedbar")

							self:SetAttribute("state-last", self:GetAttribute("state-pagedbar"))

							self:SetAttribute("state-current", self:GetAttribute("state-pagedbar"))

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("pagedbar", self:GetAttribute("state-priority"))
							elseif (self:GetAttribute("state-pagedbar") and self:GetAttribute("state-pagedbar") == self:GetAttribute("handler-homestate")) then
								control:ChildUpdate("pagedbar", "homestate:"..self:GetAttribute("state-pagedbar"))
							else
								control:ChildUpdate("pagedbar", self:GetAttribute("state-pagedbar"))
							end
						else
							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("homestate", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("homestate", "homestate")
							end
						end

						]])

	handler:SetAttribute("_onstate-stance", [[

						if (self:GetAttribute("statestack")) then
							if (self:GetAttribute("statestack"):find("stance")) then
								self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("stance%d+", self:GetAttribute("state-stance") or "homestate"))
							elseif (self:GetAttribute("statestack"):find("homestate")) then
								self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("homestate", self:GetAttribute("state-stance") or "homestate"))
							elseif (self:GetAttribute("state-stance")) then
								self:SetAttribute("statestack", self:GetAttribute("statestack")..";"..self:GetAttribute("state-stance"))
							end
						else
							self:SetAttribute("statestack", self:GetAttribute("state-stance"))
						end

						if (self:GetAttribute("statestack"):find("^stance") or self:GetAttribute("statestack"):find("^homestate")) then

							self:SetAttribute("assertstate", "stance")

							self:SetAttribute("state-last", self:GetAttribute("state-stance"))

							self:SetAttribute("state-current", self:GetAttribute("state-stance"))

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("stance", self:GetAttribute("state-priority"))
							elseif (self:GetAttribute("state-stance") and self:GetAttribute("state-stance") == self:GetAttribute("handler-homestate")) then
								control:ChildUpdate("stance", "homestate:"..self:GetAttribute("state-stance"))
							else
								control:ChildUpdate("stance", self:GetAttribute("state-stance"))
							end
						else
							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("homestate", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("homestate", "homestate")
							end
						end

						]])

	handler:SetAttribute("_onstate-companion", [[

						if (self:GetAttribute("statestack")) then
							if (self:GetAttribute("statestack"):find("companion")) then
								self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("companion%d+", self:GetAttribute("state-companion") or "homestate"))
							elseif (self:GetAttribute("statestack"):find("homestate")) then
								self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("homestate", self:GetAttribute("state-companion" or "homestate")))
							elseif (self:GetAttribute("state-companion")) then
								self:SetAttribute("statestack", self:GetAttribute("statestack")..";"..self:GetAttribute("state-companion"))
							end
						else
							self:SetAttribute("statestack", self:GetAttribute("state-companion"))
						end

						if (self:GetAttribute("statestack"):find("^companion") or self:GetAttribute("statestack"):find("^homestate")) then

							self:SetAttribute("assertstate", "companion")

							self:SetAttribute("state-last", self:GetAttribute("state-companion"))

							self:SetAttribute("state-current", self:GetAttribute("state-companion"))

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("companion", self:GetAttribute("state-priority"))
							elseif (self:GetAttribute("state-companion") and self:GetAttribute("state-companion") == self:GetAttribute("handler-homestate")) then
								control:ChildUpdate("companion", "homestate:"..self:GetAttribute("state-companion"))
							else
								control:ChildUpdate("companion", self:GetAttribute("state-companion"))
							end
						else
							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("homestate", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("homestate", "homestate")
							end
						end

						]])

	handler:SetAttribute("_onstate-stealth", [[

						if (self:GetAttribute("state-stealth") == "laststate") then

							if (self:GetAttribute("statestack")) then

								if (self:GetAttribute("statestack"):find("stealth")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("stealth%d+;", ""))
								end

								local laststate = (";"):split(self:GetAttribute("statestack"))

								self:SetAttribute("state-last", laststate)

							end

							self:SetAttribute("state-current", self:GetAttribute("state-last") or "homestate")

							if (self:GetAttribute("state-last")) then
								self:SetAttribute("assertstate", self:GetAttribute("state-last"):gsub("%d+", ""))
							else
								self:SetAttribute("assertstate", "homestate")
							end

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("stealth", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("stealth", self:GetAttribute("state-last") or "homestate")
							end

						elseif (self:GetAttribute("state-stealth")) then

							if (self:GetAttribute("statestack")) then
								if (self:GetAttribute("statestack"):find("stealth")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("stealth%d+", self:GetAttribute("state-restealthction")))
								else
									self:SetAttribute("statestack", self:GetAttribute("state-stealth")..";"..self:GetAttribute("statestack"))
								end
							else
								self:SetAttribute("statestack", self:GetAttribute("state-stealth"))
							end

							self:SetAttribute("state-current", self:GetAttribute("state-stealth"))

							self:SetAttribute("assertstate", "stealth")

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("stealth", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("stealth", self:GetAttribute("state-stealth"))
							end

						end

						]])

	handler:SetAttribute("_onstate-reaction", [[

						if (self:GetAttribute("state-reaction") == "laststate") then

							if (self:GetAttribute("statestack")) then

								if (self:GetAttribute("statestack"):find("reaction")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("reaction%d+;", ""))
								end

								local laststate = (";"):split(self:GetAttribute("statestack"))

								self:SetAttribute("state-last", laststate)

							end

							self:SetAttribute("state-current", self:GetAttribute("state-last") or "homestate")

							if (self:GetAttribute("state-last")) then
								self:SetAttribute("assertstate", self:GetAttribute("state-last"):gsub("%d+", ""))
							else
								self:SetAttribute("assertstate", "homestate")
							end

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("reaction", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("reaction", self:GetAttribute("state-last") or "homestate")
							end

						elseif (self:GetAttribute("state-reaction")) then

							if (self:GetAttribute("statestack")) then
								if (self:GetAttribute("statestack"):find("reaction")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("reaction%d+", self:GetAttribute("state-reaction")))
								else
									self:SetAttribute("statestack", self:GetAttribute("state-reaction")..";"..self:GetAttribute("statestack"))
								end
							else
								self:SetAttribute("statestack", self:GetAttribute("state-reaction"))
							end

							self:SetAttribute("state-current", self:GetAttribute("state-reaction"))

							self:SetAttribute("assertstate", "reaction")

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("reaction", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("reaction", self:GetAttribute("state-reaction"))
							end
						end

						]])

	handler:SetAttribute("_onstate-combat", [[

						if (self:GetAttribute("state-combat") == "laststate") then

							if (self:GetAttribute("statestack")) then

								if (self:GetAttribute("statestack"):find("combat")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("combat%d+;", ""))
								end

								local laststate = (";"):split(self:GetAttribute("statestack"))

								self:SetAttribute("state-last", laststate)

							end

							self:SetAttribute("state-current", self:GetAttribute("state-last") or "homestate")

							if (self:GetAttribute("state-last")) then
								self:SetAttribute("assertstate", self:GetAttribute("state-last"):gsub("%d+", ""))
							else
								self:SetAttribute("assertstate", "homestate")
							end

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("combat", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("combat", self:GetAttribute("state-last") or "homestate")
							end

						elseif (self:GetAttribute("state-combat")) then

							if (self:GetAttribute("statestack")) then
								if (self:GetAttribute("statestack"):find("combat")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("combat%d+", self:GetAttribute("state-combat")))
								else
									self:SetAttribute("statestack", self:GetAttribute("state-combat")..";"..self:GetAttribute("statestack"))
								end
							else
								self:SetAttribute("statestack", self:GetAttribute("state-combat"))
							end

							self:SetAttribute("state-current", self:GetAttribute("state-combat"))

							self:SetAttribute("assertstate", "combat")

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("combat", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("combat", self:GetAttribute("state-combat"))
							end
						end

						]])

	handler:SetAttribute("_onstate-group", [[

						if (self:GetAttribute("state-group") == "laststate") then

							if (self:GetAttribute("statestack")) then

								if (self:GetAttribute("statestack"):find("group")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("group%d+;", ""))
								end

								local laststate = (";"):split(self:GetAttribute("statestack"))

								self:SetAttribute("state-last", laststate)

							end

							self:SetAttribute("state-current", self:GetAttribute("state-last") or "homestate")

							if (self:GetAttribute("state-last")) then
								self:SetAttribute("assertstate", self:GetAttribute("state-last"):gsub("%d+", ""))
							else
								self:SetAttribute("assertstate", "homestate")
							end

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("group", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("group", self:GetAttribute("state-last") or "homestate")
							end

						elseif (self:GetAttribute("state-group")) then

							if (self:GetAttribute("statestack")) then
								if (self:GetAttribute("statestack"):find("group")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("group%d+", self:GetAttribute("state-group")))
								else
									self:SetAttribute("statestack", self:GetAttribute("state-group")..";"..self:GetAttribute("statestack"))
								end
							else
								self:SetAttribute("statestack", self:GetAttribute("state-group"))
							end

							self:SetAttribute("state-current", self:GetAttribute("state-group"))

							self:SetAttribute("assertstate", "group")

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("group", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("group", self:GetAttribute("state-group"))
							end
						end

						]])

	handler:SetAttribute("_onstate-fishing", [[

						if (self:GetAttribute("state-fishing") == "laststate") then

							if (self:GetAttribute("statestack")) then

								if (self:GetAttribute("statestack"):find("fishing")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("fishing%d+;", ""))
								end

								local laststate = (";"):split(self:GetAttribute("statestack"))

								self:SetAttribute("state-last", laststate)

							end

							self:SetAttribute("state-current", self:GetAttribute("state-last") or "homestate")

							if (self:GetAttribute("state-last")) then
								self:SetAttribute("assertstate", self:GetAttribute("state-last"):gsub("%d+", ""))
							else
								self:SetAttribute("assertstate", "homestate")
							end

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("fishing", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("fishing", self:GetAttribute("state-last") or "homestate")
							end

						elseif (self:GetAttribute("state-fishing")) then

							if (self:GetAttribute("statestack")) then
								if (self:GetAttribute("statestack"):find("fishing")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("fishing%d+", self:GetAttribute("state-fishing")))
								else
									self:SetAttribute("statestack", self:GetAttribute("state-fishing")..";"..self:GetAttribute("statestack"))
								end
							else
								self:SetAttribute("statestack", self:GetAttribute("state-fishing"))
							end

							self:SetAttribute("state-current", self:GetAttribute("state-fishing"))

							self:SetAttribute("assertstate", "fishing")

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("fishing", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("fishing", self:GetAttribute("state-fishing"))
							end
						end

						]])

	handler:SetAttribute("_onstate-alt", [[

						if (self:GetAttribute("state-alt") == "laststate") then

							if (self:GetAttribute("statestack")) then

								if (self:GetAttribute("statestack"):find("alt")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("alt%d+;", ""))
								end

								local laststate = (";"):split(self:GetAttribute("statestack"))

								self:SetAttribute("state-last", laststate)

							end

							self:SetAttribute("state-current", self:GetAttribute("state-last") or "homestate")

							if (self:GetAttribute("state-last")) then
								self:SetAttribute("assertstate", self:GetAttribute("state-last"):gsub("%d+", ""))
							else
								self:SetAttribute("assertstate", "homestate")
							end

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("alt", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("alt", self:GetAttribute("state-last") or "homestate")
							end

						elseif (self:GetAttribute("state-alt")) then

							if (self:GetAttribute("statestack")) then
								if (self:GetAttribute("statestack"):find("alt")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("alt%d+", self:GetAttribute("state-alt")))
								else
									self:SetAttribute("statestack", self:GetAttribute("state-alt")..";"..self:GetAttribute("statestack"))
								end
							else
								self:SetAttribute("statestack", self:GetAttribute("state-alt"))
							end

							self:SetAttribute("state-current", self:GetAttribute("state-alt"))

							self:SetAttribute("assertstate", "alt")

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("alt", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("alt", self:GetAttribute("state-alt"))
							end
						end

						]])

	handler:SetAttribute("_onstate-ctrl", [[

						if (self:GetAttribute("state-ctrl") == "laststate") then

							if (self:GetAttribute("statestack")) then
								if (self:GetAttribute("statestack"):find("ctrl")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("ctrl%d+;", ""))
								end

								local laststate = (";"):split(self:GetAttribute("statestack"))

								self:SetAttribute("state-last", laststate)
							end

							self:SetAttribute("state-current", self:GetAttribute("state-last") or "homestate")

							if (self:GetAttribute("state-last")) then
								self:SetAttribute("assertstate", self:GetAttribute("state-last"):gsub("%d+", ""))
							else
								self:SetAttribute("assertstate", "homestate")
							end

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("ctrl", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("ctrl", self:GetAttribute("state-last") or "homestate")
							end

						elseif (self:GetAttribute("state-ctrl")) then

							if (self:GetAttribute("statestack")) then
								if (self:GetAttribute("statestack"):find("ctrl")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("ctrl%d+", self:GetAttribute("state-ctrl")))
								else
									self:SetAttribute("statestack", self:GetAttribute("state-ctrl")..";"..self:GetAttribute("statestack"))
								end
							else
								self:SetAttribute("statestack", self:GetAttribute("state-ctrl"))
							end

							self:SetAttribute("state-current", self:GetAttribute("state-ctrl"))

							self:SetAttribute("assertstate", "ctrl")

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("ctrl", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("ctrl", self:GetAttribute("state-ctrl"))
							end
						end

						]])

	handler:SetAttribute("_onstate-shift", [[

						if (self:GetAttribute("state-shift") == "laststate") then

							if (self:GetAttribute("statestack")) then
								if (self:GetAttribute("statestack"):find("shift")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("shift%d+;", ""))
								end

								local laststate = (";"):split(self:GetAttribute("statestack"))

								self:SetAttribute("state-last", laststate)
							end

							self:SetAttribute("state-current", self:GetAttribute("state-last") or "homestate")

							if (self:GetAttribute("state-last")) then
								self:SetAttribute("assertstate", self:GetAttribute("state-last"):gsub("%d+", ""))
							else
								self:SetAttribute("assertstate", "homestate")
							end

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("shift", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("shift", self:GetAttribute("state-last") or "homestate")
							end

						elseif (self:GetAttribute("state-shift")) then

							if (self:GetAttribute("statestack")) then
								if (self:GetAttribute("statestack"):find("shift")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("shift%d+", self:GetAttribute("state-shift")))
								else
									self:SetAttribute("statestack", self:GetAttribute("state-shift")..";"..self:GetAttribute("statestack"))
								end
							else
								self:SetAttribute("statestack", self:GetAttribute("state-shift"))
							end

							self:SetAttribute("state-current", self:GetAttribute("state-shift"))

							self:SetAttribute("assertstate", "shift")

							if (self:GetAttribute("state-priority")) then
								control:ChildUpdate("shift", self:GetAttribute("state-priority"))
							else
								control:ChildUpdate("shift", self:GetAttribute("state-shift"))
							end
						end

						]])

	handler:SetAttribute("_onstate-vehicle", [[

						if (self:GetAttribute("state-vehicle") == "laststate") then

							if (self:GetAttribute("statestack")) then

								if (self:GetAttribute("statestack"):find("vehicle")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("vehicle%d+;", ""))
								end

								local laststate = (";"):split(self:GetAttribute("statestack"))

								self:SetAttribute("state-last", laststate)

							end

							self:SetAttribute("state-priority", nil)

							self:SetAttribute("state-current", self:GetAttribute("state-last") or "homestate")

							if (self:GetAttribute("state-last")) then
								self:SetAttribute("assertstate", self:GetAttribute("state-last"):gsub("%d+", ""))
							else
								self:SetAttribute("assertstate", "homestate")
							end

							control:ChildUpdate("vehicle", self:GetAttribute("state-last") or "homestate")

						elseif (self:GetAttribute("state-vehicle")) then

							if (self:GetAttribute("statestack")) then
								if (self:GetAttribute("statestack"):find("vehicle")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("vehicle%d+", self:GetAttribute("state-vehicle")))
								else
									self:SetAttribute("statestack", self:GetAttribute("state-vehicle")..";"..self:GetAttribute("statestack"))
								end
							else
								self:SetAttribute("statestack", self:GetAttribute("state-vehicle"))
							end

							self:SetAttribute("state-priority", self:GetAttribute("state-vehicle"))

							self:SetAttribute("state-current", self:GetAttribute("state-vehicle"))

							self:SetAttribute("assertstate", "vehicle")

							control:ChildUpdate("vehicle", self:GetAttribute("state-vehicle"))
						end

						]])

	handler:SetAttribute("_onstate-possess", [[

						if (self:GetAttribute("state-possess") == "laststate") then

							if (self:GetAttribute("statestack")) then

								if (self:GetAttribute("statestack"):find("possess")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("possess%d+;", ""))
								end

								local laststate = (";"):split(self:GetAttribute("statestack"))

								self:SetAttribute("state-last", laststate)

							end

							self:SetAttribute("state-priority", nil)

							self:SetAttribute("state-current", self:GetAttribute("state-last") or "homestate")

							if (self:GetAttribute("state-last")) then
								self:SetAttribute("assertstate", self:GetAttribute("state-last"):gsub("%d+", ""))
							else
								self:SetAttribute("assertstate", "homestate")
							end

							control:ChildUpdate("possess", self:GetAttribute("state-last") or "homestate")

						elseif (self:GetAttribute("state-possess")) then

							if (self:GetAttribute("statestack")) then
								if (self:GetAttribute("statestack"):find("possess")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("possess%d+", self:GetAttribute("state-possess")))
								else
									self:SetAttribute("statestack", self:GetAttribute("state-possess")..";"..self:GetAttribute("statestack"))
								end
							else
								self:SetAttribute("statestack", self:GetAttribute("state-possess"))
							end

							self:SetAttribute("state-priority", self:GetAttribute("state-possess"))

							self:SetAttribute("state-current", self:GetAttribute("state-possess"))

							self:SetAttribute("assertstate", "possess")

							control:ChildUpdate("possess", self:GetAttribute("state-possess"))
						end

						]])

	handler:SetAttribute("_onstate-override", [[

						if (self:GetAttribute("state-override") == "laststate") then

							if (self:GetAttribute("statestack")) then

								if (self:GetAttribute("statestack"):find("override")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("override%d+;", ""))
								end

								local laststate = (";"):split(self:GetAttribute("statestack"))

								self:SetAttribute("state-last", laststate)

							end

							self:SetAttribute("state-priority", nil)

							self:SetAttribute("state-current", self:GetAttribute("state-last") or "homestate")

							if (self:GetAttribute("state-last")) then
								self:SetAttribute("assertstate", self:GetAttribute("state-last"):gsub("%d+", ""))
							else
								self:SetAttribute("assertstate", "homestate")
							end

							control:ChildUpdate("override", self:GetAttribute("state-last") or "homestate")

						elseif (self:GetAttribute("state-override")) then

							if (self:GetAttribute("statestack")) then
								if (self:GetAttribute("statestack"):find("override")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("override%d+", self:GetAttribute("state-override")))
								else
									self:SetAttribute("statestack", self:GetAttribute("state-override")..";"..self:GetAttribute("statestack"))
								end
							else
								self:SetAttribute("statestack", self:GetAttribute("state-override"))
							end

							self:SetAttribute("state-priority", self:GetAttribute("state-override"))

							self:SetAttribute("state-current", self:GetAttribute("state-override"))

							self:SetAttribute("assertstate", "override")

							control:ChildUpdate("override", self:GetAttribute("state-override"))
						end

						]])

	handler:SetAttribute("_onstate-extrabar", [[

						if (self:GetAttribute("state-extrabar") == "laststate") then

							if (self:GetAttribute("statestack")) then

								if (self:GetAttribute("statestack"):find("extrabar")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("extrabar%d+;", ""))
								end

								local laststate = (";"):split(self:GetAttribute("statestack"))

								self:SetAttribute("state-last", laststate)

							end

							self:SetAttribute("state-priority", self:GetAttribute("state-nil"))

							self:SetAttribute("state-current", self:GetAttribute("state-last") or "homestate")

							if (self:GetAttribute("state-last")) then
								self:SetAttribute("assertstate", self:GetAttribute("state-last"):gsub("%d+", ""))
							else
								self:SetAttribute("assertstate", "homestate")
							end

							control:ChildUpdate("extrabar", self:GetAttribute("state-last") or "homestate")

						elseif (self:GetAttribute("state-extrabar")) then

							if (self:GetAttribute("statestack")) then
								if (self:GetAttribute("statestack"):find("extrabar")) then
									self:SetAttribute("statestack", self:GetAttribute("statestack"):gsub("extrabar%d+", self:GetAttribute("state-extrabar")))
								else
									self:SetAttribute("statestack", self:GetAttribute("state-extrabar")..";"..self:GetAttribute("statestack"))
								end
							else
								self:SetAttribute("statestack", self:GetAttribute("state-extrabar"))
							end

							self:SetAttribute("state-priority", self:GetAttribute("state-extrabar"))

							self:SetAttribute("state-current", self:GetAttribute("state-extrabar"))

							self:SetAttribute("assertstate", "extrabar")

							control:ChildUpdate("extrabar", self:GetAttribute("state-extrabar"))
						end

						]])

	handler:SetAttribute("_onstate-custom", [[

						self:SetAttribute("assertstate", "custom")

						self:SetAttribute("state-last", self:GetAttribute("state-custom"))

						self:SetAttribute("state-current", self:GetAttribute("state-custom"))

						control:ChildUpdate("alt", self:GetAttribute("state-custom"))

						]])

	handler:SetAttribute("_onstate-keymap", [[

						local keymap = tonumber(self:GetAttribute("state-keymap"))

						if (keymap) then
							control:ChildUpdate("keymap", self:GetAttribute("state-current") or "homestate")
						end

						]])

	handler:SetAttribute("_onstate-current", [[ self:SetAttribute("activestate", self:GetAttribute("state-current") or "homestate") ]])

	handler:SetAttribute("_onshow", [[ control:ChildUpdate("onshow", self:GetAttribute("state-current")) ]])

	handler:SetAttribute("_childupdate", [[ self:SetAttribute("state-keymap", message) ]] )

	handler:SetAttribute("statestack", "homestate")

	handler:SetAttribute("activestate", "homestate")

	handler:SetAttribute("state-last", "homestate")

	handler:HookScript("OnAttributeChanged",

			function(self,name,value)

			end)

	self.handler = handler; handler.bar = self

	RegisterStateDriver(handler, "keymap", "keymap")

	handler:SetAllPoints(self)
end

function BAR:CreateWatcher()

	local watcher = CreateFrame("Frame", "RazerOrbweaverBarWatcher"..self:GetID(), self.handler, "SecureHandlerStateTemplate")

	setmetatable(watcher, { __index = HANDLER })

	watcher:SetID(self:GetID())

	watcher:SetAttribute("_onattributechanged", [[ ]])

	watcher:SetAttribute("_onstate-petbattle", [[

			if (self:GetAttribute("state-petbattle") == "hide") then
				self:GetParent():Hide()
			elseif (not self:GetParent():IsShown() and not self:GetParent():GetAttribute("vishide")) then
				self:GetParent():Show()
			end
	]])

	RegisterStateDriver(watcher, "petbattle", "[petbattle] hide; [nopetbattle] show")

end

function BAR:Update()

	local handler = self.handler

	if (self.stateschanged) then

		handler:UpdateStates(self)

		self.stateschanged = false
	end

	self:SaveData()
end

function BAR:SetPosition()

	local id, layout = self:GetID(), barLayouts[DB.layout]

	if (id and layout) then

		local x, y = (";"):split(layout[id])

		local yOffset = self.gdata.pad * self.gdata.yom

		x = tonumber(x); y = tonumber(y)

		if (x and y) then
			self:SetPoint("CENTER", x*DB.scale, (y*DB.scale) + yOffset)
		end
	end
end

function BAR:CreateButtons()

	local button

	self.buttonCount = 0

	for btnID in gmatch(self.gdata.buttonList, "[^;]+") do

		btnID = tonumber(btnID)

		if (btnID) then

			button = _G["RazerOrbweaverButton"..btnID]

			if (not button) then
				button = R.CreateButton(btnID)
			end

			self.buttons[button] = true

			self.buttonCount = self.buttonCount + 1
		end
	end
end

function BAR:SetButtonLoc()

	local width, height, num, pad, count, columns = 0, 0, 0, self.gdata.pad, self.buttonCount, self.gdata.columns
	local shape, x, y, button, placed, first, last, offset = self.gdata.shape
	local rows = ceil((round(ceil(count/self.gdata.columns), 1)/2)+0.5)
	local cAdjust, rAdjust = 0.5, 1.5

	local highX, highY, lowX, lowY

	for btnID in gmatch(self.gdata.buttonList, "[^;]+") do

		button = _G["RazerOrbweaverButton"..btnID]

		if (button and num < count) then

			num = num + 1

			button:ClearAllPoints()

			button:SetParent(self.handler)

			width = button:GetWidth(); height = button:GetHeight()

			if (shape == 2) then

				local adjCount = count-2

				if (num <= 8) then

					if (not placed) then
						placed = 0
					end

					x = ((width+pad)*(adjCount/math.pi))*(cos(placed))
					y = ((width+pad)*(adjCount/math.pi))*(sin(placed))

					if (not highX or x > highX) then
						highX = x
					end

					if (not highY or y > highY) then
						highY = y
					end

					if (not lowX or x < lowX) then
						lowX = x
					end

					if (not lowY or y < lowY) then
						lowY = y
					end

					button:SetPoint("CENTER", self, "CENTER", x, y)

					placed = placed - (360/adjCount)

					if (mod(num,2) == 0) then
						tinsert(dpadswap, button)
					end

				elseif (num == 9) then

					button:SetPoint("CENTER", self, "CENTER", lowX+pad-17, highY-pad-10)

				elseif (num == 10) then

					button:SetPoint("CENTER", self, "CENTER", highX-pad+17, lowY+pad+10)

				end

			else

				if (not placed) then
					placed = 0
				end

				x = -(width + pad) * ((columns/2)-cAdjust)
				y = (height + pad) * (rows-rAdjust)

				button:SetPoint("CENTER", self, "CENTER", x, y)

				placed = placed + 1; cAdjust = cAdjust + 1

				if (placed >= columns) then
					placed = 0
					cAdjust = 0.5
					rAdjust = rAdjust + 1
				end
			end

			button:SetScale(self.gdata.scale*DB.scale)

		end
	end
end

function BAR:SetFauxState(state)

	local button

	self.handler:SetAttribute("fauxstate", state)

	for btnID in gmatch(self.gdata.buttonList, "[^;]+") do

		button = _G["RazerOrbweaverButton"..btnID]

		if (button) then
			button:SetFauxState(state)
		end
	end

	if (R.GUI and R.GUI:IsVisible()) then
		R.BarEditorUpdateData(self)
	end
end

function BAR:LoadButtons()

	local num, count = 0, self.buttonCount

	for btnID in gmatch(self.gdata.buttonList, "[^;]+") do

		button = _G["RazerOrbweaverButton"..btnID]

		if (button and num < count) then

			if (SKIN) then

				local btnData = {	Normal = button.normaltexture, Icon = button.iconframeicon, Cooldown = button.iconframecooldown, HotKey = button.hotkey, Count = button.count, Name = button.name, Border = button.border, AutoCast = false }

				SKIN:Group("RazerOrbweaver", self.gdata.name):AddButton(button, btnData)

			end

			button:SetData(self)

			button:LoadData(ROS.cSpec, self.handler:GetAttribute("activestate"))

			button:SetDefaults()

			button:SetType(true)
		end
	end
end

function BAR:SetPerimeter()

	local num, count = 0, self.buttonCount

	self.buttonCount = 0

	self.top = nil; self.bottom = nil; self.left = nil; self.right = nil

	for btnID in gmatch(self.gdata.buttonList, "[^;]+") do

		button = _G["RazerOrbweaverButton"..btnID]

		if (button and num < count) then

			local btnTop, btnBottom, btnLeft, btnRight = button:GetTop(), button:GetBottom(), button:GetLeft(), button:GetRight()
			local scale = 1

			self.buttonCount = self.buttonCount + 1

			if (self.top) then
				if (btnTop*scale > self.top) then self.top = btnTop*scale end
			else self.top = btnTop*scale end

			if (self.bottom) then
				if (btnBottom*scale < self.bottom) then self.bottom = btnBottom*scale end
			else self.bottom = btnBottom*scale end

			if (self.left) then
				if (btnLeft*scale < self.left) then self.left = btnLeft*scale end
			else self.left = btnLeft*scale end

			if (self.right) then
				if (btnRight*scale > self.right) then self.right = btnRight*scale end
			else self.right = btnRight*scale end

			num = num + 1
		end
	end
end

function BAR:SetDefaults()

	if (DB.firstRun[R.realm][R.player] == true) then
		if (self:GetID() == 1 and GetNumShapeshiftForms() > 0) then
			self.cdata.stance = true
			self:SetRemap_Stance()
		end
	end
end

function BAR:SetRemap_Paged()

	self.cdata.remap = ""

	for i=1,6 do
		self.cdata.remap = self.cdata.remap..i..":"..i..";"
	end

	self.cdata.remap = gsub(self.cdata.remap, ";$", "")

end

local druidForms = { [1066] = true, [40120] = true, [783] = true, [114282] = true }

function BAR:SetRemap_Stance()

	local start = tonumber(match(MS.stance.homestate, "%d+"))

	if (start) then

		self.cdata.remap = ""

		for i=start,GetNumShapeshiftForms() do
			self.cdata.remap = self.cdata.remap..i..":"..i..";"
		end

		self.cdata.remap = gsub(self.cdata.remap, ";$", "")

		if (R.class == "DRUID") then
			for i,id in pairs(R.StanceIndex) do
				if (druidForms[id]) then
					self.cdata.remap = gsub(self.cdata.remap, i..":"..i, i..":0")
				end
			end
		end
	end
end

function BAR:SetStates(msg, gui, silent)

	local state = match(msg, "^%S+")
	local command = gsub(msg, state, ""); command = gsub(command, "^%s+", "")

	if (not MS[state]) then
		if (not silent) then
			M.PrintStateList()
			return
		end
	end

	if (self.cdata[state] and not gui) then

		self.cdata[state] = false

	elseif (not gui) then

		self.cdata[state] = true
	end

	if (state == "pagedbar") then

		self.cdata.stance = false
		self.cdata.companion = false

		if (self.cdata.pagedbar) then

			self:SetRemap_Paged()

		else
			self.cdata.remap = false
		end
	end

	if (state == "stance") then

		self.cdata.pagedbar = false
		self.cdata.companion = false

		if (not self.cdata.stance and self.cdata.prowl) then
			self.cdata.prowl = false
		end

		if (self.cdata.stance) then

			self:SetRemap_Stance()

		else
			self.cdata.remap = false
		end
	end

	if (state == "custom") then

		if (self.cdata.custom) then

			local count, newstates = 0, ""

			self.cdata.customNames = {}

			for states in gmatch(command, "[^;]+") do

				self.cdata.customRange = "1;"..count

				if (count == 0) then
					newstates = states.." homestate; "
					self.cdata.customNames["homestate"] = states
				else
					newstates = newstates..states.." custom"..count.."; "
					self.cdata.customNames["custom"..count] = states
				end

				count = count + 1
			end

			self.cdata.custom = newstates or ""

		else
			self.cdata.customNames = false
			self.cdata.customRange = false
		end
	end

	if (state == "companion") then
		self.cdata.pagedbar = false
		self.cdata.stance = false
	end

	self.stateschanged = true

	self:Update()

end

function BAR:SetVehicle()

	if (DB.useVehicle) then

		self.cdata.vehicle = true
		self.cdata.possess = true
		self.cdata.override = true

	elseif (self.vehicle and self.vehicle.registered) then

		self.cdata.vehicle = false
		self.cdata.possess = false
		self.cdata.override = false
	end
end

function BAR:SetSize()

	if (self.right) then
		self:SetWidth(((self.right-self.left)+5)*(self.gdata.scale*DB.scale))
		self:SetHeight(((self.top-self.bottom)+5)*(self.gdata.scale*DB.scale))
	else
		self:SetWidth(195)
		self:SetHeight(36*(self.gdata.scale*DB.scale))
	end

end

function BAR:ACTIONBAR_SHOWGRID(...)

	if (not InCombatLockdown() and GP:IsVisible()) then
		self:Hide()
	end

end

function BAR:ACTIONBAR_HIDEGRID(...)

	if (not InCombatLockdown() and GP:IsVisible()) then
		self:Show()
	end

end

function BAR:ACTIVE_TALENT_GROUP_CHANGED(...)

	self.stateschanged = true

	self:Update()

end


function BAR:OnEvent(...)

	local event = select(1,...)

	if (BAR[event]) then
		BAR[event](self, ...)
	end
end

function BAR:OnClick(...)

	local button = select(1, ...)

	for index, bar in ipairs(BARIndex) do
		bar:SetBackdropColor(0,0.5,0,0.5)
	end

	if (not IsAddOnLoaded("RazerOrbweaver_GUI")) then
		LoadAddOn("RazerOrbweaver_GUI")
	end

	if (R.GUI:IsVisible() and R.CurrentBar == self) then
		R.CurrentBar = nil
		R.GUI:Hide()
	else
		R.CurrentBar = self
		self:SetBackdropColor(0,1,0,0.5)

		R.GUI:Show()

		GameTooltip:Hide()
	end
end

function BAR:OnEnter(...)

	self:SetBackdropColor(0,1,0,0.5)

	if (R.GUI and R.GUI:IsVisible()) then
		return
	end

	GameTooltip:SetOwner(self, "ANCHOR_BOTTOMLEFT")
	GameTooltip:SetText("|cffffffff"..L.BAR..": "..self.gdata.name.."|r")
	GameTooltip:AddLine(L.BAR_CLICK)
	GameTooltip:Show()

end

function BAR:OnLeave(...)

	if (self ~= R.CurrentBar) then
		self:SetBackdropColor(0,0.5,0,0.5)
	end

	GameTooltip:Hide()

end

function BAR:SaveData()

	local index = self:GetID()

	if (barGDB[index]) then

		for key,value in pairs(self.gdata) do
			barGDB[index][key] = value
		end

	else
		print("DEBUG: Bad Global Save Data for "..self:GetName().." ?")
	end

	if (barCDB[index]) then

		for key,value in pairs(self.cdata) do
			barCDB[index][key] = value
		end

	else
		print("DEBUG: Bad Character Save Data for "..self:GetName().." ?")
	end
end

function BAR:LoadData()

	local index = self:GetID()

	if (barGDB[index]) then

		if (barGDB[index]) then
			self.gdata = CopyTable(barGDB[index])
			self.cdata = CopyTable(barCDB[index])
		else
			self.gdata = CopyTable(barGlobalDefaults)
			self.cdata = CopyTable(barGlobalDefaults)
		end
	else
		print("DEBUG: Bad Load Data for "..self:GetName().." ?")
	end
end

function BAR:UpdateButtonData()

	for button in pairs(self.buttons) do
		button:SetData(self)
	end
end

local BAR_MT = { __index = BAR }

local function CreateBar(index)

	local bar = CreateFrame("CheckButton", "RazerOrbweaverBar"..index, GP)

	setmetatable(bar, BAR_MT)

	bar.stateschanged = true
	bar.buttons = {}
	bar.gdata = {}
	bar.cdata = {}

	bar:SetID(index)
	bar:SetWidth(375)
	bar:SetHeight(40)
	bar:SetBackdrop({ bgFile = "Interface/Tooltips/UI-Tooltip-Background", edgeFile = "Interface/Tooltips/UI-Tooltip-Border", tile = true, tileSize = 16, edgeSize = 12, insets = { left = 4, right = 4, top = 4, bottom = 4 } })
	bar:SetBackdropColor(0,0.5,0,0.5)
	bar:SetBackdropBorderColor(0,0,0,0)
	bar:SetFrameLevel(6)
	bar:RegisterForClicks("AnyUp")
	bar:RegisterForDrag("LeftButton", "RightButton")

	bar:SetScript("OnClick", BAR.OnClick)
	bar:SetScript("OnDragStart", function() GP:StartMoving() end)
	bar:SetScript("OnDragStop", function() GP:StopMovingOrSizing() end)
	bar:SetScript("OnEnter", BAR.OnEnter)
	bar:SetScript("OnLeave", BAR.OnLeave)
	bar:SetScript("OnEvent", BAR.OnEvent)

	bar:RegisterEvent("ACTIONBAR_SHOWGRID")
	bar:RegisterEvent("ACTIONBAR_HIDEGRID")
	bar:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED")

	BARIndex[index] = bar
end


local function LoadBar(...)

	local index = select(1, ...)

	local bar = BARIndex[index]

	if (bar) then

		local defaults, gdefaults, cdefaults = R.Defaults.bars[bar:GetID()], CopyTable(barGlobalDefaults), CopyTable(barCharDefaults)

		if (barGDB[index]) then
			bar.gdata = CopyTable(barGDB[index])
		else

			barGDB[index] = {}

			if (defaults and defaults.gdata) then
				for key,value in pairs(defaults.gdata) do
					bar.gdata[key] = value
				end
			end
		end

		if (barGData[index]) then
			for key,value in pairs(barGData[index]) do
				bar.gdata[key] = value
			end
		end

		R.UpdateData(bar.gdata, gdefaults)

		if (barCDB[index]) then
			bar.cdata = CopyTable(barCDB[index])
		else

			barCDB[index] = {}

			if (defaults and defaults.cdata) then
				for key,value in pairs(defaults.cdata) do
					bar.cdata[key] = value
				end
			end
		end

		R.UpdateData(bar.cdata, cdefaults)

		bar:SetPosition()

		bar:CreateHandler()

		bar:CreateWatcher()

		bar:CreateButtons()

		bar:SetButtonLoc()

		bar:LoadButtons()

		bar:SetPerimeter()

		bar:SetDefaults()

		bar:SetSize()

		bar:SetVehicle()

		bar:SaveData()

		bar:Update()
	end
end

function R.ToggleBars(show, hide)

	if (PEW) then

		if (show) then

			for index, bar in ipairs(BARIndex) do
				bar:Show()
			end

			R.BarsShown = true

		elseif (hide) then

			for index, bar in ipairs(BARIndex) do
				bar:Hide()
			end

			R.BarsShown = nil

		else

			if  (R.BarsShown) then
				for index, bar in ipairs(BARIndex) do
					bar:Hide()
				end

				R.BarsShown = nil

			else
				for index, bar in ipairs(BARIndex) do
					bar:Show()
				end

				R.BarsShown = true
			end
		end
	end
end

function R:ToggleDPad(on)

	if (false) then

		for i,btn in pairs(dpadswap) do
			btn:Show()
		end

	else
		for i,btn in pairs(dpadswap) do
			btn:Hide()
		end
	end
end

local function CreateGamePad()

	R.GamePad = CreateFrame("Button", "RazerOrbweaverGamePad", UIParent)

	GP = R.GamePad

	GP:Hide()

	GP:SetWidth(400)
	GP:SetHeight(600)
	GP:SetPoint("CENTER")
	GP:SetFrameStrata(DB.strata)
	GP:SetClampedToScreen(true)
	GP:SetMovable(true)
	GP:RegisterForClicks("AnyUp")
	GP:RegisterForDrag("LeftButton", "RightButton")
	GP:SetScript("OnDragStart", function(self) self:StartMoving() end)
	GP:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)
	GP:SetScript("OnHide", function(self) R.ToggleBars(nil,true) for index, bar in ipairs(BARIndex) do bar:SetBackdropColor(0,0.5,0,0.5) end R.CurrentBar = nil end)
	GP:SetScript("OnShow", function(self) R.ToggleBars(true) end)
	GP:SetScript("OnEvent", function(self) self:Hide() end)
	GP:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED")

end

function R.ResizeGamePad()

	GP.top = nil; GP.bottom = nil; GP.left = nil; GP.right = nil

	for index, bar in ipairs(BARIndex) do

		local barTop, barBottom, barLeft, barRight = bar:GetTop(), bar:GetBottom(), bar:GetLeft(), bar:GetRight()

		if (GP.top) then
			if (barTop > GP.top) then GP.top = barTop end
		else GP.top = barTop end

		if (GP.bottom) then
			if (barBottom < GP.bottom) then GP.bottom = barBottom end
		else GP.bottom = barBottom end

		if (GP.left) then
			if (barLeft < GP.left) then GP.left = barLeft end
		else GP.left = barLeft end

		if (GP.right) then
			if (barRight > GP.right) then GP.right = barRight end
		else GP.right = barRight end
	end

	GP:SetWidth(((GP.right-GP.left)+(3*DB.scale)))
	GP:SetHeight(((GP.top-GP.bottom)+(3*DB.scale)))
end

function R.SetStratas()

	R.GamePad:SetFrameStrata(DB.strata)

	local index

	for k,v in pairs(R.Stratas) do
		if (v == DB.strata) then
			index = k + 1
		end
	end

	for _, bar in pairs(BARIndex) do
		bar:SetFrameStrata(R.Stratas[index])
	end

	for _, btn in pairs(BTNIndex) do
		btn:SetFrameStrata(R.Stratas[index])
	end
end

local function controlOnEvent(self, event, ...)

	if (event == "ADDON_LOADED" and ... == "RazerOrbweaver") then

		player, realm = UnitName("player"), GetRealmName()

		DB = RazerOrbweaverDB

		if (not DB.bars[realm]) then
			DB.bars[realm] = {}
		end

		if (not DB.bars[realm][player]) then
			DB.bars[realm][player] = {}
		end

		barGDB = DB.bars

		barCDB = DB.bars[realm][player]

		CreateGamePad()

	elseif (event == "PLAYER_LOGIN") then

		ROS = RazerOrbweaverSpec[R.realm][R.player]

		for index in ipairs(R.Defaults.bars) do
			CreateBar(index)
		end

		for index in ipairs(R.Defaults.bars) do
			LoadBar(index, ROS.cSpec)
		end

		R.ResizeGamePad()

		R.SetStratas()

		R:ToggleDPad(DB.dpadState)

	elseif (event == "PLAYER_ENTERING_WORLD" and not PEW) then

		PEW = true; self.elapsed = 0

	elseif (event == "PLAYER_REGEN_DISABLED") then

		GP:Hide()

		if (R.GUI) then
			R.GUI:Hide()
		end
	end
end

local frame = CreateFrame("Frame", nil, UIParent)
frame:SetScript("OnEvent", controlOnEvent)
frame:SetScript("OnUpdate", controlOnUpdate)
frame:RegisterEvent("ADDON_LOADED")
frame:RegisterEvent("PLAYER_LOGIN")
frame:RegisterEvent("PLAYER_ENTERING_WORLD")
frame:RegisterEvent("PLAYER_REGEN_DISABLED")
frame.elapsed = 0
