﻿--RazerOrbweaver, a World of Warcraft® user interface addon.

local R, DB, PEW, GUI, player, realm, barDB, editmode = RazerOrbweaver

local SPECIAL = setmetatable({}, { __index = CreateFrame("CheckButton") })

local L = LibStub("AceLocale-3.0"):GetLocale("RazerOrbweaver")
local LGUI = LibStub("AceLocale-3.0"):GetLocale("RazerOrbweaver_GUI")

local BARIndex, BTNIndex, MacroDrag, StartDrag = R.BARIndex, R.BTNIndex, R.MacroDrag, R.StartDrag

local RazerActions, SpecialActions = R.RazerActions, R.SpecialActions

local barStates = {}

local miscOptions = {

	[LGUI.OPTION_1] = "barLock",
	[LGUI.OPTION_2] = "barLockAlt",
	[LGUI.OPTION_3] = "barLockCtrl",
	[LGUI.OPTION_4] = "barLockShift",

	[LGUI.OPTION_5] = "tooltips",
	[LGUI.OPTION_6] = "tooltipsEnhanced",
	[LGUI.OPTION_7] = "tooltipsCombat",

	[LGUI.OPTION_8] = "spellGlow",
	[LGUI.OPTION_9] = "spellGlowDef",
	[LGUI.OPTION_10] = "spellGlowAlt",

	[LGUI.OPTION_11] = "bindText",
	[LGUI.OPTION_12] = "macroText",
	[LGUI.OPTION_13] = "countText",

	[LGUI.OPTION_14] = "cdText",
	[LGUI.OPTION_15] = "cdAlpha",

	[LGUI.OPTION_16] = "auraText",
	[LGUI.OPTION_17] = "auraInd",

	[LGUI.OPTION_18] = "upClicks",
	[LGUI.OPTION_19] = "downClicks",

	[LGUI.OPTION_20] = "rangeInd",
}

local function SetPosition(gui)

	gui:ClearAllPoints()

	if (gui.Pos == "left") then
		gui:SetPoint("TOPRIGHT", R.GamePad, "TOPLEFT", -5, 0)
	else
		gui:SetPoint("TOPLEFT", R.GamePad, "TOPRIGHT", 5, 0)
	end
end

local function CheckPosition(self, elapsed)

	if (self.UICenter) then

		local x = R.GamePad:GetCenter()
		local oldPos = self.Pos

		if (x > self.UICenter) then

			self.Pos = "left"
		else

			self.Pos = "right"
		end

		if (self.Pos ~= oldPos) then
			SetPosition(self)
		end
	end
end

local function updateText(frame, text)

	if (not frame or not text) then return end

	frame:SetText(text)
	frame:SetCursorPosition(0)
end

local function strata_OnShow(self)

	local data = {}

	for k,v in pairs(R.Stratas) do
		if (k < 6) then
			data[k.."_"..LGUI["STRATA_"..k]] = v
		end
	end

	R.EditBox_PopUpInitialize(self.popup, data)

	for k,v in pairs(R.Stratas) do
		if (v == DB.strata) then
			self:SetText(LGUI["STRATA_"..k])
		end
	end
end

local function strata_OnTextChanged(self)

	if (self.value) then

		DB.strata = self.value

		R.SetStratas()
	end
end

local function scale_OnShow(self)

	self:SetValue(DB.scale)
	self.edit:SetText(format("%.2f", DB.scale))

end

local function scale_OnMouseDown(self, button)

	local GP, gui = R.GamePad, R.GUI

	gui:ClearAllPoints()
	gui:SetMovable(true)
	gui:SetUserPlaced(true)

	GP.posData = { GP:GetPoint() }

	GP:ClearAllPoints()

	if (gui.Pos == "left") then
		GP:SetPoint("TOPLEFT", gui, "TOPRIGHT", 5, 0)
	else
		GP:SetPoint("TOPRIGHT", gui, "TOPLEFT", -5, 0)
	end

	R.ToggleBars(nil, true)

	GP:SetAlpha(0)
end

local function scale_OnMouseUp(self, button)

	local GP, gui = R.GamePad, R.GUI

	GP:ClearAllPoints()

	GP:SetPoint(unpack(GP.posData))

	R.ResizeGamePad()

	gui:SetUserPlaced(false)
	gui:SetMovable(false)
	gui:ClearAllPoints()

	SetPosition(gui)

	R.ToggleBars(true)

	GP:SetAlpha(1)

end

local function scale_OnValueChanged(self, value)

	DB.scale = value

	for _,bar in pairs(BARIndex) do
		bar:SetButtonLoc()
		bar:SetPerimeter()
		bar:SetSize()
		bar:SetPosition()
	end

	self.edit:SetText(format("%.2f", DB.scale))
end

local function pad_OnShow(self, id)

	local bar = BARIndex[id]

	if (bar) then
		self:SetValue(bar.gdata.pad)
		self.edit:SetText(format("%.1f", bar.gdata.pad))
	end

end

local function pad_OnValueChanged(self, value, id)

	local bar = BARIndex[id]

	if (bar) then

		bar.gdata.pad = value

		bar:SetButtonLoc()
		bar:SetPosition()
		bar:SetPerimeter()
		bar:SetSize()
		bar:SaveData()
	end

	self.edit:SetText(format("%.1f", value))
end

local function pad_OnMouseDown(self, button)

	R.ToggleBars(nil, true)
	R.GamePad:SetAlpha(0)

end

local function pad_OnMouseUp(self, button)

	R.ToggleBars(true)
	R.ResizeGamePad()
	R.GamePad:SetAlpha(1)
end

local function barMap_OnShow(self)

	self.value = nil

	bar = R.CurrentBar

	if (bar) then

		local data = {}

		for k,v in pairs(R.STATES) do

			if (bar.cdata.pagedbar and k:find("pagedbar")) then

				data[v] = k:match("%d+")

			elseif (bar.cdata.stance and k:find("stance")) then

				data[v] = k:match("%d+")

			end
		end

		R.EditBox_PopUpInitialize(self.popup, data)
	end

	self:SetText("")
end

local function barMap_OnTextChanged(self)

	bar = R.CurrentBar

	if (bar and self.value and bar.cdata.remap) then

		local map, remap

		for states in gmatch(bar.cdata.remap, "[^;]+") do

			map, remap = (":"):split(states)

			if (map == self.value) then

				R.GUI.remapto.value = remap

				if (bar.cdata.pagedbar) then
					R.GUI.remapto:SetText(R.STATES["pagedbar"..remap])
				elseif (bar.cdata.stance) then
					R.GUI.remapto:SetText(R.STATES["stance"..remap])
				end
			end
		end
	else
		R.GUI.remapto:SetText("")
	end

end

local function remapTo_OnShow(self)

	self.value = nil

	bar = R.CurrentBar

	if (bar) then

		local data = {}

		for k,v in pairs(R.STATES) do

			if (bar.cdata.pagedbar and k:find("pagedbar")) then

				data[v] = k:match("%d+")

			elseif (bar.cdata.stance and k:find("stance")) then

				data[v] = k:match("%d+")

			end
		end

		R.EditBox_PopUpInitialize(self.popup, data)
	end
end

local function remapTo_OnTextChanged(self)

	bar = R.CurrentBar

	if (bar and bar.cdata.remap and self.value) then

		local value = R.GUI.barmap.value

		bar.cdata.remap = bar.cdata.remap:gsub(value..":%d+", value..":"..self.value)

		if (bar.cdata.pagedbar) then
			bar.pagedbar.registered = false
		elseif (bar.cdata.stance) then
			bar.stance.registered = false
		end

		bar.stateschanged = true

		bar:Update()
	end

end

local function customStates_Update(self)

	bar = R.CurrentBar

	if (bar and bar.config.custom and self:GetText()) then

		local states = "custom "..self:GetText()

		states = states:gsub("\n", ";"); states = states:gsub("[;]+", ";")

		if (bar.custom) then
			bar.custom.registered = false
		end

		M.SetBarStates(states, true, true)

		--updateCycleOrder(bar)
	end

	self:ClearFocus()

	self:GetParent().focus:Show()
end

function R.Option_OnClick(option, checked)

	local bar = R.CurrentBar

	if (bar and option) then

		if (checked) then
			bar.cdata[option] = true
		else
			bar.cdata[option] = false
		end

		if (option == "spellGlowDef" and bar.cdata.spellGlowDef) then
			bar.cdata.spellGlowAlt = false
		end

		if (option == "spellGlowAlt" and bar.cdata.spellGlowAlt) then
			bar.cdata.spellGlowDef = false
		end

		if (option == "spellGlow" and not bar.cdata.spellGlowDef and not bar.cdata.spellGlowAlt) then
			bar.cdata.spellGlowDef = true
		end

		bar:SaveData()

		bar:UpdateButtonData()

		R.BarEditorUpdateData(bar)

	end

end

function R.StateOptions_OnClick(frame, option, checked, state)

	local bar, index = R.CurrentBar, 1

	if (bar and option) then

		bar.option = option

		for k,v in pairs(barStates) do

			if (v[2] == option) then

				if (v[1] == "custom") then

					if (checked) then

						bar.cdata.custom = ""
						bar.cdata.customRange = ""
						bar.cdata.customNames = {}

						for kk,vv in pairs(barStates) do
							if (vv[1] ~= "custom") then
								bar.cdata[vv[1]] = false
							end
						end

					else
						bar.cdata.custom = false
						bar.cdata.customRange = false
						bar.cdata.customNames = false
					end
				else
					if (checked) then
						bar.cdata[v[1]] = true
						bar.cdata.custom = false
						bar.cdata.customRange = false
						bar.cdata.customNames = false
					else
						bar.cdata[v[1]] = false
					end
				end

				state = v[1]
			end
		end

		if (state) then

			if (state == "preset") then

				if (checked) then
					bar.cdata.custom = false
					bar.cdata.customRange = false
					bar.cdata.customNames = false
				end

				bar:SetStates("custom", true, true)

			elseif (state == "prowl") then

				bar.stance.registered = false

				bar:SetStates("stance", true, true)

			else

				bar:SetStates(state, true, true)
			end
		end

		--updateCycleOrder(bar)

		bar:SaveData()

		R.BarEditorUpdateData(bar)
	end
end

function R.BarEditorUpdateData(bar, setfaux)

	if (InterfaceOptionsFrame:IsVisible()) then
		InterfaceOptionsFrameOkay_OnClick()
	end

	local gui, index, frame = R.GUI, 1

	if (bar) then

		if (gui.barOptheader) then
			gui.barOptheader:SetText(LGUI.CURRENT..": "..HIGHLIGHT_FONT_COLOR_CODE..bar.gdata.name.."|r")
		end

		if (gui.barStatesHeader) then
			gui.barStatesHeader:SetText(LGUI.CURRENT..": "..HIGHLIGHT_FONT_COLOR_CODE..bar.gdata.name.."|r")
		end

		if (gui.baropts) then

			for i,frame in ipairs(gui.baropts) do

				if (miscOptions[frame.option] == "barLockAlt" or miscOptions[frame.option] == "barLockCtrl" or miscOptions[frame.option] == "barLockShift") then
					if (bar.cdata.barLock) then
						frame:Enable()
						frame.text:SetTextColor(0.1, 1, 0.1)
					else
						bar.cdata[miscOptions[frame.option]] = false
						frame:Disable()
						frame.text:SetTextColor(0.5, 0.5, 0.5)
					end
				end

				if (miscOptions[frame.option] == "tooltipsEnhanced" or miscOptions[frame.option] == "tooltipsCombat") then
					if (bar.cdata.tooltips) then
						frame:Enable()
						frame.text:SetTextColor(0.1, 1, 0.1)
					else
						bar.cdata[miscOptions[frame.option]] = false
						frame:Disable()
						frame.text:SetTextColor(0.5, 0.5, 0.5)
					end
				end

				if (miscOptions[frame.option] == "spellGlowDef" or miscOptions[frame.option] == "spellGlowAlt") then
					if (bar.cdata.spellGlow) then
						frame:Enable()
						frame.text:SetTextColor(0.1, 1, 0.1)
					else
						bar.cdata[miscOptions[frame.option]] = false
						frame:Disable()
						frame.text:SetTextColor(0.5, 0.5, 0.5)
					end

				end

				if (bar.cdata[miscOptions[frame.option]]) then
					frame:SetChecked(1)
				else
					frame:SetChecked(nil)
				end
			end
		end

		if (gui.optionBtns) then

			for i,frame in ipairs(gui.optionBtns) do

				if (frame.prowl) then

					if (bar.cdata.prowl) then
						frame:SetChecked(1)
					else
						frame:SetChecked(nil)
					end

					if (bar.cdata.stance) then
						frame.text:SetTextColor(0.1, 1, 0.1)
						frame:Enable()
					else
						frame.text:SetTextColor(0.5,0.5,0.5)
						frame:Disable()
					end

				else

					for k,v in pairs(barStates) do
						if (v[2] == frame.option) then
							if (bar.cdata[v[1]]) then
								frame:SetChecked(1)
							else
								frame:SetChecked(nil)
							end
						end
					end
				end
			end
		end

		if (setfaux) then
			bar.handler:SetAttribute("fauxstate", bar.handler:GetAttribute("activestate"))
		end

		R.ActionListScrollFrameUpdate()
	end
end

local function TabsOnClick(cTab)

	for tab, frame in pairs(R.GUI.tabs) do

		if (tab == cTab) then
			PanelTemplates_SelectTab(tab); PlaySound("igCharacterInfoTab"); frame:Show()
		else
			PanelTemplates_DeselectTab(tab); frame:Hide()
		end

	end

	R.GUI.cTab = cTab

end

function R.ToggleVehicleEdit(show, hide)

	if (editmode or hide) then

		editmode = false

		for index,button in pairs(BTNIndex) do

			if (button.data) then

				button.vehicle_edit = false
				button:MACRO_UpdateAll(true)

				if (button.sdata.vehicle) then
					button.keymaptext:SetText("")
					button.keymaptext:Hide()
				end
			end
		end

		for index,btn in pairs(R.GUI.vehicle_btns) do
			btn:Disable()
			btn.icon:SetDesaturated(true)
			btn.keymaptext:SetTextColor(0.5,0.5,0.5)
		end

		for index,btn in pairs(R.GUI.razeractions) do
			btn:Enable()
			btn.icon:SetDesaturated(nil)
			btn.keymaptext:SetTextColor(0.9,0.9,0.9)
		end

		R.GUI.vehicle_toggle.text:SetText(LGUI.VEHICLE_EDIT_SHOW)

	else

		editmode = true

		for index,button in pairs(BTNIndex) do

			if (button.data) then
				button.vehicle_edit = true
				button:MACRO_UpdateAll()
			end
		end

		for index,btn in pairs(R.GUI.vehicle_btns) do
			btn:Enable()
			btn.icon:SetDesaturated(nil)
			btn.keymaptext:SetTextColor(0.9,0.9,0.9)
		end

		for index,btn in pairs(R.GUI.razeractions) do
			btn:Disable()
			btn.icon:SetDesaturated(true)
			btn.keymaptext:SetTextColor(0.5,0.5,0.5)
		end

		R.GUI.vehicle_toggle.text:SetText(LGUI.VEHICLE_EDIT_HIDE)

	end

end

function SPECIAL:PostClick()

	self:SetChecked(nil)

	MacroDrag[0] = false; StartDrag = false

	ClearCursor(); SetCursor(nil)

end

function SPECIAL:OnDragStart(button)

	local texture = self.icon:GetTexture()
	local specaction, index = ("_"):split(self.specaction)

	if (specaction == "vehicle" and index == "exit") then
		texture = "Interface\\Vehicles\\UI-Vehicles-Button-Exit-Up"
	end

	index = tonumber(index)

	if (index and specaction == "move") then
		if (index == 3 or index == 4) then
			texture = RazerActions[index+2][1]
		end
	end

	wipe(MacroDrag)

	MacroDrag[0] = self.specaction
	MacroDrag[1] = self
	MacroDrag[2] = ""
	MacroDrag[3] = false
	MacroDrag[4] = ""
	MacroDrag[5] = false
	MacroDrag[6] = false
	MacroDrag[7] = false

	if (specaction == "move") then
		MacroDrag[8] = index
		MacroDrag[9] = false
	elseif (specaction == "keymap") then
		MacroDrag[8] = false
		MacroDrag[9] = index
	end

	MacroDrag.texture = texture

	SetCursor(MacroDrag.texture)

end

function SPECIAL:OnReceiveDrag()

	MacroDrag[0] = false; StartDrag = false

	ClearCursor(); SetCursor(nil)

end

local SPECIAL_MT = { __index = SPECIAL }

local function manualEdit_OnShow(self)

	self:SetChecked(not DB.razerBindings)

	if (DB.razerBindings) then
		R.GUI.editToggle:Disable()
		R.GUI.editToggle.text:SetTextColor(0.5, 0.5, 0.5)
	else
		R.GUI.editToggle:Enable()
		R.GUI.editToggle.text:SetTextColor(1, 0.82, 0)
	end

end

R.ManualEdit_OnShow = manualEdit_OnShow

local function manualEdit_OnClick(self,button,down)

	if (self:GetChecked()) then
		R.BindingsWarning()
	else
		R.BindingsResetWarning()
	end
end

local function useVehicle_OnShow(self)

	self:SetChecked(DB.useVehicle)

	if (DB.useVehicle) then
		R.GUI.vehicle_toggle:Enable()
		R.GUI.vehicle_toggle.text:SetTextColor(1, 0.82, 0)
	else
		R.GUI.vehicle_toggle:Disable()
		R.GUI.vehicle_toggle.text:SetTextColor(0.5, 0.5, 0.5)
		R.ToggleVehicleEdit(nil, true)
	end

end

local function useVehicle_OnClick(self,button,down)

	if (self:GetChecked()) then
		DB.useVehicle = true
	else
		DB.useVehicle = false
	end

	useVehicle_OnShow(self)

	for index, bar in ipairs(BARIndex) do
		bar.stateschanged = true
		bar:SetVehicle()
		bar:Update()
	end
end

local function CreateGUI()

	R.GUI = CreateFrame("Frame", "RazerOrbweaverGUIPanel", UIParent)

	local gui, lastIndex = R.GUI, #barStates

	local count, offset, index, frame, anchor, last = 1, 0

	gui.baropts = {}
	gui.optionBtns = {}
	gui.tabs = {}
	gui.vehicle_btns = {}
	gui.razeractions = {}

	gui:SetBackdrop({ bgFile = "Interface/Tooltips/UI-Tooltip-Background", edgeFile = "Interface/Tooltips/UI-Tooltip-Border", tile = true, tileSize = 16, edgeSize = 16, insets = { left = 4, right = 4, top = 4, bottom = 4 } })
	gui:SetBackdropBorderColor(0, 1, 0, 0.6)
	gui:SetBackdropColor(0,0,0,1)
	gui:SetWidth(450)
	gui:SetHeight(415)
	gui:SetScript("OnDragStart", function(self) R.GamePad:StartMoving() end)
	gui:SetScript("OnDragStop", function(self) R.GamePad:StopMovingOrSizing() end)
	gui:SetScript("OnShow", function(self) self.UICenter = UIParent:GetWidth()/2 if (R.CurrentBar) then R.BarEditorUpdateData(R.CurrentBar, true) end end)
	gui:SetScript("OnHide", function(self) if (not R.BarsShown) then R.ToggleBars(true) end end)
	gui:SetScript("OnUpdate", CheckPosition)
	gui:SetScript("OnEvent", function(self) self:Hide() end)
	gui:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED")
	gui:RegisterForDrag("LeftButton", "RightButton")
	gui:SetClampedToScreen(true)
	gui:SetClampRectInsets(0, 0, 0, -35)
	gui:Hide()

	gui.Pos = "right"

	frame = CreateFrame("Button", "RazerOrbweaverGUI_CloseButton", gui, "UIPanelCloseButton")
	frame:SetPoint("TOPRIGHT", 3, 3)
	frame:SetScript("OnClick", function(self) R.GUI:Hide() end)

	frame = CreateFrame("Frame", "RazerOrbweaverGUI_GamePadOptions", gui)
	frame:SetAllPoints(gui)
	frame:Show()

	gui.gamePadOptions = frame

	frame = CreateFrame("Frame", "RazerOrbweaverGUI_GamePadHeader", gui.gamePadOptions)
	frame:SetBackdrop({ bgFile = "Interface/Tooltips/UI-Tooltip-Background", edgeFile = "Interface/Tooltips/UI-Tooltip-Border", tile = true, tileSize = 16, edgeSize = 16, insets = { left = 4, right = 4, top = 4, bottom = 4 } })
	frame:SetBackdropBorderColor(0, 0.6, 0, 0.6)
	frame:SetBackdropColor(0,0,0,0)
	frame:SetPoint("TOPLEFT", gui.gamePadOptions, "TOPLEFT", 10, -20)
	frame:SetPoint("BOTTOMRIGHT", gui.gamePadOptions, "TOPRIGHT", -10, -115)
	frame:SetFrameLevel(gui.gamePadOptions:GetFrameLevel())

	gui.gamePadHeader = frame

	gui.gamePadHeader.banner = gui.gamePadHeader:CreateTexture(nil, "BACKGROUND")
	gui.gamePadHeader.banner:SetTexture("Interface\\AddOns\\RazerOrbweaver\\Images\\RazerOrbweaver_Banner")
	gui.gamePadHeader.banner:SetAllPoints()

	gui.gamePadHeaderImage = frame.banner

	frame = CreateFrame("Frame", "RazerOrbweaverGUI_GamePadMainOpt", gui.gamePadOptions)
	frame:SetBackdrop({ bgFile = "Interface/Tooltips/UI-Tooltip-Background", edgeFile = "Interface/Tooltips/UI-Tooltip-Border", tile = true, tileSize = 16, edgeSize = 16, insets = { left = 4, right = 4, top = 4, bottom = 4 } })
	frame:SetBackdropBorderColor(0, 0.6, 0, 0.6)
	frame:SetBackdropColor(0,0,0,0.5)
	frame:SetPoint("TOPLEFT", gui.gamePadHeader, "BOTTOMLEFT", 0, -5)
	frame:SetPoint("BOTTOMRIGHT", gui.gamePadOptions, "BOTTOMRIGHT", -10, 10)
	frame:SetFrameLevel(gui.gamePadOptions:GetFrameLevel())

	gui.gamePadMainOpt = frame

	frame = CreateFrame("Slider", "RazerOrbweaverGUI_SliderScale", gui.gamePadMainOpt, "RazerOrbweaverSliderTemplate")
	frame:SetWidth(gui:GetWidth()-100)
	frame:SetMinMaxValues(0.5, 1.5)
	frame:SetValueStep(0.01)
	frame:SetScript("OnShow", scale_OnShow)
	frame:SetScript("OnValueChanged", scale_OnValueChanged)
	frame:SetScript("OnMouseDown", scale_OnMouseDown)
	frame:SetScript("OnMouseUp", scale_OnMouseUp)
	frame.desc:SetText(LGUI.GAMEPAD_SCALE)
	frame:SetPoint("TOPLEFT", gui.gamePadMainOpt, "TOPLEFT", 10, -25)

	gui.gamePadSliderScale = frame

	frame = CreateFrame("EditBox", "RazerOrbweaverGUI_SliderScaleEdit", gui.gamePadMainOpt, "RazerOrbweaverEditBoxTemplate")
	frame:SetPoint("LEFT", gui.gamePadSliderScale, "RIGHT", 1, 0)
	frame.slider = gui.gamePadSliderScale
	frame:SetScript("OnTabPressed", function(self) local num = tonumber(self:GetText()) if(num) then scale_OnMouseDown() self.slider:SetValue(num) scale_OnMouseUp() end self:ClearFocus() end)
	frame:SetScript("OnEnterPressed", function(self) local num = tonumber(self:GetText()) if(num) then scale_OnMouseDown() self.slider:SetValue(num) scale_OnMouseUp() end self:ClearFocus() end)

	gui.gamePadSliderScaleEdit = frame
	gui.gamePadSliderScale.edit = gui.gamePadSliderScaleEdit

	frame = CreateFrame("Slider", "RazerOrbweaverGUI_SliderMainPad", gui.gamePadMainOpt, "RazerOrbweaverSliderTemplate")
	frame:SetWidth(gui:GetWidth()-100)
	frame:SetMinMaxValues(-10, 20)
	frame:SetValueStep(0.5)
	frame:SetScript("OnShow", function(self) pad_OnShow(self, 1) end)
	frame:SetScript("OnValueChanged", function(self, value) pad_OnValueChanged(self, value, 1) end)
	frame:SetScript("OnMouseDown", pad_OnMouseDown)
	frame:SetScript("OnMouseUp", pad_OnMouseUp)
	frame.desc:SetText(LGUI.MAINPAD_SPACING)
	frame:SetPoint("TOPLEFT", gui.gamePadSliderScale, "BOTTOMLEFT", 0, -31)

	gui.gamePadSliderMainPad = frame

	frame = CreateFrame("EditBox", "RazerOrbweaverGUI_SliderMainPadEdit", gui.gamePadMainOpt, "RazerOrbweaverEditBoxTemplate")
	frame:SetPoint("LEFT", gui.gamePadSliderMainPad, "RIGHT", 1, 0)
	frame.slider = gui.gamePadSliderMainPad
	frame:SetScript("OnTabPressed", function(self) local num = tonumber(self:GetText()) if(num) then self.slider:SetValue(num) pad_OnMouseUp() end self:ClearFocus() end)
	frame:SetScript("OnEnterPressed", function(self) local num = tonumber(self:GetText()) if(num) then self.slider:SetValue(num) pad_OnMouseUp() end self:ClearFocus() end)

	gui.gamePadSliderMainPadEdit = frame
	gui.gamePadSliderMainPad.edit = gui.gamePadSliderMainPadEdit

	frame = CreateFrame("Slider", "RazerOrbweaverGUI_SliderDPad", gui.gamePadMainOpt, "RazerOrbweaverSliderTemplate")
	frame:SetWidth(gui:GetWidth()-100)
	frame:SetMinMaxValues(-30, -10)
	frame:SetValueStep(0.5)
	frame:SetScript("OnShow", function(self) pad_OnShow(self, 2) end)
	frame:SetScript("OnValueChanged", function(self, value) pad_OnValueChanged(self, value, 2) end)
	frame:SetScript("OnMouseDown", pad_OnMouseDown)
	frame:SetScript("OnMouseUp", pad_OnMouseUp)
	frame.desc:SetText(LGUI.DPAD_SPACING)
	frame:SetPoint("TOPLEFT", gui.gamePadSliderMainPad, "BOTTOMLEFT", 0, -31)

	gui.gamePadSliderDPad = frame

	frame = CreateFrame("EditBox", "RazerOrbweaverGUI_SliderDPadEdit", gui.gamePadMainOpt, "RazerOrbweaverEditBoxTemplate")
	frame:SetPoint("LEFT", gui.gamePadSliderDPad, "RIGHT", 1, 0)
	frame.slider = gui.gamePadSliderDPad
	frame:SetScript("OnTabPressed", function(self) local num = tonumber(self:GetText()) if(num) then self.slider:SetValue(num) pad_OnMouseUp() end self:ClearFocus() end)
	frame:SetScript("OnEnterPressed", function(self) local num = tonumber(self:GetText()) if(num) then self.slider:SetValue(num) pad_OnMouseUp() end self:ClearFocus() end)

	gui.gamePadSliderDPadEdit = frame
	gui.gamePadSliderDPad.edit = gui.gamePadSliderDPadEdit

	frame = CreateFrame("CheckButton", "$parentRazerOrbweaverBindings", gui.gamePadMainOpt, "RazerOrbweaverGUIOptionCBTemplate")
	frame.text:SetText(LGUI.MANUAL_BINDINGS)
	frame:SetPoint("TOPLEFT", gui.gamePadSliderDPad, "BOTTOMLEFT", 0, -35)
	frame:SetScript("OnShow", manualEdit_OnShow)
	frame:SetScript("OnClick", manualEdit_OnClick)

	gui.manualBindings = frame

	frame = CreateFrame("Button", "$parentEditToggle", gui.gamePadMainOpt, "RazerOrbweaverOptionButtonTemplate")
	frame:SetWidth(100)
	frame:SetHeight(25)
	frame:SetPoint("TOPRIGHT", gui.gamePadSliderDPad, "BOTTOMRIGHT", 60, -35)
	frame:SetScript("OnClick", function(self) R.ToggleBindings() end)
	frame.text:SetText(L.EDIT_BINDINGS)

	gui.editToggle = frame

	frame = CreateFrame("CheckButton", "$parentMainBar", gui.gamePadMainOpt, "RazerOrbweaverGUIOptionCBTemplate")
	frame:SetID(101)
	frame.text:SetText(LGUI.BLIZZ_MAINBAR)
	frame:SetPoint("TOPLEFT", gui.manualBindings, "BOTTOMLEFT", 0, -25)
	frame:SetScript("OnShow", function(self) self:SetChecked(DB.mainbar) if (R.OpDep) then self:Disable() self.text:SetTextColor(0.5, 0.5, 0.5) end end)
	frame:SetScript("OnClick", function(self,button,down) if (self:GetChecked()) then DB.mainbar = true else DB.mainbar = false end R:ToggleBlizzBar(DB.mainbar) end )

	gui.mainbar = frame


	--frame = CreateFrame("CheckButton", "$parentDPadToggle", gui.gamePadMainOpt, "RazerOrbweaverGUIOptionCBTemplate")
	--frame.text:SetText(LGUI.DPAD_SWAP)
	--frame:SetPoint("TOPLEFT", gui.mainbar, "BOTTOMLEFT", 0, -25)
	--frame:SetScript("OnShow", function(self) self:SetChecked(DB.dpadState) end)
	--frame:SetScript("OnClick", function(self,button,down) if (self:GetChecked()) then DB.dpadState = true else DB.dpadState = false end R:ToggleDPad(DB.dpadState) end )

	--gui.DpadToggle = frame

	frame = CreateFrame("Frame", "RazerOrbweaverGUI_BarOptions", gui)
	frame:SetAllPoints(gui)
	frame:Hide()

	gui.barOptions = frame

	gui.barOptheader = frame:CreateFontString(gui.barOptions:GetName().."Header", "ARTWORK", "GameFontGreen")
	gui.barOptheader:SetPoint("TOP", gui.barOptions, "TOP", 0, -10)
	gui.barOptheader:SetJustifyH("CENTER")

	frame = CreateFrame("Frame", "RazerOrbweaverGUI_BarOptionsBG", gui.barOptions)
	frame:SetBackdrop({ bgFile = "Interface/Tooltips/UI-Tooltip-Background", edgeFile = "Interface/Tooltips/UI-Tooltip-Border", tile = true, tileSize = 16, edgeSize = 16, insets = { left = 4, right = 4, top = 4, bottom = 4 } })
	frame:SetBackdropBorderColor(0, 0.6, 0, 0.6)
	frame:SetBackdropColor(0,0,0,0.5)
	frame:SetPoint("TOPLEFT", gui.barOptions, "TOPLEFT", 10, -25)
	frame:SetPoint("BOTTOMRIGHT", gui.barOptions, "BOTTOMRIGHT", -10, 10)

	gui.barOptionsBG = frame

	local offsets = { [2] = 12, [3] = 0, [4] = 0, [6] = 12, [7] = 0, [9] = 12, [10] = 0 }

	local columns = { [11] = (gui:GetWidth()/2) + 10 }

	for index=1,20 do

		frame = CreateFrame("CheckButton", "$parentOption"..index, gui.barOptions, "RazerOrbweaverGUIOptionCBTemplate")
		frame:SetID(index)
		frame:SetScript("OnClick", function(self) R.Option_OnClick(miscOptions[self.option], self:GetChecked()) end)
		frame.text = _G[frame:GetName().."Text"]
		frame.text:SetText(LGUI["OPTION_"..index])
		frame.tooltip = LGUI["OPTION_"..index.."_TOOLTIP"]
		frame.option = frame.text:GetText()

		tinsert(gui.baropts, frame)

		if (index == 1) then
			frame:SetPoint("TOPLEFT", gui.barOptionsBG, "TOPLEFT", 25, -13); anchor = frame; offset = 0
		elseif (index == 11) then
			frame:SetPoint("TOPLEFT", gui.barOptionsBG, "TOPLEFT", columns[index], -13); anchor = frame; offset = 0
		elseif (offsets[index]) then

			frame:SetPoint("TOPLEFT", last, "BOTTOMLEFT", offsets[index], -12)

			if (offsets[index] ~= 0) then
				offset = -(offsets[index])
			end
		else
			frame:SetPoint("TOPLEFT", last, "BOTTOMLEFT", offset, -12)

			if (offset ~= 0) then
				offset = 0
			end
		end

		last = frame

	end

	frame = CreateFrame("Frame", "RazerOrbweaverGUI_RazerActions", gui)
	frame:SetAllPoints(gui)
	frame:SetScript("OnShow", function() R.ToggleBars(nil,true) end)
	frame:SetScript("OnHide", function() R.ToggleVehicleEdit(nil, true) end)
	frame:Hide()

	gui.razerActions = frame

	frame = CreateFrame("Frame", "RazerOrbweaverGUI_RazerMoveButtons", gui.razerActions)
	frame:SetBackdrop({ bgFile = "Interface/Tooltips/UI-Tooltip-Background", edgeFile = "Interface/Tooltips/UI-Tooltip-Border", tile = true, tileSize = 16, edgeSize = 16, insets = { left = 4, right = 4, top = 4, bottom = 4 } })
	frame:SetBackdropBorderColor(0, 0.6, 0, 0.6)
	frame:SetBackdropColor(0,0,0,0.5)
	frame:SetPoint("TOPLEFT", 10, -20)
	frame:SetPoint("BOTTOMRIGHT", gui.razerActions, "TOPRIGHT", -10, -125)

	gui.razerMoveButtons = frame

	gui.RBheader = frame:CreateFontString(gui.razerMoveButtons:GetName().."Header", "ARTWORK", "GameFontGreen")
	gui.RBheader:SetPoint("TOP", gui.razerMoveButtons, "TOP", 0, -10)
	gui.RBheader:SetJustifyH("CENTER")
	gui.RBheader:SetText(LGUI.RAZERMOVEACTIONS)

	count, anchor, last = 1, nil, nil

	for i=1,7 do

		frame = CreateFrame("CheckButton", "RazerOrbweaverGUI_SpecAction"..i, gui.razerMoveButtons, "RazerOrbweaverGUISpecialActionTemplate")
		frame:RegisterForDrag("LeftButton", "RightButton")
		frame:SetScript("PostClick", SPECIAL.PostClick)
		frame:SetScript("OnDragStart", SPECIAL.OnDragStart)
		frame:SetScript("OnReceiveDrag", SPECIAL.OnReceiveDrag)
		frame.iconframe:SetVertexColor(0,0.6,0,1)

		setmetatable(frame, SPECIAL_MT)

		frame.icon:SetTexture(RazerActions[i][1])
		frame.specaction = "move_"..i
		frame.actionindex = i

		if (count == 1) then
			frame:SetPoint("TOPLEFT", 15, -40)
			anchor = frame; last = frame; index = count + 7
		elseif (count == 7) then
			frame:SetPoint("LEFT", last, "RIGHT", 67, 0)
			last = frame
		else
			frame:SetPoint("LEFT", last, "RIGHT", 15, 0)
			last = frame
		end

		count = count + 1

		tinsert(gui.razeractions, frame)

	end

	frame = CreateFrame("Frame", "RazerOrbweaverGUI_RazerKeyMapButtons", gui.razerActions)
	frame:SetBackdrop({ bgFile = "Interface/Tooltips/UI-Tooltip-Background", edgeFile = "Interface/Tooltips/UI-Tooltip-Border", tile = true, tileSize = 16, edgeSize = 16, insets = { left = 4, right = 4, top = 4, bottom = 4 } })
	frame:SetBackdropBorderColor(0, 0.6, 0, 0.6)
	frame:SetBackdropColor(0,0,0,0.5)
	frame:SetPoint("TOPLEFT", gui.razerMoveButtons, "BOTTOMLEFT", 0, -5)
	frame:SetPoint("BOTTOMRIGHT", -10, 180)

	gui.razerKeyMapButtons = frame

	gui.KMheader = frame:CreateFontString(gui.razerKeyMapButtons:GetName().."Header", "ARTWORK", "GameFontGreen")
	gui.KMheader:SetPoint("TOP", gui.razerKeyMapButtons, "TOP", 0, -10)
	gui.KMheader:SetJustifyH("CENTER")
	gui.KMheader:SetText(LGUI.RAZERKEYMAPACTIONS)

	count, anchor, last = 1, nil, nil

	for i=8,15 do

		frame = CreateFrame("CheckButton", "RazerOrbweaverGUI_SpecAction"..i-7, gui.razerKeyMapButtons, "RazerOrbweaverGUISpecialActionTemplate")
		frame:RegisterForDrag("LeftButton", "RightButton")
		frame:SetScript("PostClick", SPECIAL.PostClick)
		frame:SetScript("OnDragStart", SPECIAL.OnDragStart)
		frame:SetScript("OnReceiveDrag", SPECIAL.OnReceiveDrag)
		frame.iconframe:SetVertexColor(0,0.6,0,1)

		setmetatable(frame, SPECIAL_MT)

		frame.icon:SetTexture(RazerActions[8][1])
		frame.keymaptext:SetText(i-7)
		frame.specaction = "keymap_"..i-7
		frame.icon:SetVertexColor(0.5,0.5,0.5)

		if (count == 1) then
			frame:SetPoint("TOPLEFT", 15, -40)
			anchor = frame; last = frame; index = count + 7
		else
			frame:SetPoint("LEFT", last, "RIGHT", 15, 0)
			last = frame
		end

		count = count + 1

		tinsert(gui.razeractions, frame)

	end

	frame = CreateFrame("Frame", "RazerOrbweaverGUI_VehicleButtons", gui.razerActions)
	frame:SetBackdrop({ bgFile = "Interface/Tooltips/UI-Tooltip-Background", edgeFile = "Interface/Tooltips/UI-Tooltip-Border", tile = true, tileSize = 16, edgeSize = 16, insets = { left = 4, right = 4, top = 4, bottom = 4 } })
	frame:SetBackdropBorderColor(0, 0.6, 0, 0.6)
	frame:SetBackdropColor(0,0,0,0.5)
	frame:SetPoint("TOPLEFT", gui.razerKeyMapButtons, "BOTTOMLEFT", 0, -5)
	frame:SetPoint("BOTTOMRIGHT", -10, 40)

	gui.vehicleButtons = frame

	gui.VEHheader = frame:CreateFontString(gui.vehicleButtons:GetName().."Header", "ARTWORK", "GameFontGreen")
	gui.VEHheader:SetPoint("TOP", gui.vehicleButtons, "TOP", 0, -10)
	gui.VEHheader:SetJustifyH("CENTER")
	gui.VEHheader:SetText(LGUI.VEHICLEACTIONS)

	frame = CreateFrame("CheckButton", "$parentUseVehicleButtons", gui.razerActions, "RazerOrbweaverGUIOptionCBTemplate")
	frame.text:SetText(LGUI.ENABLE_VEHICLE)
	frame:SetPoint("BOTTOMLEFT", gui.vehicleButtons, "BOTTOMLEFT", 5, 10)
	frame:SetScript("OnShow", useVehicle_OnShow)
	frame:SetScript("OnClick", useVehicle_OnClick)

	gui.use_vehicle = frame

	frame = CreateFrame("Button", "$parentVehicleToggle", gui.razerActions, "RazerOrbweaverOptionButtonTemplate")
	frame:SetWidth(160)
	frame:SetHeight(25)
	frame:SetPoint("BOTTOMRIGHT", gui.vehicleButtons, "BOTTOMRIGHT", -5, 10)
	frame:SetScript("OnClick", function(self) R.ToggleVehicleEdit() end)
	frame.text:SetText(LGUI.VEHICLE_EDIT_SHOW)

	gui.vehicle_toggle = frame

	count, anchor, last = 1, nil, nil

	for i=1,6 do

		frame = CreateFrame("CheckButton", "RazerOrbweaverGUI_VehicleAction"..i, gui.vehicleButtons, "RazerOrbweaverGUISpecialActionTemplate")
		frame:RegisterForDrag("LeftButton", "RightButton")
		frame:SetScript("PostClick", SPECIAL.PostClick)
		frame:SetScript("OnDragStart", SPECIAL.OnDragStart)
		frame:SetScript("OnReceiveDrag", SPECIAL.OnReceiveDrag)
		frame.iconframe:SetVertexColor(0,0.6,0,1)

		frame.icon:SetTexture(SpecialActions.default)
		frame.keymaptext:SetText(i)

		frame.specaction = "vehicle_"..i

		setmetatable(frame, SPECIAL_MT)

		if (count == 1) then
			frame:SetPoint("TOPLEFT", 15, -40)
			anchor = frame; last = frame; index = count + 2
		else
			frame:SetPoint("LEFT", last, "RIGHT", 15, 0)
			last = frame
		end

		count = count + 1

		tinsert(gui.vehicle_btns, frame)

		frame:Disable()
		frame.icon:SetDesaturated(true)
		frame.keymaptext:SetTextColor(0.5,0.5,0.5)

	end

	frame = CreateFrame("CheckButton", "RazerOrbweaverGUI_SpecialActions3", gui.vehicleButtons, "RazerOrbweaverGUISpecialActionTemplate")
	frame:RegisterForDrag("LeftButton", "RightButton")
	frame:SetScript("PostClick", SPECIAL.PostClick)
	frame:SetScript("OnDragStart", SPECIAL.OnDragStart)
	frame:SetScript("OnReceiveDrag", SPECIAL.OnReceiveDrag)
	frame.iconframe:SetVertexColor(0,0.6,0,1)

	frame.icon:SetTexture(SpecialActions.vehicle)
	frame.icon:SetTexCoord(0.140625,0.859375,0.140625,0.859375)
	frame.specaction = "vehicle_exit"

	setmetatable(frame, SPECIAL_MT)

	frame:SetPoint("LEFT", last, "RIGHT", 67, 0)

	tinsert(gui.vehicle_btns, frame)

	frame:Disable()
	frame.icon:SetDesaturated(true)
	frame.keymaptext:SetTextColor(0.5,0.5,0.5)

	frame = CreateFrame("Frame", "RazerOrbweaverGUI_AdvOptions", gui)
	frame:SetAllPoints(gui)
	frame:Hide()

	gui.advOptions = frame

	local y = -64

	frame = CreateFrame("Frame", "RazerOrbweaverGUI_BarStates", gui.advOptions)
	frame:SetAllPoints()
	frame:SetFrameLevel(gui.advOptions:GetFrameLevel())

	gui.barStates = frame

	gui.barStatesHeader = frame:CreateFontString(gui.barStates:GetName().."Header", "ARTWORK", "GameFontGreen")
	gui.barStatesHeader:SetPoint("TOP", gui.advOptions, "TOP", 0, -10)
	gui.barStatesHeader:SetJustifyH("CENTER")

	frame = CreateFrame("Frame", "RazerOrbweaverGUI_BarPresetActionList", gui.barStates, "RazerOrbweaverListFrameTemplate")
	frame:SetPoint("TOPLEFT", gui.barStates, "TOPLEFT", 10, -25)
	frame:SetPoint("BOTTOMRIGHT", gui.barStates, "BOTTOM", -30, 10)
	frame:SetBackdrop({ bgFile = "Interface/Tooltips/UI-Tooltip-Background", edgeFile = "Interface/Tooltips/UI-Tooltip-Border", tile = true, tileSize = 16, edgeSize = 16, insets = { left = 4, right = 4, top = 4, bottom = 4 } })
	frame:SetBackdropBorderColor(0, 0.6, 0, 0.6)
	frame:SetBackdropColor(0,0,0,0.5)
	frame:SetFrameLevel(gui.advOptions:GetFrameLevel())
	frame.scrollframe:SetScript("OnShow", R.ActionListScrollFrameUpdate)
	frame.scrollframe:SetScript("OnVerticalScroll", function(self, offset) FauxScrollFrame_OnVerticalScroll(self, offset, 2, R.ActionListScrollFrameUpdate) end)

	R:ActionListScrollFrame_OnLoad(frame.scrollframe)

	gui.actionList = frame

	frame = CreateFrame("Frame", "RazerOrbweaverGUI_BarPresetStates", gui.barStates)
	frame:SetPoint("TOPLEFT", gui.actionList, "TOPRIGHT", 10, 0)
	frame:SetPoint("BOTTOMRIGHT", gui.barStates, "BOTTOMRIGHT", -10, 10)
	frame:SetBackdrop({ bgFile = "Interface/Tooltips/UI-Tooltip-Background", edgeFile = "Interface/Tooltips/UI-Tooltip-Border", tile = true, tileSize = 16, edgeSize = 16, insets = { left = 4, right = 4, top = 4, bottom = 4 } })
	frame:SetBackdropBorderColor(0, 0.6, 0, 0.6)
	frame:SetBackdropColor(0,0,0,0.5)
	frame:SetFrameLevel(gui.advOptions:GetFrameLevel())

	gui.barPresetStates = frame

	anchor, last = nil, nil

	for i=1,#barStates-1 do

		if (barStates[i] and barStates[i][2] ~= "exclude") then

			frame = CreateFrame("CheckButton", "$parentRadioCheck"..i, gui.barPresetStates, "RazerOrbweaverGUIOptionCBTemplate")

			frame:SetID(i)
			frame:SetScript("OnClick", function(self, button) R.StateOptions_OnClick(self, self.option, self:GetChecked()) end)
			frame.text = _G[frame:GetName().."Text"]
			frame.text:SetText(barStates[i][2])
			frame.tooltip = barStates[i][3]
			frame.option = frame.text:GetText()

			if (barStates[i][1] == "prowl") then
				frame.prowl = true
			end

			tinsert(gui.optionBtns, frame)

			if (not anchor) then

				frame:SetPoint("TOPLEFT", gui.barPresetStates, "TOPLEFT", 15, -13)
				anchor = frame; last = frame

			else
				frame:SetPoint("TOP", last, "BOTTOM", 0, -9)
				last = frame
			end

		end

	end

	frame = CreateFrame("Button", "RazerOrbweaverGUI_Tab1", gui, "RazerOrbweaverTabTemplate")
	frame:SetPoint("TOPLEFT", gui, "BOTTOMLEFT", 11, 2)
	frame:SetScript("OnClick", function(self) TabsOnClick(self) R.ToggleBars(true) end)
	frame:SetID(1)
	frame.text:SetText(LGUI.GAMEPAD)

	gui.tab1 = frame; gui.tabs[frame] = gui.gamePadOptions

	frame = CreateFrame("Button", "RazerOrbweaverGUI_Tab2", gui, "RazerOrbweaverTabTemplate")
	frame:SetPoint("LEFT", gui.tab1, "RIGHT", -15, 0)
	frame:SetScript("OnClick", function(self) TabsOnClick(self) R.ToggleBars(nil, true) end)
	frame:SetID(2)
	frame.text:SetText(LGUI.BUTTONS)

	gui.tab2 = frame; gui.tabs[frame] = gui.razerActions

	frame = CreateFrame("Button", "RazerOrbweaverGUI_Tab3", gui, "RazerOrbweaverTabTemplate")
	frame:SetPoint("LEFT", gui.tab2, "RIGHT", -15, 0)
	frame:SetScript("OnClick", function(self) TabsOnClick(self) R.ToggleBars(true) end)
	frame:SetID(3)
	frame.text:SetText(LGUI.BARS)

	gui.tab3 = frame; gui.tabs[frame] = gui.barOptions

	frame = CreateFrame("Button", "RazerOrbweaverGUI_Tab4", gui, "RazerOrbweaverTabTemplate")
	frame:SetPoint("LEFT", gui.tab3, "RIGHT", -15, 0)
	frame:SetScript("OnClick", function(self) TabsOnClick(self) R.ToggleBars(true) end)
	frame:SetID(4)
	frame.text:SetText(LGUI.ADVANCED)

	gui.tab4 = frame; gui.tabs[frame] = gui.advOptions

	PanelTemplates_SelectTab(gui.tab1); PanelTemplates_TabResize(gui.tab1, 0, nil, 75, 90)

	PanelTemplates_DeselectTab(gui.tab2); PanelTemplates_TabResize(gui.tab2, 0, nil, 75, 90)

	PanelTemplates_DeselectTab(gui.tab3); PanelTemplates_TabResize(gui.tab3, 0, nil, 75, 90)

	PanelTemplates_DeselectTab(gui.tab4); PanelTemplates_TabResize(gui.tab4, 0, nil, 75, 90)

	SetPosition(gui)
end

local numShown = 15

function R:ActionListScrollFrame_OnLoad(frame)

	frame.offset = 0
	frame.scrollChild = _G[frame:GetName().."ScrollChildFrame"]

	frame:SetBackdropBorderColor(0.5, 0.5, 0.5)
	frame:SetBackdropColor(0,0,0,0.5)

	local button, lastButton, rowButton, count, script = false, false, false, 0

	for i=1,numShown do

		button = CreateFrame("CheckButton", frame:GetName().."Button"..i, frame:GetParent(), "RazerOrbweaverScrollFrameButtonTemplate")

		button.frame = frame:GetParent()
		button.numShown = numShown
		button.elapsed = 0

		button:SetScript("OnClick",

			function(self)

				local button

				for i=1,numShown do

					button = _G["RazerOrbweaverGUI_BarPresetActionListScrollFrameButton"..i]

					if (i == self:GetID()) then

						if (self.bar) then
							self.bar:SetFauxState(self.state)
						end

					else
						button:SetChecked(nil)
					end

				end

			end)

		button:SetScript("OnEnter",
			function(self)

			end)

		button:SetScript("OnLeave",
			function(self)

			end)

		button:SetScript("OnShow",
			function(self)
				self.elapsed = 0; self.setheight = true
			end)

		button:SetScript("OnUpdate",

			function(self,elapsed)

				self.elapsed = self.elapsed + elapsed

				if (self.setheight and self.elapsed > 0.03) then
					self:SetHeight((self.frame:GetHeight()-10)/self.numShown)
					self.setheight = nil
				end
			end)

		button.name = button:CreateFontString(button:GetName().."Index", "ARTWORK", "GameFontGreen")
		button.name:SetPoint("TOPLEFT", button, "TOPLEFT", 5, 0)
		button.name:SetPoint("BOTTOMRIGHT", button, "BOTTOMRIGHT", -5, 0)
		button.name:SetJustifyH("LEFT")

		button:SetID(i)
		button:SetFrameLevel(frame:GetFrameLevel()+2)
		button:SetNormalTexture("")

		if (not lastButton) then
			button:SetPoint("TOPLEFT", 8, -5)
			button:SetPoint("TOPRIGHT", -15, -5)
			lastButton = button
		else
			button:SetPoint("TOPLEFT", lastButton, "BOTTOMLEFT", 0, 0)
			button:SetPoint("TOPRIGHT", lastButton, "BOTTOMRIGHT", 0, 0)
			lastButton = button
		end

	end

	R.ActionListScrollFrameUpdate()
end

local stateList = {}

function R.ActionListScrollFrameUpdate(frame)

	if (not RazerOrbweaverGUI_BarPresetActionList:IsVisible()) then return end

	local bar, i

	if (R.CurrentBar) then

		wipe(stateList)

		bar, i = R.CurrentBar

		stateList["00"..L.HOMESTATE] = "homestate"

		for state, values in pairs(R.MS) do

			if (bar.cdata[state] and state ~= "vehicle" and state ~= "possess" and state ~= "override" and state ~= "extrabar") then

				for index, name in pairs(R.STATES) do

					if (index ~= "laststate" and name ~= ATTRIBUTE_NOOP and values.states:find(index)) then

						i = index:match("%d+")

						if (i) then
							i = values.order..i
						else
							i = values.order
						end

						if (values.homestate and index == values.homestate) then
							stateList["00"..name] = "homestate"; stateList["00"..L.HOMESTATE] = nil
						elseif (values.order < 10) then
							stateList["0"..i..name] = index
						else
							stateList[i..name] = index
						end
					end
				end
			end
		end

	else
		wipe(stateList)
	end

	if (not frame) then
		frame = RazerOrbweaverGUI_BarPresetActionListScrollFrame
	end

	local dataOffset, count, data, button, text, datum = FauxScrollFrame_GetOffset(frame), 1, {}

	for k in pairs(stateList) do
		data[count] = k; count = count + 1
	end

	table.sort(data)

	frame:Show()

	frame.buttonH = frame:GetHeight()/numShown

	for i=1,numShown do

		button = _G["RazerOrbweaverGUI_BarPresetActionListScrollFrameButton"..i]
		button:SetChecked(nil)

		count = dataOffset + i

		if (data[count]) then

			text = data[count]

			if (bar and stateList[text] == bar.handler:GetAttribute("fauxstate")) then
				button:SetChecked(1)
			end

			button.bar = bar
			button.state = stateList[text]
			button.name:SetText(text:gsub("^%d+",""))
			button:Enable()
			button:Show()

			button.name:SetJustifyH("CENTER")

		else

			button:Hide()
		end
	end

	FauxScrollFrame_Update(frame, #data, numShown, 2)
end

local function hookBar(bar, handler)

	bar:HookScript("OnClick", function(self, button) R.BarEditorUpdateData(self) end)

	handler:HookScript("OnAttributeChanged", function(self,name,value)

		if (R.GUI:IsVisible() and name == "activestate" and R.CurrentBar == self.bar) then
			R.BarEditorUpdateData(self.bar, true)
		end

	end)
end

local function controlOnEvent(self, event, ...)

	if (event == "ADDON_LOADED" and ... == "RazerOrbweaver_GUI") then

		DB = RazerOrbweaverDB

		for k,v in pairs(R.MS) do
			if (k ~= "vehicle" and k ~= "override" and k ~= "possess" and k ~= "extrabar") then
				barStates[v.order] = { k, LGUI["BARSTATE_"..k], LGUI["BARSTATE_"..k.."_TOOLTIP"] }
			end
		end

		CreateGUI()

		for index, bar in pairs(R.BARIndex) do
			hookBar(bar, bar.handler)
		end

	end
end

local frame = CreateFrame("Frame", nil, UIParent)
frame:SetScript("OnEvent", controlOnEvent)
frame:RegisterEvent("ADDON_LOADED")