//
//  AppTracker.h
//  AppTracker
//
//  Created by Stefan on 15.02.14.
//  Copyright (c) 2014 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AppTrackerApp.h"
#import "AppTrackerRecording.h"
#import "AppTrackerGroup.h"



@interface AppTracker : NSObject


@property (readonly, strong, nonatomic) NSPersistentStoreCoordinator *persistentStoreCoordinator;
@property (readonly, strong, nonatomic) NSManagedObjectModel *managedObjectModel;
@property (readonly, strong, nonatomic) NSManagedObjectContext *managedObjectContext;
@property (strong, nonatomic) NSURL *url;


@property (strong, nonatomic) NSArrayController * recordingsArrayController;
@property (strong, nonatomic) NSManagedObject * currentRecording;
@property (assign, nonatomic) CFTimeInterval idleTime;
@property (assign, nonatomic) NSNumber * enabled;
@property (strong, nonatomic) NSNumber *idleThreshold;


+(AppTracker *)sharedAppTracker;
-(void)start:(id)sender;
-(NSArray *)itemsFromDate:(NSDate *)fromDate toDate:(NSDate *)toDate;
@end
