//
//  FSConnection.h
//  Instacast
//
//  Created by Martin Hering on 06.09.12.
//
//

#import <Foundation/Foundation.h>

typedef enum {
    kFSConnectionValidationNoError,
    kFSConnectionValidationNoInternetConnectionError,
    kFSConnectionValidationAuthenticationError,
    kFSConnectionValidationServerError
} FSConnectionValidationError;

extern NSString* FSConnectionContentDidChangeExternallyNotification;

extern NSString* CrossbucketSyncDomain;

@protocol FSConnectionProtocol <NSObject>
@required
- (NSURL*) serviceURL;
- (NSDictionary*) identityInfo;
- (BOOL) supportsLocalPush; // default = NO

// synchronous
- (BOOL) coordinateSyncingWithError:(NSError**)outError byBlock:(BOOL (^)(NSURL* serviceURL))block;

- (NSMutableDictionary *) directoryContentsAtURL:(NSURL *)theURL error:(NSError**)error;
- (NSMutableDictionary *) directoryContentsAtURL:(NSURL *)theURL depth:(NSInteger)theDepth error:(NSError**)error;
- (BOOL) createDirectory:(NSURL *)theURL;
- (BOOL) removeURL:(NSURL *)theURL;
- (BOOL) appendFile:(NSString *)thePath toURL:(NSURL *)theURL;
- (BOOL) appendURL:(NSURL *)theURL toFile:(NSString *)thePath;

- (BOOL) isValidWithInfo:(NSDictionary**)validationInfo error:(FSConnectionValidationError*)error;

@end


@interface FSConnection : NSObject <FSConnectionProtocol, NSCoding>

@property (nonatomic, strong) NSString* syncIdentifier;

@end


