//
//  FSServerDictionaryUtilites.h
//  Sync
//
//  Created by Martin Hering on 27.04.13.
//  Copyright (c) 2013 Stefan. All rights reserved.
//

#import <Foundation/Foundation.h>

extern NSString* kDeviceInfoFileName;
extern NSString* kLogFileName;
extern NSString* kLogIndexFileName;
extern NSString* kDeltaIndexFileName;


@class FSConnection;

@interface FSFileSystem : NSObject

+ (id) fileSystemWithConnection:(FSConnection*)connection queue:(dispatch_queue_t)syncQueue;

// only invoke from within the sync queue!
- (NSDictionary*) _serverDictionaryError:(NSError**)error;
- (NSInteger) remoteRepository;
- (NSArray*) devicesInRepository:(NSInteger)repository;


// can be used on main thread
- (BOOL) loadDeviceInfosCompletion:(void(^)(NSArray* deviceInfos, NSError* error))completion;
- (void) cancel;
@end
