//
//  FSLoginViewController.h
//  Sync
//
//  Created by Martin Hering on 03.10.12.
//  Copyright (c) 2012 Stefan. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class FSManagedObjectContext;
@protocol FSLoginViewControllerDelegate;

@interface FSLoginViewController : NSViewController

+ (NSURL*) authURLWithPath:(NSString*)path;

+ (FSLoginViewController*) beginLoginSheetForWindow:(NSWindow*)window context:(FSManagedObjectContext*)context;

@property (nonatomic, strong) FSManagedObjectContext* context;
@property (nonatomic, weak) id<FSLoginViewControllerDelegate> delegate;

@end


@protocol FSLoginViewControllerDelegate
- (void) loginViewControllerDidSignin:(FSLoginViewController*)controller;
@end