//
//  RMTextMarkdownParserOperation.h
//  RMTextKit
//
//  Created by James Beith on 17/07/2014.
//  Copyright (c) 2014 Realmac Software. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSUInteger, RMTextMarkdownParserOperationFormatType) {
	RMTextMarkdownParserOperationFormatTypeHTMLBody = 0,
	RMTextMarkdownParserOperationFormatTypeHTMLDocument = 1,
	RMTextMarkdownParserOperationFormatTypeRTF = 2,
};

@interface RMTextMarkdownParserOperation : NSOperation

- (id)initWithMarkdownSource:(NSString *)markdownSource formatType:(RMTextMarkdownParserOperationFormatType)formatType;

@property (readonly, copy, atomic) NSString * (^completionProvider)(NSError **errorRef);

@end
