AnimateMate Plugin For Sketch
=============================

#### "Create your animations directly in Sketch using AnimateMate."

![AnimateMate - Logo Animation](https://github.com/Creatide/AnimateMate/blob/gh-pages/img/readme/AnimateMate_LogoAnimation_GitHub.gif)

<br><br>

##### *Haha, is this joke or what?! Why the heck do I need animation tools in Sketch.*

You know feeling when you just need a simple animation for your awesome concept and you realize that it's a huge process to move all assets into some other application? That’s a lot of hassle! Like this example.

<br>

![AnimateMate - Slider Example](https://github.com/Creatide/AnimateMate/blob/gh-pages/img/readme/AnimateMate_Example_Slider_0-135.gif)

##### *I Know the Feeling!*

That's why I created AnimateMate in order to produce and export simple animations straight out of Sketch. It's not exactly rocket science, but it can lighten your workflow in some cases. 
So let the game begin!

![AnimateMate - Game Example](https://github.com/Creatide/AnimateMate/blob/gh-pages/img/readme/AnimateMate_Example_PingPong_0-100.gif)


## Install

Copy **`AnimateMate.sketchplugin`** to **Sketch** plugins folder. 

> Easiest way to go into your Sketch plugin folder:<br>
**Plugins > Manage Plugins > Reveal Plugins Folder**


## How to Use

There are tons of ways to use **AnimateMate** and I'll try to explain basics in this video.

<a href="http://www.youtube.com/watch?feature=player_embedded&v=bDm_c4wPBkc
" target="_blank"><img src="https://github.com/Creatide/AnimateMate/blob/gh-pages/img/readme/AnimateMate_Basics_Video_YouTube_Thumbnail.png" 
alt="AnimateMate Basics" /></a>

You could run into a situation when you're wondering why it's working this or that way... This plugin does not convert your **Sketch** to a fully featured animation software :) However, it'll help you in many simple cases, but if you need more complex animations you should consider some other animation tools. **AnimateMate** was made for creating simple animations at least for now, we'll see how it'll develop in the future...

#### Shortcuts

Command               | Shortcut                              | Description
:-------------------  | :------------------------------------ | :----------------------------------------------------
**Create Animation**  | *`ctrl` + `option` + `cmd` +* **`K`** | Create new animation / keyframe to layer.
**Offset Animation**  | *`ctrl` + `option` + `cmd` +* **`O`** | Offset animated and/or keyframe values.
**Random Animation**  | *`ctrl` + `option` + `cmd` +* **`G`** | Generate random animation to selected layers.
**Edit Animation**    | *`ctrl` + `option` + `cmd` +* **`L`** | Edit layer animation values in ordered text view.
**Delete Animation**  | *`ctrl` + `option` + `cmd` +* **`D`** | Delete animation from selected layer(s).
**Return Keyframe**   | *`ctrl` + `option` + `cmd` +* **`R`** | Return selected keyframe values to layer(s).
**Export Animation**  | *`ctrl` + `option` + `cmd` +* **`A`** | Export your animation to PNG or GIF format.
**Reverse Keyframes** | *`ctrl` + `option` + `cmd` +* **`B`** | Reverse keyframes in single or multiple animations.


## Examples

Here are a couple examples that are made using **AnimateMate** plugin in **Sketch**. You'll find more info and examples in the [AnimateMate.com](http://animatemate.com) web pages.

![Example 1](https://github.com/Creatide/AnimateMate/blob/gh-pages/img/readme/AnimateMate_Example_001.gif)

![Example 2](https://github.com/Creatide/AnimateMate/blob/gh-pages/img/readme/AnimateMate_Example_002.gif)

![Example 3](https://github.com/Creatide/AnimateMate/blob/gh-pages/img/readme/AnimateMate_Example_003_RandomAnimation.gif)

![Example 4](https://github.com/Creatide/AnimateMate/blob/gh-pages/img/readme/AnimateMate_Example_004_RandomAnimation.gif)

![Example 5](https://github.com/Creatide/AnimateMate/blob/gh-pages/img/readme/AnimateMate_Example_005_MaskAnimation.gif)

![Example 6](https://github.com/Creatide/AnimateMate/blob/gh-pages/img/readme/AnimateMate_Example_006_Over2kItemCountRenderTest.gif)

![Example 7](https://github.com/Creatide/AnimateMate/blob/gh-pages/img/readme/AnimateMate_Example_007_ManyItemsCountRenderTest.gif)

![Example 8](https://github.com/Creatide/AnimateMate/blob/gh-pages/img/readme/AnimateMate_Example_008_LoadingIndicators.gif)

![Example 9](https://github.com/Creatide/AnimateMate/blob/gh-pages/img/readme/AnimateMate_Example_CassetteDemo.gif)


## Known Bugs to Fix

* [ ] Export scaling option doesn't work after Sketch 41 version.

## Roadmap & Feature Ideas

* [x] Remember values in some input fields in dialogs
* [ ] Visual timeline editor
* [ ] Improve groups workflow
* [ ] Text animations
* [ ] Randomize exist keyframe values
* [ ] Select a layer by keyframe numbers
* [ ] Anchor helper object into the workflow
* [x] Reverse keyframes
* [ ] Spread keyframes to a given time
* [ ] Multiple easing types in animations
* [x] More options to GIF exporting


## Colloboration & Feedback

If you fork AnimateMate and create some useful updates, please do send me pull requests so I can include your work to AnimateMate and give you credit here!

There is so much to do in order to make it better! Collaboration is very welcome and all feedback is greatly appreciated [hello@creatide.com](mailto:hello@creatide.com)

> I'm a Visual Designer and a hobbyist coder. So if you're a more experienced with code, I know we can make it even better :)


## About

I think **Sketch** is super useful in many design tasks. But while using Sketch and as well many other graphic design softwares I was always longing for the basic level of animation tools. Usually it's only the basic move-, rotation-, scale- or transparency animations that needed to visualise something simple.

I think most of the graphical design sofwares should include at least some very basic level of animation tools. Like in Photoshop I've nowadays found many good uses for animation tools. Too often it would be hard work to transfer all assets to other software just for creating simple animations. Still, it doesn't need to be such a complex system...

### Author

**AnimateMate** made by [Creatide](http://creatide.com) *([Sakari Niittymaa](http://sakari.niittymaa.com))*

> Creatide is not a company nor a big factory. It's a single Designer who also loves coding and improving workflow. I create tools for my personal usage in order to relieve my design process, so every tool is used by myself. Some of those tools end up being released to the public under this name and domain.

> Working as a designer makes your come up with different ideas on how your workflow could be improved. My approach: when you got an idea for a specific tool, create it, then you have it. That's what Creatide is all about.

### Contributors

Thank you all for your contributions. Special thanks to these people for writing code:

[@headlessme](https://github.com/headlessme)

### Licence

The MIT License (MIT)
Copyright (c) 2017 [Creatide](http://creatide.com) *([Sakari Niittymaa](http://sakari.niittymaa.com))*

### Used Libraries & Tools

- [Gifsicle](https://github.com/kohler/gifsicle)
- [Robert Penner's Easing Functions](http://robertpenner.com/easing/)
