#include "ReShade.fxh"

uniform float size <
	ui_type = "drag";
	ui_min = 2;
	ui_max = 16;
	ui_label = "Crosshair Size";
	ui_tooltip = "Size of the crosshair in pixels";
> = 3.5;

uniform float thick <
	ui_type = "drag";
	ui_min = 0.1;
	ui_max = 4;
	ui_label = "Crosshair Thickness";
	ui_tooltip = "Thickness of the crosshair in pixels";
> = 1.5;

uniform int crosshair_color_r <
	ui_type ="drag";
	ui_min = 0;
	ui_max = 255;
	ui_label = "Crosshair color red";
	ui_tooltip = "Color Red";
> = 255;

uniform int crosshair_color_g <
	ui_type ="drag";
	ui_min = 0;
	ui_max = 255;
	ui_label = "Crosshair color green";
	ui_tooltip = "Color Green";
> = 142;

uniform int crosshair_color_b <
	ui_type ="drag";
	ui_min = 0;
	ui_max = 255;
	ui_label = "Crosshair color blue";
	ui_tooltip = "Color Blue";
> = 255;

#define crosshair_color float3( crosshair_color_r/255, crosshair_color_g/255, crosshair_color_b/255)

float3 PS_crosshairRing(float4 pos : SV_Position, float2 texcoord : TexCoord) : SV_Target {
	float3 color = tex2D(ReShade::BackBuffer, texcoord).rgb;
	float2 center = float2( (BUFFER_WIDTH / 2)-1, (BUFFER_HEIGHT / 2)-1);

	float dist_fromCenter = distance(center, pos);
	float dist_fromIdeal = abs(dist_fromCenter - size);
	float mix = max(thick - dist_fromIdeal,0) / thick;
	color = lerp(color, crosshair_color, mix);
	
	return color;
}

float3 PS_crosshairCross(float4 pos : SV_Position, float2 texcoord : TexCoord) : SV_Target {
	float3 color = tex2D(ReShade::BackBuffer, texcoord).rgb;
	float2 center = float2( (BUFFER_WIDTH / 2)-1, (BUFFER_HEIGHT / 2)-1);

	float dist_fromVertical = abs(center.x - pos.x);
	float dist_fromHorizontal = abs(center.y - pos.y);
	
	float mix;
	
	if (dist_fromVertical<dist_fromHorizontal) {
		mix = min(max(thick - dist_fromVertical,0)/thick,max(size-dist_fromHorizontal,0));
	} else {
		mix = min(max(thick - dist_fromHorizontal,0)/thick,max(size-dist_fromVertical,0));
	}

	color = lerp(color, crosshair_color, mix);
	return color;
}

technique Ring {
	pass crosshairRing {
		VertexShader=PostProcessVS;
		PixelShader=PS_crosshairRing;		
	}
}

technique Cross {
	pass crosshairCross {
		VertexShader=PostProcessVS;
		PixelShader=PS_crosshairCross;
	}
}