var exec = require("child_process").exec;
var path = require("path");
var dingtalkGYPPath = require.resolve(path.join('nw-gyp', 'bin', 'nw-gyp.js'));
var os = require('os');
var osName = 'win';
var pkg = require("../package.json");
var configKey = "dingtalk-gyp-config";
var fs = require("fs-extra");
if(os.platform() === 'darwin'){
    osName = 'mac';
}
var arch = osName === "win" ? "ia32" : "x64";
var addons = path.join(process.cwd(),"add-on");
var buildPath = path.join(process.cwd(),"build");
var targetSrc = path.join(buildPath,"Release/dingtalk_graffiti.node");
var targetDest = "";

var versionKey = "version";
var pdbSrcDir = path.join(buildPath,"Release/dingtalk_graffiti.pdb");;
var pdbDestDir = "\\\\minint-u3nmshv\\dingtalk_share\\node_module\\dingtalk-graffiti\\";

function _constructWinConfigArgs(winCfg){
    if(!winCfg){
        return new Error("windows dingtalk configuration is need");
    }
    var _configureOption = winCfg["configure"];
    var argsRecognition = ["target","arch","target_arch","runtime","build-from-source"];
    var args = ["configure"];
    argsRecognition.forEach(function(arg){
        if(_configureOption[arg]!=undefined){
            if(_configureOption[arg]){
                args.push("--"+arg+"="+_configureOption[arg]);
            }else{
                args.push("--"+arg);
            }
        }
    })
    return args;
}

function _constructWinBuildArgs(winCfg){
    return ["build"];
}

function _configure(callback){
    var _cfg = _constructWinConfigArgs(pkg[configKey][osName]);
    var name = "dingtalk_graffiti.node";
	targetDest = path.join(addons,name);
	
	//pdb backup configuration
	var pdbName = "dingtalk_graffiti.pdb";
	var version = pkg[versionKey];
    pdbDestDir = path.join(pdbDestDir,version);
	pdbDestDir = path.join(pdbDestDir,pdbName);
	
    if(_cfg instanceof Error){
        callback && callback(_cfg);
    }
    var configure = ["node",dingtalkGYPPath].concat(_cfg).join(" ");
    console.log(configure);
    var data = exec(configure,function(err){
        callback && callback(err);
    });
    data.stdout.on("data",function(out){
        console.log(out);
    });

    data.stderr.on("data",function(err){
        console.log(err);
    })
}

function _build(callback){
    var _cfg = _constructWinBuildArgs(pkg[configKey][osName]);
    if(_cfg instanceof Error){
        callback && callback(_cfg);
    }
    var build = ["node",dingtalkGYPPath].concat(_cfg).join(" ");
    console.log(build)
    var data = exec(build,function(err){
        callback && callback(err);
    })
    data.stdout.on("data",function(out){
        console.log(out);
    });

    data.stderr.on("data",function(err){
        console.log(err);
    })
}

function _clean(){
    try{
        if(!fs.existsSync(addons)){
            fs.mkdirsSync(addons);
        }
        fs.copySync(targetSrc,targetDest);
		fs.copySync(pdbSrcDir,pdbDestDir); //pdb backup
        //fs.removeSync(buildPath);
    }catch(e){
        console.log(e);
    }
}

function buildWithDingtalkGYP(){
    if(fs.existsSync(addons)){
        fs.removeSync(addons);
    }
    _configure(function(err){
        if(!err){
            _build(function(err){
                if(!err){
                    _clean();
                }
            });
        }else{
            console.log(err);
        }
    })
}

buildWithDingtalkGYP();