var pkg = require("../package.json");
var installCfg = pkg.installConfig;
var os = require('os');
var osName = 'win';
var platform = os.platform();
var url = require("url");
var Download = require('@ali/ding-download').Download;
var md5 = require("md5-file");
var fs = require("fs");
var path = require("path");
if(platform === 'darwin'){
    osName = 'mac';
}
var arch = osName === "win" ? "ia32" : "x64";

function install(){
	if(osName === 'win')
	{
		var name = "dingtalk_graffiti.node";
		var downloadUrl = url.resolve(installCfg.installUrl,"./v"+pkg.version+"/"+name);
		var addons = path.join(process.cwd(),"add-on");
		if(!fs.existsSync(addons)){
			fs.mkdirSync(addons);
		}
		var targetDest = path.join(addons,"dingtalk_graffiti.node");
		console.log("start to download the binary package");
		console.log(downloadUrl);
		var d = new Download(downloadUrl, targetDest);
		d.addListener(d.EventsName.finish, function(){
			var md5Value =  md5(targetDest);
			//console.log(md5Value);
			if(md5Value !== installCfg[osName]["md5"][arch]){
				console.log("md5 is not the same");
			}else{
				console.log("download success");
			}
		})
		d.addListener(d.EventsName.error, function(err){
			console.log(err);
		})
	}
	else
	{
		console.log("mac os, do nothing");
	}
}

install();