{
  "targets": [
    { 
      "target_name": "sqlite3_node",
      "include_dirs": ["<!(node -e \"require('nan')\")", "src/dingtalk_crypto/openssl/openssl-1.0.2/include",
      	"src/dingtalk_crypto", "src/dingtalk_monitor"],
      "cflags": [ 
          "-include ../src/gcc-preinclude.h",
          "--std=c++11",
          "-fno-rtti",
          "-pthread"
      ],
      'library_dirs':[
	    'src/dingtalk_crypto/openssl',
	  ],

      # "conditions": [
      #     ["OS=='mac'", {
      #       "xcode_settings": {
      #       "GCC_ENABLE_CPP_EXCEPTIONS": "YES",
      #         'MACOSX_DEPLOYMENT_TARGET': '10.7',
      #         'OTHER_CPLUSPLUSFLAGS' : ['-std=c++11','-stdlib=libc++'],
      #         'OTHER_LDFLAGS': ['-stdlib=libc++'],
      #       },
      #     }],
      #     ["OS=='win'",{
      #       'defines': [
      #       ],
      #     }],
      # ],
      "conditions": [
          ["OS=='mac'", {
              "libraries" : [
	          "-lcrypto",
		  "$(SDKROOT)/System/Library/FrameWorks/AppKit.framework",
	      ],
              "xcode_settings": {
                  "GCC_ENABLE_CPP_EXCEPTIONS": "YES",
                  'MACOSX_DEPLOYMENT_TARGET': '10.7',
                  'OTHER_CPLUSPLUSFLAGS' : ['-std=c++11','-stdlib=libc++'],
                  'OTHER_LDFLAGS': ['-stdlib=libc++'],
              },
	      'sources':[
	          "src/dingtalk_clipboard/clipboard_mac.mm",
		  "src/dingtalk_clipboard/sys_string_conversions_mac.mm",

	      ],
          }],
          ["OS=='win'",{
	      "libraries": ['-llibeay32MT.lib', '-lssleay32MT.lib'],
	      'sources': [
	          "src/dingtalk_clipboard/clipboard_win.cc",
	      ],
          }]
      ],
      "defines": [
        "SQLITE_HAS_CODEC", 
        "NDEBUG=1", 
        '_HAS_EXCEPTIONS=1',
        "HAVE_USLEEP=1", 
        "SQLITE_HAVE_ISNAN",
        "SQLITE_DEFAULT_JOURNAL_SIZE_LIMIT=1048576", 
        "SQLITE_THREADSAFE=2", 
        "SQLITE_TEMP_STORE=3"
        #"SQLITE_POWERSAFE_OVERWRITE=1", 
        #"SQLITE_DEFAULT_FILE_FORMAT=4", 
        #"SSQLITE_DEFAULT_AUTOVACUUM=1",
        #"SQLITE_ENABLE_MEMORY_MANAGEMENT=1", 
        #"SQLITE_ENABLE_FTS3", 
        #"SQLITE_ENABLE_FTS3_BACKWARDS",
        #"SQLITE_ENABLE_FTS4", 
        #"SQLITE_OMIT_BUILTIN_TEST", 
        #"SQLITE_OMIT_COMPILEOPTION_DIAGS", 
        #"SQLITE_OMIT_LOAD_EXTENSION", 
        #"SQLITE_DEFAULT_FILE_PERMISSIONS=0600", 
        #"NO_ANDROID_FUNCS=0",
        #"SQLITE_DEFAULT_MEMSTATUS=0"
      ],
      "sources": [
        "src/utils.cc",
        "src/database.cc",
        "src/node_sqlite3.cc",
        "src/statement.cc",
        "src/sqlcrypto/crypto.c",
        "src/sqlcrypto/aes/aescrypt.c",
        "src/sqlcrypto/aes/aeskey.c",
        "src/sqlcrypto/aes/aestab.c",
        "src/sqlcrypto/sqlite3/shell.c",
        "src/search/searcher.cpp",
        "src/search/log.cpp",
        "src/search/pinyin.cpp",
        "src/search/mman.cpp",
        "src/search/v8/search_provider_v8.cc",
        "src/search/v8/basictypes.cc",
        "src/search/v8/cJSON.c",
        "src/search/v8/cJSON_Utils.cc",
        "src/dingtalk_crypto/dingtalk_crypto.cpp",
        "src/dingtalk_crypto/cryptokit/Aes128CBC.cpp",
        "src/dingtalk_crypto/cryptokit/Aes256CBC.cpp",
        "src/dingtalk_crypto/cryptokit/AesCBC.cpp",
        "src/dingtalk_crypto/cryptokit/Binary.cpp",
        "src/dingtalk_crypto/cryptokit/CryptoBuilder.cpp",
        "src/dingtalk_crypto/cryptokit/CryptoKit.cpp",
        "src/dingtalk_crypto/cryptokit/SecretWithHeader.cpp",
        "src/dingtalk_crypto/cryptokit/Base64.cpp",
        "src/dingtalk_crypto/cryptokit/BlackBox.cpp",
        "src/dingtalk_monitor/dingtalk_monitor.cpp",
        "src/dingtalk_clipboard/dingtalk_clipboard.cpp",
        "src/dingtalk_clipboard/string_number_conversions.cc",
        "src/dingtalk_clipboard/string_piece.cc",
	
      ]
    },
  ]
}
