var Client = require("./client");

var clients = {}

function getClientInstance(name){
    if(clients[name]){
        return clients[name]
    }else{
        return clients[name] = new Client(name);
    }
}

function getClients(clientNames){
    return clientNames.map(function(name){
        return clients[name];
    })
}

function getAllClients(){
    return Object.keys(clients).map(function(name){
        return clients[name];
    })
}

function destroyClient(name){
    if(clients[name]){
        delete clients[name]
    }
}

function detroyAllClients(){
    Object.keys(clients).map(function(name){
        delete clients[name];
    })
}

module.exports = {
    getClientInstance : getClientInstance,
    getClients:getClients,
    getAllClients : getAllClients,
    destroyClient : destroyClient,
    detroyAllClients: detroyAllClients
}