webpackJsonp([0],[
/* 0 */,
/* 1 */,
/* 2 */,
/* 3 */,
/* 4 */,
/* 5 */,
/* 6 */,
/* 7 */,
/* 8 */,
/* 9 */,
/* 10 */,
/* 11 */,
/* 12 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AlertResult; });
/* harmony export (immutable) */ __webpack_exports__["h"] = debug;
/* harmony export (immutable) */ __webpack_exports__["v"] = isNonEmptyObject;
/* harmony export (immutable) */ __webpack_exports__["u"] = isNonEmptyArray;
/* harmony export (immutable) */ __webpack_exports__["k"] = forAllItems;
/* unused harmony export getAllItemsInSections */
/* harmony export (immutable) */ __webpack_exports__["l"] = getAllItemsInFolder;
/* harmony export (immutable) */ __webpack_exports__["q"] = getSectionsInFolder;
/* harmony export (immutable) */ __webpack_exports__["x"] = itemsKeyForImageType;
/* harmony export (immutable) */ __webpack_exports__["g"] = categoryKeyForImageType;
/* harmony export (immutable) */ __webpack_exports__["m"] = getEntityDescriptors;
/* harmony export (immutable) */ __webpack_exports__["M"] = typeKeyForEntity;
/* harmony export (immutable) */ __webpack_exports__["i"] = enclosingTypeForEntity;
/* harmony export (immutable) */ __webpack_exports__["A"] = missingFontFamiliesForTypeStyles;
/* harmony export (immutable) */ __webpack_exports__["D"] = populateTypeStyleFontFamilyIDs;
/* harmony export (immutable) */ __webpack_exports__["E"] = populateTypeStyleTextColorIDs;
/* harmony export (immutable) */ __webpack_exports__["B"] = normalizeStyleData;
/* harmony export (immutable) */ __webpack_exports__["n"] = getGlobalAssetsObject;
/* harmony export (immutable) */ __webpack_exports__["H"] = promiseTracker;
/* harmony export (immutable) */ __webpack_exports__["G"] = promiseToRunOnQueue;
/* harmony export (immutable) */ __webpack_exports__["F"] = promiseTimeout;
/* harmony export (immutable) */ __webpack_exports__["s"] = imageItemFromLayer;
/* harmony export (immutable) */ __webpack_exports__["o"] = getImageHashKey;
/* harmony export (immutable) */ __webpack_exports__["b"] = addImageHash;
/* harmony export (immutable) */ __webpack_exports__["C"] = populateAllImageHashes;
/* harmony export (immutable) */ __webpack_exports__["L"] = styleFromFVD;
/* harmony export (immutable) */ __webpack_exports__["f"] = base64Encode;
/* unused harmony export allColors */
/* harmony export (immutable) */ __webpack_exports__["z"] = missingColorsInTypeStyles;
/* harmony export (immutable) */ __webpack_exports__["c"] = anonymousColorPalette;
/* harmony export (immutable) */ __webpack_exports__["I"] = randomID;
/* harmony export (immutable) */ __webpack_exports__["j"] = findAlternativeFormat;
/* unused harmony export imageFromURL */
/* harmony export (immutable) */ __webpack_exports__["d"] = backgroundColorIDWithBestContrastForImageURL;
/* harmony export (immutable) */ __webpack_exports__["e"] = backgroundColorWithBetterContrastForTextColor;
/* harmony export (immutable) */ __webpack_exports__["r"] = hasDuplicateElements;
/* harmony export (immutable) */ __webpack_exports__["y"] = mainFormatFromImageType;
/* harmony export (immutable) */ __webpack_exports__["p"] = getItemStringBasedOnData;
/* harmony export (immutable) */ __webpack_exports__["K"] = signedURLFromSignedData;
/* harmony export (immutable) */ __webpack_exports__["J"] = signedDataFromFileName;
/* harmony export (immutable) */ __webpack_exports__["t"] = isAlphanumericSort;
/* harmony export (immutable) */ __webpack_exports__["w"] = isV7;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_tinycolor2__ = __webpack_require__(110);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_tinycolor2___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_tinycolor2__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_sha1__ = __webpack_require__(111);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_sha1___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_sha1__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_design_systems_lib__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_design_systems_lib___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_design_systems_lib__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__sketch__ = __webpack_require__(18);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__shared_constants__ = __webpack_require__(41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__shared_constants___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5__shared_constants__);
var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };








var AlertResult = {
  OK: 1000,
  Cancel: 1001
};

function debug(msg) {

  if (msg instanceof Error) {

    // we are doing this because of JSON.stringify doesnt play nicely for error types as explained here:
    // https://stackoverflow.com/questions/18391212/is-it-not-possible-to-stringify-an-error-using-json-stringify
    var msgObject = {};
    __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.forEach(Object.getOwnPropertyNames(msg), function (errorKey) {
      msgObject[errorKey] = msg[errorKey];
    });
    msg = msgObject;
  }
  __WEBPACK_IMPORTED_MODULE_4__sketch__["g" /* postNativeUIEvent */]('onDebug', msg);
}

function isNonEmptyObject(obj) {
  return obj && Object.keys(obj).length;
}

function isNonEmptyArray(ary) {
  return ary && ary.length;
}

function forAllItems(styleguide, func) {
  __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.each(styleguide.logos, function (logo) {
    return func(logo);
  });
  __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.each(styleguide.typeStyles, function (style) {
    return func(style);
  });
  __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.each(styleguide.sharedStyles, function (style) {
    return func(style);
  });
  forAllImageItems(styleguide, func);
}

function forAllImageItems(styleguide, func) {
  var _loop = function _loop() {
    //filtering them out for now as user of this method did not planned on sketchSymbols to be present
    if (imageType === 'sketchSymbols') {
      return {
        v: void 0
      };
    }
    var category = __WEBPACK_IMPORTED_MODULE_5__shared_constants___default.a.IMAGE_CATS[imageType];
    if (styleguide[category.categoryKey]) {
      styleguide[category.categoryKey].forEach(function (section) {
        section[category.itemsKey].forEach(function (image) {
          func(image);
        });
      });
    }
  };

  for (var imageType in __WEBPACK_IMPORTED_MODULE_5__shared_constants___default.a.IMAGE_CATS) {
    var _ret = _loop();

    if ((typeof _ret === 'undefined' ? 'undefined' : _typeof(_ret)) === "object") return _ret.v;
  }
}

function getAllItemsInSections(sections, itemKey) {
  return __WEBPACK_IMPORTED_MODULE_3_design_systems_lib__["utils"].getItemsFromSections(sections, itemKey);
}

function getAllItemsInFolder(styleguide, entityType, folderId) {
  return __WEBPACK_IMPORTED_MODULE_3_design_systems_lib__["utils"].getItemsFromFolder(styleguide, entityType, folderId);
}

function getSectionsInFolder(styleguide, entityType, folderId) {
  return __WEBPACK_IMPORTED_MODULE_3_design_systems_lib__["utils"].getSectionsFromFolder(styleguide, entityType, folderId);
}

function itemsKeyForImageType(imageType) {
  return __WEBPACK_IMPORTED_MODULE_5__shared_constants___default.a.IMAGE_CATS[imageType].itemsKey;
}

function categoryKeyForImageType(imageType) {
  return __WEBPACK_IMPORTED_MODULE_5__shared_constants___default.a.IMAGE_CATS[imageType].categoryKey;
}

function getEntityDescriptors() {
  return __WEBPACK_IMPORTED_MODULE_3_design_systems_lib__["utils"].entityDescriptors.entityTypes;
}

function typeKeyForEntity(entityKey) {
  var entityDescriptors = getEntityDescriptors();
  return entityDescriptors[entityKey].typeKey;
}

function enclosingTypeForEntity(entityKey) {
  var entityDescriptors = getEntityDescriptors();
  return entityDescriptors[entityKey].enclosingType;
}

function missingFontFamiliesForTypeStyles(typeStyles, styleData) {
  var missingFonts = [];
  __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.each(typeStyles, function (style) {
    var existingFamily = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.find(styleData.globalAssets.fonts, {
      family: style.fontFamily
    });
    if (!existingFamily) {
      missingFonts = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.union(missingFonts, [style.fontFamily]);
    }
  });

  return missingFonts;
}

function populateTypeStyleFontFamilyIDs(typeStyles, styleData) {
  __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.each(typeStyles, function (style) {
    var existingFamily = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.find(styleData.globalAssets.fonts, {
      family: style.fontFamily
    });
    if (!existingFamily) {
      throw new Error('No font family "' + style.fontFamily + '" in design library.');
    } else {
      style.fontFamily = existingFamily._id;
    }
  });
}

function populateTypeStyleTextColorIDs(typeStyles, styleData) {
  var colors = allColors(styleData);

  __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.each(typeStyles, function (typeStyle) {

    var matchingColor = colors.find(function (color) {
      return __WEBPACK_IMPORTED_MODULE_1_tinycolor2___default()(color.value).toRgbString() == __WEBPACK_IMPORTED_MODULE_1_tinycolor2___default()(typeStyle.textColor).toRgbString();
    });

    typeStyle.textColor = matchingColor ? matchingColor._id : null;
  });
}

//todo: think of getting rid of this step at all
function normalizeStyleData(styleData) {
  var styleguides = styleData.parentStyleguides.concat(styleData.styleguide);
  styleguides.forEach(function (styleguide) {
    forAllItems(styleguide, function (item) {
      if (item.backgroundColor) {
        item.backgroundColorID = item.backgroundColor;
        item.backgroundColor = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.get(item, 'backgroundColorObject.value');
      }

      if (item.textColor) {
        item.textColorID = item.textColor;
        item.textColor = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.get(item, 'textColorObject.value');
      }

      if (item.fontFamily) {
        item.fontFamilyID = item.fontFamily;
        item.fontFamily = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.get(item, 'fontFamilyObject.family');
      }
    });
  });
}

function getGlobalAssetsObject(styleData) {
  var styleguides = styleData.parentStyleguides.concat(styleData.styleguide);
  var ImageConstants = __WEBPACK_IMPORTED_MODULE_5__shared_constants___default.a.IMAGE_CATS;
  var globalAssets = { colors: styleData.globalAssets.colors, fonts: styleData.globalAssets.fonts };
  globalAssets.icons = __WEBPACK_IMPORTED_MODULE_3_design_systems_lib__["utils"].createGlobalAssetsListForSections(styleguides, ImageConstants.icons.categoryKey, ImageConstants.icons.itemsKey);
  globalAssets.components = __WEBPACK_IMPORTED_MODULE_3_design_systems_lib__["utils"].createGlobalAssetsListForSections(styleguides, ImageConstants.components.categoryKey, ImageConstants.components.itemsKey);
  globalAssets.typeStyles = __WEBPACK_IMPORTED_MODULE_3_design_systems_lib__["utils"].createGlobalAssetsListForType(styleguides, 'typeStyles');
  globalAssets.sharedStyles = __WEBPACK_IMPORTED_MODULE_3_design_systems_lib__["utils"].createGlobalAssetsListForType(styleguides, 'sharedStyles');
  globalAssets.sketchSymbols = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.uniqBy(__WEBPACK_IMPORTED_MODULE_3_design_systems_lib__["utils"].createGlobalAssetsListForType(styleguides, 'sketchSymbols'), function (value) {
    return value.metadata.sketchSymbolId;
  });

  return globalAssets;
}

// Create a promise wrapper that calls back immediately and when the promise
// resolves.
function promiseTracker(_ref) {
  var onCreate = _ref.onCreate,
      onResolve = _ref.onResolve;

  return function (promise) {
    if (onCreate) {
      onCreate();
    }

    return promise.then(function (value) {
      if (onResolve) {
        onResolve();
      }

      return value;
    });
  };
}

// queue is the queue to use, func is something that returns a promise or value.
function promiseToRunOnQueue(queue, func) {
  return new Promise(function (resolve, reject) {
    queue.defer(function (complete) {
      // Calling func returns the result of the task. It is either a promise or
      // a value.
      var promiseOrValue = func();

      // Treat it as a promise either way.
      var promise = Promise.resolve(promiseOrValue);

      // When that promise completes, resolve or reject the wrapper promise and
      // notify the queue the task is complete.
      promise.then(function (value) {
        resolve(value);
        complete(null, value);
      }).catch(function (err) {
        reject(err);
        complete(err);
      });
    });
  });
}

function promiseTimeout(time, message, promise) {
  var timeout = new Promise(function (resolve) {
    return setTimeout(resolve, time);
  }).then(function () {
    return Promise.reject(new Error(message));
  });

  return Promise.race([promise, timeout]);
}

function imageItemFromLayer(layer, primaryExtension, librarySharedStylesMap, libraryTypeStylesMap) {
  primaryExtension = primaryExtension || 'svg';
  var primaryUploadedItem = layer.uploadedItems.find(function (uploadedItem) {
    return uploadedItem.format === primaryExtension && uploadedItem.exportOptionsKey === 'formatsToUpload';
  } // Not a thumbnail/preview image.
  );

  // Map the upload data structure here to the API model
  // `ImageFile` schema.
  var imageFileFromUploadedData = function imageFileFromUploadedData(uploadedItem) {
    return {
      assetKey: uploadedItem.assetKey,
      extension: uploadedItem.format,
      size: uploadedItem.byteLength,
      width: uploadedItem.width,
      height: uploadedItem.height
    };
  };

  // Add all the basic native sized format, excluding the
  // primary one as `additionalFormats`.
  var additionalFormats = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.chain(layer.uploadedItems).filter(function (uploadedItem) {
    return uploadedItem.exportOptionsKey === 'formatsToUpload' && uploadedItem !== primaryUploadedItem;
  }).map(imageFileFromUploadedData).value();

  // Add all the preview or thumbnail images to as
  // `previewImages`.
  var previewImages = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.chain(layer.uploadedItems).filter(function (uploadedItem) {
    return uploadedItem.exportOptionsKey === 'previewsToUpload';
  }).map(imageFileFromUploadedData).value();

  var sharedObjectsV2 = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.compact(__WEBPACK_IMPORTED_MODULE_0_lodash___default.a.map(layer.sharedObjects || [], function (sharedObject) {
    if (sharedObject.type === 'text') {
      return libraryTypeStylesMap[sharedObject.id];
    }
    if (sharedObject.type === 'layerStyle') {
      return librarySharedStylesMap[sharedObject.id];
    }
  }));

  var directNestedSymbolIDs = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.uniq(layer.directNestedSymbolIDs);

  return {
    name: layer.name,
    fileName: layer.name + '.' + primaryExtension,
    assetKey: primaryUploadedItem.assetKey,
    extension: primaryExtension,
    size: primaryUploadedItem.byteLength,
    dimensions: primaryUploadedItem.width + 'X' + primaryUploadedItem.height,
    backgroundColor: layer.backgroundColorID || undefined,
    metadata: {
      sketchSymbolId: layer.symbolID,
      hash: layer.hash,
      sharedObjectsV2: sharedObjectsV2.length > 0 ? sharedObjectsV2 : undefined,
      directNestedSymbolIds: directNestedSymbolIDs.length > 0 ? directNestedSymbolIDs : undefined
    },
    additionalFormats: additionalFormats,
    previewImages: previewImages
  };
}

function getImageHashKey(symbolID, imageID) {
  return symbolID + '-' + imageID;
}

function addImageHash(hashesMap, image, dataURI) {
  if (hashesMap) {
    var symbolId = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.get(image, 'metadata.sketchSymbolId');
    var imageId = image._id;
    // we use the symbol and imageId as the hash key so validate we have both
    if (symbolId && imageId) {
      var key = getImageHashKey(symbolId, imageId);
      // if we have persisted hash use it, otherwise generate new one
      hashesMap[key] = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.get(image, 'metadata.hash');
      //meaning we don't have the hash for this object and we have the data upon which we can calculate the key, perform the calculation
      if (!hashesMap[key] && dataURI) {
        hashesMap[key] = __WEBPACK_IMPORTED_MODULE_2_sha1___default()(dataURI);
      }
    }
  }
}

function populateAllImageHashes(styleData, hashesMap) {

  __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.forEach(styleData.globalAssets.sketchSymbols, function (symbol) {
    //we set image hash here to optimize for the initial state where we dont have any persisted hashes and everything will be considered new
    // it is redundant for the uploaded layere and after some time we can consider to remove this
    addImageHash(hashesMap, symbol);
  });

  //create a list of all styleguides
  var styleguides = [styleData.styleguide].concat(styleData.parentStyleguides);
  styleguides.forEach(function (styleguide) {
    forAllImageItems(styleguide, function (item) {
      addImageHash(hashesMap, item);
    });
  });
}

function styleFromFVD(fvd) {
  var result = {};

  if (!fvd) {
    return result;
  }

  var parts = fvd.split('');
  var style = parts[0];
  var weight = parts[1];

  // fontStyle
  if (style === 'i') {
    result.fontStyle = 'italic';
  }

  // fontWeight
  var number = parseInt(weight, 10);
  if (number) {
    weight = weight * 100;

    if (weight === 700) {
      result.fontWeight = 'bold';
    } else if (weight != 400) {
      result.fontWeight = weight;
    }
  }

  return result;
}

// This works with unicode characters.
function base64Encode(str) {
  return btoa(encodeURIComponent(str).replace(/%([0-9A-F]{2})/g, function (match, p1) {
    return String.fromCharCode('0x' + p1);
  }));
}

function allColors(styleData) {
  return __WEBPACK_IMPORTED_MODULE_0_lodash___default()(__WEBPACK_IMPORTED_MODULE_3_design_systems_lib__["utils"].defaultColors.colors).concat(styleData.globalAssets.colors);
}

function missingColorsInTypeStyles(typeStyles, styleData) {
  var colorStrs = allColors(styleData).map(function (color) {
    return __WEBPACK_IMPORTED_MODULE_1_tinycolor2___default()(color.value).toRgbString();
  });

  var missingColors = __WEBPACK_IMPORTED_MODULE_0_lodash___default()(typeStyles)
  // Common format for matching strings.
  .map(function (typeStyle) {
    return __WEBPACK_IMPORTED_MODULE_1_tinycolor2___default()(typeStyle.textColor).toRgbString();
  }).filter(function (colorStr) {
    return !colorStrs.includes(colorStr);
  }).uniq().map(function (colorStr) {
    return { value: colorStr };
  }).value();

  return missingColors;
}

function anonymousColorPalette(styleData) {
  return __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.find(styleData.styleguide.colorSections, { anonymousColorSection: true });
}

function randomID() {
  return Math.random().toString(36).substr(2, 10);
}

function findAlternativeFormat(imageType, requestedFromat) {

  if (!imageType || !imageType.additionalFormats) {
    return null;
  }

  return __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.find(imageType.additionalFormats, { extension: requestedFromat });
}

function imageFromURL(url) {
  return new Promise(function (resolve, reject) {
    var img = document.createElement('img');
    img.onerror = function (err) {
      return reject(err.message);
    };
    img.onload = function () {
      return resolve(img);
    };
    img.src = url;
  });
}

function imageIsLight(img) {
  var width = 10;
  var height = 10;
  var brightnessThreshold = 240; // Out of 255.

  var canvas = document.createElement('canvas');
  canvas.width = width;
  canvas.height = height;
  var ctx = canvas.getContext('2d');

  // Draw image on white background.
  ctx.fillStyle = 'white';
  ctx.fillRect(0, 0, width, height);
  ctx.drawImage(img, 0, 0, width, height);

  // Get image pixel data.
  var imageData = ctx.getImageData(0, 0, width, height);
  var data = imageData.data;

  var r, g, b;
  for (var i = 0; i < data.length; i += 4) {
    r = data[i];
    g = data[i + 1];
    b = data[i + 2];
    // Stop as soon as any pixel is too dark.
    if (brightnessThreshold > __WEBPACK_IMPORTED_MODULE_1_tinycolor2___default()({ r: r, g: g, b: b }).getBrightness()) {
      return false;
    }
  }

  return true;
}

function okayToOverrideBackgroundColorID(backgroundColorID) {
  if (!backgroundColorID) {
    return true;
  } else if (backgroundColorID == 'white' || backgroundColorID == 'gray') {
    return true;
  }
  return false;
}

function backgroundColorIDWithBestContrastForImageURL(newImageURL, currentBackgroundColorID) {
  if (newImageURL && okayToOverrideBackgroundColorID(currentBackgroundColorID)) {
    return imageFromURL(newImageURL).then(function (img) {
      return imageIsLight(img) ? 'gray' : null;
    });
  } else {
    return Promise.resolve(currentBackgroundColorID);
  }
}

function backgroundColorWithBetterContrastForTextColor(textColorString, currentBackgroundColorString) {
  var backgroundColor = __WEBPACK_IMPORTED_MODULE_1_tinycolor2___default()(currentBackgroundColorString);
  var backgroundColorBrightness = backgroundColor.getBrightness();

  // Only adjust background color if it is white.
  if (backgroundColorBrightness > 245) {
    var textColorBrightness = __WEBPACK_IMPORTED_MODULE_1_tinycolor2___default()(textColorString).getBrightness();
    if (backgroundColorBrightness - textColorBrightness < 16) {
      backgroundColor.darken(20);
    }
  }

  return backgroundColor.toHexString();
}

function hasDuplicateElements(list, fieldName) {
  var map = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.groupBy(list, fieldName);
  var duplicatesFound = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.some(map, function (value, key) {
    return value.length > 1;
  });
  return duplicatesFound;
}

function mainFormatFromImageType(type) {
  return __WEBPACK_IMPORTED_MODULE_5__shared_constants___default.a.IMAGE_CATS[type].preferPNGFormat ? 'png' : 'svg';
}

//This is intended to extract the correct form of plural vs singular for entity type related message
//For example: "Error removing color" or "Error removing colors" instead of color(s)
function getItemStringBasedOnData(key, items) {

  var entities = __WEBPACK_IMPORTED_MODULE_3_design_systems_lib__["utils"].entityDescriptors.entityTypesArray();
  var typeKeyMap = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.keyBy(entities, 'typeKey');

  var entity = typeKeyMap[key];
  if (!entity) {
    return 'section';
  }

  var string = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.toLower(entity.shortTitle);
  if (items && items.length == 1) {
    string = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.trimEnd(string, 's');
  }

  return string;
}

function signedURLFromSignedData(signedData) {
  if (!signedData) {
    return {};
  }
  return { fileURL: signedData.signedUrl.split('?')[0], signedFileURL: signedData.signedUrl };
}

function signedDataFromFileName(signedFiles, fileName) {
  return __WEBPACK_IMPORTED_MODULE_0_lodash___default()(signedFiles).find({ fileName: fileName });
}

function isAlphanumericSort(sortMode) {
  return __WEBPACK_IMPORTED_MODULE_3_design_systems_lib__["utils"].isAlphanumeric(sortMode);
}

function isV7(invisionMode) {
  return __WEBPACK_IMPORTED_MODULE_3_design_systems_lib__["utils"].isV7(invisionMode);
}

/***/ }),
/* 13 */,
/* 14 */,
/* 15 */,
/* 16 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (immutable) */ __webpack_exports__["openApplicationMenu"] = openApplicationMenu;
/* harmony export (immutable) */ __webpack_exports__["showProgressSheet"] = showProgressSheet;
/* harmony export (immutable) */ __webpack_exports__["hideProgressSheet"] = hideProgressSheet;
/* harmony export (immutable) */ __webpack_exports__["incrementProgress"] = incrementProgress;
/* harmony export (immutable) */ __webpack_exports__["typeStylesLoaded"] = typeStylesLoaded;
/* harmony export (immutable) */ __webpack_exports__["styleguideSectionChanged"] = styleguideSectionChanged;
/* harmony export (immutable) */ __webpack_exports__["persistImageData"] = persistImageData;
/* harmony export (immutable) */ __webpack_exports__["openURLInBrowser"] = openURLInBrowser;
/* harmony export (immutable) */ __webpack_exports__["installPluginUpdate"] = installPluginUpdate;
/* harmony export (immutable) */ __webpack_exports__["updateDocument"] = updateDocument;
/* harmony export (immutable) */ __webpack_exports__["imageDragEnd"] = imageDragEnd;
/* harmony export (immutable) */ __webpack_exports__["imageDragStart"] = imageDragStart;
/* harmony export (immutable) */ __webpack_exports__["chooseColor"] = chooseColor;
/* harmony export (immutable) */ __webpack_exports__["chooseSharedStyle"] = chooseSharedStyle;
/* harmony export (immutable) */ __webpack_exports__["chooseTypography"] = chooseTypography;
/* harmony export (immutable) */ __webpack_exports__["typeStyleDragEnd"] = typeStyleDragEnd;
/* harmony export (immutable) */ __webpack_exports__["restartSketch"] = restartSketch;
/* harmony export (immutable) */ __webpack_exports__["resizeMainWindnow"] = resizeMainWindnow;
/* harmony export (immutable) */ __webpack_exports__["addTypeStyles"] = addTypeStyles;
/* harmony export (immutable) */ __webpack_exports__["onOpenDeleteTypeStylesApp"] = onOpenDeleteTypeStylesApp;
/* harmony export (immutable) */ __webpack_exports__["addSharedStyles"] = addSharedStyles;
/* harmony export (immutable) */ __webpack_exports__["onOpenDeleteSharedStylesApp"] = onOpenDeleteSharedStylesApp;
/* harmony export (immutable) */ __webpack_exports__["addColors"] = addColors;
/* harmony export (immutable) */ __webpack_exports__["uploadLayers"] = uploadLayers;
/* harmony export (immutable) */ __webpack_exports__["onImageFallbackDataReceived"] = onImageFallbackDataReceived;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__sketch__ = __webpack_require__(18);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__util__ = __webpack_require__(12);





function openApplicationMenu(applicationData) {
  Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */])('onApplicationContextMenu', applicationData);
}

function showProgressSheet(options) {
  Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */])('onShowProgresSheet', options);
}

function hideProgressSheet() {
  Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */])('onHideProgressSheet');
}

function incrementProgress(incrementBy) {
  Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */])('onIncrementProgress', incrementBy);
}

function typeStylesLoaded(typeStyles) {
  Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */])('onTypeStylesDidLoad', typeStyles);
}

function styleguideSectionChanged(newSectionData) {
  Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */])('onStyleguideSectionChanged', newSectionData);
}

function persistImageData(imageData) {
  Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */])('onImageFallbackDataReceived', imageData);
}

function openURLInBrowser(url) {
  Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */])('onOpenURLInBrowser', url);
}

function installPluginUpdate() {
  Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */])('onInstallUpdate');
}

function updateDocument() {
  Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */])('onUpdateDocument');
}

function imageDragEnd(item, evt) {

  //if we want to insert an image and there is also skla native format for the primary format then use it instead
  var sklaFormat = __WEBPACK_IMPORTED_MODULE_1__util__["j" /* findAlternativeFormat */](item, 'skla') || {};

  Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */])('onPossibleImageDrop', {
    draggedImgSrcUrl: evt.target.src,
    extension: item.extension,
    name: item.name,
    id: item._id,
    metadata: item.metadata,
    pageName: item.pageName,
    sklaExtension: sklaFormat.extension,
    sklaUrl: sklaFormat.url,
    sklaAssetKey: sklaFormat.assetKey
  });
}

function imageDragStart(prefetchingStyleData, evt) {
  if (prefetchingStyleData) {
    Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["b" /* displayAlert */])({
      title: 'Can’t add to document while library is being updated.',
      description: 'Your library is getting updated with the most\nup-to-date items.  You can add components to the document when the update is done.',
      buttons: ['OK']
    });
    evt.preventDefault();
  }
}

function chooseColor(color, event) {
  if (event.button === 0) {
    Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */])('onChooseColor', {
      color: color,
      preferBorders: !!event.shiftKey
    });
  }
}

function chooseSharedStyle(prefetchingStyleData, sharedStyle, event) {
  if (event.button === 0) {
    if (prefetchingStyleData) {
      Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["b" /* displayAlert */])({
        title: 'Can\'t apply style to layer while library is being updated',
        description: 'Your library is getting updated with the most\nup-to-date items. You can apply styles to the document when the update is done.',
        buttons: ['OK']
      });
    } else {
      Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */])('onChooseSharedStyle', sharedStyle);
    }
  }
}

function chooseTypography(typeStyle, event) {
  if (event.button === 0) {
    Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */])('onChooseTypeStyle', {
      typeStyle: typeStyle
    });
  }
}

function typeStyleDragEnd(typeStyle) {
  Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */])('onPossibleTypeStyleDrop', typeStyle);
}

function restartSketch() {
  Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */])('onRestartSketch');
}

function resizeMainWindnow(dimensions) {
  Object(__WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */])('onChangeMainWindowSize', dimensions);
}

function addTypeStyles(folderId) {
  __WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */]('onAddTypeStyles', { folderId: folderId });
}

function onOpenDeleteTypeStylesApp() {
  __WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */]('openDeleteTypeStylesApp');
}

function addSharedStyles(folderId) {
  __WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */]('onAddSharedStyles', { folderId: folderId });
}

function onOpenDeleteSharedStylesApp() {
  __WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */]('openDeleteSharedStylesApp');
}

function addColors(paletteID, folderId) {
  __WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */]('onAddColors', { paletteID: paletteID, folderId: folderId });
}

// Upload layers - stage #1
function uploadLayers(imageType, sectionID, folderId) {
  __WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */]('onUploadLayers', { imageType: imageType, sectionID: sectionID, folderId: folderId });
}

function onImageFallbackDataReceived(dataURL, image) {
  //todo: should work for skla, and all formats in general
  __WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */]('onImageFallbackDataReceived', {
    url: image.url,
    extension: image.extension,
    dataURL: dataURL
  });
}

/***/ }),
/* 17 */,
/* 18 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["h"] = sendDataToNativeHost;
/* harmony export (immutable) */ __webpack_exports__["a"] = debug;
/* harmony export (immutable) */ __webpack_exports__["g"] = postNativeUIEvent;
/* unused harmony export callNativeUIFunction */
/* harmony export (immutable) */ __webpack_exports__["i"] = setStyleData;
/* harmony export (immutable) */ __webpack_exports__["j"] = setUserData;
/* harmony export (immutable) */ __webpack_exports__["e"] = getSharedStyleArchiveData;
/* harmony export (immutable) */ __webpack_exports__["f"] = getSharedStylePreviewImageData;
/* harmony export (immutable) */ __webpack_exports__["c"] = getCachedImageData;
/* harmony export (immutable) */ __webpack_exports__["d"] = getCraftManagerToken;
/* harmony export (immutable) */ __webpack_exports__["b"] = displayAlert;
/*eslint no-console: ["error", { allow: ["log"] }]*/

function sendDataToNativeHost(data) {
  console.log('WEB->NATIVE', data);
  window.status = JSON.stringify(data);
}

function debug(message) {
  sendDataToNativeHost({
    eventType: 'debug',
    message: message
  });
}

function postNativeUIEvent(eventName, payload) {
  window.status = JSON.stringify({ eventName: eventName, payload: payload });
}

function callNativeUIFunction(functionName, args, callback) {
  var callbackID = Math.random().toString(36).substr(2, 10);
  window.dsm['callback-' + callbackID] = callback;
  postNativeUIEvent('onCallFunction', { functionName: functionName, callbackID: callbackID, args: args });
}

function setStyleData(styleData) {
  return new Promise(function (resolve) {
    callNativeUIFunction('setStyleData', styleData, function () {
      resolve();
    });
  });
}

function setUserData(idToken, refreshToken, domainInfo) {
  return new Promise(function (resolve) {
    callNativeUIFunction('setUserData', { idToken: idToken, refreshToken: refreshToken, domainInfo: domainInfo }, function () {
      resolve();
    });
  });
}

function getSharedStyleArchiveData(sharedStyleID) {
  return new Promise(function (resolve) {
    callNativeUIFunction('getSharedStyleArchiveData', sharedStyleID, function (data) {
      resolve(data);
    });
  });
}

function getSharedStylePreviewImageData(sharedStyleID) {
  return new Promise(function (resolve) {
    callNativeUIFunction('getSharedStylePreviewImageData', sharedStyleID, function (data) {
      resolve(data);
    });
  });
}

function getCachedImageData(payload) {
  return new Promise(function (resolve, reject) {
    callNativeUIFunction('getCachedImageData', payload, function (dataURI) {
      if (!dataURI) {
        reject();
      }
      resolve(dataURI);
    });
  });
}

function getCraftManagerToken() {
  return new Promise(function (resolve) {
    callNativeUIFunction('getCraftManagerToken', null, function (refreshToken) {
      resolve(refreshToken);
    });
  });
}

function displayAlert(options, callback) {
  callNativeUIFunction('displayAlert', options, callback);
}

/***/ }),
/* 19 */,
/* 20 */,
/* 21 */,
/* 22 */,
/* 23 */,
/* 24 */,
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

var Dispatcher = __webpack_require__(169),
    Flux = __webpack_require__(432),
    FluxMixin = __webpack_require__(434),
    FluxChildMixin = __webpack_require__(435),
    StoreWatchMixin = __webpack_require__(436),
    createStore = __webpack_require__(437);

var Fluxxor = {
  Dispatcher: Dispatcher,
  Flux: Flux,
  FluxMixin: FluxMixin,
  FluxChildMixin: FluxChildMixin,
  StoreWatchMixin: StoreWatchMixin,
  createStore: createStore,
  version: __webpack_require__(439)
};

module.exports = Fluxxor;

/***/ }),
/* 26 */,
/* 27 */,
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

var _ = __webpack_require__(3);

var actionClasses = [__webpack_require__(965).default, __webpack_require__(972).default, __webpack_require__(973).default, __webpack_require__(974).default, __webpack_require__(976).default, __webpack_require__(977).default, __webpack_require__(978).default, __webpack_require__(979).default, __webpack_require__(980).default, __webpack_require__(982).default];

var actions = _.map(actionClasses, 'actions');
var constants = _.map(actionClasses, 'constants');

actions = _.merge.apply(_, actions);
constants = _.merge.apply(_, constants);

module.exports = { actions: actions, constants: constants };

/***/ }),
/* 29 */,
/* 30 */,
/* 31 */,
/* 32 */,
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (prefixedValue, value, keepUnprefixed) {
  return keepUnprefixed ? [prefixedValue, value] : prefixedValue;
};

module.exports = exports["default"];

/***/ }),
/* 34 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Icon; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_classnames__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_classnames__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_react_svg_inline__ = __webpack_require__(194);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_react_svg_inline___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_react_svg_inline__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__brandai_design_systems_web_src_icons_icon_sprite__ = __webpack_require__(195);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__brandai_design_systems_web_src_icons_icon_sprite___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4__brandai_design_systems_web_src_icons_icon_sprite__);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }








// In the long run we don't want to take it from web but have here a local copy
// (These icons should be in use by Sketch only anyway and not needed in web)


var Icon = (_temp = _class = function (_Component) {
  _inherits(Icon, _Component);

  function Icon(props) {
    _classCallCheck(this, Icon);

    var _this = _possibleConstructorReturn(this, (Icon.__proto__ || Object.getPrototypeOf(Icon)).call(this, props));

    _this.state = {};
    _this.handleClick = _this.handleClick.bind(_this);
    return _this;
  }

  _createClass(Icon, [{
    key: 'handleClick',
    value: function handleClick(e) {
      if (this.props.onClick) {
        this.props.onClick(e);
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var glyphName = 'icon-' + this.props.glyph;

      if (!this.props.glyph || !__WEBPACK_IMPORTED_MODULE_4__brandai_design_systems_web_src_icons_icon_sprite___default.a[glyphName]) {
        return null;
      }

      var className = __WEBPACK_IMPORTED_MODULE_2_classnames___default()('c-icon', 'c-icon--' + this.props.color, this.props.className);

      // https://github.com/MoOx/react-svg-inline
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        {
          className: className,
          style: { height: this.props.size },
          onClick: this.handleClick },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3_react_svg_inline___default.a, {
          className: 'c-icon__inline',
          width: this.props.size + 'px',
          height: this.props.size + 'px',
          svg: __WEBPACK_IMPORTED_MODULE_4__brandai_design_systems_web_src_icons_icon_sprite___default.a[glyphName],
          cleanup: ['title']
        })
      );
    }
  }]);

  return Icon;
}(__WEBPACK_IMPORTED_MODULE_0_react__["Component"]), _class.propTypes = {
  glyph: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string.isRequired,
  /**
   * icon is always a square
   * */
  size: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.number,

  onClick: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,

  /**
   * set svg fill color to the color the parent
   * */
  color: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf(['white', 'black', 'gray', 'pink', 'red']),

  //allow to add custom styling on the icon
  className: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string
}, _class.defaultProps = {
  size: 24,
  color: 'gray'
}, _temp);


/***/ }),
/* 35 */,
/* 36 */,
/* 37 */,
/* 38 */,
/* 39 */,
/* 40 */,
/* 41 */
/***/ (function(module, exports) {

module.exports = {
  IMAGE_CATS: {
    icons: {
      categoryKey: 'iconSections',
      itemsKey: 'icons',
      displayNamePlural: 'Icons',
      preferPNGFormat: false,
      previewsToUpload: [],
      formatsToUpload: [{
        format: 'png'
      }, {
        format: 'skla'
      }, {
        format: 'svg'
      }]
    },
    components: {
      categoryKey: 'componentImageSections',
      itemsKey: 'components',
      displayNamePlural: 'Components',
      preferPNGFormat: true,
      formatsToUpload: [{
        format: 'png'
      }, {
        format: 'skla'
      }],
      previewsToUpload: [{
        fileNameSuffix: '-thumb-300',
        format: 'png',
        maxLongEdge: 300
      }]
    },
    sketchSymbols: {
      formatsToUpload: [{
        format: 'png'
      }, {
        format: 'skla'
      }],
      previewsToUpload: [{
        fileNameSuffix: '-thumb-300',
        format: 'png',
        maxLongEdge: 300
      }]
    }
  },
  TYPES_TO_SYNC: {
    colors: { key: 'colors', label: 'Colors', description: 'Added to “Document Colors”' },
    typeStyles: { key: 'typeStyles', label: 'Text Styles' },
    sharedStyles: { key: 'sharedStyles', label: 'Layer Styles' },
    symbols: { key: 'symbols', label: 'Symbols' }
  },
  INDEX: {
    fontPSName: 0,
    fontFaceName: 1,
    fontWeight: 2,
    fontTraits: 3
  },
  gridSize: {
    md: 120,
    sm: 90,
    xs: 60
  },
  editingSources: {
    styleguidePage: 'styleguidePage',
    styleguideTree: 'styleguideTree'
  },
  treeNodeTypes: {
    asset: 'asset',
    section: 'section',
    folder: 'folder'
  }
};

/***/ }),
/* 42 */,
/* 43 */,
/* 44 */,
/* 45 */,
/* 46 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return App; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__sketch__ = __webpack_require__(18);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__util__ = __webpack_require__(12);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






var App = function (_React$Component) {
  _inherits(App, _React$Component);

  function App(props) {
    _classCallCheck(this, App);

    var _this = _possibleConstructorReturn(this, (App.__proto__ || Object.getPrototypeOf(App)).call(this, props));

    _this.nativeHost = {};
    _this.pendingCallbacks = {};
    return _this;
  }

  _createClass(App, [{
    key: 'componentWillMount',
    value: function componentWillMount() {
      window.dsm = window.dsm || {};
      var app = this;

      this.props.nativeHandlers.forEach(function (func) {
        app.nativeHost[func] = function () {
          for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }

          var lastArg = args[args.length - 1];
          var asyncID;
          if (lastArg && typeof lastArg == 'function') {
            args.pop();
            asyncID = __WEBPACK_IMPORTED_MODULE_2__util__["I" /* randomID */]();
            app.pendingCallbacks[asyncID] = lastArg;
          }
          __WEBPACK_IMPORTED_MODULE_1__sketch__["h" /* sendDataToNativeHost */]({
            eventType: 'functionCall',
            name: func,
            id: asyncID,
            args: args
          });
        };
      });

      window.dsm.receiveDataFromNativeUI = function (data) {
        if (data.eventType == 'functionCall') {
          var handler = app[data.name];
          if (handler) {
            var result;
            try {
              result = handler.apply(app, data.args);
            } catch (err) {
              if (data.id) {
                __WEBPACK_IMPORTED_MODULE_1__sketch__["h" /* sendDataToNativeHost */]({
                  eventType: 'asyncError',
                  id: data.id,
                  reason: err.message
                });
              }
            }
            if (data.id) {
              __WEBPACK_IMPORTED_MODULE_1__sketch__["h" /* sendDataToNativeHost */]({
                eventType: 'asyncResult',
                id: data.id,
                value: result
              });
            }
          } else {
            Object(__WEBPACK_IMPORTED_MODULE_1__sketch__["a" /* debug */])('No app function "' + data.name + '".');
          }
        } else if (data.eventType == 'asyncResult') {
          app.pendingCallbacks[data.asyncID](null, data.value);
        } else if (data.eventType == 'asyncError') {
          app.pendingCallbacks[data.asyncID](data.reason);
        }
      };

      // Prevent default context menu unless holding option key (for development).
      window.oncontextmenu = function (evt) {
        if (!event.altKey) {
          evt.preventDefault();
        }
      };
    }

    // Wait until refs are available.

  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      __WEBPACK_IMPORTED_MODULE_1__sketch__["h" /* sendDataToNativeHost */]({
        eventType: 'initialize',
        functions: this.exportToNativeHost().map(function (f) {
          return f.name;
        })
      });
    }

    // Override this in your subclass.

  }, {
    key: 'exportToNativeHost',
    value: function exportToNativeHost() {
      return [];
    }
  }]);

  return App;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component);



/***/ }),
/* 47 */,
/* 48 */,
/* 49 */,
/* 50 */,
/* 51 */,
/* 52 */,
/* 53 */,
/* 54 */,
/* 55 */,
/* 56 */,
/* 57 */,
/* 58 */,
/* 59 */,
/* 60 */,
/* 61 */,
/* 62 */,
/* 63 */,
/* 64 */,
/* 65 */,
/* 66 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);


/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var type = _ref.type;

  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    "div",
    { className: "u-flex-center-viewport" },
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      "div",
      { className: "no-items-message" },
      "No search results found..."
    )
  );
});

/***/ }),
/* 67 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);


/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var type = _ref.type;

  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    "div",
    { className: "u-flex-center-viewport" },
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      "div",
      { className: "no-items-message" },
      "No ",
      type,
      "..."
    )
  );
});

/***/ }),
/* 68 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_design_systems_lib__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_design_systems_lib___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_design_systems_lib__);

var loggerService = new __WEBPACK_IMPORTED_MODULE_0_design_systems_lib__["clientServices"].loggingService(__WEBPACK_IMPORTED_MODULE_0_design_systems_lib__["sharedConstants"].clients.sketch, '0c7f02ea-2ae2-4a1f-a43c-bc28c47e0959', { environment: "prod", forceHttps: true });

/* harmony default export */ __webpack_exports__["a"] = (loggerService);

/***/ }),
/* 69 */,
/* 70 */,
/* 71 */,
/* 72 */,
/* 73 */,
/* 74 */,
/* 75 */,
/* 76 */,
/* 77 */,
/* 78 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__);
var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var FluxActionAwareComponent = function FluxActionAwareComponent(InnerComponent) {
  var _class, _temp;

  return _temp = _class = function (_Component) {
    _inherits(_class, _Component);

    function _class(props) {
      _classCallCheck(this, _class);

      var _this = _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).call(this, props));

      _this.state = {};
      _this.getFlux = _this.getFlux.bind(_this);
      _this.getActions = _this.getActions.bind(_this);
      return _this;
    }

    _createClass(_class, [{
      key: 'componentWillMount',
      value: function componentWillMount() {
        if (!this.props.flux && (!this.context || !this.context.flux)) {
          var namePart = this.constructor.displayName ? " of " + this.constructor.displayName : "";
          throw new Error("Could not find flux on this.props or this.context" + namePart);
        }
      }
    }, {
      key: 'getChildContext',
      value: function getChildContext() {
        return {
          flux: this.getFlux()
        };
      }
    }, {
      key: 'getFlux',
      value: function getFlux() {
        return this.props.flux || this.context && this.context.flux;
      }
    }, {
      key: 'getActions',
      value: function getActions() {
        var flux = this.getFlux();
        if (flux) {
          return flux.actions;
        }
        throw new Error("Could not find flux on this.props or this.context");
      }
    }, {
      key: 'render',
      value: function render() {
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(InnerComponent, _extends({}, this.props, {
          actions: this.getActions()
        }));
      }
    }]);

    return _class;
  }(__WEBPACK_IMPORTED_MODULE_0_react__["Component"]), _class.childContextTypes = {
    flux: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object
  }, _class.contextTypes = {
    flux: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object
  }, _temp;
};

/* harmony default export */ __webpack_exports__["a"] = (FluxActionAwareComponent);

/***/ }),
/* 79 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__components_library_TextInput__ = __webpack_require__(80);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__components_library_ClickYourWayComponent__ = __webpack_require__(591);





function getDefaultClassName(tileSize) {
  return 'c-base-tile c-base-tile--' + tileSize;
}

/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var readOnly = _ref.readOnly,
      onMenu = _ref.onMenu,
      onSelect = _ref.onSelect,
      onPreviewEntity = _ref.onPreviewEntity,
      _ref$tileSize = _ref.tileSize,
      tileSize = _ref$tileSize === undefined ? 'md' : _ref$tileSize,
      customHeight = _ref.customHeight,
      children = _ref.children,
      editing = _ref.editing,
      onBeginEdit = _ref.onBeginEdit,
      onCancelEdit = _ref.onCancelEdit,
      onFinishedEditing = _ref.onFinishedEditing,
      name = _ref.name,
      updateErrorOccurred = _ref.updateErrorOccurred,
      defaultValue = _ref.defaultValue,
      selected = _ref.selected,
      nameHidden = _ref.nameHidden,
      className = _ref.className,
      style = _ref.style,
      draggable = _ref.draggable,
      _onDragStart = _ref.onDragStart,
      _onDragEnd = _ref.onDragEnd;


  var tileClassName = className || getDefaultClassName(tileSize);
  if (selected) {
    tileClassName += ' c-base-tile--selected';
  }
  var tileStyle = style || {};
  if (customHeight && customHeight > 0) {
    tileStyle.height = customHeight;
  }

  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    'div',
    null,
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      __WEBPACK_IMPORTED_MODULE_2__components_library_ClickYourWayComponent__["a" /* default */],
      {
        title: name,
        onContextMenu: function onContextMenu(event) {
          !readOnly ? onMenu(event) : null;
        },
        onDoubleClick: onPreviewEntity ? function (event) {
          return onPreviewEntity(event);
        } : null,
        onClick: onSelect ? function (event) {
          return onSelect(event);
        } : null,
        className: tileClassName,
        style: tileStyle
      },
      __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        {
          className: 'c-base-tile__container',
          draggable: draggable,
          onDragStart: function onDragStart(evt) {
            return _onDragStart && _onDragStart(evt);
          },
          onDragEnd: function onDragEnd(evt) {
            return _onDragEnd && _onDragEnd(evt);
          }
        },
        children
      )
    ),
    nameHidden ? null : __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_1__components_library_TextInput__["a" /* default */], {
      readOnly: readOnly,
      value: name,
      updateErrorOccurred: updateErrorOccurred,
      labelDefaultValue: defaultValue,
      editing: editing,
      onBeginEdit: onBeginEdit,
      onCancelEdit: onCancelEdit,
      onChangeValue: onFinishedEditing,
      fieldClassName: 'c-base-tile__name'
    })
  );
});

/***/ }),
/* 80 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return TextInput; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_classnames__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_classnames__);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }





var ENTER_KEY = 13;
var ESC_KEY = 27;

var TextInput = (_temp = _class = function (_React$Component) {
  _inherits(TextInput, _React$Component);

  function TextInput(props) {
    _classCallCheck(this, TextInput);

    var _this = _possibleConstructorReturn(this, (TextInput.__proto__ || Object.getPrototypeOf(TextInput)).call(this, props));

    _this.invokeOnChange = function (newValue) {
      // If the user finished editing with the same value he started with, it's like canceling
      if (newValue === _this.getFieldValue()) {
        _this.props.onCancelEdit && _this.props.onCancelEdit();
      } else if (_this.props.onChangeValue) {
        _this.setState({ value: newValue });
        _this.props.onChangeValue(newValue);
      }
    };

    _this.setBeginEdit = function () {
      if (!_this.props.readOnly && _this.props.onBeginEdit) {
        _this.props.onBeginEdit();
      }
    };

    _this.onKeyDown = function (event) {
      if (event.keyCode === ESC_KEY) {
        if (_this.props.onCancelEdit) {
          event.preventDefault();
          _this.props.onCancelEdit();
        }
      } else if (event.keyCode === ENTER_KEY) {
        event.preventDefault();
        _this.invokeOnChange(event.target.value);
      }
    };

    _this.state = { value: null };
    return _this;
  }

  _createClass(TextInput, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (nextProps.value !== this.props.value || nextProps.updateErrorOccurred) {
        this.setState({ value: null });
      }
    }
  }, {
    key: 'getFieldValue',
    value: function getFieldValue() {
      return this.state.value === null ? this.props.value : this.state.value;
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var fieldValue = this.getFieldValue();

      var className = __WEBPACK_IMPORTED_MODULE_2_classnames___default()('c-text-input--no-gutter', { 'u-cursor-text': !this.props.readOnly }, this.props.fieldClassName);

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        {
          title: fieldValue,
          className: className,
          onClick: !this.props.useDoubleClick ? this.setBeginEdit : null,
          onDoubleClick: this.props.useDoubleClick ? this.setBeginEdit : null,
          style: this.props.style
        },
        this.props.editing ? __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement('input', {
          autoFocus: true,
          defaultValue: fieldValue,
          onKeyDown: this.onKeyDown,
          onFocus: function onFocus(event) {
            return event.target.select();
          },
          onBlur: function onBlur(event) {
            return _this2.invokeOnChange(event.target.value);
          }
        }) : fieldValue || this.props.labelDefaultValue
      );
    }
  }]);

  return TextInput;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component), _class.propTypes = {
  readOnly: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
  fieldClassName: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
  value: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
  updateErrorOccurred: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
  labelDefaultValue: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
  editing: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
  useDoubleClick: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
  onBeginEdit: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onCancelEdit: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onChangeValue: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  style: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object
}, _temp);


/***/ }),
/* 81 */,
/* 82 */,
/* 83 */,
/* 84 */,
/* 85 */,
/* 86 */,
/* 87 */,
/* 88 */,
/* 89 */,
/* 90 */,
/* 91 */,
/* 92 */,
/* 93 */,
/* 94 */,
/* 95 */,
/* 96 */,
/* 97 */,
/* 98 */,
/* 99 */,
/* 100 */,
/* 101 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__components_library_Icon__ = __webpack_require__(34);




/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var onClickTarget = _ref.onClickTarget;


  var fabButton = __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    'div',
    { className: 'c-fab-button', onClick: onClickTarget },
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_1__components_library_Icon__["a" /* default */], { size: 24, glyph: 'fab-add' })
  );

  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    'div',
    null,
    fabButton
  );
});

/***/ }),
/* 102 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return DropTargetTile; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var DropTargetTile = (_temp = _class = function (_React$Component) {
  _inherits(DropTargetTile, _React$Component);

  function DropTargetTile(props) {
    _classCallCheck(this, DropTargetTile);

    var _this = _possibleConstructorReturn(this, (DropTargetTile.__proto__ || Object.getPrototypeOf(DropTargetTile)).call(this, props));

    _this.handleDragOver = function (e) {
      if (e.preventDefault) {
        e.preventDefault(); // Necessary. Allows us to drop.
        e.stopPropagation();
      }

      if (_this.props.reorderingAllowed) {

        if (_this.props.forceClueLocation) {
          _this.insertBefore = _this.props.forceClueLocation;
        } else {
          if (_this.props.direction === 'horizontal') {
            var middleWidth = e.currentTarget.offsetWidth / 2;
            _this.insertBefore = e.currentTarget.offsetLeft + middleWidth > e.clientX;
          } else {
            var middleHeight = e.currentTarget.offsetHeight / 2;
            _this.insertBefore = e.currentTarget.offsetTop + middleHeight > e.pageY;
          }
        }

        if (_this.insertBefore) {
          e.currentTarget.classList.add(_this.state.beforeClueClassName);
          e.currentTarget.classList.remove(_this.state.afterClueClassName);
        } else {
          e.currentTarget.classList.add(_this.state.afterClueClassName);
          e.currentTarget.classList.remove(_this.state.beforeClueClassName);
        }
      }
      return false;
    };

    _this.handleDragEnter = function () {

      _this.setState({ dragEntered: true });

      if (!_this.timer && !_this.props.reorderingAllowed) {
        _this.timer = setTimeout(function () {
          _this.props.onContinuosHover(true);
        }, 400);
      }
    };

    _this.handleDragLeave = function (e) {
      var currentTarget = e.currentTarget;

      // Drag leave might be triggered when I did not leave the drop target but started hovering over its inner children,
      // This way they will receive dragEnter and the parent dragLeave.
      // Since this is not considered as actual leave for we are calculating if we are still within the drop target boundaries
      // and only if actually leaving it will invoke the leave flow
      if (_this.pointWithinRectangle(e.clientX, e.pageY, currentTarget.offsetLeft, currentTarget.offsetTop, currentTarget.offsetWidth, currentTarget.offsetHeight)) {
        return;
      }

      _this.clearUIClues(e);
      _this.clearTimeout();
    };

    _this.handleDrop = function (e) {
      event.preventDefault(); // don't forget this!

      _this.clearUIClues(e);
      _this.clearTimeout();

      if (_this.props.reorderingAllowed) {
        _this.props.onDrop(_this.insertBefore);
      }
    };

    _this.clearUIClues = function (e) {
      e.currentTarget.classList.remove(_this.state.beforeClueClassName);
      e.currentTarget.classList.remove(_this.state.afterClueClassName);
      _this.setState({ dragEntered: false });
    };

    _this.clearTimeout = function () {
      if (_this.timer) {
        clearTimeout(_this.timer);
        _this.timer = null;
      }
    };

    _this.insertBefore = false;
    _this.state = {
      dragEntered: false,
      beforeClueClassName: 'before-clue--' + _this.props.direction,
      afterClueClassName: 'after-clue--' + _this.props.direction
    };
    return _this;
  }

  _createClass(DropTargetTile, [{
    key: 'pointWithinRectangle',
    value: function pointWithinRectangle(x, y, leftTopCornerX, leftTopCornerY, width, height) {
      if (x > leftTopCornerX && x < leftTopCornerX + width && y > leftTopCornerY && y < leftTopCornerY + height) {
        return true;
      }

      return false;
    }
  }, {
    key: 'render',
    value: function render() {

      if (!this.props.isDroppable) {
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          { className: this.props.className },
          this.props.children
        );
      }

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        {
          className: 'c-drop-target ' + this.props.className,
          onDragLeave: this.handleDragLeave,
          onDragEnter: this.handleDragEnter,
          onDragOver: this.handleDragOver,
          onDrop: this.handleDrop
        },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          { style: { pointerEvents: this.state.dragEntered ? 'none' : 'initial' } },
          this.props.children
        )
      );
    }
  }]);

  return DropTargetTile;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component), _class.propTypes = {
  isDroppable: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
  direction: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf(['vertical', 'horizontal']),
  reorderingAllowed: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
  onContinuosHover: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func.isRequired,
  onDrop: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func.isRequired,
  forceClueLocation: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOf(['before', 'after'])
}, _class.defaultProps = {
  direction: 'horizontal',
  isDroppable: true
}, _temp);


/***/ }),
/* 103 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// returns a style object with a single concated prefixed value string

exports.default = function (property, value) {
  var replacer = arguments.length <= 2 || arguments[2] === undefined ? function (prefix, value) {
    return prefix + value;
  } : arguments[2];
  return _defineProperty({}, property, ['-webkit-', '-moz-', ''].map(function (prefix) {
    return replacer(prefix, value);
  }));
};

module.exports = exports['default'];

/***/ }),
/* 104 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_design_systems_lib__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_design_systems_lib___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_design_systems_lib__);

var analyticsReporter = new __WEBPACK_IMPORTED_MODULE_0_design_systems_lib__["analyticsService"](__WEBPACK_IMPORTED_MODULE_0_design_systems_lib__["sharedConstants"].analyticsClients.sketch);

/* harmony default export */ __webpack_exports__["a"] = (analyticsReporter);

/***/ }),
/* 105 */,
/* 106 */,
/* 107 */
/***/ (function(module, exports) {

// From https://github.com/isaacs/inherits
// inherits is licensed under the ISC license:
//
//
// The ISC License
//
// Copyright (c) Isaac Z. Schlueter
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
// OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor;
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor;
    var TempCtor = function TempCtor() {};
    TempCtor.prototype = superCtor.prototype;
    ctor.prototype = new TempCtor();
    ctor.prototype.constructor = ctor;
  };
}

/***/ }),
/* 108 */,
/* 109 */,
/* 110 */,
/* 111 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Buffer) {(function() {
  var crypt = __webpack_require__(468),
      utf8 = __webpack_require__(180).utf8,
      bin = __webpack_require__(180).bin,

  // The core
  sha1 = function (message) {
    // Convert to byte array
    if (message.constructor == String)
      message = utf8.stringToBytes(message);
    else if (typeof Buffer !== 'undefined' && typeof Buffer.isBuffer == 'function' && Buffer.isBuffer(message))
      message = Array.prototype.slice.call(message, 0);
    else if (!Array.isArray(message))
      message = message.toString();

    // otherwise assume byte array

    var m  = crypt.bytesToWords(message),
        l  = message.length * 8,
        w  = [],
        H0 =  1732584193,
        H1 = -271733879,
        H2 = -1732584194,
        H3 =  271733878,
        H4 = -1009589776;

    // Padding
    m[l >> 5] |= 0x80 << (24 - l % 32);
    m[((l + 64 >>> 9) << 4) + 15] = l;

    for (var i = 0; i < m.length; i += 16) {
      var a = H0,
          b = H1,
          c = H2,
          d = H3,
          e = H4;

      for (var j = 0; j < 80; j++) {

        if (j < 16)
          w[j] = m[i + j];
        else {
          var n = w[j - 3] ^ w[j - 8] ^ w[j - 14] ^ w[j - 16];
          w[j] = (n << 1) | (n >>> 31);
        }

        var t = ((H0 << 5) | (H0 >>> 27)) + H4 + (w[j] >>> 0) + (
                j < 20 ? (H1 & H2 | ~H1 & H3) + 1518500249 :
                j < 40 ? (H1 ^ H2 ^ H3) + 1859775393 :
                j < 60 ? (H1 & H2 | H1 & H3 | H2 & H3) - 1894007588 :
                         (H1 ^ H2 ^ H3) - 899497514);

        H4 = H3;
        H3 = H2;
        H2 = (H1 << 30) | (H1 >>> 2);
        H1 = H0;
        H0 = t;
      }

      H0 += a;
      H1 += b;
      H2 += c;
      H3 += d;
      H4 += e;
    }

    return [H0, H1, H2, H3, H4];
  },

  // Public API
  api = function (message, options) {
    var digestbytes = crypt.wordsToBytes(sha1(message));
    return options && options.asBytes ? digestbytes :
        options && options.asString ? bin.bytesToString(digestbytes) :
        crypt.bytesToHex(digestbytes);
  };

  api._blocksize = 16;
  api._digestsize = 20;

  module.exports = api;
})();

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(179).Buffer))

/***/ }),
/* 112 */,
/* 113 */,
/* 114 */,
/* 115 */,
/* 116 */,
/* 117 */,
/* 118 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__BaseTile__ = __webpack_require__(79);




/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var readOnly = _ref.readOnly,
      color = _ref.color,
      name = _ref.name,
      updateErrorOccurred = _ref.updateErrorOccurred,
      _ref$size = _ref.size,
      size = _ref$size === undefined ? 'md' : _ref$size,
      editing = _ref.editing,
      onSelect = _ref.onSelect,
      onPreviewEntity = _ref.onPreviewEntity,
      onBeginEdit = _ref.onBeginEdit,
      onCancelEdit = _ref.onCancelEdit,
      onRename = _ref.onRename,
      onMenu = _ref.onMenu,
      customHeight = _ref.customHeight,
      nameHidden = _ref.nameHidden,
      namePlaceholder = _ref.namePlaceholder,
      onColorDragStart = _ref.onColorDragStart,
      onColorDragEnd = _ref.onColorDragEnd,
      _ref$draggable = _ref.draggable,
      draggable = _ref$draggable === undefined ? true : _ref$draggable;


  //BaseTile doesn't have a preset support for such a small size so just use customHeight to achieve this goal
  var adjustedCustomHeight = size === 'sm' ? 32 : customHeight;
  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    __WEBPACK_IMPORTED_MODULE_1__BaseTile__["a" /* default */],
    {
      readOnly: readOnly,
      onMenu: onMenu,
      onSelect: onSelect,
      onPreviewEntity: onPreviewEntity,
      customHeight: adjustedCustomHeight,
      name: name,
      updateErrorOccurred: updateErrorOccurred,
      editing: editing,
      onBeginEdit: onBeginEdit,
      onCancelEdit: onCancelEdit,
      onFinishedEditing: onRename,
      nameHidden: nameHidden,
      defaultValue: namePlaceholder,
      onDragStart: onColorDragStart,
      onDragEnd: onColorDragEnd,
      draggable: draggable
    },
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'div',
      { className: 'c-color-tile__preview--' + size },
      __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { className: 'c-color-tile__checker-background' },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement('div', {
          className: 'c-color-tile__swatch',
          style: { backgroundColor: color }
        })
      )
    )
  );
});

/***/ }),
/* 119 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_classnames__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_classnames__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__TextInput_js__ = __webpack_require__(80);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__components_library_Icon__ = __webpack_require__(34);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__RichTextEditorWithCustomLinks__ = __webpack_require__(197);






/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var readOnly = _ref.readOnly,
      name = _ref.name,
      updateErrorOccurred = _ref.updateErrorOccurred,
      isNew = _ref.isNew,
      onMenu = _ref.onMenu,
      editing = _ref.editing,
      onBeginEdit = _ref.onBeginEdit,
      onCancelEdit = _ref.onCancelEdit,
      onRename = _ref.onRename,
      showDescription = _ref.showDescription,
      description = _ref.description,
      descriptionAsDelta = _ref.descriptionAsDelta,
      defaultDescription = _ref.defaultDescription,
      additionalClassNames = _ref.additionalClassNames,
      disabled = _ref.disabled;


  var className = __WEBPACK_IMPORTED_MODULE_1_classnames___default()('section-head u-mb5', additionalClassNames);

  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    'div',
    {
      className: className
    },
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'div',
      { className: 'section-head__action' },
      __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2__TextInput_js__["a" /* default */], {
        readOnly: readOnly,
        fieldClassName: 'section-head__title ' + (disabled ? 'disabled' : ''),
        value: name,
        updateErrorOccurred: updateErrorOccurred,
        editing: editing,
        onBeginEdit: onBeginEdit,
        onCancelEdit: onCancelEdit,
        onChangeValue: function onChangeValue(name) {
          return onRename({ name: name });
        },
        labelDefaultValue: getName(isNew, name || 'Untitled Section')
      }),
      readOnly ? null : __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3__components_library_Icon__["a" /* default */], { glyph: 'actions-more', size: 18, onClick: onMenu })
    ),
    !showDescription ? null : __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'div',
      { className: 'section-description' },
      __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__RichTextEditorWithCustomLinks__["a" /* default */], {
        className: 'u-mt4',
        legacyValue: description,
        value: descriptionAsDelta,
        placeholder: defaultDescription || 'Description...',
        readOnly: readOnly,
        onFinishedEditing: function onFinishedEditing(descriptionAsDelta) {
          return onRename({ descriptionAsDelta: descriptionAsDelta });
        }
      })
    )
  );
});

function getName(isNew, name) {
  if (isNew) {
    return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'em',
      null,
      name
    );
  } else {
    return name;
  }
}

/***/ }),
/* 120 */,
/* 121 */,
/* 122 */,
/* 123 */,
/* 124 */,
/* 125 */,
/* 126 */,
/* 127 */,
/* 128 */,
/* 129 */,
/* 130 */,
/* 131 */,
/* 132 */,
/* 133 */,
/* 134 */,
/* 135 */,
/* 136 */,
/* 137 */,
/* 138 */,
/* 139 */,
/* 140 */,
/* 141 */,
/* 142 */,
/* 143 */,
/* 144 */,
/* 145 */,
/* 146 */,
/* 147 */,
/* 148 */,
/* 149 */,
/* 150 */,
/* 151 */,
/* 152 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__util__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__BaseTile__ = __webpack_require__(79);






/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var readOnly = _ref.readOnly,
      typeStyle = _ref.typeStyle,
      draggable = _ref.draggable,
      selected = _ref.selected,
      installedFonts = _ref.installedFonts,
      onSelect = _ref.onSelect,
      onPreviewEntity = _ref.onPreviewEntity,
      onTypeStyleDragStart = _ref.onTypeStyleDragStart,
      onTypeStyleDragEnd = _ref.onTypeStyleDragEnd,
      onMenu = _ref.onMenu,
      _ref$rowView = _ref.rowView,
      rowView = _ref$rowView === undefined ? false : _ref$rowView,
      _ref$trim = _ref.trim,
      trim = _ref$trim === undefined ? true : _ref$trim,
      editing = _ref.editing,
      onBeginEditItem = _ref.onBeginEditItem,
      onCancelEditItem = _ref.onCancelEditItem,
      onRename = _ref.onRename,
      nameHidden = _ref.nameHidden;


  var id = typeStyle._id || typeStyle.objectID;

  var fontFamily = void 0;
  var fontIsNotInstalled = false;
  if (installedFonts) {
    if (installedFonts[id]) {
      fontFamily = installedFonts[id];
    } else {
      // Font is not installed if there is installed font data, but not
      // for this type style.
      fontIsNotInstalled = true;
      fontFamily = 'Helvetica'; // Fallback.
    }
  } else {
    // No installed font data, so use info from type style.
    fontFamily = typeStyle.metadata && typeStyle.metadata.postScriptName || typeStyle.fontFamily;
  }
  var fontStyle = __WEBPACK_IMPORTED_MODULE_2__util__["L" /* styleFromFVD */](typeStyle.fontVariant);

  // Adjust background color for better contrast.
  // todo: need to rethink/rewrite the whole background color thing
  var textColor = typeStyle.textColor || 'black';
  var backgroundColor = __WEBPACK_IMPORTED_MODULE_2__util__["e" /* backgroundColorWithBetterContrastForTextColor */](textColor, typeStyle.backgroundColor || (rowView ? 'white' : '#F6F7F7'));

  var sampleStyles = {
    color: selected ? 'white' : textColor,
    backgroundColor: selected ? 'ActiveBorder' : backgroundColor,
    fontSize: typeStyle.fontSize,
    fontFamily: fontFamily,
    fontWeight: fontStyle.fontWeight,
    fontStyle: fontStyle.fontStyle,
    textAlign: typeStyle.alignment,
    letterSpacing: typeStyle.letterSpacing,
    textTransform: typeStyle.uppercase ? 'uppercase' : void 0,
    opacity: typeStyle.opacity ? typeStyle.opacity : void 0,
    textDecoration: (typeStyle.underline ? 'underline' : void 0) || (typeStyle.strikethrough ? 'line-through' : void 0)
  };

  // Limit fontSize in the row view.
  if (typeStyle.fontSize > 50) {
    sampleStyles.fontSize = 50;
  }

  var fontNotInstalledWarning = fontIsNotInstalled ? __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    'div',
    {
      className: 'flex-none',
      style: { paddingLeft: 10 },
      title: 'The font used in this style is not installed. A fallback font will be used.'
    },
    '\u26A0\uFE0F'
  ) : null;

  var namePlaceholder = __WEBPACK_IMPORTED_MODULE_2__util__["m" /* getEntityDescriptors */]().typeStyles.namePlaceholder;
  var name = typeStyle.name || namePlaceholder;
  var className = rowView ? 'c-text-row' : 'c-text-tile';
  var sampleClassName = trim ? 'c-text-tile__sample' : '';

  // no need to pass selected to base tile since it is handled differently
  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    __WEBPACK_IMPORTED_MODULE_3__BaseTile__["a" /* default */],
    {
      className: className,
      style: { backgroundColor: sampleStyles.backgroundColor },
      onSelect: onSelect,
      readOnly: readOnly,
      onMenu: onMenu,
      editing: editing,
      onBeginEdit: onBeginEditItem,
      onCancelEdit: onCancelEditItem,
      onFinishedEditing: onRename,
      name: typeStyle.name,
      updateErrorOccurred: typeStyle.updateErrorOccurred,
      defaultValue: namePlaceholder,
      onPreviewEntity: onPreviewEntity,
      nameHidden: nameHidden || rowView,
      draggable: draggable,
      onDragStart: function onDragStart(evt) {
        attachDraggedCursorImage(id, evt);
        if (onTypeStyleDragStart) {
          onTypeStyleDragStart(evt);
        }
      },
      onDragEnd: onTypeStyleDragEnd && onTypeStyleDragEnd.bind(null, __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.defaults({ name: name }, typeStyle))
    },
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'div',
      { className: 'flex items-center u-no-min-width u-full-width' },
      __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { className: 'flex-auto ' + sampleClassName, style: sampleStyles },
        name
      ),
      fontNotInstalledWarning
    ),
    draggable && __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement('img', {
      id: 'proxy-image-' + id,
      style: { position: 'absolute', left: '-9999px' },
      src: svgDataURI(name, fontFamily, sampleStyles, 1000, 300)
    })
  );
});

function attachDraggedCursorImage(id, evt) {
  var image = document.getElementById('proxy-image-' + id);
  evt.dataTransfer.setDragImage(image, 20, 260);
  evt.dataTransfer.setData('text/plain', '.....');
}

function svgDataURI(text, fontFamily, styles, width, height) {
  var svg = '<?xml version="1.0" encoding="UTF-8" standalone="no"?>\n    <svg width="' + width + '" height="' + height + '" viewBox="0 0 ' + width + ' ' + height + '" xmlns="http://www.w3.org/2000/svg" version="1.1">\n      <text\n        x="0"\n        y="' + height * 0.9 + '"\n        fill="' + styles.color + '"\n        font-family="' + fontFamily + '"\n        font-size="' + styles.fontSize + '"\n        font-weight="' + styles.fontWeight + '"\n        font-style="' + styles.fontStyle + '"\n        letter-spacing="' + styles.letterSpacing + '"\n        text-decoration="' + styles.textDecoration + '"\n        text-transform="' + styles.textTransform + '"\n      >\n        ' + text + '\n      </text>\n    </svg>\n  ';

  return 'data:image/svg+xml;base64,' + __WEBPACK_IMPORTED_MODULE_2__util__["f" /* base64Encode */](svg);
}

/***/ }),
/* 153 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Shortcuts; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__shortcuts__ = __webpack_require__(855);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__util__ = __webpack_require__(12);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/* global Mousetrap */







var Shortcuts = function (_React$Component) {
  _inherits(Shortcuts, _React$Component);

  function Shortcuts() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, Shortcuts);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Shortcuts.__proto__ || Object.getPrototypeOf(Shortcuts)).call.apply(_ref, [this].concat(args))), _this), _this.handleCallback = function (event, combo) {

      if (_this.props.preventDefault) {
        event.preventDefault();
      }

      if (_this.props.stopPropagation) {
        event.stopPropagation();
      }

      var shortcutsSet = __WEBPACK_IMPORTED_MODULE_1__shortcuts__["a" /* default */][_this.props.name];
      if (!shortcutsSet) {
        Object(__WEBPACK_IMPORTED_MODULE_2__util__["h" /* debug */])('Should not happen, if shortcut handler is fired it should have appropriate value in shortcuts map ' + combo);
      }
      _this.props.handler(event, shortcutsSet[combo]);
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(Shortcuts, [{
    key: 'componentWillMount',
    value: function componentWillMount() {
      var shortcutsSet = __WEBPACK_IMPORTED_MODULE_1__shortcuts__["a" /* default */][this.props.name];
      if (!shortcutsSet) {
        return;
      }
      Mousetrap.bind(Object.keys(shortcutsSet), this.handleCallback);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      var shortcutsSet = __WEBPACK_IMPORTED_MODULE_1__shortcuts__["a" /* default */][this.props.name];
      if (!shortcutsSet) {
        return;
      }
      Mousetrap.unbind(Object.keys(shortcutsSet));
    }
  }, {
    key: 'render',
    value: function render() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        null,
        this.props.children
      );
    }
  }]);

  return Shortcuts;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component);



/***/ }),
/* 154 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// Shim to avoid requiring Velocity in Node environments, since it
// requires window. Note that this just no-ops the components so
// that they'll render, rather than doing something clever like
// statically rendering the end state of any provided animations.
//
// TODO(finneganh): Circle back on jsdom to see if we can run full
// Velocity with it in place. This come up in:
// https://github.com/twitter-fabric/velocity-react/issues/119
// but there may have been different loading issues in that case,
// not a global incompatibility with jsdom.

if (typeof window === 'undefined' || typeof navigator === 'undefined' || navigator.userAgent.indexOf("Node.js") !== -1 || navigator.userAgent.indexOf("jsdom") !== -1) {

  var Velocity = function Velocity() {};
  Velocity.Utilities = {};
  Velocity.Utilities.removeData = function () {};
  Velocity.velocityReactServerShim = true;
  module.exports = Velocity;
} else {
  // this is how velocity-ui finds the Velocity instance, so lets make sure we find the right instance
  var g = window.jQuery || window.Zepto || window;

  // require Velocity if it doesn't already exist
  module.exports = g.Velocity ? g.Velocity : __webpack_require__(883);
}

/***/ }),
/* 155 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var StyleKeeper = function () {
  function StyleKeeper(userAgent) {
    _classCallCheck(this, StyleKeeper);

    this._userAgent = userAgent;
    this._listeners = [];
    this._cssSet = {};
  }

  StyleKeeper.prototype.subscribe = function subscribe(listener) {
    var _this = this;

    if (this._listeners.indexOf(listener) === -1) {
      this._listeners.push(listener);
    }

    return {
      // Must be fat arrow to capture `this`
      remove: function remove() {
        var listenerIndex = _this._listeners.indexOf(listener);
        if (listenerIndex > -1) {
          _this._listeners.splice(listenerIndex, 1);
        }
      }
    };
  };

  StyleKeeper.prototype.addCSS = function addCSS(css) {
    var _this2 = this;

    if (!this._cssSet[css]) {
      this._cssSet[css] = true;
      this._emitChange();
    }

    return {
      // Must be fat arrow to capture `this`
      remove: function remove() {
        delete _this2._cssSet[css];
        _this2._emitChange();
      }
    };
  };

  StyleKeeper.prototype.getCSS = function getCSS() {
    return Object.keys(this._cssSet).join('\n');
  };

  StyleKeeper.prototype._emitChange = function _emitChange() {
    this._listeners.forEach(function (listener) {
      return listener();
    });
  };

  return StyleKeeper;
}();

exports.default = StyleKeeper;
module.exports = exports['default'];

/***/ }),
/* 156 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = cssRuleSetToString;

var _appendPxIfNeeded = __webpack_require__(277);

var _appendPxIfNeeded2 = _interopRequireDefault(_appendPxIfNeeded);

var _camelCasePropsToDashCase = __webpack_require__(893);

var _camelCasePropsToDashCase2 = _interopRequireDefault(_camelCasePropsToDashCase);

var _mapObject = __webpack_require__(278);

var _mapObject2 = _interopRequireDefault(_mapObject);

var _prefixer = __webpack_require__(157);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function createMarkupForStyles(style) {
  return Object.keys(style).map(function (property) {
    return property + ': ' + style[property] + ';';
  }).join('\n');
}

function cssRuleSetToString(selector, rules, userAgent) {
  if (!rules) {
    return '';
  }

  var rulesWithPx = (0, _mapObject2.default)(rules, function (value, key) {
    return (0, _appendPxIfNeeded2.default)(key, value);
  });
  var prefixedRules = (0, _prefixer.getPrefixedStyle)(rulesWithPx, userAgent);
  var cssPrefixedRules = (0, _camelCasePropsToDashCase2.default)(prefixedRules);
  var serializedRules = createMarkupForStyles(cssPrefixedRules);

  return selector + '{' + serializedRules + '}';
}
module.exports = exports['default'];

/***/ }),
/* 157 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global, process) {

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; /**
                                                                                                                                                                                                                                                                               * Based on https://github.com/jsstyles/css-vendor, but without having to
                                                                                                                                                                                                                                                                               * convert between different cases all the time.
                                                                                                                                                                                                                                                                               *
                                                                                                                                                                                                                                                                               * 
                                                                                                                                                                                                                                                                               */

exports.getPrefixedKeyframes = getPrefixedKeyframes;
exports.getPrefixedStyle = getPrefixedStyle;

var _inlineStylePrefixer = __webpack_require__(894);

var _inlineStylePrefixer2 = _interopRequireDefault(_inlineStylePrefixer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function transformValues(style) {
  return Object.keys(style).reduce(function (newStyle, key) {
    var value = style[key];
    if (Array.isArray(value)) {
      value = value.join(';' + key + ':');
    } else if (value && (typeof value === 'undefined' ? 'undefined' : _typeof(value)) === 'object' && typeof value.toString === 'function') {
      value = value.toString();
    }

    newStyle[key] = value;
    return newStyle;
  }, {});
}

var _hasWarnedAboutUserAgent = false;
var _lastUserAgent = void 0;
var _cachedPrefixer = void 0;

function getPrefixer(userAgent) {
  var actualUserAgent = userAgent || global && global.navigator && global.navigator.userAgent;

  if (process.env.NODE_ENV !== 'production') {
    if (!actualUserAgent && !_hasWarnedAboutUserAgent) {
      /* eslint-disable no-console */
      console.warn('Radium: userAgent should be supplied for server-side rendering. See ' + 'https://github.com/FormidableLabs/radium/tree/master/docs/api#radium ' + 'for more information.');
      /* eslint-enable no-console */
      _hasWarnedAboutUserAgent = true;
    }
  }

  if (!_cachedPrefixer || actualUserAgent !== _lastUserAgent) {
    if (actualUserAgent === 'all') {
      _cachedPrefixer = {
        prefix: _inlineStylePrefixer2.default.prefixAll,
        prefixedKeyframes: 'keyframes'
      };
    } else {
      _cachedPrefixer = new _inlineStylePrefixer2.default({ userAgent: actualUserAgent });
    }
    _lastUserAgent = actualUserAgent;
  }
  return _cachedPrefixer;
}

function getPrefixedKeyframes(userAgent) {
  return getPrefixer(userAgent).prefixedKeyframes;
}

// Returns a new style object with vendor prefixes added to property names
// and values.
function getPrefixedStyle(style, userAgent) {
  var styleWithFallbacks = transformValues(style);
  var prefixer = getPrefixer(userAgent);
  var prefixedStyle = prefixer.prefix(styleWithFallbacks);
  return prefixedStyle;
}
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(22), __webpack_require__(11)))

/***/ }),
/* 158 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
// helper to capitalize strings

exports.default = function (str) {
  return str.charAt(0).toUpperCase() + str.slice(1);
};

module.exports = exports["default"];

/***/ }),
/* 159 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (value) {
  if (Array.isArray(value)) value = value.join(',');

  return value.match(/-webkit-|-moz-|-ms-/) !== null;
};

module.exports = exports['default'];

/***/ }),
/* 160 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony default export */ __webpack_exports__["a"] = ({

  defaultXAuthToken: 'rhR7SC8hbTflgiqAq7uKJVogMkIySGRQ',

  defaultDomain: 'projects',

  baseURL: 'invisionapp.com',
  dsmApi: 'dsm-api',

  defaultPusherToken: '9a944f66a49d70b3596e'

});

/***/ }),
/* 161 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["e"] = snapshotDeleteMessage;
/* harmony export (immutable) */ __webpack_exports__["d"] = snapshotCreatedMessage;
/* harmony export (immutable) */ __webpack_exports__["a"] = organizationAddedToUserMessage;
/* unused harmony export organizationRemovedFromUserMessage */
/* harmony export (immutable) */ __webpack_exports__["j"] = userPermissionsChangedMessage;
/* harmony export (immutable) */ __webpack_exports__["f"] = styleguideAddedMessage;
/* harmony export (immutable) */ __webpack_exports__["i"] = userAddedToStyleguideMessage;
/* harmony export (immutable) */ __webpack_exports__["b"] = organizationRenamedMessage;
/* harmony export (immutable) */ __webpack_exports__["g"] = styleguideRemovedMessage;
/* harmony export (immutable) */ __webpack_exports__["h"] = styleguideRenamedMessage;
/* harmony export (immutable) */ __webpack_exports__["c"] = prefetchingStyleDataFailed;
/* harmony export (immutable) */ __webpack_exports__["k"] = viewingSnapshotVersion;
/* unused harmony export updatePluginVersion */
function snapshotDeleteMessage(message) {
  return {
    key: 'snapshot-deleted-' + message.snapshotId,
    message: 'Version ' + message.snapshotName + ' was removed from your design library.'
  };
}

function snapshotCreatedMessage(versionCreatedMessage) {
  return {
    key: 'snapshot-created-' + versionCreatedMessage.snapshotId,
    message: 'New version ' + versionCreatedMessage.snapshotName + ' is available in your library',
    actions: {
      first: {
        text: 'See what’s new',
        action: {
          eventName: 'viewReleaseChanges',
          payload: {
            snapshotId: versionCreatedMessage.snapshotId
          }
        }
      },
      second: {
        text: 'Switch',
        action: {
          eventName: 'onStyleguideChanged',
          payload: {
            styleguideId: versionCreatedMessage.styleguideId,
            snapshotId: versionCreatedMessage.snapshotId
          }
        }
      }
    }
  };
}

function organizationAddedToUserMessage(message) {
  return {
    key: 'organization-added-' + message.organization._id,
    message: 'Organization "' + message.organization.name + '" was added.'
  };
}

function organizationRemovedFromUserMessage(message) {
  return {
    key: 'organization-remove-' + message.organization._id,
    message: 'Organization "' + message.organization.name + '" was removed.'
  };
}

function userPermissionsChangedMessage(message) {
  return {
    key: 'organization-permissions-' + message.organizationId,
    message: 'Your permissions in ' + message.organizationName + ' were changed.'
  };
}

function viewStyleguideMessage(message, text) {
  var styleguideId = message.styleguide._id;
  return {
    key: 'styleguide-added-' + styleguideId,
    message: text,
    actions: {
      first: {
        text: 'View',
        action: {
          eventName: 'onStyleguideChanged',
          payload: {
            styleguideId: styleguideId
          }
        }
      }
    }
  };
}

function styleguideAddedMessage(message) {
  var text = 'Design library "' + message.styleguide.name + '" is now available in your organization "' + message.styleguide.organization + '".';

  return viewStyleguideMessage(message, text);
}

function userAddedToStyleguideMessage(message) {
  var text = 'Design library "' + message.styleguide.name + '" was shared with you';

  return viewStyleguideMessage(message, text);
}

function organizationRenamedMessage(message) {
  return {
    key: 'organization-renamed-' + message.organization._id,
    message: 'Organization was renamed to "' + message.organization.name + '"'
  };
}

function styleguideRemovedMessage(message) {
  return {
    key: 'styleguide-removed-' + message.styleguideId,
    message: message.styleguideName + ' design library was removed from your organization ' + message.organizationName + '.'
  };
}

function styleguideRenamedMessage(message) {
  return {
    key: 'styleguide-renamed-' + message.styleguideId,
    message: 'This design library has been renamed.'
  };
}

function prefetchingStyleDataFailed(styleguideId) {
  return {
    key: 'styleguide-prefetching-' + styleguideId,
    message: 'Could not download library data. Please check you connection.',
    actions: {
      first: {
        text: 'Try again',
        action: { eventName: 'fetchCacheableStyleData' }
      }
    },
    undismissible: true
  };
}

function viewingSnapshotVersion(styleguide) {
  return {
    key: 'editor-viewing-' + styleguide._id,
    message: 'You are viewing version "' + styleguide.snapshotName + '" of your design library.',
    actions: {
      first: {
        text: 'Edit Shared Draft',
        action: {
          eventName: 'onStyleguideChanged',
          payload: {
            styleguideId: styleguide._id
          }
        }
      }
    }
  };
}

function updatePluginVersion(versionInfo) {
  var updateMessageText = versionInfo.updateMessage || 'A new plugin version is available to install.';
  var releaseNotesURL = versionInfo.releaseNotesURL;

  return {
    key: 'update-plugin',
    persisted: true,
    message: updateMessageText,
    actions: {
      first: {
        text: 'Read More',
        action: {
          eventName: 'viewSketchReleaseNotesPage',
          payload: releaseNotesURL
        }
      },
      second: {
        text: 'Update',
        action: {
          eventName: 'installPluginUpdate'
        }
      }
    }
  };
}

/***/ }),
/* 162 */,
/* 163 */,
/* 164 */,
/* 165 */,
/* 166 */,
/* 167 */,
/* 168 */,
/* 169 */
/***/ (function(module, exports, __webpack_require__) {

var _ = __webpack_require__(3);

var defaultDispatchInterceptor = function defaultDispatchInterceptor(action, dispatch) {
  dispatch(action);
};

var Dispatcher = function Dispatcher(stores) {
  this.stores = {};
  this.currentDispatch = null;
  this.currentActionType = null;
  this.waitingToDispatch = [];
  this.dispatchInterceptor = defaultDispatchInterceptor;
  this._boundDispatch = this._dispatch.bind(this);

  for (var key in stores) {
    if (stores.hasOwnProperty(key)) {
      this.addStore(key, stores[key]);
    }
  }
};

Dispatcher.prototype.addStore = function (name, store) {
  store.dispatcher = this;
  this.stores[name] = store;
};

Dispatcher.prototype.dispatch = function (action) {
  this.dispatchInterceptor(action, this._boundDispatch);
};

Dispatcher.prototype._dispatch = function (action) {
  if (!action || !action.type) {
    throw new Error("Can only dispatch actions with a 'type' property");
  }

  if (this.currentDispatch) {
    var complaint = "Cannot dispatch an action ('" + action.type + "') while another action ('" + this.currentActionType + "') is being dispatched";
    throw new Error(complaint);
  }

  this.waitingToDispatch = _.clone(this.stores);

  this.currentActionType = action.type;
  this.currentDispatch = _.mapValues(this.stores, function () {
    return { resolved: false, waitingOn: [], waitCallback: null };
  });

  try {
    this.doDispatchLoop(action);
  } finally {
    this.currentActionType = null;
    this.currentDispatch = null;
  }
};

Dispatcher.prototype.doDispatchLoop = function (action) {
  var dispatch,
      canBeDispatchedTo,
      wasHandled = false,
      removeFromDispatchQueue = [],
      dispatchedThisLoop = [];

  _.forOwn(this.waitingToDispatch, function (value, key) {
    dispatch = this.currentDispatch[key];
    canBeDispatchedTo = !dispatch.waitingOn.length || !_.intersection(dispatch.waitingOn, _.keys(this.waitingToDispatch)).length;
    if (canBeDispatchedTo) {
      if (dispatch.waitCallback) {
        var stores = _.map(dispatch.waitingOn, function (key) {
          return this.stores[key];
        }.bind(this));
        var fn = dispatch.waitCallback;
        dispatch.waitCallback = null;
        dispatch.waitingOn = [];
        dispatch.resolved = true;
        fn.apply(null, stores);
        wasHandled = true;
      } else {
        dispatch.resolved = true;
        var handled = this.stores[key].__handleAction__(action);
        if (handled) {
          wasHandled = true;
        }
      }

      dispatchedThisLoop.push(key);

      if (this.currentDispatch[key].resolved) {
        removeFromDispatchQueue.push(key);
      }
    }
  }.bind(this));

  if (_.keys(this.waitingToDispatch).length && !dispatchedThisLoop.length) {
    var storesWithCircularWaits = _.keys(this.waitingToDispatch).join(", ");
    throw new Error("Indirect circular wait detected among: " + storesWithCircularWaits);
  }

  _.forEach(removeFromDispatchQueue, function (key) {
    delete this.waitingToDispatch[key];
  }.bind(this));

  if (_.size(this.waitingToDispatch)) {
    this.doDispatchLoop(action);
  }

  if (!wasHandled && console && console.warn) {
    console.warn("An action of type " + action.type + " was dispatched, but no store handled it");
  }
};

Dispatcher.prototype.waitForStores = function (store, stores, fn) {
  if (!this.currentDispatch) {
    throw new Error("Cannot wait unless an action is being dispatched");
  }

  var waitingStoreName = _.findKey(this.stores, function (val) {
    return val === store;
  });

  if (stores.indexOf(waitingStoreName) > -1) {
    throw new Error("A store cannot wait on itself");
  }

  var dispatch = this.currentDispatch[waitingStoreName];

  if (dispatch.waitingOn.length) {
    throw new Error(waitingStoreName + " already waiting on stores");
  }

  _.forEach(stores, function (storeName) {
    var storeDispatch = this.currentDispatch[storeName];
    if (!this.stores[storeName]) {
      throw new Error("Cannot wait for non-existent store " + storeName);
    }
    if (storeDispatch.waitingOn.indexOf(waitingStoreName) > -1) {
      throw new Error("Circular wait detected between " + waitingStoreName + " and " + storeName);
    }
  }.bind(this));

  dispatch.resolved = false;
  dispatch.waitingOn = _.uniq(dispatch.waitingOn.concat(stores));
  dispatch.waitCallback = fn;
};

Dispatcher.prototype.setDispatchInterceptor = function (fn) {
  if (fn) {
    this.dispatchInterceptor = fn;
  } else {
    this.dispatchInterceptor = defaultDispatchInterceptor;
  }
};

module.exports = Dispatcher;

/***/ }),
/* 170 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Representation of a single EventEmitter function.
 *
 * @param {Function} fn Event handler to be called.
 * @param {Mixed} context Context for function execution.
 * @param {Boolean} once Only emit once
 * @api private
 */
function EE(fn, context, once) {
  this.fn = fn;
  this.context = context;
  this.once = once || false;
}

/**
 * Minimal EventEmitter interface that is molded against the Node.js
 * EventEmitter interface.
 *
 * @constructor
 * @api public
 */
function EventEmitter() { /* Nothing to set */ }

/**
 * Holds the assigned EventEmitters by name.
 *
 * @type {Object}
 * @private
 */
EventEmitter.prototype._events = undefined;

/**
 * Return a list of assigned event listeners.
 *
 * @param {String} event The events that should be listed.
 * @returns {Array}
 * @api public
 */
EventEmitter.prototype.listeners = function listeners(event) {
  if (!this._events || !this._events[event]) return [];
  if (this._events[event].fn) return [this._events[event].fn];

  for (var i = 0, l = this._events[event].length, ee = new Array(l); i < l; i++) {
    ee[i] = this._events[event][i].fn;
  }

  return ee;
};

/**
 * Emit an event to all registered event listeners.
 *
 * @param {String} event The name of the event.
 * @returns {Boolean} Indication if we've emitted an event.
 * @api public
 */
EventEmitter.prototype.emit = function emit(event, a1, a2, a3, a4, a5) {
  if (!this._events || !this._events[event]) return false;

  var listeners = this._events[event]
    , len = arguments.length
    , args
    , i;

  if ('function' === typeof listeners.fn) {
    if (listeners.once) this.removeListener(event, listeners.fn, true);

    switch (len) {
      case 1: return listeners.fn.call(listeners.context), true;
      case 2: return listeners.fn.call(listeners.context, a1), true;
      case 3: return listeners.fn.call(listeners.context, a1, a2), true;
      case 4: return listeners.fn.call(listeners.context, a1, a2, a3), true;
      case 5: return listeners.fn.call(listeners.context, a1, a2, a3, a4), true;
      case 6: return listeners.fn.call(listeners.context, a1, a2, a3, a4, a5), true;
    }

    for (i = 1, args = new Array(len -1); i < len; i++) {
      args[i - 1] = arguments[i];
    }

    listeners.fn.apply(listeners.context, args);
  } else {
    var length = listeners.length
      , j;

    for (i = 0; i < length; i++) {
      if (listeners[i].once) this.removeListener(event, listeners[i].fn, true);

      switch (len) {
        case 1: listeners[i].fn.call(listeners[i].context); break;
        case 2: listeners[i].fn.call(listeners[i].context, a1); break;
        case 3: listeners[i].fn.call(listeners[i].context, a1, a2); break;
        default:
          if (!args) for (j = 1, args = new Array(len -1); j < len; j++) {
            args[j - 1] = arguments[j];
          }

          listeners[i].fn.apply(listeners[i].context, args);
      }
    }
  }

  return true;
};

/**
 * Register a new EventListener for the given event.
 *
 * @param {String} event Name of the event.
 * @param {Functon} fn Callback function.
 * @param {Mixed} context The context of the function.
 * @api public
 */
EventEmitter.prototype.on = function on(event, fn, context) {
  var listener = new EE(fn, context || this);

  if (!this._events) this._events = {};
  if (!this._events[event]) this._events[event] = listener;
  else {
    if (!this._events[event].fn) this._events[event].push(listener);
    else this._events[event] = [
      this._events[event], listener
    ];
  }

  return this;
};

/**
 * Add an EventListener that's only called once.
 *
 * @param {String} event Name of the event.
 * @param {Function} fn Callback function.
 * @param {Mixed} context The context of the function.
 * @api public
 */
EventEmitter.prototype.once = function once(event, fn, context) {
  var listener = new EE(fn, context || this, true);

  if (!this._events) this._events = {};
  if (!this._events[event]) this._events[event] = listener;
  else {
    if (!this._events[event].fn) this._events[event].push(listener);
    else this._events[event] = [
      this._events[event], listener
    ];
  }

  return this;
};

/**
 * Remove event listeners.
 *
 * @param {String} event The event we want to remove.
 * @param {Function} fn The listener that we need to find.
 * @param {Boolean} once Only remove once listeners.
 * @api public
 */
EventEmitter.prototype.removeListener = function removeListener(event, fn, once) {
  if (!this._events || !this._events[event]) return this;

  var listeners = this._events[event]
    , events = [];

  if (fn) {
    if (listeners.fn && (listeners.fn !== fn || (once && !listeners.once))) {
      events.push(listeners);
    }
    if (!listeners.fn) for (var i = 0, length = listeners.length; i < length; i++) {
      if (listeners[i].fn !== fn || (once && !listeners[i].once)) {
        events.push(listeners[i]);
      }
    }
  }

  //
  // Reset the array, or remove it completely if we have no more listeners.
  //
  if (events.length) {
    this._events[event] = events.length === 1 ? events[0] : events;
  } else {
    delete this._events[event];
  }

  return this;
};

/**
 * Remove all listeners or only the listeners for the specified event.
 *
 * @param {String} event The event want to remove all listeners for.
 * @api public
 */
EventEmitter.prototype.removeAllListeners = function removeAllListeners(event) {
  if (!this._events) return this;

  if (event) delete this._events[event];
  else this._events = {};

  return this;
};

//
// Alias methods names because people roll like that.
//
EventEmitter.prototype.off = EventEmitter.prototype.removeListener;
EventEmitter.prototype.addListener = EventEmitter.prototype.on;

//
// This function doesn't apply anymore.
//
EventEmitter.prototype.setMaxListeners = function setMaxListeners() {
  return this;
};

//
// Expose the module.
//
EventEmitter.EventEmitter = EventEmitter;
EventEmitter.EventEmitter2 = EventEmitter;
EventEmitter.EventEmitter3 = EventEmitter;

//
// Expose the module.
//
module.exports = EventEmitter;


/***/ }),
/* 171 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react_pure_render_shallowEqual__ = __webpack_require__(441);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react_pure_render_shallowEqual___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react_pure_render_shallowEqual__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_lodash_forEach__ = __webpack_require__(442);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_lodash_forEach___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_lodash_forEach__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_prop_types__);
var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






/**
 * Wrapper component that gives the wrapped component access to flux stores
 * example from BaseContainer:
 *    export default FluxStoreAwareComponent(['UserStore', 'RouterStore'], getStateFromFlux)(BaseContainer);
 * */
/* harmony default export */ __webpack_exports__["a"] = (function (storeNames) {
  return function (WrappedComponent) {
    var _class, _temp;

    var displayName = WrappedComponent.displayName || WrappedComponent.name || 'Component';

    validateWrappedComponentMethods(WrappedComponent.prototype, displayName);
    initializeWrappedComponentStateMethods(WrappedComponent);

    var getStateFromFlux = WrappedComponent.prototype.getStateFromFlux;
    var updateStateFromFlux = WrappedComponent.prototype.updateStateFromFlux;

    return _temp = _class = function (_Component) {
      _inherits(FluxStoreAwareComponent, _Component);

      function FluxStoreAwareComponent(props) {
        _classCallCheck(this, FluxStoreAwareComponent);

        var _this = _possibleConstructorReturn(this, (FluxStoreAwareComponent.__proto__ || Object.getPrototypeOf(FluxStoreAwareComponent)).call(this, props));

        _this.handleStoresChanged = _this.handleStoresChanged.bind(_this);

        // reference to the wrapped container so that we can call instance methods on it with the correct
        // "this" context
        _this.decoratedRef = null;
        return _this;
      }

      _createClass(FluxStoreAwareComponent, [{
        key: 'componentWillMount',
        value: function componentWillMount() {
          var _this2 = this;

          var flux = this.props.flux || this.context.flux;
          this.mounted = true;

          __WEBPACK_IMPORTED_MODULE_2_lodash_forEach___default()(storeNames, function (store) {
            flux.store(store).on("change", _this2.handleStoresChanged);
          }, this);
        }
      }, {
        key: 'componentDidMount',
        value: function componentDidMount() {
          this.handleStoresChanged();
        }
      }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
          if (!__WEBPACK_IMPORTED_MODULE_1_react_pure_render_shallowEqual___default()(nextProps, this.props)) {
            this.handleStoresChanged();
          }
        }
      }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
          var _this3 = this;

          var flux = this.props.flux || this.context.flux;
          this.mounted = false;
          __WEBPACK_IMPORTED_MODULE_2_lodash_forEach___default()(storeNames, function (store) {
            flux.store(store).removeListener("change", _this3.handleStoresChanged);
          });
        }
      }, {
        key: 'getChildContext',
        value: function getChildContext() {
          return {
            flux: this.getFlux()
          };
        }
      }, {
        key: 'getFlux',
        value: function getFlux() {
          return this.props.flux || this.context && this.context.flux;
        }
      }, {
        key: 'getActions',
        value: function getActions() {
          var flux = this.getFlux();
          if (flux) {
            return flux.actions;
          }
          throw new Error("Could not find flux on this.props or this.context");
        }
      }, {
        key: 'handleStoresChanged',
        value: function handleStoresChanged() {
          if (!getStateFromFlux) {
            console.log('[BUG] You took a dependency on FluxStoreAwareComponent without defining a setStateFromFlux method');
          }
          if (this.mounted && this.decoratedRef && getStateFromFlux) {
            var flux = this.props.flux || this.context.flux;
            updateStateFromFlux.call(this.decoratedRef, flux);
          }
        }
      }, {
        key: 'render',
        value: function render() {
          var _this4 = this;

          return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(WrappedComponent, _extends({
            ref: function ref(e) {
              return _this4.decoratedRef = e;
            }
          }, this.props, this.state, {

            getFlux: this.getFlux,
            flux: this.getFlux(),
            actions: this.getActions()
          }));
        }
      }]);

      return FluxStoreAwareComponent;
    }(__WEBPACK_IMPORTED_MODULE_0_react__["Component"]), _class.displayName = 'FluxStoreAwareComponent(' + displayName + ')', _class.childContextTypes = {
      flux: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.object
    }, _class.contextTypes = {
      flux: __WEBPACK_IMPORTED_MODULE_3_prop_types___default.a.object
    }, _temp;
  };
});

/**
 * Throw if a wrapped component defines a property named with one of the methods we overwrite
 * */
var methodNameKeys = ['getInitialState', 'updateStateFromFlux'];
var validateWrappedComponentMethods = function validateWrappedComponentMethods(wrappedComponent, displayName) {
  __WEBPACK_IMPORTED_MODULE_2_lodash_forEach___default()(methodNameKeys, function (key) {
    if (wrappedComponent[key]) {
      throw new Error('Component: ' + displayName + ' is wrapped by FluxStoreAwareComponent and cannot define ' + key);
    }
  });
};

/**
 * Add lifecycle methods to the component so we can set state in a way that is semantically the same as Fluxxor
 * */
var initializeWrappedComponentStateMethods = function initializeWrappedComponentStateMethods(wrappedComponent) {
  if (!wrappedComponent.prototype.getInitialState) {
    wrappedComponent.prototype.getInitialState = function () {
      if (!this.props.flux) {
        return {};
      }
      var state = wrappedComponent.prototype.getStateFromFlux.call(this, this.props.flux);
      return state;
    };
  }
  if (!wrappedComponent.prototype.updateStateFromFlux) {
    wrappedComponent.prototype.updateStateFromFlux = function (flux) {
      var state = wrappedComponent.prototype.getStateFromFlux.call(this, flux);
      this.setState(state);
    };
  }
};

/***/ }),
/* 172 */,
/* 173 */,
/* 174 */,
/* 175 */,
/* 176 */,
/* 177 */,
/* 178 */,
/* 179 */,
/* 180 */
/***/ (function(module, exports) {

var charenc = {
  // UTF-8 encoding
  utf8: {
    // Convert a string to a byte array
    stringToBytes: function(str) {
      return charenc.bin.stringToBytes(unescape(encodeURIComponent(str)));
    },

    // Convert a byte array to a string
    bytesToString: function(bytes) {
      return decodeURIComponent(escape(charenc.bin.bytesToString(bytes)));
    }
  },

  // Binary encoding
  bin: {
    // Convert a string to a byte array
    stringToBytes: function(str) {
      for (var bytes = [], i = 0; i < str.length; i++)
        bytes.push(str.charCodeAt(i) & 0xFF);
      return bytes;
    },

    // Convert a byte array to a string
    bytesToString: function(bytes) {
      for (var str = [], i = 0; i < bytes.length; i++)
        str.push(String.fromCharCode(bytes[i]));
      return str.join('');
    }
  }
};

module.exports = charenc;


/***/ }),
/* 181 */,
/* 182 */,
/* 183 */,
/* 184 */,
/* 185 */,
/* 186 */,
/* 187 */,
/* 188 */,
/* 189 */,
/* 190 */,
/* 191 */,
/* 192 */,
/* 193 */,
/* 194 */,
/* 195 */,
/* 196 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["c"] = onStyleElementContextMenu;
/* harmony export (immutable) */ __webpack_exports__["b"] = onSectionContextMenu;
/* harmony export (immutable) */ __webpack_exports__["a"] = onFolderContextMenu;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__sketch__ = __webpack_require__(18);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__util__ = __webpack_require__(12);
var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };




var entityDescriptors = __WEBPACK_IMPORTED_MODULE_1__util__["m" /* getEntityDescriptors */]();

function onStyleElementContextMenu(source, entityType, event, element, sectionId) {

  var menuItems = [{ key: 'rename', value: 'Rename' }, { key: 'delete', value: 'Delete' }];

  if (entityType === entityDescriptors.typeStyles.key) {
    menuItems.push({ key: 'set-text-color', value: 'Set Text Color' });
  }

  createNativeContextMenu(event, {
    itemName: element.name,
    element: element,
    type: entityType,
    enclosingType: __WEBPACK_IMPORTED_MODULE_1__util__["i" /* enclosingTypeForEntity */](entityType),
    enclosingID: sectionId,
    elementID: element._id,
    source: source,
    menuItems: menuItems
  });
}

function onSectionContextMenu(source, entityType, event, section) {
  createNativeContextMenu(event, {
    itemName: section.name,
    type: __WEBPACK_IMPORTED_MODULE_1__util__["i" /* enclosingTypeForEntity */](entityType),
    elementID: section._id,
    sortMode: section.sortMode,
    source: source,
    menuItems: [{ key: 'rename', value: 'Rename' }, { key: 'delete', value: 'Delete' }, { key: 'sort' }]
  });
}

function onFolderContextMenu(source, event, folder) {

  var entityType = __WEBPACK_IMPORTED_MODULE_1__util__["m" /* getEntityDescriptors */]()[folder.folderEntityType];
  var menuItems = [{ key: 'rename', value: 'Rename' }];

  if (entityType.deletable || folder.deletable) {
    menuItems.push({ key: 'delete', value: 'Delete' });
  }

  if (!entityType.enclosingType) {
    menuItems.push({ key: 'sort' });
  }

  createNativeContextMenu(event, {
    type: folder.folderEntityType,
    folderId: folder._id,
    sortMode: folder.sortMode,
    source: source,
    menuItems: menuItems
  });
}

function createNativeContextMenu(event, data) {
  __WEBPACK_IMPORTED_MODULE_0__sketch__["g" /* postNativeUIEvent */]('onContextMenu', _extends({
    x: event.clientX,
    y: event.clientY
  }, data));
}

/***/ }),
/* 197 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return RichTextEditorWithCustomLinks; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react_quill__ = __webpack_require__(198);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react_quill___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react_quill__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__brandai_design_systems_web__ = __webpack_require__(42);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__brandai_design_systems_web___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3__brandai_design_systems_web__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__sketch_native_events__ = __webpack_require__(16);
var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _class, _temp;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }







var RichTextEditor = __WEBPACK_IMPORTED_MODULE_3__brandai_design_systems_web__["compositeComponents"].RichTextEditor;

// fix for links without protocol in sketch plugin (would get about:blank, and we want to change that)
var Link = __WEBPACK_IMPORTED_MODULE_1_react_quill___default.a.Quill.import('formats/link');

var SketchSupportedLink = function (_Link) {
  _inherits(SketchSupportedLink, _Link);

  function SketchSupportedLink() {
    _classCallCheck(this, SketchSupportedLink);

    return _possibleConstructorReturn(this, (SketchSupportedLink.__proto__ || Object.getPrototypeOf(SketchSupportedLink)).apply(this, arguments));
  }

  _createClass(SketchSupportedLink, [{
    key: 'format',


    // called when editing an existing link
    value: function format(name, value) {
      _get(SketchSupportedLink.prototype.__proto__ || Object.getPrototypeOf(SketchSupportedLink.prototype), 'format', this).call(this, name, value);
      SketchSupportedLink.fixUrl(this.domNode, value);
    }

    /**
     * helper method to fix 'about:blank' in href (put there by quill because relative links with no protocol are
     * considered invalid under Sketch - they get a wrong protocol by default)
     */

  }], [{
    key: 'create',


    // called when creating a new link
    value: function create(value) {
      var node = _get(SketchSupportedLink.__proto__ || Object.getPrototypeOf(SketchSupportedLink), 'create', this).call(this, value);
      SketchSupportedLink.fixUrl(node, value);
      SketchSupportedLink.fixLinkInReadOnlyMode(node);
      return node;
    }
  }, {
    key: 'fixUrl',
    value: function fixUrl(node, value) {
      if (node.getAttribute('href').startsWith('about:blank')) {
        node.setAttribute('href', 'http://' + value);
      }
    }

    /**
     * call openURLInBrowser for links that are in a readonly editor
     * only required in readonly, otherwise handled by the link tooltip when editing (see performQuillAdjustments)
     */

  }, {
    key: 'fixLinkInReadOnlyMode',
    value: function fixLinkInReadOnlyMode(node) {
      node.addEventListener('click', function (e) {
        if (SketchSupportedLink.isInsideReadOnlyEditor(e.target)) {
          Object(__WEBPACK_IMPORTED_MODULE_4__sketch_native_events__["openURLInBrowser"])(e.target.getAttribute('href'));
          e.preventDefault();
        }
      });
    }

    /**
     * checks if element is within a readonly editor
     */

  }, {
    key: 'isInsideReadOnlyEditor',
    value: function isInsideReadOnlyEditor(element) {
      return element.closest('.c-rich-text-editor--readonly') != null;
    }
  }]);

  return SketchSupportedLink;
}(Link);

__WEBPACK_IMPORTED_MODULE_1_react_quill___default.a.Quill.register(SketchSupportedLink);

var RichTextEditorWithCustomLinks = (_temp = _class = function (_React$Component) {
  _inherits(RichTextEditorWithCustomLinks, _React$Component);

  function RichTextEditorWithCustomLinks() {
    _classCallCheck(this, RichTextEditorWithCustomLinks);

    return _possibleConstructorReturn(this, (RichTextEditorWithCustomLinks.__proto__ || Object.getPrototypeOf(RichTextEditorWithCustomLinks)).apply(this, arguments));
  }

  _createClass(RichTextEditorWithCustomLinks, [{
    key: 'render',
    value: function render() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(RichTextEditor, _extends({}, this.props, { linksClickHandler: function linksClickHandler(href) {
          return Object(__WEBPACK_IMPORTED_MODULE_4__sketch_native_events__["openURLInBrowser"])(href);
        } }));
    }
  }]);

  return RichTextEditorWithCustomLinks;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component), _class.propTypes = {
  className: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string,
  /**
   * delta value
   */
  value: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string,
  /**
   * current value (in markdown)
   */
  legacyValue: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string,
  readOnly: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool,
  placeholder: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string,
  /**
   * called when leaving edit mode and the data had changed
   */
  onFinishedEditing: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func,
  updateErrorOccurred: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.bool,
  onFocus: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func,
  /**
   * called any time the component loses focus
   */
  onLostFocus: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func,
  linkPlaceholder: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string
}, _temp);


/***/ }),
/* 198 */,
/* 199 */,
/* 200 */,
/* 201 */,
/* 202 */,
/* 203 */,
/* 204 */,
/* 205 */,
/* 206 */,
/* 207 */,
/* 208 */,
/* 209 */,
/* 210 */,
/* 211 */,
/* 212 */,
/* 213 */,
/* 214 */,
/* 215 */,
/* 216 */,
/* 217 */,
/* 218 */,
/* 219 */,
/* 220 */,
/* 221 */,
/* 222 */,
/* 223 */,
/* 224 */,
/* 225 */,
/* 226 */,
/* 227 */,
/* 228 */,
/* 229 */,
/* 230 */,
/* 231 */,
/* 232 */,
/* 233 */,
/* 234 */,
/* 235 */,
/* 236 */,
/* 237 */,
/* 238 */,
/* 239 */,
/* 240 */,
/* 241 */,
/* 242 */,
/* 243 */,
/* 244 */,
/* 245 */,
/* 246 */,
/* 247 */,
/* 248 */,
/* 249 */,
/* 250 */,
/* 251 */,
/* 252 */,
/* 253 */,
/* 254 */,
/* 255 */,
/* 256 */,
/* 257 */,
/* 258 */,
/* 259 */,
/* 260 */,
/* 261 */,
/* 262 */,
/* 263 */,
/* 264 */,
/* 265 */,
/* 266 */,
/* 267 */,
/* 268 */,
/* 269 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__BaseTile__ = __webpack_require__(79);




/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var readOnly = _ref.readOnly,
      name = _ref.name,
      updateErrorOccurred = _ref.updateErrorOccurred,
      _ref$thumbnailSize = _ref.thumbnailSize,
      thumbnailSize = _ref$thumbnailSize === undefined ? 40 : _ref$thumbnailSize,
      thumbnailURL = _ref.thumbnailURL,
      onMenu = _ref.onMenu,
      onSelect = _ref.onSelect,
      onPreviewEntity = _ref.onPreviewEntity,
      editing = _ref.editing,
      onBeginEditItem = _ref.onBeginEditItem,
      onCancelEditItem = _ref.onCancelEditItem,
      onRename = _ref.onRename,
      customHeight = _ref.customHeight,
      namePlaceholder = _ref.namePlaceholder,
      onStyleDragStart = _ref.onStyleDragStart,
      onStyleDragEnd = _ref.onStyleDragEnd,
      _ref$draggable = _ref.draggable,
      draggable = _ref$draggable === undefined ? true : _ref$draggable;


  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    __WEBPACK_IMPORTED_MODULE_1__BaseTile__["a" /* default */],
    {
      readOnly: readOnly,
      onMenu: onMenu,
      onSelect: onSelect,
      onPreviewEntity: onPreviewEntity,
      customHeight: customHeight,
      name: name,
      updateErrorOccurred: updateErrorOccurred,
      editing: editing,
      onBeginEdit: onBeginEditItem,
      onCancelEdit: onCancelEditItem,
      onFinishedEditing: onRename,
      defaultValue: namePlaceholder,
      onDragStart: onStyleDragStart,
      onDragEnd: onStyleDragEnd,
      draggable: draggable
    },
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement('img', {
      src: thumbnailURL,
      width: thumbnailSize,
      height: thumbnailSize,
      draggable: false
    })
  );
});

/***/ }),
/* 270 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__components_library_ImagePreview__ = __webpack_require__(271);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__shared_constants__ = __webpack_require__(41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__shared_constants___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2__shared_constants__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__BaseTile__ = __webpack_require__(79);






var IMAGE_TILE_PADDING = 8;

/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var image = _ref.image,
      size = _ref.size,
      preferPngFormat = _ref.preferPngFormat,
      readOnly = _ref.readOnly,
      editing = _ref.editing,
      onBeginEditItem = _ref.onBeginEditItem,
      onCancelEditItem = _ref.onCancelEditItem,
      onRenameImage = _ref.onRenameImage,
      onImageDragEnd = _ref.onImageDragEnd,
      onImageDragStart = _ref.onImageDragStart,
      onImageContextMenu = _ref.onImageContextMenu,
      onPreviewEntity = _ref.onPreviewEntity,
      _ref$draggable = _ref.draggable,
      draggable = _ref$draggable === undefined ? true : _ref$draggable,
      selected = _ref.selected,
      customHeight = _ref.customHeight,
      namePlaceholder = _ref.namePlaceholder;


  var colorObject = image.backgroundColorObject;
  var backgroundColor = colorObject && colorObject._id !== 'white' ? colorObject.value : null;

  var expectedWidth = __WEBPACK_IMPORTED_MODULE_2__shared_constants__["gridSize"][size] - 2 * IMAGE_TILE_PADDING;

  //todo: the customClass name is used for selection once it will be prt of baseTile it should be remove from here
  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    __WEBPACK_IMPORTED_MODULE_3__BaseTile__["a" /* default */],
    {
      readOnly: readOnly,
      onMenu: onImageContextMenu,
      customHeight: customHeight,
      tileSize: size,
      editing: editing,
      onBeginEdit: onBeginEditItem,
      onCancelEdit: onCancelEditItem,
      onFinishedEditing: onRenameImage,
      name: image.name,
      updateErrorOccurred: image.updateErrorOccurred,
      defaultValue: namePlaceholder,
      selected: selected,
      onPreviewEntity: onPreviewEntity
    },
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'div',
      {
        className: 'c-image-tile',
        style: { background: backgroundColor }
      },
      __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_1__components_library_ImagePreview__["a" /* default */], {
        image: image,
        draggable: draggable,
        onDragEnd: onImageDragEnd,
        onDragStart: onImageDragStart,
        expectedWidth: expectedWidth,
        preferPngFormat: preferPngFormat
      })
    )
  );
});

/***/ }),
/* 271 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_design_systems_lib__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_design_systems_lib___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_design_systems_lib__);




/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var image = _ref.image,
      draggable = _ref.draggable,
      _onDragEnd = _ref.onDragEnd,
      _onDragStart = _ref.onDragStart,
      expectedHeight = _ref.expectedHeight,
      expectedWidth = _ref.expectedWidth,
      _ref$preferPngFormat = _ref.preferPngFormat,
      preferPngFormat = _ref$preferPngFormat === undefined ? true : _ref$preferPngFormat,
      useOrignalImage = _ref.useOrignalImage;


  var style = {
    width: '100%',
    height: '100%'
  };

  expectedHeight = expectedHeight || expectedWidth;

  var previewImageFile = void 0;
  if (useOrignalImage) {
    var dimensions = __WEBPACK_IMPORTED_MODULE_2_design_systems_lib__["utils"].parseDimensions(image.dimensions);
    previewImageFile = __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.merge({}, image, dimensions);
  } else {
    previewImageFile = __WEBPACK_IMPORTED_MODULE_2_design_systems_lib__["utils"].getPreviewImageFile(image, {
      preferredMaxWidth: expectedWidth,
      preferredMaxHeight: expectedHeight,
      format: preferPngFormat ? 'png' : null
    });
  }

  var doesFit = __WEBPACK_IMPORTED_MODULE_2_design_systems_lib__["utils"].doesImageFitInContainer(previewImageFile, {
    width: expectedWidth,
    height: expectedHeight
  });

  // The CSS object-fit value 'contain' is exactly
  // what we want UNLESS the container area is larger than
  // the image to be displayed. In that case, we would not
  // like the image to be scaled up larger than 1:1, which
  // 'contain' will do.
  style.objectFit = doesFit ? 'none' : 'contain';

  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement('img', {
    onDragEnd: function onDragEnd(evt) {
      if (_onDragEnd) {
        _onDragEnd(evt);
      }
    },
    onDragStart: function onDragStart(evt) {
      if (_onDragStart) {
        _onDragStart(evt);
      }
    },
    draggable: draggable,
    style: style,
    src: previewImageFile.url
  });
});

/***/ }),
/* 272 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = {
  above: 'above',
  inside: 'inside',
  below: 'below',
  invisible: 'invisible'
};
module.exports = exports['default'];

/***/ }),
/* 273 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// Convenience main entrypoint if you are running with destructuring support:
//
//   import {VelocityComponent, VelocityTransitionGroup} from 'velocity-react';
//
// You can also require just the component(s) you're using:
//
//   var VelocityComponent = require('velocity-react/velocity-component');
//
// Note that if you want to use UI Pack you will need to require 'velocity' and
// 'velocity.ui' at a top level in your app:
//
//   require('velocity');
//   require('velocity-animate/velocity.ui');

module.exports = {
  VelocityComponent: __webpack_require__(882),
  VelocityTransitionGroup: __webpack_require__(884),
  velocityHelpers: __webpack_require__(888)
};

/***/ }),
/* 274 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddTreeNode; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_classnames__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_classnames__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__components_library_Icon__ = __webpack_require__(34);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }








var ENTER_KEY = 13;
var ESC_KEY = 27;

var DEFAULT_VALUE = 'Folder Name';

var AddTreeNode = (_temp = _class = function (_React$Component) {
  _inherits(AddTreeNode, _React$Component);

  function AddTreeNode(props) {
    _classCallCheck(this, AddTreeNode);

    var _this = _possibleConstructorReturn(this, (AddTreeNode.__proto__ || Object.getPrototypeOf(AddTreeNode)).call(this, props));

    _this.beginAddingNode = function () {
      if (_this.props.onSelect) {
        _this.props.onSelect();
      }

      _this.setState({ editing: true });
    };

    _this.onAddTreeNode = function (name) {
      if (__WEBPACK_IMPORTED_MODULE_0_lodash___default.a.isEmpty(name) || name === DEFAULT_VALUE) {
        _this.cancelAddNode();
        return;
      }

      _this.props.onAddTreeNode(name);
      _this.setState({ editing: false });
    };

    _this.cancelAddNode = function () {
      _this.setState({ editing: false });

      if (_this.props.onCancel) {
        _this.props.onCancel();
      }
    };

    _this.onKeyDown = function (event) {
      if (event.keyCode === ESC_KEY) {

        event.preventDefault();
        _this.cancelAddNode();
      } else if (event.keyCode === ENTER_KEY) {

        event.preventDefault();
        _this.onAddTreeNode(event.target.value);
      }
    };

    _this.renderContent = function () {
      if (_this.state.editing) {
        return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement('input', {
          className: 'c-add-tree-node__input',
          autoFocus: true,
          defaultValue: DEFAULT_VALUE,
          onKeyDown: _this.onKeyDown,
          onFocus: function onFocus(event) {
            return event.target.select();
          },
          onBlur: function onBlur(event) {
            return _this.onAddTreeNode(event.target.value);
          }
        });
      }

      return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
        'div',
        { className: 'c-add-tree-node__container' },
        __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__components_library_Icon__["a" /* default */], { size: 10, glyph: 'plus', className: 'c-add-tree-node__icon' }),
        __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
          'div',
          { className: 'c-add-tree-node__text' },
          'Add Folder'
        )
      );
    };

    _this.state = { editing: false };
    return _this;
  }

  _createClass(AddTreeNode, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var className = __WEBPACK_IMPORTED_MODULE_3_classnames___default()('c-add-tree-node', { 'c-add-tree-node--active': this.state.editing });

      return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
        'div',
        {
          title: 'Add Folder',
          className: className,
          onClick: function onClick() {
            return _this2.beginAddingNode();
          }
        },
        this.renderContent()
      );
    }
  }]);

  return AddTreeNode;
}(__WEBPACK_IMPORTED_MODULE_1_react___default.a.Component), _class.propTypes = {
  onAddTreeNode: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func,
  onSelect: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func,
  onCancel: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func
}, _temp);


/***/ }),
/* 275 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.default = enhanceWithRadium;

var _react = __webpack_require__(0);

var _propTypes = __webpack_require__(1);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _styleKeeper = __webpack_require__(155);

var _styleKeeper2 = _interopRequireDefault(_styleKeeper);

var _resolveStyles = __webpack_require__(276);

var _resolveStyles2 = _interopRequireDefault(_resolveStyles);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var KEYS_TO_IGNORE_WHEN_COPYING_PROPERTIES = ['arguments', 'callee', 'caller', 'length', 'name', 'prototype', 'type'];

function copyProperties(source, target) {
  Object.getOwnPropertyNames(source).forEach(function (key) {
    if (KEYS_TO_IGNORE_WHEN_COPYING_PROPERTIES.indexOf(key) < 0 && !target.hasOwnProperty(key)) {
      var descriptor = Object.getOwnPropertyDescriptor(source, key);
      Object.defineProperty(target, key, descriptor);
    }
  });
}

function isStateless(component) {
  return !component.render && !(component.prototype && component.prototype.render);
}

// Check if value is a real ES class in Native / Node code.
// See: https://stackoverflow.com/a/30760236
function isNativeClass(component) {
  return typeof component === 'function' && /^\s*class\s+/.test(component.toString());
}

// Manually apply babel-ish class inheritance.
function inherits(subClass, superClass) {
  if (typeof superClass !== 'function' && superClass !== null) {
    throw new TypeError('Super expression must either be null or a function, not ' + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });

  if (superClass) {
    if (Object.setPrototypeOf) {
      Object.setPrototypeOf(subClass, superClass);
    } else {
      subClass.__proto__ = superClass; // eslint-disable-line no-proto
    }
  }
}

function enhanceWithRadium(configOrComposedComponent) {
  var _class, _temp;

  var config = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  if (typeof configOrComposedComponent !== 'function') {
    var newConfig = _extends({}, config, configOrComposedComponent);
    return function (configOrComponent) {
      return enhanceWithRadium(configOrComponent, newConfig);
    };
  }

  var component = configOrComposedComponent;
  var ComposedComponent = component;

  // Handle Native ES classes.
  if (isNativeClass(ComposedComponent)) {
    // Manually approximate babel's class transpilation, but _with_ a real `new` call.
    ComposedComponent = function (OrigComponent) {
      function NewComponent() {
        // Ordinarily, babel would produce something like:
        //
        // ```
        // return _possibleConstructorReturn(this, OrigComponent.apply(this, arguments));
        // ```
        //
        // Instead, we just call `new` directly without the `_possibleConstructorReturn` wrapper.
        var source = new (Function.prototype.bind.apply(OrigComponent, [null].concat(Array.prototype.slice.call(arguments))))();

        // Then we manually update context with properties.
        copyProperties(source, this);

        return this;
      }

      inherits(NewComponent, OrigComponent);

      return NewComponent;
    }(ComposedComponent);
  }

  // Handle stateless components
  if (isStateless(ComposedComponent)) {
    ComposedComponent = function (_Component) {
      _inherits(ComposedComponent, _Component);

      function ComposedComponent() {
        _classCallCheck(this, ComposedComponent);

        return _possibleConstructorReturn(this, _Component.apply(this, arguments));
      }

      ComposedComponent.prototype.render = function render() {
        return component(this.props, this.context);
      };

      return ComposedComponent;
    }(_react.Component);

    ComposedComponent.displayName = component.displayName || component.name;
  }

  var RadiumEnhancer = (_temp = _class = function (_ComposedComponent) {
    _inherits(RadiumEnhancer, _ComposedComponent);

    function RadiumEnhancer() {
      _classCallCheck(this, RadiumEnhancer);

      var _this2 = _possibleConstructorReturn(this, _ComposedComponent.apply(this, arguments));

      _this2.state = _this2.state || {};
      _this2.state._radiumStyleState = {};
      _this2._radiumIsMounted = true;
      return _this2;
    }

    RadiumEnhancer.prototype.componentWillUnmount = function componentWillUnmount() {
      if (_ComposedComponent.prototype.componentWillUnmount) {
        _ComposedComponent.prototype.componentWillUnmount.call(this);
      }

      this._radiumIsMounted = false;

      if (this._radiumMouseUpListener) {
        this._radiumMouseUpListener.remove();
      }

      if (this._radiumMediaQueryListenersByQuery) {
        Object.keys(this._radiumMediaQueryListenersByQuery).forEach(function (query) {
          this._radiumMediaQueryListenersByQuery[query].remove();
        }, this);
      }
    };

    RadiumEnhancer.prototype.getChildContext = function getChildContext() {
      var superChildContext = _ComposedComponent.prototype.getChildContext ? _ComposedComponent.prototype.getChildContext.call(this) : {};

      if (!this.props.radiumConfig) {
        return superChildContext;
      }

      var newContext = _extends({}, superChildContext);

      if (this.props.radiumConfig) {
        newContext._radiumConfig = this.props.radiumConfig;
      }

      return newContext;
    };

    RadiumEnhancer.prototype.render = function render() {
      var renderedElement = _ComposedComponent.prototype.render.call(this);
      var currentConfig = this.props.radiumConfig || this.context._radiumConfig || config;

      if (config && currentConfig !== config) {
        currentConfig = _extends({}, config, currentConfig);
      }

      return (0, _resolveStyles2.default)(this, renderedElement, currentConfig);
    };

    return RadiumEnhancer;
  }(ComposedComponent), _class._isRadiumEnhanced = true, _temp);

  // Class inheritance uses Object.create and because of __proto__ issues
  // with IE <10 any static properties of the superclass aren't inherited and
  // so need to be manually populated.
  // See http://babeljs.io/docs/advanced/caveats/#classes-10-and-below-

  copyProperties(component, RadiumEnhancer);

  if (process.env.NODE_ENV !== 'production') {
    // This also fixes React Hot Loader by exposing the original components top
    // level prototype methods on the Radium enhanced prototype as discussed in
    // https://github.com/FormidableLabs/radium/issues/219.
    copyProperties(ComposedComponent.prototype, RadiumEnhancer.prototype);
  }

  if (RadiumEnhancer.propTypes && RadiumEnhancer.propTypes.style) {
    RadiumEnhancer.propTypes = _extends({}, RadiumEnhancer.propTypes, {
      style: _propTypes2.default.oneOfType([_propTypes2.default.array, _propTypes2.default.object])
    });
  }

  RadiumEnhancer.displayName = component.displayName || component.name || 'Component';

  RadiumEnhancer.contextTypes = _extends({}, RadiumEnhancer.contextTypes, {
    _radiumConfig: _propTypes2.default.object,
    _radiumStyleKeeper: _propTypes2.default.instanceOf(_styleKeeper2.default)
  });

  RadiumEnhancer.childContextTypes = _extends({}, RadiumEnhancer.childContextTypes, {
    _radiumConfig: _propTypes2.default.object,
    _radiumStyleKeeper: _propTypes2.default.instanceOf(_styleKeeper2.default)
  });

  return RadiumEnhancer;
}
module.exports = exports['default'];
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(11)))

/***/ }),
/* 276 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _appendImportantToEachValue = __webpack_require__(892);

var _appendImportantToEachValue2 = _interopRequireDefault(_appendImportantToEachValue);

var _cssRuleSetToString = __webpack_require__(156);

var _cssRuleSetToString2 = _interopRequireDefault(_cssRuleSetToString);

var _getState = __webpack_require__(282);

var _getState2 = _interopRequireDefault(_getState);

var _getStateKey = __webpack_require__(283);

var _getStateKey2 = _interopRequireDefault(_getStateKey);

var _hash = __webpack_require__(284);

var _hash2 = _interopRequireDefault(_hash);

var _mergeStyles = __webpack_require__(922);

var _plugins = __webpack_require__(285);

var _plugins2 = _interopRequireDefault(_plugins);

var _exenv = __webpack_require__(932);

var _exenv2 = _interopRequireDefault(_exenv);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DEFAULT_CONFIG = {
  plugins: [_plugins2.default.mergeStyleArray, _plugins2.default.checkProps, _plugins2.default.resolveMediaQueries, _plugins2.default.resolveInteractionStyles, _plugins2.default.keyframes, _plugins2.default.visited, _plugins2.default.removeNestedStyles, _plugins2.default.prefix, _plugins2.default.checkProps]
};

// Gross
var globalState = {};

// Declare early for recursive helpers.
var resolveStyles = null;

var _shouldResolveStyles = function _shouldResolveStyles(component) {
  return component.type && !component.type._isRadiumEnhanced;
};

var _resolveChildren = function _resolveChildren(_ref) {
  var children = _ref.children,
      component = _ref.component,
      config = _ref.config,
      existingKeyMap = _ref.existingKeyMap;

  if (!children) {
    return children;
  }

  var childrenType = typeof children === 'undefined' ? 'undefined' : _typeof(children);

  if (childrenType === 'string' || childrenType === 'number') {
    // Don't do anything with a single primitive child
    return children;
  }

  if (childrenType === 'function') {
    // Wrap the function, resolving styles on the result
    return function () {
      var result = children.apply(this, arguments);
      if (_react2.default.isValidElement(result)) {
        return resolveStyles(component, result, config, existingKeyMap, true);
      }
      return result;
    };
  }

  if (_react2.default.Children.count(children) === 1 && children.type) {
    // If a React Element is an only child, don't wrap it in an array for
    // React.Children.map() for React.Children.only() compatibility.
    var onlyChild = _react2.default.Children.only(children);
    return resolveStyles(component, onlyChild, config, existingKeyMap, true);
  }

  return _react2.default.Children.map(children, function (child) {
    if (_react2.default.isValidElement(child)) {
      return resolveStyles(component, child, config, existingKeyMap, true);
    }

    return child;
  });
};

// Recurse over props, just like children
var _resolveProps = function _resolveProps(_ref2) {
  var component = _ref2.component,
      config = _ref2.config,
      existingKeyMap = _ref2.existingKeyMap,
      props = _ref2.props;

  var newProps = props;

  Object.keys(props).forEach(function (prop) {
    // We already recurse over children above
    if (prop === 'children') {
      return;
    }

    var propValue = props[prop];
    if (_react2.default.isValidElement(propValue)) {
      newProps = _extends({}, newProps);
      newProps[prop] = resolveStyles(component, propValue, config, existingKeyMap, true);
    }
  });

  return newProps;
};

var _buildGetKey = function _buildGetKey(_ref3) {
  var componentName = _ref3.componentName,
      existingKeyMap = _ref3.existingKeyMap,
      renderedElement = _ref3.renderedElement;

  // We need a unique key to correlate state changes due to user interaction
  // with the rendered element, so we know to apply the proper interactive
  // styles.
  var originalKey = typeof renderedElement.ref === 'string' ? renderedElement.ref : renderedElement.key;
  var key = (0, _getStateKey2.default)(originalKey);

  var alreadyGotKey = false;
  var getKey = function getKey() {
    if (alreadyGotKey) {
      return key;
    }

    alreadyGotKey = true;

    if (existingKeyMap[key]) {
      var elementName = void 0;
      if (typeof renderedElement.type === 'string') {
        elementName = renderedElement.type;
      } else if (renderedElement.type.constructor) {
        elementName = renderedElement.type.constructor.displayName || renderedElement.type.constructor.name;
      }

      throw new Error('Radium requires each element with interactive styles to have a unique ' + 'key, set using either the ref or key prop. ' + (originalKey ? 'Key "' + originalKey + '" is a duplicate.' : 'Multiple elements have no key specified.') + ' ' + 'Component: "' + componentName + '". ' + (elementName ? 'Element: "' + elementName + '".' : ''));
    }

    existingKeyMap[key] = true;

    return key;
  };

  return getKey;
};

var _setStyleState = function _setStyleState(component, key, stateKey, value) {
  if (!component._radiumIsMounted) {
    return;
  }

  var existing = component._lastRadiumState || component.state && component.state._radiumStyleState || {};

  var state = { _radiumStyleState: _extends({}, existing) };
  state._radiumStyleState[key] = _extends({}, state._radiumStyleState[key]);
  state._radiumStyleState[key][stateKey] = value;

  component._lastRadiumState = state._radiumStyleState;
  component.setState(state);
};

var _runPlugins = function _runPlugins(_ref4) {
  var component = _ref4.component,
      config = _ref4.config,
      existingKeyMap = _ref4.existingKeyMap,
      props = _ref4.props,
      renderedElement = _ref4.renderedElement;

  // Don't run plugins if renderedElement is not a simple ReactDOMElement or has
  // no style.
  if (!_react2.default.isValidElement(renderedElement) || typeof renderedElement.type !== 'string' || !props.style) {
    return props;
  }

  var newProps = props;

  var plugins = config.plugins || DEFAULT_CONFIG.plugins;

  var componentName = component.constructor.displayName || component.constructor.name;
  var getKey = _buildGetKey({
    renderedElement: renderedElement,
    existingKeyMap: existingKeyMap,
    componentName: componentName
  });
  var getComponentField = function getComponentField(key) {
    return component[key];
  };
  var getGlobalState = function getGlobalState(key) {
    return globalState[key];
  };
  var componentGetState = function componentGetState(stateKey, elementKey) {
    return (0, _getState2.default)(component.state, elementKey || getKey(), stateKey);
  };
  var setState = function setState(stateKey, value, elementKey) {
    return _setStyleState(component, elementKey || getKey(), stateKey, value);
  };

  var addCSS = function addCSS(css) {
    var styleKeeper = component._radiumStyleKeeper || component.context._radiumStyleKeeper;
    if (!styleKeeper) {
      if (__isTestModeEnabled) {
        return {
          remove: function remove() {}
        };
      }

      throw new Error('To use plugins requiring `addCSS` (e.g. keyframes, media queries), ' + 'please wrap your application in the StyleRoot component. Component ' + 'name: `' + componentName + '`.');
    }

    return styleKeeper.addCSS(css);
  };

  var newStyle = props.style;

  plugins.forEach(function (plugin) {
    var result = plugin({
      ExecutionEnvironment: _exenv2.default,
      addCSS: addCSS,
      appendImportantToEachValue: _appendImportantToEachValue2.default,
      componentName: componentName,
      config: config,
      cssRuleSetToString: _cssRuleSetToString2.default,
      getComponentField: getComponentField,
      getGlobalState: getGlobalState,
      getState: componentGetState,
      hash: _hash2.default,
      mergeStyles: _mergeStyles.mergeStyles,
      props: newProps,
      setState: setState,
      isNestedStyle: _mergeStyles.isNestedStyle,
      style: newStyle
    }) || {};

    newStyle = result.style || newStyle;

    newProps = result.props && Object.keys(result.props).length ? _extends({}, newProps, result.props) : newProps;

    var newComponentFields = result.componentFields || {};
    Object.keys(newComponentFields).forEach(function (fieldName) {
      component[fieldName] = newComponentFields[fieldName];
    });

    var newGlobalState = result.globalState || {};
    Object.keys(newGlobalState).forEach(function (key) {
      globalState[key] = newGlobalState[key];
    });
  });

  if (newStyle !== props.style) {
    newProps = _extends({}, newProps, { style: newStyle });
  }

  return newProps;
};

// Wrapper around React.cloneElement. To avoid processing the same element
// twice, whenever we clone an element add a special prop to make sure we don't
// process this element again.
var _cloneElement = function _cloneElement(renderedElement, newProps, newChildren) {
  // Only add flag if this is a normal DOM element
  if (typeof renderedElement.type === 'string') {
    newProps = _extends({}, newProps, { 'data-radium': true });
  }

  return _react2.default.cloneElement(renderedElement, newProps, newChildren);
};

//
// The nucleus of Radium. resolveStyles is called on the rendered elements
// before they are returned in render. It iterates over the elements and
// children, rewriting props to add event handlers required to capture user
// interactions (e.g. mouse over). It also replaces the style prop because it
// adds in the various interaction styles (e.g. :hover).
//
resolveStyles = function resolveStyles(component, // ReactComponent, flow+eslint complaining
renderedElement) {
  var config = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : DEFAULT_CONFIG;
  var existingKeyMap = arguments[3];
  var shouldCheckBeforeResolve = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;

  // ReactElement
  existingKeyMap = existingKeyMap || {};
  if (!renderedElement ||
  // Bail if we've already processed this element. This ensures that only the
  // owner of an element processes that element, since the owner's render
  // function will be called first (which will always be the case, since you
  // can't know what else to render until you render the parent component).
  renderedElement.props && renderedElement.props['data-radium'] ||
  // Bail if this element is a radium enhanced element, because if it is,
  // then it will take care of resolving its own styles.
  shouldCheckBeforeResolve && !_shouldResolveStyles(renderedElement)) {
    return renderedElement;
  }

  var newChildren = _resolveChildren({
    children: renderedElement.props.children,
    component: component,
    config: config,
    existingKeyMap: existingKeyMap
  });

  var newProps = _resolveProps({
    component: component,
    config: config,
    existingKeyMap: existingKeyMap,
    props: renderedElement.props
  });

  newProps = _runPlugins({
    component: component,
    config: config,
    existingKeyMap: existingKeyMap,
    props: newProps,
    renderedElement: renderedElement
  });

  // If nothing changed, don't bother cloning the element. Might be a bit
  // wasteful, as we add the sentinal to stop double-processing when we clone.
  // Assume benign double-processing is better than unneeded cloning.
  if (newChildren === renderedElement.props.children && newProps === renderedElement.props) {
    return renderedElement;
  }

  return _cloneElement(renderedElement, newProps !== renderedElement.props ? newProps : {}, newChildren);
};

// Only for use by tests
var __isTestModeEnabled = false;
if (process.env.NODE_ENV !== 'production') {
  resolveStyles.__clearStateForTests = function () {
    globalState = {};
  };
  resolveStyles.__setTestMode = function (isEnabled) {
    __isTestModeEnabled = isEnabled;
  };
}

exports.default = resolveStyles;
module.exports = exports['default'];
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(11)))

/***/ }),
/* 277 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = appendPxIfNeeded;


// Copied from https://github.com/facebook/react/blob/
// 102cd291899f9942a76c40a0e78920a6fe544dc1/
// src/renderers/dom/shared/CSSProperty.js
var isUnitlessNumber = {
  animationIterationCount: true,
  boxFlex: true,
  boxFlexGroup: true,
  boxOrdinalGroup: true,
  columnCount: true,
  flex: true,
  flexGrow: true,
  flexPositive: true,
  flexShrink: true,
  flexNegative: true,
  flexOrder: true,
  gridRow: true,
  gridColumn: true,
  fontWeight: true,
  lineClamp: true,
  lineHeight: true,
  opacity: true,
  order: true,
  orphans: true,
  tabSize: true,
  widows: true,
  zIndex: true,
  zoom: true,

  // SVG-related properties
  fillOpacity: true,
  stopOpacity: true,
  strokeDashoffset: true,
  strokeOpacity: true,
  strokeWidth: true
};

function appendPxIfNeeded(propertyName, value) {
  var needsPxSuffix = !isUnitlessNumber[propertyName] && typeof value === 'number' && value !== 0;
  return needsPxSuffix ? value + 'px' : value;
}
module.exports = exports['default'];

/***/ }),
/* 278 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = mapObject;
function mapObject(object, mapper) {
  return Object.keys(object).reduce(function (result, key) {
    result[key] = mapper(object[key], key);
    return result;
  }, {});
}
module.exports = exports["default"];

/***/ }),
/* 279 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = { "Webkit": { "transform": true, "transformOrigin": true, "transformOriginX": true, "transformOriginY": true, "backfaceVisibility": true, "perspective": true, "perspectiveOrigin": true, "transformStyle": true, "transformOriginZ": true, "animation": true, "animationDelay": true, "animationDirection": true, "animationFillMode": true, "animationDuration": true, "animationIterationCount": true, "animationName": true, "animationPlayState": true, "animationTimingFunction": true, "appearance": true, "userSelect": true, "fontKerning": true, "textEmphasisPosition": true, "textEmphasis": true, "textEmphasisStyle": true, "textEmphasisColor": true, "boxDecorationBreak": true, "clipPath": true, "maskImage": true, "maskMode": true, "maskRepeat": true, "maskPosition": true, "maskClip": true, "maskOrigin": true, "maskSize": true, "maskComposite": true, "mask": true, "maskBorderSource": true, "maskBorderMode": true, "maskBorderSlice": true, "maskBorderWidth": true, "maskBorderOutset": true, "maskBorderRepeat": true, "maskBorder": true, "maskType": true, "textDecorationStyle": true, "textDecorationSkip": true, "textDecorationLine": true, "textDecorationColor": true, "filter": true, "fontFeatureSettings": true, "breakAfter": true, "breakBefore": true, "breakInside": true, "columnCount": true, "columnFill": true, "columnGap": true, "columnRule": true, "columnRuleColor": true, "columnRuleStyle": true, "columnRuleWidth": true, "columns": true, "columnSpan": true, "columnWidth": true, "flex": true, "flexBasis": true, "flexDirection": true, "flexGrow": true, "flexFlow": true, "flexShrink": true, "flexWrap": true, "alignContent": true, "alignItems": true, "alignSelf": true, "justifyContent": true, "order": true, "transition": true, "transitionDelay": true, "transitionDuration": true, "transitionProperty": true, "transitionTimingFunction": true, "backdropFilter": true, "scrollSnapType": true, "scrollSnapPointsX": true, "scrollSnapPointsY": true, "scrollSnapDestination": true, "scrollSnapCoordinate": true, "shapeImageThreshold": true, "shapeImageMargin": true, "shapeImageOutside": true, "hyphens": true, "flowInto": true, "flowFrom": true, "regionFragment": true, "textSizeAdjust": true }, "Moz": { "appearance": true, "userSelect": true, "boxSizing": true, "textAlignLast": true, "textDecorationStyle": true, "textDecorationSkip": true, "textDecorationLine": true, "textDecorationColor": true, "tabSize": true, "hyphens": true, "fontFeatureSettings": true, "breakAfter": true, "breakBefore": true, "breakInside": true, "columnCount": true, "columnFill": true, "columnGap": true, "columnRule": true, "columnRuleColor": true, "columnRuleStyle": true, "columnRuleWidth": true, "columns": true, "columnSpan": true, "columnWidth": true }, "ms": { "flex": true, "flexBasis": false, "flexDirection": true, "flexGrow": false, "flexFlow": true, "flexShrink": false, "flexWrap": true, "alignContent": false, "alignItems": false, "alignSelf": false, "justifyContent": false, "order": false, "transform": true, "transformOrigin": true, "transformOriginX": true, "transformOriginY": true, "userSelect": true, "wrapFlow": true, "wrapThrough": true, "wrapMargin": true, "scrollSnapType": true, "scrollSnapPointsX": true, "scrollSnapPointsY": true, "scrollSnapDestination": true, "scrollSnapCoordinate": true, "touchAction": true, "hyphens": true, "flowInto": true, "flowFrom": true, "breakBefore": true, "breakAfter": true, "breakInside": true, "regionFragment": true, "gridTemplateColumns": true, "gridTemplateRows": true, "gridTemplateAreas": true, "gridTemplate": true, "gridAutoColumns": true, "gridAutoRows": true, "gridAutoFlow": true, "grid": true, "gridRowStart": true, "gridColumnStart": true, "gridRowEnd": true, "gridRow": true, "gridColumn": true, "gridColumnEnd": true, "gridColumnGap": true, "gridRowGap": true, "gridArea": true, "gridGap": true, "textSizeAdjust": true } };
module.exports = exports["default"];

/***/ }),
/* 280 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = sortPrefixedStyle;

var _isPrefixedProperty = __webpack_require__(896);

var _isPrefixedProperty2 = _interopRequireDefault(_isPrefixedProperty);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function sortPrefixedStyle(style) {
  return Object.keys(style).sort(function (left, right) {
    if ((0, _isPrefixedProperty2.default)(left) && !(0, _isPrefixedProperty2.default)(right)) {
      return -1;
    } else if (!(0, _isPrefixedProperty2.default)(left) && (0, _isPrefixedProperty2.default)(right)) {
      return 1;
    }
    return 0;
  }).reduce(function (sortedStyle, prop) {
    sortedStyle[prop] = style[prop];
    return sortedStyle;
  }, {});
}
module.exports = exports['default'];

/***/ }),
/* 281 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var uppercasePattern = /[A-Z]/g;
var msPattern = /^ms-/;
var cache = {};

function hyphenateStyleName(string) {
    return string in cache
    ? cache[string]
    : cache[string] = string
      .replace(uppercasePattern, '-$&')
      .toLowerCase()
      .replace(msPattern, '-ms-');
}

module.exports = hyphenateStyleName;


/***/ }),
/* 282 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getStateKey = __webpack_require__(283);

var _getStateKey2 = _interopRequireDefault(_getStateKey);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var getState = function getState(state, elementKey, value) {
  var key = (0, _getStateKey2.default)(elementKey);

  return !!state && !!state._radiumStyleState && !!state._radiumStyleState[key] && state._radiumStyleState[key][value];
};

exports.default = getState;
module.exports = exports['default'];

/***/ }),
/* 283 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
var getStateKey = function getStateKey(elementKey) {
  return elementKey === null || elementKey === undefined ? 'main' : elementKey.toString();
};

exports.default = getStateKey;
module.exports = exports['default'];

/***/ }),
/* 284 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = hash;


// a simple djb2 hash based on hash-string:
// https://github.com/MatthewBarker/hash-string/blob/master/source/hash-string.js
// returns a hex-encoded hash
function hash(text) {
  if (!text) {
    return '';
  }

  var hashValue = 5381;
  var index = text.length - 1;

  while (index) {
    hashValue = hashValue * 33 ^ text.charCodeAt(index);
    index -= 1;
  }

  return (hashValue >>> 0).toString(16);
}
module.exports = exports['default'];

/***/ }),
/* 285 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _checkPropsPlugin = __webpack_require__(923);

var _checkPropsPlugin2 = _interopRequireDefault(_checkPropsPlugin);

var _keyframesPlugin = __webpack_require__(924);

var _keyframesPlugin2 = _interopRequireDefault(_keyframesPlugin);

var _mergeStyleArrayPlugin = __webpack_require__(925);

var _mergeStyleArrayPlugin2 = _interopRequireDefault(_mergeStyleArrayPlugin);

var _prefixPlugin = __webpack_require__(926);

var _prefixPlugin2 = _interopRequireDefault(_prefixPlugin);

var _removeNestedStylesPlugin = __webpack_require__(927);

var _removeNestedStylesPlugin2 = _interopRequireDefault(_removeNestedStylesPlugin);

var _resolveInteractionStylesPlugin = __webpack_require__(928);

var _resolveInteractionStylesPlugin2 = _interopRequireDefault(_resolveInteractionStylesPlugin);

var _resolveMediaQueriesPlugin = __webpack_require__(930);

var _resolveMediaQueriesPlugin2 = _interopRequireDefault(_resolveMediaQueriesPlugin);

var _visitedPlugin = __webpack_require__(931);

var _visitedPlugin2 = _interopRequireDefault(_visitedPlugin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  checkProps: _checkPropsPlugin2.default,
  keyframes: _keyframesPlugin2.default,
  mergeStyleArray: _mergeStyleArrayPlugin2.default,
  prefix: _prefixPlugin2.default,
  removeNestedStyles: _removeNestedStylesPlugin2.default,
  resolveInteractionStyles: _resolveInteractionStylesPlugin2.default,
  resolveMediaQueries: _resolveMediaQueriesPlugin2.default,
  visited: _visitedPlugin2.default
};
/* eslint-disable block-scoped-const */

module.exports = exports['default'];

/***/ }),
/* 286 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_design_systems_lib__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_design_systems_lib___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_design_systems_lib__);

var entityTypes = __WEBPACK_IMPORTED_MODULE_0_design_systems_lib__["utils"].entityDescriptors.entityTypes;

var entityTypesOrder = [entityTypes.colors.key, entityTypes.typeStyles.key, entityTypes.sharedStyles.key, entityTypes.icons.key, entityTypes.components.key];

/* harmony default export */ __webpack_exports__["a"] = (entityTypesOrder);

/***/ }),
/* 287 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);


/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var children = _ref.children,
      isLight = _ref.isLight,
      contentClass = _ref.contentClass;


  var className = 'c-full-screen-message ' + (isLight ? ' c-full-screen-message--light' : '');

  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    'div',
    { className: className },
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'div',
      { className: contentClass || "c-full-screen-message__content" },
      children
    )
  );
});

/***/ }),
/* 288 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Button; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_classnames__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_classnames__);
var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }





/**
 * Button
 * */
var Button = (_temp = _class = function (_React$Component) {
  _inherits(Button, _React$Component);

  function Button() {
    _classCallCheck(this, Button);

    return _possibleConstructorReturn(this, (Button.__proto__ || Object.getPrototypeOf(Button)).apply(this, arguments));
  }

  _createClass(Button, [{
    key: 'render',
    value: function render() {
      var buttonClasses = __WEBPACK_IMPORTED_MODULE_2_classnames___default()('c-button', 'c-button--' + this.props.type, 'c-button--' + this.props.width,

      // Special case act like primary when CTA.
      { 'c-button--primary': this.props.type === 'cta' }, { 'c-button--borderless': this.props.borderless }, { 'disabled': this.props.disabled },

      // Merge with className prop.
      this.props.className);

      // Copy these props to the <button> element.
      var buttonProps = {
        style: this.props.style,
        href: this.props.href,
        onClick: this.props.onClick,
        target: this.props.target,
        download: this.props.download,
        disabled: this.props.disabled
      };

      var TagName = this.props.href ? 'a' : 'button';

      if (this.props.icon) {
        // For buttons with icons, render a container around the text for positioning purposes.
        return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
          TagName,
          _extends({ className: buttonClasses }, buttonProps),
          __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement('i', { className: __WEBPACK_IMPORTED_MODULE_2_classnames___default()('c-button__icon', 'icon', 'icon-' + this.props.icon) }),
          this.props.children ? __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
            'span',
            { className: 'c-button__text' },
            this.props.children
          ) : null
        );
      } else {
        // Buttons without icons just have their text inside.
        return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
          TagName,
          _extends({ className: buttonClasses }, buttonProps),
          this.props.children
        );
      }
    }
  }]);

  return Button;
}(__WEBPACK_IMPORTED_MODULE_1_react___default.a.Component), _class.propTypes = {
  /**
   * The main look of the button. Utility and CTA both override the width prop.
   */
  type: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.oneOf(['secondary', 'primary', 'utility', 'cta', 'emphasized']),

  /**
   * Action
   * */
  onClick: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.func,
  /**
   * How wide the button is. Use 'narrow' for buttons that have one word or
   * two or three very short words. use 'wide' for all other buttons, except
   * when in the same page or context, try to use buttons of the same width.
   */
  width: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.oneOf(['x-narrow', 'narrow', 'wide']),
  style: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.object,
  borderless: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.bool,
  icon: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.string,
  href: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.string,
  target: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.string, //can be used to define target if a link, i.e target='_blank'
  className: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.string,
  download: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.bool, //click target that allow actual download ib browsers
  disabled: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.bool
}, _class.defaultProps = {
  type: 'primary',
  width: 'narrow',
  disabled: false,
  bordered: true
}, _temp);


/***/ }),
/* 289 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return WebLink; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__sketch_native_events__ = __webpack_require__(16);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var WebLink = function (_Component) {
  _inherits(WebLink, _Component);

  function WebLink() {
    _classCallCheck(this, WebLink);

    return _possibleConstructorReturn(this, (WebLink.__proto__ || Object.getPrototypeOf(WebLink)).apply(this, arguments));
  }

  _createClass(WebLink, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'a',
        { className: this.props.className, onClick: function onClick() {
            return Object(__WEBPACK_IMPORTED_MODULE_1__sketch_native_events__["openURLInBrowser"])(_this2.props.url);
          }, href: 'javascript:void(0)' },
        this.props.text
      );
    }
  }]);

  return WebLink;
}(__WEBPACK_IMPORTED_MODULE_0_react__["Component"]);

/***/ }),
/* 290 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ListView; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_prop_types__);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }





var ListView = function (_React$Component) {
  _inherits(ListView, _React$Component);

  function ListView(props) {
    _classCallCheck(this, ListView);

    var _this = _possibleConstructorReturn(this, (ListView.__proto__ || Object.getPrototypeOf(ListView)).call(this, props));

    _this.state = {
      items: [],
      selectedItemIDs: {},
      lastSelectedItemID: null
    };
    return _this;
  }

  _createClass(ListView, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
        'div',
        null,
        this.sortedItems().map(function (item) {
          var id = item[_this2.props.idKey];
          var isSelected = _this2.state.selectedItemIDs[id];
          var toggleSelected = _this2.toggleItemSelection.bind(_this2, id);
          return _this2.props.renderItem(item, isSelected, toggleSelected);
        })
      );
    }
  }, {
    key: 'sortedItems',
    value: function sortedItems() {
      if (this.props.sortBy) {
        return __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.sortBy(this.state.items, this.props.sortBy);
      } else {
        return this.state.items;
      }
    }
  }, {
    key: 'setItems',
    value: function setItems(items) {
      this.setState({ items: items });
    }
  }, {
    key: 'afterChangeSelection',
    value: function afterChangeSelection() {
      this.props.onSelectionChanged(this.getSelectedItems().length, this.state.items.length);
    }
  }, {
    key: 'toggleItemSelection',
    value: function toggleItemSelection(id, evt) {
      var _this3 = this;

      if (evt.shiftKey && this.state.lastSelectedItemID) {
        // Select all items between last selected item and
        // this one, inclusive.
        var idsInRange = {};
        var inRange = false;
        __WEBPACK_IMPORTED_MODULE_0_lodash___default()(this.sortedItems()).map(this.props.idKey).each(function (anID) {
          // Going through the list of all ids, check if we are at either end.
          if (anID === id || anID === _this3.state.lastSelectedItemID) {
            // This makes it inclusive.
            idsInRange[anID] = true;

            // Only two ends, so this turns the range on at one end and off at the other.
            inRange = !inRange;
          }
          if (inRange) {
            idsInRange[anID] = true;
          }
        });

        this.setState({
          selectedItemIDs: __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.merge(idsInRange, this.state.selectedItemIDs)
        }, this.afterChangeSelection);
      } else {
        // Toggle selected item.

        if (this.state.selectedItemIDs[id]) {
          // Deselect.
          this.setState({
            selectedItemIDs: __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.omit(this.state.selectedItemIDs, id),
            lastSelectedItemID: id
          }, this.afterChangeSelection);
        } else {
          // Select.
          var newID = {};
          newID[id] = true;
          this.setState({
            selectedItemIDs: __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.merge(newID, this.state.selectedItemIDs),
            lastSelectedItemID: id
          }, this.afterChangeSelection);
        }
      }
    }
  }, {
    key: 'toggleSelectAll',
    value: function toggleSelectAll() {
      var areAllSelected = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.keys(this.state.selectedItemIDs).length === this.state.items.length;

      if (areAllSelected) {
        this.setState({ selectedItemIDs: {} }, this.afterChangeSelection);
      } else {
        var allIDs = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.map(this.state.items, this.props.idKey);
        var trues = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.map(__WEBPACK_IMPORTED_MODULE_0_lodash___default.a.range(this.state.items.length), function () {
          return true;
        });
        var selectedItemIDs = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.zipObject(allIDs, trues);
        this.setState({ selectedItemIDs: selectedItemIDs }, this.afterChangeSelection);
      }
    }
  }, {
    key: 'getSelectedItems',
    value: function getSelectedItems() {
      var _this4 = this;

      return __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.filter(this.state.items, function (item) {
        return _this4.state.selectedItemIDs[item[_this4.props.idKey]];
      });
    }
  }]);

  return ListView;
}(__WEBPACK_IMPORTED_MODULE_1_react___default.a.Component);




ListView.propTypes = {
  idKey: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string,
  onSelectionChanged: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func,
  renderItem: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func
};

/***/ }),
/* 291 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = saveTypeStylesWithDependencies;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__util__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__sketch_native_events__ = __webpack_require__(16);
var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();






var entityDescriptors = __WEBPACK_IMPORTED_MODULE_1__util__["m" /* getEntityDescriptors */]();

function saveTypeStylesWithDependencies(typeStyles, fontVariants, styleData, showStepNumber) {

  try {
    if (__WEBPACK_IMPORTED_MODULE_0_lodash___default.a.isEmpty(typeStyles)) {
      //we can get here with empty list only in the process of upload layer, that case we still want to show the progress bar
      var _label = showStepNumber ? '(3/5) Adding Type Styles…' : 'Adding Type Styles…';
      Object(__WEBPACK_IMPORTED_MODULE_2__sketch_native_events__["showProgressSheet"])({ maxValue: 0, label: _label });
      return Promise.resolve();
    }

    var numberOfOperations = 0;
    var trackProgress = __WEBPACK_IMPORTED_MODULE_1__util__["H" /* promiseTracker */]({
      onCreate: function onCreate() {
        return numberOfOperations += 1;
      },
      onResolve: function onResolve() {
        return Object(__WEBPACK_IMPORTED_MODULE_2__sketch_native_events__["incrementProgress"])(1);
      }
    });

    var styleguideApiClient = this.flux.store('ApiClientStore').getStyleguideClient();

    // Add dependent font families, if they don’t already
    // exist.
    var promiseToAddMissingFamilies = Promise.resolve(styleData);

    var missingFamilies = __WEBPACK_IMPORTED_MODULE_1__util__["A" /* missingFontFamiliesForTypeStyles */](typeStyles, styleData);

    if (missingFamilies.length > 0) {
      promiseToAddMissingFamilies = trackProgress(styleguideApiClient.addElementsToArray('fonts', {
        fonts: missingFamilies.map(function (family) {
          return {
            family: family,
            source: 'system',
            name: family, // TODO: there might be a better display name available.
            variants: fontVariants[family],
            folderId: __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.get(styleData.styleguide.foldersByType[entityDescriptors.fonts.key], '[0]._id')
          };
        })
      }));
    }

    // Add any dependent colors that do not already exist to
    // an anonymous color palette.
    var promiseToAddMissingColors = Promise.resolve(styleData);

    var missingColors = __WEBPACK_IMPORTED_MODULE_1__util__["z" /* missingColorsInTypeStyles */](typeStyles, styleData);

    if (missingColors.length > 0) {
      var anonymousPalette = __WEBPACK_IMPORTED_MODULE_1__util__["c" /* anonymousColorPalette */](styleData);
      if (anonymousPalette) {
        promiseToAddMissingColors = trackProgress(styleguideApiClient.addElementsToNestedArray('colors', 'colorSections', anonymousPalette._id, { colors: missingColors }));
      } else {
        promiseToAddMissingColors = trackProgress(styleguideApiClient.addElementsToArray('colorSections', {
          name: 'Other Colors',
          anonymousColorSection: true,
          colors: missingColors,
          folderId: __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.get(styleData.styleguide.foldersByType[entityDescriptors.colors.key], '[0]._id')
        }));
      }
    }

    //Existing typestyles still taken only from the styleguide as we should not get here with parent styles
    var existingTypeStyleIDs = __WEBPACK_IMPORTED_MODULE_0_lodash___default()(styleData.styleguide.typeStyles).map('_id').compact();

    var promiseToClassifyTypeStyles = Promise.all([promiseToAddMissingFamilies, promiseToAddMissingColors]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          styleDataAfterAddingFamilies = _ref2[0],
          styleDataAfterAddingColors = _ref2[1];

      // Update type styles with resolved color and font families.
      var linkedTypeStyles = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.clone(typeStyles);
      __WEBPACK_IMPORTED_MODULE_1__util__["D" /* populateTypeStyleFontFamilyIDs */](linkedTypeStyles, styleDataAfterAddingFamilies);
      __WEBPACK_IMPORTED_MODULE_1__util__["E" /* populateTypeStyleTextColorIDs */](linkedTypeStyles, styleDataAfterAddingColors);

      // Clasify the incoming typeStyles into:
      var typeStylesToCreate = [];
      var typeStylesToUpdate = [];

      __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.forEach(linkedTypeStyles, function (linkedTypeStyle) {
        if (existingTypeStyleIDs.includes(linkedTypeStyle._id)) {
          __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.unset(linkedTypeStyle, ['sampleText']);
          typeStylesToUpdate.push(linkedTypeStyle);
        } else {
          __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.unset(linkedTypeStyle, ['_id']);

          //set the consistent id for new layers but avoid changing it for update layers as those might already have usage
          linkedTypeStyle.uuid = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.toUpper(linkedTypeStyle.objectID);

          typeStylesToCreate.push(linkedTypeStyle);
        }
      });

      return { typeStylesToCreate: typeStylesToCreate, typeStylesToUpdate: typeStylesToUpdate };
    });

    var promiseToAddNewStyles = trackProgress(promiseToClassifyTypeStyles.then(function (_ref3) {
      var typeStylesToCreate = _ref3.typeStylesToCreate;

      if (typeStylesToCreate.length > 0) {
        return styleguideApiClient.addElementsToArray('typeStyles', { typeStyles: typeStylesToCreate });
      } else {
        // If there are no styles to add, return the current style
        // data instead of after adding them.
        return styleData;
      }
    }));

    var promiseToUpdateExistingStyles = trackProgress(promiseToAddNewStyles // Wait for new styles to be added first.
    .then(function () {
      return promiseToClassifyTypeStyles;
    }).then(function (_ref4) {
      var typeStylesToUpdate = _ref4.typeStylesToUpdate;

      if (typeStylesToUpdate.length > 0) {
        return styleguideApiClient.updateElementsInArray('typeStyles', { typeStyles: typeStylesToUpdate });
      } else {
        // If there are no styles to update, return the promise to add
        // new styles, which will contain style data just like after
        // updating styles would have.
        return promiseToAddNewStyles;
      }
    }));

    //progress bar label is affected by the fact if it called as a standalone operation or part of uploading layers
    var label = showStepNumber ? '(3/5) Adding Type Styles…' : 'Adding Type Styles…';
    Object(__WEBPACK_IMPORTED_MODULE_2__sketch_native_events__["showProgressSheet"])({
      label: label,
      maxValue: numberOfOperations
    });

    return promiseToUpdateExistingStyles.then(function (styleData) {
      Object(__WEBPACK_IMPORTED_MODULE_2__sketch_native_events__["typeStylesLoaded"])(styleData.styleguide.typeStyles);
      return styleData;
    });
  } catch (e) {
    return Promise.reject(e);
  }
}

/***/ }),
/* 292 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = uploadDataURI;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__logger_service_js__ = __webpack_require__(68);



var request = __webpack_require__(293);

function uploadDataURI(destinationURL, fileDataURI) {
  var verifyImage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

  var blob = blobFromDataURI(fileDataURI);
  var contentType = contentTypeFromDataURI(fileDataURI);
  return uploadBlob(destinationURL, fileDataURI, blob, contentType, verifyImage);
}

function uploadBlob(destinationURL, fileDataURI, fileBlob, contentType, verifyImage) {
  return new Promise(function (resolve, reject) {
    var fileReader = new FileReader();
    fileReader.onload = function () {
      request.post(destinationURL).set('Content-Type', contentType).send(this.result).end(function (err, res) {
        if (err) {
          __WEBPACK_IMPORTED_MODULE_1__logger_service_js__["a" /* default */].error(__WEBPACK_IMPORTED_MODULE_0_lodash___default.a.merge({ message: 'Error uploading layer' }, err));
          reject(err);
          return;
        }

        if (verifyImage && contentType.includes('png')) {
          var image = new Image();
          image.onload = function () {
            resolve();
          };
          image.onerror = function () {
            __WEBPACK_IMPORTED_MODULE_1__logger_service_js__["a" /* default */].error(__WEBPACK_IMPORTED_MODULE_0_lodash___default.a.merge({
              message: 'Image upload failed - xhr result',
              fileBlobLength: fileBlob && fileBlob.size,
              fileDataURILength: fileDataURI && fileDataURI.length,
              signedURL: destinationURL,
              contentType: contentType
            }, res));
            reject(new Error('Image could not be loaded after upload'));
          };

          image.src = destinationURL.split('?')[0];
        } else {
          resolve();
        }
      });
    };
    fileReader.readAsArrayBuffer(fileBlob);
  });
}

function contentTypeFromDataURI(dataURI) {
  var match = /^data:([^;,]*)/.exec(dataURI);
  var result = 'text/plain';
  if (match && match[1] && !/^charset=|^base64$/.test(match[1])) {
    result = match[1];
  }
  return result;
}

function blobFromDataURI(dataURI) {
  var req = new XMLHttpRequest();
  // Below false means synchronous, which makes this unsuitable for calling
  // remote URLs, although that will technically work.
  req.open('GET', dataURI, false);
  req.responseType = 'blob';
  req.send();
  return req.response;
}

//todo: move to util

/***/ }),
/* 293 */,
/* 294 */,
/* 295 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = uploadLayers;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_bluebird__ = __webpack_require__(56);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_bluebird___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_bluebird__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_sha1__ = __webpack_require__(111);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_sha1___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_sha1__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_d3_queue__ = __webpack_require__(970);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_d3_queue___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_d3_queue__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__util__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__services_upload_service__ = __webpack_require__(292);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__sketch_native_events__ = __webpack_require__(16);
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }










// upload layers - stage #3
function uploadLayers(newSection, layersToUpload, globalAssets, styleDataImageHashes, showStepNumber) {
  var _this = this;

  var hasDuplicates = checkLayersContainDuplicates.call(this, layersToUpload);
  var masterSymbolsLookup = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.keyBy(globalAssets.sketchSymbols, 'metadata.sketchSymbolId');

  var libraryTypeStylesMap = getLibraryStylesMap(globalAssets, 'typeStyles');
  var librarySharedStylesMap = getLibraryStylesMap(globalAssets, 'sharedStyles');

  if (hasDuplicates) {
    this.flux.actions.onLogMessage('info', {
      layersLookup: __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.merge(layersToUpload, { exportedData: null })
    });
  }

  // Promise wrapper that tracks progress to show in the UI for everything
  // but the style uploads.
  var trackProgress = __WEBPACK_IMPORTED_MODULE_4__util__["H" /* promiseTracker */]({
    onResolve: function onResolve() {
      return Object(__WEBPACK_IMPORTED_MODULE_6__sketch_native_events__["incrementProgress"])(1);
    }
  });

  // since all have should the same values and the first item is symbol instance that always contain the data we will take it
  // from there.
  // If the order will change we can always change this code for iteration
  var first = layersToUpload[0];
  var imageType = first.sectionType;
  var type = __WEBPACK_IMPORTED_MODULE_4__util__["x" /* itemsKeyForImageType */](imageType);
  var enclosingType = __WEBPACK_IMPORTED_MODULE_4__util__["g" /* categoryKeyForImageType */](imageType);
  var sectionID = first.sectionID;
  var primaryFormat = __WEBPACK_IMPORTED_MODULE_4__util__["y" /* mainFormatFromImageType */](imageType);

  var layersData = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.compact(__WEBPACK_IMPORTED_MODULE_0_lodash___default.a.map(layersToUpload, function (layer) {
    // Filter out layers that do not need to be uploaded because they have not changed.

    //get image either by id or from to lookup of master files, as the hashes key is per symbol and brandid item id
    var imageId = layer.imageID || __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.get(masterSymbolsLookup[layer.symbolID], '_id');

    //calculate the hash for all the sklalayer (for now it is save to assume we always have a sketch layer)
    var sketchDataURL = layer.exportedData.find(function (e) {
      return e.format === 'skla';
    });
    if (!sketchDataURL) {
      throw new Error('No sketch data (skla) for layer "' + layer.name + '"');
    }
    var hash = __WEBPACK_IMPORTED_MODULE_2_sha1___default()(sketchDataURL.dataURL);
    //set layer hash will be used later to get persisted on the image metadata
    layer.hash = hash;

    //we want only existing item to be verified against the hash, all new items will always be uploaded
    //symbol instances will always be uploaded, partially as we dont expect perf issue from ther upload and partially
    //because the archive data for instance currently does not seems to reflect complete struture for example the sharedStyles
    if (layer.symbolID && imageId && layer.isSymbolMasterDependency) {
      var key = __WEBPACK_IMPORTED_MODULE_4__util__["o" /* getImageHashKey */](layer.symbolID, imageId);
      //if they are identical we want to skip this layer in this upload operation
      if (hash === styleDataImageHashes[key]) {
        return null;
      }
    }

    //new or changed item, return the layer data as is
    return layer;
  }));

  __WEBPACK_IMPORTED_MODULE_4__util__["h" /* debug */]('Changed layers count - ' + layersData.length);

  if (layersData.length === 0) {
    return null;
  }

  var styleguideApiClient = this.flux.store('ApiClientStore').getStyleguideClient();

  return __WEBPACK_IMPORTED_MODULE_1_bluebird___default.a.map(layersData, function (layer) {
    var mainPNGExport = layer.exportedData.find(function (e) {
      return e.format === 'png' && e.exportOptionsKey === 'formatsToUpload';
    });
    //2. resolve layer background color (untracked)
    return __WEBPACK_IMPORTED_MODULE_4__util__["d" /* backgroundColorIDWithBestContrastForImageURL */](mainPNGExport ? mainPNGExport.dataURL : null, layer.backgroundColorID).then(function (backgroundColorID) {
      layer.backgroundColorID = backgroundColorID;
    });
  }).then(function () {
    //3. sign files (untracked)
    var allUploadFileNames = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.flatMap(layersData, function (layer) {
      return __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.map(layer.exportedData, 'uploadFileName');
    });

    return __WEBPACK_IMPORTED_MODULE_4__util__["F" /* promiseTimeout */](30000, 'Timed out waiting for server to sign files.', styleguideApiClient.signFiles(allUploadFileNames).catch(function () {
      return __WEBPACK_IMPORTED_MODULE_1_bluebird___default.a.reject(new Error('Error signing files.'));
    }));
  }).then(function (signedFiles) {
    //4. upload files to s3 (tracked)
    __WEBPACK_IMPORTED_MODULE_4__util__["h" /* debug */]('Layers signed. Will upload files...');

    var maxValue = signedFiles && signedFiles.length;
    var label = showStepNumber ? '(4/5) Uploading Layers…' : 'Uploading Layers…';
    Object(__WEBPACK_IMPORTED_MODULE_6__sketch_native_events__["showProgressSheet"])({ maxValue: maxValue, label: label }); // reset progress bar to track upload progress

    return __WEBPACK_IMPORTED_MODULE_1_bluebird___default.a.map(layersData, function (layer) {
      // Upload each export as a file.
      return __WEBPACK_IMPORTED_MODULE_1_bluebird___default.a.map(layer.exportedData, function (exported) {
        var signedFileData = __WEBPACK_IMPORTED_MODULE_4__util__["J" /* signedDataFromFileName */](signedFiles, exported.uploadFileName);

        var _util$signedURLFromSi = __WEBPACK_IMPORTED_MODULE_4__util__["K" /* signedURLFromSignedData */](signedFileData),
            signedFileURL = _util$signedURLFromSi.signedFileURL;

        var assetKey = signedFileData.assetKey;

        return trackProgress(
        // File uploads depend on both signatures and layer data.
        __WEBPACK_IMPORTED_MODULE_5__services_upload_service__["a" /* uploadDataURI */](signedFileURL, exported.dataURL, false).catch(function () {
          return __WEBPACK_IMPORTED_MODULE_1_bluebird___default.a.reject(new Error('Error uploading layer data.'));
        }).then(function () {
          return __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.merge({ assetKey: assetKey }, exported);
        }));
      }).then(function (uploadedItems) {
        return __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.merge(layer, { uploadedItems: uploadedItems });
      });
    }, { concurrency: 10 });
  }).then(function (layers) {
    //5. classify the uploaded layer place in design library and update sketch symbols list (untracked)
    var newItems = [];
    var updatedItems = [];
    var sketchSymbols = [];
    var newSectionItems = [];

    __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.forEach(layers, function (layer) {

      var primaryExtension = layer.isSymbolMasterDependency ? 'png' : primaryFormat;

      var imageObjectToPersist = __WEBPACK_IMPORTED_MODULE_4__util__["s" /* imageItemFromLayer */](layer, primaryExtension, librarySharedStylesMap, libraryTypeStylesMap);

      if (layer.imageID && layer.sectionID) {
        imageObjectToPersist._id = layer.imageID;
        updatedItems.push(imageObjectToPersist);
      } else if (layer.sectionID) {
        newItems.push(imageObjectToPersist);
      } else if (layer.isSymbolMasterDependency) {
        sketchSymbols.push(imageObjectToPersist);
      } else {
        // Create new image in new section.
        newSectionItems.push(imageObjectToPersist);
      }
    });

    var maxValue = countOfNonEmptyArray(updatedItems.length) + countOfNonEmptyArray(newItems.length) + countOfNonEmptyArray(sketchSymbols.length) + countOfNonEmptyArray(newSectionItems);

    var label = showStepNumber ? '(5/5) Updating Design Library…' : 'Updating Design Library…';
    Object(__WEBPACK_IMPORTED_MODULE_6__sketch_native_events__["showProgressSheet"])({ maxValue: maxValue, label: label });

    if (sketchSymbols.length === 0) {
      return __WEBPACK_IMPORTED_MODULE_1_bluebird___default.a.resolve({
        type: type,
        enclosingType: enclosingType,
        sectionID: sectionID,
        updatedItems: updatedItems,
        newItems: newItems,
        newSectionItems: newSectionItems
      });
    } else {
      //we need to update symbols first only if it will be successful update the rest
      __WEBPACK_IMPORTED_MODULE_4__util__["h" /* debug */]('Updated sketch symbols - ' + sketchSymbols.length);
      return trackProgress(__WEBPACK_IMPORTED_MODULE_4__util__["F" /* promiseTimeout */](30000, 'Timed out waiting for server to update symbols.', styleguideApiClient.updateSketchSymbols(sketchSymbols).then(function (styleData) {
        _this.dispatch('STYLEGUIDE_LOADED', styleData);
        return __WEBPACK_IMPORTED_MODULE_1_bluebird___default.a.resolve({
          type: type,
          enclosingType: enclosingType,
          sectionID: sectionID,
          updatedItems: updatedItems,
          newItems: newItems,
          newSectionItems: newSectionItems
        });
      }).catch(function () {
        return __WEBPACK_IMPORTED_MODULE_1_bluebird___default.a.reject(new Error('Error updating symbols'));
      })));
    }
  }).then(function (_ref) {
    var type = _ref.type,
        enclosingType = _ref.enclosingType,
        sectionID = _ref.sectionID,
        updatedItems = _ref.updatedItems,
        newItems = _ref.newItems,
        newSectionItems = _ref.newSectionItems;

    //5. add, update or create new section in design library with the derived elements data from the previous steps (tracked)
    __WEBPACK_IMPORTED_MODULE_4__util__["h" /* debug */]('Updating Design Library - newItems:' + newItems.length + ', updatedItems:' + updatedItems.length + ', newSectionItems:' + newSectionItems.length);
    if (hasDuplicates) {
      _this.flux.actions.onLogMessage('info', { updatedItems: updatedItems, newItems: newItems });
    }
    // For now, make upsert API calls sequentially since there were errors
    // doing them in parallel.
    var upsertQueue = Object(__WEBPACK_IMPORTED_MODULE_3_d3_queue__["queue"])(1);
    var promisesToUpsertAllItems = [];

    if (updatedItems && updatedItems.length > 0) {
      // Update existing image.
      promisesToUpsertAllItems.push(trackProgress(__WEBPACK_IMPORTED_MODULE_4__util__["G" /* promiseToRunOnQueue */](upsertQueue, function () {
        return __WEBPACK_IMPORTED_MODULE_4__util__["F" /* promiseTimeout */](30000, 'Timed out waiting for server to update item.', styleguideApiClient.updateElementsInNestedArray(type, enclosingType, sectionID, _defineProperty({}, type, updatedItems)).then(function (styleData) {
          _this.dispatch('STYLEGUIDE_LOADED', styleData);
        }).catch(function () {
          return __WEBPACK_IMPORTED_MODULE_1_bluebird___default.a.reject(new Error('Error updating item in design library.'));
        }));
      })));
    }
    if (newItems && newItems.length > 0) {
      // Create new image in existing section.
      promisesToUpsertAllItems.push(trackProgress(__WEBPACK_IMPORTED_MODULE_4__util__["G" /* promiseToRunOnQueue */](upsertQueue, function () {
        return __WEBPACK_IMPORTED_MODULE_4__util__["F" /* promiseTimeout */](30000, 'Timed out waiting for server to create item.', styleguideApiClient.addElementsToNestedArray(type, enclosingType, sectionID, _defineProperty({}, type, newItems)).then(function (styleData) {
          _this.dispatch('STYLEGUIDE_LOADED', styleData);
        }).catch(function () {
          return __WEBPACK_IMPORTED_MODULE_1_bluebird___default.a.reject(new Error('Error creating item in design library.'));
        }));
      })));
    }
    if (newSection && newSectionItems && newSectionItems.length) {
      var categoryKey = __WEBPACK_IMPORTED_MODULE_4__util__["g" /* categoryKeyForImageType */](newSection.imageType);
      var itemsKey = __WEBPACK_IMPORTED_MODULE_4__util__["x" /* itemsKeyForImageType */](newSection.imageType);
      var sectionWithItems = _defineProperty({
        name: newSection.name,
        folderId: newSection.folderId
      }, itemsKey, newSectionItems);

      promisesToUpsertAllItems.push(trackProgress(__WEBPACK_IMPORTED_MODULE_4__util__["G" /* promiseToRunOnQueue */](upsertQueue, function () {
        return __WEBPACK_IMPORTED_MODULE_4__util__["F" /* promiseTimeout */](30000, 'Timed out waiting for server to create new section.', styleguideApiClient.addElementsToArray(categoryKey, sectionWithItems).then(function (styleData) {
          _this.dispatch('STYLEGUIDE_LOADED', styleData);
        }).catch(function () {
          return __WEBPACK_IMPORTED_MODULE_1_bluebird___default.a.reject(new Error('Error adding new section to design library.'));
        }));
      })));
    }

    return __WEBPACK_IMPORTED_MODULE_1_bluebird___default.a.all(promisesToUpsertAllItems).then(function () {
      //no need to actually triggered the data updates by directly clling the api and dipatching the results
      return __WEBPACK_IMPORTED_MODULE_1_bluebird___default.a.resolve();
    });
  }).catch(function (err) {
    // I am not hiding here the hiding of the progress bar as it happen in higher catch clause
    __WEBPACK_IMPORTED_MODULE_4__util__["h" /* debug */](err.stack);
    return __WEBPACK_IMPORTED_MODULE_1_bluebird___default.a.reject(err);
  });
}

function checkLayersContainDuplicates(layers) {
  var symbolMasters = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.filter(layers, function (layer) {
    return layer.isSymbolMasterDependency;
  });

  var duplicateIds = __WEBPACK_IMPORTED_MODULE_4__util__["r" /* hasDuplicateElements */](symbolMasters, 'id');
  var duplicatedSymbolIDs = __WEBPACK_IMPORTED_MODULE_4__util__["r" /* hasDuplicateElements */](symbolMasters, 'symbolID');

  var hasDuplicates = duplicateIds || duplicatedSymbolIDs;
  if (hasDuplicates) {
    this.flux.actions.onLogMessage('info', { message: 'Possible layers duplication issues', layers: layers });
  }
  return hasDuplicates;
}

function countOfNonEmptyArray(array) {
  return array.length > 0 ? 1 : 0;
}

function getLibraryStylesMap(globalAssets, key) {
  var libraryTextStyles = globalAssets[key];

  var map = {};
  //library content overrides the map content so it assigned second
  libraryTextStyles.forEach(function (style) {
    map[style.uuid] = style._id;
  });

  return map;
}

/***/ }),
/* 296 */,
/* 297 */,
/* 298 */,
/* 299 */,
/* 300 */,
/* 301 */,
/* 302 */,
/* 303 */,
/* 304 */,
/* 305 */,
/* 306 */,
/* 307 */,
/* 308 */,
/* 309 */,
/* 310 */,
/* 311 */,
/* 312 */,
/* 313 */,
/* 314 */,
/* 315 */,
/* 316 */,
/* 317 */,
/* 318 */,
/* 319 */,
/* 320 */,
/* 321 */,
/* 322 */,
/* 323 */,
/* 324 */,
/* 325 */,
/* 326 */,
/* 327 */,
/* 328 */,
/* 329 */,
/* 330 */,
/* 331 */,
/* 332 */,
/* 333 */,
/* 334 */,
/* 335 */,
/* 336 */,
/* 337 */,
/* 338 */,
/* 339 */,
/* 340 */,
/* 341 */,
/* 342 */,
/* 343 */,
/* 344 */,
/* 345 */,
/* 346 */,
/* 347 */,
/* 348 */,
/* 349 */,
/* 350 */,
/* 351 */,
/* 352 */,
/* 353 */,
/* 354 */,
/* 355 */,
/* 356 */,
/* 357 */,
/* 358 */,
/* 359 */,
/* 360 */,
/* 361 */,
/* 362 */,
/* 363 */,
/* 364 */,
/* 365 */,
/* 366 */,
/* 367 */,
/* 368 */,
/* 369 */,
/* 370 */,
/* 371 */,
/* 372 */,
/* 373 */,
/* 374 */,
/* 375 */,
/* 376 */,
/* 377 */,
/* 378 */,
/* 379 */,
/* 380 */,
/* 381 */,
/* 382 */,
/* 383 */,
/* 384 */,
/* 385 */,
/* 386 */,
/* 387 */,
/* 388 */,
/* 389 */,
/* 390 */,
/* 391 */,
/* 392 */,
/* 393 */,
/* 394 */,
/* 395 */,
/* 396 */,
/* 397 */,
/* 398 */,
/* 399 */,
/* 400 */,
/* 401 */,
/* 402 */,
/* 403 */,
/* 404 */,
/* 405 */,
/* 406 */,
/* 407 */,
/* 408 */,
/* 409 */,
/* 410 */,
/* 411 */,
/* 412 */,
/* 413 */,
/* 414 */,
/* 415 */,
/* 416 */,
/* 417 */,
/* 418 */,
/* 419 */,
/* 420 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(421);


/***/ }),
/* 421 */
/***/ (function(module, exports, __webpack_require__) {

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var React = __webpack_require__(0);
var ReactDOM = __webpack_require__(14);
var queryString = __webpack_require__(430);
var Fluxxor = __webpack_require__(25);

var MainApp = __webpack_require__(440).default;
var AddColorsApp = __webpack_require__(955).default;
var ManageTypeStylesApp = __webpack_require__(956).default;
var ManageSharedStylesApp = __webpack_require__(957).default;
var ManageSymbolsApp = __webpack_require__(959).default;
var SelectiveSyncApp = __webpack_require__(960).default;

__webpack_require__(961);

var storeCreator = __webpack_require__(963).default;
var stores = storeCreator(history);
var actions = __webpack_require__(28).actions;

var flux = new Fluxxor.Flux(stores, actions);
flux.setDispatchInterceptor(function (action, dispatch) {
  ReactDOM.unstable_batchedUpdates(function () {
    dispatch(action);
  });
});

flux.on('dispatch', function (type, payload) {

  //todo: don't log it in prod
  if (console && console.log) {
    // eslint-disable-line no-console
    if (type !== 'REGISTER_WALKTHROUGH_STEP') {
      var time = new Date();
      var timeString = time.getHours() + ':' + time.getMinutes() + ':' + time.getSeconds() + ',' + time.getMilliseconds();
      console.log('[Dispatch]-' + timeString + ':', type, payload); // eslint-disable-line no-console
    }
  }
});

var params = queryString.parse(window.location.search);
var appElement = {
  MainApp: MainApp,
  AddColorsApp: AddColorsApp,
  ManageTypeStylesApp: ManageTypeStylesApp,
  ManageSharedStylesApp: ManageSharedStylesApp,
  ManageSymbolsApp: ManageSymbolsApp,
  SelectiveSyncApp: SelectiveSyncApp
}[params.appName];

var props = {};

if (!params.nativeHandlers) {
  props.nativeHandlers = [];
} else if (!Array.isArray(params.nativeHandlers)) {
  // If there is only one key in the query string, it will
  // be parsed as a value, not an array. So, here we make it
  // an array.
  props.nativeHandlers = [params.nativeHandlers];
} else {
  props.nativeHandlers = params.nativeHandlers;
}

var createElement = function createElement(Component, props) {
  return React.createElement(Component, _extends({}, props, { flux: flux }));
};

ReactDOM.render(createElement(appElement, props), document.getElementById('main'));

/***/ }),
/* 422 */,
/* 423 */,
/* 424 */,
/* 425 */,
/* 426 */,
/* 427 */,
/* 428 */,
/* 429 */,
/* 430 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var strictUriEncode = __webpack_require__(431);
var objectAssign = __webpack_require__(29);

function encoderForArrayFormat(opts) {
	switch (opts.arrayFormat) {
		case 'index':
			return function (key, value, index) {
				return value === null ? [
					encode(key, opts),
					'[',
					index,
					']'
				].join('') : [
					encode(key, opts),
					'[',
					encode(index, opts),
					']=',
					encode(value, opts)
				].join('');
			};

		case 'bracket':
			return function (key, value) {
				return value === null ? encode(key, opts) : [
					encode(key, opts),
					'[]=',
					encode(value, opts)
				].join('');
			};

		default:
			return function (key, value) {
				return value === null ? encode(key, opts) : [
					encode(key, opts),
					'=',
					encode(value, opts)
				].join('');
			};
	}
}

function parserForArrayFormat(opts) {
	var result;

	switch (opts.arrayFormat) {
		case 'index':
			return function (key, value, accumulator) {
				result = /\[(\d*)\]$/.exec(key);

				key = key.replace(/\[\d*\]$/, '');

				if (!result) {
					accumulator[key] = value;
					return;
				}

				if (accumulator[key] === undefined) {
					accumulator[key] = {};
				}

				accumulator[key][result[1]] = value;
			};

		case 'bracket':
			return function (key, value, accumulator) {
				result = /(\[\])$/.exec(key);
				key = key.replace(/\[\]$/, '');

				if (!result) {
					accumulator[key] = value;
					return;
				} else if (accumulator[key] === undefined) {
					accumulator[key] = [value];
					return;
				}

				accumulator[key] = [].concat(accumulator[key], value);
			};

		default:
			return function (key, value, accumulator) {
				if (accumulator[key] === undefined) {
					accumulator[key] = value;
					return;
				}

				accumulator[key] = [].concat(accumulator[key], value);
			};
	}
}

function encode(value, opts) {
	if (opts.encode) {
		return opts.strict ? strictUriEncode(value) : encodeURIComponent(value);
	}

	return value;
}

function keysSorter(input) {
	if (Array.isArray(input)) {
		return input.sort();
	} else if (typeof input === 'object') {
		return keysSorter(Object.keys(input)).sort(function (a, b) {
			return Number(a) - Number(b);
		}).map(function (key) {
			return input[key];
		});
	}

	return input;
}

exports.extract = function (str) {
	return str.split('?')[1] || '';
};

exports.parse = function (str, opts) {
	opts = objectAssign({arrayFormat: 'none'}, opts);

	var formatter = parserForArrayFormat(opts);

	// Create an object with no prototype
	// https://github.com/sindresorhus/query-string/issues/47
	var ret = Object.create(null);

	if (typeof str !== 'string') {
		return ret;
	}

	str = str.trim().replace(/^(\?|#|&)/, '');

	if (!str) {
		return ret;
	}

	str.split('&').forEach(function (param) {
		var parts = param.replace(/\+/g, ' ').split('=');
		// Firefox (pre 40) decodes `%3D` to `=`
		// https://github.com/sindresorhus/query-string/pull/37
		var key = parts.shift();
		var val = parts.length > 0 ? parts.join('=') : undefined;

		// missing `=` should be `null`:
		// http://w3.org/TR/2012/WD-url-20120524/#collect-url-parameters
		val = val === undefined ? null : decodeURIComponent(val);

		formatter(decodeURIComponent(key), val, ret);
	});

	return Object.keys(ret).sort().reduce(function (result, key) {
		var val = ret[key];
		if (Boolean(val) && typeof val === 'object' && !Array.isArray(val)) {
			// Sort object keys, not values
			result[key] = keysSorter(val);
		} else {
			result[key] = val;
		}

		return result;
	}, Object.create(null));
};

exports.stringify = function (obj, opts) {
	var defaults = {
		encode: true,
		strict: true,
		arrayFormat: 'none'
	};

	opts = objectAssign(defaults, opts);

	var formatter = encoderForArrayFormat(opts);

	return obj ? Object.keys(obj).sort().map(function (key) {
		var val = obj[key];

		if (val === undefined) {
			return '';
		}

		if (val === null) {
			return encode(key, opts);
		}

		if (Array.isArray(val)) {
			var result = [];

			val.slice().forEach(function (val2) {
				if (val2 === undefined) {
					return;
				}

				result.push(formatter(key, val2, result.length));
			});

			return result.join('&');
		}

		return encode(key, opts) + '=' + encode(val, opts);
	}).filter(function (x) {
		return x.length > 0;
	}).join('&') : '';
};


/***/ }),
/* 431 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

module.exports = function (str) {
	return encodeURIComponent(str).replace(/[!'()*]/g, function (c) {
		return '%' + c.charCodeAt(0).toString(16).toUpperCase();
	});
};


/***/ }),
/* 432 */
/***/ (function(module, exports, __webpack_require__) {

var EventEmitter = __webpack_require__(170),
    inherits = __webpack_require__(107),
    objectPath = __webpack_require__(433);

var _ = __webpack_require__(3);

var Dispatcher = __webpack_require__(169);

var findLeaves = function findLeaves(obj, path, callback) {
  path = path || [];

  for (var key in obj) {
    if (obj.hasOwnProperty(key)) {
      if (_.isFunction(obj[key])) {
        callback(path.concat(key), obj[key]);
      } else {
        findLeaves(obj[key], path.concat(key), callback);
      }
    }
  }
};

var Flux = function Flux(stores, actions) {
  EventEmitter.call(this);
  this.dispatcher = new Dispatcher(stores);
  this.actions = {};
  this.stores = {};

  var dispatcher = this.dispatcher;
  var flux = this;
  this.dispatchBinder = {
    flux: flux,
    dispatch: function dispatch(type, payload) {
      try {
        flux.emit("dispatch", type, payload);
      } finally {
        dispatcher.dispatch({ type: type, payload: payload });
      }
    }
  };

  this.addActions(actions);
  this.addStores(stores);
};

inherits(Flux, EventEmitter);

Flux.prototype.addActions = function (actions) {
  findLeaves(actions, [], this.addAction.bind(this));
};

// addAction has two signatures:
// 1: string[, string, string, string...], actionFunction
// 2: arrayOfStrings, actionFunction
Flux.prototype.addAction = function () {
  if (arguments.length < 2) {
    throw new Error("addAction requires at least two arguments, a string (or array of strings) and a function");
  }

  var args = Array.prototype.slice.call(arguments);

  if (!_.isFunction(args[args.length - 1])) {
    throw new Error("The last argument to addAction must be a function");
  }

  var func = args.pop().bind(this.dispatchBinder);

  if (!_.isString(args[0])) {
    args = args[0];
  }

  var leadingPaths = _.reduce(args, function (acc, next) {
    if (acc) {
      var nextPath = acc[acc.length - 1].concat([next]);
      return acc.concat([nextPath]);
    } else {
      return [[next]];
    }
  }, null);

  // Detect trying to replace a function at any point in the path
  _.forEach(leadingPaths, function (path) {
    if (_.isFunction(objectPath.get(this.actions, path))) {
      throw new Error("An action named " + args.join(".") + " already exists");
    }
  }.bind(this));

  // Detect trying to replace a namespace at the final point in the path
  if (objectPath.get(this.actions, args)) {
    throw new Error("A namespace named " + args.join(".") + " already exists");
  }

  objectPath.set(this.actions, args, func, true);
};

Flux.prototype.store = function (name) {
  return this.stores[name];
};

Flux.prototype.getAllStores = function () {
  return this.stores;
};

Flux.prototype.addStore = function (name, store) {
  if (name in this.stores) {
    throw new Error("A store named '" + name + "' already exists");
  }
  store.flux = this;
  this.stores[name] = store;
  this.dispatcher.addStore(name, store);
};

Flux.prototype.addStores = function (stores) {
  for (var key in stores) {
    if (stores.hasOwnProperty(key)) {
      this.addStore(key, stores[key]);
    }
  }
};

Flux.prototype.setDispatchInterceptor = function (fn) {
  this.dispatcher.setDispatchInterceptor(fn);
};

module.exports = Flux;

/***/ }),
/* 433 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (root, factory){
  'use strict';

  /*istanbul ignore next:cant test*/
  if (typeof module === 'object' && typeof module.exports === 'object') {
    module.exports = factory();
  } else if (true) {
    // AMD. Register as an anonymous module.
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {
    // Browser globals
    root.objectPath = factory();
  }
})(this, function(){
  'use strict';

  var
    toStr = Object.prototype.toString,
    _hasOwnProperty = Object.prototype.hasOwnProperty;

  function isEmpty(value){
    if (!value) {
      return true;
    }
    if (isArray(value) && value.length === 0) {
      return true;
    } else {
      for (var i in value) {
        if (_hasOwnProperty.call(value, i)) {
          return false;
        }
      }
      return true;
    }
  }

  function toString(type){
    return toStr.call(type);
  }

  function isNumber(value){
    return typeof value === 'number' || toString(value) === "[object Number]";
  }

  function isString(obj){
    return typeof obj === 'string' || toString(obj) === "[object String]";
  }

  function isObject(obj){
    return typeof obj === 'object' && toString(obj) === "[object Object]";
  }

  function isArray(obj){
    return typeof obj === 'object' && typeof obj.length === 'number' && toString(obj) === '[object Array]';
  }

  function isBoolean(obj){
    return typeof obj === 'boolean' || toString(obj) === '[object Boolean]';
  }

  function getKey(key){
    var intKey = parseInt(key);
    if (intKey.toString() === key) {
      return intKey;
    }
    return key;
  }

  function set(obj, path, value, doNotReplace){
    if (isNumber(path)) {
      path = [path];
    }
    if (isEmpty(path)) {
      return obj;
    }
    if (isString(path)) {
      return set(obj, path.split('.'), value, doNotReplace);
    }
    var currentPath = getKey(path[0]);

    if (path.length === 1) {
      var oldVal = obj[currentPath];
      if (oldVal === void 0 || !doNotReplace) {
        obj[currentPath] = value;
      }
      return oldVal;
    }

    if (obj[currentPath] === void 0) {
      if (isNumber(currentPath)) {
        obj[currentPath] = [];
      } else {
        obj[currentPath] = {};
      }
    }

    return set(obj[currentPath], path.slice(1), value, doNotReplace);
  }

  function del(obj, path) {
    if (isNumber(path)) {
      path = [path];
    }

    if (isEmpty(obj)) {
      return void 0;
    }

    if (isEmpty(path)) {
      return obj;
    }
    if(isString(path)) {
      return del(obj, path.split('.'));
    }

    var currentPath = getKey(path[0]);
    var oldVal = obj[currentPath];

    if(path.length === 1) {
      if (oldVal !== void 0) {
        if (isArray(obj)) {
          obj.splice(currentPath, 1);
        } else {
          delete obj[currentPath];
        }
      }
    } else {
      if (obj[currentPath] !== void 0) {
        return del(obj[currentPath], path.slice(1));
      }
    }

    return obj;
  }

  var objectPath = {};

  objectPath.ensureExists = function (obj, path, value){
    return set(obj, path, value, true);
  };

  objectPath.set = function (obj, path, value, doNotReplace){
    return set(obj, path, value, doNotReplace);
  };

  objectPath.insert = function (obj, path, value, at){
    var arr = objectPath.get(obj, path);
    at = ~~at;
    if (!isArray(arr)) {
      arr = [];
      objectPath.set(obj, path, arr);
    }
    arr.splice(at, 0, value);
  };

  objectPath.empty = function(obj, path) {
    if (isEmpty(path)) {
      return obj;
    }
    if (isEmpty(obj)) {
      return void 0;
    }

    var value, i;
    if (!(value = objectPath.get(obj, path))) {
      return obj;
    }

    if (isString(value)) {
      return objectPath.set(obj, path, '');
    } else if (isBoolean(value)) {
      return objectPath.set(obj, path, false);
    } else if (isNumber(value)) {
      return objectPath.set(obj, path, 0);
    } else if (isArray(value)) {
      value.length = 0;
    } else if (isObject(value)) {
      for (i in value) {
        if (_hasOwnProperty.call(value, i)) {
          delete value[i];
        }
      }
    } else {
      return objectPath.set(obj, path, null);
    }
  };

  objectPath.push = function (obj, path /*, values */){
    var arr = objectPath.get(obj, path);
    if (!isArray(arr)) {
      arr = [];
      objectPath.set(obj, path, arr);
    }

    arr.push.apply(arr, Array.prototype.slice.call(arguments, 2));
  };

  objectPath.coalesce = function (obj, paths, defaultValue) {
    var value;

    for (var i = 0, len = paths.length; i < len; i++) {
      if ((value = objectPath.get(obj, paths[i])) !== void 0) {
        return value;
      }
    }

    return defaultValue;
  };

  objectPath.get = function (obj, path, defaultValue){
    if (isNumber(path)) {
      path = [path];
    }
    if (isEmpty(path)) {
      return obj;
    }
    if (isEmpty(obj)) {
      return defaultValue;
    }
    if (isString(path)) {
      return objectPath.get(obj, path.split('.'), defaultValue);
    }

    var currentPath = getKey(path[0]);

    if (path.length === 1) {
      if (obj[currentPath] === void 0) {
        return defaultValue;
      }
      return obj[currentPath];
    }

    return objectPath.get(obj[currentPath], path.slice(1), defaultValue);
  };

  objectPath.del = function(obj, path) {
    return del(obj, path);
  };

  return objectPath;
});

/***/ }),
/* 434 */
/***/ (function(module, exports) {

var FluxMixin = function FluxMixin(React) {
  return {
    componentWillMount: function componentWillMount() {
      if (!this.props.flux && (!this.context || !this.context.flux)) {
        var namePart = this.constructor.displayName ? " of " + this.constructor.displayName : "";
        throw new Error("Could not find flux on this.props or this.context" + namePart);
      }
    },

    childContextTypes: {
      flux: React.PropTypes.object
    },

    contextTypes: {
      flux: React.PropTypes.object
    },

    getChildContext: function getChildContext() {
      return {
        flux: this.getFlux()
      };
    },

    getFlux: function getFlux() {
      return this.props.flux || this.context && this.context.flux;
    }
  };
};

FluxMixin.componentWillMount = function () {
  throw new Error("Fluxxor.FluxMixin is a function that takes React as a " + "parameter and returns the mixin, e.g.: mixins: [Fluxxor.FluxMixin(React)]");
};

module.exports = FluxMixin;

/***/ }),
/* 435 */
/***/ (function(module, exports) {

var FluxChildMixin = function FluxChildMixin(React) {
  return {
    componentWillMount: function componentWillMount() {
      if (console && console.warn) {
        var namePart = this.constructor.displayName ? " in " + this.constructor.displayName : "",
            message = "Fluxxor.FluxChildMixin was found in use" + namePart + ", " + "but has been deprecated. Use Fluxxor.FluxMixin instead.";
        console.warn(message);
      }
    },

    contextTypes: {
      flux: React.PropTypes.object
    },

    getFlux: function getFlux() {
      return this.context.flux;
    }
  };
};

FluxChildMixin.componentWillMount = function () {
  throw new Error("Fluxxor.FluxChildMixin is a function that takes React as a " + "parameter and returns the mixin, e.g.: mixins[Fluxxor.FluxChildMixin(React)]");
};

module.exports = FluxChildMixin;

/***/ }),
/* 436 */
/***/ (function(module, exports, __webpack_require__) {

var _ = __webpack_require__(3);

var StoreWatchMixin = function StoreWatchMixin() {
  var storeNames = Array.prototype.slice.call(arguments);
  return {
    componentDidMount: function componentDidMount() {
      var flux = this.props.flux || this.context.flux;
      this.mounted = true;

      // No autobinding in ES6 classes
      this._setStateFromFlux = function () {
        if (this.mounted) {
          this.setState(this.getStateFromFlux());
        }
      }.bind(this);

      _.forEach(storeNames, function (store) {
        flux.store(store).on("change", this._setStateFromFlux);
      }.bind(this));
    },

    componentWillUnmount: function componentWillUnmount() {
      var flux = this.props.flux || this.context.flux;
      this.mounted = false;
      _.forEach(storeNames, function (store) {
        flux.store(store).removeListener("change", this._setStateFromFlux);
      }.bind(this));
    },

    getInitialState: function getInitialState() {
      return this.getStateFromFlux();
    }
  };
};

StoreWatchMixin.componentWillMount = function () {
  throw new Error("Fluxxor.StoreWatchMixin is a function that takes one or more " + "store names as parameters and returns the mixin, e.g.: " + "mixins: [Fluxxor.StoreWatchMixin(\"Store1\", \"Store2\")]");
};

module.exports = StoreWatchMixin;

/***/ }),
/* 437 */
/***/ (function(module, exports, __webpack_require__) {

var _ = __webpack_require__(3);

var Store = __webpack_require__(438);
var inherits = __webpack_require__(107);

var RESERVED_KEYS = ["flux", "waitFor"];

var createStore = function createStore(spec) {
  _.forEach(RESERVED_KEYS, function (key) {
    if (spec[key]) {
      throw new Error("Reserved key '" + key + "' found in store definition");
    }
  });

  var constructor = function constructor(options) {
    options = options || {};
    Store.call(this);

    for (var key in spec) {
      if (key === "actions") {
        this.bindActions(spec[key]);
      } else if (key === "initialize") {
        // do nothing
      } else if (_.isFunction(spec[key])) {
        this[key] = spec[key].bind(this);
      } else {
        this[key] = spec[key];
      }
    }

    if (spec.initialize) {
      spec.initialize.call(this, options);
    }
  };

  inherits(constructor, Store);
  return constructor;
};

module.exports = createStore;

/***/ }),
/* 438 */
/***/ (function(module, exports, __webpack_require__) {

var EventEmitter = __webpack_require__(170),
    inherits = __webpack_require__(107);

var _ = __webpack_require__(3);

function Store(dispatcher) {
  this.dispatcher = dispatcher;
  this.__actions__ = {};
  EventEmitter.call(this);
}

inherits(Store, EventEmitter);

Store.prototype.__handleAction__ = function (action) {
  var handler;
  if (!!(handler = this.__actions__[action.type])) {
    if (_.isFunction(handler)) {
      handler.call(this, action.payload, action.type);
    } else if (handler && _.isFunction(this[handler])) {
      this[handler].call(this, action.payload, action.type);
    } else {
      throw new Error("The handler for action type " + action.type + " is not a function");
    }
    return true;
  } else {
    return false;
  }
};

Store.prototype.bindActions = function () {
  var actions = Array.prototype.slice.call(arguments);

  if (actions.length > 1 && actions.length % 2 !== 0) {
    throw new Error("bindActions must take an even number of arguments.");
  }

  var bindAction = function (type, handler) {
    if (!handler) {
      throw new Error("The handler for action type " + type + " is falsy");
    }

    this.__actions__[type] = handler;
  }.bind(this);

  if (actions.length === 1 && _.isObject(actions[0])) {
    actions = actions[0];
    for (var key in actions) {
      if (actions.hasOwnProperty(key)) {
        bindAction(key, actions[key]);
      }
    }
  } else {
    for (var i = 0; i < actions.length; i += 2) {
      var type = actions[i],
          handler = actions[i + 1];

      if (!type) {
        throw new Error("Argument " + (i + 1) + " to bindActions is a falsy value");
      }

      bindAction(type, handler);
    }
  }
};

Store.prototype.waitFor = function (stores, fn) {
  this.dispatcher.waitForStores(this, stores, fn.bind(this));
};

module.exports = Store;

/***/ }),
/* 439 */
/***/ (function(module, exports) {

module.exports = "1.7.3";

/***/ }),
/* 440 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_flux_stores__ = __webpack_require__(171);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__containers_AlertsContainer__ = __webpack_require__(464);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__util__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__sketch__ = __webpack_require__(18);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__native_applications_App__ = __webpack_require__(46);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__styleguide_StyleguidePage__ = __webpack_require__(589);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__onboarding_SignupForms__ = __webpack_require__(858);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__ApplicationNav__ = __webpack_require__(859);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__LoadingIndicator__ = __webpack_require__(945);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__components_library_PreventDrop__ = __webpack_require__(947);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__FullScreenMessages__ = __webpack_require__(948);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__LoginScreen__ = __webpack_require__(949);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__IntroductionFlow__ = __webpack_require__(951);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15__TrialSubscriptionHeader__ = __webpack_require__(952);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16__services_load_analytics__ = __webpack_require__(953);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17_design_systems_lib__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17_design_systems_lib___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_17_design_systems_lib__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_18__brandai_design_systems_web__ = __webpack_require__(42);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_18__brandai_design_systems_web___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_18__brandai_design_systems_web__);
var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }


























var TrialExpired = __WEBPACK_IMPORTED_MODULE_18__brandai_design_systems_web__["compositeComponents"].TrialExpired,
    StartTrialFlow = __WEBPACK_IMPORTED_MODULE_18__brandai_design_systems_web__["compositeComponents"].StartTrialFlow;


var INTERVAL_TO_CHECK_TOKEN = 1000 * 60 * 5; //  5 minutes

var MainApp = function (_App) {
  _inherits(MainApp, _App);

  function MainApp(props) {
    _classCallCheck(this, MainApp);

    var _this = _possibleConstructorReturn(this, (MainApp.__proto__ || Object.getPrototypeOf(MainApp)).call(this, props));

    _this.state = {};
    //TODO: kim will tell me how to fix this
    __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.merge(_this.state, _this.getInitialState());
    return _this;
  }

  _createClass(MainApp, [{
    key: 'getStateFromFlux',
    value: function getStateFromFlux(flux) {
      var userStore = flux.store('UserStore');
      var organizationStore = flux.store('OrganizationStore');
      var searchResultsStore = flux.store('SearchResultsStore');
      var styleguideStore = flux.store('StyleguideStore');
      var navigationStore = flux.store('NavigationStore');
      var applicationStore = flux.store('ApplicationStore');
      var apiClientStore = flux.store('ApiClientStore');
      var shouldLog = "prod" === 'dev';
      if (shouldLog) {
        console.log('get state from flux'); // eslint-disable-line no-console
      }

      //todo: change how the filtered data working
      var state = {
        user: userStore.user,
        idToken: userStore.idToken,
        initialIdToken: userStore.initialIdToken,
        refreshToken: userStore.refreshToken,
        loadingUser: userStore.loadingUser,
        invisionAuthMode: userStore.invisionAuthMode,
        loadingOrganizations: organizationStore.loadingOrganizations,
        organizations: organizationStore.organizations,
        organizationExistMessage: organizationStore.organizationExistMessage,
        organizationErrorData: organizationStore.organizationErrorData,
        currentOrganization: organizationStore.getCurrentOrganization(),
        shouldReloadOrganizations: organizationStore.shouldReloadOrganizations,
        trialFeatureEnabled: organizationStore.trialFeatureEnabled,
        inStartTrialFlow: organizationStore.inStartTrialFlow(),
        currentOrganizationTrialExpired: organizationStore.currentOrganizationTrialExpired,

        filteredStyleData: searchResultsStore.filteredStyleguide,
        searchQuery: searchResultsStore.styleDataSearchQuery,

        styleData: styleguideStore.styleData,
        styleguide: styleguideStore.styleguide,
        styleguideId: styleguideStore.getStyleguideId(),
        snapshotId: styleguideStore.getSnapshotId(),
        styleguideError: styleguideStore.styleguideError,
        loadingStyleData: styleguideStore.loadingStyleData,
        relativeUpdateDate: styleguideStore.relativeUpdateDate,
        readOnly: styleguideStore.isReadOnly(),
        styleDataImageHashes: styleguideStore.styleDataImageHashes,
        editingItemID: styleguideStore.editingItemID,
        editingSource: styleguideStore.editingSource,
        shouldReloadStyleguide: styleguideStore.shouldReloadStyleguide,
        prefetchingStyleData: styleguideStore.prefetchingStyleData,
        prefetchingStyleDataFailed: styleguideStore.prefetchingStyleDataFailed,
        initialStyleguideId: styleguideStore.initialStyleguideId, //the value of the styleguideId persisted in defaults
        shouldReorderStyleguide: styleguideStore.canReorder,

        selectedType: navigationStore.selectedType,
        selectedFolderId: navigationStore.selectedFolderId,
        selectedFolder: navigationStore.selectedFolder,
        selectedStyleEntity: navigationStore.getSelectedEntityData(),
        selectedSectionId: navigationStore.selectedSectionId,
        toggledNodes: navigationStore.toggledNodes,
        addingFolder: navigationStore.addingFolder,

        updatingDocument: applicationStore.updatingDocument,
        baseHost: apiClientStore.getBaseHost()
      };

      //if no connection override explicitly the state from store
      if (!this.state.connected || state.currentOrganizationTrialExpired) {
        state.readOnly = true;
      }
      if (shouldLog) {
        console.log(state); // eslint-disable-line no-console
      }
      return state;
    }
  }, {
    key: '_handleEvent',
    value: function _handleEvent(eventData) {
      var handler = this[eventData.eventName];
      if (!handler && this.props.actions) {
        handler = this.props.actions[eventData.eventName];
      }
      if (!handler) {
        Object(__WEBPACK_IMPORTED_MODULE_4__util__["h" /* debug */])('No event handler for web UI event "' + eventData.eventName + '"');
      } else {
        handler.call(this, eventData.payload);
      }
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      var _this2 = this;

      // Put event handling function on the window so it can be called from the
      // native UI.
      window.dsm = window.dsm || {};
      window.dsm.handleEvent = this._handleEvent.bind(this);

      // Prevent default context menu unless holding option key (for development).
      window.oncontextmenu = function (evt) {
        if (!evt.altKey) {
          evt.preventDefault();
        }
      };

      window.onblur = function () {
        __WEBPACK_IMPORTED_MODULE_5__sketch__["g" /* postNativeUIEvent */]('onWindowDidBlur');
      };

      // Init job queue.
      window.dsm.jobQueue = [];

      // Everything is set up, inform the native UI that we are ready.
      __WEBPACK_IMPORTED_MODULE_5__sketch__["g" /* postNativeUIEvent */]('onWebUIDidFinishLoading');

      window.addEventListener('unhandledrejection', function (event) {
        var reason = __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.get(event, 'detail.reason') || event;

        console.error(reason); // eslint-disable-line no-console
        _this2.props.actions.onLogMessage('error', { message: 'Unhandled Rejection', reason: reason });
      });
    }
  }, {
    key: 'componentWillUpdate',
    value: function componentWillUpdate(nextProps, nextState) {
      var _this3 = this;

      //if we now have a signed in user load organizations (token can exist even if we don't yet know the authentication will be successful)
      if (nextState.connected && !this.state.idToken && nextState.idToken) {
        this.props.actions.loadUserOrganizations();
      }

      // load analytics once we are connected and have a URL
      if (nextState.connected && nextState.baseHost && !(this.state.connected && this.state.baseHost)) {
        Object(__WEBPACK_IMPORTED_MODULE_16__services_load_analytics__["a" /* loadAnalytics */])(nextState.baseHost, nextState.invisionAuthMode, function (message, err) {
          return _this3.props.actions.onLogMessage('error', { message: message, err: err });
        }, function () {
          return _this3.props.actions.onIdentifyUser();
        });
      }

      //meaning we have a signed user who completed the sign up steps
      if (!this.state.shouldReloadStyleguide && nextState.shouldReloadStyleguide && __WEBPACK_IMPORTED_MODULE_4__util__["u" /* isNonEmptyArray */](nextState.organizations)) {

        //if user organization loaded and we have styleguide, try to load it
        var _styleguideToLoad = this.styleguideToLoad(nextState, nextState.styleguideId || nextState.initialStyleguideId),
            styleguideId = _styleguideToLoad.styleguideId;

        if (styleguideId === this.state.styleguideId) {
          this.refreshStyleData();
        } else {
          this.loadStyleData(styleguideId);
        }
      }

      if (!this.state.shouldReloadOrganizations && nextState.shouldReloadOrganizations) {
        this.props.actions.loadUserOrganizations();
      }
    }
  }, {
    key: 'needToShowLoginDialog',
    value: function needToShowLoginDialog(state) {
      return !!state.connected && !state.idToken && !state.initialIdToken;
    }
  }, {
    key: 'renderApplication',
    value: function renderApplication(styleData, content) {
      var actions = this.props.actions;

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        __WEBPACK_IMPORTED_MODULE_11__components_library_PreventDrop__["a" /* default */],
        {
          className: 'u-flex',
          onDropCallback: actions.setReorderIntent.bind(null, false)
        },
        this.renderApplicationNav(styleData),
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          { className: 'flex-auto u-no-min-width' },
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_15__TrialSubscriptionHeader__["a" /* default */], {
            organization: this.state.currentOrganization, onTrialExpired: actions.trialPeriodExpired, onManagePlans: actions.comparePlans
          }),
          content
        ),
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3__containers_AlertsContainer__["a" /* default */], null)
      );
    }

    // Renderers for different plugin parts

  }, {
    key: 'renderApplicationNav',
    value: function renderApplicationNav(styleData) {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__ApplicationNav__["a" /* default */], _extends({}, this.state, { styleData: styleData }));
    }
  }, {
    key: 'renderStyleguideApp',
    value: function renderStyleguideApp(styleData) {

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_7__styleguide_StyleguidePage__["a" /* default */], {
        styleData: styleData,
        selectedType: this.state.selectedType,
        selectedFolder: this.state.selectedFolder,
        readOnly: this.state.readOnly,
        isSearching: !!this.state.searchQuery,
        searchQuery: this.state.searchQuery,
        editingItemID: this.state.editingItemID,
        editingSource: this.state.editingSource,
        onAddLogosInWeb: this.props.actions.openStyleguideInBrowser,
        installedFonts: this.state.installedFonts,
        selectedLayerCount: this.state.selectedLayerCount,
        prefetchingStyleData: this.state.prefetchingStyleData,
        selectedStyleEntity: this.state.selectedStyleEntity,
        selectedSectionId: this.state.selectedSectionId,
        canReorder: this.state.shouldReorderStyleguide,
        addingFolder: this.state.addingFolder
      });
    }
  }, {
    key: 'renderSignupForms',
    value: function renderSignupForms() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__onboarding_SignupForms__["a" /* default */], {
        user: this.state.user,
        idToken: this.state.idToken,
        organizationExistMessage: this.state.organizationExistMessage,
        onCreateOrganization: this._createOrganization.bind(this),
        checkOrganizationExists: this.props.actions.checkOrganizationExists,
        onUpdateUserDetails: this.props.actions.updateUserDetails,
        onTermsClicked: this.props.actions.viewTermsPage,
        onSignOut: this.props.actions.onUserSignedOut
      });
    }
  }, {
    key: 'renderTrialExpiredPage',
    value: function renderTrialExpiredPage(trialExpiredElementKey) {
      var actions = this.props.actions;
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(TrialExpired, {
        small: true,
        onManagePlans: function onManagePlans() {
          actions.dismissUIElement(trialExpiredElementKey);
          actions.comparePlans();
        },
        onClose: function onClose() {
          return actions.dismissUIElement(trialExpiredElementKey);
        }
      });
    }
  }, {
    key: 'renderStartTrialFlow',
    value: function renderStartTrialFlow() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(StartTrialFlow, {
        onContinue: this.props.actions.startOrganizationTrial,
        onFinish: this.props.actions.trialStartConfirmed,
        organization: this.state.currentOrganization,
        small: true,
        updateMinimumSize: function updateMinimumSize(dimensions) {
          return __WEBPACK_IMPORTED_MODULE_5__sketch__["g" /* postNativeUIEvent */]('onChangeMainWindowSize', dimensions);
        },
        onComparePlans: this.props.actions.comparePlans
      });
    }
  }, {
    key: 'render',
    value: function render() {

      if (this.state.needsRestart) {
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_12__FullScreenMessages__["e" /* RestartSketchMessage */], { restartSketch: this.restartSketch });
      }

      if (this.state.connected === false && !this.state.idToken) {
        //explicit no connection
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_12__FullScreenMessages__["b" /* NoConnectionMessage */], null);
      }

      if (this.needToShowLoginDialog(this.state)) {
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_13__LoginScreen__["a" /* LoginScreen */], null);
      }

      var styleData = this.state.searchQuery ? this.state.filteredStyleData : this.state.styleData;

      if (this.isLoading()) {
        if (!styleData) {
          return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_10__LoadingIndicator__["a" /* default */], { fullScreen: true });
        }

        return this.renderApplication(styleData, __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_10__LoadingIndicator__["a" /* default */], { fullScreen: false }));
      }

      if (this.state.organizationErrorData) {
        return this.renderApplication(styleData, __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_12__FullScreenMessages__["d" /* OrganizationLoadErrMessage */], {
          errorData: this.state.organizationErrorData,
          baseHost: this.state.baseHost,
          onSignOut: this.props.actions.onUserSignedOut }));
      }

      if (this.state.styleguideError) {
        return this.renderApplication(styleData, __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_12__FullScreenMessages__["a" /* ApplicationErrMessage */], { error: this.state.styleguideError }));
      }

      if (this.state.user) {
        if (!__WEBPACK_IMPORTED_MODULE_17_design_systems_lib__["utils"].isUIElementDismissed(this.state.user, 'SKETCH_INTRODUCTION_VIDEO')) {
          return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_14__IntroductionFlow__["a" /* default */], {
            trialFeatureEnabled: this.state.trialFeatureEnabled,
            onGetStarted: this.props.actions.dismissUIElement.bind(null, 'SKETCH_INTRODUCTION_VIDEO') });
        }

        if (!__WEBPACK_IMPORTED_MODULE_4__util__["u" /* isNonEmptyArray */](this.state.organizations)) {
          return this.renderSignupForms();
        }

        if (this.state.inStartTrialFlow) {
          return this.renderStartTrialFlow();
        }
      }

      var trialExpiredElementKey = 'TRIAL_EXPIRED-' + __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.get(this.state.currentOrganization, '_id');
      if (this.state.currentOrganizationTrialExpired && !__WEBPACK_IMPORTED_MODULE_17_design_systems_lib__["utils"].isUIElementDismissed(this.state.user, trialExpiredElementKey)) {
        return this.renderTrialExpiredPage(trialExpiredElementKey);
      }

      if (__WEBPACK_IMPORTED_MODULE_4__util__["v" /* isNonEmptyObject */](styleData)) {
        return this.renderApplication(styleData, this.renderStyleguideApp(styleData));
      }

      return this.renderApplication(styleData, __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_12__FullScreenMessages__["c" /* NoLibrariesExistMessage */], { viewHomepage: this.props.actions.viewHomepage }));
    }
  }, {
    key: 'isLoading',
    value: function isLoading() {
      //this.state.connected === undefined means we dont know yet the status of the connection so treat as loading
      return this.state.loadingStyleData || this.state.loadingUser || this.state.loadingOrganizations || this.state.connected === undefined;
    }

    // data loaders methods

  }, {
    key: 'styleguideToLoad',
    value: function styleguideToLoad(state, styleguideId) {
      var styleguideToLoad = void 0;

      var defaultOrganization = state.currentOrganization;

      //check if the stored styleguide id is part of this user organizations and find what organization it is
      var styleguideOrganizations = __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.chain(state.organizations).map(function (org) {
        var styleguides = org.styleguides || [];
        var found = __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.find(styleguides, { _id: styleguideId });
        if (!found) {
          return null;
        }
        return org;
      }).compact().value();

      if (styleguideId && __WEBPACK_IMPORTED_MODULE_4__util__["u" /* isNonEmptyArray */](styleguideOrganizations)) {
        styleguideToLoad = styleguideId;
        var styleguideOrganization = styleguideOrganizations[0];
        if (styleguideOrganization._id !== __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.get(defaultOrganization, '_id')) {
          this.props.actions.setDefaultOrganization(styleguideOrganization._id);
          defaultOrganization = styleguideOrganization;
        }
      } else {
        //if we decided not to load the saved styleguide then choose the first from the default organization
        if (__WEBPACK_IMPORTED_MODULE_4__util__["u" /* isNonEmptyArray */](defaultOrganization.styleguides)) {
          styleguideToLoad = defaultOrganization.styleguides[0]._id;
        }
      }
      return { styleguideId: styleguideToLoad, defaultOrganization: defaultOrganization };
    }

    /**
     * Load styleguide and update the state according to the results of the fetch
     *
     * Used in working copy and snapshot fetching
     * @param styleguideId
     */

  }, {
    key: 'loadStyleData',
    value: function loadStyleData(styleguideId, requestedSnapshotId) {
      var latestSnapshot = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      this.props.actions.loadStyleData(styleguideId, {
        snapshotId: requestedSnapshotId,
        latestSnapshot: latestSnapshot,
        withVersions: true
      });
    }

    /* *
     * Similar to loadStyleguide except:
     *   will not cleaning the style data upon and replace only when new data is fetched
     *   search filter will be preserved
     *   and we will not create new subscription as one already exists
     *
     * Should be use only within the currently loaded styleguide/snapshot
     */

  }, {
    key: 'refreshStyleData',
    value: function refreshStyleData() {
      this.props.actions.refreshStyleData();
    }

    //callback for creating new organization

  }, {
    key: '_createOrganization',
    value: function _createOrganization(organizationData) {
      this.props.actions.createOrganization(organizationData);
    }

    // Native events publishers

  }, {
    key: 'runNextJobInQueue',
    value: function runNextJobInQueue() {
      var nextJobId = window.dsm.jobQueue.shift();
      if (nextJobId) {
        Object(__WEBPACK_IMPORTED_MODULE_4__util__["h" /* debug */])('Running job with id \'' + nextJobId + '\'');
        setTimeout(function () {
          return __WEBPACK_IMPORTED_MODULE_5__sketch__["g" /* postNativeUIEvent */]('onRunJob', nextJobId);
        }, 5);
      } else {
        __WEBPACK_IMPORTED_MODULE_5__sketch__["g" /* postNativeUIEvent */]('onAllJobsDidFinish');
      }
    }

    // Native UI event handlers.

  }, {
    key: 'onLaunchPlugin',
    value: function onLaunchPlugin(payload) {
      var _this4 = this;

      Object(__WEBPACK_IMPORTED_MODULE_4__util__["h" /* debug */])('API key: ' + payload.idToken);
      Object(__WEBPACK_IMPORTED_MODULE_4__util__["h" /* debug */])(payload);

      payload.setConnectionStatus = this.setConnectionStatus.bind(this);
      this.props.actions.pluginLaunched(payload);

      //here the state is updated with all the stored data
      this.setState(payload, function () {

        //execute token refresh upon timeout execution and every interval since then
        // we need the first one as we don't have timestamp stored in the local storage and will not have correct token refresh on user load otherwise
        setInterval(_this4._refreshAuthToken.bind(_this4), INTERVAL_TO_CHECK_TOKEN);
      });

      var sketchVersion = payload.sketchVersion,
          pluginVersion = payload.pluginVersion,
          styleguideId = payload.styleguideId,
          domainInfo = payload.domainInfo;

      this.props.actions.onLogMessage('info', {
        message: 'Plugin launched',
        sketchVersion: sketchVersion,
        pluginVersion: pluginVersion,
        styleguideId: styleguideId,
        domainInfo: domainInfo
      });
    }
  }, {
    key: '_refreshAuthToken',
    value: function _refreshAuthToken() {
      Object(__WEBPACK_IMPORTED_MODULE_4__util__["h" /* debug */])('_refreshAuthToken interval: token - ' + this.state.refreshToken + ', connected - ' + this.state.connected);
      if (this.state.refreshToken && this.state.connected) {
        this.props.actions.refreshToken();
      }
    }

    /* *
      Refresh user data with delayed execution
       This function is called after connection is returned. Delay it and check if after timeout the connection is still available.
      This should help to avoid refreshing user data when the connection is 'jumpy'.
    **/

  }, {
    key: '_delayedRefreshUserData',
    value: function _delayedRefreshUserData() {
      var _this5 = this;

      if (this.refreshAllTimer) {
        clearTimeout(this.refreshAllTimer);
        this.refreshAllTimer = null;
      }

      this.refreshAllTimer = setTimeout(function () {
        if (_this5.state.connected) {
          _this5.props.actions.onLogMessage('info', { message: 'start refreshing user data after connection regained' });

          _this5.props.actions.refreshToken(false, function () {

            // refresh organizations
            _this5.props.actions.refreshUserOrganizations();

            //styleguide are always refreshed after organization are reloaded

            _this5.refreshAllTimer = null;
          });
        }
      }, 3 * 1000);
    }

    //receive an indication if we have a valid connection now

  }, {
    key: 'setConnectionStatus',
    value: function setConnectionStatus(connected) {
      var _this6 = this;

      Object(__WEBPACK_IMPORTED_MODULE_4__util__["h" /* debug */])('set connection status - ' + connected);

      //if there was indication that the state changed from disconnected, fetch the style data
      //(it is explicit false as we want to distinguish the initial setConnectionStatus call on which we don't want to fetch the data as it was just loaded)
      if (this.state.connected === false && connected) {
        //reload only if the user was already loaded
        if (this.state.user) {
          this._delayedRefreshUserData();
        }
      }

      //this will happen after initial launch and only after we have a valid connection
      if (!this.state.user && !this.state.connected && connected && this.state.initialIdToken && (this.state.refreshToken || __WEBPACK_IMPORTED_MODULE_4__util__["w" /* isV7 */](this.state.invisionAuthMode))) {
        this.setState({ connected: connected }, function () {
          _this6.props.actions.refreshToken(true);
        });
        return;
      }

      //we want the style data not to be editable if there is not connection so updating readOnly property of the styleguide based on the status
      if (this.state.connected !== connected) {
        var editable = connected && this.state.styleguide && this.state.styleguide.allowEditing;
        this.setState({ readOnly: !editable, connected: connected });
      }
    }
  }, {
    key: 'onInstalledFontsAvailable',
    value: function onInstalledFontsAvailable(installedFonts) {
      this.setState({ installedFonts: installedFonts });
    }
  }, {
    key: 'onSelectionDidChange',
    value: function onSelectionDidChange(counts) {
      this.setState(counts);
    }
  }, {
    key: 'onQueueJob',
    value: function onQueueJob(jobId) {
      window.dsm.jobQueue.push(jobId);
    }
  }, {
    key: 'onStartRunningJobsInQueue',
    value: function onStartRunningJobsInQueue() {
      Object(__WEBPACK_IMPORTED_MODULE_4__util__["h" /* debug */])('start running jobs');
      // Run the first job. When it finishes, the the next one will be run, etc.
      this.runNextJobInQueue();
    }
  }, {
    key: 'onJobDidFinish',
    value: function onJobDidFinish() {
      // After each job, run the next one.
      this.runNextJobInQueue();
    }
  }, {
    key: 'onCallback',
    value: function onCallback(_ref) {
      var callbackID = _ref.callbackID,
          payload = _ref.payload;

      var callback = window.dsm['callback-' + callbackID];
      if (callback) {
        callback(payload);
      }
    }

    //consider native calling to action directly

  }, {
    key: 'onLogMessage',
    value: function onLogMessage(_ref2) {
      var level = _ref2.level,
          _ref2$data = _ref2.data,
          data = _ref2$data === undefined ? {} : _ref2$data;

      this.props.actions.onLogMessage(level, data);
    }
  }]);

  return MainApp;
}(__WEBPACK_IMPORTED_MODULE_6__native_applications_App__["a" /* default */]);

/* harmony default export */ __webpack_exports__["default"] = (Object(__WEBPACK_IMPORTED_MODULE_2_flux_stores__["a" /* default */])(['StyleguideStore', 'NavigationStore', 'UserStore', 'OrganizationStore', 'SearchResultsStore', 'ApplicationStore'])(MainApp));

/***/ }),
/* 441 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
exports['default'] = shallowEqual;

function shallowEqual(objA, objB) {
  if (objA === objB) {
    return true;
  }

  if (typeof objA !== 'object' || objA === null || typeof objB !== 'object' || objB === null) {
    return false;
  }

  var keysA = Object.keys(objA);
  var keysB = Object.keys(objB);

  if (keysA.length !== keysB.length) {
    return false;
  }

  // Test for A's keys different from B.
  var bHasOwnProperty = Object.prototype.hasOwnProperty.bind(objB);
  for (var i = 0; i < keysA.length; i++) {
    if (!bHasOwnProperty(keysA[i]) || objA[keysA[i]] !== objB[keysA[i]]) {
      return false;
    }
  }

  return true;
}

module.exports = exports['default'];

/***/ }),
/* 442 */
/***/ (function(module, exports, __webpack_require__) {

var arrayEach = __webpack_require__(443),
    baseEach = __webpack_require__(172),
    castFunction = __webpack_require__(461),
    isArray = __webpack_require__(26);

/**
 * Iterates over elements of `collection` and invokes `iteratee` for each element.
 * The iteratee is invoked with three arguments: (value, index|key, collection).
 * Iteratee functions may exit iteration early by explicitly returning `false`.
 *
 * **Note:** As with other "Collections" methods, objects with a "length"
 * property are iterated like arrays. To avoid this behavior use `_.forIn`
 * or `_.forOwn` for object iteration.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @alias each
 * @category Collection
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} [iteratee=_.identity] The function invoked per iteration.
 * @returns {Array|Object} Returns `collection`.
 * @see _.forEachRight
 * @example
 *
 * _.forEach([1, 2], function(value) {
 *   console.log(value);
 * });
 * // => Logs `1` then `2`.
 *
 * _.forEach({ 'a': 1, 'b': 2 }, function(value, key) {
 *   console.log(key);
 * });
 * // => Logs 'a' then 'b' (iteration order is not guaranteed).
 */
function forEach(collection, iteratee) {
  var func = isArray(collection) ? arrayEach : baseEach;
  return func(collection, castFunction(iteratee));
}

module.exports = forEach;


/***/ }),
/* 443 */
/***/ (function(module, exports) {

/**
 * A specialized version of `_.forEach` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns `array`.
 */
function arrayEach(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (iteratee(array[index], index, array) === false) {
      break;
    }
  }
  return array;
}

module.exports = arrayEach;


/***/ }),
/* 444 */,
/* 445 */,
/* 446 */,
/* 447 */,
/* 448 */,
/* 449 */,
/* 450 */,
/* 451 */,
/* 452 */,
/* 453 */,
/* 454 */,
/* 455 */,
/* 456 */,
/* 457 */,
/* 458 */,
/* 459 */,
/* 460 */,
/* 461 */
/***/ (function(module, exports, __webpack_require__) {

var identity = __webpack_require__(178);

/**
 * Casts `value` to `identity` if it's not a function.
 *
 * @private
 * @param {*} value The value to inspect.
 * @returns {Function} Returns cast function.
 */
function castFunction(value) {
  return typeof value == 'function' ? value : identity;
}

module.exports = castFunction;


/***/ }),
/* 462 */,
/* 463 */,
/* 464 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_flux_stores__ = __webpack_require__(171);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__util__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__sketch_native_events__ = __webpack_require__(16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__components_components_library_Alert__ = __webpack_require__(551);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }










var AlertsContainer = function (_React$Component) {
  _inherits(AlertsContainer, _React$Component);

  function AlertsContainer(props) {
    _classCallCheck(this, AlertsContainer);

    var _this = _possibleConstructorReturn(this, (AlertsContainer.__proto__ || Object.getPrototypeOf(AlertsContainer)).call(this, props));

    _this.state = {};
    //TODO: kim will tell me how to fix this
    __WEBPACK_IMPORTED_MODULE_2_lodash___default.a.merge(_this.state, _this.getInitialState());
    return _this;
  }

  _createClass(AlertsContainer, [{
    key: 'getStateFromFlux',
    value: function getStateFromFlux(flux) {
      var store = flux.store('AlertsStore');
      var state = { alerts: store.getAlerts() };
      return state;
    }
  }, {
    key: 'handleAction',
    value: function handleAction(actionData) {

      //if could nto find in flux action try native event that trigger sketch actions
      var eventName = actionData.eventName;
      var handler = this.props.actions[eventName];

      if (!handler) {
        handler = __WEBPACK_IMPORTED_MODULE_4__sketch_native_events__[eventName];
        if (!handler) {
          __WEBPACK_IMPORTED_MODULE_3__util__["h" /* debug */]('No event handler for alert action "' + eventName + '"');
          //todo: probably log
          return;
        }
      }

      handler.call(this, actionData.payload);
    }
  }, {
    key: 'render',
    value: function render() {

      if (this.state.alerts && this.state.alerts.length === 0) {
        return null;
      }
      //aggregate incoming alerts by key
      var alerts = __WEBPACK_IMPORTED_MODULE_2_lodash___default.a.uniqBy(this.state.alerts, 'key');

      var alertTiles = alerts.map(function (alert, index) {
        var _this2 = this;

        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_5__components_components_library_Alert__["a" /* default */], {
          key: alert.key,
          alert: alert,
          handleAction: this.handleAction.bind(this),
          dismissCallback: function dismissCallback() {
            _this2.props.actions.dismissAlert(alert);
          }
        });
      }.bind(this));

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { className: 'c-alerts-container' },
        alertTiles
      );
    }
  }]);

  return AlertsContainer;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component);

/* harmony default export */ __webpack_exports__["a"] = (Object(__WEBPACK_IMPORTED_MODULE_1_flux_stores__["a" /* default */])(['AlertsStore'])(AlertsContainer));

/***/ }),
/* 465 */,
/* 466 */,
/* 467 */,
/* 468 */
/***/ (function(module, exports) {

(function() {
  var base64map
      = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/',

  crypt = {
    // Bit-wise rotation left
    rotl: function(n, b) {
      return (n << b) | (n >>> (32 - b));
    },

    // Bit-wise rotation right
    rotr: function(n, b) {
      return (n << (32 - b)) | (n >>> b);
    },

    // Swap big-endian to little-endian and vice versa
    endian: function(n) {
      // If number given, swap endian
      if (n.constructor == Number) {
        return crypt.rotl(n, 8) & 0x00FF00FF | crypt.rotl(n, 24) & 0xFF00FF00;
      }

      // Else, assume array and swap all items
      for (var i = 0; i < n.length; i++)
        n[i] = crypt.endian(n[i]);
      return n;
    },

    // Generate an array of any length of random bytes
    randomBytes: function(n) {
      for (var bytes = []; n > 0; n--)
        bytes.push(Math.floor(Math.random() * 256));
      return bytes;
    },

    // Convert a byte array to big-endian 32-bit words
    bytesToWords: function(bytes) {
      for (var words = [], i = 0, b = 0; i < bytes.length; i++, b += 8)
        words[b >>> 5] |= bytes[i] << (24 - b % 32);
      return words;
    },

    // Convert big-endian 32-bit words to a byte array
    wordsToBytes: function(words) {
      for (var bytes = [], b = 0; b < words.length * 32; b += 8)
        bytes.push((words[b >>> 5] >>> (24 - b % 32)) & 0xFF);
      return bytes;
    },

    // Convert a byte array to a hex string
    bytesToHex: function(bytes) {
      for (var hex = [], i = 0; i < bytes.length; i++) {
        hex.push((bytes[i] >>> 4).toString(16));
        hex.push((bytes[i] & 0xF).toString(16));
      }
      return hex.join('');
    },

    // Convert a hex string to a byte array
    hexToBytes: function(hex) {
      for (var bytes = [], c = 0; c < hex.length; c += 2)
        bytes.push(parseInt(hex.substr(c, 2), 16));
      return bytes;
    },

    // Convert a byte array to a base-64 string
    bytesToBase64: function(bytes) {
      for (var base64 = [], i = 0; i < bytes.length; i += 3) {
        var triplet = (bytes[i] << 16) | (bytes[i + 1] << 8) | bytes[i + 2];
        for (var j = 0; j < 4; j++)
          if (i * 8 + j * 6 <= bytes.length * 8)
            base64.push(base64map.charAt((triplet >>> 6 * (3 - j)) & 0x3F));
          else
            base64.push('=');
      }
      return base64.join('');
    },

    // Convert a base-64 string to a byte array
    base64ToBytes: function(base64) {
      // Remove non-base-64 characters
      base64 = base64.replace(/[^A-Z0-9+\/]/ig, '');

      for (var bytes = [], i = 0, imod4 = 0; i < base64.length;
          imod4 = ++i % 4) {
        if (imod4 == 0) continue;
        bytes.push(((base64map.indexOf(base64.charAt(i - 1))
            & (Math.pow(2, -2 * imod4 + 8) - 1)) << (imod4 * 2))
            | (base64map.indexOf(base64.charAt(i)) >>> (6 - imod4 * 2)));
      }
      return bytes;
    }
  };

  module.exports = crypt;
})();


/***/ }),
/* 469 */,
/* 470 */,
/* 471 */,
/* 472 */,
/* 473 */,
/* 474 */,
/* 475 */,
/* 476 */,
/* 477 */,
/* 478 */,
/* 479 */,
/* 480 */,
/* 481 */,
/* 482 */,
/* 483 */,
/* 484 */,
/* 485 */,
/* 486 */,
/* 487 */,
/* 488 */,
/* 489 */,
/* 490 */,
/* 491 */,
/* 492 */,
/* 493 */,
/* 494 */,
/* 495 */,
/* 496 */,
/* 497 */,
/* 498 */,
/* 499 */,
/* 500 */,
/* 501 */,
/* 502 */,
/* 503 */,
/* 504 */,
/* 505 */,
/* 506 */,
/* 507 */,
/* 508 */,
/* 509 */,
/* 510 */,
/* 511 */,
/* 512 */,
/* 513 */,
/* 514 */,
/* 515 */,
/* 516 */,
/* 517 */,
/* 518 */,
/* 519 */,
/* 520 */,
/* 521 */,
/* 522 */,
/* 523 */,
/* 524 */,
/* 525 */,
/* 526 */,
/* 527 */,
/* 528 */,
/* 529 */,
/* 530 */,
/* 531 */,
/* 532 */,
/* 533 */,
/* 534 */,
/* 535 */,
/* 536 */,
/* 537 */,
/* 538 */,
/* 539 */,
/* 540 */,
/* 541 */,
/* 542 */,
/* 543 */,
/* 544 */,
/* 545 */,
/* 546 */,
/* 547 */,
/* 548 */,
/* 549 */,
/* 550 */,
/* 551 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Alert; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__components_library_Icon__ = __webpack_require__(34);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






var Alert = (_temp = _class = function (_React$Component) {
  _inherits(Alert, _React$Component);

  function Alert() {
    _classCallCheck(this, Alert);

    return _possibleConstructorReturn(this, (Alert.__proto__ || Object.getPrototypeOf(Alert)).apply(this, arguments));
  }

  _createClass(Alert, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      var _this2 = this;

      // adopted from here http://blog.mxstbr.com/2015/07/fade-in-react/

      if (this.alert) {
        window.requestAnimationFrame(function () {
          _this2.alert.style.opacity = 1;
        });
      }
    }
  }, {
    key: 'renderApplicationNotification',
    value: function renderApplicationNotification() {}
  }, {
    key: 'render',
    value: function render() {
      var _this3 = this;

      var alert = this.props.alert;
      if (!alert) {
        return null;
      }

      var actions = alert.actions || {};
      var first = actions.first,
          second = actions.second;


      return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
        'div',
        { className: 'c-alert', ref: function ref(c) {
            _this3.alert = c;
          } },
        __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
          'div',
          { className: 'u-flex items-center' },
          __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
            'div',
            { className: 'c-alert__text' },
            alert.message
          ),
          first ? __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
            'div',
            { className: 'c-alert__link', onClick: this.props.handleAction.bind(null, first.action) },
            first.text
          ) : null,
          second ? __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
            'div',
            { className: 'c-alert__link', onClick: this.props.handleAction.bind(null, second.action) },
            second.text
          ) : null
        ),
        alert.undismissible ? null : __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2__components_library_Icon__["a" /* default */], { glyph: 'cancel', color: 'white', size: 12, onClick: this.props.dismissCallback })
      );
    }
  }]);

  return Alert;
}(__WEBPACK_IMPORTED_MODULE_1_react___default.a.Component), _class.propTypes = {
  alert: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.shape({
    key: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.string.isRequired,
    message: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.string.isRequired,
    actions: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.object,
    undismissible: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.bool, //alert that cannot be dismissed by the user
    persisted: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.bool //alert that is not  removed by store upon various navigations
  }).isRequired,
  dismissCallback: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.func.isRequired,
  handleAction: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.func.isRequired
}, _class.defaultProps = {
  closable: true
}, _temp);


/***/ }),
/* 552 */,
/* 553 */,
/* 554 */,
/* 555 */,
/* 556 */,
/* 557 */,
/* 558 */,
/* 559 */,
/* 560 */,
/* 561 */,
/* 562 */,
/* 563 */,
/* 564 */,
/* 565 */,
/* 566 */,
/* 567 */,
/* 568 */,
/* 569 */,
/* 570 */,
/* 571 */,
/* 572 */,
/* 573 */,
/* 574 */,
/* 575 */,
/* 576 */,
/* 577 */,
/* 578 */,
/* 579 */,
/* 580 */,
/* 581 */,
/* 582 */,
/* 583 */,
/* 584 */,
/* 585 */,
/* 586 */,
/* 587 */,
/* 588 */,
/* 589 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_flux_actions__ = __webpack_require__(78);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__util__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__sketch_create_native_context_menu__ = __webpack_require__(196);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__sections_ColorsSection__ = __webpack_require__(590);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__sections_TypographySection__ = __webpack_require__(849);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__sections_SharedStylesSection__ = __webpack_require__(850);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__sections_ImagesSection__ = __webpack_require__(851);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__fullview_EntityFullView__ = __webpack_require__(852);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__components_library_FolderHeader__ = __webpack_require__(857);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__sections_NoItemsView__ = __webpack_require__(67);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__NoSearchResults__ = __webpack_require__(66);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__shared_constants__ = __webpack_require__(41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__shared_constants___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_12__shared_constants__);
var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }








var entityDescriptors = __WEBPACK_IMPORTED_MODULE_2__util__["m" /* getEntityDescriptors */]();












var StyleguidePage = function (_Component) {
  _inherits(StyleguidePage, _Component);

  function StyleguidePage(props) {
    _classCallCheck(this, StyleguidePage);

    var _this = _possibleConstructorReturn(this, (StyleguidePage.__proto__ || Object.getPrototypeOf(StyleguidePage)).call(this, props));

    _this.onBeginEditItem = function (item) {
      _this.props.actions.onBeginEditItem(_extends({
        source: __WEBPACK_IMPORTED_MODULE_12__shared_constants__["editingSources"].styleguidePage
      }, item));
    };

    return _this;
  }

  _createClass(StyleguidePage, [{
    key: 'render',
    value: function render() {

      if (this.props.addingFolder) {
        return this.renderFolderPlaceholder();
      }

      return this.props.selectedStyleEntity ? this.renderFullView() : this.renderStyleguide(this.props.styleData.styleguide, this.props.readOnly, false);
    }
  }, {
    key: 'renderFolderPlaceholder',
    value: function renderFolderPlaceholder() {
      var placeholderFolder = {
        name: 'Folder name'
      };

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { className: 'u-py8' },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__components_library_FolderHeader__["a" /* default */], {
          folder: placeholderFolder,
          readOnly: true,
          disabled: true
        })
      );
    }
  }, {
    key: 'renderFullView',
    value: function renderFullView() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__fullview_EntityFullView__["a" /* default */], _extends({}, this.props.selectedStyleEntity, {
        readOnly: this.props.readOnly,
        prefetchingStyleData: this.props.prefetchingStyleData,
        onBeginEditItem: this.onBeginEditItem,
        editingItemID: this.getEditingItemId()
      }));
    }
  }, {
    key: 'renderFolderHeader',
    value: function renderFolderHeader(folder) {
      if (this.props.selectedSectionId) {
        return null;
      }

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_9__components_library_FolderHeader__["a" /* default */], {
        folder: folder,
        readOnly: this.props.readOnly,
        onBeginEditItem: this.onBeginEditItem,
        editingItemID: this.getEditingItemId(),
        onUpdateFolder: this.props.actions.onUpdateFolder,
        onMenu: __WEBPACK_IMPORTED_MODULE_3__sketch_create_native_context_menu__["a" /* onFolderContextMenu */].bind(null, __WEBPACK_IMPORTED_MODULE_12__shared_constants__["editingSources"].styleguidePage)
      });
    }
  }, {
    key: 'renderStyleguide',
    value: function renderStyleguide(styleguide, readOnly, isParent) {

      if (this.props.isSearching) {
        if (this.props.styleData.noResultsFound) {
          return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_11__NoSearchResults__["a" /* default */], null);
        }
        return null;
      }

      if (!this.props.selectedFolder) {
        return null;
      }

      var selectedItems = __WEBPACK_IMPORTED_MODULE_2__util__["l" /* getAllItemsInFolder */](styleguide, entityDescriptors[this.props.selectedType], this.props.selectedFolder._id);

      if (isParent && (!selectedItems || !selectedItems.length || selectedItems.length === 0)) {
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_10__sections_NoItemsView__["a" /* default */], { type: entityDescriptors[this.props.selectedType].shortTitle });
      }

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { className: 'u-py8' },
        this.renderFolderHeader(this.props.selectedFolder),
        this.getSelectedSection(styleguide, this.props.selectedFolder, selectedItems, readOnly)
      );
    }
  }, {
    key: 'getSelectedSection',
    value: function getSelectedSection(styleguide, selectedFolder, selectedItems, readOnly) {

      var folderSections = __WEBPACK_IMPORTED_MODULE_2__util__["q" /* getSectionsInFolder */](styleguide, entityDescriptors[this.props.selectedType], selectedFolder._id);
      var editingItemId = this.getEditingItemId();

      switch (this.props.selectedType) {
        case entityDescriptors.colors.key:
          return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__sections_ColorsSection__["a" /* default */], {
            readOnly: readOnly,
            palettes: folderSections,
            editingItemID: editingItemId,
            onBeginEditItem: this.onBeginEditItem,
            onRenameColor: this.props.actions.onUpdateEntityByEntityType,
            onColorContextMenu: __WEBPACK_IMPORTED_MODULE_3__sketch_create_native_context_menu__["c" /* onStyleElementContextMenu */].bind(null, __WEBPACK_IMPORTED_MODULE_12__shared_constants__["editingSources"].styleguidePage, entityDescriptors.colors.key),
            onPaletteContextMenu: __WEBPACK_IMPORTED_MODULE_3__sketch_create_native_context_menu__["b" /* onSectionContextMenu */].bind(null, __WEBPACK_IMPORTED_MODULE_12__shared_constants__["editingSources"].styleguidePage, entityDescriptors.colors.key),
            onUpdatePalette: this.props.actions.onUpdatePalette,
            isSearching: this.props.isSearching,
            onPreviewEntity: this.props.actions.selectStyleElement,
            folderId: selectedFolder._id,
            selectedSectionId: this.props.selectedSectionId,
            canReorder: this.props.canReorder,
            setReorderIntent: this.props.actions.setReorderIntent,
            onReorderItems: this.props.actions.reorderItemsInSection,
            setDraggedEntity: this.props.actions.setDraggedEntity,
            onMoveItemToSectionEnd: this.props.actions.moveItemToSectionEnd
          });

        case entityDescriptors.typeStyles.key:
          return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_5__sections_TypographySection__["a" /* default */], {
            readOnly: readOnly,
            typeStyles: selectedItems,
            folder: selectedFolder,
            installedFonts: this.props.installedFonts,
            onTypeStyleContextMenu: __WEBPACK_IMPORTED_MODULE_3__sketch_create_native_context_menu__["c" /* onStyleElementContextMenu */].bind(null, __WEBPACK_IMPORTED_MODULE_12__shared_constants__["editingSources"].styleguidePage, entityDescriptors.typeStyles.key),
            isSearching: this.props.isSearching,
            onPreviewEntity: this.props.actions.selectStyleElement,
            onBeginEditItem: this.onBeginEditItem,
            editingItemID: editingItemId,
            onRenameEntity: this.props.actions.onUpdateEntityByEntityType,
            canReorder: this.props.canReorder,
            setReorderIntent: this.props.actions.setReorderIntent,
            onReorderItems: this.props.actions.reorderItemsForType,
            setDraggedEntity: this.props.actions.setDraggedEntity
          });
        case entityDescriptors.sharedStyles.key:
          return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_6__sections_SharedStylesSection__["a" /* default */], {
            readOnly: readOnly,
            sharedStyles: selectedItems,
            folder: selectedFolder,
            onSharedStyleItemContextMenu: __WEBPACK_IMPORTED_MODULE_3__sketch_create_native_context_menu__["c" /* onStyleElementContextMenu */].bind(null, __WEBPACK_IMPORTED_MODULE_12__shared_constants__["editingSources"].styleguidePage, entityDescriptors.sharedStyles.key),
            prefetchingStyleData: this.props.prefetchingStyleData,
            isSearching: this.props.isSearching,
            onPreviewEntity: this.props.actions.selectStyleElement,
            onBeginEditItem: this.onBeginEditItem,
            editingItemID: editingItemId,
            onRenameEntity: this.props.actions.onUpdateEntityByEntityType,
            canReorder: this.props.canReorder,
            setReorderIntent: this.props.actions.setReorderIntent,
            onReorderItems: this.props.actions.reorderItemsForType,
            setDraggedEntity: this.props.actions.setDraggedEntity
          });
        case entityDescriptors.icons.key:
          return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_7__sections_ImagesSection__["a" /* default */], {
            key: 'icons',
            imageType: 'icons',
            boxSize: 'sm',
            readOnly: readOnly,
            sections: folderSections,
            onImageContextMenu: __WEBPACK_IMPORTED_MODULE_3__sketch_create_native_context_menu__["c" /* onStyleElementContextMenu */].bind(null, __WEBPACK_IMPORTED_MODULE_12__shared_constants__["editingSources"].styleguidePage, entityDescriptors.icons.key),
            onImageSectionContextMenu: __WEBPACK_IMPORTED_MODULE_3__sketch_create_native_context_menu__["b" /* onSectionContextMenu */].bind(null, __WEBPACK_IMPORTED_MODULE_12__shared_constants__["editingSources"].styleguidePage, entityDescriptors.icons.key),
            selectedLayerCount: this.props.selectedLayerCount,
            onBeginEditItem: this.onBeginEditItem,
            editingItemID: editingItemId,
            onRenameImage: this.props.actions.onUpdateEntityByEntityType,
            onUpdateImageSection: this.props.actions.onUpdateImageSection,
            isSearching: this.props.isSearching,
            prefetchingStyleData: this.props.prefetchingStyleData,
            onPreviewEntity: this.props.actions.selectStyleElement,
            folderId: selectedFolder._id,
            selectedSectionId: this.props.selectedSectionId,
            canReorder: this.props.canReorder,
            setReorderIntent: this.props.actions.setReorderIntent,
            onReorderItems: this.props.actions.reorderItemsInSection,
            setDraggedEntity: this.props.actions.setDraggedEntity,
            onMoveItemToSectionEnd: this.props.actions.moveItemToSectionEnd
          });
        case entityDescriptors.components.key:
          return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_7__sections_ImagesSection__["a" /* default */], {
            key: 'components',
            imageType: 'components',
            boxSize: 'md',
            readOnly: readOnly,
            sections: folderSections,
            onImageContextMenu: __WEBPACK_IMPORTED_MODULE_3__sketch_create_native_context_menu__["c" /* onStyleElementContextMenu */].bind(null, __WEBPACK_IMPORTED_MODULE_12__shared_constants__["editingSources"].styleguidePage, entityDescriptors.components.key),
            onImageSectionContextMenu: __WEBPACK_IMPORTED_MODULE_3__sketch_create_native_context_menu__["b" /* onSectionContextMenu */].bind(null, __WEBPACK_IMPORTED_MODULE_12__shared_constants__["editingSources"].styleguidePage, entityDescriptors.components.key),
            selectedLayerCount: this.props.selectedLayerCount,
            onBeginEditItem: this.onBeginEditItem,
            editingItemID: editingItemId,
            onRenameImage: this.props.actions.onUpdateEntityByEntityType,
            onUpdateImageSection: this.props.actions.onUpdateImageSection,
            isSearching: this.props.isSearching,
            prefetchingStyleData: this.props.prefetchingStyleData,
            onPreviewEntity: this.props.actions.selectStyleElement,
            folderId: selectedFolder._id,
            selectedSectionId: this.props.selectedSectionId,
            canReorder: this.props.canReorder,
            setReorderIntent: this.props.actions.setReorderIntent,
            onReorderItems: this.props.actions.reorderItemsInSection,
            setDraggedEntity: this.props.actions.setDraggedEntity,
            onMoveItemToSectionEnd: this.props.actions.moveItemToSectionEnd
          });
      }

      return null;
    }
  }, {
    key: 'getEditingItemId',
    value: function getEditingItemId() {
      if (this.props.editingSource === __WEBPACK_IMPORTED_MODULE_12__shared_constants__["editingSources"].styleguidePage) {
        return this.props.editingItemID;
      }

      return null;
    }
  }]);

  return StyleguidePage;
}(__WEBPACK_IMPORTED_MODULE_0_react__["Component"]);

/* harmony default export */ __webpack_exports__["a"] = (Object(__WEBPACK_IMPORTED_MODULE_1_flux_actions__["a" /* default */])(StyleguidePage));

/***/ }),
/* 590 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ColorsSection; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__tiles_ColorTile__ = __webpack_require__(118);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__components_library_SectionHead__ = __webpack_require__(119);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__NoSearchResults__ = __webpack_require__(66);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__NoItemsView__ = __webpack_require__(67);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__components_library_FABButton__ = __webpack_require__(101);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__components_library_DropTargetTile__ = __webpack_require__(102);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__util__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__sketch_native_events_js__ = __webpack_require__(16);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }














var ColorsSection = function (_React$Component) {
  _inherits(ColorsSection, _React$Component);

  function ColorsSection() {
    _classCallCheck(this, ColorsSection);

    return _possibleConstructorReturn(this, (ColorsSection.__proto__ || Object.getPrototypeOf(ColorsSection)).apply(this, arguments));
  }

  _createClass(ColorsSection, [{
    key: 'renderEmptyViews',
    value: function renderEmptyViews() {

      if (this.props.isSearching) {
        //in search mode we want to present consistent no result view, even if there was no original data
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3__NoSearchResults__["a" /* default */], { type: 'Colors' });
      }

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        null,
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__NoItemsView__["a" /* default */], { type: 'Colors' }),
        this.renderAddSectionButton()
      );
    }
  }, {
    key: 'renderDropTargetPlaceholder',
    value: function renderDropTargetPlaceholder(isDroppable, palette, entity) {
      var _props = this.props,
          setReorderIntent = _props.setReorderIntent,
          canReorder = _props.canReorder,
          onMoveItemToSectionEnd = _props.onMoveItemToSectionEnd;


      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_6__components_library_DropTargetTile__["a" /* default */], {
        reorderingAllowed: canReorder,
        onContinuosHover: setReorderIntent,
        onDrop: function onDrop() {
          return onMoveItemToSectionEnd(entity.key, palette._id, palette.sortMode);
        },
        isDroppable: isDroppable,
        className: 'cell u-full-width',
        direction: 'vertical',
        forceClueLocation: 'before'
      });
    }
  }, {
    key: 'renderColors',
    value: function renderColors(palette) {
      var _props2 = this.props,
          readOnly = _props2.readOnly,
          editingItemID = _props2.editingItemID,
          onBeginEditItem = _props2.onBeginEditItem,
          onRenameColor = _props2.onRenameColor,
          onColorContextMenu = _props2.onColorContextMenu,
          _onPreviewEntity = _props2.onPreviewEntity,
          folderId = _props2.folderId,
          selectedSectionId = _props2.selectedSectionId,
          setReorderIntent = _props2.setReorderIntent,
          canReorder = _props2.canReorder,
          onReorderItems = _props2.onReorderItems,
          setDraggedEntity = _props2.setDraggedEntity;


      var entity = __WEBPACK_IMPORTED_MODULE_7__util__["m" /* getEntityDescriptors */]().colors;
      var isDroppable = !readOnly && (!selectedSectionId || !__WEBPACK_IMPORTED_MODULE_7__util__["t" /* isAlphanumericSort */](palette.sortMode));

      if (palette.colors.length === 0) {
        return this.renderDropTargetPlaceholder(isDroppable, palette, entity);
      }

      return palette.colors.map(function (color) {
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          __WEBPACK_IMPORTED_MODULE_6__components_library_DropTargetTile__["a" /* default */],
          {
            key: color._id,
            reorderingAllowed: canReorder,
            onContinuosHover: setReorderIntent,
            onDrop: function onDrop(insertBefore) {
              return onReorderItems(entity.key, palette._id, color._id, palette.sortMode, insertBefore);
            },
            isDroppable: isDroppable,
            className: 'cell cell-md'
          },
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_1__tiles_ColorTile__["a" /* default */], {
            readOnly: readOnly,
            name: color.name,
            updateErrorOccurred: color.updateErrorOccurred,
            namePlaceholder: entity.namePlaceholder,
            color: color.value,
            onSelect: function onSelect(event) {
              return Object(__WEBPACK_IMPORTED_MODULE_8__sketch_native_events_js__["chooseColor"])(color.value, event);
            },
            onPreviewEntity: function onPreviewEntity() {
              return _onPreviewEntity(entity.key, folderId, palette._id, color._id);
            },
            onBeginEdit: function onBeginEdit() {
              return onBeginEditItem({ elementID: color._id });
            },
            onCancelEdit: function onCancelEdit() {
              return onBeginEditItem({});
            },
            editing: editingItemID && editingItemID === color._id,
            onRename: function onRename(name) {
              return onRenameColor(entity.key, palette._id, color._id, { name: name });
            },
            onMenu: function onMenu(evt) {
              return onColorContextMenu(evt, color, palette._id);
            },
            onColorDragStart: function onColorDragStart() {
              return setDraggedEntity({ _id: color._id, sectionId: palette._id });
            },
            onColorDragEnd: function onColorDragEnd() {
              return setDraggedEntity(null);
            }
          })
        );
      });
    }
  }, {
    key: 'renderAddSectionButton',
    value: function renderAddSectionButton() {
      var _props3 = this.props,
          readOnly = _props3.readOnly,
          isSearching = _props3.isSearching,
          selectedSectionId = _props3.selectedSectionId,
          folderId = _props3.folderId;

      // Render placeholder section that users use to create new sections.

      if (!readOnly && !isSearching) {
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_5__components_library_FABButton__["a" /* default */], { type: 'add', onClickTarget: function onClickTarget() {
            Object(__WEBPACK_IMPORTED_MODULE_8__sketch_native_events_js__["addColors"])(selectedSectionId, folderId);
          }
        });
      }
      return null;
    }
  }, {
    key: 'renderSections',
    value: function renderSections() {
      var _this2 = this;

      var _props4 = this.props,
          readOnly = _props4.readOnly,
          palettes = _props4.palettes,
          editingItemID = _props4.editingItemID,
          onBeginEditItem = _props4.onBeginEditItem,
          onPaletteContextMenu = _props4.onPaletteContextMenu,
          onUpdatePalette = _props4.onUpdatePalette,
          isSearching = _props4.isSearching,
          selectedSectionId = _props4.selectedSectionId;


      var sections = palettes.map(function (palette, paletteIdx) {

        if (selectedSectionId && selectedSectionId !== palette._id) {
          return null;
        }
        var colorSwatches = _this2.renderColors(palette);

        //if there are no color swatches in the specific section and we are searching return null, since we don't want to present empty sections
        if (colorSwatches.length === 0 && isSearching) {
          return null;
        }

        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          { key: paletteIdx, className: 'u-mb5' },
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2__components_library_SectionHead__["a" /* default */], {
            readOnly: readOnly,
            name: palette.name,
            updateErrorOccurred: palette.updateErrorOccurred,
            onMenu: function onMenu(evt) {
              return onPaletteContextMenu(evt, palette);
            },
            onBeginEdit: function onBeginEdit() {
              return onBeginEditItem({ elementID: palette._id });
            },
            onCancelEdit: function onCancelEdit() {
              return onBeginEditItem({});
            },
            editing: editingItemID && editingItemID === palette._id,
            onRename: onUpdatePalette.bind(null, palette._id),
            showDescription: true,
            description: palette.description,
            descriptionAsDelta: palette.descriptionAsDelta
          }),
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
            'div',
            { className: 'grid' },
            colorSwatches
          )
        );
      });
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        null,
        sections
      );
    }
  }, {
    key: 'render',
    value: function render() {

      // if there are no sections
      if (!__WEBPACK_IMPORTED_MODULE_7__util__["u" /* isNonEmptyArray */](this.props.palettes)) {
        return this.renderEmptyViews();
      }

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        null,
        this.renderSections(),
        this.renderAddSectionButton()
      );
    }
  }]);

  return ColorsSection;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component);



/***/ }),
/* 591 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ClickYourWayComponent; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_lodash__);
var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }





var DOUBLE_CLICK_TOLERANCE = 300;

// This component creates a delay in reaction to a click. Use cautiously only if really needed.
var ClickYourWayComponent = (_temp = _class = function (_React$Component) {
  _inherits(ClickYourWayComponent, _React$Component);

  function ClickYourWayComponent(props) {
    _classCallCheck(this, ClickYourWayComponent);

    var _this = _possibleConstructorReturn(this, (ClickYourWayComponent.__proto__ || Object.getPrototypeOf(ClickYourWayComponent)).call(this, props));

    _this.handleClick = function (event) {
      // If the component has no double click behavior fallback to regular click handling
      if (!_this.props.onDoubleClick) {
        _this.handleSingleClick(event);
        return;
      }

      if (_this.state.clickCounter == 0) {
        event.persist();
        _this.setState({
          clickCounter: 1,
          timer: setTimeout(function () {
            return _this.handleSingleClick(event);
          }, DOUBLE_CLICK_TOLERANCE)
        });
      } else {
        clearTimeout(_this.state.timer);
        _this.props.onDoubleClick(event);
        _this.setState({
          clickCounter: 0,
          timer: null
        });
      }
    };

    _this.state = {
      clickCounter: 0,
      timer: null
    };
    return _this;
  }

  _createClass(ClickYourWayComponent, [{
    key: 'handleSingleClick',
    value: function handleSingleClick(event) {
      this.props.onClick(event);
      this.setState({
        clickCounter: 0,
        timer: null
      });
    }
  }, {
    key: 'render',
    value: function render() {
      var additionalProps = __WEBPACK_IMPORTED_MODULE_2_lodash___default.a.omit(this.props, ['onClick', 'onDoubleClick']);
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement('div', _extends({
        onClick: this.props.onClick ? this.handleClick : null,
        onDoubleClick: !this.props.onClick ? this.props.onDoubleClick : null
      }, additionalProps));
    }
  }]);

  return ClickYourWayComponent;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component), _class.propTypes = {
  onClick: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onDoubleClick: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func
}, _temp);


/***/ }),
/* 592 */,
/* 593 */,
/* 594 */,
/* 595 */,
/* 596 */,
/* 597 */,
/* 598 */,
/* 599 */,
/* 600 */,
/* 601 */,
/* 602 */,
/* 603 */,
/* 604 */,
/* 605 */,
/* 606 */,
/* 607 */,
/* 608 */,
/* 609 */,
/* 610 */,
/* 611 */,
/* 612 */,
/* 613 */,
/* 614 */,
/* 615 */,
/* 616 */,
/* 617 */,
/* 618 */,
/* 619 */,
/* 620 */,
/* 621 */,
/* 622 */,
/* 623 */,
/* 624 */,
/* 625 */,
/* 626 */,
/* 627 */,
/* 628 */,
/* 629 */,
/* 630 */,
/* 631 */,
/* 632 */,
/* 633 */,
/* 634 */,
/* 635 */,
/* 636 */,
/* 637 */,
/* 638 */,
/* 639 */,
/* 640 */,
/* 641 */,
/* 642 */,
/* 643 */,
/* 644 */,
/* 645 */,
/* 646 */,
/* 647 */,
/* 648 */,
/* 649 */,
/* 650 */,
/* 651 */,
/* 652 */,
/* 653 */,
/* 654 */,
/* 655 */,
/* 656 */,
/* 657 */,
/* 658 */,
/* 659 */,
/* 660 */,
/* 661 */,
/* 662 */,
/* 663 */,
/* 664 */,
/* 665 */,
/* 666 */,
/* 667 */,
/* 668 */,
/* 669 */,
/* 670 */,
/* 671 */,
/* 672 */,
/* 673 */,
/* 674 */,
/* 675 */,
/* 676 */,
/* 677 */,
/* 678 */,
/* 679 */,
/* 680 */,
/* 681 */,
/* 682 */,
/* 683 */,
/* 684 */,
/* 685 */,
/* 686 */,
/* 687 */,
/* 688 */,
/* 689 */,
/* 690 */,
/* 691 */,
/* 692 */,
/* 693 */,
/* 694 */,
/* 695 */,
/* 696 */,
/* 697 */,
/* 698 */,
/* 699 */,
/* 700 */,
/* 701 */,
/* 702 */,
/* 703 */,
/* 704 */,
/* 705 */,
/* 706 */,
/* 707 */,
/* 708 */,
/* 709 */,
/* 710 */,
/* 711 */,
/* 712 */,
/* 713 */,
/* 714 */,
/* 715 */,
/* 716 */,
/* 717 */,
/* 718 */,
/* 719 */,
/* 720 */,
/* 721 */,
/* 722 */,
/* 723 */,
/* 724 */,
/* 725 */,
/* 726 */,
/* 727 */,
/* 728 */,
/* 729 */,
/* 730 */,
/* 731 */,
/* 732 */,
/* 733 */,
/* 734 */,
/* 735 */,
/* 736 */,
/* 737 */,
/* 738 */,
/* 739 */,
/* 740 */,
/* 741 */,
/* 742 */,
/* 743 */,
/* 744 */,
/* 745 */,
/* 746 */,
/* 747 */,
/* 748 */,
/* 749 */,
/* 750 */,
/* 751 */,
/* 752 */,
/* 753 */,
/* 754 */,
/* 755 */,
/* 756 */,
/* 757 */,
/* 758 */,
/* 759 */,
/* 760 */,
/* 761 */,
/* 762 */,
/* 763 */,
/* 764 */,
/* 765 */,
/* 766 */,
/* 767 */,
/* 768 */,
/* 769 */,
/* 770 */,
/* 771 */,
/* 772 */,
/* 773 */,
/* 774 */,
/* 775 */,
/* 776 */,
/* 777 */,
/* 778 */,
/* 779 */,
/* 780 */,
/* 781 */,
/* 782 */,
/* 783 */,
/* 784 */,
/* 785 */,
/* 786 */,
/* 787 */,
/* 788 */,
/* 789 */,
/* 790 */,
/* 791 */,
/* 792 */,
/* 793 */,
/* 794 */,
/* 795 */,
/* 796 */,
/* 797 */,
/* 798 */,
/* 799 */,
/* 800 */,
/* 801 */,
/* 802 */,
/* 803 */,
/* 804 */,
/* 805 */,
/* 806 */,
/* 807 */,
/* 808 */,
/* 809 */,
/* 810 */,
/* 811 */,
/* 812 */,
/* 813 */,
/* 814 */,
/* 815 */,
/* 816 */,
/* 817 */,
/* 818 */,
/* 819 */,
/* 820 */,
/* 821 */,
/* 822 */,
/* 823 */,
/* 824 */,
/* 825 */,
/* 826 */,
/* 827 */,
/* 828 */,
/* 829 */,
/* 830 */,
/* 831 */,
/* 832 */,
/* 833 */,
/* 834 */,
/* 835 */,
/* 836 */,
/* 837 */,
/* 838 */,
/* 839 */,
/* 840 */,
/* 841 */,
/* 842 */,
/* 843 */,
/* 844 */,
/* 845 */,
/* 846 */,
/* 847 */,
/* 848 */,
/* 849 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__util__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__tiles_TypeStyleSample__ = __webpack_require__(152);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__NoSearchResults__ = __webpack_require__(66);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__NoItemsView__ = __webpack_require__(67);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__components_library_FABButton__ = __webpack_require__(101);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__components_library_DropTargetTile__ = __webpack_require__(102);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__sketch_native_events__ = __webpack_require__(16);










/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var readOnly = _ref.readOnly,
      typeStyles = _ref.typeStyles,
      folder = _ref.folder,
      onTypeStyleContextMenu = _ref.onTypeStyleContextMenu,
      installedFonts = _ref.installedFonts,
      isSearching = _ref.isSearching,
      _onPreviewEntity = _ref.onPreviewEntity,
      editingItemID = _ref.editingItemID,
      _onBeginEditItem = _ref.onBeginEditItem,
      onRenameEntity = _ref.onRenameEntity,
      canReorder = _ref.canReorder,
      setReorderIntent = _ref.setReorderIntent,
      onReorderItems = _ref.onReorderItems,
      setDraggedEntity = _ref.setDraggedEntity;


  var entity = __WEBPACK_IMPORTED_MODULE_1__util__["m" /* getEntityDescriptors */]().typeStyles;

  var addButton;
  if (!readOnly && !isSearching) {
    addButton = __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_5__components_library_FABButton__["a" /* default */], { type: 'add', onClickTarget: function onClickTarget() {
        Object(__WEBPACK_IMPORTED_MODULE_7__sketch_native_events__["addTypeStyles"])(folder._id);
      }
    });
  }

  //if no type styles
  if (!__WEBPACK_IMPORTED_MODULE_1__util__["u" /* isNonEmptyArray */](typeStyles)) {
    if (isSearching) {
      //and we are in search flow present no result message
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3__NoSearchResults__["a" /* default */], { type: entity.shortTitle });
    }

    return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'div',
      null,
      __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__NoItemsView__["a" /* default */], { type: entity.shortTitle }),
      addButton
    );
  }

  // var deleteButton;
  // if (!readOnly && util.isNonEmptyArray(typeStyles)) {
  //   deleteButton = (
  //     <button
  //       onClick={onOpenDeleteTypeStylesApp}
  //     >
  //       Delete Type Styles…
  //     </button>
  //   );
  // }

  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    'div',
    null,
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'div',
      null,
      typeStyles.map(function (typeStyle) {
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          __WEBPACK_IMPORTED_MODULE_6__components_library_DropTargetTile__["a" /* default */],
          {
            key: typeStyle._id,
            reorderingAllowed: canReorder,
            onContinuosHover: setReorderIntent,
            onDrop: function onDrop(insertBefore) {
              return onReorderItems(entity.key, typeStyle._id, folder.sortMode, insertBefore);
            },
            direction: 'vertical',
            isDroppable: !readOnly,
            className: 'u-mx8 u-py4'
          },
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2__tiles_TypeStyleSample__["a" /* default */], {
            onSelect: function onSelect(event) {
              return Object(__WEBPACK_IMPORTED_MODULE_7__sketch_native_events__["chooseTypography"])(typeStyle, event);
            },
            onPreviewEntity: function onPreviewEntity() {
              return _onPreviewEntity(entity.key, folder._id, null, typeStyle._id);
            },
            readOnly: readOnly,
            draggable: true,
            onTypeStyleDragStart: function onTypeStyleDragStart() {
              return setDraggedEntity({ _id: typeStyle._id });
            },
            onTypeStyleDragEnd: function onTypeStyleDragEnd(typeStyle) {
              setDraggedEntity(null);
              Object(__WEBPACK_IMPORTED_MODULE_7__sketch_native_events__["typeStyleDragEnd"])(typeStyle);
            },
            installedFonts: installedFonts,
            typeStyle: typeStyle,
            onMenu: function onMenu(evt) {
              return onTypeStyleContextMenu(evt, typeStyle);
            },
            editing: editingItemID && editingItemID === typeStyle._id,
            onBeginEditItem: function onBeginEditItem() {
              return _onBeginEditItem({ elementID: typeStyle._id });
            },
            onCancelEditItem: function onCancelEditItem() {
              return _onBeginEditItem({});
            },
            onRename: function onRename(name) {
              return onRenameEntity(entity.key, null, typeStyle._id, { name: name });
            }
          })
        );
      })
    ),
    addButton
  );
});

/***/ }),
/* 850 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__util__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__tiles_SharedStyleTile__ = __webpack_require__(269);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__NoSearchResults__ = __webpack_require__(66);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__NoItemsView__ = __webpack_require__(67);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__components_library_FABButton__ = __webpack_require__(101);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__components_library_DropTargetTile__ = __webpack_require__(102);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__sketch_native_events__ = __webpack_require__(16);










/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var readOnly = _ref.readOnly,
      sharedStyles = _ref.sharedStyles,
      folder = _ref.folder,
      onSharedStyleItemContextMenu = _ref.onSharedStyleItemContextMenu,
      prefetchingStyleData = _ref.prefetchingStyleData,
      isSearching = _ref.isSearching,
      _onPreviewEntity = _ref.onPreviewEntity,
      editingItemID = _ref.editingItemID,
      _onBeginEditItem = _ref.onBeginEditItem,
      onRenameEntity = _ref.onRenameEntity,
      canReorder = _ref.canReorder,
      setReorderIntent = _ref.setReorderIntent,
      onReorderItems = _ref.onReorderItems,
      setDraggedEntity = _ref.setDraggedEntity;


  var entity = __WEBPACK_IMPORTED_MODULE_1__util__["m" /* getEntityDescriptors */]().sharedStyles;

  // we have found styles
  var addButton;
  if (!readOnly && !isSearching) {
    addButton = __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_5__components_library_FABButton__["a" /* default */], { type: 'add', onClickTarget: function onClickTarget() {
        Object(__WEBPACK_IMPORTED_MODULE_7__sketch_native_events__["addSharedStyles"])(folder._id);
      }
    });
  }

  //if no styles found
  if (!__WEBPACK_IMPORTED_MODULE_1__util__["u" /* isNonEmptyArray */](sharedStyles)) {
    if (isSearching) {
      //and we are in search flow present no result message
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3__NoSearchResults__["a" /* default */], { type: entity.shortTitle });
    }

    return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'div',
      null,
      __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__NoItemsView__["a" /* default */], { type: entity.shortTitle }),
      addButton
    );
  }

  // var deleteButton;
  // if (!readOnly && util.isNonEmptyArray(sharedStyles)) {
  //   deleteButton = (
  //     <button
  //       onClick={onOpenDeleteSharedStylesApp}
  //     >
  //       Delete Shared Styles…
  //     </button>
  //   );
  // }

  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    'div',
    null,
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'div',
      { className: 'grid' },
      sharedStyles.map(function (sharedStyle) {
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          __WEBPACK_IMPORTED_MODULE_6__components_library_DropTargetTile__["a" /* default */],
          {
            key: sharedStyle._id,
            reorderingAllowed: canReorder,
            onContinuosHover: setReorderIntent,
            onDrop: function onDrop(insertBefore) {
              return onReorderItems(entity.key, sharedStyle._id, folder.sortMode, insertBefore);
            },
            isDroppable: !readOnly,
            className: 'cell cell-md'
          },
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2__tiles_SharedStyleTile__["a" /* default */], {
            readOnly: readOnly,
            name: sharedStyle.name,
            updateErrorOccurred: sharedStyle.updateErrorOccurred,
            namePlaceholder: entity.namePlaceholder,
            thumbnailURL: sharedStyle.thumbnailUrl,
            onMenu: function onMenu(evt) {
              return onSharedStyleItemContextMenu(evt, sharedStyle);
            },
            onSelect: function onSelect(evt) {
              return Object(__WEBPACK_IMPORTED_MODULE_7__sketch_native_events__["chooseSharedStyle"])(prefetchingStyleData, sharedStyle, evt);
            },
            onPreviewEntity: function onPreviewEntity() {
              return _onPreviewEntity(entity.key, folder._id, null, sharedStyle._id);
            },
            editing: editingItemID && editingItemID === sharedStyle._id,
            onBeginEditItem: function onBeginEditItem() {
              return _onBeginEditItem({ elementID: sharedStyle._id });
            },
            onCancelEditItem: function onCancelEditItem() {
              return _onBeginEditItem({});
            },
            onRename: function onRename(name) {
              return onRenameEntity(entity.key, null, sharedStyle._id, { name: name });
            },
            onStyleDragStart: function onStyleDragStart() {
              return setDraggedEntity({ _id: sharedStyle._id });
            },
            onStyleDragEnd: function onStyleDragEnd() {
              return setDraggedEntity(null);
            }
          })
        );
      })
    ),
    addButton
  );
});

/***/ }),
/* 851 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ImagesSection; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__util__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__shared_constants__ = __webpack_require__(41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__shared_constants___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2__shared_constants__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__components_library_SectionHead__ = __webpack_require__(119);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__tiles_ImageTile__ = __webpack_require__(270);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__NoSearchResults__ = __webpack_require__(66);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__NoItemsView__ = __webpack_require__(67);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__components_library_FABButton__ = __webpack_require__(101);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__components_library_DropTargetTile__ = __webpack_require__(102);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__sketch_native_events_js__ = __webpack_require__(16);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }












var _require = __webpack_require__(42),
    compositeComponents = _require.compositeComponents;

var LazyLoad = compositeComponents.LazyLoad;



var ImagesSection = function (_React$Component) {
  _inherits(ImagesSection, _React$Component);

  function ImagesSection(props) {
    _classCallCheck(this, ImagesSection);

    var _this = _possibleConstructorReturn(this, (ImagesSection.__proto__ || Object.getPrototypeOf(ImagesSection)).call(this, props));

    _this.category = __WEBPACK_IMPORTED_MODULE_2__shared_constants__["IMAGE_CATS"][props.imageType];
    _this.entity = __WEBPACK_IMPORTED_MODULE_1__util__["m" /* getEntityDescriptors */]()[props.imageType];
    return _this;
  }

  _createClass(ImagesSection, [{
    key: 'renderEmptyViews',
    value: function renderEmptyViews() {
      if (this.props.isSearching) {
        //in search mode we want to present consistent no result view, even if there was no original data
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_5__NoSearchResults__["a" /* default */], { type: this.category.displayNamePlural });
      }

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        null,
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_6__NoItemsView__["a" /* default */], { type: this.category.displayNamePlural }),
        this.renderUploadWithSectionButton()
      );
    }
  }, {
    key: 'renderUploadWithSectionButton',
    value: function renderUploadWithSectionButton() {
      var _props = this.props,
          readOnly = _props.readOnly,
          selectedLayerCount = _props.selectedLayerCount,
          isSearching = _props.isSearching,
          selectedSectionId = _props.selectedSectionId,
          folderId = _props.folderId,
          imageType = _props.imageType;

      // Render placeholder section that users use to create new sections.

      if (!readOnly && !isSearching) {
        var tooltip = selectedLayerCount === 0 ? null : selectedLayerCount + ' layer selected';

        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_7__components_library_FABButton__["a" /* default */], { type: 'add', tooltip: tooltip, onClickTarget: function onClickTarget() {
            Object(__WEBPACK_IMPORTED_MODULE_9__sketch_native_events_js__["uploadLayers"])(imageType, selectedSectionId, folderId);
          }
        });
      }
      return null;
    }
  }, {
    key: 'renderDropTargetPlaceholder',
    value: function renderDropTargetPlaceholder(isDroppable, section) {
      var _this2 = this;

      var _props2 = this.props,
          setReorderIntent = _props2.setReorderIntent,
          canReorder = _props2.canReorder,
          onMoveItemToSectionEnd = _props2.onMoveItemToSectionEnd;


      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__components_library_DropTargetTile__["a" /* default */], {
        reorderingAllowed: canReorder,
        onContinuosHover: setReorderIntent,
        onDrop: function onDrop() {
          return onMoveItemToSectionEnd(_this2.entity.key, section._id, section.sortMode);
        },
        isDroppable: isDroppable,
        className: 'cell u-full-width',
        direction: 'vertical',
        forceClueLocation: 'before'
      });
    }
  }, {
    key: 'renderTiles',
    value: function renderTiles(section) {
      var _this3 = this;

      var _props3 = this.props,
          readOnly = _props3.readOnly,
          _onImageContextMenu = _props3.onImageContextMenu,
          _onBeginEditItem = _props3.onBeginEditItem,
          _onRenameImage = _props3.onRenameImage,
          editingItemID = _props3.editingItemID,
          _onPreviewEntity = _props3.onPreviewEntity,
          folderId = _props3.folderId,
          boxSize = _props3.boxSize,
          prefetchingStyleData = _props3.prefetchingStyleData,
          selectedSectionId = _props3.selectedSectionId,
          setReorderIntent = _props3.setReorderIntent,
          canReorder = _props3.canReorder,
          onReorderItems = _props3.onReorderItems,
          setDraggedEntity = _props3.setDraggedEntity;


      var sectionBoxSize = boxSize;
      var isDroppable = !readOnly && (!selectedSectionId || !__WEBPACK_IMPORTED_MODULE_1__util__["t" /* isAlphanumericSort */](section.sortMode));

      var items = section[this.category.itemsKey];

      if (items.length === 0) {
        return this.renderDropTargetPlaceholder(isDroppable, section);
      }

      return items.map(function (item) {
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          __WEBPACK_IMPORTED_MODULE_8__components_library_DropTargetTile__["a" /* default */],
          {
            key: item._id,
            reorderingAllowed: canReorder,
            onContinuosHover: setReorderIntent,
            onDrop: function onDrop(insertBefore) {
              return onReorderItems(_this3.entity.key, section._id, item._id, section.sortMode, insertBefore);
            },
            isDroppable: isDroppable,
            className: 'cell cell-' + sectionBoxSize
          },
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
            LazyLoad,
            { height: __WEBPACK_IMPORTED_MODULE_2__shared_constants__["gridSize"][sectionBoxSize], onlyCacheOnFirstLoad: true },
            __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__tiles_ImageTile__["a" /* default */], {
              image: item,
              namePlaceholder: _this3.entity.namePlaceholder,
              nameHidden: false,
              size: sectionBoxSize,
              preferPngFormat: _this3.category.preferPNGFormat,
              readOnly: readOnly,
              editing: editingItemID && editingItemID === item._id,
              onBeginEditItem: function onBeginEditItem() {
                return _onBeginEditItem({ elementID: item._id });
              },
              onCancelEditItem: function onCancelEditItem() {
                return _onBeginEditItem({});
              },
              onRenameImage: function onRenameImage(name) {
                return _onRenameImage(_this3.category.itemsKey, section._id, item._id, { name: name });
              },
              onImageDragEnd: function onImageDragEnd(evt) {
                Object(__WEBPACK_IMPORTED_MODULE_9__sketch_native_events_js__["imageDragEnd"])(item, evt);
                setDraggedEntity(null);
              },
              onImageDragStart: function onImageDragStart(evt) {
                Object(__WEBPACK_IMPORTED_MODULE_9__sketch_native_events_js__["imageDragStart"])(prefetchingStyleData, evt);
                setDraggedEntity({ _id: item._id, sectionId: section._id });
              },
              onImageContextMenu: function onImageContextMenu(evt) {
                !readOnly ? _onImageContextMenu(evt, item, section._id) : null;
              },
              onPreviewEntity: function onPreviewEntity() {
                return _onPreviewEntity(_this3.entity.key, folderId, section._id, item._id);
              },
              onFallbackDataReceived: __WEBPACK_IMPORTED_MODULE_9__sketch_native_events_js__["onImageFallbackDataReceived"]
            })
          )
        );
      });
    }
  }, {
    key: 'renderSections',
    value: function renderSections() {
      var _this4 = this;

      var _props4 = this.props,
          readOnly = _props4.readOnly,
          sections = _props4.sections,
          onImageSectionContextMenu = _props4.onImageSectionContextMenu,
          onBeginEditItem = _props4.onBeginEditItem,
          onUpdateImageSection = _props4.onUpdateImageSection,
          editingItemID = _props4.editingItemID,
          isSearching = _props4.isSearching,
          selectedSectionId = _props4.selectedSectionId,
          imageType = _props4.imageType;


      var imageSections = sections.map(function (section, sectionIdx) {

        if (selectedSectionId && selectedSectionId !== section._id) {
          return null;
        }

        var imageTiles = _this4.renderTiles(section);

        //if there are no image tiles for the specific section and we are searching return null, since we don't want to present empty sections
        if (imageTiles.length === 0 && isSearching) {
          return null;
        }

        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          { key: section._id || sectionIdx, className: 'u-mb10' },
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3__components_library_SectionHead__["a" /* default */], {
            readOnly: readOnly,
            name: section.name,
            updateErrorOccurred: section.updateErrorOccurred,
            onMenu: function onMenu(evt) {
              return onImageSectionContextMenu(evt, section);
            },
            onBeginEdit: function onBeginEdit() {
              return onBeginEditItem({ elementID: section._id });
            },
            onCancelEdit: function onCancelEdit() {
              return onBeginEditItem({});
            },
            editing: editingItemID && editingItemID === section._id,
            onRename: onUpdateImageSection.bind(null, imageType, section._id),
            showDescription: true,
            description: section.description,
            descriptionAsDelta: section.descriptionAsDelta
          }),
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
            'div',
            { className: 'grid' },
            imageTiles
          )
        );
      });

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        null,
        imageSections
      );
    }
  }, {
    key: 'render',
    value: function render() {
      if (!__WEBPACK_IMPORTED_MODULE_1__util__["u" /* isNonEmptyArray */](this.props.sections)) {
        return this.renderEmptyViews();
      }

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        null,
        this.renderSections(),
        this.renderUploadWithSectionButton()
      );
    }
  }]);

  return ImagesSection;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component);



/***/ }),
/* 852 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_flux_actions__ = __webpack_require__(78);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__EntityHeader__ = __webpack_require__(853);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__EntityPreview__ = __webpack_require__(854);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__EntityDescription__ = __webpack_require__(856);
var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }










var EntityFullView = function (_React$Component) {
  _inherits(EntityFullView, _React$Component);

  function EntityFullView(props) {
    _classCallCheck(this, EntityFullView);

    var _this = _possibleConstructorReturn(this, (EntityFullView.__proto__ || Object.getPrototypeOf(EntityFullView)).call(this, props));

    _this.state = {};
    _this.handleResize = _this.handleResize.bind(_this);
    return _this;
  }

  _createClass(EntityFullView, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      window.addEventListener('resize', this.handleResize);
      this.handleResize();
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      window.removeEventListener('resize', this.handleResize);
    }
  }, {
    key: 'handleResize',
    value: function handleResize() {
      if (this.element) {
        this.setState({ dimensions: __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.pick(this.element.getBoundingClientRect(), ['width', 'height']) });
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var props = this.props;
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { ref: function ref(c) {
            return _this2.element = c;
          }, className: 'c-full-view' },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3__EntityHeader__["a" /* default */], _extends({}, props, {
          onBeginRename: this.props.onBeginEditItem,
          onRenameFinished: this.props.actions.onUpdateEntityByEntityType,
          editingItemID: this.props.editingItemID
        })),
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__EntityPreview__["a" /* default */], _extends({}, props, { dimensions: this.state.dimensions })),
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_5__EntityDescription__["a" /* default */], _extends({}, props, { updateDescription: this.props.actions.onUpdateEntityByEntityType }))
      );
    }
  }]);

  return EntityFullView;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component);

/* harmony default export */ __webpack_exports__["a"] = (Object(__WEBPACK_IMPORTED_MODULE_2_flux_actions__["a" /* default */])(EntityFullView));

/***/ }),
/* 853 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__components_library_TextInput__ = __webpack_require__(80);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_design_systems_lib__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_design_systems_lib___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_design_systems_lib__);





var entityTypes = __WEBPACK_IMPORTED_MODULE_2_design_systems_lib__["utils"].entityDescriptors.entityTypes;

function getPlaceholderName(type) {
  return type ? entityTypes[type].namePlaceholder : 'Untitled';
}

/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var entity = _ref.entity,
      type = _ref.type,
      readOnly = _ref.readOnly,
      editingItemID = _ref.editingItemID,
      onBeginRename = _ref.onBeginRename,
      onRenameFinished = _ref.onRenameFinished,
      sectionId = _ref.sectionId;


  var placeholder = getPlaceholderName(type);

  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    'div',
    null,
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_1__components_library_TextInput__["a" /* default */], {
      fieldClassName: 'c-full-view__name',
      readOnly: readOnly,
      value: entity.name,
      updateErrorOccurred: entity.updateErrorOccurred,
      labelDefaultValue: placeholder,
      editing: editingItemID && editingItemID === entity._id,
      onBeginEdit: function onBeginEdit() {
        return onBeginRename({ elementID: entity._id });
      },
      onCancelEdit: function onCancelEdit() {
        return onBeginRename({});
      },
      onChangeValue: function onChangeValue(name) {
        return onRenameFinished(type, sectionId, entity._id, { name: name });
      }
    })
  );
});

/***/ }),
/* 854 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_design_systems_lib__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_design_systems_lib___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_design_systems_lib__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__sketch_native_events__ = __webpack_require__(16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__components_library_ImagePreview__ = __webpack_require__(271);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__tiles_SharedStyleTile__ = __webpack_require__(269);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__tiles_TypeStyleSample__ = __webpack_require__(152);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__tiles_ColorTile__ = __webpack_require__(118);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__components_library_Shortcuts__ = __webpack_require__(153);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp2;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }














var EntityPreview = (_temp2 = _class = function (_React$Component) {
  _inherits(EntityPreview, _React$Component);

  function EntityPreview() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, EntityPreview);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = EntityPreview.__proto__ || Object.getPrototypeOf(EntityPreview)).call.apply(_ref, [this].concat(args))), _this), _this.handleShortcuts = function () {
      var entity = _this.props.entity;
      var action = null;
      switch (_this.props.type) {
        case 'sharedStyles':
          action = __WEBPACK_IMPORTED_MODULE_3__sketch_native_events__["chooseSharedStyle"].bind(null, _this.props.prefetchingStyleData, entity, { button: 0 }); //todo: ask Daniel what the button verification used for
          break;
        case 'typeStyles':
          action = __WEBPACK_IMPORTED_MODULE_3__sketch_native_events__["chooseTypography"].bind(null, entity, { button: 0 });
          break;
        case 'colors':
          action = __WEBPACK_IMPORTED_MODULE_3__sketch_native_events__["chooseColor"].bind(null, entity.value, { button: 0 });
          break;
      }

      if (action) {
        return action();
      }
    }, _this.renderEntity = function () {
      if (!_this[_this.props.type]) {
        return null;
      }
      return _this[_this.props.type]();
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(EntityPreview, [{
    key: 'typeStyles',


    /* TYPE RENDERING */

    value: function typeStyles() {
      var typographyEntity = this.props.entity;
      return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_6__tiles_TypeStyleSample__["a" /* default */], {
        onSelect: __WEBPACK_IMPORTED_MODULE_3__sketch_native_events__["chooseTypography"].bind(null, typographyEntity),
        readOnly: true,
        draggable: true,
        onTypeStyleDragEnd: __WEBPACK_IMPORTED_MODULE_3__sketch_native_events__["typeStyleDragEnd"].bind(null, typographyEntity),
        typeStyle: typographyEntity,
        trim: false,
        nameHidden: true
      });
    }
  }, {
    key: 'sharedStyles',
    value: function sharedStyles() {
      var sharedStyleEntity = this.props.entity;

      return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_5__tiles_SharedStyleTile__["a" /* default */], {
        readOnly: true,
        thumbnailURL: sharedStyleEntity.thumbnailUrl,
        customHeight: 80,
        onSelect: __WEBPACK_IMPORTED_MODULE_3__sketch_native_events__["chooseSharedStyle"].bind(null, this.props.prefetchingStyleData, sharedStyleEntity),
        draggable: false
      });
    }
  }, {
    key: 'colors',
    value: function colors() {

      var color = this.props.entity;

      return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_7__tiles_ColorTile__["a" /* default */], {
        readOnly: true,
        color: color.value,
        onSelect: __WEBPACK_IMPORTED_MODULE_3__sketch_native_events__["chooseColor"].bind(null, color.value),
        nameHidden: true,
        draggable: false
      });
    }
  }, {
    key: 'components',
    value: function components() {
      return this.imageType(true, true);
    }
  }, {
    key: 'icons',
    value: function icons() {
      return this.imageType(true, false);
    }
  }, {
    key: 'imageType',
    value: function imageType() {
      var useBackgroundColor = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
      var preferPNGFormat = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      var imageEntity = this.props.entity;
      var style = {};
      if (useBackgroundColor) {
        var colorObject = imageEntity.backgroundColorObject;
        style = { backgroundColor: colorObject && colorObject._id !== 'white' ? colorObject.value : null };
      }

      var _ref2 = this.props.dimensions || {},
          height = _ref2.height,
          width = _ref2.width;

      if (!height || !width) {
        return null;
      }

      var maxHeightDueToImageHeight = 200; // Somewhat reasonable size, hopefully this is never used.

      var imageAspectRatio = 2 / 3; // This is a guess and thankfully should almost never be used!

      var imageDimensions = __WEBPACK_IMPORTED_MODULE_2_design_systems_lib__["utils"].parseDimensions(imageEntity.dimensions);
      if (imageDimensions) {
        imageAspectRatio = imageDimensions.height / imageDimensions.width;
        maxHeightDueToImageHeight = imageDimensions.height;
      }

      var maxHeightDueToImageAspectRatioAndComponentWidth = width * imageAspectRatio;

      var maxHeightDueToComponentHeight = height - 110; // Leave some space at the bottom for the description.

      style.height = Math.min(maxHeightDueToImageHeight, maxHeightDueToImageAspectRatioAndComponentWidth, maxHeightDueToComponentHeight);

      //the entity preview defines padding based on being modal or not and it affect the allow left image size
      return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
        'div',
        { className: 'c-full-view__image-preview', style: style },
        __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__components_library_ImagePreview__["a" /* default */], {
          image: imageEntity,
          draggable: true,
          expectedWidth: width,
          expectedHeight: style.height,
          preferPngFormat: preferPNGFormat,
          onDragEnd: __WEBPACK_IMPORTED_MODULE_3__sketch_native_events__["imageDragEnd"].bind(null, imageEntity),
          onDragStart: __WEBPACK_IMPORTED_MODULE_3__sketch_native_events__["imageDragStart"].bind(null, this.props.prefetchingStyleData),
          useOrignalImage: true
        })
      );
    }
  }, {
    key: 'render',
    value: function render() {
      return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
        'div',
        { className: 'u-mt10 u-mb5' },
        __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
          __WEBPACK_IMPORTED_MODULE_8__components_library_Shortcuts__["a" /* default */],
          { name: 'ApplyEntity', handler: this.handleShortcuts },
          this.renderEntity()
        )
      );
    }
  }]);

  return EntityPreview;
}(__WEBPACK_IMPORTED_MODULE_1_react___default.a.Component), _class.propTypes = {
  type: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.string,
  entity: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.object.isRequired,
  organizationName: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.string,
  styleguideName: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.string,
  accessKey: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.string,
  enclosingId: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.string,
  onUpdate: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.func,
  readOnly: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.bool,
  boundingRect: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.number
}, _temp2);


/* harmony default export */ __webpack_exports__["a"] = (EntityPreview);

/***/ }),
/* 855 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/*

  Top level keys of the JSON are the names of keyboard shortcuts schemas that might be used bu component.
  Each such entry contain keys which are the actual combinations keyboard that will be behind some action.
  For each key you can find a string value which represents the constant meaning of the actions and that is what will be passed
  to users of Shortcuts component to help differentiate between different cases
 */

/* harmony default export */ __webpack_exports__["a"] = ({
  TreeNavigation: {
    'up': 'MOVE_UP',
    'down': 'MOVE_DOWN'
  },
  Search: {
    'command+f': 'FOCUS_SEARCH'
  },
  ApplyEntity: {
    'enter': 'APPLY'
  }
});

/***/ }),
/* 856 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__components_library_RichTextEditorWithCustomLinks__ = __webpack_require__(197);



/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var type = _ref.type,
      entity = _ref.entity,
      readOnly = _ref.readOnly,
      sectionId = _ref.sectionId,
      updateDescription = _ref.updateDescription;


  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    'div',
    { className: 'c-full-view__description' },
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_1__components_library_RichTextEditorWithCustomLinks__["a" /* default */], {
      readOnly: readOnly,
      value: entity.descriptionAsDelta,
      legacyValue: entity.description,
      placeholder: 'Description...',
      onFinishedEditing: function onFinishedEditing(descriptionAsDelta) {
        return updateDescription(type, sectionId, entity._id, { descriptionAsDelta: descriptionAsDelta });
      }
    })
  );
});

/***/ }),
/* 857 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return FolderHeader; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__SectionHead__ = __webpack_require__(119);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






var FolderHeader = (_temp = _class = function (_React$Component) {
  _inherits(FolderHeader, _React$Component);

  function FolderHeader() {
    _classCallCheck(this, FolderHeader);

    return _possibleConstructorReturn(this, (FolderHeader.__proto__ || Object.getPrototypeOf(FolderHeader)).apply(this, arguments));
  }

  _createClass(FolderHeader, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          folder = _props.folder,
          readOnly = _props.readOnly,
          disabled = _props.disabled,
          editingItemID = _props.editingItemID,
          onBeginEditItem = _props.onBeginEditItem,
          onUpdateFolder = _props.onUpdateFolder,
          _onMenu = _props.onMenu;


      var folderIdentifier = folder._id || folder.folderEntityType;

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2__SectionHead__["a" /* default */], {
        readOnly: readOnly,
        disabled: disabled,
        additionalClassNames: 'u-pb10 u-section-border-bottom u-mb10',
        name: folder.name,
        description: folder.description,
        descriptionAsDelta: folder.descriptionAsDelta,
        showDescription: true,
        onBeginEdit: function onBeginEdit() {
          return onBeginEditItem({ folderId: folderIdentifier });
        },
        onCancelEdit: function onCancelEdit() {
          return onBeginEditItem({});
        },
        editing: editingItemID && editingItemID === folderIdentifier,
        onRename: function onRename(data) {
          return onUpdateFolder(folder, data);
        },
        updateErrorOccurred: folder.updateErrorOccurred,
        onMenu: function onMenu(evt) {
          return _onMenu(evt, folder);
        }
      });
    }
  }]);

  return FolderHeader;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component), _class.propTypes = {
  folder: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.shape({
    _id: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
    name: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
    description: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
    folderEntityType: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string
  }),
  editingItemID: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
  readOnly: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
  disabled: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
  onBeginEditItem: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onUpdateFolder: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onMenu: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func
}, _temp);


/***/ }),
/* 858 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_design_systems_lib__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_design_systems_lib___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_design_systems_lib__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__brandai_design_systems_web__ = __webpack_require__(42);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__brandai_design_systems_web___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2__brandai_design_systems_web__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__components_library_Icon__ = __webpack_require__(34);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__sketch_native_events__ = __webpack_require__(16);



var NewOrganizationForm = __WEBPACK_IMPORTED_MODULE_2__brandai_design_systems_web__["compositeComponents"].NewOrganizationForm;






/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var user = _ref.user,
      idToken = _ref.idToken,
      organizationExistMessage = _ref.organizationExistMessage,
      onCreateOrganization = _ref.onCreateOrganization,
      checkOrganizationExists = _ref.checkOrganizationExists,
      onSignOut = _ref.onSignOut;


  var content = void 0;
  if ((user.companyId || user.teamId) && user.isInvisionAdmin === false) {
    content = __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'div',
      { className: 'u-mx20' },
      __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'p',
        { className: 'u-medium' },
        'Let\u2019s try that again'
      ),
      __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'p',
        { className: 'u-small' },
        'To keep our libraries secure, every user must be invited by your InVision account administrator. Please reach out to your organization\u2019s admin for access.'
      )
    );
  } else if (user.anonymous) {
    //this currently happen because of an issue with CM that doesn't change domains correct for SSO and thus it results
    //in anonymous user return from edge gateway for us
    content = __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'div',
      { className: 'u-mx20' },
      __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'p',
        { className: 'u-medium' },
        'Oops, something went wrong'
      ),
      __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'p',
        { className: 'u-small' },
        'Please try to sign in again.'
      )
    );
  } else {
    content = __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(NewOrganizationForm, {
      message: organizationExistMessage,
      showStyleguideTemplates: false,
      styleguideTemplateKey: __WEBPACK_IMPORTED_MODULE_1_design_systems_lib__["sharedConstants"].styleguideTemplates.blank,
      onCreate: onCreateOrganization,
      checkOrganizationExists: checkOrganizationExists,
      user: user,
      onSignOut: onSignOut
    });
  }

  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    'div',
    { className: 'c-sign-up' },
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'div',
      { className: 'u-fixed u-l3 u-t4', onClick: function onClick() {
          return Object(__WEBPACK_IMPORTED_MODULE_4__sketch_native_events__["openApplicationMenu"])({ idToken: idToken });
        } },
      __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3__components_library_Icon__["a" /* default */], { size: 16, glyph: 'chevron-down-alt' })
    ),
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'div',
      { className: 'u-fixed u-l15 u-t5' },
      __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3__components_library_Icon__["a" /* default */], { size: 32, color: 'black', glyph: 'invision-logo' })
    ),
    content
  );
});

/***/ }),
/* 859 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_react_waypoint__ = __webpack_require__(860);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_react_waypoint___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_react_waypoint__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_flux_actions__ = __webpack_require__(78);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__components_library_SideNav__ = __webpack_require__(876);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__components_library_SearchBox__ = __webpack_require__(877);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__styleguide_StyleguideTree__ = __webpack_require__(878);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__ApplicationHeader__ = __webpack_require__(942);
var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }












var ApplicationNav = function (_Component) {
  _inherits(ApplicationNav, _Component);

  function ApplicationNav(props) {
    _classCallCheck(this, ApplicationNav);

    var _this = _possibleConstructorReturn(this, (ApplicationNav.__proto__ || Object.getPrototypeOf(ApplicationNav)).call(this, props));

    _this.state = { scrolling: false };
    return _this;
  }

  _createClass(ApplicationNav, [{
    key: 'renderApplicationHeader',
    value: function renderApplicationHeader() {

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_7__ApplicationHeader__["a" /* default */], _extends({}, this.props, {
        onUpdateDocument: this.props.actions.startingUpdateDocument
      }));
    }
  }, {
    key: 'renderSearchBox',
    value: function renderSearchBox() {
      if (this.props.styleData) {
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_5__components_library_SearchBox__["a" /* default */], {
          searchQuery: this.props.searchQuery,
          placeholder: 'Search',
          onSearch: this.props.actions.searchStyleguide
        });
      }
      return null;
    }
  }, {
    key: 'renderStyleguideTree',
    value: function renderStyleguideTree() {
      if (this.props.styleData) {
        var data = __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.pick(this.props, ['styleData', 'selectedType', 'selectedFolderId', 'selectedSectionId', 'selectedStyleEntity', 'toggledNodes', 'editingItemID', 'editingSource', 'readOnly']);
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_6__styleguide_StyleguideTree__["a" /* default */], _extends({}, data, {
          isSearching: !!this.props.searchQuery,
          allowActiveNode: !this.props.addingFolder
        }));
      }
      return null;
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var headerClassName = 'c-app-nav__header ' + (this.state.scrolling ? 'c-app-nav__header-scrolling' : '');

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        __WEBPACK_IMPORTED_MODULE_4__components_library_SideNav__["a" /* default */],
        null,
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          { className: headerClassName },
          this.renderApplicationHeader(),
          this.renderSearchBox()
        ),
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          { className: 'c-app-nav__container' },
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2_react_waypoint___default.a, {
            onLeave: function onLeave() {
              _this2.setState({ scrolling: true });
            },
            onEnter: function onEnter() {
              _this2.setState({ scrolling: false });
            }
          }),
          this.renderStyleguideTree()
        )
      );
    }
  }]);

  return ApplicationNav;
}(__WEBPACK_IMPORTED_MODULE_0_react__["Component"]);

/* harmony default export */ __webpack_exports__["a"] = (Object(__WEBPACK_IMPORTED_MODULE_3_flux_actions__["a" /* default */])(ApplicationNav));

/***/ }),
/* 860 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _consolidatedEvents = __webpack_require__(861);

var _propTypes = __webpack_require__(1);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _computeOffsetPixels = __webpack_require__(867);

var _computeOffsetPixels2 = _interopRequireDefault(_computeOffsetPixels);

var _constants = __webpack_require__(272);

var _constants2 = _interopRequireDefault(_constants);

var _debugLog = __webpack_require__(870);

var _debugLog2 = _interopRequireDefault(_debugLog);

var _ensureChildrenIsSingleDOMElement = __webpack_require__(871);

var _ensureChildrenIsSingleDOMElement2 = _interopRequireDefault(_ensureChildrenIsSingleDOMElement);

var _getCurrentPosition = __webpack_require__(873);

var _getCurrentPosition2 = _interopRequireDefault(_getCurrentPosition);

var _onNextTick = __webpack_require__(874);

var _onNextTick2 = _interopRequireDefault(_onNextTick);

var _resolveScrollableAncestorProp = __webpack_require__(875);

var _resolveScrollableAncestorProp2 = _interopRequireDefault(_resolveScrollableAncestorProp);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var defaultProps = {
  topOffset: '0px',
  bottomOffset: '0px',
  horizontal: false,
  onEnter: function onEnter() {},
  onLeave: function onLeave() {},
  onPositionChange: function onPositionChange() {},

  fireOnRapidScroll: true
};

/**
 * Calls a function when you scroll to the element.
 */

var Waypoint = function (_React$Component) {
  _inherits(Waypoint, _React$Component);

  function Waypoint(props) {
    _classCallCheck(this, Waypoint);

    var _this = _possibleConstructorReturn(this, (Waypoint.__proto__ || Object.getPrototypeOf(Waypoint)).call(this, props));

    _this.refElement = function (e) {
      return _this._ref = e;
    };
    return _this;
  }

  _createClass(Waypoint, [{
    key: 'componentWillMount',
    value: function componentWillMount() {
      (0, _ensureChildrenIsSingleDOMElement2.default)(this.props.children);

      if (this.props.scrollableParent) {
        // eslint-disable-line react/prop-types
        throw new Error('The `scrollableParent` prop has changed name to `scrollableAncestor`.');
      }
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      var _this2 = this;

      if (!Waypoint.getWindow()) {
        return;
      }

      // this._ref may occasionally not be set at this time. To help ensure that
      // this works smoothly, we want to delay the initial execution until the
      // next tick.
      this.cancelInitialTimeout = (0, _onNextTick2.default)(function () {
        _this2._handleScroll = _this2._handleScroll.bind(_this2);
        _this2.scrollableAncestor = _this2._findScrollableAncestor();

        if (process.env.NODE_ENV !== 'production' && _this2.props.debug) {
          (0, _debugLog2.default)('scrollableAncestor', _this2.scrollableAncestor);
        }

        _this2.scrollEventListenerHandle = (0, _consolidatedEvents.addEventListener)(_this2.scrollableAncestor, 'scroll', _this2._handleScroll, { passive: true });

        _this2.resizeEventListenerHandle = (0, _consolidatedEvents.addEventListener)(window, 'resize', _this2._handleScroll, { passive: true });

        _this2._handleScroll(null);
      });
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      (0, _ensureChildrenIsSingleDOMElement2.default)(nextProps.children);
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate() {
      if (!Waypoint.getWindow()) {
        return;
      }

      if (!this.scrollableAncestor) {
        // The Waypoint has not yet initialized.
        return;
      }

      // The element may have moved.
      this._handleScroll(null);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (!Waypoint.getWindow()) {
        return;
      }

      if (this.scrollEventListenerHandle) {
        (0, _consolidatedEvents.removeEventListener)(this.scrollEventListenerHandle);
      }
      if (this.resizeEventListenerHandle) {
        (0, _consolidatedEvents.removeEventListener)(this.resizeEventListenerHandle);
      }

      if (this.cancelInitialTimeout) {
        this.cancelInitialTimeout();
      }
    }

    /**
     * Traverses up the DOM to find an ancestor container which has an overflow
     * style that allows for scrolling.
     *
     * @return {Object} the closest ancestor element with an overflow style that
     *   allows for scrolling. If none is found, the `window` object is returned
     *   as a fallback.
     */

  }, {
    key: '_findScrollableAncestor',
    value: function _findScrollableAncestor() {
      var _props = this.props,
          horizontal = _props.horizontal,
          scrollableAncestor = _props.scrollableAncestor;


      if (scrollableAncestor) {
        return (0, _resolveScrollableAncestorProp2.default)(scrollableAncestor);
      }

      var node = this._ref;

      while (node.parentNode) {
        node = node.parentNode;

        if (node === document.body) {
          // We've reached all the way to the root node.
          return window;
        }

        var style = window.getComputedStyle(node);
        var overflowDirec = horizontal ? style.getPropertyValue('overflow-x') : style.getPropertyValue('overflow-y');
        var overflow = overflowDirec || style.getPropertyValue('overflow');

        if (overflow === 'auto' || overflow === 'scroll') {
          return node;
        }
      }

      // A scrollable ancestor element was not found, which means that we need to
      // do stuff on window.
      return window;
    }

    /**
     * @param {Object} event the native scroll event coming from the scrollable
     *   ancestor, or resize event coming from the window. Will be undefined if
     *   called by a React lifecyle method
     */

  }, {
    key: '_handleScroll',
    value: function _handleScroll(event) {
      if (!this._ref) {
        // There's a chance we end up here after the component has been unmounted.
        return;
      }

      var bounds = this._getBounds();
      var currentPosition = (0, _getCurrentPosition2.default)(bounds);
      var previousPosition = this._previousPosition;

      if (process.env.NODE_ENV !== 'production' && this.props.debug) {
        (0, _debugLog2.default)('currentPosition', currentPosition);
        (0, _debugLog2.default)('previousPosition', previousPosition);
      }

      // Save previous position as early as possible to prevent cycles
      this._previousPosition = currentPosition;

      if (previousPosition === currentPosition) {
        // No change since last trigger
        return;
      }

      var callbackArg = {
        currentPosition: currentPosition,
        previousPosition: previousPosition,
        event: event,
        waypointTop: bounds.waypointTop,
        waypointBottom: bounds.waypointBottom,
        viewportTop: bounds.viewportTop,
        viewportBottom: bounds.viewportBottom
      };
      this.props.onPositionChange.call(this, callbackArg);

      if (currentPosition === _constants2.default.inside) {
        this.props.onEnter.call(this, callbackArg);
      } else if (previousPosition === _constants2.default.inside) {
        this.props.onLeave.call(this, callbackArg);
      }

      var isRapidScrollDown = previousPosition === _constants2.default.below && currentPosition === _constants2.default.above;
      var isRapidScrollUp = previousPosition === _constants2.default.above && currentPosition === _constants2.default.below;

      if (this.props.fireOnRapidScroll && (isRapidScrollDown || isRapidScrollUp)) {
        // If the scroll event isn't fired often enough to occur while the
        // waypoint was visible, we trigger both callbacks anyway.
        this.props.onEnter.call(this, {
          currentPosition: _constants2.default.inside,
          previousPosition: previousPosition,
          event: event,
          waypointTop: bounds.waypointTop,
          waypointBottom: bounds.waypointBottom,
          viewportTop: bounds.viewportTop,
          viewportBottom: bounds.viewportBottom
        });
        this.props.onLeave.call(this, {
          currentPosition: currentPosition,
          previousPosition: _constants2.default.inside,
          event: event,
          waypointTop: bounds.waypointTop,
          waypointBottom: bounds.waypointBottom,
          viewportTop: bounds.viewportTop,
          viewportBottom: bounds.viewportBottom
        });
      }
    }
  }, {
    key: '_getBounds',
    value: function _getBounds() {
      var horizontal = this.props.horizontal;

      var _ref$getBoundingClien = this._ref.getBoundingClientRect(),
          left = _ref$getBoundingClien.left,
          top = _ref$getBoundingClien.top,
          right = _ref$getBoundingClien.right,
          bottom = _ref$getBoundingClien.bottom;

      var waypointTop = horizontal ? left : top;
      var waypointBottom = horizontal ? right : bottom;

      var contextHeight = void 0;
      var contextScrollTop = void 0;
      if (this.scrollableAncestor === window) {
        contextHeight = horizontal ? window.innerWidth : window.innerHeight;
        contextScrollTop = 0;
      } else {
        contextHeight = horizontal ? this.scrollableAncestor.offsetWidth : this.scrollableAncestor.offsetHeight;
        contextScrollTop = horizontal ? this.scrollableAncestor.getBoundingClientRect().left : this.scrollableAncestor.getBoundingClientRect().top;
      }

      if (process.env.NODE_ENV !== 'production' && this.props.debug) {
        (0, _debugLog2.default)('waypoint top', waypointTop);
        (0, _debugLog2.default)('waypoint bottom', waypointBottom);
        (0, _debugLog2.default)('scrollableAncestor height', contextHeight);
        (0, _debugLog2.default)('scrollableAncestor scrollTop', contextScrollTop);
      }

      var _props2 = this.props,
          bottomOffset = _props2.bottomOffset,
          topOffset = _props2.topOffset;

      var topOffsetPx = (0, _computeOffsetPixels2.default)(topOffset, contextHeight);
      var bottomOffsetPx = (0, _computeOffsetPixels2.default)(bottomOffset, contextHeight);
      var contextBottom = contextScrollTop + contextHeight;

      return {
        waypointTop: waypointTop,
        waypointBottom: waypointBottom,
        viewportTop: contextScrollTop + topOffsetPx,
        viewportBottom: contextBottom - bottomOffsetPx
      };
    }

    /**
     * @return {Object}
     */

  }, {
    key: 'render',
    value: function render() {
      var _this3 = this;

      var children = this.props.children;


      if (!children) {
        // We need an element that we can locate in the DOM to determine where it is
        // rendered relative to the top of its context.
        return _react2.default.createElement('span', { ref: this.refElement, style: { fontSize: 0 } });
      }

      var ref = function ref(node) {
        _this3.refElement(node);
        if (children.ref) {
          children.ref(node);
        }
      };

      return _react2.default.cloneElement(children, { ref: ref });
    }
  }]);

  return Waypoint;
}(_react2.default.Component);

exports.default = Waypoint;


Waypoint.propTypes = {
  children: _propTypes2.default.element,
  debug: _propTypes2.default.bool,
  onEnter: _propTypes2.default.func,
  onLeave: _propTypes2.default.func,
  onPositionChange: _propTypes2.default.func,
  fireOnRapidScroll: _propTypes2.default.bool,
  scrollableAncestor: _propTypes2.default.any,
  horizontal: _propTypes2.default.bool,

  // `topOffset` can either be a number, in which case its a distance from the
  // top of the container in pixels, or a string value. Valid string values are
  // of the form "20px", which is parsed as pixels, or "20%", which is parsed
  // as a percentage of the height of the containing element.
  // For instance, if you pass "-20%", and the containing element is 100px tall,
  // then the waypoint will be triggered when it has been scrolled 20px beyond
  // the top of the containing element.
  topOffset: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.number]),

  // `bottomOffset` is like `topOffset`, but for the bottom of the container.
  bottomOffset: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.number])
};

Waypoint.above = _constants2.default.above;
Waypoint.below = _constants2.default.below;
Waypoint.inside = _constants2.default.inside;
Waypoint.invisible = _constants2.default.invisible;
Waypoint.getWindow = function () {
  if (typeof window !== 'undefined') {
    return window;
  }
};
Waypoint.defaultProps = defaultProps;
Waypoint.displayName = 'Waypoint';
module.exports = exports['default'];
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(11)))

/***/ }),
/* 861 */
/***/ (function(module, exports, __webpack_require__) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EVENT_HANDLERS_KEY = undefined;
exports.addEventListener = addEventListener;
exports.removeEventListener = removeEventListener;

var _normalizeEventOptions = __webpack_require__(862);

var _normalizeEventOptions2 = _interopRequireDefault(_normalizeEventOptions);

var _TargetEventHandlers = __webpack_require__(865);

var _TargetEventHandlers2 = _interopRequireDefault(_TargetEventHandlers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

// Export to make testing possible.
var EVENT_HANDLERS_KEY = exports.EVENT_HANDLERS_KEY = '__consolidated_events_handlers__';

function addEventListener(target, eventName, listener, options) {
  if (!target[EVENT_HANDLERS_KEY]) {
    // eslint-disable-next-line no-param-reassign
    target[EVENT_HANDLERS_KEY] = new _TargetEventHandlers2['default'](target);
  }
  var normalizedEventOptions = (0, _normalizeEventOptions2['default'])(options);
  return target[EVENT_HANDLERS_KEY].add(eventName, listener, normalizedEventOptions);
}

// Deprecated
function removeEventListener(unsubscribeFn) {
  unsubscribeFn();
}

/***/ }),
/* 862 */
/***/ (function(module, exports, __webpack_require__) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports['default'] = normalizeEventOptions;

var _canUsePassiveEventListeners = __webpack_require__(863);

var _canUsePassiveEventListeners2 = _interopRequireDefault(_canUsePassiveEventListeners);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function normalizeEventOptions(eventOptions) {
  if (!eventOptions) {
    return undefined;
  }

  if (!(0, _canUsePassiveEventListeners2['default'])()) {
    // If the browser does not support the passive option, then it is expecting
    // a boolean for the options argument to specify whether it should use
    // capture or not. In more modern browsers, this is passed via the `capture`
    // option, so let's just hoist that value up.
    return !!eventOptions.capture;
  }

  return eventOptions;
}

/***/ }),
/* 863 */
/***/ (function(module, exports, __webpack_require__) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports['default'] = canUsePassiveEventListeners;

var _canUseDOM = __webpack_require__(864);

var _canUseDOM2 = _interopRequireDefault(_canUseDOM);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

// Adapted from Modernizr
// https://github.com/Modernizr/Modernizr/blob/5eea7e2a/feature-detects/dom/passiveeventlisteners.js#L26-L35
function testPassiveEventListeners() {
  if (!_canUseDOM2['default']) {
    return false;
  }

  if (!window.addEventListener || !window.removeEventListener || !Object.defineProperty) {
    return false;
  }

  var supportsPassiveOption = false;
  try {
    var opts = Object.defineProperty({}, 'passive', {
      get: function () {
        function get() {
          supportsPassiveOption = true;
        }

        return get;
      }()
    });
    window.addEventListener('test', null, opts);
  } catch (e) {
    // do nothing
  }

  return supportsPassiveOption;
}

var memoized = void 0;

function canUsePassiveEventListeners() {
  if (memoized === undefined) {
    memoized = testPassiveEventListeners();
  }
  return memoized;
}

/***/ }),
/* 864 */
/***/ (function(module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
var CAN_USE_DOM = !!(typeof window !== 'undefined' && window.document && window.document.createElement);

exports['default'] = CAN_USE_DOM;

/***/ }),
/* 865 */
/***/ (function(module, exports, __webpack_require__) {

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _eventOptionsKey = __webpack_require__(866);

var _eventOptionsKey2 = _interopRequireDefault(_eventOptionsKey);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ensureCanMutateNextEventHandlers(eventHandlers) {
  if (eventHandlers.handlers === eventHandlers.nextHandlers) {
    // eslint-disable-next-line no-param-reassign
    eventHandlers.nextHandlers = eventHandlers.handlers.slice();
  }
}

var TargetEventHandlers = function () {
  function TargetEventHandlers(target) {
    _classCallCheck(this, TargetEventHandlers);

    this.target = target;
    this.events = {};
  }

  _createClass(TargetEventHandlers, [{
    key: 'getEventHandlers',
    value: function () {
      function getEventHandlers(eventName, options) {
        var key = String(eventName) + ' ' + String((0, _eventOptionsKey2['default'])(options));

        if (!this.events[key]) {
          this.events[key] = {
            handlers: [],
            handleEvent: undefined
          };
          this.events[key].nextHandlers = this.events[key].handlers;
        }

        return this.events[key];
      }

      return getEventHandlers;
    }()
  }, {
    key: 'handleEvent',
    value: function () {
      function handleEvent(eventName, options, event) {
        var eventHandlers = this.getEventHandlers(eventName, options);
        eventHandlers.handlers = eventHandlers.nextHandlers;
        eventHandlers.handlers.forEach(function (handler) {
          if (handler) {
            // We need to check for presence here because a handler function may
            // cause later handlers to get removed. This can happen if you for
            // instance have a waypoint that unmounts another waypoint as part of an
            // onEnter/onLeave handler.
            handler(event);
          }
        });
      }

      return handleEvent;
    }()
  }, {
    key: 'add',
    value: function () {
      function add(eventName, listener, options) {
        var _this = this;

        // options has already been normalized at this point.
        var eventHandlers = this.getEventHandlers(eventName, options);

        ensureCanMutateNextEventHandlers(eventHandlers);

        if (eventHandlers.nextHandlers.length === 0) {
          eventHandlers.handleEvent = this.handleEvent.bind(this, eventName, options);

          this.target.addEventListener(eventName, eventHandlers.handleEvent, options);
        }

        eventHandlers.nextHandlers.push(listener);

        var isSubscribed = true;
        var unsubscribe = function () {
          function unsubscribe() {
            if (!isSubscribed) {
              return;
            }

            isSubscribed = false;

            ensureCanMutateNextEventHandlers(eventHandlers);
            var index = eventHandlers.nextHandlers.indexOf(listener);
            eventHandlers.nextHandlers.splice(index, 1);

            if (eventHandlers.nextHandlers.length === 0) {
              // All event handlers have been removed, so we want to remove the event
              // listener from the target node.

              if (_this.target) {
                // There can be a race condition where the target may no longer exist
                // when this function is called, e.g. when a React component is
                // unmounting. Guarding against this prevents the following error:
                //
                //   Cannot read property 'removeEventListener' of undefined
                _this.target.removeEventListener(eventName, eventHandlers.handleEvent, options);
              }

              eventHandlers.handleEvent = undefined;
            }
          }

          return unsubscribe;
        }();
        return unsubscribe;
      }

      return add;
    }()
  }]);

  return TargetEventHandlers;
}();

exports['default'] = TargetEventHandlers;

/***/ }),
/* 866 */
/***/ (function(module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = eventOptionsKey;
/* eslint-disable no-bitwise */

/**
 * Generate a unique key for any set of event options
 */
function eventOptionsKey(normalizedEventOptions) {
  if (!normalizedEventOptions) {
    return 0;
  }

  // If the browser does not support passive event listeners, the normalized
  // event options will be a boolean.
  if (normalizedEventOptions === true) {
    return 100;
  }

  // At this point, the browser supports passive event listeners, so we expect
  // the event options to be an object with possible properties of capture,
  // passive, and once.
  //
  // We want to consistently return the same value, regardless of the order of
  // these properties, so let's use binary maths to assign each property to a
  // bit, and then add those together (with an offset to account for the
  // booleans at the beginning of this function).
  var capture = normalizedEventOptions.capture << 0;
  var passive = normalizedEventOptions.passive << 1;
  var once = normalizedEventOptions.once << 2;
  return capture + passive + once;
}

/***/ }),
/* 867 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = computeOffsetPixels;

var _parseOffsetAsPercentage = __webpack_require__(868);

var _parseOffsetAsPercentage2 = _interopRequireDefault(_parseOffsetAsPercentage);

var _parseOffsetAsPixels = __webpack_require__(869);

var _parseOffsetAsPixels2 = _interopRequireDefault(_parseOffsetAsPixels);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @param {string|number} offset
 * @param {number} contextHeight
 * @return {number} A number representing `offset` converted into pixels.
 */
function computeOffsetPixels(offset, contextHeight) {
  var pixelOffset = (0, _parseOffsetAsPixels2.default)(offset);

  if (typeof pixelOffset === 'number') {
    return pixelOffset;
  }

  var percentOffset = (0, _parseOffsetAsPercentage2.default)(offset);
  if (typeof percentOffset === 'number') {
    return percentOffset * contextHeight;
  }
}
module.exports = exports['default'];

/***/ }),
/* 868 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = parseOffsetAsPercentage;
/**
 * Attempts to parse the offset provided as a prop as a percentage. For
 * instance, if the component has been provided with the string "20%" as
 * a value of one of the offset props. If the value matches, then it returns
 * a numeric version of the prop. For instance, "20%" would become `0.2`.
 * If `str` isn't a percentage, then `undefined` will be returned.
 *
 * @param {string} str The value of an offset prop to be converted to a
 *   number.
 * @return {number|undefined} The numeric version of `str`. Undefined if `str`
 *   was not a percentage.
 */
function parseOffsetAsPercentage(str) {
  if (str.slice(-1) === '%') {
    return parseFloat(str.slice(0, -1)) / 100;
  }
}
module.exports = exports['default'];

/***/ }),
/* 869 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = parseOffsetAsPixels;
/**
 * Attempts to parse the offset provided as a prop as a pixel value. If
 * parsing fails, then `undefined` is returned. Three examples of values that
 * will be successfully parsed are:
 * `20`
 * "20px"
 * "20"
 *
 * @param {string|number} str A string of the form "{number}" or "{number}px",
 *   or just a number.
 * @return {number|undefined} The numeric version of `str`. Undefined if `str`
 *   was neither a number nor string ending in "px".
 */
function parseOffsetAsPixels(str) {
  if (!isNaN(parseFloat(str)) && isFinite(str)) {
    return parseFloat(str);
  } else if (str.slice(-2) === 'px') {
    return parseFloat(str.slice(0, -2));
  }
}
module.exports = exports['default'];

/***/ }),
/* 870 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = debugLog;
function debugLog() {
  if (process.env.NODE_ENV !== 'production') {
    console.log(arguments); // eslint-disable-line no-console
  }
}
module.exports = exports['default'];
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(11)))

/***/ }),
/* 871 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ensureChildrenIsSingleDOMElement;

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _isDOMElement = __webpack_require__(872);

var _isDOMElement2 = _interopRequireDefault(_isDOMElement);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Raise an error if "children" isn't a single DOM Element
 *
 * @param {React.element|null} children
 * @return {undefined}
 */
function ensureChildrenIsSingleDOMElement(children) {
  if (children) {
    _react2.default.Children.only(children);

    if (!(0, _isDOMElement2.default)(children)) {
      throw new Error('You must wrap any Component Elements passed to Waypoint in a DOM Element (eg; a <div>).');
    }
  }
}
module.exports = exports['default'];

/***/ }),
/* 872 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isDOMElement;
/**
 * When an element's type is a string, it represents a DOM node with that tag name
 * https://facebook.github.io/react/blog/2015/12/18/react-components-elements-and-instances.html#dom-elements
 *
 * @param {React.element} Component
 * @return {bool} Whether the component is a DOM Element
 */
function isDOMElement(Component) {
  return typeof Component.type === 'string';
}
module.exports = exports['default'];

/***/ }),
/* 873 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getCurrentPosition;

var _constants = __webpack_require__(272);

var _constants2 = _interopRequireDefault(_constants);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @param {object} bounds An object with bounds data for the waypoint and
 *   scrollable parent
 * @return {string} The current position of the waypoint in relation to the
 *   visible portion of the scrollable parent. One of `constants.above`,
 *   `constants.below`, or `constants.inside`.
 */
function getCurrentPosition(bounds) {
  if (bounds.viewportBottom - bounds.viewportTop === 0) {
    return _constants2.default.invisible;
  }

  // top is within the viewport
  if (bounds.viewportTop <= bounds.waypointTop && bounds.waypointTop <= bounds.viewportBottom) {
    return _constants2.default.inside;
  }

  // bottom is within the viewport
  if (bounds.viewportTop <= bounds.waypointBottom && bounds.waypointBottom <= bounds.viewportBottom) {
    return _constants2.default.inside;
  }

  // top is above the viewport and bottom is below the viewport
  if (bounds.waypointTop <= bounds.viewportTop && bounds.viewportBottom <= bounds.waypointBottom) {
    return _constants2.default.inside;
  }

  if (bounds.viewportBottom < bounds.waypointTop) {
    return _constants2.default.below;
  }

  if (bounds.waypointTop < bounds.viewportTop) {
    return _constants2.default.above;
  }

  return _constants2.default.invisible;
}
module.exports = exports['default'];

/***/ }),
/* 874 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = onNextTick;
var timeout = void 0;
var timeoutQueue = [];

function onNextTick(cb) {
  timeoutQueue.push(cb);

  if (!timeout) {
    timeout = setTimeout(function () {
      timeout = null;

      // Drain the timeoutQueue
      var item = void 0;
      // eslint-disable-next-line no-cond-assign
      while (item = timeoutQueue.shift()) {
        item();
      }
    }, 0);
  }

  return function unsubscribe() {
    var index = timeoutQueue.indexOf(cb);
    if (index === -1) {
      return;
    }

    timeoutQueue.splice(index, 1);

    if (!timeoutQueue.length && timeout) {
      clearTimeout(timeout);
      timeout = null;
    }
  };
}
module.exports = exports["default"];

/***/ }),
/* 875 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = resolveScrollableAncestorProp;
function resolveScrollableAncestorProp(scrollableAncestor) {
  // When Waypoint is rendered on the server, `window` is not available.
  // To make Waypoint easier to work with, we allow this to be specified in
  // string form and safely convert to `window` here.
  if (scrollableAncestor === 'window') {
    return global.window;
  }

  return scrollableAncestor;
}
module.exports = exports['default'];
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(22)))

/***/ }),
/* 876 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);


/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var children = _ref.children;


  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    "div",
    { className: "c-side-nav" },
    children
  );
});

/***/ }),
/* 877 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return SearchBox; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_classnames__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_classnames___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_classnames__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__components_library_Icon__ = __webpack_require__(34);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__Shortcuts_js__ = __webpack_require__(153);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }










var SearchBox = function (_React$Component) {
  _inherits(SearchBox, _React$Component);

  function SearchBox(props) {
    _classCallCheck(this, SearchBox);

    var _this = _possibleConstructorReturn(this, (SearchBox.__proto__ || Object.getPrototypeOf(SearchBox)).call(this, props));

    _this.handleChange = _this.handleChange.bind(_this);
    _this.handleClear = _this.handleClear.bind(_this);

    _this.state = {
      searchQuery: props.searchQuery,
      searchCallback: __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.debounce(props.onSearch, 300)
    };
    return _this;
  }

  _createClass(SearchBox, [{
    key: 'setFocus',
    value: function setFocus() {
      if (this.searchInput) {
        this.searchInput.focus();
      }
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      this.setFocus();
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (!nextProps.searchQuery) {
        this.setState({
          searchQuery: nextProps.searchQuery
        });
      }
    }
  }, {
    key: 'handleChange',
    value: function handleChange(e) {
      var value = e.target.value;
      if (value !== this.state.searchQuery) {
        this.setState({ searchQuery: value });
        this.state.searchCallback(value);
      }
    }
  }, {
    key: 'handleClear',
    value: function handleClear() {
      if (this.state.searchQuery) {
        var value = '';
        this.setState({ searchQuery: value });
        this.props.onSearch(value);
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var fieldValue = this.state.searchQuery;

      var inputBoxClassName = __WEBPACK_IMPORTED_MODULE_3_classnames___default()('c-search-box__box', { 'c-search-box__box--searching': fieldValue });

      return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
        'div',
        { className: 'c-search-box__strip' },
        __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
          'div',
          { className: inputBoxClassName },
          __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__components_library_Icon__["a" /* default */], { size: 16, glyph: 'search-sketch', className: 'c-search-box__search-icon' }),
          __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
            __WEBPACK_IMPORTED_MODULE_5__Shortcuts_js__["a" /* default */],
            { name: 'Search', preventDefault: true, handler: this.setFocus.bind(this) },
            __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement('input', {
              className: 'mousetrap',
              ref: function ref(c) {
                _this2.searchInput = c;
              },
              value: fieldValue,
              placeholder: this.props.placeholder,
              onChange: this.handleChange,
              autoComplete: 'off',
              autoCorrect: 'off',
              spellCheck: 'false'
            })
          ),
          fieldValue ? __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__components_library_Icon__["a" /* default */], {
            size: 16, glyph: 'cancel-circle', className: 'c-search-box__clear-button',
            onClick: this.handleClear }) : null
        )
      );
    }
  }]);

  return SearchBox;
}(__WEBPACK_IMPORTED_MODULE_1_react___default.a.Component);




SearchBox.propTypes = {
  searchQuery: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string,
  placeholder: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.string,
  onSearch: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func.isRequired
};

/***/ }),
/* 878 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_flux_actions__ = __webpack_require__(78);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__treeview_TreeView__ = __webpack_require__(879);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__utils_style_data_tree_view_mapper__ = __webpack_require__(941);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__util__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__sketch_create_native_context_menu__ = __webpack_require__(196);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__shared_constants__ = __webpack_require__(41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__shared_constants___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7__shared_constants__);
var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }













var StyleguideTree = (_temp = _class = function (_Component) {
  _inherits(StyleguideTree, _Component);

  function StyleguideTree(props) {
    _classCallCheck(this, StyleguideTree);

    var _this = _possibleConstructorReturn(this, (StyleguideTree.__proto__ || Object.getPrototypeOf(StyleguideTree)).call(this, props));

    _this.onNodeSelected = function (node) {
      if (!node.children) {
        _this.props.actions.selectStyleElement(node.type, node.folderId, node.sectionId, node.id, {
          sectionName: node.sectionName
        });
      } else {
        _this.props.actions.selectStyleElement(node.type, node.folderId, node.sectionId);
      }
    };

    _this.onNodeToggled = function (node) {
      if (node.children) {
        _this.props.actions.toggledStyleNode(node.nodeIdentifier);
      }
    };

    _this.onAddTopLevelFolder = function (name) {
      _this.props.actions.onAddFolder({ name: name, topLevelFolder: true, folderEntityType: 'components' });
    };

    _this.onAddFolder = function (name, parentNode) {
      _this.props.actions.onAddFolder({ name: name, type: parentNode.type, folderId: parentNode.folderId });
    };

    _this.onUpdateNode = function (node, data) {
      var enclosingType = __WEBPACK_IMPORTED_MODULE_5__util__["i" /* enclosingTypeForEntity */](node.type);
      var typeKey = __WEBPACK_IMPORTED_MODULE_5__util__["M" /* typeKeyForEntity */](node.type);

      switch (node.nodeType) {
        case __WEBPACK_IMPORTED_MODULE_7__shared_constants__["treeNodeTypes"].asset:
          _this.props.actions.onUpdateItem({
            type: typeKey,
            enclosingType: enclosingType,
            enclosingID: node.sectionId,
            elementID: node.id,
            data: data
          });
          break;
        case __WEBPACK_IMPORTED_MODULE_7__shared_constants__["treeNodeTypes"].section:
          _this.props.actions.onUpdateItem({ type: enclosingType, elementID: node.sectionId, data: data });
          break;
        case __WEBPACK_IMPORTED_MODULE_7__shared_constants__["treeNodeTypes"].folder:
          _this.props.actions.onUpdateFolder({ _id: node.folderId, folderEntityType: node.type }, data);
          break;
      }
    };

    _this.onBeginEditItem = function (item) {
      _this.props.actions.onBeginEditItem(_extends({
        source: __WEBPACK_IMPORTED_MODULE_7__shared_constants__["editingSources"].styleguideTree
      }, item));
    };

    _this.onNodeMenu = function (event, node) {
      switch (node.nodeType) {
        case __WEBPACK_IMPORTED_MODULE_7__shared_constants__["treeNodeTypes"].folder:
          Object(__WEBPACK_IMPORTED_MODULE_6__sketch_create_native_context_menu__["a" /* onFolderContextMenu */])(__WEBPACK_IMPORTED_MODULE_7__shared_constants__["editingSources"].styleguideTree, event, node.nodeData);
          break;
        case __WEBPACK_IMPORTED_MODULE_7__shared_constants__["treeNodeTypes"].section:
          Object(__WEBPACK_IMPORTED_MODULE_6__sketch_create_native_context_menu__["b" /* onSectionContextMenu */])(__WEBPACK_IMPORTED_MODULE_7__shared_constants__["editingSources"].styleguideTree, node.type, event, node.nodeData);
          break;
        case __WEBPACK_IMPORTED_MODULE_7__shared_constants__["treeNodeTypes"].asset:
          Object(__WEBPACK_IMPORTED_MODULE_6__sketch_create_native_context_menu__["c" /* onStyleElementContextMenu */])(__WEBPACK_IMPORTED_MODULE_7__shared_constants__["editingSources"].styleguideTree, node.type, event, node.nodeData, node.sectionId);
          break;
      }
    };

    return _this;
  }

  _createClass(StyleguideTree, [{
    key: 'getSelectedEntityId',
    value: function getSelectedEntityId() {
      if (this.props.selectedStyleEntity) {
        return this.props.selectedStyleEntity.entityId;
      }

      return null;
    }
  }, {
    key: 'getData',
    value: function getData() {
      var styleData = this.props.styleData;

      var entityId = this.getSelectedEntityId();

      if (this.props.isSearching) {
        return Object(__WEBPACK_IMPORTED_MODULE_4__utils_style_data_tree_view_mapper__["a" /* mapToList */])(styleData, entityId, this.props.allowActiveNode);
      } else {
        return Object(__WEBPACK_IMPORTED_MODULE_4__utils_style_data_tree_view_mapper__["b" /* mapToTree */])(styleData, this.props.selectedType, this.props.selectedFolderId, this.props.selectedSectionId, entityId, this.props.toggledNodes || {}, this.props.allowActiveNode);
      }
    }
  }, {
    key: 'getEditingItemId',
    value: function getEditingItemId() {
      if (this.props.editingSource === __WEBPACK_IMPORTED_MODULE_7__shared_constants__["editingSources"].styleguideTree) {
        return this.props.editingItemID;
      }

      return null;
    }
  }, {
    key: 'render',
    value: function render() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3__treeview_TreeView__["a" /* default */], {
        data: this.getData(),
        onNodeSelected: this.onNodeSelected,
        onNodeToggled: this.onNodeToggled,
        isSearching: this.props.isSearching,
        readOnly: this.props.readOnly,
        onAddNode: this.onAddFolder,
        onAddTopLevelNode: this.onAddTopLevelFolder,
        onAddNodeTriggered: this.props.actions.onAddFolderStart,
        onAddNodeCanceled: this.props.actions.onAddFolderCancel,
        editingItemID: this.getEditingItemId(),
        onBeginEditNode: this.onBeginEditItem,
        onUpdateNode: this.onUpdateNode,
        onNodeMenu: this.onNodeMenu
      });
    }
  }]);

  return StyleguideTree;
}(__WEBPACK_IMPORTED_MODULE_0_react__["Component"]), _class.propTypes = {
  styleData: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object.isRequired,
  selectedType: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
  selectedSectionId: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
  selectedFolderId: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
  selectedStyleEntity: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object,
  isSearching: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
  readOnly: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
  allowActiveNode: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
  toggledNodes: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object,
  editingItemID: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
  editingSource: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string
}, _temp);

/* harmony default export */ __webpack_exports__["a"] = (Object(__WEBPACK_IMPORTED_MODULE_2_flux_actions__["a" /* default */])(StyleguideTree));

/***/ }),
/* 879 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return TreeView; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__components_TreeBeard__ = __webpack_require__(880);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__components_library_Shortcuts__ = __webpack_require__(153);
var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }







var TreeView = function (_React$Component) {
  _inherits(TreeView, _React$Component);

  function TreeView() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, TreeView);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = TreeView.__proto__ || Object.getPrototypeOf(TreeView)).call.apply(_ref, [this].concat(args))), _this), _this.handleShortcuts = function (event, action) {

      if (!_this.props.isSearching) {
        //consider having enabled/disabled state in the shortcuts component
        return;
      }

      switch (action) {
        case 'MOVE_DOWN':
          _this.selectNext(1);
          break;
        case 'MOVE_UP':
          _this.selectNext(-1);
          break;
      }
    }, _this.onSelect = function (node) {
      _this.setState({ cursor: node });
      _this.props.onNodeSelected(node);
    }, _this.onToggle = function (node) {
      if (node.children) {
        _this.props.onNodeToggled(node);
      }
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(TreeView, [{
    key: 'findNextElement',
    value: function findNextElement(requestedStep) {
      var cursor = this.state.cursor;

      if (this.props.data && this.props.data.length > 0) {

        var currentPlace = -1;
        if (cursor) {
          var foundIndex = __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.findIndex(this.props.data, function (node) {
            return node.id == cursor.id;
          });
          if (!__WEBPACK_IMPORTED_MODULE_1_lodash___default.a.isUndefined(foundIndex)) {
            currentPlace = foundIndex;
          }
        }

        var requestedPlace = currentPlace + requestedStep;
        //if it is within valid array boundaries
        if (requestedPlace >= 0 && requestedPlace < this.props.data.length) {
          return this.props.data[requestedPlace];
        }

        return null;
      }

      return null;
    }
  }, {
    key: 'selectNext',
    value: function selectNext(requestedStep) {
      var nextElement = this.findNextElement(requestedStep);
      if (!nextElement) {
        return;
      }
      this.onSelect(nextElement);
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          onNodeSelected = _props.onNodeSelected,
          onNodeToggled = _props.onNodeToggled,
          props = _objectWithoutProperties(_props, ['onNodeSelected', 'onNodeToggled']);

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        __WEBPACK_IMPORTED_MODULE_3__components_library_Shortcuts__["a" /* default */],
        { name: 'TreeNavigation', handler: this.handleShortcuts },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2__components_TreeBeard__["a" /* default */], _extends({}, props, {
          onSelect: this.onSelect,
          onToggle: this.onToggle
        }))
      );
    }
  }]);

  return TreeView;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component);



/***/ }),
/* 880 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__TreeNode__ = __webpack_require__(881);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__themes_default__ = __webpack_require__(939);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__themes_animations__ = __webpack_require__(940);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__AddTreeNode__ = __webpack_require__(274);


var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }









var TreeBeard = function (_React$Component) {
  _inherits(TreeBeard, _React$Component);

  function TreeBeard() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, TreeBeard);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = TreeBeard.__proto__ || Object.getPrototypeOf(TreeBeard)).call.apply(_ref, [this].concat(args))), _this), _this.renderAddTreeNode = function () {
      var _this$props = _this.props,
          onAddTopLevelNode = _this$props.onAddTopLevelNode,
          onAddNodeTriggered = _this$props.onAddNodeTriggered,
          onAddNodeCanceled = _this$props.onAddNodeCanceled,
          readOnly = _this$props.readOnly,
          isSearching = _this$props.isSearching;


      if (isSearching || readOnly) {
        return null;
      }

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_5__AddTreeNode__["a" /* default */], {
        onAddTreeNode: onAddTopLevelNode,
        onSelect: onAddNodeTriggered,
        onCancel: onAddNodeCanceled
      });
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(TreeBeard, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          animations = _props.animations,
          propsData = _props.data,
          onSelect = _props.onSelect,
          onToggle = _props.onToggle,
          onNodeMenu = _props.onNodeMenu,
          onBeginEditNode = _props.onBeginEditNode,
          onUpdateNode = _props.onUpdateNode,
          onAddNode = _props.onAddNode,
          onAddNodeTriggered = _props.onAddNodeTriggered,
          onAddNodeCanceled = _props.onAddNodeCanceled,
          style = _props.style,
          editingItemID = _props.editingItemID,
          readOnly = _props.readOnly;


      var data = propsData;

      // Support Multiple Root Nodes. Its not formally a tree, but its a use-case.
      if (!Array.isArray(data)) {
        data = [data];
      }
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'ul',
        { style: style.tree.base },
        data.map(function (node, index) {
          return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2__TreeNode__["a" /* default */], {
            animations: animations,
            key: node.nodeIdentifier || index,
            node: node,
            onSelect: onSelect,
            onToggle: onToggle,
            onMenu: onNodeMenu,
            style: style.tree.node,
            editingItemID: editingItemID,
            onBeginEdit: onBeginEditNode,
            onUpdate: onUpdateNode,
            readOnly: readOnly,
            onAddNode: onAddNode,
            onAddNodeTriggered: onAddNodeTriggered,
            onAddNodeCanceled: onAddNodeCanceled
          });
        }),
        this.renderAddTreeNode()
      );
    }
  }]);

  return TreeBeard;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component);

TreeBeard.propTypes = {
  style: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object,
  data: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([__WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.array]).isRequired,
  animations: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([__WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool]),
  onSelect: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onToggle: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onNodeMenu: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onAddNode: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onAddTopLevelNode: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onAddNodeTriggered: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onAddNodeCanceled: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  isSearching: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
  readOnly: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
  onBeginEditNode: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onUpdateNode: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  editingItemID: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string
};

TreeBeard.defaultProps = {
  style: __WEBPACK_IMPORTED_MODULE_3__themes_default__["a" /* default */],
  animations: __WEBPACK_IMPORTED_MODULE_4__themes_animations__["a" /* default */]
};

/* harmony default export */ __webpack_exports__["a"] = (TreeBeard);

/***/ }),
/* 881 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__brandai_velocity_react__ = __webpack_require__(273);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__brandai_velocity_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2__brandai_velocity_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__AddTreeNode__ = __webpack_require__(274);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__NodeContainer__ = __webpack_require__(889);


var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }







var TreeNode = function (_React$Component) {
  _inherits(TreeNode, _React$Component);

  function TreeNode() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, TreeNode);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = TreeNode.__proto__ || Object.getPrototypeOf(TreeNode)).call.apply(_ref, [this].concat(args))), _this), _this.onSelect = function () {
      var _this$props = _this.props,
          node = _this$props.node,
          onSelect = _this$props.onSelect;


      if (onSelect) {
        onSelect(node);
      }
    }, _this.onToggle = function () {
      var _this$props2 = _this.props,
          node = _this$props2.node,
          onToggle = _this$props2.onToggle;


      if (onToggle) {
        onToggle(node);
      }
    }, _this.onMenu = function (event) {
      var _this$props3 = _this.props,
          readOnly = _this$props3.readOnly,
          onMenu = _this$props3.onMenu,
          node = _this$props3.node;


      if (!readOnly && onMenu) {
        onMenu(event, node);
      }
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(TreeNode, [{
    key: 'animations',
    value: function animations() {
      var _props = this.props,
          animations = _props.animations,
          node = _props.node;


      if (animations === false) {
        return false;
      }

      var anim = Object.assign({}, animations, node.animations);
      return {
        toggle: anim.toggle(this.props),
        drawer: anim.drawer(this.props)
      };
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var style = this.props.style;

      var animations = this.animations();

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'li',
        {
          ref: function ref(_ref2) {
            return _this2.topLevelRef = _ref2;
          },
          style: style.base },
        this.renderHeader(animations),
        this.renderDrawer(animations)
      );
    }
  }, {
    key: 'renderDrawer',
    value: function renderDrawer(animations) {
      var _this3 = this;

      var toggled = this.props.node.toggled;


      if (!animations && !toggled) {
        return null;
      } else if (!animations && toggled) {
        return this.renderChildren();
      }

      var _animations$drawer = animations.drawer,
          animation = _animations$drawer.animation,
          duration = _animations$drawer.duration,
          restAnimationInfo = _objectWithoutProperties(_animations$drawer, ['animation', 'duration']);

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        __WEBPACK_IMPORTED_MODULE_2__brandai_velocity_react__["VelocityTransitionGroup"],
        _extends({}, restAnimationInfo, {
          ref: function ref(_ref3) {
            return _this3.velocityRef = _ref3;
          } }),
        toggled ? this.renderChildren() : null
      );
    }
  }, {
    key: 'renderHeader',
    value: function renderHeader(animations) {
      var _props2 = this.props,
          node = _props2.node,
          style = _props2.style,
          onBeginEdit = _props2.onBeginEdit,
          onUpdate = _props2.onUpdate,
          editingItemID = _props2.editingItemID,
          readOnly = _props2.readOnly;


      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__NodeContainer__["a" /* default */], {
        animations: animations,
        node: Object.assign({}, node),
        onSelect: this.onSelect,
        onToggle: this.onToggle,
        onMenu: this.onMenu,
        style: style,
        onBeginEdit: onBeginEdit,
        onUpdate: onUpdate,
        editingItemID: editingItemID,
        readOnly: readOnly
      });
    }
  }, {
    key: 'renderChildren',
    value: function renderChildren() {
      var _this4 = this;

      var _props3 = this.props,
          animations = _props3.animations,
          node = _props3.node,
          style = _props3.style,
          editingItemID = _props3.editingItemID,
          readOnly = _props3.readOnly,
          onAddNode = _props3.onAddNode,
          onAddNodeTriggered = _props3.onAddNodeTriggered,
          onAddNodeCanceled = _props3.onAddNodeCanceled;


      var children = node.children;
      if (!Array.isArray(children)) {
        children = children ? [children] : [];
      }

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'ul',
        {
          style: style.subtree,
          ref: function ref(_ref4) {
            return _this4.subtreeRef = _ref4;
          } },
        children.map(function (child, index) {
          return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(TreeNode, _extends({}, _this4._eventBubbles(), {
            animations: animations,
            key: child.nodeIdentifier || index,
            node: child,
            style: style,
            editingItemID: editingItemID,
            readOnly: readOnly
          }));
        }),
        this.renderAddTreeNode()
      );
    }
  }, {
    key: 'renderAddTreeNode',
    value: function renderAddTreeNode() {
      var _props4 = this.props,
          onAddNode = _props4.onAddNode,
          onAddNodeTriggered = _props4.onAddNodeTriggered,
          onAddNodeCanceled = _props4.onAddNodeCanceled,
          readOnly = _props4.readOnly,
          node = _props4.node;


      if (!node.canAddNestedNodes || readOnly) {
        return null;
      }

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3__AddTreeNode__["a" /* default */], {
        onAddTreeNode: function onAddTreeNode(name) {
          return onAddNode(name, node);
        },
        onSelect: onAddNodeTriggered,
        onCancel: onAddNodeCanceled
      });
    }
  }, {
    key: '_eventBubbles',
    value: function _eventBubbles() {
      var _props5 = this.props,
          onSelect = _props5.onSelect,
          onToggle = _props5.onToggle,
          onMenu = _props5.onMenu,
          onUpdate = _props5.onUpdate,
          onBeginEdit = _props5.onBeginEdit;


      return {
        onSelect: onSelect,
        onToggle: onToggle,
        onBeginEdit: onBeginEdit,
        onUpdate: onUpdate,
        onMenu: onMenu
      };
    }
  }]);

  return TreeNode;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component);

TreeNode.propTypes = {
  style: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object.isRequired,
  node: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object.isRequired,
  animations: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([__WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool]).isRequired,
  onSelect: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onToggle: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onMenu: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onBeginEdit: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onUpdate: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  editingItemID: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string,
  readOnly: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
  onAddNode: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onAddNodeTriggered: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onAddNodeCanceled: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func
};

/* harmony default export */ __webpack_exports__["a"] = (TreeNode);

/***/ }),
/* 882 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
  };
}();

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _possibleConstructorReturn(self, call) {
  if (!self) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }return call && ((typeof call === "undefined" ? "undefined" : _typeof(call)) === "object" || typeof call === "function") ? call : self;
}

function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === "undefined" ? "undefined" : _typeof(superClass)));
  }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
}

/*
Copyright (c) 2015 Twitter, Inc. and other contributors

Component to add Velocity animations to one or more children. Wraps a single child without adding
additional DOM nodes.

The API attempts to be as declarative as possible. A single animation property declares what
animation the child should have. If that property changes, this component applies the new animation
to the child on the next tick.

By default, the animation is not run when the component is mounted. Instead, Velocity's "finish"
command is used to jump to the animation's end state. For a component that animates out of and
back in to a default state, this allows the parent to specify the "animate into" animation as
the default, and therefore not have to distinguish between the initial state and the state to
return to after animating away.

Properties:
 animation: Either an animation key or hash defining the animation. See Velocity's documentation
   for what this can be. (It is passed to Velocity exactly.)
 runOnMount: If true, runs the animation even when the component is first mounted.
 targetQuerySelector: By default, this component's single child is animated. If targetQuerySelector
   is provided, it is used to select descendants to apply the animation to. Use with caution, only
   when you're confident that React's reconciliation will preserve these nodes during animation.
   Also note querySelectorAll's silly behavior w.r.t. pruning results when being called on a node.
   A special value of "children" will use the direct children of the node, since there isn't a
   great way to specify that to querySelectorAll.
 interruptBehavior: Sets how the previous animation should behave when the "animation" prop is
   changed before it’s done. Default is "stop", which halts the animation where it is. "finish"
   will jump the animation to its completed appearance. "queue" will run the new animation after
   the previous one has finished.

Unrecognized properties are passed as options to Velocity (e.g. "duration", "delay", "loop").

Methods:
 runAnimation: Triggers the animation immediately. Useful for when you want an animation that
   corresponds to an event but not a particular model state change (e.g. a "bump" when a click
   occurs).
*/

var _ = __webpack_require__(3);

var React = __webpack_require__(0);
var ReactDOM = __webpack_require__(14);
var PropTypes = __webpack_require__(1);
var Velocity = __webpack_require__(154);

var VelocityComponent = function (_React$Component) {
  _inherits(VelocityComponent, _React$Component);

  function VelocityComponent(props) {
    _classCallCheck(this, VelocityComponent);

    var _this = _possibleConstructorReturn(this, (VelocityComponent.__proto__ || Object.getPrototypeOf(VelocityComponent)).call(this, props));

    _this._animationTimeout = null;

    // This public method is kept as self-bound to maintain compatibility with the React.createClass
    // version of the component.
    _this.runAnimation = _this.runAnimation.bind(_this);
    return _this;
  }

  _createClass(VelocityComponent, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      this.runAnimation();

      // Jump to the end so that the component has the visual appearance of the animation having
      // been run to completion.
      if (this.props.runOnMount !== true) {
        this._finishAnimation();
      }
    }
  }, {
    key: 'componentWillUpdate',
    value: function componentWillUpdate(newProps, newState) {
      if (!_.isEqual(newProps.animation, this.props.animation)) {
        if (newProps.interruptBehavior === 'stop') {
          this._stopAnimation();
        } else if (newProps.interruptBehavior === 'finish') {
          this._finishAnimation();
        }

        this._scheduleAnimation();
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      this._stopAnimation();
      this._clearVelocityCache(this._getDOMTarget());

      if (this._animationTimeout) {
        clearTimeout(this._animationTimeout);
      }
    }

    // It's ok to call this externally! By default the animation will be queued up. Pass stop: true in
    // to stop the current animation before running. Pass finish: true to finish the current animation
    // before running.

  }, {
    key: 'runAnimation',
    value: function runAnimation(config) {
      config = config || {};

      this._animationTimeout = null;

      if (this.props.animation == null) {
        return;
      }

      if (config.stop) {
        Velocity(this._getDOMTarget(), 'stop', true);
      } else if (config.finish) {
        Velocity(this._getDOMTarget(), 'finishAll', true);
      }

      // Delegate all props except for the ones that we have specified as our own via propTypes.
      var opts = _.omit(this.props, _.keys(VelocityComponent.propTypes));
      Velocity(this._getDOMTarget(), this.props.animation, opts);
    }

    // We trigger animations on a new tick because of a Velocity bug where adding a
    // multi-step animation from within a complete callback causes the first 2 animations to run
    // simultaneously.

  }, {
    key: '_scheduleAnimation',
    value: function _scheduleAnimation() {
      if (this._animationTimeout) {
        return;
      }

      this._animationTimeout = setTimeout(this.runAnimation, 0);
    }

    // Returns one or more DOM nodes to apply the animation to. This is checked every time we start
    // or stop an animation, which means that if an animation is proceeding but the element is removed
    // from the page, it will run its course rather than ever being stopped. (We go this route
    // because of difficulty in tracking what animations are currently being animated, due to both
    // chained animations and the need to be able to "stop" an animation before it begins.)

  }, {
    key: '_getDOMTarget',
    value: function _getDOMTarget() {
      var node = ReactDOM.findDOMNode(this);

      if (this.props.targetQuerySelector === 'children') {
        return node.children;
      } else if (this.props.targetQuerySelector != null) {
        return node.querySelectorAll(this.props.targetQuerySelector);
      } else {
        return node;
      }
    }
  }, {
    key: '_finishAnimation',
    value: function _finishAnimation() {
      Velocity(this._getDOMTarget(), 'finishAll', true);
    }
  }, {
    key: '_stopAnimation',
    value: function _stopAnimation() {
      Velocity(this._getDOMTarget(), 'stop', true);
    }

    // Velocity keeps extensive caches for all animated elements to minimize layout thrashing.
    // This can cause a serious memory leak, keeping references to unmounted elements as well
    // completion handlers and associated react objects. This crudely clears these references.

  }, {
    key: '_clearVelocityCache',
    value: function _clearVelocityCache(target) {
      if (target.length) {
        _.forEach(target, this._clearVelocityCache);
      } else {
        Velocity.Utilities.removeData(target, ['velocity', 'fxqueue']);
      }
    }

    // This component does not include any DOM footprint of its own, so instead we return our
    // child out of render(). (Render must only return a single element, which restricts us to
    // one child. If you want to animate multiple children, provide your own wrapper element and
    // use the "targetQuerySelector" prop to target its children.)

  }, {
    key: 'render',
    value: function render() {
      return this.props.children;
    }
  }]);

  return VelocityComponent;
}(React.Component);

VelocityComponent.propTypes = {
  animation: PropTypes.any,
  children: PropTypes.element.isRequired,
  runOnMount: PropTypes.bool,
  targetQuerySelector: PropTypes.string,
  interruptBehavior: PropTypes.string
  // Any additional properties will be sent as options to Velocity
};

VelocityComponent.defaultProps = {
  animation: null,
  runOnMount: false,
  targetQuerySelector: null,
  interruptBehavior: 'stop'
};

module.exports = VelocityComponent;

/***/ }),
/* 883 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;/*! VelocityJS.org (1.5.0). (C) 2014 Julian Shapiro. MIT @license: en.wikipedia.org/wiki/MIT_License */

/*************************
 Velocity jQuery Shim
 *************************/

/*! VelocityJS.org jQuery Shim (1.0.1). (C) 2014 The jQuery Foundation. MIT @license: en.wikipedia.org/wiki/MIT_License. */

/* This file contains the jQuery functions that Velocity relies on, thereby removing Velocity's dependency on a full copy of jQuery, and allowing it to work in any environment. */
/* These shimmed functions are only used if jQuery isn't present. If both this shim and jQuery are loaded, Velocity defaults to jQuery proper. */
/* Browser support: Using this shim instead of jQuery proper removes support for IE8. */

(function(window) {
	"use strict";
	/***************
	 Setup
	 ***************/

	/* If jQuery is already loaded, there's no point in loading this shim. */
	if (window.jQuery) {
		return;
	}

	/* jQuery base. */
	var $ = function(selector, context) {
		return new $.fn.init(selector, context);
	};

	/********************
	 Private Methods
	 ********************/

	/* jQuery */
	$.isWindow = function(obj) {
		/* jshint eqeqeq: false */
		return obj && obj === obj.window;
	};

	/* jQuery */
	$.type = function(obj) {
		if (!obj) {
			return obj + "";
		}

		return typeof obj === "object" || typeof obj === "function" ?
				class2type[toString.call(obj)] || "object" :
				typeof obj;
	};

	/* jQuery */
	$.isArray = Array.isArray || function(obj) {
		return $.type(obj) === "array";
	};

	/* jQuery */
	function isArraylike(obj) {
		var length = obj.length,
				type = $.type(obj);

		if (type === "function" || $.isWindow(obj)) {
			return false;
		}

		if (obj.nodeType === 1 && length) {
			return true;
		}

		return type === "array" || length === 0 || typeof length === "number" && length > 0 && (length - 1) in obj;
	}

	/***************
	 $ Methods
	 ***************/

	/* jQuery: Support removed for IE<9. */
	$.isPlainObject = function(obj) {
		var key;

		if (!obj || $.type(obj) !== "object" || obj.nodeType || $.isWindow(obj)) {
			return false;
		}

		try {
			if (obj.constructor &&
					!hasOwn.call(obj, "constructor") &&
					!hasOwn.call(obj.constructor.prototype, "isPrototypeOf")) {
				return false;
			}
		} catch (e) {
			return false;
		}

		for (key in obj) {
		}

		return key === undefined || hasOwn.call(obj, key);
	};

	/* jQuery */
	$.each = function(obj, callback, args) {
		var value,
				i = 0,
				length = obj.length,
				isArray = isArraylike(obj);

		if (args) {
			if (isArray) {
				for (; i < length; i++) {
					value = callback.apply(obj[i], args);

					if (value === false) {
						break;
					}
				}
			} else {
				for (i in obj) {
					if (!obj.hasOwnProperty(i)) {
						continue;
					}
					value = callback.apply(obj[i], args);

					if (value === false) {
						break;
					}
				}
			}

		} else {
			if (isArray) {
				for (; i < length; i++) {
					value = callback.call(obj[i], i, obj[i]);

					if (value === false) {
						break;
					}
				}
			} else {
				for (i in obj) {
					if (!obj.hasOwnProperty(i)) {
						continue;
					}
					value = callback.call(obj[i], i, obj[i]);

					if (value === false) {
						break;
					}
				}
			}
		}

		return obj;
	};

	/* Custom */
	$.data = function(node, key, value) {
		/* $.getData() */
		if (value === undefined) {
			var getId = node[$.expando],
					store = getId && cache[getId];

			if (key === undefined) {
				return store;
			} else if (store) {
				if (key in store) {
					return store[key];
				}
			}
			/* $.setData() */
		} else if (key !== undefined) {
			var setId = node[$.expando] || (node[$.expando] = ++$.uuid);

			cache[setId] = cache[setId] || {};
			cache[setId][key] = value;

			return value;
		}
	};

	/* Custom */
	$.removeData = function(node, keys) {
		var id = node[$.expando],
				store = id && cache[id];

		if (store) {
			// Cleanup the entire store if no keys are provided.
			if (!keys) {
				delete cache[id];
			} else {
				$.each(keys, function(_, key) {
					delete store[key];
				});
			}
		}
	};

	/* jQuery */
	$.extend = function() {
		var src, copyIsArray, copy, name, options, clone,
				target = arguments[0] || {},
				i = 1,
				length = arguments.length,
				deep = false;

		if (typeof target === "boolean") {
			deep = target;

			target = arguments[i] || {};
			i++;
		}

		if (typeof target !== "object" && $.type(target) !== "function") {
			target = {};
		}

		if (i === length) {
			target = this;
			i--;
		}

		for (; i < length; i++) {
			if ((options = arguments[i])) {
				for (name in options) {
					if (!options.hasOwnProperty(name)) {
						continue;
					}
					src = target[name];
					copy = options[name];

					if (target === copy) {
						continue;
					}

					if (deep && copy && ($.isPlainObject(copy) || (copyIsArray = $.isArray(copy)))) {
						if (copyIsArray) {
							copyIsArray = false;
							clone = src && $.isArray(src) ? src : [];

						} else {
							clone = src && $.isPlainObject(src) ? src : {};
						}

						target[name] = $.extend(deep, clone, copy);

					} else if (copy !== undefined) {
						target[name] = copy;
					}
				}
			}
		}

		return target;
	};

	/* jQuery 1.4.3 */
	$.queue = function(elem, type, data) {
		function $makeArray(arr, results) {
			var ret = results || [];

			if (arr) {
				if (isArraylike(Object(arr))) {
					/* $.merge */
					(function(first, second) {
						var len = +second.length,
								j = 0,
								i = first.length;

						while (j < len) {
							first[i++] = second[j++];
						}

						if (len !== len) {
							while (second[j] !== undefined) {
								first[i++] = second[j++];
							}
						}

						first.length = i;

						return first;
					})(ret, typeof arr === "string" ? [arr] : arr);
				} else {
					[].push.call(ret, arr);
				}
			}

			return ret;
		}

		if (!elem) {
			return;
		}

		type = (type || "fx") + "queue";

		var q = $.data(elem, type);

		if (!data) {
			return q || [];
		}

		if (!q || $.isArray(data)) {
			q = $.data(elem, type, $makeArray(data));
		} else {
			q.push(data);
		}

		return q;
	};

	/* jQuery 1.4.3 */
	$.dequeue = function(elems, type) {
		/* Custom: Embed element iteration. */
		$.each(elems.nodeType ? [elems] : elems, function(i, elem) {
			type = type || "fx";

			var queue = $.queue(elem, type),
					fn = queue.shift();

			if (fn === "inprogress") {
				fn = queue.shift();
			}

			if (fn) {
				if (type === "fx") {
					queue.unshift("inprogress");
				}

				fn.call(elem, function() {
					$.dequeue(elem, type);
				});
			}
		});
	};

	/******************
	 $.fn Methods
	 ******************/

	/* jQuery */
	$.fn = $.prototype = {
		init: function(selector) {
			/* Just return the element wrapped inside an array; don't proceed with the actual jQuery node wrapping process. */
			if (selector.nodeType) {
				this[0] = selector;

				return this;
			} else {
				throw new Error("Not a DOM node.");
			}
		},
		offset: function() {
			/* jQuery altered code: Dropped disconnected DOM node checking. */
			var box = this[0].getBoundingClientRect ? this[0].getBoundingClientRect() : {top: 0, left: 0};

			return {
				top: box.top + (window.pageYOffset || document.scrollTop || 0) - (document.clientTop || 0),
				left: box.left + (window.pageXOffset || document.scrollLeft || 0) - (document.clientLeft || 0)
			};
		},
		position: function() {
			/* jQuery */
			function offsetParentFn(elem) {
				var offsetParent = elem.offsetParent;

				while (offsetParent && (offsetParent.nodeName.toLowerCase() !== "html" && offsetParent.style && offsetParent.style.position.toLowerCase() === "static")) {
					offsetParent = offsetParent.offsetParent;
				}

				return offsetParent || document;
			}

			/* Zepto */
			var elem = this[0],
					offsetParent = offsetParentFn(elem),
					offset = this.offset(),
					parentOffset = /^(?:body|html)$/i.test(offsetParent.nodeName) ? {top: 0, left: 0} : $(offsetParent).offset();

			offset.top -= parseFloat(elem.style.marginTop) || 0;
			offset.left -= parseFloat(elem.style.marginLeft) || 0;

			if (offsetParent.style) {
				parentOffset.top += parseFloat(offsetParent.style.borderTopWidth) || 0;
				parentOffset.left += parseFloat(offsetParent.style.borderLeftWidth) || 0;
			}

			return {
				top: offset.top - parentOffset.top,
				left: offset.left - parentOffset.left
			};
		}
	};

	/**********************
	 Private Variables
	 **********************/

	/* For $.data() */
	var cache = {};
	$.expando = "velocity" + (new Date().getTime());
	$.uuid = 0;

	/* For $.queue() */
	var class2type = {},
			hasOwn = class2type.hasOwnProperty,
			toString = class2type.toString;

	var types = "Boolean Number String Function Array Date RegExp Object Error".split(" ");
	for (var i = 0; i < types.length; i++) {
		class2type["[object " + types[i] + "]"] = types[i].toLowerCase();
	}

	/* Makes $(node) possible, without having to call init. */
	$.fn.init.prototype = $.fn;

	/* Globalize Velocity onto the window, and assign its Utilities property. */
	window.Velocity = {Utilities: $};
})(window);

/******************
 Velocity.js
 ******************/

(function(factory) {
	"use strict";
	/* CommonJS module. */
	if (typeof module === "object" && typeof module.exports === "object") {
		module.exports = factory();
		/* AMD module. */
	} else if (true) {
		!(__WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) :
				__WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
		/* Browser globals. */
	} else {
		factory();
	}
}(function() {
	"use strict";
	return function(global, window, document, undefined) {

		/***************
		 Summary
		 ***************/

		/*
		 - CSS: CSS stack that works independently from the rest of Velocity.
		 - animate(): Core animation method that iterates over the targeted elements and queues the incoming call onto each element individually.
		 - Pre-Queueing: Prepare the element for animation by instantiating its data cache and processing the call's options.
		 - Queueing: The logic that runs once the call has reached its point of execution in the element's $.queue() stack.
		 Most logic is placed here to avoid risking it becoming stale (if the element's properties have changed).
		 - Pushing: Consolidation of the tween data followed by its push onto the global in-progress calls container.
		 - tick(): The single requestAnimationFrame loop responsible for tweening all in-progress calls.
		 - completeCall(): Handles the cleanup process for each Velocity call.
		 */

		/*********************
		 Helper Functions
		 *********************/

		/* IE detection. Gist: https://gist.github.com/julianshapiro/9098609 */
		var IE = (function() {
			if (document.documentMode) {
				return document.documentMode;
			} else {
				for (var i = 7; i > 4; i--) {
					var div = document.createElement("div");

					div.innerHTML = "<!--[if IE " + i + "]><span></span><![endif]-->";

					if (div.getElementsByTagName("span").length) {
						div = null;

						return i;
					}
				}
			}

			return undefined;
		})();

		/* rAF shim. Gist: https://gist.github.com/julianshapiro/9497513 */
		var rAFShim = (function() {
			var timeLast = 0;

			return window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || function(callback) {
				var timeCurrent = (new Date()).getTime(),
						timeDelta;

				/* Dynamically set delay on a per-tick basis to match 60fps. */
				/* Technique by Erik Moller. MIT license: https://gist.github.com/paulirish/1579671 */
				timeDelta = Math.max(0, 16 - (timeCurrent - timeLast));
				timeLast = timeCurrent + timeDelta;

				return setTimeout(function() {
					callback(timeCurrent + timeDelta);
				}, timeDelta);
			};
		})();

		var performance = (function() {
			var perf = window.performance || {};

			if (typeof perf.now !== "function") {
				var nowOffset = perf.timing && perf.timing.navigationStart ? perf.timing.navigationStart : (new Date()).getTime();

				perf.now = function() {
					return (new Date()).getTime() - nowOffset;
				};
			}
			return perf;
		})();

		/* Array compacting. Copyright Lo-Dash. MIT License: https://github.com/lodash/lodash/blob/master/LICENSE.txt */
		function compactSparseArray(array) {
			var index = -1,
					length = array ? array.length : 0,
					result = [];

			while (++index < length) {
				var value = array[index];

				if (value) {
					result.push(value);
				}
			}

			return result;
		}

		/**
		 * Shim for "fixing" IE's lack of support (IE < 9) for applying slice
		 * on host objects like NamedNodeMap, NodeList, and HTMLCollection
		 * (technically, since host objects have been implementation-dependent,
		 * at least before ES2015, IE hasn't needed to work this way).
		 * Also works on strings, fixes IE < 9 to allow an explicit undefined
		 * for the 2nd argument (as in Firefox), and prevents errors when
		 * called on other DOM objects.
		 */
		var _slice = (function() {
			var slice = Array.prototype.slice;

			try {
				// Can't be used with DOM elements in IE < 9
				slice.call(document.documentElement);
				return slice;
			} catch (e) { // Fails in IE < 9

				// This will work for genuine arrays, array-like objects, 
				// NamedNodeMap (attributes, entities, notations),
				// NodeList (e.g., getElementsByTagName), HTMLCollection (e.g., childNodes),
				// and will not fail on other DOM objects (as do DOM elements in IE < 9)
				return function(begin, end) {
					var len = this.length;

					if (typeof begin !== "number") {
						begin = 0;
					}
					// IE < 9 gets unhappy with an undefined end argument
					if (typeof end !== "number") {
						end = len;
					}
					// For native Array objects, we use the native slice function
					if (this.slice) {
						return slice.call(this, begin, end);
					}
					// For array like object we handle it ourselves.
					var i,
							cloned = [],
							// Handle negative value for "begin"
							start = (begin >= 0) ? begin : Math.max(0, len + begin),
							// Handle negative value for "end"
							upTo = end < 0 ? len + end : Math.min(end, len),
							// Actual expected size of the slice
							size = upTo - start;

					if (size > 0) {
						cloned = new Array(size);
						if (this.charAt) {
							for (i = 0; i < size; i++) {
								cloned[i] = this.charAt(start + i);
							}
						} else {
							for (i = 0; i < size; i++) {
								cloned[i] = this[start + i];
							}
						}
					}
					return cloned;
				};
			}
		})();

		/* .indexOf doesn't exist in IE<9 */
		var _inArray = (function() {
			if (Array.prototype.includes) {
				return function(arr, val) {
					return arr.includes(val);
				};
			}
			if (Array.prototype.indexOf) {
				return function(arr, val) {
					return arr.indexOf(val) >= 0;
				};
			}
			return function(arr, val) {
				for (var i = 0; i < arr.length; i++) {
					if (arr[i] === val) {
						return true;
					}
				}
				return false;
			};
		});

		function sanitizeElements(elements) {
			/* Unwrap jQuery/Zepto objects. */
			if (Type.isWrapped(elements)) {
				elements = _slice.call(elements);
				/* Wrap a single element in an array so that $.each() can iterate with the element instead of its node's children. */
			} else if (Type.isNode(elements)) {
				elements = [elements];
			}

			return elements;
		}

		var Type = {
			isNumber: function(variable) {
				return (typeof variable === "number");
			},
			isString: function(variable) {
				return (typeof variable === "string");
			},
			isArray: Array.isArray || function(variable) {
				return Object.prototype.toString.call(variable) === "[object Array]";
			},
			isFunction: function(variable) {
				return Object.prototype.toString.call(variable) === "[object Function]";
			},
			isNode: function(variable) {
				return variable && variable.nodeType;
			},
			/* Determine if variable is an array-like wrapped jQuery, Zepto or similar element, or even a NodeList etc. */
			/* NOTE: HTMLFormElements also have a length. */
			isWrapped: function(variable) {
				return variable
						&& variable !== window
						&& Type.isNumber(variable.length)
						&& !Type.isString(variable)
						&& !Type.isFunction(variable)
						&& !Type.isNode(variable)
						&& (variable.length === 0 || Type.isNode(variable[0]));
			},
			isSVG: function(variable) {
				return window.SVGElement && (variable instanceof window.SVGElement);
			},
			isEmptyObject: function(variable) {
				for (var name in variable) {
					if (variable.hasOwnProperty(name)) {
						return false;
					}
				}

				return true;
			}
		};

		/*****************
		 Dependencies
		 *****************/

		var $,
				isJQuery = false;

		if (global.fn && global.fn.jquery) {
			$ = global;
			isJQuery = true;
		} else {
			$ = window.Velocity.Utilities;
		}

		if (IE <= 8 && !isJQuery) {
			throw new Error("Velocity: IE8 and below require jQuery to be loaded before Velocity.");
		} else if (IE <= 7) {
			/* Revert to jQuery's $.animate(), and lose Velocity's extra features. */
			jQuery.fn.velocity = jQuery.fn.animate;

			/* Now that $.fn.velocity is aliased, abort this Velocity declaration. */
			return;
		}

		/*****************
		 Constants
		 *****************/

		var DURATION_DEFAULT = 400,
				EASING_DEFAULT = "swing";

		/*************
		 State
		 *************/

		var Velocity = {
			/* Container for page-wide Velocity state data. */
			State: {
				/* Detect mobile devices to determine if mobileHA should be turned on. */
				isMobile: /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(window.navigator.userAgent),
				/* The mobileHA option's behavior changes on older Android devices (Gingerbread, versions 2.3.3-2.3.7). */
				isAndroid: /Android/i.test(window.navigator.userAgent),
				isGingerbread: /Android 2\.3\.[3-7]/i.test(window.navigator.userAgent),
				isChrome: window.chrome,
				isFirefox: /Firefox/i.test(window.navigator.userAgent),
				/* Create a cached element for re-use when checking for CSS property prefixes. */
				prefixElement: document.createElement("div"),
				/* Cache every prefix match to avoid repeating lookups. */
				prefixMatches: {},
				/* Cache the anchor used for animating window scrolling. */
				scrollAnchor: null,
				/* Cache the browser-specific property names associated with the scroll anchor. */
				scrollPropertyLeft: null,
				scrollPropertyTop: null,
				/* Keep track of whether our RAF tick is running. */
				isTicking: false,
				/* Container for every in-progress call to Velocity. */
				calls: [],
				delayedElements: {
					count: 0
				}
			},
			/* Velocity's custom CSS stack. Made global for unit testing. */
			CSS: {/* Defined below. */},
			/* A shim of the jQuery utility functions used by Velocity -- provided by Velocity's optional jQuery shim. */
			Utilities: $,
			/* Container for the user's custom animation redirects that are referenced by name in place of the properties map argument. */
			Redirects: {/* Manually registered by the user. */},
			Easings: {/* Defined below. */},
			/* Attempt to use ES6 Promises by default. Users can override this with a third-party promises library. */
			Promise: window.Promise,
			/* Velocity option defaults, which can be overriden by the user. */
			defaults: {
				queue: "",
				duration: DURATION_DEFAULT,
				easing: EASING_DEFAULT,
				begin: undefined,
				complete: undefined,
				progress: undefined,
				display: undefined,
				visibility: undefined,
				loop: false,
				delay: false,
				mobileHA: true,
				/* Advanced: Set to false to prevent property values from being cached between consecutive Velocity-initiated chain calls. */
				_cacheValues: true,
				/* Advanced: Set to false if the promise should always resolve on empty element lists. */
				promiseRejectEmpty: true
			},
			/* A design goal of Velocity is to cache data wherever possible in order to avoid DOM requerying. Accordingly, each element has a data cache. */
			init: function(element) {
				$.data(element, "velocity", {
					/* Store whether this is an SVG element, since its properties are retrieved and updated differently than standard HTML elements. */
					isSVG: Type.isSVG(element),
					/* Keep track of whether the element is currently being animated by Velocity.
					 This is used to ensure that property values are not transferred between non-consecutive (stale) calls. */
					isAnimating: false,
					/* A reference to the element's live computedStyle object. Learn more here: https://developer.mozilla.org/en/docs/Web/API/window.getComputedStyle */
					computedStyle: null,
					/* Tween data is cached for each animation on the element so that data can be passed across calls --
					 in particular, end values are used as subsequent start values in consecutive Velocity calls. */
					tweensContainer: null,
					/* The full root property values of each CSS hook being animated on this element are cached so that:
					 1) Concurrently-animating hooks sharing the same root can have their root values' merged into one while tweening.
					 2) Post-hook-injection root values can be transferred over to consecutively chained Velocity calls as starting root values. */
					rootPropertyValueCache: {},
					/* A cache for transform updates, which must be manually flushed via CSS.flushTransformCache(). */
					transformCache: {}
				});
			},
			/* A parallel to jQuery's $.css(), used for getting/setting Velocity's hooked CSS properties. */
			hook: null, /* Defined below. */
			/* Velocity-wide animation time remapping for testing purposes. */
			mock: false,
			version: {major: 1, minor: 5, patch: 1},
			/* Set to 1 or 2 (most verbose) to output debug info to console. */
			debug: false,
			/* Use rAF high resolution timestamp when available */
			timestamp: true,
			/* Pause all animations */
			pauseAll: function(queueName) {
				var currentTime = (new Date()).getTime();

				$.each(Velocity.State.calls, function(i, activeCall) {

					if (activeCall) {

						/* If we have a queueName and this call is not on that queue, skip */
						if (queueName !== undefined && ((activeCall[2].queue !== queueName) || (activeCall[2].queue === false))) {
							return true;
						}

						/* Set call to paused */
						activeCall[5] = {
							resume: false
						};
					}
				});

				/* Pause timers on any currently delayed calls */
				$.each(Velocity.State.delayedElements, function(k, element) {
					if (!element) {
						return;
					}
					pauseDelayOnElement(element, currentTime);
				});
			},
			/* Resume all animations */
			resumeAll: function(queueName) {
				var currentTime = (new Date()).getTime();

				$.each(Velocity.State.calls, function(i, activeCall) {

					if (activeCall) {

						/* If we have a queueName and this call is not on that queue, skip */
						if (queueName !== undefined && ((activeCall[2].queue !== queueName) || (activeCall[2].queue === false))) {
							return true;
						}

						/* Set call to resumed if it was paused */
						if (activeCall[5]) {
							activeCall[5].resume = true;
						}
					}
				});
				/* Resume timers on any currently delayed calls */
				$.each(Velocity.State.delayedElements, function(k, element) {
					if (!element) {
						return;
					}
					resumeDelayOnElement(element, currentTime);
				});
			}
		};

		/* Retrieve the appropriate scroll anchor and property name for the browser: https://developer.mozilla.org/en-US/docs/Web/API/Window.scrollY */
		if (window.pageYOffset !== undefined) {
			Velocity.State.scrollAnchor = window;
			Velocity.State.scrollPropertyLeft = "pageXOffset";
			Velocity.State.scrollPropertyTop = "pageYOffset";
		} else {
			Velocity.State.scrollAnchor = document.documentElement || document.body.parentNode || document.body;
			Velocity.State.scrollPropertyLeft = "scrollLeft";
			Velocity.State.scrollPropertyTop = "scrollTop";
		}

		/* Shorthand alias for jQuery's $.data() utility. */
		function Data(element) {
			/* Hardcode a reference to the plugin name. */
			var response = $.data(element, "velocity");

			/* jQuery <=1.4.2 returns null instead of undefined when no match is found. We normalize this behavior. */
			return response === null ? undefined : response;
		}

		/**************
		 Delay Timer
		 **************/

		function pauseDelayOnElement(element, currentTime) {
			/* Check for any delay timers, and pause the set timeouts (while preserving time data)
			 to be resumed when the "resume" command is issued */
			var data = Data(element);
			if (data && data.delayTimer && !data.delayPaused) {
				data.delayRemaining = data.delay - currentTime + data.delayBegin;
				data.delayPaused = true;
				clearTimeout(data.delayTimer.setTimeout);
			}
		}

		function resumeDelayOnElement(element, currentTime) {
			/* Check for any paused timers and resume */
			var data = Data(element);
			if (data && data.delayTimer && data.delayPaused) {
				/* If the element was mid-delay, re initiate the timeout with the remaining delay */
				data.delayPaused = false;
				data.delayTimer.setTimeout = setTimeout(data.delayTimer.next, data.delayRemaining);
			}
		}



		/**************
		 Easing
		 **************/

		/* Step easing generator. */
		function generateStep(steps) {
			return function(p) {
				return Math.round(p * steps) * (1 / steps);
			};
		}

		/* Bezier curve function generator. Copyright Gaetan Renaudeau. MIT License: http://en.wikipedia.org/wiki/MIT_License */
		function generateBezier(mX1, mY1, mX2, mY2) {
			var NEWTON_ITERATIONS = 4,
					NEWTON_MIN_SLOPE = 0.001,
					SUBDIVISION_PRECISION = 0.0000001,
					SUBDIVISION_MAX_ITERATIONS = 10,
					kSplineTableSize = 11,
					kSampleStepSize = 1.0 / (kSplineTableSize - 1.0),
					float32ArraySupported = "Float32Array" in window;

			/* Must contain four arguments. */
			if (arguments.length !== 4) {
				return false;
			}

			/* Arguments must be numbers. */
			for (var i = 0; i < 4; ++i) {
				if (typeof arguments[i] !== "number" || isNaN(arguments[i]) || !isFinite(arguments[i])) {
					return false;
				}
			}

			/* X values must be in the [0, 1] range. */
			mX1 = Math.min(mX1, 1);
			mX2 = Math.min(mX2, 1);
			mX1 = Math.max(mX1, 0);
			mX2 = Math.max(mX2, 0);

			var mSampleValues = float32ArraySupported ? new Float32Array(kSplineTableSize) : new Array(kSplineTableSize);

			function A(aA1, aA2) {
				return 1.0 - 3.0 * aA2 + 3.0 * aA1;
			}
			function B(aA1, aA2) {
				return 3.0 * aA2 - 6.0 * aA1;
			}
			function C(aA1) {
				return 3.0 * aA1;
			}

			function calcBezier(aT, aA1, aA2) {
				return ((A(aA1, aA2) * aT + B(aA1, aA2)) * aT + C(aA1)) * aT;
			}

			function getSlope(aT, aA1, aA2) {
				return 3.0 * A(aA1, aA2) * aT * aT + 2.0 * B(aA1, aA2) * aT + C(aA1);
			}

			function newtonRaphsonIterate(aX, aGuessT) {
				for (var i = 0; i < NEWTON_ITERATIONS; ++i) {
					var currentSlope = getSlope(aGuessT, mX1, mX2);

					if (currentSlope === 0.0) {
						return aGuessT;
					}

					var currentX = calcBezier(aGuessT, mX1, mX2) - aX;
					aGuessT -= currentX / currentSlope;
				}

				return aGuessT;
			}

			function calcSampleValues() {
				for (var i = 0; i < kSplineTableSize; ++i) {
					mSampleValues[i] = calcBezier(i * kSampleStepSize, mX1, mX2);
				}
			}

			function binarySubdivide(aX, aA, aB) {
				var currentX, currentT, i = 0;

				do {
					currentT = aA + (aB - aA) / 2.0;
					currentX = calcBezier(currentT, mX1, mX2) - aX;
					if (currentX > 0.0) {
						aB = currentT;
					} else {
						aA = currentT;
					}
				} while (Math.abs(currentX) > SUBDIVISION_PRECISION && ++i < SUBDIVISION_MAX_ITERATIONS);

				return currentT;
			}

			function getTForX(aX) {
				var intervalStart = 0.0,
						currentSample = 1,
						lastSample = kSplineTableSize - 1;

				for (; currentSample !== lastSample && mSampleValues[currentSample] <= aX; ++currentSample) {
					intervalStart += kSampleStepSize;
				}

				--currentSample;

				var dist = (aX - mSampleValues[currentSample]) / (mSampleValues[currentSample + 1] - mSampleValues[currentSample]),
						guessForT = intervalStart + dist * kSampleStepSize,
						initialSlope = getSlope(guessForT, mX1, mX2);

				if (initialSlope >= NEWTON_MIN_SLOPE) {
					return newtonRaphsonIterate(aX, guessForT);
				} else if (initialSlope === 0.0) {
					return guessForT;
				} else {
					return binarySubdivide(aX, intervalStart, intervalStart + kSampleStepSize);
				}
			}

			var _precomputed = false;

			function precompute() {
				_precomputed = true;
				if (mX1 !== mY1 || mX2 !== mY2) {
					calcSampleValues();
				}
			}

			var f = function(aX) {
				if (!_precomputed) {
					precompute();
				}
				if (mX1 === mY1 && mX2 === mY2) {
					return aX;
				}
				if (aX === 0) {
					return 0;
				}
				if (aX === 1) {
					return 1;
				}

				return calcBezier(getTForX(aX), mY1, mY2);
			};

			f.getControlPoints = function() {
				return [{x: mX1, y: mY1}, {x: mX2, y: mY2}];
			};

			var str = "generateBezier(" + [mX1, mY1, mX2, mY2] + ")";
			f.toString = function() {
				return str;
			};

			return f;
		}

		/* Runge-Kutta spring physics function generator. Adapted from Framer.js, copyright Koen Bok. MIT License: http://en.wikipedia.org/wiki/MIT_License */
		/* Given a tension, friction, and duration, a simulation at 60FPS will first run without a defined duration in order to calculate the full path. A second pass
		 then adjusts the time delta -- using the relation between actual time and duration -- to calculate the path for the duration-constrained animation. */
		var generateSpringRK4 = (function() {
			function springAccelerationForState(state) {
				return (-state.tension * state.x) - (state.friction * state.v);
			}

			function springEvaluateStateWithDerivative(initialState, dt, derivative) {
				var state = {
					x: initialState.x + derivative.dx * dt,
					v: initialState.v + derivative.dv * dt,
					tension: initialState.tension,
					friction: initialState.friction
				};

				return {dx: state.v, dv: springAccelerationForState(state)};
			}

			function springIntegrateState(state, dt) {
				var a = {
					dx: state.v,
					dv: springAccelerationForState(state)
				},
						b = springEvaluateStateWithDerivative(state, dt * 0.5, a),
						c = springEvaluateStateWithDerivative(state, dt * 0.5, b),
						d = springEvaluateStateWithDerivative(state, dt, c),
						dxdt = 1.0 / 6.0 * (a.dx + 2.0 * (b.dx + c.dx) + d.dx),
						dvdt = 1.0 / 6.0 * (a.dv + 2.0 * (b.dv + c.dv) + d.dv);

				state.x = state.x + dxdt * dt;
				state.v = state.v + dvdt * dt;

				return state;
			}

			return function springRK4Factory(tension, friction, duration) {

				var initState = {
					x: -1,
					v: 0,
					tension: null,
					friction: null
				},
						path = [0],
						time_lapsed = 0,
						tolerance = 1 / 10000,
						DT = 16 / 1000,
						have_duration, dt, last_state;

				tension = parseFloat(tension) || 500;
				friction = parseFloat(friction) || 20;
				duration = duration || null;

				initState.tension = tension;
				initState.friction = friction;

				have_duration = duration !== null;

				/* Calculate the actual time it takes for this animation to complete with the provided conditions. */
				if (have_duration) {
					/* Run the simulation without a duration. */
					time_lapsed = springRK4Factory(tension, friction);
					/* Compute the adjusted time delta. */
					dt = time_lapsed / duration * DT;
				} else {
					dt = DT;
				}

				while (true) {
					/* Next/step function .*/
					last_state = springIntegrateState(last_state || initState, dt);
					/* Store the position. */
					path.push(1 + last_state.x);
					time_lapsed += 16;
					/* If the change threshold is reached, break. */
					if (!(Math.abs(last_state.x) > tolerance && Math.abs(last_state.v) > tolerance)) {
						break;
					}
				}

				/* If duration is not defined, return the actual time required for completing this animation. Otherwise, return a closure that holds the
				 computed path and returns a snapshot of the position according to a given percentComplete. */
				return !have_duration ? time_lapsed : function(percentComplete) {
					return path[ (percentComplete * (path.length - 1)) | 0 ];
				};
			};
		}());

		/* jQuery easings. */
		Velocity.Easings = {
			linear: function(p) {
				return p;
			},
			swing: function(p) {
				return 0.5 - Math.cos(p * Math.PI) / 2;
			},
			/* Bonus "spring" easing, which is a less exaggerated version of easeInOutElastic. */
			spring: function(p) {
				return 1 - (Math.cos(p * 4.5 * Math.PI) * Math.exp(-p * 6));
			}
		};

		/* CSS3 and Robert Penner easings. */
		$.each(
				[
					["ease", [0.25, 0.1, 0.25, 1.0]],
					["ease-in", [0.42, 0.0, 1.00, 1.0]],
					["ease-out", [0.00, 0.0, 0.58, 1.0]],
					["ease-in-out", [0.42, 0.0, 0.58, 1.0]],
					["easeInSine", [0.47, 0, 0.745, 0.715]],
					["easeOutSine", [0.39, 0.575, 0.565, 1]],
					["easeInOutSine", [0.445, 0.05, 0.55, 0.95]],
					["easeInQuad", [0.55, 0.085, 0.68, 0.53]],
					["easeOutQuad", [0.25, 0.46, 0.45, 0.94]],
					["easeInOutQuad", [0.455, 0.03, 0.515, 0.955]],
					["easeInCubic", [0.55, 0.055, 0.675, 0.19]],
					["easeOutCubic", [0.215, 0.61, 0.355, 1]],
					["easeInOutCubic", [0.645, 0.045, 0.355, 1]],
					["easeInQuart", [0.895, 0.03, 0.685, 0.22]],
					["easeOutQuart", [0.165, 0.84, 0.44, 1]],
					["easeInOutQuart", [0.77, 0, 0.175, 1]],
					["easeInQuint", [0.755, 0.05, 0.855, 0.06]],
					["easeOutQuint", [0.23, 1, 0.32, 1]],
					["easeInOutQuint", [0.86, 0, 0.07, 1]],
					["easeInExpo", [0.95, 0.05, 0.795, 0.035]],
					["easeOutExpo", [0.19, 1, 0.22, 1]],
					["easeInOutExpo", [1, 0, 0, 1]],
					["easeInCirc", [0.6, 0.04, 0.98, 0.335]],
					["easeOutCirc", [0.075, 0.82, 0.165, 1]],
					["easeInOutCirc", [0.785, 0.135, 0.15, 0.86]]
				], function(i, easingArray) {
			Velocity.Easings[easingArray[0]] = generateBezier.apply(null, easingArray[1]);
		});

		/* Determine the appropriate easing type given an easing input. */
		function getEasing(value, duration) {
			var easing = value;

			/* The easing option can either be a string that references a pre-registered easing,
			 or it can be a two-/four-item array of integers to be converted into a bezier/spring function. */
			if (Type.isString(value)) {
				/* Ensure that the easing has been assigned to jQuery's Velocity.Easings object. */
				if (!Velocity.Easings[value]) {
					easing = false;
				}
			} else if (Type.isArray(value) && value.length === 1) {
				easing = generateStep.apply(null, value);
			} else if (Type.isArray(value) && value.length === 2) {
				/* springRK4 must be passed the animation's duration. */
				/* Note: If the springRK4 array contains non-numbers, generateSpringRK4() returns an easing
				 function generated with default tension and friction values. */
				easing = generateSpringRK4.apply(null, value.concat([duration]));
			} else if (Type.isArray(value) && value.length === 4) {
				/* Note: If the bezier array contains non-numbers, generateBezier() returns false. */
				easing = generateBezier.apply(null, value);
			} else {
				easing = false;
			}

			/* Revert to the Velocity-wide default easing type, or fall back to "swing" (which is also jQuery's default)
			 if the Velocity-wide default has been incorrectly modified. */
			if (easing === false) {
				if (Velocity.Easings[Velocity.defaults.easing]) {
					easing = Velocity.defaults.easing;
				} else {
					easing = EASING_DEFAULT;
				}
			}

			return easing;
		}

		/*****************
		 CSS Stack
		 *****************/

		/* The CSS object is a highly condensed and performant CSS stack that fully replaces jQuery's.
		 It handles the validation, getting, and setting of both standard CSS properties and CSS property hooks. */
		/* Note: A "CSS" shorthand is aliased so that our code is easier to read. */
		var CSS = Velocity.CSS = {
			/*************
			 RegEx
			 *************/

			RegEx: {
				isHex: /^#([A-f\d]{3}){1,2}$/i,
				/* Unwrap a property value's surrounding text, e.g. "rgba(4, 3, 2, 1)" ==> "4, 3, 2, 1" and "rect(4px 3px 2px 1px)" ==> "4px 3px 2px 1px". */
				valueUnwrap: /^[A-z]+\((.*)\)$/i,
				wrappedValueAlreadyExtracted: /[0-9.]+ [0-9.]+ [0-9.]+( [0-9.]+)?/,
				/* Split a multi-value property into an array of subvalues, e.g. "rgba(4, 3, 2, 1) 4px 3px 2px 1px" ==> [ "rgba(4, 3, 2, 1)", "4px", "3px", "2px", "1px" ]. */
				valueSplit: /([A-z]+\(.+\))|(([A-z0-9#-.]+?)(?=\s|$))/ig
			},
			/************
			 Lists
			 ************/

			Lists: {
				colors: ["fill", "stroke", "stopColor", "color", "backgroundColor", "borderColor", "borderTopColor", "borderRightColor", "borderBottomColor", "borderLeftColor", "outlineColor"],
				transformsBase: ["translateX", "translateY", "scale", "scaleX", "scaleY", "skewX", "skewY", "rotateZ"],
				transforms3D: ["transformPerspective", "translateZ", "scaleZ", "rotateX", "rotateY"],
				units: [
					"%", // relative
					"em", "ex", "ch", "rem", // font relative
					"vw", "vh", "vmin", "vmax", // viewport relative
					"cm", "mm", "Q", "in", "pc", "pt", "px", // absolute lengths
					"deg", "grad", "rad", "turn", // angles
					"s", "ms" // time
				],
				colorNames: {
					"aliceblue": "240,248,255",
					"antiquewhite": "250,235,215",
					"aquamarine": "127,255,212",
					"aqua": "0,255,255",
					"azure": "240,255,255",
					"beige": "245,245,220",
					"bisque": "255,228,196",
					"black": "0,0,0",
					"blanchedalmond": "255,235,205",
					"blueviolet": "138,43,226",
					"blue": "0,0,255",
					"brown": "165,42,42",
					"burlywood": "222,184,135",
					"cadetblue": "95,158,160",
					"chartreuse": "127,255,0",
					"chocolate": "210,105,30",
					"coral": "255,127,80",
					"cornflowerblue": "100,149,237",
					"cornsilk": "255,248,220",
					"crimson": "220,20,60",
					"cyan": "0,255,255",
					"darkblue": "0,0,139",
					"darkcyan": "0,139,139",
					"darkgoldenrod": "184,134,11",
					"darkgray": "169,169,169",
					"darkgrey": "169,169,169",
					"darkgreen": "0,100,0",
					"darkkhaki": "189,183,107",
					"darkmagenta": "139,0,139",
					"darkolivegreen": "85,107,47",
					"darkorange": "255,140,0",
					"darkorchid": "153,50,204",
					"darkred": "139,0,0",
					"darksalmon": "233,150,122",
					"darkseagreen": "143,188,143",
					"darkslateblue": "72,61,139",
					"darkslategray": "47,79,79",
					"darkturquoise": "0,206,209",
					"darkviolet": "148,0,211",
					"deeppink": "255,20,147",
					"deepskyblue": "0,191,255",
					"dimgray": "105,105,105",
					"dimgrey": "105,105,105",
					"dodgerblue": "30,144,255",
					"firebrick": "178,34,34",
					"floralwhite": "255,250,240",
					"forestgreen": "34,139,34",
					"fuchsia": "255,0,255",
					"gainsboro": "220,220,220",
					"ghostwhite": "248,248,255",
					"gold": "255,215,0",
					"goldenrod": "218,165,32",
					"gray": "128,128,128",
					"grey": "128,128,128",
					"greenyellow": "173,255,47",
					"green": "0,128,0",
					"honeydew": "240,255,240",
					"hotpink": "255,105,180",
					"indianred": "205,92,92",
					"indigo": "75,0,130",
					"ivory": "255,255,240",
					"khaki": "240,230,140",
					"lavenderblush": "255,240,245",
					"lavender": "230,230,250",
					"lawngreen": "124,252,0",
					"lemonchiffon": "255,250,205",
					"lightblue": "173,216,230",
					"lightcoral": "240,128,128",
					"lightcyan": "224,255,255",
					"lightgoldenrodyellow": "250,250,210",
					"lightgray": "211,211,211",
					"lightgrey": "211,211,211",
					"lightgreen": "144,238,144",
					"lightpink": "255,182,193",
					"lightsalmon": "255,160,122",
					"lightseagreen": "32,178,170",
					"lightskyblue": "135,206,250",
					"lightslategray": "119,136,153",
					"lightsteelblue": "176,196,222",
					"lightyellow": "255,255,224",
					"limegreen": "50,205,50",
					"lime": "0,255,0",
					"linen": "250,240,230",
					"magenta": "255,0,255",
					"maroon": "128,0,0",
					"mediumaquamarine": "102,205,170",
					"mediumblue": "0,0,205",
					"mediumorchid": "186,85,211",
					"mediumpurple": "147,112,219",
					"mediumseagreen": "60,179,113",
					"mediumslateblue": "123,104,238",
					"mediumspringgreen": "0,250,154",
					"mediumturquoise": "72,209,204",
					"mediumvioletred": "199,21,133",
					"midnightblue": "25,25,112",
					"mintcream": "245,255,250",
					"mistyrose": "255,228,225",
					"moccasin": "255,228,181",
					"navajowhite": "255,222,173",
					"navy": "0,0,128",
					"oldlace": "253,245,230",
					"olivedrab": "107,142,35",
					"olive": "128,128,0",
					"orangered": "255,69,0",
					"orange": "255,165,0",
					"orchid": "218,112,214",
					"palegoldenrod": "238,232,170",
					"palegreen": "152,251,152",
					"paleturquoise": "175,238,238",
					"palevioletred": "219,112,147",
					"papayawhip": "255,239,213",
					"peachpuff": "255,218,185",
					"peru": "205,133,63",
					"pink": "255,192,203",
					"plum": "221,160,221",
					"powderblue": "176,224,230",
					"purple": "128,0,128",
					"red": "255,0,0",
					"rosybrown": "188,143,143",
					"royalblue": "65,105,225",
					"saddlebrown": "139,69,19",
					"salmon": "250,128,114",
					"sandybrown": "244,164,96",
					"seagreen": "46,139,87",
					"seashell": "255,245,238",
					"sienna": "160,82,45",
					"silver": "192,192,192",
					"skyblue": "135,206,235",
					"slateblue": "106,90,205",
					"slategray": "112,128,144",
					"snow": "255,250,250",
					"springgreen": "0,255,127",
					"steelblue": "70,130,180",
					"tan": "210,180,140",
					"teal": "0,128,128",
					"thistle": "216,191,216",
					"tomato": "255,99,71",
					"turquoise": "64,224,208",
					"violet": "238,130,238",
					"wheat": "245,222,179",
					"whitesmoke": "245,245,245",
					"white": "255,255,255",
					"yellowgreen": "154,205,50",
					"yellow": "255,255,0"
				}
			},
			/************
			 Hooks
			 ************/

			/* Hooks allow a subproperty (e.g. "boxShadowBlur") of a compound-value CSS property
			 (e.g. "boxShadow: X Y Blur Spread Color") to be animated as if it were a discrete property. */
			/* Note: Beyond enabling fine-grained property animation, hooking is necessary since Velocity only
			 tweens properties with single numeric values; unlike CSS transitions, Velocity does not interpolate compound-values. */
			Hooks: {
				/********************
				 Registration
				 ********************/

				/* Templates are a concise way of indicating which subproperties must be individually registered for each compound-value CSS property. */
				/* Each template consists of the compound-value's base name, its constituent subproperty names, and those subproperties' default values. */
				templates: {
					"textShadow": ["Color X Y Blur", "black 0px 0px 0px"],
					"boxShadow": ["Color X Y Blur Spread", "black 0px 0px 0px 0px"],
					"clip": ["Top Right Bottom Left", "0px 0px 0px 0px"],
					"backgroundPosition": ["X Y", "0% 0%"],
					"transformOrigin": ["X Y Z", "50% 50% 0px"],
					"perspectiveOrigin": ["X Y", "50% 50%"]
				},
				/* A "registered" hook is one that has been converted from its template form into a live,
				 tweenable property. It contains data to associate it with its root property. */
				registered: {
					/* Note: A registered hook looks like this ==> textShadowBlur: [ "textShadow", 3 ],
					 which consists of the subproperty's name, the associated root property's name,
					 and the subproperty's position in the root's value. */
				},
				/* Convert the templates into individual hooks then append them to the registered object above. */
				register: function() {
					/* Color hooks registration: Colors are defaulted to white -- as opposed to black -- since colors that are
					 currently set to "transparent" default to their respective template below when color-animated,
					 and white is typically a closer match to transparent than black is. An exception is made for text ("color"),
					 which is almost always set closer to black than white. */
					for (var i = 0; i < CSS.Lists.colors.length; i++) {
						var rgbComponents = (CSS.Lists.colors[i] === "color") ? "0 0 0 1" : "255 255 255 1";
						CSS.Hooks.templates[CSS.Lists.colors[i]] = ["Red Green Blue Alpha", rgbComponents];
					}

					var rootProperty,
							hookTemplate,
							hookNames;

					/* In IE, color values inside compound-value properties are positioned at the end the value instead of at the beginning.
					 Thus, we re-arrange the templates accordingly. */
					if (IE) {
						for (rootProperty in CSS.Hooks.templates) {
							if (!CSS.Hooks.templates.hasOwnProperty(rootProperty)) {
								continue;
							}
							hookTemplate = CSS.Hooks.templates[rootProperty];
							hookNames = hookTemplate[0].split(" ");

							var defaultValues = hookTemplate[1].match(CSS.RegEx.valueSplit);

							if (hookNames[0] === "Color") {
								/* Reposition both the hook's name and its default value to the end of their respective strings. */
								hookNames.push(hookNames.shift());
								defaultValues.push(defaultValues.shift());

								/* Replace the existing template for the hook's root property. */
								CSS.Hooks.templates[rootProperty] = [hookNames.join(" "), defaultValues.join(" ")];
							}
						}
					}

					/* Hook registration. */
					for (rootProperty in CSS.Hooks.templates) {
						if (!CSS.Hooks.templates.hasOwnProperty(rootProperty)) {
							continue;
						}
						hookTemplate = CSS.Hooks.templates[rootProperty];
						hookNames = hookTemplate[0].split(" ");

						for (var j in hookNames) {
							if (!hookNames.hasOwnProperty(j)) {
								continue;
							}
							var fullHookName = rootProperty + hookNames[j],
									hookPosition = j;

							/* For each hook, register its full name (e.g. textShadowBlur) with its root property (e.g. textShadow)
							 and the hook's position in its template's default value string. */
							CSS.Hooks.registered[fullHookName] = [rootProperty, hookPosition];
						}
					}
				},
				/*****************************
				 Injection and Extraction
				 *****************************/

				/* Look up the root property associated with the hook (e.g. return "textShadow" for "textShadowBlur"). */
				/* Since a hook cannot be set directly (the browser won't recognize it), style updating for hooks is routed through the hook's root property. */
				getRoot: function(property) {
					var hookData = CSS.Hooks.registered[property];

					if (hookData) {
						return hookData[0];
					} else {
						/* If there was no hook match, return the property name untouched. */
						return property;
					}
				},
				getUnit: function(str, start) {
					var unit = (str.substr(start || 0, 5).match(/^[a-z%]+/) || [])[0] || "";

					if (unit && _inArray(CSS.Lists.units, unit)) {
						return unit;
					}
					return "";
				},
				fixColors: function(str) {
					return str.replace(/(rgba?\(\s*)?(\b[a-z]+\b)/g, function($0, $1, $2) {
						if (CSS.Lists.colorNames.hasOwnProperty($2)) {
							return ($1 ? $1 : "rgba(") + CSS.Lists.colorNames[$2] + ($1 ? "" : ",1)");
						}
						return $1 + $2;
					});
				},
				/* Convert any rootPropertyValue, null or otherwise, into a space-delimited list of hook values so that
				 the targeted hook can be injected or extracted at its standard position. */
				cleanRootPropertyValue: function(rootProperty, rootPropertyValue) {
					/* If the rootPropertyValue is wrapped with "rgb()", "clip()", etc., remove the wrapping to normalize the value before manipulation. */
					if (CSS.RegEx.valueUnwrap.test(rootPropertyValue)) {
						rootPropertyValue = rootPropertyValue.match(CSS.RegEx.valueUnwrap)[1];
					}

					/* If rootPropertyValue is a CSS null-value (from which there's inherently no hook value to extract),
					 default to the root's default value as defined in CSS.Hooks.templates. */
					/* Note: CSS null-values include "none", "auto", and "transparent". They must be converted into their
					 zero-values (e.g. textShadow: "none" ==> textShadow: "0px 0px 0px black") for hook manipulation to proceed. */
					if (CSS.Values.isCSSNullValue(rootPropertyValue)) {
						rootPropertyValue = CSS.Hooks.templates[rootProperty][1];
					}

					return rootPropertyValue;
				},
				/* Extracted the hook's value from its root property's value. This is used to get the starting value of an animating hook. */
				extractValue: function(fullHookName, rootPropertyValue) {
					var hookData = CSS.Hooks.registered[fullHookName];

					if (hookData) {
						var hookRoot = hookData[0],
								hookPosition = hookData[1];

						rootPropertyValue = CSS.Hooks.cleanRootPropertyValue(hookRoot, rootPropertyValue);

						/* Split rootPropertyValue into its constituent hook values then grab the desired hook at its standard position. */
						return rootPropertyValue.toString().match(CSS.RegEx.valueSplit)[hookPosition];
					} else {
						/* If the provided fullHookName isn't a registered hook, return the rootPropertyValue that was passed in. */
						return rootPropertyValue;
					}
				},
				/* Inject the hook's value into its root property's value. This is used to piece back together the root property
				 once Velocity has updated one of its individually hooked values through tweening. */
				injectValue: function(fullHookName, hookValue, rootPropertyValue) {
					var hookData = CSS.Hooks.registered[fullHookName];

					if (hookData) {
						var hookRoot = hookData[0],
								hookPosition = hookData[1],
								rootPropertyValueParts,
								rootPropertyValueUpdated;

						rootPropertyValue = CSS.Hooks.cleanRootPropertyValue(hookRoot, rootPropertyValue);

						/* Split rootPropertyValue into its individual hook values, replace the targeted value with hookValue,
						 then reconstruct the rootPropertyValue string. */
						rootPropertyValueParts = rootPropertyValue.toString().match(CSS.RegEx.valueSplit);
						rootPropertyValueParts[hookPosition] = hookValue;
						rootPropertyValueUpdated = rootPropertyValueParts.join(" ");

						return rootPropertyValueUpdated;
					} else {
						/* If the provided fullHookName isn't a registered hook, return the rootPropertyValue that was passed in. */
						return rootPropertyValue;
					}
				}
			},
			/*******************
			 Normalizations
			 *******************/

			/* Normalizations standardize CSS property manipulation by pollyfilling browser-specific implementations (e.g. opacity)
			 and reformatting special properties (e.g. clip, rgba) to look like standard ones. */
			Normalizations: {
				/* Normalizations are passed a normalization target (either the property's name, its extracted value, or its injected value),
				 the targeted element (which may need to be queried), and the targeted property value. */
				registered: {
					clip: function(type, element, propertyValue) {
						switch (type) {
							case "name":
								return "clip";
								/* Clip needs to be unwrapped and stripped of its commas during extraction. */
							case "extract":
								var extracted;

								/* If Velocity also extracted this value, skip extraction. */
								if (CSS.RegEx.wrappedValueAlreadyExtracted.test(propertyValue)) {
									extracted = propertyValue;
								} else {
									/* Remove the "rect()" wrapper. */
									extracted = propertyValue.toString().match(CSS.RegEx.valueUnwrap);

									/* Strip off commas. */
									extracted = extracted ? extracted[1].replace(/,(\s+)?/g, " ") : propertyValue;
								}

								return extracted;
								/* Clip needs to be re-wrapped during injection. */
							case "inject":
								return "rect(" + propertyValue + ")";
						}
					},
					blur: function(type, element, propertyValue) {
						switch (type) {
							case "name":
								return Velocity.State.isFirefox ? "filter" : "-webkit-filter";
							case "extract":
								var extracted = parseFloat(propertyValue);

								/* If extracted is NaN, meaning the value isn't already extracted. */
								if (!(extracted || extracted === 0)) {
									var blurComponent = propertyValue.toString().match(/blur\(([0-9]+[A-z]+)\)/i);

									/* If the filter string had a blur component, return just the blur value and unit type. */
									if (blurComponent) {
										extracted = blurComponent[1];
										/* If the component doesn't exist, default blur to 0. */
									} else {
										extracted = 0;
									}
								}

								return extracted;
								/* Blur needs to be re-wrapped during injection. */
							case "inject":
								/* For the blur effect to be fully de-applied, it needs to be set to "none" instead of 0. */
								if (!parseFloat(propertyValue)) {
									return "none";
								} else {
									return "blur(" + propertyValue + ")";
								}
						}
					},
					/* <=IE8 do not support the standard opacity property. They use filter:alpha(opacity=INT) instead. */
					opacity: function(type, element, propertyValue) {
						if (IE <= 8) {
							switch (type) {
								case "name":
									return "filter";
								case "extract":
									/* <=IE8 return a "filter" value of "alpha(opacity=\d{1,3})".
									 Extract the value and convert it to a decimal value to match the standard CSS opacity property's formatting. */
									var extracted = propertyValue.toString().match(/alpha\(opacity=(.*)\)/i);

									if (extracted) {
										/* Convert to decimal value. */
										propertyValue = extracted[1] / 100;
									} else {
										/* When extracting opacity, default to 1 since a null value means opacity hasn't been set. */
										propertyValue = 1;
									}

									return propertyValue;
								case "inject":
									/* Opacified elements are required to have their zoom property set to a non-zero value. */
									element.style.zoom = 1;

									/* Setting the filter property on elements with certain font property combinations can result in a
									 highly unappealing ultra-bolding effect. There's no way to remedy this throughout a tween, but dropping the
									 value altogether (when opacity hits 1) at leasts ensures that the glitch is gone post-tweening. */
									if (parseFloat(propertyValue) >= 1) {
										return "";
									} else {
										/* As per the filter property's spec, convert the decimal value to a whole number and wrap the value. */
										return "alpha(opacity=" + parseInt(parseFloat(propertyValue) * 100, 10) + ")";
									}
							}
							/* With all other browsers, normalization is not required; return the same values that were passed in. */
						} else {
							switch (type) {
								case "name":
									return "opacity";
								case "extract":
									return propertyValue;
								case "inject":
									return propertyValue;
							}
						}
					}
				},
				/*****************************
				 Batched Registrations
				 *****************************/

				/* Note: Batched normalizations extend the CSS.Normalizations.registered object. */
				register: function() {

					/*****************
					 Transforms
					 *****************/

					/* Transforms are the subproperties contained by the CSS "transform" property. Transforms must undergo normalization
					 so that they can be referenced in a properties map by their individual names. */
					/* Note: When transforms are "set", they are actually assigned to a per-element transformCache. When all transform
					 setting is complete complete, CSS.flushTransformCache() must be manually called to flush the values to the DOM.
					 Transform setting is batched in this way to improve performance: the transform style only needs to be updated
					 once when multiple transform subproperties are being animated simultaneously. */
					/* Note: IE9 and Android Gingerbread have support for 2D -- but not 3D -- transforms. Since animating unsupported
					 transform properties results in the browser ignoring the *entire* transform string, we prevent these 3D values
					 from being normalized for these browsers so that tweening skips these properties altogether
					 (since it will ignore them as being unsupported by the browser.) */
					if ((!IE || IE > 9) && !Velocity.State.isGingerbread) {
						/* Note: Since the standalone CSS "perspective" property and the CSS transform "perspective" subproperty
						 share the same name, the latter is given a unique token within Velocity: "transformPerspective". */
						CSS.Lists.transformsBase = CSS.Lists.transformsBase.concat(CSS.Lists.transforms3D);
					}

					for (var i = 0; i < CSS.Lists.transformsBase.length; i++) {
						/* Wrap the dynamically generated normalization function in a new scope so that transformName's value is
						 paired with its respective function. (Otherwise, all functions would take the final for loop's transformName.) */
						(function() {
							var transformName = CSS.Lists.transformsBase[i];

							CSS.Normalizations.registered[transformName] = function(type, element, propertyValue) {
								switch (type) {
									/* The normalized property name is the parent "transform" property -- the property that is actually set in CSS. */
									case "name":
										return "transform";
										/* Transform values are cached onto a per-element transformCache object. */
									case "extract":
										/* If this transform has yet to be assigned a value, return its null value. */
										if (Data(element) === undefined || Data(element).transformCache[transformName] === undefined) {
											/* Scale CSS.Lists.transformsBase default to 1 whereas all other transform properties default to 0. */
											return /^scale/i.test(transformName) ? 1 : 0;
											/* When transform values are set, they are wrapped in parentheses as per the CSS spec.
											 Thus, when extracting their values (for tween calculations), we strip off the parentheses. */
										}
										return Data(element).transformCache[transformName].replace(/[()]/g, "");
									case "inject":
										var invalid = false;

										/* If an individual transform property contains an unsupported unit type, the browser ignores the *entire* transform property.
										 Thus, protect users from themselves by skipping setting for transform values supplied with invalid unit types. */
										/* Switch on the base transform type; ignore the axis by removing the last letter from the transform's name. */
										switch (transformName.substr(0, transformName.length - 1)) {
											/* Whitelist unit types for each transform. */
											case "translate":
												invalid = !/(%|px|em|rem|vw|vh|\d)$/i.test(propertyValue);
												break;
												/* Since an axis-free "scale" property is supported as well, a little hack is used here to detect it by chopping off its last letter. */
											case "scal":
											case "scale":
												/* Chrome on Android has a bug in which scaled elements blur if their initial scale
												 value is below 1 (which can happen with forcefeeding). Thus, we detect a yet-unset scale property
												 and ensure that its first value is always 1. More info: http://stackoverflow.com/questions/10417890/css3-animations-with-transform-causes-blurred-elements-on-webkit/10417962#10417962 */
												if (Velocity.State.isAndroid && Data(element).transformCache[transformName] === undefined && propertyValue < 1) {
													propertyValue = 1;
												}

												invalid = !/(\d)$/i.test(propertyValue);
												break;
											case "skew":
												invalid = !/(deg|\d)$/i.test(propertyValue);
												break;
											case "rotate":
												invalid = !/(deg|\d)$/i.test(propertyValue);
												break;
										}

										if (!invalid) {
											/* As per the CSS spec, wrap the value in parentheses. */
											Data(element).transformCache[transformName] = "(" + propertyValue + ")";
										}

										/* Although the value is set on the transformCache object, return the newly-updated value for the calling code to process as normal. */
										return Data(element).transformCache[transformName];
								}
							};
						})();
					}

					/*************
					 Colors
					 *************/

					/* Since Velocity only animates a single numeric value per property, color animation is achieved by hooking the individual RGBA components of CSS color properties.
					 Accordingly, color values must be normalized (e.g. "#ff0000", "red", and "rgb(255, 0, 0)" ==> "255 0 0 1") so that their components can be injected/extracted by CSS.Hooks logic. */
					for (var j = 0; j < CSS.Lists.colors.length; j++) {
						/* Wrap the dynamically generated normalization function in a new scope so that colorName's value is paired with its respective function.
						 (Otherwise, all functions would take the final for loop's colorName.) */
						(function() {
							var colorName = CSS.Lists.colors[j];

							/* Note: In IE<=8, which support rgb but not rgba, color properties are reverted to rgb by stripping off the alpha component. */
							CSS.Normalizations.registered[colorName] = function(type, element, propertyValue) {
								switch (type) {
									case "name":
										return colorName;
										/* Convert all color values into the rgb format. (Old IE can return hex values and color names instead of rgb/rgba.) */
									case "extract":
										var extracted;

										/* If the color is already in its hookable form (e.g. "255 255 255 1") due to having been previously extracted, skip extraction. */
										if (CSS.RegEx.wrappedValueAlreadyExtracted.test(propertyValue)) {
											extracted = propertyValue;
										} else {
											var converted,
													colorNames = {
														black: "rgb(0, 0, 0)",
														blue: "rgb(0, 0, 255)",
														gray: "rgb(128, 128, 128)",
														green: "rgb(0, 128, 0)",
														red: "rgb(255, 0, 0)",
														white: "rgb(255, 255, 255)"
													};

											/* Convert color names to rgb. */
											if (/^[A-z]+$/i.test(propertyValue)) {
												if (colorNames[propertyValue] !== undefined) {
													converted = colorNames[propertyValue];
												} else {
													/* If an unmatched color name is provided, default to black. */
													converted = colorNames.black;
												}
												/* Convert hex values to rgb. */
											} else if (CSS.RegEx.isHex.test(propertyValue)) {
												converted = "rgb(" + CSS.Values.hexToRgb(propertyValue).join(" ") + ")";
												/* If the provided color doesn't match any of the accepted color formats, default to black. */
											} else if (!(/^rgba?\(/i.test(propertyValue))) {
												converted = colorNames.black;
											}

											/* Remove the surrounding "rgb/rgba()" string then replace commas with spaces and strip
											 repeated spaces (in case the value included spaces to begin with). */
											extracted = (converted || propertyValue).toString().match(CSS.RegEx.valueUnwrap)[1].replace(/,(\s+)?/g, " ");
										}

										/* So long as this isn't <=IE8, add a fourth (alpha) component if it's missing and default it to 1 (visible). */
										if ((!IE || IE > 8) && extracted.split(" ").length === 3) {
											extracted += " 1";
										}

										return extracted;
									case "inject":
										/* If we have a pattern then it might already have the right values */
										if (/^rgb/.test(propertyValue)) {
											return propertyValue;
										}

										/* If this is IE<=8 and an alpha component exists, strip it off. */
										if (IE <= 8) {
											if (propertyValue.split(" ").length === 4) {
												propertyValue = propertyValue.split(/\s+/).slice(0, 3).join(" ");
											}
											/* Otherwise, add a fourth (alpha) component if it's missing and default it to 1 (visible). */
										} else if (propertyValue.split(" ").length === 3) {
											propertyValue += " 1";
										}

										/* Re-insert the browser-appropriate wrapper("rgb/rgba()"), insert commas, and strip off decimal units
										 on all values but the fourth (R, G, and B only accept whole numbers). */
										return (IE <= 8 ? "rgb" : "rgba") + "(" + propertyValue.replace(/\s+/g, ",").replace(/\.(\d)+(?=,)/g, "") + ")";
								}
							};
						})();
					}

					/**************
					 Dimensions
					 **************/
					function augmentDimension(name, element, wantInner) {
						var isBorderBox = CSS.getPropertyValue(element, "boxSizing").toString().toLowerCase() === "border-box";

						if (isBorderBox === (wantInner || false)) {
							/* in box-sizing mode, the CSS width / height accessors already give the outerWidth / outerHeight. */
							var i,
									value,
									augment = 0,
									sides = name === "width" ? ["Left", "Right"] : ["Top", "Bottom"],
									fields = ["padding" + sides[0], "padding" + sides[1], "border" + sides[0] + "Width", "border" + sides[1] + "Width"];

							for (i = 0; i < fields.length; i++) {
								value = parseFloat(CSS.getPropertyValue(element, fields[i]));
								if (!isNaN(value)) {
									augment += value;
								}
							}
							return wantInner ? -augment : augment;
						}
						return 0;
					}
					function getDimension(name, wantInner) {
						return function(type, element, propertyValue) {
							switch (type) {
								case "name":
									return name;
								case "extract":
									return parseFloat(propertyValue) + augmentDimension(name, element, wantInner);
								case "inject":
									return (parseFloat(propertyValue) - augmentDimension(name, element, wantInner)) + "px";
							}
						};
					}
					CSS.Normalizations.registered.innerWidth = getDimension("width", true);
					CSS.Normalizations.registered.innerHeight = getDimension("height", true);
					CSS.Normalizations.registered.outerWidth = getDimension("width");
					CSS.Normalizations.registered.outerHeight = getDimension("height");
				}
			},
			/************************
			 CSS Property Names
			 ************************/

			Names: {
				/* Camelcase a property name into its JavaScript notation (e.g. "background-color" ==> "backgroundColor").
				 Camelcasing is used to normalize property names between and across calls. */
				camelCase: function(property) {
					return property.replace(/-(\w)/g, function(match, subMatch) {
						return subMatch.toUpperCase();
					});
				},
				/* For SVG elements, some properties (namely, dimensional ones) are GET/SET via the element's HTML attributes (instead of via CSS styles). */
				SVGAttribute: function(property) {
					var SVGAttributes = "width|height|x|y|cx|cy|r|rx|ry|x1|x2|y1|y2";

					/* Certain browsers require an SVG transform to be applied as an attribute. (Otherwise, application via CSS is preferable due to 3D support.) */
					if (IE || (Velocity.State.isAndroid && !Velocity.State.isChrome)) {
						SVGAttributes += "|transform";
					}

					return new RegExp("^(" + SVGAttributes + ")$", "i").test(property);
				},
				/* Determine whether a property should be set with a vendor prefix. */
				/* If a prefixed version of the property exists, return it. Otherwise, return the original property name.
				 If the property is not at all supported by the browser, return a false flag. */
				prefixCheck: function(property) {
					/* If this property has already been checked, return the cached value. */
					if (Velocity.State.prefixMatches[property]) {
						return [Velocity.State.prefixMatches[property], true];
					} else {
						var vendors = ["", "Webkit", "Moz", "ms", "O"];

						for (var i = 0, vendorsLength = vendors.length; i < vendorsLength; i++) {
							var propertyPrefixed;

							if (i === 0) {
								propertyPrefixed = property;
							} else {
								/* Capitalize the first letter of the property to conform to JavaScript vendor prefix notation (e.g. webkitFilter). */
								propertyPrefixed = vendors[i] + property.replace(/^\w/, function(match) {
									return match.toUpperCase();
								});
							}

							/* Check if the browser supports this property as prefixed. */
							if (Type.isString(Velocity.State.prefixElement.style[propertyPrefixed])) {
								/* Cache the match. */
								Velocity.State.prefixMatches[property] = propertyPrefixed;

								return [propertyPrefixed, true];
							}
						}

						/* If the browser doesn't support this property in any form, include a false flag so that the caller can decide how to proceed. */
						return [property, false];
					}
				}
			},
			/************************
			 CSS Property Values
			 ************************/

			Values: {
				/* Hex to RGB conversion. Copyright Tim Down: http://stackoverflow.com/questions/5623838/rgb-to-hex-and-hex-to-rgb */
				hexToRgb: function(hex) {
					var shortformRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i,
							longformRegex = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i,
							rgbParts;

					hex = hex.replace(shortformRegex, function(m, r, g, b) {
						return r + r + g + g + b + b;
					});

					rgbParts = longformRegex.exec(hex);

					return rgbParts ? [parseInt(rgbParts[1], 16), parseInt(rgbParts[2], 16), parseInt(rgbParts[3], 16)] : [0, 0, 0];
				},
				isCSSNullValue: function(value) {
					/* The browser defaults CSS values that have not been set to either 0 or one of several possible null-value strings.
					 Thus, we check for both falsiness and these special strings. */
					/* Null-value checking is performed to default the special strings to 0 (for the sake of tweening) or their hook
					 templates as defined as CSS.Hooks (for the sake of hook injection/extraction). */
					/* Note: Chrome returns "rgba(0, 0, 0, 0)" for an undefined color whereas IE returns "transparent". */
					return (!value || /^(none|auto|transparent|(rgba\(0, ?0, ?0, ?0\)))$/i.test(value));
				},
				/* Retrieve a property's default unit type. Used for assigning a unit type when one is not supplied by the user. */
				getUnitType: function(property) {
					if (/^(rotate|skew)/i.test(property)) {
						return "deg";
					} else if (/(^(scale|scaleX|scaleY|scaleZ|alpha|flexGrow|flexHeight|zIndex|fontWeight)$)|((opacity|red|green|blue|alpha)$)/i.test(property)) {
						/* The above properties are unitless. */
						return "";
					} else {
						/* Default to px for all other properties. */
						return "px";
					}
				},
				/* HTML elements default to an associated display type when they're not set to display:none. */
				/* Note: This function is used for correctly setting the non-"none" display value in certain Velocity redirects, such as fadeIn/Out. */
				getDisplayType: function(element) {
					var tagName = element && element.tagName.toString().toLowerCase();

					if (/^(b|big|i|small|tt|abbr|acronym|cite|code|dfn|em|kbd|strong|samp|var|a|bdo|br|img|map|object|q|script|span|sub|sup|button|input|label|select|textarea)$/i.test(tagName)) {
						return "inline";
					} else if (/^(li)$/i.test(tagName)) {
						return "list-item";
					} else if (/^(tr)$/i.test(tagName)) {
						return "table-row";
					} else if (/^(table)$/i.test(tagName)) {
						return "table";
					} else if (/^(tbody)$/i.test(tagName)) {
						return "table-row-group";
						/* Default to "block" when no match is found. */
					} else {
						return "block";
					}
				},
				/* The class add/remove functions are used to temporarily apply a "velocity-animating" class to elements while they're animating. */
				addClass: function(element, className) {
					if (element) {
						if (element.classList) {
							element.classList.add(className);
						} else if (Type.isString(element.className)) {
							// Element.className is around 15% faster then set/getAttribute
							element.className += (element.className.length ? " " : "") + className;
						} else {
							// Work around for IE strict mode animating SVG - and anything else that doesn't behave correctly - the same way jQuery does it
							var currentClass = element.getAttribute(IE <= 7 ? "className" : "class") || "";

							element.setAttribute("class", currentClass + (currentClass ? " " : "") + className);
						}
					}
				},
				removeClass: function(element, className) {
					if (element) {
						if (element.classList) {
							element.classList.remove(className);
						} else if (Type.isString(element.className)) {
							// Element.className is around 15% faster then set/getAttribute
							// TODO: Need some jsperf tests on performance - can we get rid of the regex and maybe use split / array manipulation?
							element.className = element.className.toString().replace(new RegExp("(^|\\s)" + className.split(" ").join("|") + "(\\s|$)", "gi"), " ");
						} else {
							// Work around for IE strict mode animating SVG - and anything else that doesn't behave correctly - the same way jQuery does it
							var currentClass = element.getAttribute(IE <= 7 ? "className" : "class") || "";

							element.setAttribute("class", currentClass.replace(new RegExp("(^|\s)" + className.split(" ").join("|") + "(\s|$)", "gi"), " "));
						}
					}
				}
			},
			/****************************
			 Style Getting & Setting
			 ****************************/

			/* The singular getPropertyValue, which routes the logic for all normalizations, hooks, and standard CSS properties. */
			getPropertyValue: function(element, property, rootPropertyValue, forceStyleLookup) {
				/* Get an element's computed property value. */
				/* Note: Retrieving the value of a CSS property cannot simply be performed by checking an element's
				 style attribute (which only reflects user-defined values). Instead, the browser must be queried for a property's
				 *computed* value. You can read more about getComputedStyle here: https://developer.mozilla.org/en/docs/Web/API/window.getComputedStyle */
				function computePropertyValue(element, property) {
					/* When box-sizing isn't set to border-box, height and width style values are incorrectly computed when an
					 element's scrollbars are visible (which expands the element's dimensions). Thus, we defer to the more accurate
					 offsetHeight/Width property, which includes the total dimensions for interior, border, padding, and scrollbar.
					 We subtract border and padding to get the sum of interior + scrollbar. */
					var computedValue = 0;

					/* IE<=8 doesn't support window.getComputedStyle, thus we defer to jQuery, which has an extensive array
					 of hacks to accurately retrieve IE8 property values. Re-implementing that logic here is not worth bloating the
					 codebase for a dying browser. The performance repercussions of using jQuery here are minimal since
					 Velocity is optimized to rarely (and sometimes never) query the DOM. Further, the $.css() codepath isn't that slow. */
					if (IE <= 8) {
						computedValue = $.css(element, property); /* GET */
						/* All other browsers support getComputedStyle. The returned live object reference is cached onto its
						 associated element so that it does not need to be refetched upon every GET. */
					} else {
						/* Browsers do not return height and width values for elements that are set to display:"none". Thus, we temporarily
						 toggle display to the element type's default value. */
						var toggleDisplay = false;

						if (/^(width|height)$/.test(property) && CSS.getPropertyValue(element, "display") === 0) {
							toggleDisplay = true;
							CSS.setPropertyValue(element, "display", CSS.Values.getDisplayType(element));
						}

						var revertDisplay = function() {
							if (toggleDisplay) {
								CSS.setPropertyValue(element, "display", "none");
							}
						};

						if (!forceStyleLookup) {
							if (property === "height" && CSS.getPropertyValue(element, "boxSizing").toString().toLowerCase() !== "border-box") {
								var contentBoxHeight = element.offsetHeight - (parseFloat(CSS.getPropertyValue(element, "borderTopWidth")) || 0) - (parseFloat(CSS.getPropertyValue(element, "borderBottomWidth")) || 0) - (parseFloat(CSS.getPropertyValue(element, "paddingTop")) || 0) - (parseFloat(CSS.getPropertyValue(element, "paddingBottom")) || 0);
								revertDisplay();

								return contentBoxHeight;
							} else if (property === "width" && CSS.getPropertyValue(element, "boxSizing").toString().toLowerCase() !== "border-box") {
								var contentBoxWidth = element.offsetWidth - (parseFloat(CSS.getPropertyValue(element, "borderLeftWidth")) || 0) - (parseFloat(CSS.getPropertyValue(element, "borderRightWidth")) || 0) - (parseFloat(CSS.getPropertyValue(element, "paddingLeft")) || 0) - (parseFloat(CSS.getPropertyValue(element, "paddingRight")) || 0);
								revertDisplay();

								return contentBoxWidth;
							}
						}

						var computedStyle;

						/* For elements that Velocity hasn't been called on directly (e.g. when Velocity queries the DOM on behalf
						 of a parent of an element its animating), perform a direct getComputedStyle lookup since the object isn't cached. */
						if (Data(element) === undefined) {
							computedStyle = window.getComputedStyle(element, null); /* GET */
							/* If the computedStyle object has yet to be cached, do so now. */
						} else if (!Data(element).computedStyle) {
							computedStyle = Data(element).computedStyle = window.getComputedStyle(element, null); /* GET */
							/* If computedStyle is cached, use it. */
						} else {
							computedStyle = Data(element).computedStyle;
						}

						/* IE and Firefox do not return a value for the generic borderColor -- they only return individual values for each border side's color.
						 Also, in all browsers, when border colors aren't all the same, a compound value is returned that Velocity isn't setup to parse.
						 So, as a polyfill for querying individual border side colors, we just return the top border's color and animate all borders from that value. */
						if (property === "borderColor") {
							property = "borderTopColor";
						}

						/* IE9 has a bug in which the "filter" property must be accessed from computedStyle using the getPropertyValue method
						 instead of a direct property lookup. The getPropertyValue method is slower than a direct lookup, which is why we avoid it by default. */
						if (IE === 9 && property === "filter") {
							computedValue = computedStyle.getPropertyValue(property); /* GET */
						} else {
							computedValue = computedStyle[property];
						}

						/* Fall back to the property's style value (if defined) when computedValue returns nothing,
						 which can happen when the element hasn't been painted. */
						if (computedValue === "" || computedValue === null) {
							computedValue = element.style[property];
						}

						revertDisplay();
					}

					/* For top, right, bottom, and left (TRBL) values that are set to "auto" on elements of "fixed" or "absolute" position,
					 defer to jQuery for converting "auto" to a numeric value. (For elements with a "static" or "relative" position, "auto" has the same
					 effect as being set to 0, so no conversion is necessary.) */
					/* An example of why numeric conversion is necessary: When an element with "position:absolute" has an untouched "left"
					 property, which reverts to "auto", left's value is 0 relative to its parent element, but is often non-zero relative
					 to its *containing* (not parent) element, which is the nearest "position:relative" ancestor or the viewport (and always the viewport in the case of "position:fixed"). */
					if (computedValue === "auto" && /^(top|right|bottom|left)$/i.test(property)) {
						var position = computePropertyValue(element, "position"); /* GET */

						/* For absolute positioning, jQuery's $.position() only returns values for top and left;
						 right and bottom will have their "auto" value reverted to 0. */
						/* Note: A jQuery object must be created here since jQuery doesn't have a low-level alias for $.position().
						 Not a big deal since we're currently in a GET batch anyway. */
						if (position === "fixed" || (position === "absolute" && /top|left/i.test(property))) {
							/* Note: jQuery strips the pixel unit from its returned values; we re-add it here to conform with computePropertyValue's behavior. */
							computedValue = $(element).position()[property] + "px"; /* GET */
						}
					}

					return computedValue;
				}

				var propertyValue;

				/* If this is a hooked property (e.g. "clipLeft" instead of the root property of "clip"),
				 extract the hook's value from a normalized rootPropertyValue using CSS.Hooks.extractValue(). */
				if (CSS.Hooks.registered[property]) {
					var hook = property,
							hookRoot = CSS.Hooks.getRoot(hook);

					/* If a cached rootPropertyValue wasn't passed in (which Velocity always attempts to do in order to avoid requerying the DOM),
					 query the DOM for the root property's value. */
					if (rootPropertyValue === undefined) {
						/* Since the browser is now being directly queried, use the official post-prefixing property name for this lookup. */
						rootPropertyValue = CSS.getPropertyValue(element, CSS.Names.prefixCheck(hookRoot)[0]); /* GET */
					}

					/* If this root has a normalization registered, peform the associated normalization extraction. */
					if (CSS.Normalizations.registered[hookRoot]) {
						rootPropertyValue = CSS.Normalizations.registered[hookRoot]("extract", element, rootPropertyValue);
					}

					/* Extract the hook's value. */
					propertyValue = CSS.Hooks.extractValue(hook, rootPropertyValue);

					/* If this is a normalized property (e.g. "opacity" becomes "filter" in <=IE8) or "translateX" becomes "transform"),
					 normalize the property's name and value, and handle the special case of transforms. */
					/* Note: Normalizing a property is mutually exclusive from hooking a property since hook-extracted values are strictly
					 numerical and therefore do not require normalization extraction. */
				} else if (CSS.Normalizations.registered[property]) {
					var normalizedPropertyName,
							normalizedPropertyValue;

					normalizedPropertyName = CSS.Normalizations.registered[property]("name", element);

					/* Transform values are calculated via normalization extraction (see below), which checks against the element's transformCache.
					 At no point do transform GETs ever actually query the DOM; initial stylesheet values are never processed.
					 This is because parsing 3D transform matrices is not always accurate and would bloat our codebase;
					 thus, normalization extraction defaults initial transform values to their zero-values (e.g. 1 for scaleX and 0 for translateX). */
					if (normalizedPropertyName !== "transform") {
						normalizedPropertyValue = computePropertyValue(element, CSS.Names.prefixCheck(normalizedPropertyName)[0]); /* GET */

						/* If the value is a CSS null-value and this property has a hook template, use that zero-value template so that hooks can be extracted from it. */
						if (CSS.Values.isCSSNullValue(normalizedPropertyValue) && CSS.Hooks.templates[property]) {
							normalizedPropertyValue = CSS.Hooks.templates[property][1];
						}
					}

					propertyValue = CSS.Normalizations.registered[property]("extract", element, normalizedPropertyValue);
				}

				/* If a (numeric) value wasn't produced via hook extraction or normalization, query the DOM. */
				if (!/^[\d-]/.test(propertyValue)) {
					/* For SVG elements, dimensional properties (which SVGAttribute() detects) are tweened via
					 their HTML attribute values instead of their CSS style values. */
					var data = Data(element);

					if (data && data.isSVG && CSS.Names.SVGAttribute(property)) {
						/* Since the height/width attribute values must be set manually, they don't reflect computed values.
						 Thus, we use use getBBox() to ensure we always get values for elements with undefined height/width attributes. */
						if (/^(height|width)$/i.test(property)) {
							/* Firefox throws an error if .getBBox() is called on an SVG that isn't attached to the DOM. */
							try {
								propertyValue = element.getBBox()[property];
							} catch (error) {
								propertyValue = 0;
							}
							/* Otherwise, access the attribute value directly. */
						} else {
							propertyValue = element.getAttribute(property);
						}
					} else {
						propertyValue = computePropertyValue(element, CSS.Names.prefixCheck(property)[0]); /* GET */
					}
				}

				/* Since property lookups are for animation purposes (which entails computing the numeric delta between start and end values),
				 convert CSS null-values to an integer of value 0. */
				if (CSS.Values.isCSSNullValue(propertyValue)) {
					propertyValue = 0;
				}

				if (Velocity.debug >= 2) {
					console.log("Get " + property + ": " + propertyValue);
				}

				return propertyValue;
			},
			/* The singular setPropertyValue, which routes the logic for all normalizations, hooks, and standard CSS properties. */
			setPropertyValue: function(element, property, propertyValue, rootPropertyValue, scrollData) {
				var propertyName = property;

				/* In order to be subjected to call options and element queueing, scroll animation is routed through Velocity as if it were a standard CSS property. */
				if (property === "scroll") {
					/* If a container option is present, scroll the container instead of the browser window. */
					if (scrollData.container) {
						scrollData.container["scroll" + scrollData.direction] = propertyValue;
						/* Otherwise, Velocity defaults to scrolling the browser window. */
					} else {
						if (scrollData.direction === "Left") {
							window.scrollTo(propertyValue, scrollData.alternateValue);
						} else {
							window.scrollTo(scrollData.alternateValue, propertyValue);
						}
					}
				} else {
					/* Transforms (translateX, rotateZ, etc.) are applied to a per-element transformCache object, which is manually flushed via flushTransformCache().
					 Thus, for now, we merely cache transforms being SET. */
					if (CSS.Normalizations.registered[property] && CSS.Normalizations.registered[property]("name", element) === "transform") {
						/* Perform a normalization injection. */
						/* Note: The normalization logic handles the transformCache updating. */
						CSS.Normalizations.registered[property]("inject", element, propertyValue);

						propertyName = "transform";
						propertyValue = Data(element).transformCache[property];
					} else {
						/* Inject hooks. */
						if (CSS.Hooks.registered[property]) {
							var hookName = property,
									hookRoot = CSS.Hooks.getRoot(property);

							/* If a cached rootPropertyValue was not provided, query the DOM for the hookRoot's current value. */
							rootPropertyValue = rootPropertyValue || CSS.getPropertyValue(element, hookRoot); /* GET */

							propertyValue = CSS.Hooks.injectValue(hookName, propertyValue, rootPropertyValue);
							property = hookRoot;
						}

						/* Normalize names and values. */
						if (CSS.Normalizations.registered[property]) {
							propertyValue = CSS.Normalizations.registered[property]("inject", element, propertyValue);
							property = CSS.Normalizations.registered[property]("name", element);
						}

						/* Assign the appropriate vendor prefix before performing an official style update. */
						propertyName = CSS.Names.prefixCheck(property)[0];

						/* A try/catch is used for IE<=8, which throws an error when "invalid" CSS values are set, e.g. a negative width.
						 Try/catch is avoided for other browsers since it incurs a performance overhead. */
						if (IE <= 8) {
							try {
								element.style[propertyName] = propertyValue;
							} catch (error) {
								if (Velocity.debug) {
									console.log("Browser does not support [" + propertyValue + "] for [" + propertyName + "]");
								}
							}
							/* SVG elements have their dimensional properties (width, height, x, y, cx, etc.) applied directly as attributes instead of as styles. */
							/* Note: IE8 does not support SVG elements, so it's okay that we skip it for SVG animation. */
						} else {
							var data = Data(element);

							if (data && data.isSVG && CSS.Names.SVGAttribute(property)) {
								/* Note: For SVG attributes, vendor-prefixed property names are never used. */
								/* Note: Not all CSS properties can be animated via attributes, but the browser won't throw an error for unsupported properties. */
								element.setAttribute(property, propertyValue);
							} else {
								element.style[propertyName] = propertyValue;
							}
						}

						if (Velocity.debug >= 2) {
							console.log("Set " + property + " (" + propertyName + "): " + propertyValue);
						}
					}
				}

				/* Return the normalized property name and value in case the caller wants to know how these values were modified before being applied to the DOM. */
				return [propertyName, propertyValue];
			},
			/* To increase performance by batching transform updates into a single SET, transforms are not directly applied to an element until flushTransformCache() is called. */
			/* Note: Velocity applies transform properties in the same order that they are chronogically introduced to the element's CSS styles. */
			flushTransformCache: function(element) {
				var transformString = "",
						data = Data(element);

				/* Certain browsers require that SVG transforms be applied as an attribute. However, the SVG transform attribute takes a modified version of CSS's transform string
				 (units are dropped and, except for skewX/Y, subproperties are merged into their master property -- e.g. scaleX and scaleY are merged into scale(X Y). */
				if ((IE || (Velocity.State.isAndroid && !Velocity.State.isChrome)) && data && data.isSVG) {
					/* Since transform values are stored in their parentheses-wrapped form, we use a helper function to strip out their numeric values.
					 Further, SVG transform properties only take unitless (representing pixels) values, so it's okay that parseFloat() strips the unit suffixed to the float value. */
					var getTransformFloat = function(transformProperty) {
						return parseFloat(CSS.getPropertyValue(element, transformProperty));
					};

					/* Create an object to organize all the transforms that we'll apply to the SVG element. To keep the logic simple,
					 we process *all* transform properties -- even those that may not be explicitly applied (since they default to their zero-values anyway). */
					var SVGTransforms = {
						translate: [getTransformFloat("translateX"), getTransformFloat("translateY")],
						skewX: [getTransformFloat("skewX")], skewY: [getTransformFloat("skewY")],
						/* If the scale property is set (non-1), use that value for the scaleX and scaleY values
						 (this behavior mimics the result of animating all these properties at once on HTML elements). */
						scale: getTransformFloat("scale") !== 1 ? [getTransformFloat("scale"), getTransformFloat("scale")] : [getTransformFloat("scaleX"), getTransformFloat("scaleY")],
						/* Note: SVG's rotate transform takes three values: rotation degrees followed by the X and Y values
						 defining the rotation's origin point. We ignore the origin values (default them to 0). */
						rotate: [getTransformFloat("rotateZ"), 0, 0]
					};

					/* Iterate through the transform properties in the user-defined property map order.
					 (This mimics the behavior of non-SVG transform animation.) */
					$.each(Data(element).transformCache, function(transformName) {
						/* Except for with skewX/Y, revert the axis-specific transform subproperties to their axis-free master
						 properties so that they match up with SVG's accepted transform properties. */
						if (/^translate/i.test(transformName)) {
							transformName = "translate";
						} else if (/^scale/i.test(transformName)) {
							transformName = "scale";
						} else if (/^rotate/i.test(transformName)) {
							transformName = "rotate";
						}

						/* Check that we haven't yet deleted the property from the SVGTransforms container. */
						if (SVGTransforms[transformName]) {
							/* Append the transform property in the SVG-supported transform format. As per the spec, surround the space-delimited values in parentheses. */
							transformString += transformName + "(" + SVGTransforms[transformName].join(" ") + ")" + " ";

							/* After processing an SVG transform property, delete it from the SVGTransforms container so we don't
							 re-insert the same master property if we encounter another one of its axis-specific properties. */
							delete SVGTransforms[transformName];
						}
					});
				} else {
					var transformValue,
							perspective;

					/* Transform properties are stored as members of the transformCache object. Concatenate all the members into a string. */
					$.each(Data(element).transformCache, function(transformName) {
						transformValue = Data(element).transformCache[transformName];

						/* Transform's perspective subproperty must be set first in order to take effect. Store it temporarily. */
						if (transformName === "transformPerspective") {
							perspective = transformValue;
							return true;
						}

						/* IE9 only supports one rotation type, rotateZ, which it refers to as "rotate". */
						if (IE === 9 && transformName === "rotateZ") {
							transformName = "rotate";
						}

						transformString += transformName + transformValue + " ";
					});

					/* If present, set the perspective subproperty first. */
					if (perspective) {
						transformString = "perspective" + perspective + " " + transformString;
					}
				}

				CSS.setPropertyValue(element, "transform", transformString);
			}
		};

		/* Register hooks and normalizations. */
		CSS.Hooks.register();
		CSS.Normalizations.register();

		/* Allow hook setting in the same fashion as jQuery's $.css(). */
		Velocity.hook = function(elements, arg2, arg3) {
			var value;

			elements = sanitizeElements(elements);

			$.each(elements, function(i, element) {
				/* Initialize Velocity's per-element data cache if this element hasn't previously been animated. */
				if (Data(element) === undefined) {
					Velocity.init(element);
				}

				/* Get property value. If an element set was passed in, only return the value for the first element. */
				if (arg3 === undefined) {
					if (value === undefined) {
						value = CSS.getPropertyValue(element, arg2);
					}
					/* Set property value. */
				} else {
					/* sPV returns an array of the normalized propertyName/propertyValue pair used to update the DOM. */
					var adjustedSet = CSS.setPropertyValue(element, arg2, arg3);

					/* Transform properties don't automatically set. They have to be flushed to the DOM. */
					if (adjustedSet[0] === "transform") {
						Velocity.CSS.flushTransformCache(element);
					}

					value = adjustedSet;
				}
			});

			return value;
		};

		/*****************
		 Animation
		 *****************/

		var animate = function() {
			var opts;

			/******************
			 Call Chain
			 ******************/

			/* Logic for determining what to return to the call stack when exiting out of Velocity. */
			function getChain() {
				/* If we are using the utility function, attempt to return this call's promise. If no promise library was detected,
				 default to null instead of returning the targeted elements so that utility function's return value is standardized. */
				if (isUtility) {
					return promiseData.promise || null;
					/* Otherwise, if we're using $.fn, return the jQuery-/Zepto-wrapped element set. */
				} else {
					return elementsWrapped;
				}
			}

			/*************************
			 Arguments Assignment
			 *************************/

			/* To allow for expressive CoffeeScript code, Velocity supports an alternative syntax in which "elements" (or "e"), "properties" (or "p"), and "options" (or "o")
			 objects are defined on a container object that's passed in as Velocity's sole argument. */
			/* Note: Some browsers automatically populate arguments with a "properties" object. We detect it by checking for its default "names" property. */
			var syntacticSugar = (arguments[0] && (arguments[0].p || (($.isPlainObject(arguments[0].properties) && !arguments[0].properties.names) || Type.isString(arguments[0].properties)))),
					/* Whether Velocity was called via the utility function (as opposed to on a jQuery/Zepto object). */
					isUtility,
					/* When Velocity is called via the utility function ($.Velocity()/Velocity()), elements are explicitly
					 passed in as the first parameter. Thus, argument positioning varies. We normalize them here. */
					elementsWrapped,
					argumentIndex;

			var elements,
					propertiesMap,
					options;

			/* Detect jQuery/Zepto elements being animated via the $.fn method. */
			if (Type.isWrapped(this)) {
				isUtility = false;

				argumentIndex = 0;
				elements = this;
				elementsWrapped = this;
				/* Otherwise, raw elements are being animated via the utility function. */
			} else {
				isUtility = true;

				argumentIndex = 1;
				elements = syntacticSugar ? (arguments[0].elements || arguments[0].e) : arguments[0];
			}

			/***************
			 Promises
			 ***************/

			var promiseData = {
				promise: null,
				resolver: null,
				rejecter: null
			};

			/* If this call was made via the utility function (which is the default method of invocation when jQuery/Zepto are not being used), and if
			 promise support was detected, create a promise object for this call and store references to its resolver and rejecter methods. The resolve
			 method is used when a call completes naturally or is prematurely stopped by the user. In both cases, completeCall() handles the associated
			 call cleanup and promise resolving logic. The reject method is used when an invalid set of arguments is passed into a Velocity call. */
			/* Note: Velocity employs a call-based queueing architecture, which means that stopping an animating element actually stops the full call that
			 triggered it -- not that one element exclusively. Similarly, there is one promise per call, and all elements targeted by a Velocity call are
			 grouped together for the purposes of resolving and rejecting a promise. */
			if (isUtility && Velocity.Promise) {
				promiseData.promise = new Velocity.Promise(function(resolve, reject) {
					promiseData.resolver = resolve;
					promiseData.rejecter = reject;
				});
			}

			if (syntacticSugar) {
				propertiesMap = arguments[0].properties || arguments[0].p;
				options = arguments[0].options || arguments[0].o;
			} else {
				propertiesMap = arguments[argumentIndex];
				options = arguments[argumentIndex + 1];
			}

			elements = sanitizeElements(elements);

			if (!elements) {
				if (promiseData.promise) {
					if (!propertiesMap || !options || options.promiseRejectEmpty !== false) {
						promiseData.rejecter();
					} else {
						promiseData.resolver();
					}
				}
				return;
			}

			/* The length of the element set (in the form of a nodeList or an array of elements) is defaulted to 1 in case a
			 single raw DOM element is passed in (which doesn't contain a length property). */
			var elementsLength = elements.length,
					elementsIndex = 0;

			/***************************
			 Argument Overloading
			 ***************************/

			/* Support is included for jQuery's argument overloading: $.animate(propertyMap [, duration] [, easing] [, complete]).
			 Overloading is detected by checking for the absence of an object being passed into options. */
			/* Note: The stop/finish/pause/resume actions do not accept animation options, and are therefore excluded from this check. */
			if (!/^(stop|finish|finishAll|pause|resume)$/i.test(propertiesMap) && !$.isPlainObject(options)) {
				/* The utility function shifts all arguments one position to the right, so we adjust for that offset. */
				var startingArgumentPosition = argumentIndex + 1;

				options = {};

				/* Iterate through all options arguments */
				for (var i = startingArgumentPosition; i < arguments.length; i++) {
					/* Treat a number as a duration. Parse it out. */
					/* Note: The following RegEx will return true if passed an array with a number as its first item.
					 Thus, arrays are skipped from this check. */
					if (!Type.isArray(arguments[i]) && (/^(fast|normal|slow)$/i.test(arguments[i]) || /^\d/.test(arguments[i]))) {
						options.duration = arguments[i];
						/* Treat strings and arrays as easings. */
					} else if (Type.isString(arguments[i]) || Type.isArray(arguments[i])) {
						options.easing = arguments[i];
						/* Treat a function as a complete callback. */
					} else if (Type.isFunction(arguments[i])) {
						options.complete = arguments[i];
					}
				}
			}

			/*********************
			 Action Detection
			 *********************/

			/* Velocity's behavior is categorized into "actions": Elements can either be specially scrolled into view,
			 or they can be started, stopped, paused, resumed, or reversed . If a literal or referenced properties map is passed in as Velocity's
			 first argument, the associated action is "start". Alternatively, "scroll", "reverse", "pause", "resume" or "stop" can be passed in 
			 instead of a properties map. */
			var action;

			switch (propertiesMap) {
				case "scroll":
					action = "scroll";
					break;

				case "reverse":
					action = "reverse";
					break;

				case "pause":

					/*******************
					 Action: Pause
					 *******************/

					var currentTime = (new Date()).getTime();

					/* Handle delay timers */
					$.each(elements, function(i, element) {
						pauseDelayOnElement(element, currentTime);
					});

					/* Pause and Resume are call-wide (not on a per element basis). Thus, calling pause or resume on a 
					 single element will cause any calls that containt tweens for that element to be paused/resumed
					 as well. */

					/* Iterate through all calls and pause any that contain any of our elements */
					$.each(Velocity.State.calls, function(i, activeCall) {

						var found = false;
						/* Inactive calls are set to false by the logic inside completeCall(). Skip them. */
						if (activeCall) {
							/* Iterate through the active call's targeted elements. */
							$.each(activeCall[1], function(k, activeElement) {
								var queueName = (options === undefined) ? "" : options;

								if (queueName !== true && (activeCall[2].queue !== queueName) && !(options === undefined && activeCall[2].queue === false)) {
									return true;
								}

								/* Iterate through the calls targeted by the stop command. */
								$.each(elements, function(l, element) {
									/* Check that this call was applied to the target element. */
									if (element === activeElement) {

										/* Set call to paused */
										activeCall[5] = {
											resume: false
										};

										/* Once we match an element, we can bounce out to the next call entirely */
										found = true;
										return false;
									}
								});

								/* Proceed to check next call if we have already matched */
								if (found) {
									return false;
								}
							});
						}

					});

					/* Since pause creates no new tweens, exit out of Velocity. */
					return getChain();

				case "resume":

					/*******************
					 Action: Resume
					 *******************/

					/* Handle delay timers */
					$.each(elements, function(i, element) {
						resumeDelayOnElement(element, currentTime);
					});

					/* Pause and Resume are call-wide (not on a per elemnt basis). Thus, calling pause or resume on a 
					 single element will cause any calls that containt tweens for that element to be paused/resumed
					 as well. */

					/* Iterate through all calls and pause any that contain any of our elements */
					$.each(Velocity.State.calls, function(i, activeCall) {
						var found = false;
						/* Inactive calls are set to false by the logic inside completeCall(). Skip them. */
						if (activeCall) {
							/* Iterate through the active call's targeted elements. */
							$.each(activeCall[1], function(k, activeElement) {
								var queueName = (options === undefined) ? "" : options;

								if (queueName !== true && (activeCall[2].queue !== queueName) && !(options === undefined && activeCall[2].queue === false)) {
									return true;
								}

								/* Skip any calls that have never been paused */
								if (!activeCall[5]) {
									return true;
								}

								/* Iterate through the calls targeted by the stop command. */
								$.each(elements, function(l, element) {
									/* Check that this call was applied to the target element. */
									if (element === activeElement) {

										/* Flag a pause object to be resumed, which will occur during the next tick. In
										 addition, the pause object will at that time be deleted */
										activeCall[5].resume = true;

										/* Once we match an element, we can bounce out to the next call entirely */
										found = true;
										return false;
									}
								});

								/* Proceed to check next call if we have already matched */
								if (found) {
									return false;
								}
							});
						}

					});

					/* Since resume creates no new tweens, exit out of Velocity. */
					return getChain();

				case "finish":
				case "finishAll":
				case "stop":
					/*******************
					 Action: Stop
					 *******************/

					/* Clear the currently-active delay on each targeted element. */
					$.each(elements, function(i, element) {
						if (Data(element) && Data(element).delayTimer) {
							/* Stop the timer from triggering its cached next() function. */
							clearTimeout(Data(element).delayTimer.setTimeout);

							/* Manually call the next() function so that the subsequent queue items can progress. */
							if (Data(element).delayTimer.next) {
								Data(element).delayTimer.next();
							}

							delete Data(element).delayTimer;
						}

						/* If we want to finish everything in the queue, we have to iterate through it
						 and call each function. This will make them active calls below, which will
						 cause them to be applied via the duration setting. */
						if (propertiesMap === "finishAll" && (options === true || Type.isString(options))) {
							/* Iterate through the items in the element's queue. */
							$.each($.queue(element, Type.isString(options) ? options : ""), function(_, item) {
								/* The queue array can contain an "inprogress" string, which we skip. */
								if (Type.isFunction(item)) {
									item();
								}
							});

							/* Clearing the $.queue() array is achieved by resetting it to []. */
							$.queue(element, Type.isString(options) ? options : "", []);
						}
					});

					var callsToStop = [];

					/* When the stop action is triggered, the elements' currently active call is immediately stopped. The active call might have
					 been applied to multiple elements, in which case all of the call's elements will be stopped. When an element
					 is stopped, the next item in its animation queue is immediately triggered. */
					/* An additional argument may be passed in to clear an element's remaining queued calls. Either true (which defaults to the "fx" queue)
					 or a custom queue string can be passed in. */
					/* Note: The stop command runs prior to Velocity's Queueing phase since its behavior is intended to take effect *immediately*,
					 regardless of the element's current queue state. */

					/* Iterate through every active call. */
					$.each(Velocity.State.calls, function(i, activeCall) {
						/* Inactive calls are set to false by the logic inside completeCall(). Skip them. */
						if (activeCall) {
							/* Iterate through the active call's targeted elements. */
							$.each(activeCall[1], function(k, activeElement) {
								/* If true was passed in as a secondary argument, clear absolutely all calls on this element. Otherwise, only
								 clear calls associated with the relevant queue. */
								/* Call stopping logic works as follows:
								 - options === true --> stop current default queue calls (and queue:false calls), including remaining queued ones.
								 - options === undefined --> stop current queue:"" call and all queue:false calls.
								 - options === false --> stop only queue:false calls.
								 - options === "custom" --> stop current queue:"custom" call, including remaining queued ones (there is no functionality to only clear the currently-running queue:"custom" call). */
								var queueName = (options === undefined) ? "" : options;

								if (queueName !== true && (activeCall[2].queue !== queueName) && !(options === undefined && activeCall[2].queue === false)) {
									return true;
								}

								/* Iterate through the calls targeted by the stop command. */
								$.each(elements, function(l, element) {
									/* Check that this call was applied to the target element. */
									if (element === activeElement) {
										/* Optionally clear the remaining queued calls. If we're doing "finishAll" this won't find anything,
										 due to the queue-clearing above. */
										if (options === true || Type.isString(options)) {
											/* Iterate through the items in the element's queue. */
											$.each($.queue(element, Type.isString(options) ? options : ""), function(_, item) {
												/* The queue array can contain an "inprogress" string, which we skip. */
												if (Type.isFunction(item)) {
													/* Pass the item's callback a flag indicating that we want to abort from the queue call.
													 (Specifically, the queue will resolve the call's associated promise then abort.)  */
													item(null, true);
												}
											});

											/* Clearing the $.queue() array is achieved by resetting it to []. */
											$.queue(element, Type.isString(options) ? options : "", []);
										}

										if (propertiesMap === "stop") {
											/* Since "reverse" uses cached start values (the previous call's endValues), these values must be
											 changed to reflect the final value that the elements were actually tweened to. */
											/* Note: If only queue:false animations are currently running on an element, it won't have a tweensContainer
											 object. Also, queue:false animations can't be reversed. */
											var data = Data(element);
											if (data && data.tweensContainer && queueName !== false) {
												$.each(data.tweensContainer, function(m, activeTween) {
													activeTween.endValue = activeTween.currentValue;
												});
											}

											callsToStop.push(i);
										} else if (propertiesMap === "finish" || propertiesMap === "finishAll") {
											/* To get active tweens to finish immediately, we forcefully shorten their durations to 1ms so that
											 they finish upon the next rAf tick then proceed with normal call completion logic. */
											activeCall[2].duration = 1;
										}
									}
								});
							});
						}
					});

					/* Prematurely call completeCall() on each matched active call. Pass an additional flag for "stop" to indicate
					 that the complete callback and display:none setting should be skipped since we're completing prematurely. */
					if (propertiesMap === "stop") {
						$.each(callsToStop, function(i, j) {
							completeCall(j, true);
						});

						if (promiseData.promise) {
							/* Immediately resolve the promise associated with this stop call since stop runs synchronously. */
							promiseData.resolver(elements);
						}
					}

					/* Since we're stopping, and not proceeding with queueing, exit out of Velocity. */
					return getChain();

				default:
					/* Treat a non-empty plain object as a literal properties map. */
					if ($.isPlainObject(propertiesMap) && !Type.isEmptyObject(propertiesMap)) {
						action = "start";

						/****************
						 Redirects
						 ****************/

						/* Check if a string matches a registered redirect (see Redirects above). */
					} else if (Type.isString(propertiesMap) && Velocity.Redirects[propertiesMap]) {
						opts = $.extend({}, options);

						var durationOriginal = opts.duration,
								delayOriginal = opts.delay || 0;

						/* If the backwards option was passed in, reverse the element set so that elements animate from the last to the first. */
						if (opts.backwards === true) {
							elements = $.extend(true, [], elements).reverse();
						}

						/* Individually trigger the redirect for each element in the set to prevent users from having to handle iteration logic in their redirect. */
						$.each(elements, function(elementIndex, element) {
							/* If the stagger option was passed in, successively delay each element by the stagger value (in ms). Retain the original delay value. */
							if (parseFloat(opts.stagger)) {
								opts.delay = delayOriginal + (parseFloat(opts.stagger) * elementIndex);
							} else if (Type.isFunction(opts.stagger)) {
								opts.delay = delayOriginal + opts.stagger.call(element, elementIndex, elementsLength);
							}

							/* If the drag option was passed in, successively increase/decrease (depending on the presense of opts.backwards)
							 the duration of each element's animation, using floors to prevent producing very short durations. */
							if (opts.drag) {
								/* Default the duration of UI pack effects (callouts and transitions) to 1000ms instead of the usual default duration of 400ms. */
								opts.duration = parseFloat(durationOriginal) || (/^(callout|transition)/.test(propertiesMap) ? 1000 : DURATION_DEFAULT);

								/* For each element, take the greater duration of: A) animation completion percentage relative to the original duration,
								 B) 75% of the original duration, or C) a 200ms fallback (in case duration is already set to a low value).
								 The end result is a baseline of 75% of the redirect's duration that increases/decreases as the end of the element set is approached. */
								opts.duration = Math.max(opts.duration * (opts.backwards ? 1 - elementIndex / elementsLength : (elementIndex + 1) / elementsLength), opts.duration * 0.75, 200);
							}

							/* Pass in the call's opts object so that the redirect can optionally extend it. It defaults to an empty object instead of null to
							 reduce the opts checking logic required inside the redirect. */
							Velocity.Redirects[propertiesMap].call(element, element, opts || {}, elementIndex, elementsLength, elements, promiseData.promise ? promiseData : undefined);
						});

						/* Since the animation logic resides within the redirect's own code, abort the remainder of this call.
						 (The performance overhead up to this point is virtually non-existant.) */
						/* Note: The jQuery call chain is kept intact by returning the complete element set. */
						return getChain();
					} else {
						var abortError = "Velocity: First argument (" + propertiesMap + ") was not a property map, a known action, or a registered redirect. Aborting.";

						if (promiseData.promise) {
							promiseData.rejecter(new Error(abortError));
						} else if (window.console) {
							console.log(abortError);
						}

						return getChain();
					}
			}

			/**************************
			 Call-Wide Variables
			 **************************/

			/* A container for CSS unit conversion ratios (e.g. %, rem, and em ==> px) that is used to cache ratios across all elements
			 being animated in a single Velocity call. Calculating unit ratios necessitates DOM querying and updating, and is therefore
			 avoided (via caching) wherever possible. This container is call-wide instead of page-wide to avoid the risk of using stale
			 conversion metrics across Velocity animations that are not immediately consecutively chained. */
			var callUnitConversionData = {
				lastParent: null,
				lastPosition: null,
				lastFontSize: null,
				lastPercentToPxWidth: null,
				lastPercentToPxHeight: null,
				lastEmToPx: null,
				remToPx: null,
				vwToPx: null,
				vhToPx: null
			};

			/* A container for all the ensuing tween data and metadata associated with this call. This container gets pushed to the page-wide
			 Velocity.State.calls array that is processed during animation ticking. */
			var call = [];

			/************************
			 Element Processing
			 ************************/

			/* Element processing consists of three parts -- data processing that cannot go stale and data processing that *can* go stale (i.e. third-party style modifications):
			 1) Pre-Queueing: Element-wide variables, including the element's data storage, are instantiated. Call options are prepared. If triggered, the Stop action is executed.
			 2) Queueing: The logic that runs once this call has reached its point of execution in the element's $.queue() stack. Most logic is placed here to avoid risking it becoming stale.
			 3) Pushing: Consolidation of the tween data followed by its push onto the global in-progress calls container.
			 `elementArrayIndex` allows passing index of the element in the original array to value functions.
			 If `elementsIndex` were used instead the index would be determined by the elements' per-element queue.
			 */
			function processElement(element, elementArrayIndex) {

				/*************************
				 Part I: Pre-Queueing
				 *************************/

				/***************************
				 Element-Wide Variables
				 ***************************/

				var /* The runtime opts object is the extension of the current call's options and Velocity's page-wide option defaults. */
						opts = $.extend({}, Velocity.defaults, options),
						/* A container for the processed data associated with each property in the propertyMap.
						 (Each property in the map produces its own "tween".) */
						tweensContainer = {},
						elementUnitConversionData;

				/******************
				 Element Init
				 ******************/

				if (Data(element) === undefined) {
					Velocity.init(element);
				}

				/******************
				 Option: Delay
				 ******************/

				/* Since queue:false doesn't respect the item's existing queue, we avoid injecting its delay here (it's set later on). */
				/* Note: Velocity rolls its own delay function since jQuery doesn't have a utility alias for $.fn.delay()
				 (and thus requires jQuery element creation, which we avoid since its overhead includes DOM querying). */
				if (parseFloat(opts.delay) && opts.queue !== false) {
					$.queue(element, opts.queue, function(next, clearQueue) {
						if (clearQueue === true) {
							/* Do not continue with animation queueing. */
							return true;
						}

						/* This is a flag used to indicate to the upcoming completeCall() function that this queue entry was initiated by Velocity. See completeCall() for further details. */
						Velocity.velocityQueueEntryFlag = true;

						/* The ensuing queue item (which is assigned to the "next" argument that $.queue() automatically passes in) will be triggered after a setTimeout delay.
						 The setTimeout is stored so that it can be subjected to clearTimeout() if this animation is prematurely stopped via Velocity's "stop" command, and
						 delayBegin/delayTime is used to ensure we can "pause" and "resume" a tween that is still mid-delay. */

						/* Temporarily store delayed elements to facilite access for global pause/resume */
						var callIndex = Velocity.State.delayedElements.count++;
						Velocity.State.delayedElements[callIndex] = element;

						var delayComplete = (function(index) {
							return function() {
								/* Clear the temporary element */
								Velocity.State.delayedElements[index] = false;

								/* Finally, issue the call */
								next();
							};
						})(callIndex);


						Data(element).delayBegin = (new Date()).getTime();
						Data(element).delay = parseFloat(opts.delay);
						Data(element).delayTimer = {
							setTimeout: setTimeout(next, parseFloat(opts.delay)),
							next: delayComplete
						};
					});
				}

				/*********************
				 Option: Duration
				 *********************/

				/* Support for jQuery's named durations. */
				switch (opts.duration.toString().toLowerCase()) {
					case "fast":
						opts.duration = 200;
						break;

					case "normal":
						opts.duration = DURATION_DEFAULT;
						break;

					case "slow":
						opts.duration = 600;
						break;

					default:
						/* Remove the potential "ms" suffix and default to 1 if the user is attempting to set a duration of 0 (in order to produce an immediate style change). */
						opts.duration = parseFloat(opts.duration) || 1;
				}

				/************************
				 Global Option: Mock
				 ************************/

				if (Velocity.mock !== false) {
					/* In mock mode, all animations are forced to 1ms so that they occur immediately upon the next rAF tick.
					 Alternatively, a multiplier can be passed in to time remap all delays and durations. */
					if (Velocity.mock === true) {
						opts.duration = opts.delay = 1;
					} else {
						opts.duration *= parseFloat(Velocity.mock) || 1;
						opts.delay *= parseFloat(Velocity.mock) || 1;
					}
				}

				/*******************
				 Option: Easing
				 *******************/

				opts.easing = getEasing(opts.easing, opts.duration);

				/**********************
				 Option: Callbacks
				 **********************/

				/* Callbacks must functions. Otherwise, default to null. */
				if (opts.begin && !Type.isFunction(opts.begin)) {
					opts.begin = null;
				}

				if (opts.progress && !Type.isFunction(opts.progress)) {
					opts.progress = null;
				}

				if (opts.complete && !Type.isFunction(opts.complete)) {
					opts.complete = null;
				}

				/*********************************
				 Option: Display & Visibility
				 *********************************/

				/* Refer to Velocity's documentation (VelocityJS.org/#displayAndVisibility) for a description of the display and visibility options' behavior. */
				/* Note: We strictly check for undefined instead of falsiness because display accepts an empty string value. */
				if (opts.display !== undefined && opts.display !== null) {
					opts.display = opts.display.toString().toLowerCase();

					/* Users can pass in a special "auto" value to instruct Velocity to set the element to its default display value. */
					if (opts.display === "auto") {
						opts.display = Velocity.CSS.Values.getDisplayType(element);
					}
				}

				if (opts.visibility !== undefined && opts.visibility !== null) {
					opts.visibility = opts.visibility.toString().toLowerCase();
				}

				/**********************
				 Option: mobileHA
				 **********************/

				/* When set to true, and if this is a mobile device, mobileHA automatically enables hardware acceleration (via a null transform hack)
				 on animating elements. HA is removed from the element at the completion of its animation. */
				/* Note: Android Gingerbread doesn't support HA. If a null transform hack (mobileHA) is in fact set, it will prevent other tranform subproperties from taking effect. */
				/* Note: You can read more about the use of mobileHA in Velocity's documentation: VelocityJS.org/#mobileHA. */
				opts.mobileHA = (opts.mobileHA && Velocity.State.isMobile && !Velocity.State.isGingerbread);

				/***********************
				 Part II: Queueing
				 ***********************/

				/* When a set of elements is targeted by a Velocity call, the set is broken up and each element has the current Velocity call individually queued onto it.
				 In this way, each element's existing queue is respected; some elements may already be animating and accordingly should not have this current Velocity call triggered immediately. */
				/* In each queue, tween data is processed for each animating property then pushed onto the call-wide calls array. When the last element in the set has had its tweens processed,
				 the call array is pushed to Velocity.State.calls for live processing by the requestAnimationFrame tick. */
				function buildQueue(next) {
					var data, lastTweensContainer;

					/*******************
					 Option: Begin
					 *******************/

					/* The begin callback is fired once per call -- not once per elemenet -- and is passed the full raw DOM element set as both its context and its first argument. */
					if (opts.begin && elementsIndex === 0) {
						/* We throw callbacks in a setTimeout so that thrown errors don't halt the execution of Velocity itself. */
						try {
							opts.begin.call(elements, elements);
						} catch (error) {
							setTimeout(function() {
								throw error;
							}, 1);
						}
					}

					/*****************************************
					 Tween Data Construction (for Scroll)
					 *****************************************/

					/* Note: In order to be subjected to chaining and animation options, scroll's tweening is routed through Velocity as if it were a standard CSS property animation. */
					if (action === "scroll") {
						/* The scroll action uniquely takes an optional "offset" option -- specified in pixels -- that offsets the targeted scroll position. */
						var scrollDirection = (/^x$/i.test(opts.axis) ? "Left" : "Top"),
								scrollOffset = parseFloat(opts.offset) || 0,
								scrollPositionCurrent,
								scrollPositionCurrentAlternate,
								scrollPositionEnd;

						/* Scroll also uniquely takes an optional "container" option, which indicates the parent element that should be scrolled --
						 as opposed to the browser window itself. This is useful for scrolling toward an element that's inside an overflowing parent element. */
						if (opts.container) {
							/* Ensure that either a jQuery object or a raw DOM element was passed in. */
							if (Type.isWrapped(opts.container) || Type.isNode(opts.container)) {
								/* Extract the raw DOM element from the jQuery wrapper. */
								opts.container = opts.container[0] || opts.container;
								/* Note: Unlike other properties in Velocity, the browser's scroll position is never cached since it so frequently changes
								 (due to the user's natural interaction with the page). */
								scrollPositionCurrent = opts.container["scroll" + scrollDirection]; /* GET */

								/* $.position() values are relative to the container's currently viewable area (without taking into account the container's true dimensions
								 -- say, for example, if the container was not overflowing). Thus, the scroll end value is the sum of the child element's position *and*
								 the scroll container's current scroll position. */
								scrollPositionEnd = (scrollPositionCurrent + $(element).position()[scrollDirection.toLowerCase()]) + scrollOffset; /* GET */
								/* If a value other than a jQuery object or a raw DOM element was passed in, default to null so that this option is ignored. */
							} else {
								opts.container = null;
							}
						} else {
							/* If the window itself is being scrolled -- not a containing element -- perform a live scroll position lookup using
							 the appropriate cached property names (which differ based on browser type). */
							scrollPositionCurrent = Velocity.State.scrollAnchor[Velocity.State["scrollProperty" + scrollDirection]]; /* GET */
							/* When scrolling the browser window, cache the alternate axis's current value since window.scrollTo() doesn't let us change only one value at a time. */
							scrollPositionCurrentAlternate = Velocity.State.scrollAnchor[Velocity.State["scrollProperty" + (scrollDirection === "Left" ? "Top" : "Left")]]; /* GET */

							/* Unlike $.position(), $.offset() values are relative to the browser window's true dimensions -- not merely its currently viewable area --
							 and therefore end values do not need to be compounded onto current values. */
							scrollPositionEnd = $(element).offset()[scrollDirection.toLowerCase()] + scrollOffset; /* GET */
						}

						/* Since there's only one format that scroll's associated tweensContainer can take, we create it manually. */
						tweensContainer = {
							scroll: {
								rootPropertyValue: false,
								startValue: scrollPositionCurrent,
								currentValue: scrollPositionCurrent,
								endValue: scrollPositionEnd,
								unitType: "",
								easing: opts.easing,
								scrollData: {
									container: opts.container,
									direction: scrollDirection,
									alternateValue: scrollPositionCurrentAlternate
								}
							},
							element: element
						};

						if (Velocity.debug) {
							console.log("tweensContainer (scroll): ", tweensContainer.scroll, element);
						}

						/******************************************
						 Tween Data Construction (for Reverse)
						 ******************************************/

						/* Reverse acts like a "start" action in that a property map is animated toward. The only difference is
						 that the property map used for reverse is the inverse of the map used in the previous call. Thus, we manipulate
						 the previous call to construct our new map: use the previous map's end values as our new map's start values. Copy over all other data. */
						/* Note: Reverse can be directly called via the "reverse" parameter, or it can be indirectly triggered via the loop option. (Loops are composed of multiple reverses.) */
						/* Note: Reverse calls do not need to be consecutively chained onto a currently-animating element in order to operate on cached values;
						 there is no harm to reverse being called on a potentially stale data cache since reverse's behavior is simply defined
						 as reverting to the element's values as they were prior to the previous *Velocity* call. */
					} else if (action === "reverse") {
						data = Data(element);

						/* Abort if there is no prior animation data to reverse to. */
						if (!data) {
							return;
						}

						if (!data.tweensContainer) {
							/* Dequeue the element so that this queue entry releases itself immediately, allowing subsequent queue entries to run. */
							$.dequeue(element, opts.queue);

							return;
						} else {
							/*********************
							 Options Parsing
							 *********************/

							/* If the element was hidden via the display option in the previous call,
							 revert display to "auto" prior to reversal so that the element is visible again. */
							if (data.opts.display === "none") {
								data.opts.display = "auto";
							}

							if (data.opts.visibility === "hidden") {
								data.opts.visibility = "visible";
							}

							/* If the loop option was set in the previous call, disable it so that "reverse" calls aren't recursively generated.
							 Further, remove the previous call's callback options; typically, users do not want these to be refired. */
							data.opts.loop = false;
							data.opts.begin = null;
							data.opts.complete = null;

							/* Since we're extending an opts object that has already been extended with the defaults options object,
							 we remove non-explicitly-defined properties that are auto-assigned values. */
							if (!options.easing) {
								delete opts.easing;
							}

							if (!options.duration) {
								delete opts.duration;
							}

							/* The opts object used for reversal is an extension of the options object optionally passed into this
							 reverse call plus the options used in the previous Velocity call. */
							opts = $.extend({}, data.opts, opts);

							/*************************************
							 Tweens Container Reconstruction
							 *************************************/

							/* Create a deepy copy (indicated via the true flag) of the previous call's tweensContainer. */
							lastTweensContainer = $.extend(true, {}, data ? data.tweensContainer : null);

							/* Manipulate the previous tweensContainer by replacing its end values and currentValues with its start values. */
							for (var lastTween in lastTweensContainer) {
								/* In addition to tween data, tweensContainers contain an element property that we ignore here. */
								if (lastTweensContainer.hasOwnProperty(lastTween) && lastTween !== "element") {
									var lastStartValue = lastTweensContainer[lastTween].startValue;

									lastTweensContainer[lastTween].startValue = lastTweensContainer[lastTween].currentValue = lastTweensContainer[lastTween].endValue;
									lastTweensContainer[lastTween].endValue = lastStartValue;

									/* Easing is the only option that embeds into the individual tween data (since it can be defined on a per-property basis).
									 Accordingly, every property's easing value must be updated when an options object is passed in with a reverse call.
									 The side effect of this extensibility is that all per-property easing values are forcefully reset to the new value. */
									if (!Type.isEmptyObject(options)) {
										lastTweensContainer[lastTween].easing = opts.easing;
									}

									if (Velocity.debug) {
										console.log("reverse tweensContainer (" + lastTween + "): " + JSON.stringify(lastTweensContainer[lastTween]), element);
									}
								}
							}

							tweensContainer = lastTweensContainer;
						}

						/*****************************************
						 Tween Data Construction (for Start)
						 *****************************************/

					} else if (action === "start") {

						/*************************
						 Value Transferring
						 *************************/

						/* If this queue entry follows a previous Velocity-initiated queue entry *and* if this entry was created
						 while the element was in the process of being animated by Velocity, then this current call is safe to use
						 the end values from the prior call as its start values. Velocity attempts to perform this value transfer
						 process whenever possible in order to avoid requerying the DOM. */
						/* If values aren't transferred from a prior call and start values were not forcefed by the user (more on this below),
						 then the DOM is queried for the element's current values as a last resort. */
						/* Note: Conversely, animation reversal (and looping) *always* perform inter-call value transfers; they never requery the DOM. */

						data = Data(element);

						/* The per-element isAnimating flag is used to indicate whether it's safe (i.e. the data isn't stale)
						 to transfer over end values to use as start values. If it's set to true and there is a previous
						 Velocity call to pull values from, do so. */
						if (data && data.tweensContainer && data.isAnimating === true) {
							lastTweensContainer = data.tweensContainer;
						}

						/***************************
						 Tween Data Calculation
						 ***************************/

						/* This function parses property data and defaults endValue, easing, and startValue as appropriate. */
						/* Property map values can either take the form of 1) a single value representing the end value,
						 or 2) an array in the form of [ endValue, [, easing] [, startValue] ].
						 The optional third parameter is a forcefed startValue to be used instead of querying the DOM for
						 the element's current value. Read Velocity's docmentation to learn more about forcefeeding: VelocityJS.org/#forcefeeding */
						var parsePropertyValue = function(valueData, skipResolvingEasing) {
							var endValue, easing, startValue;

							/* If we have a function as the main argument then resolve it first, in case it returns an array that needs to be split */
							if (Type.isFunction(valueData)) {
								valueData = valueData.call(element, elementArrayIndex, elementsLength);
							}

							/* Handle the array format, which can be structured as one of three potential overloads:
							 A) [ endValue, easing, startValue ], B) [ endValue, easing ], or C) [ endValue, startValue ] */
							if (Type.isArray(valueData)) {
								/* endValue is always the first item in the array. Don't bother validating endValue's value now
								 since the ensuing property cycling logic does that. */
								endValue = valueData[0];

								/* Two-item array format: If the second item is a number, function, or hex string, treat it as a
								 start value since easings can only be non-hex strings or arrays. */
								if ((!Type.isArray(valueData[1]) && /^[\d-]/.test(valueData[1])) || Type.isFunction(valueData[1]) || CSS.RegEx.isHex.test(valueData[1])) {
									startValue = valueData[1];
									/* Two or three-item array: If the second item is a non-hex string easing name or an array, treat it as an easing. */
								} else if ((Type.isString(valueData[1]) && !CSS.RegEx.isHex.test(valueData[1]) && Velocity.Easings[valueData[1]]) || Type.isArray(valueData[1])) {
									easing = skipResolvingEasing ? valueData[1] : getEasing(valueData[1], opts.duration);

									/* Don't bother validating startValue's value now since the ensuing property cycling logic inherently does that. */
									startValue = valueData[2];
								} else {
									startValue = valueData[1] || valueData[2];
								}
								/* Handle the single-value format. */
							} else {
								endValue = valueData;
							}

							/* Default to the call's easing if a per-property easing type was not defined. */
							if (!skipResolvingEasing) {
								easing = easing || opts.easing;
							}

							/* If functions were passed in as values, pass the function the current element as its context,
							 plus the element's index and the element set's size as arguments. Then, assign the returned value. */
							if (Type.isFunction(endValue)) {
								endValue = endValue.call(element, elementArrayIndex, elementsLength);
							}

							if (Type.isFunction(startValue)) {
								startValue = startValue.call(element, elementArrayIndex, elementsLength);
							}

							/* Allow startValue to be left as undefined to indicate to the ensuing code that its value was not forcefed. */
							return [endValue || 0, easing, startValue];
						};

						var fixPropertyValue = function(property, valueData) {
							/* In case this property is a hook, there are circumstances where we will intend to work on the hook's root property and not the hooked subproperty. */
							var rootProperty = CSS.Hooks.getRoot(property),
									rootPropertyValue = false,
									/* Parse out endValue, easing, and startValue from the property's data. */
									endValue = valueData[0],
									easing = valueData[1],
									startValue = valueData[2],
									pattern;

							/**************************
							 Start Value Sourcing
							 **************************/

							/* Other than for the dummy tween property, properties that are not supported by the browser (and do not have an associated normalization) will
							 inherently produce no style changes when set, so they are skipped in order to decrease animation tick overhead.
							 Property support is determined via prefixCheck(), which returns a false flag when no supported is detected. */
							/* Note: Since SVG elements have some of their properties directly applied as HTML attributes,
							 there is no way to check for their explicit browser support, and so we skip skip this check for them. */
							if ((!data || !data.isSVG) && rootProperty !== "tween" && CSS.Names.prefixCheck(rootProperty)[1] === false && CSS.Normalizations.registered[rootProperty] === undefined) {
								if (Velocity.debug) {
									console.log("Skipping [" + rootProperty + "] due to a lack of browser support.");
								}
								return;
							}

							/* If the display option is being set to a non-"none" (e.g. "block") and opacity (filter on IE<=8) is being
							 animated to an endValue of non-zero, the user's intention is to fade in from invisible, thus we forcefeed opacity
							 a startValue of 0 if its startValue hasn't already been sourced by value transferring or prior forcefeeding. */
							if (((opts.display !== undefined && opts.display !== null && opts.display !== "none") || (opts.visibility !== undefined && opts.visibility !== "hidden")) && /opacity|filter/.test(property) && !startValue && endValue !== 0) {
								startValue = 0;
							}

							/* If values have been transferred from the previous Velocity call, extract the endValue and rootPropertyValue
							 for all of the current call's properties that were *also* animated in the previous call. */
							/* Note: Value transferring can optionally be disabled by the user via the _cacheValues option. */
							if (opts._cacheValues && lastTweensContainer && lastTweensContainer[property]) {
								if (startValue === undefined) {
									startValue = lastTweensContainer[property].endValue + lastTweensContainer[property].unitType;
								}

								/* The previous call's rootPropertyValue is extracted from the element's data cache since that's the
								 instance of rootPropertyValue that gets freshly updated by the tweening process, whereas the rootPropertyValue
								 attached to the incoming lastTweensContainer is equal to the root property's value prior to any tweening. */
								rootPropertyValue = data.rootPropertyValueCache[rootProperty];
								/* If values were not transferred from a previous Velocity call, query the DOM as needed. */
							} else {
								/* Handle hooked properties. */
								if (CSS.Hooks.registered[property]) {
									if (startValue === undefined) {
										rootPropertyValue = CSS.getPropertyValue(element, rootProperty); /* GET */
										/* Note: The following getPropertyValue() call does not actually trigger a DOM query;
										 getPropertyValue() will extract the hook from rootPropertyValue. */
										startValue = CSS.getPropertyValue(element, property, rootPropertyValue);
										/* If startValue is already defined via forcefeeding, do not query the DOM for the root property's value;
										 just grab rootProperty's zero-value template from CSS.Hooks. This overwrites the element's actual
										 root property value (if one is set), but this is acceptable since the primary reason users forcefeed is
										 to avoid DOM queries, and thus we likewise avoid querying the DOM for the root property's value. */
									} else {
										/* Grab this hook's zero-value template, e.g. "0px 0px 0px black". */
										rootPropertyValue = CSS.Hooks.templates[rootProperty][1];
									}
									/* Handle non-hooked properties that haven't already been defined via forcefeeding. */
								} else if (startValue === undefined) {
									startValue = CSS.getPropertyValue(element, property); /* GET */
								}
							}

							/**************************
							 Value Data Extraction
							 **************************/

							var separatedValue,
									endValueUnitType,
									startValueUnitType,
									operator = false;

							/* Separates a property value into its numeric value and its unit type. */
							var separateValue = function(property, value) {
								var unitType,
										numericValue;

								numericValue = (value || "0")
										.toString()
										.toLowerCase()
										/* Match the unit type at the end of the value. */
										.replace(/[%A-z]+$/, function(match) {
											/* Grab the unit type. */
											unitType = match;

											/* Strip the unit type off of value. */
											return "";
										});

								/* If no unit type was supplied, assign one that is appropriate for this property (e.g. "deg" for rotateZ or "px" for width). */
								if (!unitType) {
									unitType = CSS.Values.getUnitType(property);
								}

								return [numericValue, unitType];
							};

							if (startValue !== endValue && Type.isString(startValue) && Type.isString(endValue)) {
								pattern = "";
								var iStart = 0, // index in startValue
										iEnd = 0, // index in endValue
										aStart = [], // array of startValue numbers
										aEnd = [], // array of endValue numbers
										inCalc = 0, // Keep track of being inside a "calc()" so we don't duplicate it
										inRGB = 0, // Keep track of being inside an RGB as we can't use fractional values
										inRGBA = 0; // Keep track of being inside an RGBA as we must pass fractional for the alpha channel

								startValue = CSS.Hooks.fixColors(startValue);
								endValue = CSS.Hooks.fixColors(endValue);
								while (iStart < startValue.length && iEnd < endValue.length) {
									var cStart = startValue[iStart],
											cEnd = endValue[iEnd];

									if (/[\d\.-]/.test(cStart) && /[\d\.-]/.test(cEnd)) {
										var tStart = cStart, // temporary character buffer
												tEnd = cEnd, // temporary character buffer
												dotStart = ".", // Make sure we can only ever match a single dot in a decimal
												dotEnd = "."; // Make sure we can only ever match a single dot in a decimal

										while (++iStart < startValue.length) {
											cStart = startValue[iStart];
											if (cStart === dotStart) {
												dotStart = ".."; // Can never match two characters
											} else if (!/\d/.test(cStart)) {
												break;
											}
											tStart += cStart;
										}
										while (++iEnd < endValue.length) {
											cEnd = endValue[iEnd];
											if (cEnd === dotEnd) {
												dotEnd = ".."; // Can never match two characters
											} else if (!/\d/.test(cEnd)) {
												break;
											}
											tEnd += cEnd;
										}
										var uStart = CSS.Hooks.getUnit(startValue, iStart), // temporary unit type
												uEnd = CSS.Hooks.getUnit(endValue, iEnd); // temporary unit type

										iStart += uStart.length;
										iEnd += uEnd.length;
										if (uStart === uEnd) {
											// Same units
											if (tStart === tEnd) {
												// Same numbers, so just copy over
												pattern += tStart + uStart;
											} else {
												// Different numbers, so store them
												pattern += "{" + aStart.length + (inRGB ? "!" : "") + "}" + uStart;
												aStart.push(parseFloat(tStart));
												aEnd.push(parseFloat(tEnd));
											}
										} else {
											// Different units, so put into a "calc(from + to)" and animate each side to/from zero
											var nStart = parseFloat(tStart),
													nEnd = parseFloat(tEnd);

											pattern += (inCalc < 5 ? "calc" : "") + "("
													+ (nStart ? "{" + aStart.length + (inRGB ? "!" : "") + "}" : "0") + uStart
													+ " + "
													+ (nEnd ? "{" + (aStart.length + (nStart ? 1 : 0)) + (inRGB ? "!" : "") + "}" : "0") + uEnd
													+ ")";
											if (nStart) {
												aStart.push(nStart);
												aEnd.push(0);
											}
											if (nEnd) {
												aStart.push(0);
												aEnd.push(nEnd);
											}
										}
									} else if (cStart === cEnd) {
										pattern += cStart;
										iStart++;
										iEnd++;
										// Keep track of being inside a calc()
										if (inCalc === 0 && cStart === "c"
												|| inCalc === 1 && cStart === "a"
												|| inCalc === 2 && cStart === "l"
												|| inCalc === 3 && cStart === "c"
												|| inCalc >= 4 && cStart === "("
												) {
											inCalc++;
										} else if ((inCalc && inCalc < 5)
												|| inCalc >= 4 && cStart === ")" && --inCalc < 5) {
											inCalc = 0;
										}
										// Keep track of being inside an rgb() / rgba()
										if (inRGB === 0 && cStart === "r"
												|| inRGB === 1 && cStart === "g"
												|| inRGB === 2 && cStart === "b"
												|| inRGB === 3 && cStart === "a"
												|| inRGB >= 3 && cStart === "("
												) {
											if (inRGB === 3 && cStart === "a") {
												inRGBA = 1;
											}
											inRGB++;
										} else if (inRGBA && cStart === ",") {
											if (++inRGBA > 3) {
												inRGB = inRGBA = 0;
											}
										} else if ((inRGBA && inRGB < (inRGBA ? 5 : 4))
												|| inRGB >= (inRGBA ? 4 : 3) && cStart === ")" && --inRGB < (inRGBA ? 5 : 4)) {
											inRGB = inRGBA = 0;
										}
									} else {
										inCalc = 0;
										// TODO: changing units, fixing colours
										break;
									}
								}
								if (iStart !== startValue.length || iEnd !== endValue.length) {
									if (Velocity.debug) {
										console.error("Trying to pattern match mis-matched strings [\"" + endValue + "\", \"" + startValue + "\"]");
									}
									pattern = undefined;
								}
								if (pattern) {
									if (aStart.length) {
										if (Velocity.debug) {
											console.log("Pattern found \"" + pattern + "\" -> ", aStart, aEnd, "[" + startValue + "," + endValue + "]");
										}
										startValue = aStart;
										endValue = aEnd;
										endValueUnitType = startValueUnitType = "";
									} else {
										pattern = undefined;
									}
								}
							}

							if (!pattern) {
								/* Separate startValue. */
								separatedValue = separateValue(property, startValue);
								startValue = separatedValue[0];
								startValueUnitType = separatedValue[1];

								/* Separate endValue, and extract a value operator (e.g. "+=", "-=") if one exists. */
								separatedValue = separateValue(property, endValue);
								endValue = separatedValue[0].replace(/^([+-\/*])=/, function(match, subMatch) {
									operator = subMatch;

									/* Strip the operator off of the value. */
									return "";
								});
								endValueUnitType = separatedValue[1];

								/* Parse float values from endValue and startValue. Default to 0 if NaN is returned. */
								startValue = parseFloat(startValue) || 0;
								endValue = parseFloat(endValue) || 0;

								/***************************************
								 Property-Specific Value Conversion
								 ***************************************/

								/* Custom support for properties that don't actually accept the % unit type, but where pollyfilling is trivial and relatively foolproof. */
								if (endValueUnitType === "%") {
									/* A %-value fontSize/lineHeight is relative to the parent's fontSize (as opposed to the parent's dimensions),
									 which is identical to the em unit's behavior, so we piggyback off of that. */
									if (/^(fontSize|lineHeight)$/.test(property)) {
										/* Convert % into an em decimal value. */
										endValue = endValue / 100;
										endValueUnitType = "em";
										/* For scaleX and scaleY, convert the value into its decimal format and strip off the unit type. */
									} else if (/^scale/.test(property)) {
										endValue = endValue / 100;
										endValueUnitType = "";
										/* For RGB components, take the defined percentage of 255 and strip off the unit type. */
									} else if (/(Red|Green|Blue)$/i.test(property)) {
										endValue = (endValue / 100) * 255;
										endValueUnitType = "";
									}
								}
							}

							/***************************
							 Unit Ratio Calculation
							 ***************************/

							/* When queried, the browser returns (most) CSS property values in pixels. Therefore, if an endValue with a unit type of
							 %, em, or rem is animated toward, startValue must be converted from pixels into the same unit type as endValue in order
							 for value manipulation logic (increment/decrement) to proceed. Further, if the startValue was forcefed or transferred
							 from a previous call, startValue may also not be in pixels. Unit conversion logic therefore consists of two steps:
							 1) Calculating the ratio of %/em/rem/vh/vw relative to pixels
							 2) Converting startValue into the same unit of measurement as endValue based on these ratios. */
							/* Unit conversion ratios are calculated by inserting a sibling node next to the target node, copying over its position property,
							 setting values with the target unit type then comparing the returned pixel value. */
							/* Note: Even if only one of these unit types is being animated, all unit ratios are calculated at once since the overhead
							 of batching the SETs and GETs together upfront outweights the potential overhead
							 of layout thrashing caused by re-querying for uncalculated ratios for subsequently-processed properties. */
							/* Todo: Shift this logic into the calls' first tick instance so that it's synced with RAF. */
							var calculateUnitRatios = function() {

								/************************
								 Same Ratio Checks
								 ************************/

								/* The properties below are used to determine whether the element differs sufficiently from this call's
								 previously iterated element to also differ in its unit conversion ratios. If the properties match up with those
								 of the prior element, the prior element's conversion ratios are used. Like most optimizations in Velocity,
								 this is done to minimize DOM querying. */
								var sameRatioIndicators = {
									myParent: element.parentNode || document.body, /* GET */
									position: CSS.getPropertyValue(element, "position"), /* GET */
									fontSize: CSS.getPropertyValue(element, "fontSize") /* GET */
								},
										/* Determine if the same % ratio can be used. % is based on the element's position value and its parent's width and height dimensions. */
										samePercentRatio = ((sameRatioIndicators.position === callUnitConversionData.lastPosition) && (sameRatioIndicators.myParent === callUnitConversionData.lastParent)),
										/* Determine if the same em ratio can be used. em is relative to the element's fontSize. */
										sameEmRatio = (sameRatioIndicators.fontSize === callUnitConversionData.lastFontSize);

								/* Store these ratio indicators call-wide for the next element to compare against. */
								callUnitConversionData.lastParent = sameRatioIndicators.myParent;
								callUnitConversionData.lastPosition = sameRatioIndicators.position;
								callUnitConversionData.lastFontSize = sameRatioIndicators.fontSize;

								/***************************
								 Element-Specific Units
								 ***************************/

								/* Note: IE8 rounds to the nearest pixel when returning CSS values, thus we perform conversions using a measurement
								 of 100 (instead of 1) to give our ratios a precision of at least 2 decimal values. */
								var measurement = 100,
										unitRatios = {};

								if (!sameEmRatio || !samePercentRatio) {
									var dummy = data && data.isSVG ? document.createElementNS("http://www.w3.org/2000/svg", "rect") : document.createElement("div");

									Velocity.init(dummy);
									sameRatioIndicators.myParent.appendChild(dummy);

									/* To accurately and consistently calculate conversion ratios, the element's cascaded overflow and box-sizing are stripped.
									 Similarly, since width/height can be artificially constrained by their min-/max- equivalents, these are controlled for as well. */
									/* Note: Overflow must be also be controlled for per-axis since the overflow property overwrites its per-axis values. */
									$.each(["overflow", "overflowX", "overflowY"], function(i, property) {
										Velocity.CSS.setPropertyValue(dummy, property, "hidden");
									});
									Velocity.CSS.setPropertyValue(dummy, "position", sameRatioIndicators.position);
									Velocity.CSS.setPropertyValue(dummy, "fontSize", sameRatioIndicators.fontSize);
									Velocity.CSS.setPropertyValue(dummy, "boxSizing", "content-box");

									/* width and height act as our proxy properties for measuring the horizontal and vertical % ratios. */
									$.each(["minWidth", "maxWidth", "width", "minHeight", "maxHeight", "height"], function(i, property) {
										Velocity.CSS.setPropertyValue(dummy, property, measurement + "%");
									});
									/* paddingLeft arbitrarily acts as our proxy property for the em ratio. */
									Velocity.CSS.setPropertyValue(dummy, "paddingLeft", measurement + "em");

									/* Divide the returned value by the measurement to get the ratio between 1% and 1px. Default to 1 since working with 0 can produce Infinite. */
									unitRatios.percentToPxWidth = callUnitConversionData.lastPercentToPxWidth = (parseFloat(CSS.getPropertyValue(dummy, "width", null, true)) || 1) / measurement; /* GET */
									unitRatios.percentToPxHeight = callUnitConversionData.lastPercentToPxHeight = (parseFloat(CSS.getPropertyValue(dummy, "height", null, true)) || 1) / measurement; /* GET */
									unitRatios.emToPx = callUnitConversionData.lastEmToPx = (parseFloat(CSS.getPropertyValue(dummy, "paddingLeft")) || 1) / measurement; /* GET */

									sameRatioIndicators.myParent.removeChild(dummy);
								} else {
									unitRatios.emToPx = callUnitConversionData.lastEmToPx;
									unitRatios.percentToPxWidth = callUnitConversionData.lastPercentToPxWidth;
									unitRatios.percentToPxHeight = callUnitConversionData.lastPercentToPxHeight;
								}

								/***************************
								 Element-Agnostic Units
								 ***************************/

								/* Whereas % and em ratios are determined on a per-element basis, the rem unit only needs to be checked
								 once per call since it's exclusively dependant upon document.body's fontSize. If this is the first time
								 that calculateUnitRatios() is being run during this call, remToPx will still be set to its default value of null,
								 so we calculate it now. */
								if (callUnitConversionData.remToPx === null) {
									/* Default to browsers' default fontSize of 16px in the case of 0. */
									callUnitConversionData.remToPx = parseFloat(CSS.getPropertyValue(document.body, "fontSize")) || 16; /* GET */
								}

								/* Similarly, viewport units are %-relative to the window's inner dimensions. */
								if (callUnitConversionData.vwToPx === null) {
									callUnitConversionData.vwToPx = parseFloat(window.innerWidth) / 100; /* GET */
									callUnitConversionData.vhToPx = parseFloat(window.innerHeight) / 100; /* GET */
								}

								unitRatios.remToPx = callUnitConversionData.remToPx;
								unitRatios.vwToPx = callUnitConversionData.vwToPx;
								unitRatios.vhToPx = callUnitConversionData.vhToPx;

								if (Velocity.debug >= 1) {
									console.log("Unit ratios: " + JSON.stringify(unitRatios), element);
								}
								return unitRatios;
							};

							/********************
							 Unit Conversion
							 ********************/

							/* The * and / operators, which are not passed in with an associated unit, inherently use startValue's unit. Skip value and unit conversion. */
							if (/[\/*]/.test(operator)) {
								endValueUnitType = startValueUnitType;
								/* If startValue and endValue differ in unit type, convert startValue into the same unit type as endValue so that if endValueUnitType
								 is a relative unit (%, em, rem), the values set during tweening will continue to be accurately relative even if the metrics they depend
								 on are dynamically changing during the course of the animation. Conversely, if we always normalized into px and used px for setting values, the px ratio
								 would become stale if the original unit being animated toward was relative and the underlying metrics change during the animation. */
								/* Since 0 is 0 in any unit type, no conversion is necessary when startValue is 0 -- we just start at 0 with endValueUnitType. */
							} else if ((startValueUnitType !== endValueUnitType) && startValue !== 0) {
								/* Unit conversion is also skipped when endValue is 0, but *startValueUnitType* must be used for tween values to remain accurate. */
								/* Note: Skipping unit conversion here means that if endValueUnitType was originally a relative unit, the animation won't relatively
								 match the underlying metrics if they change, but this is acceptable since we're animating toward invisibility instead of toward visibility,
								 which remains past the point of the animation's completion. */
								if (endValue === 0) {
									endValueUnitType = startValueUnitType;
								} else {
									/* By this point, we cannot avoid unit conversion (it's undesirable since it causes layout thrashing).
									 If we haven't already, we trigger calculateUnitRatios(), which runs once per element per call. */
									elementUnitConversionData = elementUnitConversionData || calculateUnitRatios();

									/* The following RegEx matches CSS properties that have their % values measured relative to the x-axis. */
									/* Note: W3C spec mandates that all of margin and padding's properties (even top and bottom) are %-relative to the *width* of the parent element. */
									var axis = (/margin|padding|left|right|width|text|word|letter/i.test(property) || /X$/.test(property) || property === "x") ? "x" : "y";

									/* In order to avoid generating n^2 bespoke conversion functions, unit conversion is a two-step process:
									 1) Convert startValue into pixels. 2) Convert this new pixel value into endValue's unit type. */
									switch (startValueUnitType) {
										case "%":
											/* Note: translateX and translateY are the only properties that are %-relative to an element's own dimensions -- not its parent's dimensions.
											 Velocity does not include a special conversion process to account for this behavior. Therefore, animating translateX/Y from a % value
											 to a non-% value will produce an incorrect start value. Fortunately, this sort of cross-unit conversion is rarely done by users in practice. */
											startValue *= (axis === "x" ? elementUnitConversionData.percentToPxWidth : elementUnitConversionData.percentToPxHeight);
											break;

										case "px":
											/* px acts as our midpoint in the unit conversion process; do nothing. */
											break;

										default:
											startValue *= elementUnitConversionData[startValueUnitType + "ToPx"];
									}

									/* Invert the px ratios to convert into to the target unit. */
									switch (endValueUnitType) {
										case "%":
											startValue *= 1 / (axis === "x" ? elementUnitConversionData.percentToPxWidth : elementUnitConversionData.percentToPxHeight);
											break;

										case "px":
											/* startValue is already in px, do nothing; we're done. */
											break;

										default:
											startValue *= 1 / elementUnitConversionData[endValueUnitType + "ToPx"];
									}
								}
							}

							/*********************
							 Relative Values
							 *********************/

							/* Operator logic must be performed last since it requires unit-normalized start and end values. */
							/* Note: Relative *percent values* do not behave how most people think; while one would expect "+=50%"
							 to increase the property 1.5x its current value, it in fact increases the percent units in absolute terms:
							 50 points is added on top of the current % value. */
							switch (operator) {
								case "+":
									endValue = startValue + endValue;
									break;

								case "-":
									endValue = startValue - endValue;
									break;

								case "*":
									endValue = startValue * endValue;
									break;

								case "/":
									endValue = startValue / endValue;
									break;
							}

							/**************************
							 tweensContainer Push
							 **************************/

							/* Construct the per-property tween object, and push it to the element's tweensContainer. */
							tweensContainer[property] = {
								rootPropertyValue: rootPropertyValue,
								startValue: startValue,
								currentValue: startValue,
								endValue: endValue,
								unitType: endValueUnitType,
								easing: easing
							};
							if (pattern) {
								tweensContainer[property].pattern = pattern;
							}

							if (Velocity.debug) {
								console.log("tweensContainer (" + property + "): " + JSON.stringify(tweensContainer[property]), element);
							}
						};

						/* Create a tween out of each property, and append its associated data to tweensContainer. */
						for (var property in propertiesMap) {

							if (!propertiesMap.hasOwnProperty(property)) {
								continue;
							}
							/* The original property name's format must be used for the parsePropertyValue() lookup,
							 but we then use its camelCase styling to normalize it for manipulation. */
							var propertyName = CSS.Names.camelCase(property),
									valueData = parsePropertyValue(propertiesMap[property]);

							/* Find shorthand color properties that have been passed a hex string. */
							/* Would be quicker to use CSS.Lists.colors.includes() if possible */
							if (_inArray(CSS.Lists.colors, propertyName)) {
								/* Parse the value data for each shorthand. */
								var endValue = valueData[0],
										easing = valueData[1],
										startValue = valueData[2];

								if (CSS.RegEx.isHex.test(endValue)) {
									/* Convert the hex strings into their RGB component arrays. */
									var colorComponents = ["Red", "Green", "Blue"],
											endValueRGB = CSS.Values.hexToRgb(endValue),
											startValueRGB = startValue ? CSS.Values.hexToRgb(startValue) : undefined;

									/* Inject the RGB component tweens into propertiesMap. */
									for (var i = 0; i < colorComponents.length; i++) {
										var dataArray = [endValueRGB[i]];

										if (easing) {
											dataArray.push(easing);
										}

										if (startValueRGB !== undefined) {
											dataArray.push(startValueRGB[i]);
										}

										fixPropertyValue(propertyName + colorComponents[i], dataArray);
									}
									/* If we have replaced a shortcut color value then don't update the standard property name */
									continue;
								}
							}
							fixPropertyValue(propertyName, valueData);
						}

						/* Along with its property data, store a reference to the element itself onto tweensContainer. */
						tweensContainer.element = element;
					}

					/*****************
					 Call Push
					 *****************/

					/* Note: tweensContainer can be empty if all of the properties in this call's property map were skipped due to not
					 being supported by the browser. The element property is used for checking that the tweensContainer has been appended to. */
					if (tweensContainer.element) {
						/* Apply the "velocity-animating" indicator class. */
						CSS.Values.addClass(element, "velocity-animating");

						/* The call array houses the tweensContainers for each element being animated in the current call. */
						call.push(tweensContainer);

						data = Data(element);

						if (data) {
							/* Store the tweensContainer and options if we're working on the default effects queue, so that they can be used by the reverse command. */
							if (opts.queue === "") {

								data.tweensContainer = tweensContainer;
								data.opts = opts;
							}

							/* Switch on the element's animating flag. */
							data.isAnimating = true;
						}

						/* Once the final element in this call's element set has been processed, push the call array onto
						 Velocity.State.calls for the animation tick to immediately begin processing. */
						if (elementsIndex === elementsLength - 1) {
							/* Add the current call plus its associated metadata (the element set and the call's options) onto the global call container.
							 Anything on this call container is subjected to tick() processing. */
							Velocity.State.calls.push([call, elements, opts, null, promiseData.resolver, null, 0]);

							/* If the animation tick isn't running, start it. (Velocity shuts it off when there are no active calls to process.) */
							if (Velocity.State.isTicking === false) {
								Velocity.State.isTicking = true;

								/* Start the tick loop. */
								tick();
							}
						} else {
							elementsIndex++;
						}
					}
				}

				/* When the queue option is set to false, the call skips the element's queue and fires immediately. */
				if (opts.queue === false) {
					/* Since this buildQueue call doesn't respect the element's existing queue (which is where a delay option would have been appended),
					 we manually inject the delay property here with an explicit setTimeout. */
					if (opts.delay) {

						/* Temporarily store delayed elements to facilitate access for global pause/resume */
						var callIndex = Velocity.State.delayedElements.count++;
						Velocity.State.delayedElements[callIndex] = element;

						var delayComplete = (function(index) {
							return function() {
								/* Clear the temporary element */
								Velocity.State.delayedElements[index] = false;

								/* Finally, issue the call */
								buildQueue();
							};
						})(callIndex);

						Data(element).delayBegin = (new Date()).getTime();
						Data(element).delay = parseFloat(opts.delay);
						Data(element).delayTimer = {
							setTimeout: setTimeout(buildQueue, parseFloat(opts.delay)),
							next: delayComplete
						};
					} else {
						buildQueue();
					}
					/* Otherwise, the call undergoes element queueing as normal. */
					/* Note: To interoperate with jQuery, Velocity uses jQuery's own $.queue() stack for queuing logic. */
				} else {
					$.queue(element, opts.queue, function(next, clearQueue) {
						/* If the clearQueue flag was passed in by the stop command, resolve this call's promise. (Promises can only be resolved once,
						 so it's fine if this is repeatedly triggered for each element in the associated call.) */
						if (clearQueue === true) {
							if (promiseData.promise) {
								promiseData.resolver(elements);
							}

							/* Do not continue with animation queueing. */
							return true;
						}

						/* This flag indicates to the upcoming completeCall() function that this queue entry was initiated by Velocity.
						 See completeCall() for further details. */
						Velocity.velocityQueueEntryFlag = true;

						buildQueue(next);
					});
				}

				/*********************
				 Auto-Dequeuing
				 *********************/

				/* As per jQuery's $.queue() behavior, to fire the first non-custom-queue entry on an element, the element
				 must be dequeued if its queue stack consists *solely* of the current call. (This can be determined by checking
				 for the "inprogress" item that jQuery prepends to active queue stack arrays.) Regardless, whenever the element's
				 queue is further appended with additional items -- including $.delay()'s or even $.animate() calls, the queue's
				 first entry is automatically fired. This behavior contrasts that of custom queues, which never auto-fire. */
				/* Note: When an element set is being subjected to a non-parallel Velocity call, the animation will not begin until
				 each one of the elements in the set has reached the end of its individually pre-existing queue chain. */
				/* Note: Unfortunately, most people don't fully grasp jQuery's powerful, yet quirky, $.queue() function.
				 Lean more here: http://stackoverflow.com/questions/1058158/can-somebody-explain-jquery-queue-to-me */
				if ((opts.queue === "" || opts.queue === "fx") && $.queue(element)[0] !== "inprogress") {
					$.dequeue(element);
				}
			}

			/**************************
			 Element Set Iteration
			 **************************/

			/* If the "nodeType" property exists on the elements variable, we're animating a single element.
			 Place it in an array so that $.each() can iterate over it. */
			$.each(elements, function(i, element) {
				/* Ensure each element in a set has a nodeType (is a real element) to avoid throwing errors. */
				if (Type.isNode(element)) {
					processElement(element, i);
				}
			});

			/******************
			 Option: Loop
			 ******************/

			/* The loop option accepts an integer indicating how many times the element should loop between the values in the
			 current call's properties map and the element's property values prior to this call. */
			/* Note: The loop option's logic is performed here -- after element processing -- because the current call needs
			 to undergo its queue insertion prior to the loop option generating its series of constituent "reverse" calls,
			 which chain after the current call. Two reverse calls (two "alternations") constitute one loop. */
			opts = $.extend({}, Velocity.defaults, options);
			opts.loop = parseInt(opts.loop, 10);
			var reverseCallsCount = (opts.loop * 2) - 1;

			if (opts.loop) {
				/* Double the loop count to convert it into its appropriate number of "reverse" calls.
				 Subtract 1 from the resulting value since the current call is included in the total alternation count. */
				for (var x = 0; x < reverseCallsCount; x++) {
					/* Since the logic for the reverse action occurs inside Queueing and therefore this call's options object
					 isn't parsed until then as well, the current call's delay option must be explicitly passed into the reverse
					 call so that the delay logic that occurs inside *Pre-Queueing* can process it. */
					var reverseOptions = {
						delay: opts.delay,
						progress: opts.progress
					};

					/* If a complete callback was passed into this call, transfer it to the loop redirect's final "reverse" call
					 so that it's triggered when the entire redirect is complete (and not when the very first animation is complete). */
					if (x === reverseCallsCount - 1) {
						reverseOptions.display = opts.display;
						reverseOptions.visibility = opts.visibility;
						reverseOptions.complete = opts.complete;
					}

					animate(elements, "reverse", reverseOptions);
				}
			}

			/***************
			 Chaining
			 ***************/

			/* Return the elements back to the call chain, with wrapped elements taking precedence in case Velocity was called via the $.fn. extension. */
			return getChain();
		};

		/* Turn Velocity into the animation function, extended with the pre-existing Velocity object. */
		Velocity = $.extend(animate, Velocity);
		/* For legacy support, also expose the literal animate method. */
		Velocity.animate = animate;

		/**************
		 Timing
		 **************/

		/* Ticker function. */
		var ticker = window.requestAnimationFrame || rAFShim;

		/* Inactive browser tabs pause rAF, which results in all active animations immediately sprinting to their completion states when the tab refocuses.
		 To get around this, we dynamically switch rAF to setTimeout (which the browser *doesn't* pause) when the tab loses focus. We skip this for mobile
		 devices to avoid wasting battery power on inactive tabs. */
		/* Note: Tab focus detection doesn't work on older versions of IE, but that's okay since they don't support rAF to begin with. */
		if (!Velocity.State.isMobile && document.hidden !== undefined) {
			var updateTicker = function() {
				/* Reassign the rAF function (which the global tick() function uses) based on the tab's focus state. */
				if (document.hidden) {
					ticker = function(callback) {
						/* The tick function needs a truthy first argument in order to pass its internal timestamp check. */
						return setTimeout(function() {
							callback(true);
						}, 16);
					};

					/* The rAF loop has been paused by the browser, so we manually restart the tick. */
					tick();
				} else {
					ticker = window.requestAnimationFrame || rAFShim;
				}
			};

			/* Page could be sitting in the background at this time (i.e. opened as new tab) so making sure we use correct ticker from the start */
			updateTicker();

			/* And then run check again every time visibility changes */
			document.addEventListener("visibilitychange", updateTicker);
		}

		/************
		 Tick
		 ************/

		/* Note: All calls to Velocity are pushed to the Velocity.State.calls array, which is fully iterated through upon each tick. */
		function tick(timestamp) {
			/* An empty timestamp argument indicates that this is the first tick occurence since ticking was turned on.
			 We leverage this metadata to fully ignore the first tick pass since RAF's initial pass is fired whenever
			 the browser's next tick sync time occurs, which results in the first elements subjected to Velocity
			 calls being animated out of sync with any elements animated immediately thereafter. In short, we ignore
			 the first RAF tick pass so that elements being immediately consecutively animated -- instead of simultaneously animated
			 by the same Velocity call -- are properly batched into the same initial RAF tick and consequently remain in sync thereafter. */
			if (timestamp) {
				/* We normally use RAF's high resolution timestamp but as it can be significantly offset when the browser is
				 under high stress we give the option for choppiness over allowing the browser to drop huge chunks of frames.
				 We use performance.now() and shim it if it doesn't exist for when the tab is hidden. */
				var timeCurrent = Velocity.timestamp && timestamp !== true ? timestamp : performance.now();

				/********************
				 Call Iteration
				 ********************/

				var callsLength = Velocity.State.calls.length;

				/* To speed up iterating over this array, it is compacted (falsey items -- calls that have completed -- are removed)
				 when its length has ballooned to a point that can impact tick performance. This only becomes necessary when animation
				 has been continuous with many elements over a long period of time; whenever all active calls are completed, completeCall() clears Velocity.State.calls. */
				if (callsLength > 10000) {
					Velocity.State.calls = compactSparseArray(Velocity.State.calls);
					callsLength = Velocity.State.calls.length;
				}

				/* Iterate through each active call. */
				for (var i = 0; i < callsLength; i++) {
					/* When a Velocity call is completed, its Velocity.State.calls entry is set to false. Continue on to the next call. */
					if (!Velocity.State.calls[i]) {
						continue;
					}

					/************************
					 Call-Wide Variables
					 ************************/

					var callContainer = Velocity.State.calls[i],
							call = callContainer[0],
							opts = callContainer[2],
							timeStart = callContainer[3],
							firstTick = !timeStart,
							tweenDummyValue = null,
							pauseObject = callContainer[5],
							millisecondsEllapsed = callContainer[6];



					/* If timeStart is undefined, then this is the first time that this call has been processed by tick().
					 We assign timeStart now so that its value is as close to the real animation start time as possible.
					 (Conversely, had timeStart been defined when this call was added to Velocity.State.calls, the delay
					 between that time and now would cause the first few frames of the tween to be skipped since
					 percentComplete is calculated relative to timeStart.) */
					/* Further, subtract 16ms (the approximate resolution of RAF) from the current time value so that the
					 first tick iteration isn't wasted by animating at 0% tween completion, which would produce the
					 same style value as the element's current value. */
					if (!timeStart) {
						timeStart = Velocity.State.calls[i][3] = timeCurrent - 16;
					}

					/* If a pause object is present, skip processing unless it has been set to resume */
					if (pauseObject) {
						if (pauseObject.resume === true) {
							/* Update the time start to accomodate the paused completion amount */
							timeStart = callContainer[3] = Math.round(timeCurrent - millisecondsEllapsed - 16);

							/* Remove pause object after processing */
							callContainer[5] = null;
						} else {
							continue;
						}
					}

					millisecondsEllapsed = callContainer[6] = timeCurrent - timeStart;

					/* The tween's completion percentage is relative to the tween's start time, not the tween's start value
					 (which would result in unpredictable tween durations since JavaScript's timers are not particularly accurate).
					 Accordingly, we ensure that percentComplete does not exceed 1. */
					var percentComplete = Math.min((millisecondsEllapsed) / opts.duration, 1);

					/**********************
					 Element Iteration
					 **********************/

					/* For every call, iterate through each of the elements in its set. */
					for (var j = 0, callLength = call.length; j < callLength; j++) {
						var tweensContainer = call[j],
								element = tweensContainer.element;

						/* Check to see if this element has been deleted midway through the animation by checking for the
						 continued existence of its data cache. If it's gone, or the element is currently paused, skip animating this element. */
						if (!Data(element)) {
							continue;
						}

						var transformPropertyExists = false;

						/**********************************
						 Display & Visibility Toggling
						 **********************************/

						/* If the display option is set to non-"none", set it upfront so that the element can become visible before tweening begins.
						 (Otherwise, display's "none" value is set in completeCall() once the animation has completed.) */
						if (opts.display !== undefined && opts.display !== null && opts.display !== "none") {
							if (opts.display === "flex") {
								var flexValues = ["-webkit-box", "-moz-box", "-ms-flexbox", "-webkit-flex"];

								$.each(flexValues, function(i, flexValue) {
									CSS.setPropertyValue(element, "display", flexValue);
								});
							}

							CSS.setPropertyValue(element, "display", opts.display);
						}

						/* Same goes with the visibility option, but its "none" equivalent is "hidden". */
						if (opts.visibility !== undefined && opts.visibility !== "hidden") {
							CSS.setPropertyValue(element, "visibility", opts.visibility);
						}

						/************************
						 Property Iteration
						 ************************/

						/* For every element, iterate through each property. */
						for (var property in tweensContainer) {
							/* Note: In addition to property tween data, tweensContainer contains a reference to its associated element. */
							if (tweensContainer.hasOwnProperty(property) && property !== "element") {
								var tween = tweensContainer[property],
										currentValue,
										/* Easing can either be a pre-genereated function or a string that references a pre-registered easing
										 on the Velocity.Easings object. In either case, return the appropriate easing *function*. */
										easing = Type.isString(tween.easing) ? Velocity.Easings[tween.easing] : tween.easing;

								/******************************
								 Current Value Calculation
								 ******************************/

								if (Type.isString(tween.pattern)) {
									var patternReplace = percentComplete === 1 ?
											function($0, index, round) {
												var result = tween.endValue[index];

												return round ? Math.round(result) : result;
											} :
											function($0, index, round) {
												var startValue = tween.startValue[index],
														tweenDelta = tween.endValue[index] - startValue,
														result = startValue + (tweenDelta * easing(percentComplete, opts, tweenDelta));

												return round ? Math.round(result) : result;
											};

									currentValue = tween.pattern.replace(/{(\d+)(!)?}/g, patternReplace);
								} else if (percentComplete === 1) {
									/* If this is the last tick pass (if we've reached 100% completion for this tween),
									 ensure that currentValue is explicitly set to its target endValue so that it's not subjected to any rounding. */
									currentValue = tween.endValue;
								} else {
									/* Otherwise, calculate currentValue based on the current delta from startValue. */
									var tweenDelta = tween.endValue - tween.startValue;

									currentValue = tween.startValue + (tweenDelta * easing(percentComplete, opts, tweenDelta));
									/* If no value change is occurring, don't proceed with DOM updating. */
								}
								if (!firstTick && (currentValue === tween.currentValue)) {
									continue;
								}

								tween.currentValue = currentValue;

								/* If we're tweening a fake 'tween' property in order to log transition values, update the one-per-call variable so that
								 it can be passed into the progress callback. */
								if (property === "tween") {
									tweenDummyValue = currentValue;
								} else {
									/******************
									 Hooks: Part I
									 ******************/
									var hookRoot;

									/* For hooked properties, the newly-updated rootPropertyValueCache is cached onto the element so that it can be used
									 for subsequent hooks in this call that are associated with the same root property. If we didn't cache the updated
									 rootPropertyValue, each subsequent update to the root property in this tick pass would reset the previous hook's
									 updates to rootPropertyValue prior to injection. A nice performance byproduct of rootPropertyValue caching is that
									 subsequently chained animations using the same hookRoot but a different hook can use this cached rootPropertyValue. */
									if (CSS.Hooks.registered[property]) {
										hookRoot = CSS.Hooks.getRoot(property);

										var rootPropertyValueCache = Data(element).rootPropertyValueCache[hookRoot];

										if (rootPropertyValueCache) {
											tween.rootPropertyValue = rootPropertyValueCache;
										}
									}

									/*****************
									 DOM Update
									 *****************/

									/* setPropertyValue() returns an array of the property name and property value post any normalization that may have been performed. */
									/* Note: To solve an IE<=8 positioning bug, the unit type is dropped when setting a property value of 0. */
									var adjustedSetData = CSS.setPropertyValue(element, /* SET */
											property,
											tween.currentValue + (IE < 9 && parseFloat(currentValue) === 0 ? "" : tween.unitType),
											tween.rootPropertyValue,
											tween.scrollData);

									/*******************
									 Hooks: Part II
									 *******************/

									/* Now that we have the hook's updated rootPropertyValue (the post-processed value provided by adjustedSetData), cache it onto the element. */
									if (CSS.Hooks.registered[property]) {
										/* Since adjustedSetData contains normalized data ready for DOM updating, the rootPropertyValue needs to be re-extracted from its normalized form. ?? */
										if (CSS.Normalizations.registered[hookRoot]) {
											Data(element).rootPropertyValueCache[hookRoot] = CSS.Normalizations.registered[hookRoot]("extract", null, adjustedSetData[1]);
										} else {
											Data(element).rootPropertyValueCache[hookRoot] = adjustedSetData[1];
										}
									}

									/***************
									 Transforms
									 ***************/

									/* Flag whether a transform property is being animated so that flushTransformCache() can be triggered once this tick pass is complete. */
									if (adjustedSetData[0] === "transform") {
										transformPropertyExists = true;
									}

								}
							}
						}

						/****************
						 mobileHA
						 ****************/

						/* If mobileHA is enabled, set the translate3d transform to null to force hardware acceleration.
						 It's safe to override this property since Velocity doesn't actually support its animation (hooks are used in its place). */
						if (opts.mobileHA) {
							/* Don't set the null transform hack if we've already done so. */
							if (Data(element).transformCache.translate3d === undefined) {
								/* All entries on the transformCache object are later concatenated into a single transform string via flushTransformCache(). */
								Data(element).transformCache.translate3d = "(0px, 0px, 0px)";

								transformPropertyExists = true;
							}
						}

						if (transformPropertyExists) {
							CSS.flushTransformCache(element);
						}
					}

					/* The non-"none" display value is only applied to an element once -- when its associated call is first ticked through.
					 Accordingly, it's set to false so that it isn't re-processed by this call in the next tick. */
					if (opts.display !== undefined && opts.display !== "none") {
						Velocity.State.calls[i][2].display = false;
					}
					if (opts.visibility !== undefined && opts.visibility !== "hidden") {
						Velocity.State.calls[i][2].visibility = false;
					}

					/* Pass the elements and the timing data (percentComplete, msRemaining, timeStart, tweenDummyValue) into the progress callback. */
					if (opts.progress) {
						opts.progress.call(callContainer[1],
								callContainer[1],
								percentComplete,
								Math.max(0, (timeStart + opts.duration) - timeCurrent),
								timeStart,
								tweenDummyValue);
					}

					/* If this call has finished tweening, pass its index to completeCall() to handle call cleanup. */
					if (percentComplete === 1) {
						completeCall(i);
					}
				}
			}

			/* Note: completeCall() sets the isTicking flag to false when the last call on Velocity.State.calls has completed. */
			if (Velocity.State.isTicking) {
				ticker(tick);
			}
		}

		/**********************
		 Call Completion
		 **********************/

		/* Note: Unlike tick(), which processes all active calls at once, call completion is handled on a per-call basis. */
		function completeCall(callIndex, isStopped) {
			/* Ensure the call exists. */
			if (!Velocity.State.calls[callIndex]) {
				return false;
			}

			/* Pull the metadata from the call. */
			var call = Velocity.State.calls[callIndex][0],
					elements = Velocity.State.calls[callIndex][1],
					opts = Velocity.State.calls[callIndex][2],
					resolver = Velocity.State.calls[callIndex][4];

			var remainingCallsExist = false;

			/*************************
			 Element Finalization
			 *************************/

			for (var i = 0, callLength = call.length; i < callLength; i++) {
				var element = call[i].element;

				/* If the user set display to "none" (intending to hide the element), set it now that the animation has completed. */
				/* Note: display:none isn't set when calls are manually stopped (via Velocity("stop"). */
				/* Note: Display gets ignored with "reverse" calls and infinite loops, since this behavior would be undesirable. */
				if (!isStopped && !opts.loop) {
					if (opts.display === "none") {
						CSS.setPropertyValue(element, "display", opts.display);
					}

					if (opts.visibility === "hidden") {
						CSS.setPropertyValue(element, "visibility", opts.visibility);
					}
				}

				/* If the element's queue is empty (if only the "inprogress" item is left at position 0) or if its queue is about to run
				 a non-Velocity-initiated entry, turn off the isAnimating flag. A non-Velocity-initiatied queue entry's logic might alter
				 an element's CSS values and thereby cause Velocity's cached value data to go stale. To detect if a queue entry was initiated by Velocity,
				 we check for the existence of our special Velocity.queueEntryFlag declaration, which minifiers won't rename since the flag
				 is assigned to jQuery's global $ object and thus exists out of Velocity's own scope. */
				var data = Data(element);

				if (opts.loop !== true && ($.queue(element)[1] === undefined || !/\.velocityQueueEntryFlag/i.test($.queue(element)[1]))) {
					/* The element may have been deleted. Ensure that its data cache still exists before acting on it. */
					if (data) {
						data.isAnimating = false;
						/* Clear the element's rootPropertyValueCache, which will become stale. */
						data.rootPropertyValueCache = {};

						var transformHAPropertyExists = false;
						/* If any 3D transform subproperty is at its default value (regardless of unit type), remove it. */
						$.each(CSS.Lists.transforms3D, function(i, transformName) {
							var defaultValue = /^scale/.test(transformName) ? 1 : 0,
									currentValue = data.transformCache[transformName];

							if (data.transformCache[transformName] !== undefined && new RegExp("^\\(" + defaultValue + "[^.]").test(currentValue)) {
								transformHAPropertyExists = true;

								delete data.transformCache[transformName];
							}
						});

						/* Mobile devices have hardware acceleration removed at the end of the animation in order to avoid hogging the GPU's memory. */
						if (opts.mobileHA) {
							transformHAPropertyExists = true;
							delete data.transformCache.translate3d;
						}

						/* Flush the subproperty removals to the DOM. */
						if (transformHAPropertyExists) {
							CSS.flushTransformCache(element);
						}

						/* Remove the "velocity-animating" indicator class. */
						CSS.Values.removeClass(element, "velocity-animating");
					}
				}

				/*********************
				 Option: Complete
				 *********************/

				/* Complete is fired once per call (not once per element) and is passed the full raw DOM element set as both its context and its first argument. */
				/* Note: Callbacks aren't fired when calls are manually stopped (via Velocity("stop"). */
				if (!isStopped && opts.complete && !opts.loop && (i === callLength - 1)) {
					/* We throw callbacks in a setTimeout so that thrown errors don't halt the execution of Velocity itself. */
					try {
						opts.complete.call(elements, elements);
					} catch (error) {
						setTimeout(function() {
							throw error;
						}, 1);
					}
				}

				/**********************
				 Promise Resolving
				 **********************/

				/* Note: Infinite loops don't return promises. */
				if (resolver && opts.loop !== true) {
					resolver(elements);
				}

				/****************************
				 Option: Loop (Infinite)
				 ****************************/

				if (data && opts.loop === true && !isStopped) {
					/* If a rotateX/Y/Z property is being animated by 360 deg with loop:true, swap tween start/end values to enable
					 continuous iterative rotation looping. (Otherise, the element would just rotate back and forth.) */
					$.each(data.tweensContainer, function(propertyName, tweenContainer) {
						if (/^rotate/.test(propertyName) && ((parseFloat(tweenContainer.startValue) - parseFloat(tweenContainer.endValue)) % 360 === 0)) {
							var oldStartValue = tweenContainer.startValue;

							tweenContainer.startValue = tweenContainer.endValue;
							tweenContainer.endValue = oldStartValue;
						}

						if (/^backgroundPosition/.test(propertyName) && parseFloat(tweenContainer.endValue) === 100 && tweenContainer.unitType === "%") {
							tweenContainer.endValue = 0;
							tweenContainer.startValue = 100;
						}
					});

					Velocity(element, "reverse", {loop: true, delay: opts.delay});
				}

				/***************
				 Dequeueing
				 ***************/

				/* Fire the next call in the queue so long as this call's queue wasn't set to false (to trigger a parallel animation),
				 which would have already caused the next call to fire. Note: Even if the end of the animation queue has been reached,
				 $.dequeue() must still be called in order to completely clear jQuery's animation queue. */
				if (opts.queue !== false) {
					$.dequeue(element, opts.queue);
				}
			}

			/************************
			 Calls Array Cleanup
			 ************************/

			/* Since this call is complete, set it to false so that the rAF tick skips it. This array is later compacted via compactSparseArray().
			 (For performance reasons, the call is set to false instead of being deleted from the array: http://www.html5rocks.com/en/tutorials/speed/v8/) */
			Velocity.State.calls[callIndex] = false;

			/* Iterate through the calls array to determine if this was the final in-progress animation.
			 If so, set a flag to end ticking and clear the calls array. */
			for (var j = 0, callsLength = Velocity.State.calls.length; j < callsLength; j++) {
				if (Velocity.State.calls[j] !== false) {
					remainingCallsExist = true;

					break;
				}
			}

			if (remainingCallsExist === false) {
				/* tick() will detect this flag upon its next iteration and subsequently turn itself off. */
				Velocity.State.isTicking = false;

				/* Clear the calls array so that its length is reset. */
				delete Velocity.State.calls;
				Velocity.State.calls = [];
			}
		}

		/******************
		 Frameworks
		 ******************/

		/* Both jQuery and Zepto allow their $.fn object to be extended to allow wrapped elements to be subjected to plugin calls.
		 If either framework is loaded, register a "velocity" extension pointing to Velocity's core animate() method.  Velocity
		 also registers itself onto a global container (window.jQuery || window.Zepto || window) so that certain features are
		 accessible beyond just a per-element scope. This master object contains an .animate() method, which is later assigned to $.fn
		 (if jQuery or Zepto are present). Accordingly, Velocity can both act on wrapped DOM elements and stand alone for targeting raw DOM elements. */
		global.Velocity = Velocity;

		if (global !== window) {
			/* Assign the element function to Velocity's core animate() method. */
			global.fn.velocity = animate;
			/* Assign the object function's defaults to Velocity's global defaults object. */
			global.fn.velocity.defaults = Velocity.defaults;
		}

		/***********************
		 Packaged Redirects
		 ***********************/

		/* slideUp, slideDown */
		$.each(["Down", "Up"], function(i, direction) {
			Velocity.Redirects["slide" + direction] = function(element, options, elementsIndex, elementsSize, elements, promiseData) {
				var opts = $.extend({}, options),
						begin = opts.begin,
						complete = opts.complete,
						inlineValues = {},
						computedValues = {height: "", marginTop: "", marginBottom: "", paddingTop: "", paddingBottom: ""};

				if (opts.display === undefined) {
					/* Show the element before slideDown begins and hide the element after slideUp completes. */
					/* Note: Inline elements cannot have dimensions animated, so they're reverted to inline-block. */
					opts.display = (direction === "Down" ? (Velocity.CSS.Values.getDisplayType(element) === "inline" ? "inline-block" : "block") : "none");
				}

				opts.begin = function() {
					/* If the user passed in a begin callback, fire it now. */
					if (elementsIndex === 0 && begin) {
						begin.call(elements, elements);
					}

					/* Cache the elements' original vertical dimensional property values so that we can animate back to them. */
					for (var property in computedValues) {
						if (!computedValues.hasOwnProperty(property)) {
							continue;
						}
						inlineValues[property] = element.style[property];

						/* For slideDown, use forcefeeding to animate all vertical properties from 0. For slideUp,
						 use forcefeeding to start from computed values and animate down to 0. */
						var propertyValue = CSS.getPropertyValue(element, property);
						computedValues[property] = (direction === "Down") ? [propertyValue, 0] : [0, propertyValue];
					}

					/* Force vertical overflow content to clip so that sliding works as expected. */
					inlineValues.overflow = element.style.overflow;
					element.style.overflow = "hidden";
				};

				opts.complete = function() {
					/* Reset element to its pre-slide inline values once its slide animation is complete. */
					for (var property in inlineValues) {
						if (inlineValues.hasOwnProperty(property)) {
							element.style[property] = inlineValues[property];
						}
					}

					/* If the user passed in a complete callback, fire it now. */
					if (elementsIndex === elementsSize - 1) {
						if (complete) {
							complete.call(elements, elements);
						}
						if (promiseData) {
							promiseData.resolver(elements);
						}
					}
				};

				Velocity(element, computedValues, opts);
			};
		});

		/* fadeIn, fadeOut */
		$.each(["In", "Out"], function(i, direction) {
			Velocity.Redirects["fade" + direction] = function(element, options, elementsIndex, elementsSize, elements, promiseData) {
				var opts = $.extend({}, options),
						complete = opts.complete,
						propertiesMap = {opacity: (direction === "In") ? 1 : 0};

				/* Since redirects are triggered individually for each element in the animated set, avoid repeatedly triggering
				 callbacks by firing them only when the final element has been reached. */
				if (elementsIndex !== 0) {
					opts.begin = null;
				}
				if (elementsIndex !== elementsSize - 1) {
					opts.complete = null;
				} else {
					opts.complete = function() {
						if (complete) {
							complete.call(elements, elements);
						}
						if (promiseData) {
							promiseData.resolver(elements);
						}
					};
				}

				/* If a display was passed in, use it. Otherwise, default to "none" for fadeOut or the element-specific default for fadeIn. */
				/* Note: We allow users to pass in "null" to skip display setting altogether. */
				if (opts.display === undefined) {
					opts.display = (direction === "In" ? "auto" : "none");
				}

				Velocity(this, propertiesMap, opts);
			};
		});

		return Velocity;
	}((window.jQuery || window.Zepto || window), window, (window ? window.document : undefined));
}));

/******************
 Known Issues
 ******************/

/* The CSS spec mandates that the translateX/Y/Z transforms are %-relative to the element itself -- not its parent.
 Velocity, however, doesn't make this distinction. Thus, converting to or from the % unit with these subproperties
 will produce an inaccurate conversion value. The same issue exists with the cx/cy attributes of SVG circles and ellipses. */


/***/ }),
/* 884 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
  };
}();

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _possibleConstructorReturn(self, call) {
  if (!self) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }return call && ((typeof call === "undefined" ? "undefined" : _typeof(call)) === "object" || typeof call === "function") ? call : self;
}

function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === "undefined" ? "undefined" : _typeof(superClass)));
  }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
}

/*
Copyright (c) 2015 Twitter, Inc. and other contributors

Component to add Velocity animations around React transitions. Delegates to the React TransitionGroup
addon.

Properties
  enter: Animation to run on a child component being added
  leave: Animation to run on a child component leaving
  runOnMount: if true, runs the "enter" animation on the elements that exist as children when this
    component is mounted.
  enterHideStyle/enterShowStyle: see below.

Any additional properties (e.g. "className", "component") will be passed to the internal
TransitionGroup.

"enter" and "leave" should either be a string naming an animation, or a hash with an
"animation" key that can either be a string itself, or a hash of style attributes to animate (this
value is passed to Velocity its the first arg).

If "enter" or "leave" is a hash, it can additionally have a "style" value that is applied the tick
before the Velocity animation starts. Use this for non-animating properties (like "position") that
are prerequisites for correct animation. The style value is applied using Velocity's JS -> CSS
routines, which may differ from React's.

Any hash entries beyond "animation" and "style" are passed in an options hash to Velocity. Use this
for options like "stagger", "reverse", &tc.

By default, this component will immediately hide all entering children with display: 'none', and
unhide them one tick later with display: ''. This is done so that we can coalesce multiple enters
into a single animation, and we want to avoid any popping of elements in while they're collected. If
you prefer a different way of hiding these elements so that e.g. geometry can be immediately
calculated, use the enterHideStyle and enterShowStyle props to provide alternate style hashes for
hiding and revealing entering elements.

Statics
  disabledForTest: Set this to true globally to turn off all custom animation logic. Instead, this
    component will behave like a vanilla TransitionGroup.

Inspired by https://gist.github.com/tkafka/0d94c6ec94297bb67091
*/

var _ = __webpack_require__(3);

var React = __webpack_require__(0);
var ReactDOM = __webpack_require__(14);
var PropTypes = __webpack_require__(1);
var TransitionGroup = __webpack_require__(885);
var Velocity = __webpack_require__(154);

// Shim requestAnimationFrame for browsers that don't support it, in particular IE 9.
var shimRequestAnimationFrame = typeof window !== 'undefined' && (window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || function (callback) {
  window.setTimeout(callback, 0);
});

// Fix 'Invalid calling object' error in IE
shimRequestAnimationFrame = typeof window !== 'undefined' && shimRequestAnimationFrame.bind(window);

var shimCancelAnimationFrame = typeof window !== 'undefined' && (window.cancelAnimationFrame || window.webkitCancelAnimationFrame || window.mozCancelAnimationFrame || function (timeout) {
  window.clearTimeout(timeout);
});

shimCancelAnimationFrame = typeof window !== 'undefined' && shimCancelAnimationFrame.bind(window);

// Internal wrapper for the transitioned elements. Delegates all child lifecycle events to the
// parent VelocityTransitionGroup so that it can co-ordinate animating all of the elements at once.

var VelocityTransitionGroupChild = function (_React$Component) {
  _inherits(VelocityTransitionGroupChild, _React$Component);

  function VelocityTransitionGroupChild() {
    _classCallCheck(this, VelocityTransitionGroupChild);

    return _possibleConstructorReturn(this, (VelocityTransitionGroupChild.__proto__ || Object.getPrototypeOf(VelocityTransitionGroupChild)).apply(this, arguments));
  }

  _createClass(VelocityTransitionGroupChild, [{
    key: 'componentWillAppear',
    value: function componentWillAppear(doneFn) {
      this.props.willAppearFunc(ReactDOM.findDOMNode(this), doneFn);
    }
  }, {
    key: 'componentWillEnter',
    value: function componentWillEnter(doneFn) {
      this.props.willEnterFunc(ReactDOM.findDOMNode(this), doneFn);
    }
  }, {
    key: 'componentWillLeave',
    value: function componentWillLeave(doneFn) {
      this.props.willLeaveFunc(ReactDOM.findDOMNode(this), doneFn);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      // Clear references from velocity cache.
      Velocity.Utilities.removeData(ReactDOM.findDOMNode(this), ['velocity', 'fxqueue']);
    }
  }, {
    key: 'render',
    value: function render() {
      return React.Children.only(this.props.children);
    }
  }]);

  return VelocityTransitionGroupChild;
}(React.Component);

VelocityTransitionGroupChild.propTypes = {
  children: PropTypes.element.isRequired,
  willAppearFunc: PropTypes.func.isRequired,
  willEnterFunc: PropTypes.func.isRequired,
  willLeaveFunc: PropTypes.func.isRequired
};

var VelocityTransitionGroup = function (_React$Component2) {
  _inherits(VelocityTransitionGroup, _React$Component2);

  function VelocityTransitionGroup(props) {
    _classCallCheck(this, VelocityTransitionGroup);

    var _this2 = _possibleConstructorReturn(this, (VelocityTransitionGroup.__proto__ || Object.getPrototypeOf(VelocityTransitionGroup)).call(this, props));

    _this2._scheduledAnimationFrame = null;
    _this2._scheduledAnimationRunFrames = [];
    _this2._entering = [];
    _this2._leaving = [];

    _this2._timers = [];
    _this2._unmounted = false;

    _this2.childWillAppear = _this2.childWillAppear.bind(_this2);
    _this2.childWillEnter = _this2.childWillEnter.bind(_this2);
    _this2.childWillLeave = _this2.childWillLeave.bind(_this2);

    _this2._runAnimations = _this2._runAnimations.bind(_this2);
    _this2._wrapChild = _this2._wrapChild.bind(_this2);
    return _this2;
  }

  _createClass(VelocityTransitionGroup, [{
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this._scheduledAnimationFrame) {
        shimCancelAnimationFrame(this._scheduledAnimationFrame);
      }

      _.forEach(this._timers, function (timer) {
        clearTimeout(timer);
      });

      _.forEach(this._scheduledAnimationRunFrames, function (frame) {
        shimCancelAnimationFrame(frame);
      });

      // We don't cancel all the in-process animations, so we use this to know if the component
      // is gone when an animation is over.
      this._unmounted = true;
    }
  }, {
    key: 'render',
    value: function render() {
      // Pass any props that are not our own on into the TransitionGroup delegate.
      var transitionGroupProps = _.omit(this.props, _.keys(VelocityTransitionGroup.propTypes));

      // Without our custom childFactory, we just get a default TransitionGroup that doesn't do
      // anything special at all.
      if (!this.constructor.disabledForTest && !Velocity.velocityReactServerShim) {
        transitionGroupProps.childFactory = this._wrapChild;
      }

      return React.createElement(TransitionGroup, transitionGroupProps, this.props.children);
    }
  }, {
    key: 'childWillAppear',
    value: function childWillAppear(node, doneFn) {
      var _this3 = this;

      if (this.props.runOnMount) {
        this.childWillEnter(node, doneFn);
      } else {
        this._finishAnimation(node, this.props.enter);

        // Important to tick over so that any callbacks due to finishing the animation complete first.
        //
        // Using setTimeout so that doneFn gets called even when the tab is hidden.
        var t = setTimeout(function () {
          var idx = _this3._timers.indexOf(t);
          if (idx >= 0) {
            _this3._timers.splice(idx, 1);
          }

          doneFn();
        }, 0);
        this._timers.push(t);
      }
    }
  }, {
    key: 'childWillEnter',
    value: function childWillEnter(node, doneFn) {
      if (this._shortCircuitAnimation(this.props.enter, doneFn)) return;

      // By finishing a "leave" on the element, we put it in the right state to be animated in. Useful
      // if "leave" includes a rotation or something that we'd like to have as our starting point, for
      // symmetry.
      // We use overrideOpts to prevent any "begin" or "complete" callback from triggering in this case, since
      // it doesn't make a ton of sense.
      this._finishAnimation(node, this.props.leave, { begin: undefined, complete: undefined });

      // We're not going to start the animation for a tick, so set the node's display to none (or any
      // custom "hide" style provided) so that it doesn't flash in.
      _.forEach(this.props.enterHideStyle, function (val, key) {
        Velocity.CSS.setPropertyValue(node, key, val);
      });

      this._entering.push({
        node: node,
        doneFn: doneFn
      });

      this._schedule();
    }
  }, {
    key: 'childWillLeave',
    value: function childWillLeave(node, doneFn) {
      if (this._shortCircuitAnimation(this.props.leave, doneFn)) return;

      this._leaving.push({
        node: node,
        doneFn: doneFn
      });

      this._schedule();
    }
  }, {
    key: '_shortCircuitAnimation',

    // document.hidden check is there because animation completion callbacks won't fire (due to
    // chaining off of rAF), which would prevent entering / leaving DOM nodes from being cleaned up
    // while the tab is hidden.
    //
    // Returns true if this did short circuit, false if lifecycle methods should continue with
    // their animations.
    value: function _shortCircuitAnimation(animationProp, doneFn) {
      if (document.hidden || this._parseAnimationProp(animationProp).animation == null) {
        doneFn();

        return true;
      } else {
        return false;
      }
    }
  }, {
    key: '_schedule',
    value: function _schedule() {
      if (this._scheduledAnimationFrame) {
        return;
      }

      // Need rAF to make sure we're in the same event queue as Velocity from here out. Important
      // for avoiding getting wrong interleaving with Velocity callbacks.
      this._scheduledAnimationFrame = shimRequestAnimationFrame(this._runAnimations);
    }

    // arrow function because this is used as an rAF callback

  }, {
    key: '_runAnimations',
    value: function _runAnimations() {
      this._scheduledAnimationFrame = null;

      this._runAnimation(true, this._entering, this.props.enter);
      this._runAnimation(false, this._leaving, this.props.leave);

      this._entering = [];
      this._leaving = [];
    }

    // Used to parse out the 'enter' and 'leave' properties. Handles cases where they are omitted
    // as well as when they are just strings and not hashes of animation and options.

  }, {
    key: '_parseAnimationProp',
    value: function _parseAnimationProp(animationProp) {
      var animation, opts, style;

      if (typeof animationProp === 'string') {
        animation = animationProp;
        style = null;
        opts = {};
      } else {
        animation = animationProp != null ? animationProp.animation : null;
        style = animationProp != null ? animationProp.style : null;
        opts = _.omit(animationProp, 'animation', 'style');
      }

      return {
        animation: animation,
        style: style,
        opts: opts
      };
    }
  }, {
    key: '_runAnimation',
    value: function _runAnimation(entering, queue, animationProp) {
      var _this4 = this;

      if (queue.length === 0) {
        return;
      }

      var nodes = _.map(queue, 'node');
      var doneFns = _.map(queue, 'doneFn');

      var parsedAnimation = this._parseAnimationProp(animationProp);
      var animation = parsedAnimation.animation;
      var style = parsedAnimation.style;
      var opts = parsedAnimation.opts;

      // Clearing display reverses the behavior from childWillAppear where all elements are added with
      // display: none to prevent them from flashing in before the animation starts. We don't do this
      // for the fade/slide animations or any animation that ends in "In," since Velocity will handle
      // it for us.
      //
      // If a custom "enterShowStyle" prop is passed, (i.e. not one that just reverses display: none)
      // we always run it, regardless of the animation, since it's probably doing something around
      // opacity or positioning that Velocity will not necessarily reset.
      if (entering) {
        if (!_.isEqual(this.props.enterShowStyle, { display: '' }) || !(/^(fade|slide)/.test(animation) || /In$/.test(animation))) {
          style = _.assign({}, this.props.enterShowStyle, style);
        }
      }

      // Because Safari can synchronously repaint when CSS "display" is reset, we set styles for all
      // browsers before the rAF tick below that starts the animation. This way you know in all
      // cases that you need to support your static styles being visible on the element before
      // the animation begins.
      if (style != null) {
        _.each(style, function (value, key) {
          Velocity.hook(nodes, key, value);
        });
      }

      var doneFn = function doneFn() {
        // calling doneFns after the parent has unmounted leads to errors
        if (_this4._unmounted) {
          return;
        }

        doneFns.map(function (doneFn) {
          doneFn();
        });
      };

      // For nodes that are entering, we tell the TransitionGroup that we're done with them
      // immediately. That way, they can be removed later before their entering animations complete.
      // If we're leaving, we stop current animations (which may be partially-completed enter
      // animations) so that we can then animate out. Velocity typically makes these transitions
      // very smooth, correctly animating from whatever state the element is currently in.
      if (entering) {
        doneFn();
        doneFn = null;
      } else {
        Velocity(nodes, 'stop');
      }

      var combinedCompleteFn;
      if (doneFn && opts.complete) {
        var optsCompleteFn = opts.complete;
        combinedCompleteFn = function combinedCompleteFn() {
          doneFn();
          // preserve this / args from Velocity so the complete function has context for what completed
          optsCompleteFn.apply(this, arguments);
        };
      } else {
        // One or the other or neither.
        combinedCompleteFn = doneFn || opts.complete;
      }

      // Bit of a hack. Without this rAF, sometimes an enter animation doesn't start running, or is
      // stopped before getting anywhere. This should get us on the other side of both completeFn and
      // any _finishAnimation that's happening.
      var t = shimRequestAnimationFrame(function () {
        var idx = _this4._scheduledAnimationRunFrames.indexOf(t);
        if (idx >= 0) {
          _this4._scheduledAnimationRunFrames.splice(idx, 1);
        }

        Velocity(nodes, animation, _.assign({}, opts, {
          complete: combinedCompleteFn
        }));
      });

      this._scheduledAnimationRunFrames.push(t);
    }
  }, {
    key: '_finishAnimation',
    value: function _finishAnimation(node, animationProp, overrideOpts) {
      var parsedAnimation = this._parseAnimationProp(animationProp);
      var animation = parsedAnimation.animation;
      var style = parsedAnimation.style;
      var opts = _.assign({}, parsedAnimation.opts, overrideOpts);

      if (style != null) {
        _.each(style, function (value, key) {
          Velocity.hook(node, key, value);
        });
      }

      if (animation != null) {
        // Opts are relevant even though we're immediately finishing, since things like "display"
        // can affect the animation outcome.

        Velocity(node, animation, opts);
        Velocity(node, 'finishAll', true);
      }
    }
  }, {
    key: '_wrapChild',
    value: function _wrapChild(child) {
      return React.createElement(VelocityTransitionGroupChild, {
        willAppearFunc: this.childWillAppear,
        willEnterFunc: this.childWillEnter,
        willLeaveFunc: this.childWillLeave
      }, child);
    }
  }]);

  return VelocityTransitionGroup;
}(React.Component);

VelocityTransitionGroup.disabledForTest = false; // global, mutable, for disabling animations during test

VelocityTransitionGroup.propTypes = {
  runOnMount: PropTypes.bool,
  enter: PropTypes.any,
  leave: PropTypes.any,
  children: PropTypes.any,
  enterHideStyle: PropTypes.object,
  enterShowStyle: PropTypes.object
};

VelocityTransitionGroup.defaultProps = {
  runOnMount: false,
  enter: null,
  leave: null,
  enterHideStyle: {
    display: 'none'
  },
  enterShowStyle: {
    display: ''
  }
};

module.exports = VelocityTransitionGroup;

/***/ }),
/* 885 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _chainFunction = __webpack_require__(886);

var _chainFunction2 = _interopRequireDefault(_chainFunction);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(1);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _warning = __webpack_require__(21);

var _warning2 = _interopRequireDefault(_warning);

var _ChildMapping = __webpack_require__(887);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var propTypes = {
  component: _propTypes2.default.any,
  childFactory: _propTypes2.default.func,
  children: _propTypes2.default.node
};

var defaultProps = {
  component: 'span',
  childFactory: function childFactory(child) {
    return child;
  }
};

var TransitionGroup = function (_React$Component) {
  _inherits(TransitionGroup, _React$Component);

  function TransitionGroup(props, context) {
    _classCallCheck(this, TransitionGroup);

    var _this = _possibleConstructorReturn(this, _React$Component.call(this, props, context));

    _this.performAppear = function (key, component) {
      _this.currentlyTransitioningKeys[key] = true;

      if (component.componentWillAppear) {
        component.componentWillAppear(_this._handleDoneAppearing.bind(_this, key, component));
      } else {
        _this._handleDoneAppearing(key, component);
      }
    };

    _this._handleDoneAppearing = function (key, component) {
      if (component.componentDidAppear) {
        component.componentDidAppear();
      }

      delete _this.currentlyTransitioningKeys[key];

      var currentChildMapping = (0, _ChildMapping.getChildMapping)(_this.props.children);

      if (!currentChildMapping || !currentChildMapping.hasOwnProperty(key)) {
        // This was removed before it had fully appeared. Remove it.
        _this.performLeave(key, component);
      }
    };

    _this.performEnter = function (key, component) {
      _this.currentlyTransitioningKeys[key] = true;

      if (component.componentWillEnter) {
        component.componentWillEnter(_this._handleDoneEntering.bind(_this, key, component));
      } else {
        _this._handleDoneEntering(key, component);
      }
    };

    _this._handleDoneEntering = function (key, component) {
      if (component.componentDidEnter) {
        component.componentDidEnter();
      }

      delete _this.currentlyTransitioningKeys[key];

      var currentChildMapping = (0, _ChildMapping.getChildMapping)(_this.props.children);

      if (!currentChildMapping || !currentChildMapping.hasOwnProperty(key)) {
        // This was removed before it had fully entered. Remove it.
        _this.performLeave(key, component);
      }
    };

    _this.performLeave = function (key, component) {
      _this.currentlyTransitioningKeys[key] = true;

      if (component.componentWillLeave) {
        component.componentWillLeave(_this._handleDoneLeaving.bind(_this, key, component));
      } else {
        // Note that this is somewhat dangerous b/c it calls setState()
        // again, effectively mutating the component before all the work
        // is done.
        _this._handleDoneLeaving(key, component);
      }
    };

    _this._handleDoneLeaving = function (key, component) {
      if (component.componentDidLeave) {
        component.componentDidLeave();
      }

      delete _this.currentlyTransitioningKeys[key];

      var currentChildMapping = (0, _ChildMapping.getChildMapping)(_this.props.children);

      if (currentChildMapping && currentChildMapping.hasOwnProperty(key)) {
        // This entered again before it fully left. Add it again.
        _this.keysToEnter.push(key);
      } else {
        _this.setState(function (state) {
          var newChildren = _extends({}, state.children);
          delete newChildren[key];
          return { children: newChildren };
        });
      }
    };

    _this.childRefs = Object.create(null);

    _this.state = {
      children: (0, _ChildMapping.getChildMapping)(props.children)
    };
    return _this;
  }

  TransitionGroup.prototype.componentWillMount = function componentWillMount() {
    this.currentlyTransitioningKeys = {};
    this.keysToEnter = [];
    this.keysToLeave = [];
  };

  TransitionGroup.prototype.componentDidMount = function componentDidMount() {
    var initialChildMapping = this.state.children;
    for (var key in initialChildMapping) {
      if (initialChildMapping[key]) {
        this.performAppear(key, this.childRefs[key]);
      }
    }
  };

  TransitionGroup.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
    var nextChildMapping = (0, _ChildMapping.getChildMapping)(nextProps.children);
    var prevChildMapping = this.state.children;

    this.setState({
      children: (0, _ChildMapping.mergeChildMappings)(prevChildMapping, nextChildMapping)
    });

    for (var key in nextChildMapping) {
      var hasPrev = prevChildMapping && prevChildMapping.hasOwnProperty(key);
      if (nextChildMapping[key] && !hasPrev && !this.currentlyTransitioningKeys[key]) {
        this.keysToEnter.push(key);
      }
    }

    for (var _key in prevChildMapping) {
      var hasNext = nextChildMapping && nextChildMapping.hasOwnProperty(_key);
      if (prevChildMapping[_key] && !hasNext && !this.currentlyTransitioningKeys[_key]) {
        this.keysToLeave.push(_key);
      }
    }

    // If we want to someday check for reordering, we could do it here.
  };

  TransitionGroup.prototype.componentDidUpdate = function componentDidUpdate() {
    var _this2 = this;

    var keysToEnter = this.keysToEnter;
    this.keysToEnter = [];
    keysToEnter.forEach(function (key) {
      return _this2.performEnter(key, _this2.childRefs[key]);
    });

    var keysToLeave = this.keysToLeave;
    this.keysToLeave = [];
    keysToLeave.forEach(function (key) {
      return _this2.performLeave(key, _this2.childRefs[key]);
    });
  };

  TransitionGroup.prototype.render = function render() {
    var _this3 = this;

    // TODO: we could get rid of the need for the wrapper node
    // by cloning a single child
    var childrenToRender = [];

    var _loop = function _loop(key) {
      var child = _this3.state.children[key];
      if (child) {
        var isCallbackRef = typeof child.ref !== 'string';
        var factoryChild = _this3.props.childFactory(child);
        var ref = function ref(r) {
          _this3.childRefs[key] = r;
        };

        process.env.NODE_ENV !== 'production' ? (0, _warning2.default)(isCallbackRef, 'string refs are not supported on children of TransitionGroup and will be ignored. ' + 'Please use a callback ref instead: https://facebook.github.io/react/docs/refs-and-the-dom.html#the-ref-callback-attribute') : void 0;

        // Always chaining the refs leads to problems when the childFactory
        // wraps the child. The child ref callback gets called twice with the
        // wrapper and the child. So we only need to chain the ref if the
        // factoryChild is not different from child.
        if (factoryChild === child && isCallbackRef) {
          ref = (0, _chainFunction2.default)(child.ref, ref);
        }

        // You may need to apply reactive updates to a child as it is leaving.
        // The normal React way to do it won't work since the child will have
        // already been removed. In case you need this behavior you can provide
        // a childFactory function to wrap every child, even the ones that are
        // leaving.
        childrenToRender.push(_react2.default.cloneElement(factoryChild, {
          key: key,
          ref: ref
        }));
      }
    };

    for (var key in this.state.children) {
      _loop(key);
    }

    // Do not forward TransitionGroup props to primitive DOM nodes
    var props = _extends({}, this.props);
    delete props.transitionLeave;
    delete props.transitionName;
    delete props.transitionAppear;
    delete props.transitionEnter;
    delete props.childFactory;
    delete props.transitionLeaveTimeout;
    delete props.transitionEnterTimeout;
    delete props.transitionAppearTimeout;
    delete props.component;

    return _react2.default.createElement(this.props.component, props, childrenToRender);
  };

  return TransitionGroup;
}(_react2.default.Component);

TransitionGroup.displayName = 'TransitionGroup';


TransitionGroup.propTypes = process.env.NODE_ENV !== "production" ? propTypes : {};
TransitionGroup.defaultProps = defaultProps;

exports.default = TransitionGroup;
module.exports = exports['default'];
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(11)))

/***/ }),
/* 886 */
/***/ (function(module, exports) {


module.exports = function chain(){
  var len = arguments.length
  var args = [];

  for (var i = 0; i < len; i++)
    args[i] = arguments[i]

  args = args.filter(function(fn){ return fn != null })

  if (args.length === 0) return undefined
  if (args.length === 1) return args[0]

  return args.reduce(function(current, next){
    return function chainedFunction() {
      current.apply(this, arguments);
      next.apply(this, arguments);
    };
  })
}


/***/ }),
/* 887 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
exports.getChildMapping = getChildMapping;
exports.mergeChildMappings = mergeChildMappings;

var _react = __webpack_require__(0);

/**
 * Given `this.props.children`, return an object mapping key to child.
 *
 * @param {*} children `this.props.children`
 * @return {object} Mapping of key to child
 */
function getChildMapping(children) {
  if (!children) {
    return children;
  }
  var result = {};
  _react.Children.map(children, function (child) {
    return child;
  }).forEach(function (child) {
    result[child.key] = child;
  });
  return result;
}

/**
 * When you're adding or removing children some may be added or removed in the
 * same render pass. We want to show *both* since we want to simultaneously
 * animate elements in and out. This function takes a previous set of keys
 * and a new set of keys and merges them with its best guess of the correct
 * ordering. In the future we may expose some of the utilities in
 * ReactMultiChild to make this easy, but for now React itself does not
 * directly have this concept of the union of prevChildren and nextChildren
 * so we implement it here.
 *
 * @param {object} prev prev children as returned from
 * `ReactTransitionChildMapping.getChildMapping()`.
 * @param {object} next next children as returned from
 * `ReactTransitionChildMapping.getChildMapping()`.
 * @return {object} a key set that contains all keys in `prev` and all keys
 * in `next` in a reasonable order.
 */
function mergeChildMappings(prev, next) {
  prev = prev || {};
  next = next || {};

  function getValueForKey(key) {
    if (next.hasOwnProperty(key)) {
      return next[key];
    }

    return prev[key];
  }

  // For each key of `next`, the list of keys to insert before that key in
  // the combined list
  var nextKeysPending = {};

  var pendingKeys = [];
  for (var prevKey in prev) {
    if (next.hasOwnProperty(prevKey)) {
      if (pendingKeys.length) {
        nextKeysPending[prevKey] = pendingKeys;
        pendingKeys = [];
      }
    } else {
      pendingKeys.push(prevKey);
    }
  }

  var i = void 0;
  var childMapping = {};
  for (var nextKey in next) {
    if (nextKeysPending.hasOwnProperty(nextKey)) {
      for (i = 0; i < nextKeysPending[nextKey].length; i++) {
        var pendingNextKey = nextKeysPending[nextKey][i];
        childMapping[nextKeysPending[nextKey][i]] = getValueForKey(pendingNextKey);
      }
    }
    childMapping[nextKey] = getValueForKey(nextKey);
  }

  // Finally, add the keys which didn't appear before any key in `next`
  for (i = 0; i < pendingKeys.length; i++) {
    childMapping[pendingKeys[i]] = getValueForKey(pendingKeys[i]);
  }

  return childMapping;
}

/***/ }),
/* 888 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// Copyright (c) 2015 Twitter, Inc. and other contributors

var _ = __webpack_require__(3);
var Velocity = __webpack_require__(154);

var effectCounter = 0;

// Takes a Velocity "UI pack effect" definition and registers it with a unique key, returning that
// key (to later pass as a value for the "animation" property). Takes an optional suffix, which can
// be "In" or "Out" to modify UI Pack's behavior.
//
// Unlike what you get from passing a style hash to VelocityComponent's "animation" property,
// Velocity "UI pack effects" can have chained animation calls and specify a "defaultDuration", and
// also can take advantage of "stagger" and "reverse" options on the VelocityComponent.
//
// You will need to manually register the UI Pack with the global Velocity in your application with:
//
//   require('velocity');
//   require('velocity-animate/velocity.ui');
//
// See: http://julian.com/research/velocity/#uiPack
//
// Typical usage:
//
// var Animations = {
//   down: VelocityHelpers.registerEffect({
//     defaultDuration: 1100,
//     calls: [
//       [{
//         transformOriginX: [ '50%', '50%' ],
//         transformOriginY: [ 0, 0 ],
//         rotateX: [0, 'spring'],
//       }, 1, {
//         delay: 100,
//         easing: 'ease-in',
//       }]
//     ],
//   }),
//
//   up: VelocityHelpers.registerEffect({
//     defaultDuration: 200,
//     calls: [
//       [{
//         transformOriginX: [ '50%', '50%' ],
//         transformOriginY: [ 0, 0 ],
//         rotateX: 160,
//       }]
//     ],
//   }),
// };
// ...
// <VelocityComponent animation={this.state.isUp ? Animations.up : Animations.down}>
//   ...
// <Velocity>
function registerEffect(suffix, animation) {
  if (_.isObject(suffix)) {
    animation = suffix;
    suffix = '';
  }

  var key = 'VelocityHelper.animation.' + effectCounter++ + suffix;

  // No-op on the server for now.
  if (Velocity.velocityReactServerShim) {
    return key;
  }

  if (Velocity.RegisterEffect === undefined) {
    throw "Velocity.RegisterEffect not found. You need to require 'velocity-animate/velocity.ui' at a top level for UI Pack.";
  }

  Velocity.RegisterEffect(key, animation);
  return key;
}

module.exports = {
  registerEffect: registerEffect
};

/***/ }),
/* 889 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_shallowequal__ = __webpack_require__(890);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_shallowequal___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_shallowequal__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_deep_equal__ = __webpack_require__(150);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_deep_equal___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_deep_equal__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_radium__ = __webpack_require__(891);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_radium___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_radium__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__brandai_velocity_react__ = __webpack_require__(273);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__brandai_velocity_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5__brandai_velocity_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__components_library_Icon__ = __webpack_require__(34);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__Toggle__ = __webpack_require__(937);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__Header__ = __webpack_require__(938);


var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }












var NodeContainer = __WEBPACK_IMPORTED_MODULE_4_radium___default()(_class = function (_React$Component) {
  _inherits(NodeContainer, _React$Component);

  function NodeContainer() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, NodeContainer);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = NodeContainer.__proto__ || Object.getPrototypeOf(NodeContainer)).call.apply(_ref, [this].concat(args))), _this), _this.toggleClicked = function (event) {
      _this.props.onToggle();
      event.stopPropagation();
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(NodeContainer, [{
    key: 'shouldComponentUpdate',
    value: function shouldComponentUpdate(nextProps) {
      var props = this.props;
      var nextPropKeys = Object.keys(nextProps);

      for (var i = 0; i < nextPropKeys.length; i++) {
        var key = nextPropKeys[i];
        if (key === 'animations') {
          continue;
        }

        var isEqual = __WEBPACK_IMPORTED_MODULE_2_shallowequal___default()(props[key], nextProps[key]);
        if (!isEqual) {
          return true;
        }
      }

      return !__WEBPACK_IMPORTED_MODULE_3_deep_equal___default()(props.animations, nextProps.animations, { strict: true });
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          style = _props.style,
          onSelect = _props.onSelect,
          onMenu = _props.onMenu,
          node = _props.node;
      var active = node.active,
          children = node.children;

      var isTerminal = !children;
      var container = [style.link, active ? style.activeLink : null];

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        null,
        node.active ? __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement('div', { style: style.activeRow }) : null,
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          {
            onClick: onSelect,
            onContextMenu: onMenu,
            style: container },
          !isTerminal ? this.renderToggle() : null,
          this.renderHeader(isTerminal)
        )
      );
    }
  }, {
    key: 'renderToggle',
    value: function renderToggle() {
      var animations = this.props.animations;


      if (!animations) {
        return this.renderToggleDecorator();
      }

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        __WEBPACK_IMPORTED_MODULE_5__brandai_velocity_react__["VelocityComponent"],
        {
          animation: animations.toggle.animation,
          duration: animations.toggle.duration },
        this.renderToggleDecorator()
      );
    }
  }, {
    key: 'renderToggleDecorator',
    value: function renderToggleDecorator() {
      var _props2 = this.props,
          style = _props2.style,
          node = _props2.node;


      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_7__Toggle__["a" /* default */], {
        style: style.toggle,
        node: node,
        onClick: this.toggleClicked });
    }
  }, {
    key: 'getNodeIcon',
    value: function getNodeIcon() {
      var _props3 = this.props,
          style = _props3.style,
          node = _props3.node;


      if (node.type === 'colors' && node.customData) {
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement('div', { style: { width: 12, height: 12, backgroundColor: node.customData.colorValue, marginRight: 6 } });
      }

      var iconType = null;
      switch (node.type) {
        case 'typeStyles':
          iconType = 'type-text-style';
          break;
        case 'sharedStyles':
          iconType = 'type-layer-style';
          break;
        case 'icons':
        case 'components':
          iconType = 'type-symbol';
          break;
      }

      if (!iconType) {
        return null;
      }

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { style: style.header.nodeIcon },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_6__components_library_Icon__["a" /* default */], { size: 12, glyph: iconType, color: node.active ? 'white' : 'gray' })
      );
    }
  }, {
    key: 'renderHeader',
    value: function renderHeader(isTerminal) {
      var _props4 = this.props,
          style = _props4.style,
          node = _props4.node,
          onBeginEdit = _props4.onBeginEdit,
          onUpdate = _props4.onUpdate,
          readOnly = _props4.readOnly,
          editingItemID = _props4.editingItemID;


      var nodeIcon = isTerminal ? this.getNodeIcon() : null;

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_8__Header__["a" /* default */], {
        node: node,
        nodeIcon: nodeIcon,
        style: style.header,
        editingItemID: editingItemID,
        onBeginEdit: onBeginEdit,
        onUpdate: onUpdate,
        readOnly: readOnly
      });
    }
  }]);

  return NodeContainer;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component)) || _class;

NodeContainer.propTypes = {
  style: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object.isRequired,
  onSelect: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func.isRequired,
  onToggle: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func.isRequired,
  onMenu: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  animations: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.oneOfType([__WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object, __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool]).isRequired,
  node: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object.isRequired,
  onBeginEdit: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  onUpdate: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func,
  readOnly: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
  editingItemID: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string
};

/* harmony default export */ __webpack_exports__["a"] = (NodeContainer);

/***/ }),
/* 890 */
/***/ (function(module, exports) {

//

module.exports = function shallowEqual(objA, objB, compare, compareContext) {
  var ret = compare ? compare.call(compareContext, objA, objB) : void 0;

  if (ret !== void 0) {
    return !!ret;
  }

  if (objA === objB) {
    return true;
  }

  if (typeof objA !== "object" || !objA || typeof objB !== "object" || !objB) {
    return false;
  }

  var keysA = Object.keys(objA);
  var keysB = Object.keys(objB);

  if (keysA.length !== keysB.length) {
    return false;
  }

  var bHasOwnProperty = Object.prototype.hasOwnProperty.bind(objB);

  // Test for A's keys different from B.
  for (var idx = 0; idx < keysA.length; idx++) {
    var key = keysA[idx];

    if (!bHasOwnProperty(key)) {
      return false;
    }

    var valueA = objA[key];
    var valueB = objB[key];

    ret = compare ? compare.call(compareContext, valueA, valueB, key) : void 0;

    if (ret === false || (ret === void 0 && valueA !== valueB)) {
      return false;
    }
  }

  return true;
};


/***/ }),
/* 891 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _enhancer = __webpack_require__(275);

var _enhancer2 = _interopRequireDefault(_enhancer);

var _plugins = __webpack_require__(285);

var _plugins2 = _interopRequireDefault(_plugins);

var _style = __webpack_require__(933);

var _style2 = _interopRequireDefault(_style);

var _styleRoot = __webpack_require__(934);

var _styleRoot2 = _interopRequireDefault(_styleRoot);

var _getState = __webpack_require__(282);

var _getState2 = _interopRequireDefault(_getState);

var _keyframes = __webpack_require__(936);

var _keyframes2 = _interopRequireDefault(_keyframes);

var _resolveStyles = __webpack_require__(276);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function Radium(ComposedComponent) {
  return (0, _enhancer2.default)(ComposedComponent);
}

Radium.Plugins = _plugins2.default;
Radium.Style = _style2.default;
Radium.StyleRoot = _styleRoot2.default;
Radium.getState = _getState2.default;
Radium.keyframes = _keyframes2.default;

if (process.env.NODE_ENV !== 'production') {
  Radium.TestMode = {
    clearState: _resolveStyles.__clearStateForTests,
    disable: _resolveStyles.__setTestMode.bind(null, false),
    enable: _resolveStyles.__setTestMode.bind(null, true)
  };
}

exports.default = Radium;
module.exports = exports['default'];
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(11)))

/***/ }),
/* 892 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = appendImportantToEachValue;

var _appendPxIfNeeded = __webpack_require__(277);

var _appendPxIfNeeded2 = _interopRequireDefault(_appendPxIfNeeded);

var _mapObject = __webpack_require__(278);

var _mapObject2 = _interopRequireDefault(_mapObject);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function appendImportantToEachValue(style) {
  return (0, _mapObject2.default)(style, function (result, key) {
    return (0, _appendPxIfNeeded2.default)(key, style[key]) + ' !important';
  });
}
module.exports = exports['default'];

/***/ }),
/* 893 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
var _camelCaseRegex = /([a-z])?([A-Z])/g;

var _camelCaseReplacer = function _camelCaseReplacer(match, p1, p2) {
  return (p1 || '') + '-' + p2.toLowerCase();
};

var _camelCaseToDashCase = function _camelCaseToDashCase(s) {
  return s.replace(_camelCaseRegex, _camelCaseReplacer);
};

var camelCasePropsToDashCase = function camelCasePropsToDashCase(prefixedStyle) {
  // Since prefix is expected to work on inline style objects, we must
  // translate the keys to dash case for rendering to CSS.
  return Object.keys(prefixedStyle).reduce(function (result, key) {
    var dashCaseKey = _camelCaseToDashCase(key);

    // Fix IE vendor prefix
    if (/^ms-/.test(dashCaseKey)) {
      dashCaseKey = '-' + dashCaseKey;
    }

    result[dashCaseKey] = prefixedStyle[key];
    return result;
  }, {});
};

exports.default = camelCasePropsToDashCase;
module.exports = exports['default'];

/***/ }),
/* 894 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();
// special flexbox specifications


var _prefixAll2 = __webpack_require__(895);

var _prefixAll3 = _interopRequireDefault(_prefixAll2);

var _getBrowserInformation = __webpack_require__(906);

var _getBrowserInformation2 = _interopRequireDefault(_getBrowserInformation);

var _getPrefixedKeyframes = __webpack_require__(909);

var _getPrefixedKeyframes2 = _interopRequireDefault(_getPrefixedKeyframes);

var _capitalizeString = __webpack_require__(158);

var _capitalizeString2 = _interopRequireDefault(_capitalizeString);

var _sortPrefixedStyle = __webpack_require__(280);

var _sortPrefixedStyle2 = _interopRequireDefault(_sortPrefixedStyle);

var _prefixProps = __webpack_require__(910);

var _prefixProps2 = _interopRequireDefault(_prefixProps);

var _position = __webpack_require__(911);

var _position2 = _interopRequireDefault(_position);

var _calc = __webpack_require__(912);

var _calc2 = _interopRequireDefault(_calc);

var _zoomCursor = __webpack_require__(913);

var _zoomCursor2 = _interopRequireDefault(_zoomCursor);

var _grabCursor = __webpack_require__(914);

var _grabCursor2 = _interopRequireDefault(_grabCursor);

var _flex = __webpack_require__(915);

var _flex2 = _interopRequireDefault(_flex);

var _sizing = __webpack_require__(916);

var _sizing2 = _interopRequireDefault(_sizing);

var _gradient = __webpack_require__(917);

var _gradient2 = _interopRequireDefault(_gradient);

var _transition = __webpack_require__(918);

var _transition2 = _interopRequireDefault(_transition);

var _flexboxIE = __webpack_require__(920);

var _flexboxIE2 = _interopRequireDefault(_flexboxIE);

var _flexboxOld = __webpack_require__(921);

var _flexboxOld2 = _interopRequireDefault(_flexboxOld);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var plugins = [_position2.default, _calc2.default, _zoomCursor2.default, _grabCursor2.default, _sizing2.default, _gradient2.default, _transition2.default, _flexboxIE2.default, _flexboxOld2.default,
// this must be run AFTER the flexbox specs
_flex2.default];

var Prefixer = function () {
  /**
   * Instantiante a new prefixer
   * @param {string} userAgent - userAgent to gather prefix information according to caniuse.com
   * @param {string} keepUnprefixed - keeps unprefixed properties and values
   */

  function Prefixer() {
    var _this = this;

    var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    _classCallCheck(this, Prefixer);

    var defaultUserAgent = typeof navigator !== 'undefined' ? navigator.userAgent : undefined;

    this._userAgent = options.userAgent || defaultUserAgent;
    this._keepUnprefixed = options.keepUnprefixed || false;

    this._browserInfo = (0, _getBrowserInformation2.default)(this._userAgent);

    // Checks if the userAgent was resolved correctly
    if (this._browserInfo && this._browserInfo.prefix) {
      // set additional prefix information
      this.cssPrefix = this._browserInfo.prefix.css;
      this.jsPrefix = this._browserInfo.prefix.inline;
      this.prefixedKeyframes = (0, _getPrefixedKeyframes2.default)(this._browserInfo);
    } else {
      this._usePrefixAllFallback = true;
      return false;
    }

    var data = this._browserInfo.browser && _prefixProps2.default[this._browserInfo.browser];
    if (data) {
      this._requiresPrefix = Object.keys(data).filter(function (key) {
        return data[key] >= _this._browserInfo.version;
      }).reduce(function (result, name) {
        result[name] = true;
        return result;
      }, {});
      this._hasPropsRequiringPrefix = Object.keys(this._requiresPrefix).length > 0;
    } else {
      this._usePrefixAllFallback = true;
    }
  }

  /**
   * Returns a prefixed version of the style object
   * @param {Object} styles - Style object that gets prefixed properties added
   * @returns {Object} - Style object with prefixed properties and values
   */


  _createClass(Prefixer, [{
    key: 'prefix',
    value: function prefix(styles) {
      var _this2 = this;

      // use prefixAll as fallback if userAgent can not be resolved
      if (this._usePrefixAllFallback) {
        return (0, _prefixAll3.default)(styles);
      }

      // only add prefixes if needed
      if (!this._hasPropsRequiringPrefix) {
        return styles;
      }

      Object.keys(styles).forEach(function (property) {
        var value = styles[property];
        if (value instanceof Object && !Array.isArray(value)) {
          // recurse through nested style objects
          styles[property] = _this2.prefix(value);
        } else {
          // add prefixes if needed
          if (_this2._requiresPrefix[property]) {
            styles[_this2.jsPrefix + (0, _capitalizeString2.default)(property)] = value;
            if (!_this2._keepUnprefixed) {
              delete styles[property];
            }
          }
        }
      });

      Object.keys(styles).forEach(function (property) {
        [].concat(styles[property]).forEach(function (value) {
          // resolve plugins
          plugins.forEach(function (plugin) {
            // generates a new plugin interface with current data
            assignStyles(styles, plugin({
              property: property,
              value: value,
              styles: styles,
              browserInfo: _this2._browserInfo,
              prefix: {
                js: _this2.jsPrefix,
                css: _this2.cssPrefix,
                keyframes: _this2.prefixedKeyframes
              },
              keepUnprefixed: _this2._keepUnprefixed,
              requiresPrefix: _this2._requiresPrefix
            }), value, _this2._keepUnprefixed);
          });
        });
      });

      return (0, _sortPrefixedStyle2.default)(styles);
    }

    /**
     * Returns a prefixed version of the style object using all vendor prefixes
     * @param {Object} styles - Style object that gets prefixed properties added
     * @returns {Object} - Style object with prefixed properties and values
     */

  }], [{
    key: 'prefixAll',
    value: function prefixAll(styles) {
      return (0, _prefixAll3.default)(styles);
    }
  }]);

  return Prefixer;
}();

exports.default = Prefixer;


function assignStyles(base) {
  var extend = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
  var value = arguments[2];
  var keepUnprefixed = arguments[3];

  Object.keys(extend).forEach(function (property) {
    var baseValue = base[property];
    if (Array.isArray(baseValue)) {
      [].concat(extend[property]).forEach(function (val) {
        if (base[property].indexOf(val) === -1) {
          base[property].splice(baseValue.indexOf(value), keepUnprefixed ? 0 : 1, val);
        }
      });
    } else {
      base[property] = extend[property];
    }
  });
}
module.exports = exports['default'];

/***/ }),
/* 895 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = prefixAll;

var _prefixProps = __webpack_require__(279);

var _prefixProps2 = _interopRequireDefault(_prefixProps);

var _capitalizeString = __webpack_require__(158);

var _capitalizeString2 = _interopRequireDefault(_capitalizeString);

var _sortPrefixedStyle = __webpack_require__(280);

var _sortPrefixedStyle2 = _interopRequireDefault(_sortPrefixedStyle);

var _position = __webpack_require__(897);

var _position2 = _interopRequireDefault(_position);

var _calc = __webpack_require__(898);

var _calc2 = _interopRequireDefault(_calc);

var _cursor = __webpack_require__(899);

var _cursor2 = _interopRequireDefault(_cursor);

var _flex = __webpack_require__(900);

var _flex2 = _interopRequireDefault(_flex);

var _sizing = __webpack_require__(901);

var _sizing2 = _interopRequireDefault(_sizing);

var _gradient = __webpack_require__(902);

var _gradient2 = _interopRequireDefault(_gradient);

var _transition = __webpack_require__(903);

var _transition2 = _interopRequireDefault(_transition);

var _flexboxIE = __webpack_require__(904);

var _flexboxIE2 = _interopRequireDefault(_flexboxIE);

var _flexboxOld = __webpack_require__(905);

var _flexboxOld2 = _interopRequireDefault(_flexboxOld);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// special flexbox specifications


var plugins = [_position2.default, _calc2.default, _cursor2.default, _sizing2.default, _gradient2.default, _transition2.default, _flexboxIE2.default, _flexboxOld2.default, _flex2.default];

/**
 * Returns a prefixed version of the style object using all vendor prefixes
 * @param {Object} styles - Style object that gets prefixed properties added
 * @returns {Object} - Style object with prefixed properties and values
 */
function prefixAll(styles) {
  Object.keys(styles).forEach(function (property) {
    var value = styles[property];
    if (value instanceof Object && !Array.isArray(value)) {
      // recurse through nested style objects
      styles[property] = prefixAll(value);
    } else {
      Object.keys(_prefixProps2.default).forEach(function (prefix) {
        var properties = _prefixProps2.default[prefix];
        // add prefixes if needed
        if (properties[property]) {
          styles[prefix + (0, _capitalizeString2.default)(property)] = value;
        }
      });
    }
  });

  Object.keys(styles).forEach(function (property) {
    [].concat(styles[property]).forEach(function (value, index) {
      // resolve every special plugins
      plugins.forEach(function (plugin) {
        return assignStyles(styles, plugin(property, value));
      });
    });
  });

  return (0, _sortPrefixedStyle2.default)(styles);
}

function assignStyles(base) {
  var extend = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

  Object.keys(extend).forEach(function (property) {
    var baseValue = base[property];
    if (Array.isArray(baseValue)) {
      [].concat(extend[property]).forEach(function (value) {
        var valueIndex = baseValue.indexOf(value);
        if (valueIndex > -1) {
          base[property].splice(valueIndex, 1);
        }
        base[property].push(value);
      });
    } else {
      base[property] = extend[property];
    }
  });
}
module.exports = exports['default'];

/***/ }),
/* 896 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (property) {
  return property.match(/^(Webkit|Moz|O|ms)/) !== null;
};

module.exports = exports["default"];

/***/ }),
/* 897 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = position;
function position(property, value) {
  if (property === 'position' && value === 'sticky') {
    return { position: ['-webkit-sticky', 'sticky'] };
  }
}
module.exports = exports['default'];

/***/ }),
/* 898 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = calc;

var _joinPrefixedValue = __webpack_require__(103);

var _joinPrefixedValue2 = _interopRequireDefault(_joinPrefixedValue);

var _isPrefixedValue = __webpack_require__(159);

var _isPrefixedValue2 = _interopRequireDefault(_isPrefixedValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function calc(property, value) {
  if (typeof value === 'string' && !(0, _isPrefixedValue2.default)(value) && value.indexOf('calc(') > -1) {
    return (0, _joinPrefixedValue2.default)(property, value, function (prefix, value) {
      return value.replace(/calc\(/g, prefix + 'calc(');
    });
  }
}
module.exports = exports['default'];

/***/ }),
/* 899 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = cursor;

var _joinPrefixedValue = __webpack_require__(103);

var _joinPrefixedValue2 = _interopRequireDefault(_joinPrefixedValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var values = {
  'zoom-in': true,
  'zoom-out': true,
  grab: true,
  grabbing: true
};

function cursor(property, value) {
  if (property === 'cursor' && values[value]) {
    return (0, _joinPrefixedValue2.default)(property, value);
  }
}
module.exports = exports['default'];

/***/ }),
/* 900 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = flex;
var values = { flex: true, 'inline-flex': true };

function flex(property, value) {
  if (property === 'display' && values[value]) {
    return {
      display: ['-webkit-box', '-moz-box', '-ms-' + value + 'box', '-webkit-' + value, value]
    };
  }
}
module.exports = exports['default'];

/***/ }),
/* 901 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = sizing;

var _joinPrefixedValue = __webpack_require__(103);

var _joinPrefixedValue2 = _interopRequireDefault(_joinPrefixedValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var properties = {
  maxHeight: true,
  maxWidth: true,
  width: true,
  height: true,
  columnWidth: true,
  minWidth: true,
  minHeight: true
};
var values = {
  'min-content': true,
  'max-content': true,
  'fill-available': true,
  'fit-content': true,
  'contain-floats': true
};

function sizing(property, value) {
  if (properties[property] && values[value]) {
    return (0, _joinPrefixedValue2.default)(property, value);
  }
}
module.exports = exports['default'];

/***/ }),
/* 902 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = gradient;

var _joinPrefixedValue = __webpack_require__(103);

var _joinPrefixedValue2 = _interopRequireDefault(_joinPrefixedValue);

var _isPrefixedValue = __webpack_require__(159);

var _isPrefixedValue2 = _interopRequireDefault(_isPrefixedValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var values = /linear-gradient|radial-gradient|repeating-linear-gradient|repeating-radial-gradient/;

function gradient(property, value) {
  if (typeof value === 'string' && !(0, _isPrefixedValue2.default)(value) && value.match(values) !== null) {
    return (0, _joinPrefixedValue2.default)(property, value);
  }
}
module.exports = exports['default'];

/***/ }),
/* 903 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = transition;

var _hyphenateStyleName = __webpack_require__(281);

var _hyphenateStyleName2 = _interopRequireDefault(_hyphenateStyleName);

var _capitalizeString = __webpack_require__(158);

var _capitalizeString2 = _interopRequireDefault(_capitalizeString);

var _isPrefixedValue = __webpack_require__(159);

var _isPrefixedValue2 = _interopRequireDefault(_isPrefixedValue);

var _prefixProps = __webpack_require__(279);

var _prefixProps2 = _interopRequireDefault(_prefixProps);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var properties = {
  transition: true,
  transitionProperty: true,
  WebkitTransition: true,
  WebkitTransitionProperty: true
};

function transition(property, value) {
  // also check for already prefixed transitions
  if (typeof value === 'string' && properties[property]) {
    var _ref2;

    var outputValue = prefixValue(value);
    var webkitOutput = outputValue.split(/,(?![^()]*(?:\([^()]*\))?\))/g).filter(function (value) {
      return value.match(/-moz-|-ms-/) === null;
    }).join(',');

    // if the property is already prefixed
    if (property.indexOf('Webkit') > -1) {
      return _defineProperty({}, property, webkitOutput);
    }

    return _ref2 = {}, _defineProperty(_ref2, 'Webkit' + (0, _capitalizeString2.default)(property), webkitOutput), _defineProperty(_ref2, property, outputValue), _ref2;
  }
}

function prefixValue(value) {
  if ((0, _isPrefixedValue2.default)(value)) {
    return value;
  }

  // only split multi values, not cubic beziers
  var multipleValues = value.split(/,(?![^()]*(?:\([^()]*\))?\))/g);

  // iterate each single value and check for transitioned properties
  // that need to be prefixed as well
  multipleValues.forEach(function (val, index) {
    multipleValues[index] = Object.keys(_prefixProps2.default).reduce(function (out, prefix) {
      var dashCasePrefix = '-' + prefix.toLowerCase() + '-';

      Object.keys(_prefixProps2.default[prefix]).forEach(function (prop) {
        var dashCaseProperty = (0, _hyphenateStyleName2.default)(prop);

        if (val.indexOf(dashCaseProperty) > -1 && dashCaseProperty !== 'order') {
          // join all prefixes and create a new value
          out = val.replace(dashCaseProperty, dashCasePrefix + dashCaseProperty) + ',' + out;
        }
      });
      return out;
    }, val);
  });

  return multipleValues.join(',');
}
module.exports = exports['default'];

/***/ }),
/* 904 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = flexboxIE;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var alternativeValues = {
  'space-around': 'distribute',
  'space-between': 'justify',
  'flex-start': 'start',
  'flex-end': 'end'
};
var alternativeProps = {
  alignContent: 'msFlexLinePack',
  alignSelf: 'msFlexItemAlign',
  alignItems: 'msFlexAlign',
  justifyContent: 'msFlexPack',
  order: 'msFlexOrder',
  flexGrow: 'msFlexPositive',
  flexShrink: 'msFlexNegative',
  flexBasis: 'msPreferredSize'
};

function flexboxIE(property, value) {
  if (alternativeProps[property]) {
    return _defineProperty({}, alternativeProps[property], alternativeValues[value] || value);
  }
}
module.exports = exports['default'];

/***/ }),
/* 905 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = flexboxOld;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var alternativeValues = {
  'space-around': 'justify',
  'space-between': 'justify',
  'flex-start': 'start',
  'flex-end': 'end',
  'wrap-reverse': 'multiple',
  wrap: 'multiple'
};

var alternativeProps = {
  alignItems: 'WebkitBoxAlign',
  justifyContent: 'WebkitBoxPack',
  flexWrap: 'WebkitBoxLines'
};

function flexboxOld(property, value) {
  if (property === 'flexDirection' && typeof value === 'string') {
    return {
      WebkitBoxOrient: value.indexOf('column') > -1 ? 'vertical' : 'horizontal',
      WebkitBoxDirection: value.indexOf('reverse') > -1 ? 'reverse' : 'normal'
    };
  }
  if (alternativeProps[property]) {
    return _defineProperty({}, alternativeProps[property], alternativeValues[value] || value);
  }
}
module.exports = exports['default'];

/***/ }),
/* 906 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _bowser = __webpack_require__(907);

var _bowser2 = _interopRequireDefault(_bowser);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var vendorPrefixes = {
  Webkit: ['chrome', 'safari', 'ios', 'android', 'phantom', 'opera', 'webos', 'blackberry', 'bada', 'tizen', 'chromium', 'vivaldi'],
  Moz: ['firefox', 'seamonkey', 'sailfish'],
  ms: ['msie', 'msedge']
};
var browsers = {
  chrome: [['chrome'], ['chromium']],
  safari: [['safari']],
  firefox: [['firefox']],
  edge: [['msedge']],
  opera: [['opera'], ['vivaldi']],
  ios_saf: [['ios', 'mobile'], ['ios', 'tablet']],
  ie: [['msie']],
  op_mini: [['opera', 'mobile'], ['opera', 'tablet']],
  and_uc: [['android', 'mobile'], ['android', 'tablet']],
  android: [['android', 'mobile'], ['android', 'tablet']]
};

var browserByInfo = function browserByInfo(info) {
  if (info.firefox) {
    return 'firefox';
  }
  var name = '';

  Object.keys(browsers).forEach(function (browser) {
    browsers[browser].forEach(function (condition) {
      var match = 0;
      condition.forEach(function (single) {
        if (info[single]) {
          match += 1;
        }
      });
      if (condition.length === match) {
        name = browser;
      }
    });
  });

  return name;
};

/**
 * Uses bowser to get default browser information such as version and name
 * Evaluates bowser info and adds vendorPrefix information
 * @param {string} userAgent - userAgent that gets evaluated
 */

exports.default = function (userAgent) {
  if (!userAgent) {
    return false;
  }
  var info = _bowser2.default._detect(userAgent);

  Object.keys(vendorPrefixes).forEach(function (prefix) {
    vendorPrefixes[prefix].forEach(function (browser) {
      if (info[browser]) {
        info.prefix = {
          inline: prefix,
          css: '-' + prefix.toLowerCase() + '-'
        };
      }
    });
  });

  info.browser = browserByInfo(info);

  // For cordova IOS 8 the version is missing, set truncated osversion to prevent NaN
  info.version = info.version ? parseFloat(info.version) : parseInt(parseFloat(info.osversion), 10);
  info.osversion = parseFloat(info.osversion);

  // iOS forces all browsers to use Safari under the hood
  // as the Safari version seems to match the iOS version
  // we just explicitely use the osversion instead
  // https://github.com/rofrischmann/inline-style-prefixer/issues/72
  if (info.browser === 'ios_saf' && info.version > info.osversion) {
    info.version = info.osversion;
    info.safari = true;
  }

  // seperate native android chrome
  // https://github.com/rofrischmann/inline-style-prefixer/issues/45
  if (info.browser === 'android' && info.chrome && info.version > 37) {
    info.browser = 'and_chr';
  }

  // For android < 4.4 we want to check the osversion
  // not the chrome version, see issue #26
  // https://github.com/rofrischmann/inline-style-prefixer/issues/26
  if (info.browser === 'android' && info.osversion < 5) {
    info.version = info.osversion;
  }

  return info;
};

module.exports = exports['default'];

/***/ }),
/* 907 */
/***/ (function(module, exports, __webpack_require__) {

/*!
 * Bowser - a browser detector
 * https://github.com/ded/bowser
 * MIT License | (c) Dustin Diaz 2015
 */

!function (root, name, definition) {
  if (typeof module != 'undefined' && module.exports) module.exports = definition();else if (true) __webpack_require__(908)(name, definition);else root[name] = definition();
}(this, 'bowser', function () {
  /**
    * See useragents.js for examples of navigator.userAgent
    */

  var t = true;

  function detect(ua) {

    function getFirstMatch(regex) {
      var match = ua.match(regex);
      return match && match.length > 1 && match[1] || '';
    }

    function getSecondMatch(regex) {
      var match = ua.match(regex);
      return match && match.length > 1 && match[2] || '';
    }

    var iosdevice = getFirstMatch(/(ipod|iphone|ipad)/i).toLowerCase(),
        likeAndroid = /like android/i.test(ua),
        android = !likeAndroid && /android/i.test(ua),
        nexusMobile = /nexus\s*[0-6]\s*/i.test(ua),
        nexusTablet = !nexusMobile && /nexus\s*[0-9]+/i.test(ua),
        chromeos = /CrOS/.test(ua),
        silk = /silk/i.test(ua),
        sailfish = /sailfish/i.test(ua),
        tizen = /tizen/i.test(ua),
        webos = /(web|hpw)(o|0)s/i.test(ua),
        windowsphone = /windows phone/i.test(ua),
        samsungBrowser = /SamsungBrowser/i.test(ua),
        windows = !windowsphone && /windows/i.test(ua),
        mac = !iosdevice && !silk && /macintosh/i.test(ua),
        linux = !android && !sailfish && !tizen && !webos && /linux/i.test(ua),
        edgeVersion = getSecondMatch(/edg([ea]|ios)\/(\d+(\.\d+)?)/i),
        versionIdentifier = getFirstMatch(/version\/(\d+(\.\d+)?)/i),
        tablet = /tablet/i.test(ua) && !/tablet pc/i.test(ua),
        mobile = !tablet && /[^-]mobi/i.test(ua),
        xbox = /xbox/i.test(ua),
        result;

    if (/opera/i.test(ua)) {
      //  an old Opera
      result = {
        name: 'Opera',
        opera: t,
        version: versionIdentifier || getFirstMatch(/(?:opera|opr|opios)[\s\/](\d+(\.\d+)?)/i)
      };
    } else if (/opr\/|opios/i.test(ua)) {
      // a new Opera
      result = {
        name: 'Opera',
        opera: t,
        version: getFirstMatch(/(?:opr|opios)[\s\/](\d+(\.\d+)?)/i) || versionIdentifier
      };
    } else if (/SamsungBrowser/i.test(ua)) {
      result = {
        name: 'Samsung Internet for Android',
        samsungBrowser: t,
        version: versionIdentifier || getFirstMatch(/(?:SamsungBrowser)[\s\/](\d+(\.\d+)?)/i)
      };
    } else if (/Whale/i.test(ua)) {
      result = {
        name: 'NAVER Whale browser',
        whale: t,
        version: getFirstMatch(/(?:whale)[\s\/](\d+(?:\.\d+)+)/i)
      };
    } else if (/MZBrowser/i.test(ua)) {
      result = {
        name: 'MZ Browser',
        mzbrowser: t,
        version: getFirstMatch(/(?:MZBrowser)[\s\/](\d+(?:\.\d+)+)/i)
      };
    } else if (/coast/i.test(ua)) {
      result = {
        name: 'Opera Coast',
        coast: t,
        version: versionIdentifier || getFirstMatch(/(?:coast)[\s\/](\d+(\.\d+)?)/i)
      };
    } else if (/focus/i.test(ua)) {
      result = {
        name: 'Focus',
        focus: t,
        version: getFirstMatch(/(?:focus)[\s\/](\d+(?:\.\d+)+)/i)
      };
    } else if (/yabrowser/i.test(ua)) {
      result = {
        name: 'Yandex Browser',
        yandexbrowser: t,
        version: versionIdentifier || getFirstMatch(/(?:yabrowser)[\s\/](\d+(\.\d+)?)/i)
      };
    } else if (/ucbrowser/i.test(ua)) {
      result = {
        name: 'UC Browser',
        ucbrowser: t,
        version: getFirstMatch(/(?:ucbrowser)[\s\/](\d+(?:\.\d+)+)/i)
      };
    } else if (/mxios/i.test(ua)) {
      result = {
        name: 'Maxthon',
        maxthon: t,
        version: getFirstMatch(/(?:mxios)[\s\/](\d+(?:\.\d+)+)/i)
      };
    } else if (/epiphany/i.test(ua)) {
      result = {
        name: 'Epiphany',
        epiphany: t,
        version: getFirstMatch(/(?:epiphany)[\s\/](\d+(?:\.\d+)+)/i)
      };
    } else if (/puffin/i.test(ua)) {
      result = {
        name: 'Puffin',
        puffin: t,
        version: getFirstMatch(/(?:puffin)[\s\/](\d+(?:\.\d+)?)/i)
      };
    } else if (/sleipnir/i.test(ua)) {
      result = {
        name: 'Sleipnir',
        sleipnir: t,
        version: getFirstMatch(/(?:sleipnir)[\s\/](\d+(?:\.\d+)+)/i)
      };
    } else if (/k-meleon/i.test(ua)) {
      result = {
        name: 'K-Meleon',
        kMeleon: t,
        version: getFirstMatch(/(?:k-meleon)[\s\/](\d+(?:\.\d+)+)/i)
      };
    } else if (windowsphone) {
      result = {
        name: 'Windows Phone',
        osname: 'Windows Phone',
        windowsphone: t
      };
      if (edgeVersion) {
        result.msedge = t;
        result.version = edgeVersion;
      } else {
        result.msie = t;
        result.version = getFirstMatch(/iemobile\/(\d+(\.\d+)?)/i);
      }
    } else if (/msie|trident/i.test(ua)) {
      result = {
        name: 'Internet Explorer',
        msie: t,
        version: getFirstMatch(/(?:msie |rv:)(\d+(\.\d+)?)/i)
      };
    } else if (chromeos) {
      result = {
        name: 'Chrome',
        osname: 'Chrome OS',
        chromeos: t,
        chromeBook: t,
        chrome: t,
        version: getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)
      };
    } else if (/edg([ea]|ios)/i.test(ua)) {
      result = {
        name: 'Microsoft Edge',
        msedge: t,
        version: edgeVersion
      };
    } else if (/vivaldi/i.test(ua)) {
      result = {
        name: 'Vivaldi',
        vivaldi: t,
        version: getFirstMatch(/vivaldi\/(\d+(\.\d+)?)/i) || versionIdentifier
      };
    } else if (sailfish) {
      result = {
        name: 'Sailfish',
        osname: 'Sailfish OS',
        sailfish: t,
        version: getFirstMatch(/sailfish\s?browser\/(\d+(\.\d+)?)/i)
      };
    } else if (/seamonkey\//i.test(ua)) {
      result = {
        name: 'SeaMonkey',
        seamonkey: t,
        version: getFirstMatch(/seamonkey\/(\d+(\.\d+)?)/i)
      };
    } else if (/firefox|iceweasel|fxios/i.test(ua)) {
      result = {
        name: 'Firefox',
        firefox: t,
        version: getFirstMatch(/(?:firefox|iceweasel|fxios)[ \/](\d+(\.\d+)?)/i)
      };
      if (/\((mobile|tablet);[^\)]*rv:[\d\.]+\)/i.test(ua)) {
        result.firefoxos = t;
        result.osname = 'Firefox OS';
      }
    } else if (silk) {
      result = {
        name: 'Amazon Silk',
        silk: t,
        version: getFirstMatch(/silk\/(\d+(\.\d+)?)/i)
      };
    } else if (/phantom/i.test(ua)) {
      result = {
        name: 'PhantomJS',
        phantom: t,
        version: getFirstMatch(/phantomjs\/(\d+(\.\d+)?)/i)
      };
    } else if (/slimerjs/i.test(ua)) {
      result = {
        name: 'SlimerJS',
        slimer: t,
        version: getFirstMatch(/slimerjs\/(\d+(\.\d+)?)/i)
      };
    } else if (/blackberry|\bbb\d+/i.test(ua) || /rim\stablet/i.test(ua)) {
      result = {
        name: 'BlackBerry',
        osname: 'BlackBerry OS',
        blackberry: t,
        version: versionIdentifier || getFirstMatch(/blackberry[\d]+\/(\d+(\.\d+)?)/i)
      };
    } else if (webos) {
      result = {
        name: 'WebOS',
        osname: 'WebOS',
        webos: t,
        version: versionIdentifier || getFirstMatch(/w(?:eb)?osbrowser\/(\d+(\.\d+)?)/i)
      };
      /touchpad\//i.test(ua) && (result.touchpad = t);
    } else if (/bada/i.test(ua)) {
      result = {
        name: 'Bada',
        osname: 'Bada',
        bada: t,
        version: getFirstMatch(/dolfin\/(\d+(\.\d+)?)/i)
      };
    } else if (tizen) {
      result = {
        name: 'Tizen',
        osname: 'Tizen',
        tizen: t,
        version: getFirstMatch(/(?:tizen\s?)?browser\/(\d+(\.\d+)?)/i) || versionIdentifier
      };
    } else if (/qupzilla/i.test(ua)) {
      result = {
        name: 'QupZilla',
        qupzilla: t,
        version: getFirstMatch(/(?:qupzilla)[\s\/](\d+(?:\.\d+)+)/i) || versionIdentifier
      };
    } else if (/chromium/i.test(ua)) {
      result = {
        name: 'Chromium',
        chromium: t,
        version: getFirstMatch(/(?:chromium)[\s\/](\d+(?:\.\d+)?)/i) || versionIdentifier
      };
    } else if (/chrome|crios|crmo/i.test(ua)) {
      result = {
        name: 'Chrome',
        chrome: t,
        version: getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)
      };
    } else if (android) {
      result = {
        name: 'Android',
        version: versionIdentifier
      };
    } else if (/safari|applewebkit/i.test(ua)) {
      result = {
        name: 'Safari',
        safari: t
      };
      if (versionIdentifier) {
        result.version = versionIdentifier;
      }
    } else if (iosdevice) {
      result = {
        name: iosdevice == 'iphone' ? 'iPhone' : iosdevice == 'ipad' ? 'iPad' : 'iPod'
        // WTF: version is not part of user agent in web apps
      };if (versionIdentifier) {
        result.version = versionIdentifier;
      }
    } else if (/googlebot/i.test(ua)) {
      result = {
        name: 'Googlebot',
        googlebot: t,
        version: getFirstMatch(/googlebot\/(\d+(\.\d+))/i) || versionIdentifier
      };
    } else {
      result = {
        name: getFirstMatch(/^(.*)\/(.*) /),
        version: getSecondMatch(/^(.*)\/(.*) /)
      };
    }

    // set webkit or gecko flag for browsers based on these engines
    if (!result.msedge && /(apple)?webkit/i.test(ua)) {
      if (/(apple)?webkit\/537\.36/i.test(ua)) {
        result.name = result.name || "Blink";
        result.blink = t;
      } else {
        result.name = result.name || "Webkit";
        result.webkit = t;
      }
      if (!result.version && versionIdentifier) {
        result.version = versionIdentifier;
      }
    } else if (!result.opera && /gecko\//i.test(ua)) {
      result.name = result.name || "Gecko";
      result.gecko = t;
      result.version = result.version || getFirstMatch(/gecko\/(\d+(\.\d+)?)/i);
    }

    // set OS flags for platforms that have multiple browsers
    if (!result.windowsphone && (android || result.silk)) {
      result.android = t;
      result.osname = 'Android';
    } else if (!result.windowsphone && iosdevice) {
      result[iosdevice] = t;
      result.ios = t;
      result.osname = 'iOS';
    } else if (mac) {
      result.mac = t;
      result.osname = 'macOS';
    } else if (xbox) {
      result.xbox = t;
      result.osname = 'Xbox';
    } else if (windows) {
      result.windows = t;
      result.osname = 'Windows';
    } else if (linux) {
      result.linux = t;
      result.osname = 'Linux';
    }

    function getWindowsVersion(s) {
      switch (s) {
        case 'NT':
          return 'NT';
        case 'XP':
          return 'XP';
        case 'NT 5.0':
          return '2000';
        case 'NT 5.1':
          return 'XP';
        case 'NT 5.2':
          return '2003';
        case 'NT 6.0':
          return 'Vista';
        case 'NT 6.1':
          return '7';
        case 'NT 6.2':
          return '8';
        case 'NT 6.3':
          return '8.1';
        case 'NT 10.0':
          return '10';
        default:
          return undefined;
      }
    }

    // OS version extraction
    var osVersion = '';
    if (result.windows) {
      osVersion = getWindowsVersion(getFirstMatch(/Windows ((NT|XP)( \d\d?.\d)?)/i));
    } else if (result.windowsphone) {
      osVersion = getFirstMatch(/windows phone (?:os)?\s?(\d+(\.\d+)*)/i);
    } else if (result.mac) {
      osVersion = getFirstMatch(/Mac OS X (\d+([_\.\s]\d+)*)/i);
      osVersion = osVersion.replace(/[_\s]/g, '.');
    } else if (iosdevice) {
      osVersion = getFirstMatch(/os (\d+([_\s]\d+)*) like mac os x/i);
      osVersion = osVersion.replace(/[_\s]/g, '.');
    } else if (android) {
      osVersion = getFirstMatch(/android[ \/-](\d+(\.\d+)*)/i);
    } else if (result.webos) {
      osVersion = getFirstMatch(/(?:web|hpw)os\/(\d+(\.\d+)*)/i);
    } else if (result.blackberry) {
      osVersion = getFirstMatch(/rim\stablet\sos\s(\d+(\.\d+)*)/i);
    } else if (result.bada) {
      osVersion = getFirstMatch(/bada\/(\d+(\.\d+)*)/i);
    } else if (result.tizen) {
      osVersion = getFirstMatch(/tizen[\/\s](\d+(\.\d+)*)/i);
    }
    if (osVersion) {
      result.osversion = osVersion;
    }

    // device type extraction
    var osMajorVersion = !result.windows && osVersion.split('.')[0];
    if (tablet || nexusTablet || iosdevice == 'ipad' || android && (osMajorVersion == 3 || osMajorVersion >= 4 && !mobile) || result.silk) {
      result.tablet = t;
    } else if (mobile || iosdevice == 'iphone' || iosdevice == 'ipod' || android || nexusMobile || result.blackberry || result.webos || result.bada) {
      result.mobile = t;
    }

    // Graded Browser Support
    // http://developer.yahoo.com/yui/articles/gbs
    if (result.msedge || result.msie && result.version >= 10 || result.yandexbrowser && result.version >= 15 || result.vivaldi && result.version >= 1.0 || result.chrome && result.version >= 20 || result.samsungBrowser && result.version >= 4 || result.whale && compareVersions([result.version, '1.0']) === 1 || result.mzbrowser && compareVersions([result.version, '6.0']) === 1 || result.focus && compareVersions([result.version, '1.0']) === 1 || result.firefox && result.version >= 20.0 || result.safari && result.version >= 6 || result.opera && result.version >= 10.0 || result.ios && result.osversion && result.osversion.split(".")[0] >= 6 || result.blackberry && result.version >= 10.1 || result.chromium && result.version >= 20) {
      result.a = t;
    } else if (result.msie && result.version < 10 || result.chrome && result.version < 20 || result.firefox && result.version < 20.0 || result.safari && result.version < 6 || result.opera && result.version < 10.0 || result.ios && result.osversion && result.osversion.split(".")[0] < 6 || result.chromium && result.version < 20) {
      result.c = t;
    } else result.x = t;

    return result;
  }

  var bowser = detect(typeof navigator !== 'undefined' ? navigator.userAgent || '' : '');

  bowser.test = function (browserList) {
    for (var i = 0; i < browserList.length; ++i) {
      var browserItem = browserList[i];
      if (typeof browserItem === 'string') {
        if (browserItem in bowser) {
          return true;
        }
      }
    }
    return false;
  };

  /**
   * Get version precisions count
   *
   * @example
   *   getVersionPrecision("1.10.3") // 3
   *
   * @param  {string} version
   * @return {number}
   */
  function getVersionPrecision(version) {
    return version.split(".").length;
  }

  /**
   * Array::map polyfill
   *
   * @param  {Array} arr
   * @param  {Function} iterator
   * @return {Array}
   */
  function map(arr, iterator) {
    var result = [],
        i;
    if (Array.prototype.map) {
      return Array.prototype.map.call(arr, iterator);
    }
    for (i = 0; i < arr.length; i++) {
      result.push(iterator(arr[i]));
    }
    return result;
  }

  /**
   * Calculate browser version weight
   *
   * @example
   *   compareVersions(['1.10.2.1',  '1.8.2.1.90'])    // 1
   *   compareVersions(['1.010.2.1', '1.09.2.1.90']);  // 1
   *   compareVersions(['1.10.2.1',  '1.10.2.1']);     // 0
   *   compareVersions(['1.10.2.1',  '1.0800.2']);     // -1
   *
   * @param  {Array<String>} versions versions to compare
   * @return {Number} comparison result
   */
  function compareVersions(versions) {
    // 1) get common precision for both versions, for example for "10.0" and "9" it should be 2
    var precision = Math.max(getVersionPrecision(versions[0]), getVersionPrecision(versions[1]));
    var chunks = map(versions, function (version) {
      var delta = precision - getVersionPrecision(version);

      // 2) "9" -> "9.0" (for precision = 2)
      version = version + new Array(delta + 1).join(".0");

      // 3) "9.0" -> ["000000000"", "000000009"]
      return map(version.split("."), function (chunk) {
        return new Array(20 - chunk.length).join("0") + chunk;
      }).reverse();
    });

    // iterate in reverse order by reversed chunks array
    while (--precision >= 0) {
      // 4) compare: "000000009" > "000000010" = false (but "9" > "10" = true)
      if (chunks[0][precision] > chunks[1][precision]) {
        return 1;
      } else if (chunks[0][precision] === chunks[1][precision]) {
        if (precision === 0) {
          // all version chunks are same
          return 0;
        }
      } else {
        return -1;
      }
    }
  }

  /**
   * Check if browser is unsupported
   *
   * @example
   *   bowser.isUnsupportedBrowser({
   *     msie: "10",
   *     firefox: "23",
   *     chrome: "29",
   *     safari: "5.1",
   *     opera: "16",
   *     phantom: "534"
   *   });
   *
   * @param  {Object}  minVersions map of minimal version to browser
   * @param  {Boolean} [strictMode = false] flag to return false if browser wasn't found in map
   * @param  {String}  [ua] user agent string
   * @return {Boolean}
   */
  function isUnsupportedBrowser(minVersions, strictMode, ua) {
    var _bowser = bowser;

    // make strictMode param optional with ua param usage
    if (typeof strictMode === 'string') {
      ua = strictMode;
      strictMode = void 0;
    }

    if (strictMode === void 0) {
      strictMode = false;
    }
    if (ua) {
      _bowser = detect(ua);
    }

    var version = "" + _bowser.version;
    for (var browser in minVersions) {
      if (minVersions.hasOwnProperty(browser)) {
        if (_bowser[browser]) {
          if (typeof minVersions[browser] !== 'string') {
            throw new Error('Browser version in the minVersion map should be a string: ' + browser + ': ' + String(minVersions));
          }

          // browser version and min supported version.
          return compareVersions([version, minVersions[browser]]) < 0;
        }
      }
    }

    return strictMode; // not found
  }

  /**
   * Check if browser is supported
   *
   * @param  {Object} minVersions map of minimal version to browser
   * @param  {Boolean} [strictMode = false] flag to return false if browser wasn't found in map
   * @param  {String}  [ua] user agent string
   * @return {Boolean}
   */
  function check(minVersions, strictMode, ua) {
    return !isUnsupportedBrowser(minVersions, strictMode, ua);
  }

  bowser.isUnsupportedBrowser = isUnsupportedBrowser;
  bowser.compareVersions = compareVersions;
  bowser.check = check;

  /*
   * Set our detect method to the main bowser object so we can
   * reuse it to test other user agents.
   * This is needed to implement future tests.
   */
  bowser._detect = detect;

  /*
   * Set our detect public method to the main bowser object
   * This is needed to implement bowser in server side
   */
  bowser.detect = detect;
  return bowser;
});

/***/ }),
/* 908 */
/***/ (function(module, exports) {

module.exports = function() {
	throw new Error("define cannot be used indirect");
};


/***/ }),
/* 909 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (_ref) {
  var browser = _ref.browser;
  var version = _ref.version;
  var prefix = _ref.prefix;

  var prefixedKeyframes = 'keyframes';

  if (browser === 'chrome' && version < 43 || (browser === 'safari' || browser === 'ios_saf') && version < 9 || browser === 'opera' && version < 30 || browser === 'android' && version <= 4.4 || browser === 'and_uc') {
    prefixedKeyframes = prefix.css + prefixedKeyframes;
  }
  return prefixedKeyframes;
};

module.exports = exports['default'];

/***/ }),
/* 910 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = { "chrome": { "transform": 35, "transformOrigin": 35, "transformOriginX": 35, "transformOriginY": 35, "backfaceVisibility": 35, "perspective": 35, "perspectiveOrigin": 35, "transformStyle": 35, "transformOriginZ": 35, "animation": 42, "animationDelay": 42, "animationDirection": 42, "animationFillMode": 42, "animationDuration": 42, "animationIterationCount": 42, "animationName": 42, "animationPlayState": 42, "animationTimingFunction": 42, "appearance": 55, "userSelect": 55, "fontKerning": 32, "textEmphasisPosition": 55, "textEmphasis": 55, "textEmphasisStyle": 55, "textEmphasisColor": 55, "boxDecorationBreak": 55, "clipPath": 55, "maskImage": 55, "maskMode": 55, "maskRepeat": 55, "maskPosition": 55, "maskClip": 55, "maskOrigin": 55, "maskSize": 55, "maskComposite": 55, "mask": 55, "maskBorderSource": 55, "maskBorderMode": 55, "maskBorderSlice": 55, "maskBorderWidth": 55, "maskBorderOutset": 55, "maskBorderRepeat": 55, "maskBorder": 55, "maskType": 55, "textDecorationStyle": 55, "textDecorationSkip": 55, "textDecorationLine": 55, "textDecorationColor": 55, "filter": 52, "fontFeatureSettings": 47, "breakAfter": 49, "breakBefore": 49, "breakInside": 49, "columnCount": 49, "columnFill": 49, "columnGap": 49, "columnRule": 49, "columnRuleColor": 49, "columnRuleStyle": 49, "columnRuleWidth": 49, "columns": 49, "columnSpan": 49, "columnWidth": 49 }, "safari": { "flex": 8, "flexBasis": 8, "flexDirection": 8, "flexGrow": 8, "flexFlow": 8, "flexShrink": 8, "flexWrap": 8, "alignContent": 8, "alignItems": 8, "alignSelf": 8, "justifyContent": 8, "order": 8, "transition": 6, "transitionDelay": 6, "transitionDuration": 6, "transitionProperty": 6, "transitionTimingFunction": 6, "transform": 8, "transformOrigin": 8, "transformOriginX": 8, "transformOriginY": 8, "backfaceVisibility": 8, "perspective": 8, "perspectiveOrigin": 8, "transformStyle": 8, "transformOriginZ": 8, "animation": 8, "animationDelay": 8, "animationDirection": 8, "animationFillMode": 8, "animationDuration": 8, "animationIterationCount": 8, "animationName": 8, "animationPlayState": 8, "animationTimingFunction": 8, "appearance": 10, "userSelect": 10, "backdropFilter": 10, "fontKerning": 9, "scrollSnapType": 10, "scrollSnapPointsX": 10, "scrollSnapPointsY": 10, "scrollSnapDestination": 10, "scrollSnapCoordinate": 10, "textEmphasisPosition": 7, "textEmphasis": 7, "textEmphasisStyle": 7, "textEmphasisColor": 7, "boxDecorationBreak": 10, "clipPath": 10, "maskImage": 10, "maskMode": 10, "maskRepeat": 10, "maskPosition": 10, "maskClip": 10, "maskOrigin": 10, "maskSize": 10, "maskComposite": 10, "mask": 10, "maskBorderSource": 10, "maskBorderMode": 10, "maskBorderSlice": 10, "maskBorderWidth": 10, "maskBorderOutset": 10, "maskBorderRepeat": 10, "maskBorder": 10, "maskType": 10, "textDecorationStyle": 10, "textDecorationSkip": 10, "textDecorationLine": 10, "textDecorationColor": 10, "shapeImageThreshold": 10, "shapeImageMargin": 10, "shapeImageOutside": 10, "filter": 9, "hyphens": 10, "flowInto": 10, "flowFrom": 10, "breakBefore": 8, "breakAfter": 8, "breakInside": 8, "regionFragment": 10, "columnCount": 8, "columnFill": 8, "columnGap": 8, "columnRule": 8, "columnRuleColor": 8, "columnRuleStyle": 8, "columnRuleWidth": 8, "columns": 8, "columnSpan": 8, "columnWidth": 8 }, "firefox": { "appearance": 51, "userSelect": 51, "boxSizing": 28, "textAlignLast": 48, "textDecorationStyle": 35, "textDecorationSkip": 35, "textDecorationLine": 35, "textDecorationColor": 35, "tabSize": 51, "hyphens": 42, "fontFeatureSettings": 33, "breakAfter": 51, "breakBefore": 51, "breakInside": 51, "columnCount": 51, "columnFill": 51, "columnGap": 51, "columnRule": 51, "columnRuleColor": 51, "columnRuleStyle": 51, "columnRuleWidth": 51, "columns": 51, "columnSpan": 51, "columnWidth": 51 }, "opera": { "flex": 16, "flexBasis": 16, "flexDirection": 16, "flexGrow": 16, "flexFlow": 16, "flexShrink": 16, "flexWrap": 16, "alignContent": 16, "alignItems": 16, "alignSelf": 16, "justifyContent": 16, "order": 16, "transform": 22, "transformOrigin": 22, "transformOriginX": 22, "transformOriginY": 22, "backfaceVisibility": 22, "perspective": 22, "perspectiveOrigin": 22, "transformStyle": 22, "transformOriginZ": 22, "animation": 29, "animationDelay": 29, "animationDirection": 29, "animationFillMode": 29, "animationDuration": 29, "animationIterationCount": 29, "animationName": 29, "animationPlayState": 29, "animationTimingFunction": 29, "appearance": 41, "userSelect": 41, "fontKerning": 19, "textEmphasisPosition": 41, "textEmphasis": 41, "textEmphasisStyle": 41, "textEmphasisColor": 41, "boxDecorationBreak": 41, "clipPath": 41, "maskImage": 41, "maskMode": 41, "maskRepeat": 41, "maskPosition": 41, "maskClip": 41, "maskOrigin": 41, "maskSize": 41, "maskComposite": 41, "mask": 41, "maskBorderSource": 41, "maskBorderMode": 41, "maskBorderSlice": 41, "maskBorderWidth": 41, "maskBorderOutset": 41, "maskBorderRepeat": 41, "maskBorder": 41, "maskType": 41, "textDecorationStyle": 41, "textDecorationSkip": 41, "textDecorationLine": 41, "textDecorationColor": 41, "filter": 39, "fontFeatureSettings": 34, "breakAfter": 36, "breakBefore": 36, "breakInside": 36, "columnCount": 36, "columnFill": 36, "columnGap": 36, "columnRule": 36, "columnRuleColor": 36, "columnRuleStyle": 36, "columnRuleWidth": 36, "columns": 36, "columnSpan": 36, "columnWidth": 36 }, "ie": { "flex": 10, "flexDirection": 10, "flexFlow": 10, "flexWrap": 10, "transform": 9, "transformOrigin": 9, "transformOriginX": 9, "transformOriginY": 9, "userSelect": 11, "wrapFlow": 11, "wrapThrough": 11, "wrapMargin": 11, "scrollSnapType": 11, "scrollSnapPointsX": 11, "scrollSnapPointsY": 11, "scrollSnapDestination": 11, "scrollSnapCoordinate": 11, "touchAction": 10, "hyphens": 11, "flowInto": 11, "flowFrom": 11, "breakBefore": 11, "breakAfter": 11, "breakInside": 11, "regionFragment": 11, "gridTemplateColumns": 11, "gridTemplateRows": 11, "gridTemplateAreas": 11, "gridTemplate": 11, "gridAutoColumns": 11, "gridAutoRows": 11, "gridAutoFlow": 11, "grid": 11, "gridRowStart": 11, "gridColumnStart": 11, "gridRowEnd": 11, "gridRow": 11, "gridColumn": 11, "gridColumnEnd": 11, "gridColumnGap": 11, "gridRowGap": 11, "gridArea": 11, "gridGap": 11, "textSizeAdjust": 11 }, "edge": { "userSelect": 14, "wrapFlow": 14, "wrapThrough": 14, "wrapMargin": 14, "scrollSnapType": 14, "scrollSnapPointsX": 14, "scrollSnapPointsY": 14, "scrollSnapDestination": 14, "scrollSnapCoordinate": 14, "hyphens": 14, "flowInto": 14, "flowFrom": 14, "breakBefore": 14, "breakAfter": 14, "breakInside": 14, "regionFragment": 14, "gridTemplateColumns": 14, "gridTemplateRows": 14, "gridTemplateAreas": 14, "gridTemplate": 14, "gridAutoColumns": 14, "gridAutoRows": 14, "gridAutoFlow": 14, "grid": 14, "gridRowStart": 14, "gridColumnStart": 14, "gridRowEnd": 14, "gridRow": 14, "gridColumn": 14, "gridColumnEnd": 14, "gridColumnGap": 14, "gridRowGap": 14, "gridArea": 14, "gridGap": 14 }, "ios_saf": { "flex": 8.1, "flexBasis": 8.1, "flexDirection": 8.1, "flexGrow": 8.1, "flexFlow": 8.1, "flexShrink": 8.1, "flexWrap": 8.1, "alignContent": 8.1, "alignItems": 8.1, "alignSelf": 8.1, "justifyContent": 8.1, "order": 8.1, "transition": 6, "transitionDelay": 6, "transitionDuration": 6, "transitionProperty": 6, "transitionTimingFunction": 6, "transform": 8.1, "transformOrigin": 8.1, "transformOriginX": 8.1, "transformOriginY": 8.1, "backfaceVisibility": 8.1, "perspective": 8.1, "perspectiveOrigin": 8.1, "transformStyle": 8.1, "transformOriginZ": 8.1, "animation": 8.1, "animationDelay": 8.1, "animationDirection": 8.1, "animationFillMode": 8.1, "animationDuration": 8.1, "animationIterationCount": 8.1, "animationName": 8.1, "animationPlayState": 8.1, "animationTimingFunction": 8.1, "appearance": 9.3, "userSelect": 9.3, "backdropFilter": 9.3, "fontKerning": 9.3, "scrollSnapType": 9.3, "scrollSnapPointsX": 9.3, "scrollSnapPointsY": 9.3, "scrollSnapDestination": 9.3, "scrollSnapCoordinate": 9.3, "boxDecorationBreak": 9.3, "clipPath": 9.3, "maskImage": 9.3, "maskMode": 9.3, "maskRepeat": 9.3, "maskPosition": 9.3, "maskClip": 9.3, "maskOrigin": 9.3, "maskSize": 9.3, "maskComposite": 9.3, "mask": 9.3, "maskBorderSource": 9.3, "maskBorderMode": 9.3, "maskBorderSlice": 9.3, "maskBorderWidth": 9.3, "maskBorderOutset": 9.3, "maskBorderRepeat": 9.3, "maskBorder": 9.3, "maskType": 9.3, "textSizeAdjust": 9.3, "textDecorationStyle": 9.3, "textDecorationSkip": 9.3, "textDecorationLine": 9.3, "textDecorationColor": 9.3, "shapeImageThreshold": 9.3, "shapeImageMargin": 9.3, "shapeImageOutside": 9.3, "filter": 9, "hyphens": 9.3, "flowInto": 9.3, "flowFrom": 9.3, "breakBefore": 8.1, "breakAfter": 8.1, "breakInside": 8.1, "regionFragment": 9.3, "columnCount": 8.1, "columnFill": 8.1, "columnGap": 8.1, "columnRule": 8.1, "columnRuleColor": 8.1, "columnRuleStyle": 8.1, "columnRuleWidth": 8.1, "columns": 8.1, "columnSpan": 8.1, "columnWidth": 8.1 }, "android": { "flex": 4.2, "flexBasis": 4.2, "flexDirection": 4.2, "flexGrow": 4.2, "flexFlow": 4.2, "flexShrink": 4.2, "flexWrap": 4.2, "alignContent": 4.2, "alignItems": 4.2, "alignSelf": 4.2, "justifyContent": 4.2, "order": 4.2, "transition": 4.2, "transitionDelay": 4.2, "transitionDuration": 4.2, "transitionProperty": 4.2, "transitionTimingFunction": 4.2, "transform": 4.4, "transformOrigin": 4.4, "transformOriginX": 4.4, "transformOriginY": 4.4, "backfaceVisibility": 4.4, "perspective": 4.4, "perspectiveOrigin": 4.4, "transformStyle": 4.4, "transformOriginZ": 4.4, "animation": 4.4, "animationDelay": 4.4, "animationDirection": 4.4, "animationFillMode": 4.4, "animationDuration": 4.4, "animationIterationCount": 4.4, "animationName": 4.4, "animationPlayState": 4.4, "animationTimingFunction": 4.4, "appearance": 51, "userSelect": 51, "fontKerning": 4.4, "textEmphasisPosition": 51, "textEmphasis": 51, "textEmphasisStyle": 51, "textEmphasisColor": 51, "boxDecorationBreak": 51, "clipPath": 51, "maskImage": 51, "maskMode": 51, "maskRepeat": 51, "maskPosition": 51, "maskClip": 51, "maskOrigin": 51, "maskSize": 51, "maskComposite": 51, "mask": 51, "maskBorderSource": 51, "maskBorderMode": 51, "maskBorderSlice": 51, "maskBorderWidth": 51, "maskBorderOutset": 51, "maskBorderRepeat": 51, "maskBorder": 51, "maskType": 51, "filter": 51, "fontFeatureSettings": 4.4, "breakAfter": 51, "breakBefore": 51, "breakInside": 51, "columnCount": 51, "columnFill": 51, "columnGap": 51, "columnRule": 51, "columnRuleColor": 51, "columnRuleStyle": 51, "columnRuleWidth": 51, "columns": 51, "columnSpan": 51, "columnWidth": 51 }, "and_chr": { "appearance": 51, "userSelect": 51, "textEmphasisPosition": 51, "textEmphasis": 51, "textEmphasisStyle": 51, "textEmphasisColor": 51, "boxDecorationBreak": 51, "clipPath": 51, "maskImage": 51, "maskMode": 51, "maskRepeat": 51, "maskPosition": 51, "maskClip": 51, "maskOrigin": 51, "maskSize": 51, "maskComposite": 51, "mask": 51, "maskBorderSource": 51, "maskBorderMode": 51, "maskBorderSlice": 51, "maskBorderWidth": 51, "maskBorderOutset": 51, "maskBorderRepeat": 51, "maskBorder": 51, "maskType": 51, "textDecorationStyle": 51, "textDecorationSkip": 51, "textDecorationLine": 51, "textDecorationColor": 51, "filter": 51 }, "and_uc": { "flex": 9.9, "flexBasis": 9.9, "flexDirection": 9.9, "flexGrow": 9.9, "flexFlow": 9.9, "flexShrink": 9.9, "flexWrap": 9.9, "alignContent": 9.9, "alignItems": 9.9, "alignSelf": 9.9, "justifyContent": 9.9, "order": 9.9, "transition": 9.9, "transitionDelay": 9.9, "transitionDuration": 9.9, "transitionProperty": 9.9, "transitionTimingFunction": 9.9, "transform": 9.9, "transformOrigin": 9.9, "transformOriginX": 9.9, "transformOriginY": 9.9, "backfaceVisibility": 9.9, "perspective": 9.9, "perspectiveOrigin": 9.9, "transformStyle": 9.9, "transformOriginZ": 9.9, "animation": 9.9, "animationDelay": 9.9, "animationDirection": 9.9, "animationFillMode": 9.9, "animationDuration": 9.9, "animationIterationCount": 9.9, "animationName": 9.9, "animationPlayState": 9.9, "animationTimingFunction": 9.9, "appearance": 9.9, "userSelect": 9.9, "fontKerning": 9.9, "textEmphasisPosition": 9.9, "textEmphasis": 9.9, "textEmphasisStyle": 9.9, "textEmphasisColor": 9.9, "maskImage": 9.9, "maskMode": 9.9, "maskRepeat": 9.9, "maskPosition": 9.9, "maskClip": 9.9, "maskOrigin": 9.9, "maskSize": 9.9, "maskComposite": 9.9, "mask": 9.9, "maskBorderSource": 9.9, "maskBorderMode": 9.9, "maskBorderSlice": 9.9, "maskBorderWidth": 9.9, "maskBorderOutset": 9.9, "maskBorderRepeat": 9.9, "maskBorder": 9.9, "maskType": 9.9, "textSizeAdjust": 9.9, "filter": 9.9, "hyphens": 9.9, "flowInto": 9.9, "flowFrom": 9.9, "breakBefore": 9.9, "breakAfter": 9.9, "breakInside": 9.9, "regionFragment": 9.9, "fontFeatureSettings": 9.9, "columnCount": 9.9, "columnFill": 9.9, "columnGap": 9.9, "columnRule": 9.9, "columnRuleColor": 9.9, "columnRuleStyle": 9.9, "columnRuleWidth": 9.9, "columns": 9.9, "columnSpan": 9.9, "columnWidth": 9.9 }, "op_mini": {} };
module.exports = exports["default"];

/***/ }),
/* 911 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = position;

var _getPrefixedValue = __webpack_require__(33);

var _getPrefixedValue2 = _interopRequireDefault(_getPrefixedValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function position(_ref) {
  var property = _ref.property;
  var value = _ref.value;
  var browser = _ref.browserInfo.browser;
  var css = _ref.prefix.css;
  var keepUnprefixed = _ref.keepUnprefixed;

  if (property === 'position' && value === 'sticky' && (browser === 'safari' || browser === 'ios_saf')) {
    return _defineProperty({}, property, (0, _getPrefixedValue2.default)(css + value, value, keepUnprefixed));
  }
}
module.exports = exports['default'];

/***/ }),
/* 912 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = calc;

var _getPrefixedValue = __webpack_require__(33);

var _getPrefixedValue2 = _interopRequireDefault(_getPrefixedValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function calc(_ref) {
  var property = _ref.property;
  var value = _ref.value;
  var _ref$browserInfo = _ref.browserInfo;
  var browser = _ref$browserInfo.browser;
  var version = _ref$browserInfo.version;
  var css = _ref.prefix.css;
  var keepUnprefixed = _ref.keepUnprefixed;

  if (typeof value === 'string' && value.indexOf('calc(') > -1 && (browser === 'firefox' && version < 15 || browser === 'chrome' && version < 25 || browser === 'safari' && version < 6.1 || browser === 'ios_saf' && version < 7)) {
    return _defineProperty({}, property, (0, _getPrefixedValue2.default)(value.replace(/calc\(/g, css + 'calc('), value, keepUnprefixed));
  }
}
module.exports = exports['default'];

/***/ }),
/* 913 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = zoomCursor;

var _getPrefixedValue = __webpack_require__(33);

var _getPrefixedValue2 = _interopRequireDefault(_getPrefixedValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var values = { 'zoom-in': true, 'zoom-out': true };

function zoomCursor(_ref) {
  var property = _ref.property;
  var value = _ref.value;
  var _ref$browserInfo = _ref.browserInfo;
  var browser = _ref$browserInfo.browser;
  var version = _ref$browserInfo.version;
  var css = _ref.prefix.css;
  var keepUnprefixed = _ref.keepUnprefixed;

  if (property === 'cursor' && values[value] && (browser === 'firefox' && version < 24 || browser === 'chrome' && version < 37 || browser === 'safari' && version < 9 || browser === 'opera' && version < 24)) {
    return {
      cursor: (0, _getPrefixedValue2.default)(css + value, value, keepUnprefixed)
    };
  }
}
module.exports = exports['default'];

/***/ }),
/* 914 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = grabCursor;

var _getPrefixedValue = __webpack_require__(33);

var _getPrefixedValue2 = _interopRequireDefault(_getPrefixedValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var values = { grab: true, grabbing: true };

function grabCursor(_ref) {
  var property = _ref.property;
  var value = _ref.value;
  var browser = _ref.browserInfo.browser;
  var css = _ref.prefix.css;
  var keepUnprefixed = _ref.keepUnprefixed;

  // adds prefixes for firefox, chrome, safari, and opera regardless of version until a reliable brwoser support info can be found (see: https://github.com/rofrischmann/inline-style-prefixer/issues/79)
  if (property === 'cursor' && values[value] && (browser === 'firefox' || browser === 'chrome' || browser === 'safari' || browser === 'opera')) {
    return {
      cursor: (0, _getPrefixedValue2.default)(css + value, value, keepUnprefixed)
    };
  }
}
module.exports = exports['default'];

/***/ }),
/* 915 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = flex;

var _getPrefixedValue = __webpack_require__(33);

var _getPrefixedValue2 = _interopRequireDefault(_getPrefixedValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var values = { flex: true, 'inline-flex': true };

function flex(_ref) {
  var property = _ref.property;
  var value = _ref.value;
  var _ref$browserInfo = _ref.browserInfo;
  var browser = _ref$browserInfo.browser;
  var version = _ref$browserInfo.version;
  var css = _ref.prefix.css;
  var keepUnprefixed = _ref.keepUnprefixed;

  if (property === 'display' && values[value] && (browser === 'chrome' && version < 29 && version > 20 || (browser === 'safari' || browser === 'ios_saf') && version < 9 && version > 6 || browser === 'opera' && (version == 15 || version == 16))) {
    return {
      display: (0, _getPrefixedValue2.default)(css + value, value, keepUnprefixed)
    };
  }
}
module.exports = exports['default'];

/***/ }),
/* 916 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = sizing;

var _getPrefixedValue = __webpack_require__(33);

var _getPrefixedValue2 = _interopRequireDefault(_getPrefixedValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var properties = {
  maxHeight: true,
  maxWidth: true,
  width: true,
  height: true,
  columnWidth: true,
  minWidth: true,
  minHeight: true
};
var values = {
  'min-content': true,
  'max-content': true,
  'fill-available': true,
  'fit-content': true,
  'contain-floats': true
};

function sizing(_ref) {
  var property = _ref.property;
  var value = _ref.value;
  var css = _ref.prefix.css;
  var keepUnprefixed = _ref.keepUnprefixed;

  // This might change in the future
  // Keep an eye on it
  if (properties[property] && values[value]) {
    return _defineProperty({}, property, (0, _getPrefixedValue2.default)(css + value, value, keepUnprefixed));
  }
}
module.exports = exports['default'];

/***/ }),
/* 917 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = gradient;

var _getPrefixedValue = __webpack_require__(33);

var _getPrefixedValue2 = _interopRequireDefault(_getPrefixedValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var values = /linear-gradient|radial-gradient|repeating-linear-gradient|repeating-radial-gradient/;

function gradient(_ref) {
  var property = _ref.property;
  var value = _ref.value;
  var _ref$browserInfo = _ref.browserInfo;
  var browser = _ref$browserInfo.browser;
  var version = _ref$browserInfo.version;
  var css = _ref.prefix.css;
  var keepUnprefixed = _ref.keepUnprefixed;

  if (typeof value === 'string' && value.match(values) !== null && (browser === 'firefox' && version < 16 || browser === 'chrome' && version < 26 || (browser === 'safari' || browser === 'ios_saf') && version < 7 || (browser === 'opera' || browser === 'op_mini') && version < 12.1 || browser === 'android' && version < 4.4 || browser === 'and_uc')) {
    return _defineProperty({}, property, (0, _getPrefixedValue2.default)(css + value, value, keepUnprefixed));
  }
}
module.exports = exports['default'];

/***/ }),
/* 918 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

exports.default = transition;

var _hyphenateStyleName = __webpack_require__(281);

var _hyphenateStyleName2 = _interopRequireDefault(_hyphenateStyleName);

var _unprefixProperty = __webpack_require__(919);

var _unprefixProperty2 = _interopRequireDefault(_unprefixProperty);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var properties = { transition: true, transitionProperty: true };

function transition(_ref) {
  var property = _ref.property;
  var value = _ref.value;
  var css = _ref.prefix.css;
  var requiresPrefix = _ref.requiresPrefix;
  var keepUnprefixed = _ref.keepUnprefixed;

  // also check for already prefixed transitions
  var unprefixedProperty = (0, _unprefixProperty2.default)(property);

  if (typeof value === 'string' && properties[unprefixedProperty]) {
    var _ret = function () {
      // TODO: memoize this array
      var requiresPrefixDashCased = Object.keys(requiresPrefix).map(function (prop) {
        return (0, _hyphenateStyleName2.default)(prop);
      });

      // only split multi values, not cubic beziers
      var multipleValues = value.split(/,(?![^()]*(?:\([^()]*\))?\))/g);

      requiresPrefixDashCased.forEach(function (prop) {
        multipleValues.forEach(function (val, index) {
          if (val.indexOf(prop) > -1 && prop !== 'order') {
            multipleValues[index] = val.replace(prop, css + prop) + (keepUnprefixed ? ',' + val : '');
          }
        });
      });

      return {
        v: _defineProperty({}, property, multipleValues.join(','))
      };
    }();

    if ((typeof _ret === 'undefined' ? 'undefined' : _typeof(_ret)) === "object") return _ret.v;
  }
}
module.exports = exports['default'];

/***/ }),
/* 919 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (property) {
  var unprefixed = property.replace(/^(ms|Webkit|Moz|O)/, '');
  return unprefixed.charAt(0).toLowerCase() + unprefixed.slice(1);
};

module.exports = exports['default'];

/***/ }),
/* 920 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = flexboxIE;

var _getPrefixedValue = __webpack_require__(33);

var _getPrefixedValue2 = _interopRequireDefault(_getPrefixedValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var alternativeValues = {
  'space-around': 'distribute',
  'space-between': 'justify',
  'flex-start': 'start',
  'flex-end': 'end',
  flex: 'flexbox',
  'inline-flex': 'inline-flexbox'
};
var alternativeProps = {
  alignContent: 'msFlexLinePack',
  alignSelf: 'msFlexItemAlign',
  alignItems: 'msFlexAlign',
  justifyContent: 'msFlexPack',
  order: 'msFlexOrder',
  flexGrow: 'msFlexPositive',
  flexShrink: 'msFlexNegative',
  flexBasis: 'msPreferredSize'
};

function flexboxIE(_ref) {
  var property = _ref.property;
  var value = _ref.value;
  var styles = _ref.styles;
  var _ref$browserInfo = _ref.browserInfo;
  var browser = _ref$browserInfo.browser;
  var version = _ref$browserInfo.version;
  var css = _ref.prefix.css;
  var keepUnprefixed = _ref.keepUnprefixed;

  if ((alternativeProps[property] || property === 'display' && typeof value === 'string' && value.indexOf('flex') > -1) && (browser === 'ie_mob' || browser === 'ie') && version == 10) {
    if (!keepUnprefixed && !Array.isArray(styles[property])) {
      delete styles[property];
    }
    if (property === 'display' && alternativeValues[value]) {
      return {
        display: (0, _getPrefixedValue2.default)(css + alternativeValues[value], value, keepUnprefixed)
      };
    }
    if (alternativeProps[property]) {
      return _defineProperty({}, alternativeProps[property], alternativeValues[value] || value);
    }
  }
}
module.exports = exports['default'];

/***/ }),
/* 921 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = flexboxOld;

var _getPrefixedValue = __webpack_require__(33);

var _getPrefixedValue2 = _interopRequireDefault(_getPrefixedValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var alternativeValues = {
  'space-around': 'justify',
  'space-between': 'justify',
  'flex-start': 'start',
  'flex-end': 'end',
  'wrap-reverse': 'multiple',
  wrap: 'multiple',
  flex: 'box',
  'inline-flex': 'inline-box'
};

var alternativeProps = {
  alignItems: 'WebkitBoxAlign',
  justifyContent: 'WebkitBoxPack',
  flexWrap: 'WebkitBoxLines'
};

var otherProps = ['alignContent', 'alignSelf', 'order', 'flexGrow', 'flexShrink', 'flexBasis', 'flexDirection'];
var properties = Object.keys(alternativeProps).concat(otherProps);

function flexboxOld(_ref) {
  var property = _ref.property;
  var value = _ref.value;
  var styles = _ref.styles;
  var _ref$browserInfo = _ref.browserInfo;
  var browser = _ref$browserInfo.browser;
  var version = _ref$browserInfo.version;
  var css = _ref.prefix.css;
  var keepUnprefixed = _ref.keepUnprefixed;

  if ((properties.indexOf(property) > -1 || property === 'display' && typeof value === 'string' && value.indexOf('flex') > -1) && (browser === 'firefox' && version < 22 || browser === 'chrome' && version < 21 || (browser === 'safari' || browser === 'ios_saf') && version <= 6.1 || browser === 'android' && version < 4.4 || browser === 'and_uc')) {
    if (!keepUnprefixed && !Array.isArray(styles[property])) {
      delete styles[property];
    }
    if (property === 'flexDirection' && typeof value === 'string') {
      return {
        WebkitBoxOrient: value.indexOf('column') > -1 ? 'vertical' : 'horizontal',
        WebkitBoxDirection: value.indexOf('reverse') > -1 ? 'reverse' : 'normal'
      };
    }
    if (property === 'display' && alternativeValues[value]) {
      return {
        display: (0, _getPrefixedValue2.default)(css + alternativeValues[value], value, keepUnprefixed)
      };
    }
    if (alternativeProps[property]) {
      return _defineProperty({}, alternativeProps[property], alternativeValues[value] || value);
    }
  }
}
module.exports = exports['default'];

/***/ }),
/* 922 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.isNestedStyle = isNestedStyle;
exports.mergeStyles = mergeStyles;
function isNestedStyle(value) {
  // Don't merge objects overriding toString, since they should be converted
  // to string values.
  return value && value.constructor === Object && value.toString === Object.prototype.toString;
}

// Merge style objects. Deep merge plain object values.
function mergeStyles(styles) {
  var result = {};

  styles.forEach(function (style) {
    if (!style || (typeof style === 'undefined' ? 'undefined' : _typeof(style)) !== 'object') {
      return;
    }

    if (Array.isArray(style)) {
      style = mergeStyles(style);
    }

    Object.keys(style).forEach(function (key) {
      // Simple case, nothing nested
      if (!isNestedStyle(style[key]) || !isNestedStyle(result[key])) {
        result[key] = style[key];
        return;
      }

      // If nested media, don't merge the nested styles, append a space to the
      // end (benign when converted to CSS). This way we don't end up merging
      // media queries that appear later in the chain with those that appear
      // earlier.
      if (key.indexOf('@media') === 0) {
        var newKey = key;
        // eslint-disable-next-line no-constant-condition
        while (true) {
          newKey += ' ';
          if (!result[newKey]) {
            result[newKey] = style[key];
            return;
          }
        }
      }

      // Merge all other nested styles recursively
      result[key] = mergeStyles([result[key], style[key]]);
    });
  });

  return result;
}

/***/ }),
/* 923 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _checkProps = function checkProps() {};

if (process.env.NODE_ENV !== 'production') {
  // Warn if you use longhand and shorthand properties in the same style
  // object.
  // https://developer.mozilla.org/en-US/docs/Web/CSS/Shorthand_properties

  var shorthandPropertyExpansions = {
    background: ['backgroundAttachment', 'backgroundBlendMode', 'backgroundClip', 'backgroundColor', 'backgroundImage', 'backgroundOrigin', 'backgroundPosition', 'backgroundPositionX', 'backgroundPositionY', 'backgroundRepeat', 'backgroundRepeatX', 'backgroundRepeatY', 'backgroundSize'],
    border: ['borderBottom', 'borderBottomColor', 'borderBottomStyle', 'borderBottomWidth', 'borderColor', 'borderLeft', 'borderLeftColor', 'borderLeftStyle', 'borderLeftWidth', 'borderRight', 'borderRightColor', 'borderRightStyle', 'borderRightWidth', 'borderStyle', 'borderTop', 'borderTopColor', 'borderTopStyle', 'borderTopWidth', 'borderWidth'],
    borderImage: ['borderImageOutset', 'borderImageRepeat', 'borderImageSlice', 'borderImageSource', 'borderImageWidth'],
    borderRadius: ['borderBottomLeftRadius', 'borderBottomRightRadius', 'borderTopLeftRadius', 'borderTopRightRadius'],
    font: ['fontFamily', 'fontKerning', 'fontSize', 'fontStretch', 'fontStyle', 'fontVariant', 'fontVariantLigatures', 'fontWeight', 'lineHeight'],
    listStyle: ['listStyleImage', 'listStylePosition', 'listStyleType'],
    margin: ['marginBottom', 'marginLeft', 'marginRight', 'marginTop'],
    padding: ['paddingBottom', 'paddingLeft', 'paddingRight', 'paddingTop'],
    transition: ['transitionDelay', 'transitionDuration', 'transitionProperty', 'transitionTimingFunction']
  };

  _checkProps = function checkProps(config) {
    var componentName = config.componentName,
        style = config.style;

    if ((typeof style === 'undefined' ? 'undefined' : _typeof(style)) !== 'object' || !style) {
      return;
    }

    var styleKeys = Object.keys(style);
    styleKeys.forEach(function (styleKey) {
      if (Array.isArray(shorthandPropertyExpansions[styleKey]) && shorthandPropertyExpansions[styleKey].some(function (sp) {
        return styleKeys.indexOf(sp) !== -1;
      })) {
        if (process.env.NODE_ENV !== 'production') {
          /* eslint-disable no-console */
          console.warn('Radium: property "' + styleKey + '" in style object', style, ': do not mix longhand and ' + 'shorthand properties in the same style object. Check the render ' + 'method of ' + componentName + '.', 'See https://github.com/FormidableLabs/radium/issues/95 for more ' + 'information.');
          /* eslint-enable no-console */
        }
      }
    });

    styleKeys.forEach(function (k) {
      return _checkProps(_extends({}, config, { style: style[k] }));
    });
    return;
  };
}

exports.default = _checkProps;
module.exports = exports['default'];
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(11)))

/***/ }),
/* 924 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = keyframesPlugin;
function keyframesPlugin(_ref) {
  var addCSS = _ref.addCSS,
      config = _ref.config,
      style = _ref.style;

  var newStyle = Object.keys(style).reduce(function (newStyleInProgress, key) {
    var value = style[key];
    if (key === 'animationName' && value && value.__radiumKeyframes) {
      var keyframesValue = value;

      var _keyframesValue$__pro = keyframesValue.__process(config.userAgent),
          animationName = _keyframesValue$__pro.animationName,
          css = _keyframesValue$__pro.css;

      addCSS(css);
      value = animationName;
    }

    newStyleInProgress[key] = value;
    return newStyleInProgress;
  }, {});
  return { style: newStyle };
}
module.exports = exports['default'];

/***/ }),
/* 925 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});


// Convenient syntax for multiple styles: `style={[style1, style2, etc]}`
// Ignores non-objects, so you can do `this.state.isCool && styles.cool`.
var mergeStyleArrayPlugin = function mergeStyleArrayPlugin(_ref) {
  var style = _ref.style,
      mergeStyles = _ref.mergeStyles;

  // eslint-disable-line no-shadow
  var newStyle = Array.isArray(style) ? mergeStyles(style) : style;
  return { style: newStyle };
};

exports.default = mergeStyleArrayPlugin;
module.exports = exports['default'];

/***/ }),
/* 926 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = prefixPlugin;

var _prefixer = __webpack_require__(157);

function prefixPlugin(_ref) {
  var config = _ref.config,
      style = _ref.style;

  var newStyle = (0, _prefixer.getPrefixedStyle)(style, config.userAgent);
  return { style: newStyle };
}
module.exports = exports['default'];

/***/ }),
/* 927 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = removeNestedStyles;
function removeNestedStyles(_ref) {
  var isNestedStyle = _ref.isNestedStyle,
      style = _ref.style;

  // eslint-disable-line no-shadow
  var newStyle = Object.keys(style).reduce(function (newStyleInProgress, key) {
    var value = style[key];
    if (!isNestedStyle(value)) {
      newStyleInProgress[key] = value;
    }
    return newStyleInProgress;
  }, {});

  return {
    style: newStyle
  };
}

module.exports = exports['default'];

/***/ }),
/* 928 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _mouseUpListener = __webpack_require__(929);

var _mouseUpListener2 = _interopRequireDefault(_mouseUpListener);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _isInteractiveStyleField = function _isInteractiveStyleField(styleFieldName) {
  return styleFieldName === ':hover' || styleFieldName === ':active' || styleFieldName === ':focus';
};

var resolveInteractionStyles = function resolveInteractionStyles(config) {
  var ExecutionEnvironment = config.ExecutionEnvironment,
      getComponentField = config.getComponentField,
      getState = config.getState,
      mergeStyles = config.mergeStyles,
      props = config.props,
      setState = config.setState,
      style = config.style;


  var newComponentFields = {};
  var newProps = {};

  // Only add handlers if necessary
  if (style[':hover']) {
    // Always call the existing handler if one is already defined.
    // This code, and the very similar ones below, could be abstracted a bit
    // more, but it hurts readability IMO.
    var existingOnMouseEnter = props.onMouseEnter;
    newProps.onMouseEnter = function (e) {
      existingOnMouseEnter && existingOnMouseEnter(e);
      setState(':hover', true);
    };

    var existingOnMouseLeave = props.onMouseLeave;
    newProps.onMouseLeave = function (e) {
      existingOnMouseLeave && existingOnMouseLeave(e);
      setState(':hover', false);
    };
  }

  if (style[':active']) {
    var existingOnMouseDown = props.onMouseDown;
    newProps.onMouseDown = function (e) {
      existingOnMouseDown && existingOnMouseDown(e);
      newComponentFields._lastMouseDown = Date.now();
      setState(':active', 'viamousedown');
    };

    var existingOnKeyDown = props.onKeyDown;
    newProps.onKeyDown = function (e) {
      existingOnKeyDown && existingOnKeyDown(e);
      if (e.key === ' ' || e.key === 'Enter') {
        setState(':active', 'viakeydown');
      }
    };

    var existingOnKeyUp = props.onKeyUp;
    newProps.onKeyUp = function (e) {
      existingOnKeyUp && existingOnKeyUp(e);
      if (e.key === ' ' || e.key === 'Enter') {
        setState(':active', false);
      }
    };
  }

  if (style[':focus']) {
    var existingOnFocus = props.onFocus;
    newProps.onFocus = function (e) {
      existingOnFocus && existingOnFocus(e);
      setState(':focus', true);
    };

    var existingOnBlur = props.onBlur;
    newProps.onBlur = function (e) {
      existingOnBlur && existingOnBlur(e);
      setState(':focus', false);
    };
  }

  if (style[':active'] && !getComponentField('_radiumMouseUpListener') && ExecutionEnvironment.canUseEventListeners) {
    newComponentFields._radiumMouseUpListener = _mouseUpListener2.default.subscribe(function () {
      Object.keys(getComponentField('state')._radiumStyleState).forEach(function (key) {
        if (getState(':active', key) === 'viamousedown') {
          setState(':active', false, key);
        }
      });
    });
  }

  // Merge the styles in the order they were defined
  var interactionStyles = props.disabled ? [style[':disabled']] : Object.keys(style).filter(function (name) {
    return _isInteractiveStyleField(name) && getState(name);
  }).map(function (name) {
    return style[name];
  });

  var newStyle = mergeStyles([style].concat(interactionStyles));

  // Remove interactive styles
  newStyle = Object.keys(newStyle).reduce(function (styleWithoutInteractions, name) {
    if (!_isInteractiveStyleField(name) && name !== ':disabled') {
      styleWithoutInteractions[name] = newStyle[name];
    }
    return styleWithoutInteractions;
  }, {});

  return {
    componentFields: newComponentFields,
    props: newProps,
    style: newStyle
  };
};

exports.default = resolveInteractionStyles;
module.exports = exports['default'];

/***/ }),
/* 929 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
var _callbacks = [];
var _mouseUpListenerIsActive = false;

function _handleMouseUp() {
  _callbacks.forEach(function (callback) {
    callback();
  });
}

var subscribe = function subscribe(callback) {
  if (_callbacks.indexOf(callback) === -1) {
    _callbacks.push(callback);
  }

  if (!_mouseUpListenerIsActive) {
    window.addEventListener('mouseup', _handleMouseUp);
    _mouseUpListenerIsActive = true;
  }

  return {
    remove: function remove() {
      var index = _callbacks.indexOf(callback);
      _callbacks.splice(index, 1);

      if (_callbacks.length === 0 && _mouseUpListenerIsActive) {
        window.removeEventListener('mouseup', _handleMouseUp);
        _mouseUpListenerIsActive = false;
      }
    }
  };
};

exports.default = {
  subscribe: subscribe,
  __triggerForTests: _handleMouseUp
};
module.exports = exports['default'];

/***/ }),
/* 930 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.default = resolveMediaQueries;
var _windowMatchMedia = void 0;
function _getWindowMatchMedia(ExecutionEnvironment) {
  if (_windowMatchMedia === undefined) {
    _windowMatchMedia = !!ExecutionEnvironment.canUseDOM && !!window && !!window.matchMedia && function (mediaQueryString) {
      return window.matchMedia(mediaQueryString);
    } || null;
  }
  return _windowMatchMedia;
}

function _filterObject(obj, predicate) {
  return Object.keys(obj).filter(function (key) {
    return predicate(obj[key], key);
  }).reduce(function (result, key) {
    result[key] = obj[key];
    return result;
  }, {});
}

function _removeMediaQueries(style) {
  return Object.keys(style).reduce(function (styleWithoutMedia, key) {
    if (key.indexOf('@media') !== 0) {
      styleWithoutMedia[key] = style[key];
    }
    return styleWithoutMedia;
  }, {});
}

function _topLevelRulesToCSS(_ref) {
  var addCSS = _ref.addCSS,
      appendImportantToEachValue = _ref.appendImportantToEachValue,
      cssRuleSetToString = _ref.cssRuleSetToString,
      hash = _ref.hash,
      isNestedStyle = _ref.isNestedStyle,
      style = _ref.style,
      userAgent = _ref.userAgent;

  var className = '';
  Object.keys(style).filter(function (name) {
    return name.indexOf('@media') === 0;
  }).map(function (query) {
    var topLevelRules = appendImportantToEachValue(_filterObject(style[query], function (value) {
      return !isNestedStyle(value);
    }));

    if (!Object.keys(topLevelRules).length) {
      return;
    }

    var ruleCSS = cssRuleSetToString('', topLevelRules, userAgent);

    // CSS classes cannot start with a number
    var mediaQueryClassName = 'rmq-' + hash(query + ruleCSS);
    var css = query + '{ .' + mediaQueryClassName + ruleCSS + '}';

    addCSS(css);

    className += (className ? ' ' : '') + mediaQueryClassName;
  });
  return className;
}

function _subscribeToMediaQuery(_ref2) {
  var listener = _ref2.listener,
      listenersByQuery = _ref2.listenersByQuery,
      matchMedia = _ref2.matchMedia,
      mediaQueryListsByQuery = _ref2.mediaQueryListsByQuery,
      query = _ref2.query;

  query = query.replace('@media ', '');

  var mql = mediaQueryListsByQuery[query];
  if (!mql && matchMedia) {
    mediaQueryListsByQuery[query] = mql = matchMedia(query);
  }

  if (!listenersByQuery || !listenersByQuery[query]) {
    mql.addListener(listener);

    listenersByQuery[query] = {
      remove: function remove() {
        mql.removeListener(listener);
      }
    };
  }
  return mql;
}

function resolveMediaQueries(_ref3) {
  var ExecutionEnvironment = _ref3.ExecutionEnvironment,
      addCSS = _ref3.addCSS,
      appendImportantToEachValue = _ref3.appendImportantToEachValue,
      config = _ref3.config,
      cssRuleSetToString = _ref3.cssRuleSetToString,
      getComponentField = _ref3.getComponentField,
      getGlobalState = _ref3.getGlobalState,
      hash = _ref3.hash,
      isNestedStyle = _ref3.isNestedStyle,
      mergeStyles = _ref3.mergeStyles,
      props = _ref3.props,
      setState = _ref3.setState,
      style = _ref3.style;

  // eslint-disable-line no-shadow
  var newStyle = _removeMediaQueries(style);
  var mediaQueryClassNames = _topLevelRulesToCSS({
    addCSS: addCSS,
    appendImportantToEachValue: appendImportantToEachValue,
    cssRuleSetToString: cssRuleSetToString,
    hash: hash,
    isNestedStyle: isNestedStyle,
    style: style,
    userAgent: config.userAgent
  });

  var newProps = mediaQueryClassNames ? {
    className: mediaQueryClassNames + (props.className ? ' ' + props.className : '')
  } : null;

  var matchMedia = config.matchMedia || _getWindowMatchMedia(ExecutionEnvironment);

  if (!matchMedia) {
    return {
      props: newProps,
      style: newStyle
    };
  }

  var listenersByQuery = _extends({}, getComponentField('_radiumMediaQueryListenersByQuery'));
  var mediaQueryListsByQuery = getGlobalState('mediaQueryListsByQuery') || {};

  Object.keys(style).filter(function (name) {
    return name.indexOf('@media') === 0;
  }).map(function (query) {
    var nestedRules = _filterObject(style[query], isNestedStyle);

    if (!Object.keys(nestedRules).length) {
      return;
    }

    var mql = _subscribeToMediaQuery({
      listener: function listener() {
        return setState(query, mql.matches, '_all');
      },
      listenersByQuery: listenersByQuery,
      matchMedia: matchMedia,
      mediaQueryListsByQuery: mediaQueryListsByQuery,
      query: query
    });

    // Apply media query states
    if (mql.matches) {
      newStyle = mergeStyles([newStyle, nestedRules]);
    }
  });

  return {
    componentFields: {
      _radiumMediaQueryListenersByQuery: listenersByQuery
    },
    globalState: { mediaQueryListsByQuery: mediaQueryListsByQuery },
    props: newProps,
    style: newStyle
  };
}
module.exports = exports['default'];

/***/ }),
/* 931 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = visited;
function visited(_ref) {
  var addCSS = _ref.addCSS,
      appendImportantToEachValue = _ref.appendImportantToEachValue,
      config = _ref.config,
      cssRuleSetToString = _ref.cssRuleSetToString,
      hash = _ref.hash,
      props = _ref.props,
      style = _ref.style;

  // eslint-disable-line no-shadow
  var className = props.className;

  var newStyle = Object.keys(style).reduce(function (newStyleInProgress, key) {
    var value = style[key];
    if (key === ':visited') {
      value = appendImportantToEachValue(value);
      var ruleCSS = cssRuleSetToString('', value, config.userAgent);
      var visitedClassName = 'rad-' + hash(ruleCSS);
      var css = '.' + visitedClassName + ':visited' + ruleCSS;

      addCSS(css);
      className = (className ? className + ' ' : '') + visitedClassName;
    } else {
      newStyleInProgress[key] = value;
    }

    return newStyleInProgress;
  }, {});

  return {
    props: className === props.className ? null : { className: className },
    style: newStyle
  };
}

module.exports = exports['default'];

/***/ }),
/* 932 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_RESULT__;/*!
  Copyright (c) 2015 Jed Watson.
  Based on code that is Copyright 2013-2015, Facebook, Inc.
  All rights reserved.
*/
/* global define */

(function () {
	'use strict';

	var canUseDOM = !!(
		typeof window !== 'undefined' &&
		window.document &&
		window.document.createElement
	);

	var ExecutionEnvironment = {

		canUseDOM: canUseDOM,

		canUseWorkers: typeof Worker !== 'undefined',

		canUseEventListeners:
			canUseDOM && !!(window.addEventListener || window.attachEvent),

		canUseViewport: canUseDOM && !!window.screen

	};

	if (true) {
		!(__WEBPACK_AMD_DEFINE_RESULT__ = (function () {
			return ExecutionEnvironment;
		}).call(exports, __webpack_require__, exports, module),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else if (typeof module !== 'undefined' && module.exports) {
		module.exports = ExecutionEnvironment;
	} else {
		window.ExecutionEnvironment = ExecutionEnvironment;
	}

}());


/***/ }),
/* 933 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _class, _temp;

var _cssRuleSetToString = __webpack_require__(156);

var _cssRuleSetToString2 = _interopRequireDefault(_cssRuleSetToString);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(1);

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Style = (_temp = _class = function (_PureComponent) {
  _inherits(Style, _PureComponent);

  function Style() {
    _classCallCheck(this, Style);

    return _possibleConstructorReturn(this, _PureComponent.apply(this, arguments));
  }

  Style.prototype._buildStyles = function _buildStyles(styles) {
    var _this2 = this;

    var userAgent = this.props.radiumConfig && this.props.radiumConfig.userAgent || this.context && this.context._radiumConfig && this.context._radiumConfig.userAgent;

    var scopeSelector = this.props.scopeSelector;

    var rootRules = Object.keys(styles).reduce(function (accumulator, selector) {
      if (_typeof(styles[selector]) !== 'object') {
        accumulator[selector] = styles[selector];
      }

      return accumulator;
    }, {});
    var rootStyles = Object.keys(rootRules).length ? (0, _cssRuleSetToString2.default)(scopeSelector || '', rootRules, userAgent) : '';

    return rootStyles + Object.keys(styles).reduce(function (accumulator, selector) {
      var rules = styles[selector];

      if (selector === 'mediaQueries') {
        accumulator += _this2._buildMediaQueryString(rules);
      } else if (_typeof(styles[selector]) === 'object') {
        var completeSelector = scopeSelector ? selector.split(',').map(function (part) {
          return scopeSelector + ' ' + part.trim();
        }).join(',') : selector;

        accumulator += (0, _cssRuleSetToString2.default)(completeSelector, rules, userAgent);
      }

      return accumulator;
    }, '');
  };

  Style.prototype._buildMediaQueryString = function _buildMediaQueryString(stylesByMediaQuery) {
    var _this3 = this;

    var mediaQueryString = '';

    Object.keys(stylesByMediaQuery).forEach(function (query) {
      mediaQueryString += '@media ' + query + '{' + _this3._buildStyles(stylesByMediaQuery[query]) + '}';
    });

    return mediaQueryString;
  };

  Style.prototype.render = function render() {
    if (!this.props.rules) {
      return null;
    }

    var styles = this._buildStyles(this.props.rules);

    return _react2.default.createElement('style', { dangerouslySetInnerHTML: { __html: styles } });
  };

  return Style;
}(_react.PureComponent), _class.propTypes = {
  radiumConfig: _propTypes2.default.object,
  rules: _propTypes2.default.object,
  scopeSelector: _propTypes2.default.string
}, _class.contextTypes = {
  _radiumConfig: _propTypes2.default.object
}, _class.defaultProps = {
  scopeSelector: ''
}, _temp);
exports.default = Style;
module.exports = exports['default'];

/***/ }),
/* 934 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(1);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _enhancer = __webpack_require__(275);

var _enhancer2 = _interopRequireDefault(_enhancer);

var _styleKeeper = __webpack_require__(155);

var _styleKeeper2 = _interopRequireDefault(_styleKeeper);

var _styleSheet = __webpack_require__(935);

var _styleSheet2 = _interopRequireDefault(_styleSheet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _getStyleKeeper(instance) {
  if (!instance._radiumStyleKeeper) {
    var userAgent = instance.props.radiumConfig && instance.props.radiumConfig.userAgent || instance.context._radiumConfig && instance.context._radiumConfig.userAgent;
    instance._radiumStyleKeeper = new _styleKeeper2.default(userAgent);
  }

  return instance._radiumStyleKeeper;
}

var StyleRoot = function (_PureComponent) {
  _inherits(StyleRoot, _PureComponent);

  function StyleRoot() {
    _classCallCheck(this, StyleRoot);

    var _this = _possibleConstructorReturn(this, _PureComponent.apply(this, arguments));

    _getStyleKeeper(_this);
    return _this;
  }

  StyleRoot.prototype.getChildContext = function getChildContext() {
    return { _radiumStyleKeeper: _getStyleKeeper(this) };
  };

  StyleRoot.prototype.render = function render() {
    /* eslint-disable no-unused-vars */
    // Pass down all props except config to the rendered div.
    var _props = this.props,
        radiumConfig = _props.radiumConfig,
        otherProps = _objectWithoutProperties(_props, ['radiumConfig']);
    /* eslint-enable no-unused-vars */

    return _react2.default.createElement(
      'div',
      otherProps,
      this.props.children,
      _react2.default.createElement(_styleSheet2.default, null)
    );
  };

  return StyleRoot;
}(_react.PureComponent);

StyleRoot.contextTypes = {
  _radiumConfig: _propTypes2.default.object,
  _radiumStyleKeeper: _propTypes2.default.instanceOf(_styleKeeper2.default)
};

StyleRoot.childContextTypes = {
  _radiumStyleKeeper: _propTypes2.default.instanceOf(_styleKeeper2.default)
};

StyleRoot = (0, _enhancer2.default)(StyleRoot);

exports.default = StyleRoot;
module.exports = exports['default'];

/***/ }),
/* 935 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp;

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(1);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _styleKeeper = __webpack_require__(155);

var _styleKeeper2 = _interopRequireDefault(_styleKeeper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var StyleSheet = (_temp = _class = function (_PureComponent) {
  _inherits(StyleSheet, _PureComponent);

  function StyleSheet() {
    _classCallCheck(this, StyleSheet);

    var _this = _possibleConstructorReturn(this, _PureComponent.apply(this, arguments));

    _this._onChange = function () {
      setTimeout(function () {
        _this._isMounted && _this.setState(_this._getCSSState());
      }, 0);
    };

    _this.state = _this._getCSSState();
    return _this;
  }

  StyleSheet.prototype.componentDidMount = function componentDidMount() {
    this._isMounted = true;
    this._subscription = this.context._radiumStyleKeeper.subscribe(this._onChange);
    this._onChange();
  };

  StyleSheet.prototype.componentWillUnmount = function componentWillUnmount() {
    this._isMounted = false;
    if (this._subscription) {
      this._subscription.remove();
    }
  };

  StyleSheet.prototype._getCSSState = function _getCSSState() {
    return { css: this.context._radiumStyleKeeper.getCSS() };
  };

  StyleSheet.prototype.render = function render() {
    return _react2.default.createElement('style', { dangerouslySetInnerHTML: { __html: this.state.css } });
  };

  return StyleSheet;
}(_react.PureComponent), _class.contextTypes = {
  _radiumStyleKeeper: _propTypes2.default.instanceOf(_styleKeeper2.default)
}, _temp);
exports.default = StyleSheet;
module.exports = exports['default'];

/***/ }),
/* 936 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = keyframes;

var _cssRuleSetToString = __webpack_require__(156);

var _cssRuleSetToString2 = _interopRequireDefault(_cssRuleSetToString);

var _hash = __webpack_require__(284);

var _hash2 = _interopRequireDefault(_hash);

var _prefixer = __webpack_require__(157);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function keyframes(keyframeRules, name) {
  return {
    __radiumKeyframes: true,
    __process: function __process(userAgent) {
      var keyframesPrefixed = (0, _prefixer.getPrefixedKeyframes)(userAgent);
      var rules = Object.keys(keyframeRules).map(function (percentage) {
        return (0, _cssRuleSetToString2.default)(percentage, keyframeRules[percentage], userAgent);
      }).join('\n');
      var animationName = (name ? name + '-' : '') + 'radium-animation-' + (0, _hash2.default)(rules);
      var css = '@' + keyframesPrefixed + ' ' + animationName + ' {\n' + rules + '\n}\n';
      return { css: css, animationName: animationName };
    }
  };
}

module.exports = exports['default'];

/***/ }),
/* 937 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__);





var Toggle = function Toggle(_ref) {
  var node = _ref.node,
      style = _ref.style,
      onClick = _ref.onClick;
  var height = style.height,
      width = style.width;

  var midHeight = height * 0.5;
  var points = '0,0 0,' + height + ' ' + width + ',' + midHeight;

  var additionalWrapperStyle = node.toggled ? style.wrapperToggled : style.wrapperClosed;
  var wrapperStyle = Object.assign({}, style.wrapper, additionalWrapperStyle);
  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    'div',
    { style: style.base, onClick: onClick },
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'div',
      { style: wrapperStyle },
      __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'svg',
        { height: height, width: width },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement('polygon', {
          points: points,
          style: node.active ? style.arrowActive : style.arrow })
      )
    )
  );
};
Toggle.propTypes = {
  style: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object,
  onClick: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func.isRequired
};

/* harmony default export */ __webpack_exports__["a"] = (Toggle);

/***/ }),
/* 938 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Header; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__components_library_TextInput__ = __webpack_require__(80);


var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp2;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






var Header = (_temp2 = _class = function (_React$Component) {
  _inherits(Header, _React$Component);

  function Header() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, Header);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Header.__proto__ || Object.getPrototypeOf(Header)).call.apply(_ref, [this].concat(args))), _this), _this.onBeginEdit = function () {
      var node = _this.props.node;

      _this.props.onBeginEdit({
        elementID: node.nodeIdentifier
      });
    }, _this.onCancelEdit = function () {
      _this.props.onBeginEdit({});
    }, _this.onRename = function (name) {
      _this.props.onUpdate(_this.props.node, { name: name });
    }, _this.isEditing = function () {
      var _this$props = _this.props,
          node = _this$props.node,
          editingItemID = _this$props.editingItemID;


      return editingItemID && editingItemID === node.nodeIdentifier;
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(Header, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          node = _props.node,
          style = _props.style,
          readOnly = _props.readOnly,
          nodeIcon = _props.nodeIcon;


      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { style: style.base },
        nodeIcon,
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2__components_library_TextInput__["a" /* default */], {
          readOnly: readOnly,
          value: node.name,
          updateErrorOccurred: node.nodeData.updateErrorOccurred,
          editing: this.isEditing(),
          onBeginEdit: this.onBeginEdit,
          onCancelEdit: this.onCancelEdit,
          onChangeValue: this.onRename,
          useDoubleClick: !this.props.node.active,
          style: style.title,
          fieldClassName: 'c-text-input--editable-tree-node ' + (!this.props.node.active ? 'unselected' : null)
        })
      );
    }
  }]);

  return Header;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component), _class.propTypes = {
  style: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object,
  node: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.object.isRequired,
  nodeIcon: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.element,
  onBeginEdit: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func.isRequired,
  onUpdate: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.func.isRequired,
  readOnly: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool,
  editingItemID: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string

}, _temp2);


/***/ }),
/* 939 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";


var lineHeight = '28px';

/* harmony default export */ __webpack_exports__["a"] = ({
  tree: {
    base: {
      listStyle: 'none',
      backgroundColor: '#F6F6F6',
      margin: 0,
      padding: 0,
      color: 'black',
      fontSize: '12px',
      fontWeight: '400',
      overflowX: 'hidden'
    },
    node: {
      base: {
        position: 'relative',
        paddingLeft: '10px'
      },
      link: {
        position: 'relative',
        paddingRight: '5px',
        display: 'flex'
      },
      activeLink: {
        color: 'white',
        backgroundColor: 'transparent'
      },
      activeRow: {
        position: 'absolute',
        backgroundColor: '#6C9CE4',
        width: '120%',
        height: lineHeight,
        top: '0',
        left: '-20%'
      },
      toggle: {
        base: {
          position: 'relative',
          display: 'flex',
          height: lineHeight,
          width: '20px',
          minWidth: '20px',
          alignItems: 'center',
          justifyContent: 'center'

        },
        wrapper: {
          height: '12px'
        },
        wrapperClosed: {
          margin: '0'
        },
        wrapperToggled: {
          margin: '1px 0 -1px 0'
        },
        height: 12,
        width: 6,
        arrow: {
          fill: '#A5A6A6',
          strokeWidth: 0
        },
        arrowActive: {
          fill: 'white',
          strokeWidth: 0
        }
      },
      header: {
        base: {
          display: 'flex',
          alignItems: 'center',
          flexGrow: 2,
          minWidth: 0
        },
        connector: {
          width: '2px',
          height: '12px',
          borderLeft: 'solid 2px black',
          borderBottom: 'solid 2px black',
          position: 'absolute',
          top: '0px',
          left: '-21px'
        },
        nodeIcon: {
          marginRight: '6px',
          flexShrink: '0'
        },
        title: {
          lineHeight: lineHeight,
          verticalAlign: 'middle',
          overflow: 'hidden',
          textOverflow: 'ellipsis',
          whiteSpace: 'nowrap',
          cursor: 'default'
        }
      },
      subtree: {
        listStyle: 'none',
        paddingLeft: '9px'
      }
    }
  }
});

/***/ }),
/* 940 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";


/* harmony default export */ __webpack_exports__["a"] = ({
  toggle: function toggle(_ref) {
    var toggled = _ref.node.toggled;
    return {
      animation: { rotateZ: toggled ? 90 : 0 },
      duration: 300
    };
  },
  drawer: function drawer() {
    return (/* props */{
        enter: {
          animation: 'slideDown',
          duration: 300
        },
        leave: {
          animation: 'slideUp',
          duration: 300
        }
      }
    );
  }
});

/***/ }),
/* 941 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["b"] = mapToTree;
/* harmony export (immutable) */ __webpack_exports__["a"] = mapToList;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_design_systems_lib__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_design_systems_lib___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_design_systems_lib__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__tree_view_types_order__ = __webpack_require__(286);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__shared_constants__ = __webpack_require__(41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__shared_constants___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3__shared_constants__);




var entityTypes = __WEBPACK_IMPORTED_MODULE_1_design_systems_lib__["utils"].entityDescriptors.entityTypes;




function getTypeCustomData(entityKey, item) {

  if (entityKey === entityTypes.colors.key) {
    return { colorValue: item.value };
  }

  return null;
}

function getItemName(placeholder, item) {
  return item.name || placeholder || 'Untitled';
}

function createFolderData(folder, selectedType, selectedFolderId, selectedSectionId, selectedEntityId, toggledNodes, allowActiveNode, canAddNestedNodes) {
  var active = allowActiveNode && folder.folderEntityType === selectedType && folder._id === selectedFolderId && !selectedSectionId && !selectedEntityId;
  var folderIdentifier = folder._id || folder.folderEntityType;

  return {
    nodeIdentifier: folderIdentifier,
    nodeData: folder,
    nodeType: __WEBPACK_IMPORTED_MODULE_3__shared_constants__["treeNodeTypes"].folder,
    name: folder.name,
    type: folder.folderEntityType,
    folderId: folder._id,
    toggled: toggledNodes[folderIdentifier],
    active: active,
    canAddNestedNodes: canAddNestedNodes,
    children: []
  };
}

function createSectionData(section, folder, entity, selectedSectionId, selectedEntityId, allowActiveNode, toggledNodes) {
  var sectionName = section.name || 'Untitled Section';

  return {
    nodeIdentifier: section._id,
    nodeData: section,
    nodeType: __WEBPACK_IMPORTED_MODULE_3__shared_constants__["treeNodeTypes"].section,
    name: sectionName,
    children: [],
    sectionId: section._id,
    folderId: folder._id,
    type: entity.key,
    active: allowActiveNode && section._id === selectedSectionId && !selectedEntityId,
    toggled: toggledNodes[section._id]
  };
}

function createTreeItem(entity, folder, item, selectedEntityId, allowActiveNode) {
  var section = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : {};

  return {
    nodeIdentifier: item._id,
    nodeData: item,
    nodeType: __WEBPACK_IMPORTED_MODULE_3__shared_constants__["treeNodeTypes"].asset,
    name: getItemName(entity.namePlaceholder, item),
    type: entity.key,
    id: item._id,
    customData: getTypeCustomData(entity.key, item),
    active: allowActiveNode && item._id === selectedEntityId,
    sectionId: section._id,
    folderId: folder._id,
    sectionName: section.name
  };
}

function mapFolderToNested(styleguide, entity, folder, selectedType, selectedFolderId, selectedEntityId, toggledNodes, allowActiveNode) {
  var folderData = createFolderData(folder, selectedType, selectedFolderId, null, selectedEntityId, toggledNodes, allowActiveNode, false);

  var folderItems = __WEBPACK_IMPORTED_MODULE_1_design_systems_lib__["utils"].getItemsFromFolder(styleguide, entity, folder._id);

  __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.forEach(folderItems, function (item) {
    folderData.children.push(createTreeItem(entity, folder, item, selectedEntityId, allowActiveNode));
  });

  return folderData;
}

function mapFolderWithSectionsToNested(styleguide, entity, folder, selectedType, selectedFolderId, selectedSectionId, selectedEntityId, toggledNodes, allowActiveNode) {
  var folderData = createFolderData(folder, selectedType, selectedFolderId, selectedSectionId, selectedEntityId, toggledNodes, allowActiveNode, true);

  var folderSections = __WEBPACK_IMPORTED_MODULE_1_design_systems_lib__["utils"].getSectionsFromFolder(styleguide, entity, folder._id);

  __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.forEach(folderSections, function (section) {
    var sectionData = createSectionData(section, folder, entity, selectedSectionId, selectedEntityId, allowActiveNode, toggledNodes);

    __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.forEach(section[entity.typeKey], function (item) {
      sectionData.children.push(createTreeItem(entity, folder, item, selectedEntityId, allowActiveNode, section));
    });

    folderData.children.push(sectionData);
  });

  return folderData;
}

function mapTypeToFlat(globalAssets, entity, selectedId, allowActiveNode) {

  var items = globalAssets[entity.typeKey] || [];

  return __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.map(items, function (item) {
    var section = { _id: item.sectionId, name: item.sectionName };
    return createTreeItem(entity, {}, item, selectedId, allowActiveNode, section);
  });
}

function mapToTree(styleData, selectedType, selectedFolderId, selectedSectionId, selectedEntityId, toggledNodes, allowActiveNode) {

  var styleguide = styleData.styleguide;
  var treeRoots = [];

  __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.forEach(__WEBPACK_IMPORTED_MODULE_2__tree_view_types_order__["a" /* default */], function (entityKey) {
    __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.forEach(styleguide.foldersByType[entityKey], function (folder) {
      var mappedData = void 0;
      var entity = entityTypes[entityKey];
      if (entity.enclosingType) {
        mappedData = mapFolderWithSectionsToNested(styleguide, entity, folder, selectedType, selectedFolderId, selectedSectionId, selectedEntityId, toggledNodes, allowActiveNode);
      } else {
        mappedData = mapFolderToNested(styleguide, entity, folder, selectedType, selectedFolderId, selectedEntityId, toggledNodes, allowActiveNode);
      }

      treeRoots.push(mappedData);
    });
  });

  return treeRoots;
}

function mapToList(styleData, selectedId, allowActiveNode) {

  var treeRoots = [];
  var globalAssets = styleData.globalAssets || {};
  __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.forEach(__WEBPACK_IMPORTED_MODULE_2__tree_view_types_order__["a" /* default */], function (entityKey) {
    var entity = entityTypes[entityKey];
    var mappedItems = mapTypeToFlat(globalAssets, entity, selectedId, allowActiveNode);

    treeRoots = treeRoots.concat(mappedItems);
  });

  return treeRoots;
}

/***/ }),
/* 942 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ApplicationHeader; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__components_library_Icon__ = __webpack_require__(34);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__sketch_native_events__ = __webpack_require__(16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__components_library_Spinner__ = __webpack_require__(943);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__components_library_Tooltip__ = __webpack_require__(944);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }










var AppStatusIcon = {
  CONNECTED: 'status-uptodate',
  DISCONNECTED: 'status-disconnected',
  DOWNLOAD_DATA: 'status-fetching',
  DOWNLOAD_ERROR: 'status-error-fetching'
};

var ApplicationHeader = function (_Component) {
  _inherits(ApplicationHeader, _Component);

  function ApplicationHeader() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, ApplicationHeader);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = ApplicationHeader.__proto__ || Object.getPrototypeOf(ApplicationHeader)).call.apply(_ref, [this].concat(args))), _this), _this.updateDocument = function () {
      var props = _this.props;
      if (props.loadingStyleData || props.prefetchingStyleData) {
        return;
      }
      props.onUpdateDocument();
    }, _this.updateMenu = function () {
      if (_this.props.loadingStyleData || _this.props.loadingUser || _this.props.loadingOrganizations || !_this.props.idToken) {
        return null;
      }
      Object(__WEBPACK_IMPORTED_MODULE_3__sketch_native_events__["openApplicationMenu"])(_this.getMenuData());
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(ApplicationHeader, [{
    key: 'getMenuData',
    value: function getMenuData() {
      var currentOrganization = this.props.currentOrganization || {};
      var pickedFields = ['idToken', 'connected', 'organizations', 'styleguideId', 'snapshotId', 'relativeUpdateDate', 'prefetchingStyleData', 'readOnly'];
      var passedState = __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.pick(this.props, pickedFields);

      passedState.styleguideName = __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.get(this.props.styleguide, 'name');
      passedState.snapshotName = __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.get(this.props.styleguide, 'snapshotName');
      passedState.organizationId = currentOrganization._id;
      passedState.snapshots = this.props.styleguide ? this.props.styleguide.snapshots : null;
      return passedState;
    }

    //if need more than one such case extract it to ButtonWithLoader component

  }, {
    key: 'renderUpdateDocumentButton',
    value: function renderUpdateDocumentButton() {
      var props = this.props;
      if (!props.idToken || !props.styleguideId) {
        return null;
      }

      if (this.props.updatingDocument) {
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__components_library_Spinner__["a" /* default */], null);
      } else {
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          __WEBPACK_IMPORTED_MODULE_5__components_library_Tooltip__["a" /* default */],
          {
            tooltip: 'Sync library to document'
            // Currently aligning the tooltip to the right to avoid z-index & relative positioning collisions
            , alignRight: true
          },
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2__components_library_Icon__["a" /* default */], {
            glyph: 'update-library', size: 16,
            onClick: this.updateDocument
          })
        );
      }
    }
  }, {
    key: 'getAppStatus',
    value: function getAppStatus() {
      var payload = this.props;
      var snapshotName = __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.get(this.props.styleguide, 'snapshotName');

      var lastStatusMessage = '';
      var status = '';

      // Showing disconnected icon if there is no internet connection or no organization was loaded
      if (!payload.connected || !payload.currentOrganization) {
        lastStatusMessage = 'Disconnected';
        status = AppStatusIcon.DISCONNECTED;
        // If there is no styleguide to display to the user, there is no need to show the download icon
      } else if (payload.prefetchingStyleData && !!payload.styleguideId) {
        lastStatusMessage = 'Downloading library data';
        status = AppStatusIcon.DOWNLOAD_DATA;
      } else if (payload.prefetchingStyleDataFailed) {
        lastStatusMessage = 'Problem downloading data';
        status = AppStatusIcon.DOWNLOAD_ERROR;
      } else {
        // Connection status indication
        status = AppStatusIcon.CONNECTED;

        // only if it is not snapshot we will write up to date.
        if (!payload.snapshotId) {
          lastStatusMessage = 'Up to date. ';
        }

        // Add version name indication if relevant
        if (payload.styleguideId && payload.snapshotId && snapshotName) {
          // trim the version name if it is very long, currently hard coded but can be a function of window size
          var maxLength = 30;
          if (snapshotName.length > maxLength) {
            snapshotName = snapshotName.substring(0, maxLength - 3).trim() + '...';
          }
          lastStatusMessage += 'Version ' + snapshotName + ' ';
        }

        // Time indication
        if (payload.relativeUpdateDate) {
          lastStatusMessage += (payload.snapshotId ? 'created ' : 'Last edited ') + payload.relativeUpdateDate + '.';
        }
      }

      return { status: status, statusMessage: lastStatusMessage };
    }
  }, {
    key: 'renderStatusIcon',
    value: function renderStatusIcon() {
      var appStatus = this.getAppStatus();

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        __WEBPACK_IMPORTED_MODULE_5__components_library_Tooltip__["a" /* default */],
        { tooltip: appStatus.statusMessage },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2__components_library_Icon__["a" /* default */], { size: 16, glyph: appStatus.status })
      );
    }
  }, {
    key: 'renderApplicationMenu',
    value: function renderApplicationMenu() {
      var title = __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.get(this.props.styleguide, 'name') || '';
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { className: 'c-application-menu', onClick: this.updateMenu },
        this.renderStatusIcon(),
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          { className: 'c-application-menu__title' },
          title
        ),
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2__components_library_Icon__["a" /* default */], { size: 16, glyph: 'chevron-down-alt' })
      );
    }
  }, {
    key: 'render',
    value: function render() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { className: 'c-application-header' },
        this.renderApplicationMenu(),
        this.renderUpdateDocumentButton()
      );
    }
  }]);

  return ApplicationHeader;
}(__WEBPACK_IMPORTED_MODULE_0_react__["Component"]);



/***/ }),
/* 943 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Spinner; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }



var Spinner = function (_React$Component) {
  _inherits(Spinner, _React$Component);

  function Spinner(props) {
    _classCallCheck(this, Spinner);

    return _possibleConstructorReturn(this, (Spinner.__proto__ || Object.getPrototypeOf(Spinner)).call(this, props));
  }

  _createClass(Spinner, [{
    key: 'render',
    value: function render() {
      var bars = [];
      var props = this.props;

      for (var i = 0; i < 12; i++) {
        var barStyle = {};
        barStyle.WebkitAnimationDelay = barStyle.animationDelay = (i - 12) / 10 + 's';

        barStyle.WebkitTransform = barStyle.transform = 'rotate(' + i * 30 + 'deg) translate(146%)';

        bars.push(__WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement('div', { style: barStyle, className: 'react-spinner_bar', key: i }));
      }

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        _extends({}, props, { className: (props.className || '') + ' react-spinner' }),
        bars
      );
    }
  }]);

  return Spinner;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component);



/***/ }),
/* 944 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Tooltip; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_prop_types__);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var Tooltip = (_temp = _class = function (_React$Component) {
  _inherits(Tooltip, _React$Component);

  function Tooltip() {
    _classCallCheck(this, Tooltip);

    return _possibleConstructorReturn(this, (Tooltip.__proto__ || Object.getPrototypeOf(Tooltip)).apply(this, arguments));
  }

  _createClass(Tooltip, [{
    key: 'render',
    value: function render() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        {
          className: 'c-tooltip c-tooltip-after ' + (this.props.alignRight ? 'c-tooltip-right' : 'c-tooltip-left'),
          'data-tooltip': this.props.tooltip },
        this.props.children
      );
    }
  }]);

  return Tooltip;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component), _class.propTypes = {
  tooltip: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.string.isRequired,
  alignRight: __WEBPACK_IMPORTED_MODULE_1_prop_types___default.a.bool
}, _temp);


/***/ }),
/* 945 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__components_library_LoadingIndicator__ = __webpack_require__(946);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__components_library_FullScreenMessage__ = __webpack_require__(287);





/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var fullScreen = _ref.fullScreen;

  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    __WEBPACK_IMPORTED_MODULE_2__components_library_FullScreenMessage__["a" /* default */],
    { isLight: !fullScreen },
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_1__components_library_LoadingIndicator__["a" /* default */], {
      size: 'large'
    })
  );
});

/***/ }),
/* 946 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return LoadingIndicator; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_prop_types__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react__);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var LoadingIndicator = (_temp = _class = function (_React$Component) {
  _inherits(LoadingIndicator, _React$Component);

  function LoadingIndicator() {
    _classCallCheck(this, LoadingIndicator);

    return _possibleConstructorReturn(this, (LoadingIndicator.__proto__ || Object.getPrototypeOf(LoadingIndicator)).apply(this, arguments));
  }

  _createClass(LoadingIndicator, [{
    key: 'render',
    value: function render() {
      var messageClassName = this.props.messageClassName || 'c-loading-indicator__message';
      var radius = this.props.size === 'small' ? 20 : 30;
      return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
        'div',
        { className: 'c-loading-indicator ' + this.props.className },
        __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
          'div',
          { className: 'c-loading-indicator__loader' },
          __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
            'svg',
            { className: 'c-loading-indicator__circular' },
            __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement('circle', { className: 'c-loading-indicator__path', cx: 32, cy: 32, r: radius, fill: 'none' })
          )
        ),
        this.props.message && __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
          'p',
          { className: messageClassName },
          this.props.message
        )
      );
    }
  }]);

  return LoadingIndicator;
}(__WEBPACK_IMPORTED_MODULE_1_react___default.a.Component), _class.propTypes = {
  message: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.string,
  size: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.oneOf(['small', 'large']),
  className: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.string,
  messageClassName: __WEBPACK_IMPORTED_MODULE_0_prop_types___default.a.string
}, _class.defaultProps = {
  size: 'small',
  message: 'Loading…',
  className: ''
}, _temp);


/***/ }),
/* 947 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);


/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var className = _ref.className,
      children = _ref.children,
      onDropCallback = _ref.onDropCallback;


  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    'div',
    {
      className: className,
      onDragOver: function onDragOver(e) {
        //this is needed for onDrop to be fired
        e.preventDefault();
      },
      onDrop: function onDrop(e) {
        //this is the actual prevention in default drop behavior
        e.preventDefault();
        if (onDropCallback) {
          onDropCallback();
        }
      } },
    children
  );
});

/***/ }),
/* 948 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return RestartSketchMessage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return NoConnectionMessage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ApplicationErrMessage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return OrganizationLoadErrMessage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return NoLibrariesExistMessage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__components_library_FullScreenMessage__ = __webpack_require__(287);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__components_library_Button__ = __webpack_require__(288);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__sketch_native_events__ = __webpack_require__(16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__components_library_WebLink__ = __webpack_require__(289);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }









var RestartSketchMessage = function (_Component) {
  _inherits(RestartSketchMessage, _Component);

  function RestartSketchMessage() {
    _classCallCheck(this, RestartSketchMessage);

    return _possibleConstructorReturn(this, (RestartSketchMessage.__proto__ || Object.getPrototypeOf(RestartSketchMessage)).apply(this, arguments));
  }

  _createClass(RestartSketchMessage, [{
    key: 'render',
    value: function render() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        __WEBPACK_IMPORTED_MODULE_1__components_library_FullScreenMessage__["a" /* default */],
        null,
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          { className: '' },
          'Sketch must be restarted for the update to take effect.'
        ),
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          { className: 'u-mt8' },
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
            __WEBPACK_IMPORTED_MODULE_2__components_library_Button__["a" /* default */],
            { type: 'secondary', onClick: __WEBPACK_IMPORTED_MODULE_3__sketch_native_events__["restartSketch"] },
            'Restart Sketch'
          )
        )
      );
    }
  }]);

  return RestartSketchMessage;
}(__WEBPACK_IMPORTED_MODULE_0_react__["Component"]);

var NoConnectionMessage = function (_Component2) {
  _inherits(NoConnectionMessage, _Component2);

  function NoConnectionMessage() {
    _classCallCheck(this, NoConnectionMessage);

    return _possibleConstructorReturn(this, (NoConnectionMessage.__proto__ || Object.getPrototypeOf(NoConnectionMessage)).apply(this, arguments));
  }

  _createClass(NoConnectionMessage, [{
    key: 'render',
    value: function render() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        __WEBPACK_IMPORTED_MODULE_1__components_library_FullScreenMessage__["a" /* default */],
        null,
        'Connection not found. You can access your library when you are back online.'
      );
    }
  }]);

  return NoConnectionMessage;
}(__WEBPACK_IMPORTED_MODULE_0_react__["Component"]);

var ApplicationErrMessage = function (_Component3) {
  _inherits(ApplicationErrMessage, _Component3);

  function ApplicationErrMessage() {
    _classCallCheck(this, ApplicationErrMessage);

    return _possibleConstructorReturn(this, (ApplicationErrMessage.__proto__ || Object.getPrototypeOf(ApplicationErrMessage)).apply(this, arguments));
  }

  _createClass(ApplicationErrMessage, [{
    key: 'render',
    value: function render() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        __WEBPACK_IMPORTED_MODULE_1__components_library_FullScreenMessage__["a" /* default */],
        { contentClass: 'u-full-width' },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          { className: 'message' },
          'Could not connect to Design Libraries'
        ),
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'p',
          { className: 'note' },
          this.props.error.message
        )
      );
    }
  }]);

  return ApplicationErrMessage;
}(__WEBPACK_IMPORTED_MODULE_0_react__["Component"]);

var OrganizationLoadErrMessage = function (_Component4) {
  _inherits(OrganizationLoadErrMessage, _Component4);

  function OrganizationLoadErrMessage() {
    _classCallCheck(this, OrganizationLoadErrMessage);

    return _possibleConstructorReturn(this, (OrganizationLoadErrMessage.__proto__ || Object.getPrototypeOf(OrganizationLoadErrMessage)).apply(this, arguments));
  }

  _createClass(OrganizationLoadErrMessage, [{
    key: 'render',
    value: function render() {
      if (this.props.errorData.statusCode !== 404) {
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(ApplicationErrMessage, { error: this.props.errorData.errorMessage });
      } else {
        var helpDocURL = 'https://support.invisionapp.com/hc/en-us/articles/360000124503-Signing-into-your-Enterprise-account-in-the-DSM-Sketch-plugin';
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          __WEBPACK_IMPORTED_MODULE_1__components_library_FullScreenMessage__["a" /* default */],
          { contentClass: 'u-full-width' },
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
            'div',
            { className: 'message' },
            '\u200B\u200B\u200B\u200BDouble-check your details'
          ),
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
            'p',
            { className: 'note' },
            'We\u2019re having trouble connecting you to the Enterprise domain you entered, ',
            this.props.baseHost,
            '.',
            __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
              'p',
              null,
              'Please make sure you\u2019re signed in to the right account.'
            ),
            __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
              'a',
              { href: 'javascript:void(0)', onClick: this.props.onSignOut },
              'sign out'
            ),
            '\xA0or\xA0',
            __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_4__components_library_WebLink__["a" /* WebLink */], { url: helpDocURL, text: 'learn more' })
          )
        );
      }
    }
  }]);

  return OrganizationLoadErrMessage;
}(__WEBPACK_IMPORTED_MODULE_0_react__["Component"]);

var NoLibrariesExistMessage = function (_Component5) {
  _inherits(NoLibrariesExistMessage, _Component5);

  function NoLibrariesExistMessage() {
    _classCallCheck(this, NoLibrariesExistMessage);

    return _possibleConstructorReturn(this, (NoLibrariesExistMessage.__proto__ || Object.getPrototypeOf(NoLibrariesExistMessage)).apply(this, arguments));
  }

  _createClass(NoLibrariesExistMessage, [{
    key: 'render',
    value: function render() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        __WEBPACK_IMPORTED_MODULE_1__components_library_FullScreenMessage__["a" /* default */],
        null,
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          { className: 'message' },
          'No Design Libraries found.'
        ),
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          { className: 'u-small u-mt5' },
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
            'span',
            { className: 'u-mr1' },
            'Create one at '
          ),
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
            'a',
            {
              href: 'javascript:void(0)',
              onClick: this.props.viewHomepage
            },
            'InvisionApp.com'
          )
        )
      );
    }
  }]);

  return NoLibrariesExistMessage;
}(__WEBPACK_IMPORTED_MODULE_0_react__["Component"]);

/***/ }),
/* 949 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return LoginScreen; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__sketch__ = __webpack_require__(18);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_file_loader_dsm_login_png__ = __webpack_require__(950);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_file_loader_dsm_login_png___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_file_loader_dsm_login_png__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__components_library_WebLink__ = __webpack_require__(289);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }







// this is v6 link, until we will add support also for v7
var registerUrl = 'https://projects.invisionapp.com/d/signup';

function openCraftLogin() {
  __WEBPACK_IMPORTED_MODULE_1__sketch__["g" /* postNativeUIEvent */]('onPresentAuthModal', { shown: true });
}

var LoginScreen = function (_Component) {
  _inherits(LoginScreen, _Component);

  function LoginScreen() {
    _classCallCheck(this, LoginScreen);

    return _possibleConstructorReturn(this, (LoginScreen.__proto__ || Object.getPrototypeOf(LoginScreen)).apply(this, arguments));
  }

  _createClass(LoginScreen, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      __WEBPACK_IMPORTED_MODULE_1__sketch__["g" /* postNativeUIEvent */]('onResizeToLoginScreen');
    }
  }, {
    key: 'render',
    value: function render() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { className: 'c-login-screen__content' },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement('img', { className: 'c-login-screen__illustration', src: __WEBPACK_IMPORTED_MODULE_2_file_loader_dsm_login_png___default.a }),
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          { className: 'c-login-screen__headline' },
          'Use InVision Design System Manager to create, maintain, and share libraries.'
        ),
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'button',
          { className: 'c-login-screen__button', onClick: openCraftLogin },
          'Sign In to InVision'
        ),
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          { className: 'c-login-screen__register' },
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
            'span',
            { className: 'c-login-screen__register-title' },
            'New to InVision? '
          ),
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3__components_library_WebLink__["a" /* WebLink */], { className: 'c-style-elements-link', url: registerUrl, text: 'Sign up' })
        )
      );
    }
  }]);

  return LoginScreen;
}(__WEBPACK_IMPORTED_MODULE_0_react__["Component"]);

/***/ }),
/* 950 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__.p + "c19349add9fc0ebd9d07373cdd986d38.png";

/***/ }),
/* 951 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return IntroductionFlow; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__sketch_native_events__ = __webpack_require__(16);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__brandai_design_systems_web__ = __webpack_require__(42);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__brandai_design_systems_web___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2__brandai_design_systems_web__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__components_library_Button__ = __webpack_require__(288);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }







var PreviewMode = __WEBPACK_IMPORTED_MODULE_2__brandai_design_systems_web__["compositeComponents"].PreviewMode;

var IntroductionFlow = function (_React$Component) {
  _inherits(IntroductionFlow, _React$Component);

  function IntroductionFlow(props) {
    _classCallCheck(this, IntroductionFlow);

    var _this = _possibleConstructorReturn(this, (IntroductionFlow.__proto__ || Object.getPrototypeOf(IntroductionFlow)).call(this, props));

    _this.onPreviewContinue = function () {
      _this.setState({ previewMessageSeen: true });
    };

    _this.renderPreviewModeMessage = function () {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { style: { marginTop: 50 } },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(PreviewMode, {
          onContinue: _this.onPreviewContinue,
          onLearnMore: __WEBPACK_IMPORTED_MODULE_1__sketch_native_events__["openURLInBrowser"]
        })
      );
    };

    _this.renderIntroductionVideo = function () {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { className: 'u-p10 u-text-center' },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement('iframe', {
          id: 'rb0386j9rg', src: 'https://fast.wistia.net/embed/iframe/rb0386j9rg',
          frameBorder: '0', scrolling: 'no', className: 'wistia_embed', name: 'wistia_embed', width: '100%',
          style: { height: 'calc(100vh - 104px)' }
        }),
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          null,
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
            __WEBPACK_IMPORTED_MODULE_3__components_library_Button__["a" /* default */],
            { className: 'u-mt10', type: 'secondary', onClick: _this.props.onGetStarted },
            'GET STARTED'
          )
        )
      );
    };

    _this.state = { previewMessageSeen: false };
    return _this;
  }

  _createClass(IntroductionFlow, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      Object(__WEBPACK_IMPORTED_MODULE_1__sketch_native_events__["resizeMainWindnow"])({ height: 636, width: 1000 });
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      Object(__WEBPACK_IMPORTED_MODULE_1__sketch_native_events__["resizeMainWindnow"])({ height: 450, width: 680 });
    }
  }, {
    key: 'render',
    value: function render() {
      if (!this.state.previewMessageSeen && !this.props.trialFeatureEnabled) {
        return this.renderPreviewModeMessage();
      } else {
        return this.renderIntroductionVideo();
      }
    }
  }]);

  return IntroductionFlow;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component);



/***/ }),
/* 952 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return TrialSubscriptionHeader; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__brandai_design_systems_web__ = __webpack_require__(42);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__brandai_design_systems_web___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1__brandai_design_systems_web__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_prop_types__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_prop_types___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_prop_types__);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp2;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }




var TrialSubscriptionManager = __WEBPACK_IMPORTED_MODULE_1__brandai_design_systems_web__["compositeComponents"].TrialSubscriptionManager;




var TrialSubscriptionHeader = (_temp2 = _class = function (_Component) {
  _inherits(TrialSubscriptionHeader, _Component);

  function TrialSubscriptionHeader() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, TrialSubscriptionHeader);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = TrialSubscriptionHeader.__proto__ || Object.getPrototypeOf(TrialSubscriptionHeader)).call.apply(_ref, [this].concat(args))), _this), _this.renderHeader = function (message) {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { className: 'c-trial-header' },
        message,
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          { className: 'c-trial-header__link', onClick: _this.props.onManagePlans },
          'Manage Plans'
        )
      );
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(TrialSubscriptionHeader, [{
    key: 'render',
    value: function render() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(TrialSubscriptionManager, {
        organization: this.props.organization,
        onTrialExpired: this.props.onTrialExpired,
        renderHeader: this.renderHeader
      });
    }
  }]);

  return TrialSubscriptionHeader;
}(__WEBPACK_IMPORTED_MODULE_0_react__["Component"]), _class.propTypes = {
  organization: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.object,
  onTrialExpired: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func,
  onManagePlans: __WEBPACK_IMPORTED_MODULE_2_prop_types___default.a.func.isRequired
}, _temp2);


/***/ }),
/* 953 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = loadAnalytics;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__analytics_client_js__ = __webpack_require__(104);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_load_script2__ = __webpack_require__(954);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_load_script2___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_load_script2__);



function loadAnalytics(baseHost, invisionAuthMode, onError, onSuccess) {
  var analyticsURL = baseHost + '/measure/utilities.js';

  if (__WEBPACK_IMPORTED_MODULE_0__analytics_client_js__["a" /* default */].isAnalyticsLoaded()) {
    // analytics globals exist, no need to load twice
    return;
  }

  __WEBPACK_IMPORTED_MODULE_1_load_script2___default()(analyticsURL, function (err) {
    if (err) {
      onError('Unable to load analytics script', err);
    } else {
      if (!__WEBPACK_IMPORTED_MODULE_0__analytics_client_js__["a" /* default */].isAnalyticsLoaded()) {
        onError('Unable to load analytics script', 'analytics is not loaded');
      } else {
        __WEBPACK_IMPORTED_MODULE_0__analytics_client_js__["a" /* default */].load("qlYMpWWVegoXI2HyIrepJnzXw9MMZY10", invisionAuthMode);
        onSuccess();
      }
    }
  });
}

/***/ }),
/* 954 */
/***/ (function(module, exports) {

module.exports = load

function load (src, cb) {
  var head = document.head || document.getElementsByTagName('head')[0]
  var script = document.createElement('script')

  script.type = 'text/javascript'
  script.async = true
  script.src = src

  if (cb) {
    script.onload = function () {
      script.onerror = script.onload = null
      cb(null, script)
    }
    script.onerror = function () {
      script.onerror = script.onload = null
      cb(new Error('Failed to load ' + src), script)
    }
  }

  head.appendChild(script)
}


/***/ }),
/* 955 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return AddColorsApp; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__tiles_ColorTile__ = __webpack_require__(118);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__App__ = __webpack_require__(46);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






var AddColorsApp = function (_App) {
  _inherits(AddColorsApp, _App);

  function AddColorsApp(props) {
    _classCallCheck(this, AddColorsApp);

    var _this = _possibleConstructorReturn(this, (AddColorsApp.__proto__ || Object.getPrototypeOf(AddColorsApp)).call(this, props));

    _this.state = {
      colorSections: []
    };
    return _this;
  }

  _createClass(AddColorsApp, [{
    key: 'exportToNativeHost',
    value: function exportToNativeHost() {
      return [this.setColors, this.getSelectedColors];
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var sections = this.state.colorSections.map(function (section, sectionIdx) {
        return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
          'div',
          { key: section.name },
          __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
            'div',
            { className: 'color-section__title' },
            section.name
          ),
          __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
            'div',
            { className: 'grid u-mb10' },
            section.colors.map(function (color, colorIdx) {

              var selectionClassName = color.selected ? 'color-tile--selected' : 'color-tile--unselected';
              return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
                'div',
                { className: 'color-tile ' + selectionClassName, key: colorIdx },
                __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2__tiles_ColorTile__["a" /* default */], {
                  color: color.color,
                  size: 'sm',
                  onSelect: _this2.toggleSelected.bind(_this2, sectionIdx, colorIdx),
                  nameHidden: true,
                  draggable: false,
                  readOnly: true
                })
              );
            })
          )
        );
      });
      return __WEBPACK_IMPORTED_MODULE_1_react___default.a.createElement(
        'div',
        { className: 'c-native-app' },
        sections
      );
    }
  }, {
    key: 'toggleSelected',
    value: function toggleSelected(sectionIdx, colorIdx) {
      var _this3 = this;

      var colorSections = __WEBPACK_IMPORTED_MODULE_0_lodash___default.a.cloneDeep(this.state.colorSections);
      colorSections[sectionIdx].colors[colorIdx].selected = !colorSections[sectionIdx].colors[colorIdx].selected;

      this.setState({ colorSections: colorSections }, function () {
        _this3.nativeHost.onSelectionChanged(_this3.getSelectedColors().length);
      });
    }
  }, {
    key: 'setColors',
    value: function setColors(colorSections) {
      this.setState({
        colorSections: colorSections.map(function (section) {
          return {
            name: section.name,
            colors: section.colors.map(function (color) {
              return {
                selected: false,
                color: color
              };
            })
          };
        })
      });
    }
  }, {
    key: 'getSelectedColors',
    value: function getSelectedColors() {
      return __WEBPACK_IMPORTED_MODULE_0_lodash___default()(this.state.colorSections).flatMap('colors').filter({ selected: true }).map('color').value();
    }
  }]);

  return AddColorsApp;
}(__WEBPACK_IMPORTED_MODULE_3__App__["a" /* default */]);



/***/ }),
/* 956 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ManageTypeStylesApp; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__App__ = __webpack_require__(46);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__components_library_ListView__ = __webpack_require__(290);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__tiles_TypeStyleSample__ = __webpack_require__(152);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






var ManageTypeStylesApp = function (_App) {
  _inherits(ManageTypeStylesApp, _App);

  function ManageTypeStylesApp(props) {
    _classCallCheck(this, ManageTypeStylesApp);

    var _this = _possibleConstructorReturn(this, (ManageTypeStylesApp.__proto__ || Object.getPrototypeOf(ManageTypeStylesApp)).call(this, props));

    _this.state = {
      idKey: 'ObjectID' //inital value that can be overrriden
    };
    return _this;
  }

  _createClass(ManageTypeStylesApp, [{
    key: 'exportToNativeHost',
    value: function exportToNativeHost() {
      return [this.setTypeStyles, this.getSelectedTypeStyles, this.toggleSelectAll];
    }
  }, {
    key: 'render',
    value: function render() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2__components_library_ListView__["a" /* default */], {
        ref: 'typeStylesList',
        idKey: this.state.idKey,
        sortBy: 'name',
        onSelectionChanged: this.nativeHost.onSelectionChanged,
        renderItem: this.renderTypeStyle.bind(this)
      });
    }
  }, {
    key: 'renderTypeStyle',
    value: function renderTypeStyle(typeStyle, isSelected, toggleSelected) {
      var key = typeStyle[this.state.idKey];
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { className: 'u-section-border-bottom', key: key },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3__tiles_TypeStyleSample__["a" /* default */], {
          typeStyle: typeStyle,
          selected: isSelected,
          onSelect: toggleSelected,
          rowView: true
        })
      );
    }
  }, {
    key: 'setTypeStyles',
    value: function setTypeStyles(typeStyles, idKey) {
      this.refs.typeStylesList.setItems(typeStyles);
      this.setState({ idKey: idKey });
    }
  }, {
    key: 'getSelectedTypeStyles',
    value: function getSelectedTypeStyles() {
      return this.refs.typeStylesList.getSelectedItems();
    }
  }, {
    key: 'toggleSelectAll',
    value: function toggleSelectAll() {
      this.refs.typeStylesList.toggleSelectAll();
    }
  }]);

  return ManageTypeStylesApp;
}(__WEBPACK_IMPORTED_MODULE_1__App__["a" /* default */]);



/***/ }),
/* 957 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ManageSharedStylesApp; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__App__ = __webpack_require__(46);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__components_library_ListView__ = __webpack_require__(290);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__tiles_SharedStyleRow__ = __webpack_require__(958);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






var ManageSharedStylesApp = function (_App) {
  _inherits(ManageSharedStylesApp, _App);

  function ManageSharedStylesApp(props) {
    _classCallCheck(this, ManageSharedStylesApp);

    var _this = _possibleConstructorReturn(this, (ManageSharedStylesApp.__proto__ || Object.getPrototypeOf(ManageSharedStylesApp)).call(this, props));

    _this.state = {
      idKey: 'ObjectID' //inital value that can be overrriden
    };
    return _this;
  }

  _createClass(ManageSharedStylesApp, [{
    key: 'exportToNativeHost',
    value: function exportToNativeHost() {
      return [this.setSharedStyles, this.getSelectedSharedStyles, this.toggleSelectAll];
    }
  }, {
    key: 'render',
    value: function render() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_2__components_library_ListView__["a" /* default */], {
        ref: 'sharedStylesList',
        idKey: this.state.idKey,
        sortBy: 'name',
        onSelectionChanged: this.nativeHost.onSelectionChanged,
        renderItem: this.renderSharedStyle.bind(this)
      });
    }
  }, {
    key: 'renderSharedStyle',
    value: function renderSharedStyle(sharedStyle, isSelected, toggleSelected) {

      var key = sharedStyle[this.state.idKey];
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { className: 'u-section-border-bottom', key: key },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3__tiles_SharedStyleRow__["a" /* default */], {
          name: sharedStyle.name,
          thumbnailURL: sharedStyle.thumbnailUrl,
          thumbnailSize: 24,
          selected: isSelected,
          onSelect: toggleSelected
        })
      );
    }
  }, {
    key: 'setSharedStyles',
    value: function setSharedStyles(sharedStyles, idKey) {
      this.refs.sharedStylesList.setItems(sharedStyles);
      this.setState({ idKey: idKey });
    }
  }, {
    key: 'getSelectedSharedStyles',
    value: function getSelectedSharedStyles() {
      return this.refs.sharedStylesList.getSelectedItems();
    }
  }, {
    key: 'toggleSelectAll',
    value: function toggleSelectAll() {
      this.refs.sharedStylesList.toggleSelectAll();
    }
  }]);

  return ManageSharedStylesApp;
}(__WEBPACK_IMPORTED_MODULE_1__App__["a" /* default */]);



/***/ }),
/* 958 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);


/* harmony default export */ __webpack_exports__["a"] = (function (_ref) {
  var name = _ref.name,
      thumbnailSize = _ref.thumbnailSize,
      thumbnailURL = _ref.thumbnailURL,
      selected = _ref.selected,
      onSelect = _ref.onSelect;


  return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
    'div',
    {
      className: 'u-px6 u-py3',
      onMouseDown: onSelect ? function (evt) {
        return onSelect(evt);
      } : null,
      style: {
        backgroundColor: selected ? 'ActiveBorder' : null,
        color: selected ? 'white' : null
      }
    },
    __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'div',
      { className: 'flex items-center' },
      __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement('img', {
        src: thumbnailURL,
        width: thumbnailSize,
        height: thumbnailSize,
        draggable: false
      }),
      !name ? null : __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { className: 'flex-auto u-ml6' },
        name
      )
    )
  );
});

/***/ }),
/* 959 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ManageSymbolsApp; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__App__ = __webpack_require__(46);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__tiles_ImageTile__ = __webpack_require__(270);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__util_js__ = __webpack_require__(12);
var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }







var ManageSymbolsApp = function (_App) {
  _inherits(ManageSymbolsApp, _App);

  function ManageSymbolsApp(props) {
    _classCallCheck(this, ManageSymbolsApp);

    var _this = _possibleConstructorReturn(this, (ManageSymbolsApp.__proto__ || Object.getPrototypeOf(ManageSymbolsApp)).call(this, props));

    _this.state = {
      sketchSymbols: []
    };
    return _this;
  }

  _createClass(ManageSymbolsApp, [{
    key: 'exportToNativeHost',
    value: function exportToNativeHost() {
      return [this.setSymbols, this.getSelectedSymbols];
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var symbols = __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.map(this.state.sketchSymbols, function (sketchSymbol) {
        return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          {
            className: 'cell cell-native-sm'
            // style={{width: 106}}
            , key: sketchSymbol._id,
            onClick: function onClick() {
              return _this2.toggleSelected(sketchSymbol._id);
            }
          },
          __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(__WEBPACK_IMPORTED_MODULE_3__tiles_ImageTile__["a" /* default */], {
            image: sketchSymbol,
            size: 'sm',
            preferPngFormat: true,
            readOnly: true,
            editing: false,
            draggable: false,
            selected: sketchSymbol.selected
          })
        );
      });

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { className: 'c-native-app' },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'div',
          { className: 'grid' },
          symbols
        )
      );
    }
  }, {
    key: 'setSymbols',
    value: function setSymbols(sketchSymbols) {
      var clonedSketchSymbols = __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.cloneDeep(sketchSymbols);
      this.setState({
        sketchSymbols: __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.map(clonedSketchSymbols, function (symbol) {
          return _extends({
            selected: false
          }, symbol);
        })
      });
    }
  }, {
    key: 'getSelectedSymbols',
    value: function getSelectedSymbols() {
      return __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.filter(this.state.sketchSymbols, { selected: true });
    }
  }, {
    key: 'toggleSelected',
    value: function toggleSelected(symbolId) {
      var _this3 = this;

      var selectedSymbol = __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.find(this.state.sketchSymbols, { _id: symbolId });
      selectedSymbol.selected = !selectedSymbol.selected;
      this.forceUpdate(function () {
        _this3.nativeHost.onSelectionChanged(_this3.getSelectedSymbols().length);
      });
    }
  }]);

  return ManageSymbolsApp;
}(__WEBPACK_IMPORTED_MODULE_2__App__["a" /* default */]);



/***/ }),
/* 960 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return SelectiveSyncApp; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__App__ = __webpack_require__(46);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__shared_constants__ = __webpack_require__(41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__shared_constants___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3__shared_constants__);
var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }






var SelectiveSyncApp = function (_App) {
  _inherits(SelectiveSyncApp, _App);

  function SelectiveSyncApp(props) {
    _classCallCheck(this, SelectiveSyncApp);

    var _this = _possibleConstructorReturn(this, (SelectiveSyncApp.__proto__ || Object.getPrototypeOf(SelectiveSyncApp)).call(this, props));

    _this.items = {};
    _this.state = {};

    _this.toggleSelected = _this.toggleSelected.bind(_this);
    return _this;
  }

  _createClass(SelectiveSyncApp, [{
    key: 'exportToNativeHost',
    value: function exportToNativeHost() {
      return [this.getSelectedItems];
    }
  }, {
    key: 'renderExplanation',
    value: function renderExplanation() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { className: 'u-px10 u-pt10' },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'p',
          { className: 'u-bold' },
          'Select Items to Sync'
        ),
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'p',
          { className: 'u-my9' },
          'All items in each category will be added to the document. Items that already exist in the document will be updated.'
        )
      );
    }
  }, {
    key: 'renderTypeRow',
    value: function renderTypeRow(type) {
      var _this2 = this;

      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { className: 'u-mb3' },
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement('input', {
          id: type.key, ref: function ref(c) {
            return _this2.items[type.key] = c;
          }, type: 'checkbox', defaultChecked: true,
          onChange: this.toggleSelected }),
        __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'label',
          { htmlFor: type.key },
          ' ',
          type.label
        ),
        type.description ? __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
          'p',
          { className: 'u-inline-block u-small u-m0 u-ml3', style: { color: 'gray' } },
          '\u2014 ',
          type.description
        ) : null
      );
    }
  }, {
    key: 'renderTypeSelection',
    value: function renderTypeSelection() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { className: 'u-px10' },
        this.renderTypeRow(__WEBPACK_IMPORTED_MODULE_3__shared_constants__["TYPES_TO_SYNC"].symbols),
        this.renderTypeRow(__WEBPACK_IMPORTED_MODULE_3__shared_constants__["TYPES_TO_SYNC"].typeStyles),
        this.renderTypeRow(__WEBPACK_IMPORTED_MODULE_3__shared_constants__["TYPES_TO_SYNC"].sharedStyles),
        this.renderTypeRow(__WEBPACK_IMPORTED_MODULE_3__shared_constants__["TYPES_TO_SYNC"].colors)
      );
    }
  }, {
    key: 'render',
    value: function render() {
      return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
        'div',
        { style: { backgroundColor: '#EFEFEF', height: '100vh' } },
        this.renderExplanation(),
        this.renderTypeSelection()
      );
    }
  }, {
    key: 'getSelectedItems',
    value: function getSelectedItems() {
      var checkedItems = __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.chain(this.items).map(function (item, key) {
        if (item.checked) {
          return key;
        }
        return null;
      }).compact().value();

      return __WEBPACK_IMPORTED_MODULE_1_lodash___default.a.pick(__WEBPACK_IMPORTED_MODULE_3__shared_constants__["TYPES_TO_SYNC"], checkedItems);
    }
  }, {
    key: 'toggleSelected',
    value: function toggleSelected() {
      var _this3 = this;

      this.forceUpdate(function () {
        _this3.nativeHost.onSelectionChanged(__WEBPACK_IMPORTED_MODULE_1_lodash___default.a.keys(_this3.getSelectedItems()).length);
      });
    }
  }]);

  return SelectiveSyncApp;
}(__WEBPACK_IMPORTED_MODULE_2__App__["a" /* default */]);



/***/ }),
/* 961 */
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(962);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"cacheDirectory":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(100)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {
	// When the styles change, update the <style> tags
	if(!content.locals) {
		module.hot.accept("!!../../node_modules/css-loader/index.js??ref--3-1!../../node_modules/postcss-loader/lib/index.js??ref--3-2!../../node_modules/sass-loader/lib/loader.js??ref--3-3!./index.scss", function() {
			var newContent = require("!!../../node_modules/css-loader/index.js??ref--3-1!../../node_modules/postcss-loader/lib/index.js??ref--3-2!../../node_modules/sass-loader/lib/loader.js??ref--3-3!./index.scss");
			if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
			update(newContent);
		});
	}
	// When the module is disposed, remove the <style> tags
	module.hot.dispose(function() { update(); });
}

/***/ }),
/* 962 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(151)(undefined);
// imports


// module
exports.push([module.i, "/*\n    Font Styles:\n*/\n.c-new-organization-form {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-orient: vertical;\n  -webkit-box-direction: normal;\n      -ms-flex-direction: column;\n          flex-direction: column;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center;\n  width: 480px;\n  max-width: 480px; }\n\n.c-new-organization-form__details {\n  width: 100%;\n  margin-bottom: 15px; }\n  .c-new-organization-form__details input {\n    font-size: 14px;\n    line-height: 24px;\n    padding: 12px;\n    height: 48px;\n    border-radius: 3px; }\n\n.c-new-organization-form__title {\n  font-size: 22px;\n  color: rgba(0, 0, 0, 0.87);\n  margin-bottom: 10px;\n  text-align: center; }\n\n.c-new-organization-form__subtitle {\n  font-size: 16px;\n  font-weight: 300;\n  color: rgba(0, 0, 0, 0.56);\n  font-size: 14px;\n  max-width: 480px;\n  text-align: center;\n  margin: 0 auto 32px; }\n\n.c-new-organization-form__loading-message {\n  font-size: 20px;\n  color: rgba(0, 0, 0, 0.87);\n  text-align: center;\n  margin-top: 15px; }\n\n.c-new-organization-form__account-status {\n  position: fixed;\n  bottom: 20px;\n  left: 0px;\n  width: 100%;\n  text-align: center; }\n\n.c-new-organization-form__link {\n  color: #3399ff;\n  cursor: pointer; }\n\n.c-preview-mode {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-orient: vertical;\n  -webkit-box-direction: normal;\n      -ms-flex-direction: column;\n          flex-direction: column;\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  margin-top: -72px; }\n\n.c-preview-mode__title {\n  font-size: 22px;\n  color: #000000;\n  margin-bottom: 8px; }\n\n.c-preview-mode__subtitle {\n  font-size: 16px;\n  font-weight: 300;\n  color: #000000;\n  font-size: 14px;\n  margin-bottom: 32px; }\n\n.c-preview-mode__button {\n  width: 190px;\n  text-transform: uppercase; }\n\n.c-single-illustration-full-screen {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-orient: vertical;\n  -webkit-box-direction: normal;\n      -ms-flex-direction: column;\n          flex-direction: column;\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  min-height: 100vh;\n  padding: 20px; }\n\n.c-single-illustration-full-screen__title {\n  font-size: 22px;\n  color: #000000;\n  margin-top: 32px; }\n\n.c-single-illustration-full-screen__subtitle {\n  font-size: 16px;\n  font-weight: 300;\n  color: #a5a6a6;\n  font-size: 14px;\n  white-space: pre-line;\n  text-align: center;\n  margin-top: 8px; }\n\n.c-single-illustration-full-screen__button {\n  text-transform: uppercase;\n  letter-spacing: 1px;\n  font-weight: 300;\n  margin-top: 32px; }\n\n.c-single-illustration-full-screen__link {\n  margin-top: 16px;\n  color: #3399ff;\n  cursor: pointer; }\n  .c-single-illustration-full-screen__link:visited, .c-single-illustration-full-screen__link:hover, .c-single-illustration-full-screen__link:active, .c-single-illustration-full-screen__link:focus {\n    color: #3399ff; }\n\n.c-single-illustration-full-screen__close {\n  position: absolute;\n  top: 25px;\n  right: 32px; }\n\n.c-end-of-early-access {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-orient: vertical;\n  -webkit-box-direction: normal;\n      -ms-flex-direction: column;\n          flex-direction: column;\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  min-height: 100vh;\n  padding: 20px; }\n\n.c-end-of-early-access__title {\n  font-size: 22px;\n  color: #000000;\n  margin-top: 64px; }\n\n.c-end-of-early-access__subtitle {\n  font-size: 16px;\n  font-weight: 300;\n  color: #a5a6a6;\n  font-size: 14px;\n  white-space: pre-line;\n  text-align: center;\n  margin-top: 40px;\n  max-width: 650px; }\n\n.c-end-of-early-access__button {\n  text-transform: uppercase;\n  letter-spacing: 1px;\n  font-weight: 300;\n  margin-top: 48px; }\n\n.c-validation-input__label {\n  font-size: 16px;\n  font-weight: 600;\n  color: #bcbcbc;\n  font-size: 12px;\n  display: block; }\n\n.c-validation-input__error {\n  font-size: 16px;\n  font-weight: 400;\n  color: #d1481e;\n  font-size: 12px;\n  margin-top: 8px; }\n\n.c-validation-input--empty:empty:before {\n  content: \"\\A0\"; }\n\n.c-validation-input__form-group {\n  margin-bottom: 0px; }\n\n.has-error .form-control {\n  border: 1px solid #d1481e;\n  border-radius: 3px;\n  -webkit-box-shadow: none;\n          box-shadow: none; }\n  .has-error .form-control:focus {\n    -webkit-box-shadow: none;\n            box-shadow: none;\n    border: 1px solid #d1481e;\n    border-radius: 3px; }\n\n/* this file supports the logic and should not contain styling classes, use _rich-text-editor.scss for styling */\ndiv.ql-editor[contenteditable] {\n  -webkit-user-select: text;\n     -moz-user-select: text;\n      -ms-user-select: text;\n          user-select: text; }\n\ndiv.ql-clipboard[contenteditable] {\n  -webkit-user-select: text;\n     -moz-user-select: text;\n      -ms-user-select: text;\n          user-select: text; }\n\n.c-rich-text-editor--readonly .ql-blank {\n  display: none; }\n\n.c-rich-text-editor--readonly .ql-editor > * {\n  cursor: default; }\n\n.c-rich-text-editor--no-toolbar div.ql-toolbar {\n  display: none; }\n\n.c-rich-text-editor--no-toolbar .ql-container.ql-snow {\n  border: 0; }\n\n.c-close-button__close-icon {\n  margin-bottom: 4px; }\n\n.c-close-button__close {\n  min-width: 64px;\n  min-height: 64px;\n  border-radius: 100%;\n  font-weight: 400;\n  font-size: 10px;\n  color: #bcbcbc;\n  letter-spacing: 1px;\n  -webkit-transition: all 500ms ease;\n  transition: all 500ms ease;\n  cursor: pointer;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center;\n  -webkit-box-orient: vertical;\n  -webkit-box-direction: normal;\n      -ms-flex-direction: column;\n          flex-direction: column; }\n\n.c-close-button__close:hover {\n  -webkit-transition: background-color .2s ease;\n  transition: background-color .2s ease;\n  background-color: #f6f6f6;\n  color: #a5a6a6; }\n\n.c-loading-indicator {\n  text-align: center; }\n\n.c-loading-indicator__message {\n  font-size: 12px;\n  color: #bcbcbc;\n  margin-top: 10px; }\n\n@-webkit-keyframes rotate {\n  from {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg); }\n  to {\n    -webkit-transform: rotate(360deg);\n            transform: rotate(360deg); } }\n\n@keyframes rotate {\n  from {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg); }\n  to {\n    -webkit-transform: rotate(360deg);\n            transform: rotate(360deg); } }\n\n@-webkit-keyframes dash {\n  0% {\n    stroke-dasharray: 1, 200;\n    stroke-dashoffset: 0; }\n  50% {\n    stroke-dasharray: 150, 200;\n    stroke-dashoffset: -50; }\n  100% {\n    stroke-dasharray: 150, 200;\n    stroke-dashoffset: -185; } }\n\n@keyframes dash {\n  0% {\n    stroke-dasharray: 1, 200;\n    stroke-dashoffset: 0; }\n  50% {\n    stroke-dasharray: 150, 200;\n    stroke-dashoffset: -50; }\n  100% {\n    stroke-dasharray: 150, 200;\n    stroke-dashoffset: -185; } }\n\n.c-loading-indicator__loader {\n  position: relative;\n  margin: 0 auto;\n  width: 64px;\n  height: 64px; }\n\n.c-loading-indicator__circular {\n  -webkit-animation: spin 2s linear infinite;\n          animation: spin 2s linear infinite;\n  position: relative;\n  width: 64px;\n  height: 64px; }\n\n.c-loading-indicator__path {\n  stroke-dasharray: 1,200;\n  stroke-dashoffset: 0;\n  -webkit-animation: dash 1.5s ease-in-out infinite;\n          animation: dash 1.5s ease-in-out infinite;\n  stroke-linecap: round;\n  stroke: #fc1454;\n  stroke-width: 3px; }\n\n.c-icon {\n  height: 100%; }\n\n.c-icon__inline {\n  display: -webkit-inline-box;\n  display: -ms-inline-flexbox;\n  display: inline-flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  height: 100%; }\n\n.c-icon--white * {\n  fill: #FFFFFF; }\n\n.c-icon--red * {\n  fill: #d1481e; }\n\n.c-icon--gray * {\n  fill: #a5a6a5; }\n\n.c-icon--black * {\n  fill: #000000; }\n\n.c-icon--pink * {\n  fill: #fc1454; }\n\n.grid {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -ms-flex-wrap: wrap;\n      flex-wrap: wrap;\n  padding: 8px 10px; }\n\n.cell {\n  -webkit-box-sizing: border-box;\n          box-sizing: border-box;\n  padding: 8px 6px;\n  min-width: 0; }\n\n@media (min-width: 488px) {\n  .cell-md {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 2);\n            flex: 0 0 calc(100% / 2); } }\n\n@media (min-width: 620px) {\n  .cell-md {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 3);\n            flex: 0 0 calc(100% / 3); } }\n\n@media (min-width: 752px) {\n  .cell-md {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 4);\n            flex: 0 0 calc(100% / 4); } }\n\n@media (min-width: 884px) {\n  .cell-md {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 5);\n            flex: 0 0 calc(100% / 5); } }\n\n@media (min-width: 1016px) {\n  .cell-md {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 6);\n            flex: 0 0 calc(100% / 6); } }\n\n@media (min-width: 1148px) {\n  .cell-md {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 7);\n            flex: 0 0 calc(100% / 7); } }\n\n@media (min-width: 1280px) {\n  .cell-md {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 8);\n            flex: 0 0 calc(100% / 8); } }\n\n@media (min-width: 1412px) {\n  .cell-md {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 9);\n            flex: 0 0 calc(100% / 9); } }\n\n@media (min-width: 1544px) {\n  .cell-md {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 10);\n            flex: 0 0 calc(100% / 10); } }\n\n@media (min-width: 1676px) {\n  .cell-md {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 11);\n            flex: 0 0 calc(100% / 11); } }\n\n@media (min-width: 1808px) {\n  .cell-md {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 12);\n            flex: 0 0 calc(100% / 12); } }\n\n@media (min-width: 1940px) {\n  .cell-md {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 13);\n            flex: 0 0 calc(100% / 13); } }\n\n@media (min-width: 428px) {\n  .cell-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 2);\n            flex: 0 0 calc(100% / 2); } }\n\n@media (min-width: 530px) {\n  .cell-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 3);\n            flex: 0 0 calc(100% / 3); } }\n\n@media (min-width: 632px) {\n  .cell-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 4);\n            flex: 0 0 calc(100% / 4); } }\n\n@media (min-width: 734px) {\n  .cell-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 5);\n            flex: 0 0 calc(100% / 5); } }\n\n@media (min-width: 836px) {\n  .cell-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 6);\n            flex: 0 0 calc(100% / 6); } }\n\n@media (min-width: 938px) {\n  .cell-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 7);\n            flex: 0 0 calc(100% / 7); } }\n\n@media (min-width: 1040px) {\n  .cell-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 8);\n            flex: 0 0 calc(100% / 8); } }\n\n@media (min-width: 1142px) {\n  .cell-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 9);\n            flex: 0 0 calc(100% / 9); } }\n\n@media (min-width: 1244px) {\n  .cell-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 10);\n            flex: 0 0 calc(100% / 10); } }\n\n@media (min-width: 1346px) {\n  .cell-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 11);\n            flex: 0 0 calc(100% / 11); } }\n\n@media (min-width: 1448px) {\n  .cell-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 12);\n            flex: 0 0 calc(100% / 12); } }\n\n@media (min-width: 1550px) {\n  .cell-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 13);\n            flex: 0 0 calc(100% / 13); } }\n\n@media (min-width: 1652px) {\n  .cell-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 14);\n            flex: 0 0 calc(100% / 14); } }\n\n@media (min-width: 1754px) {\n  .cell-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 15);\n            flex: 0 0 calc(100% / 15); } }\n\n@media (min-width: 1856px) {\n  .cell-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 16);\n            flex: 0 0 calc(100% / 16); } }\n\n@media (min-width: 1958px) {\n  .cell-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 17);\n            flex: 0 0 calc(100% / 17); } }\n\n@media (min-width: 368px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 2);\n            flex: 0 0 calc(100% / 2); } }\n\n@media (min-width: 440px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 3);\n            flex: 0 0 calc(100% / 3); } }\n\n@media (min-width: 512px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 4);\n            flex: 0 0 calc(100% / 4); } }\n\n@media (min-width: 584px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 5);\n            flex: 0 0 calc(100% / 5); } }\n\n@media (min-width: 656px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 6);\n            flex: 0 0 calc(100% / 6); } }\n\n@media (min-width: 728px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 7);\n            flex: 0 0 calc(100% / 7); } }\n\n@media (min-width: 800px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 8);\n            flex: 0 0 calc(100% / 8); } }\n\n@media (min-width: 872px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 9);\n            flex: 0 0 calc(100% / 9); } }\n\n@media (min-width: 944px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 10);\n            flex: 0 0 calc(100% / 10); } }\n\n@media (min-width: 1016px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 11);\n            flex: 0 0 calc(100% / 11); } }\n\n@media (min-width: 1088px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 12);\n            flex: 0 0 calc(100% / 12); } }\n\n@media (min-width: 1160px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 13);\n            flex: 0 0 calc(100% / 13); } }\n\n@media (min-width: 1232px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 14);\n            flex: 0 0 calc(100% / 14); } }\n\n@media (min-width: 1304px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 15);\n            flex: 0 0 calc(100% / 15); } }\n\n@media (min-width: 1376px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 16);\n            flex: 0 0 calc(100% / 16); } }\n\n@media (min-width: 1448px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 17);\n            flex: 0 0 calc(100% / 17); } }\n\n@media (min-width: 1520px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 18);\n            flex: 0 0 calc(100% / 18); } }\n\n@media (min-width: 1592px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 19);\n            flex: 0 0 calc(100% / 19); } }\n\n@media (min-width: 1664px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 20);\n            flex: 0 0 calc(100% / 20); } }\n\n@media (min-width: 1736px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 21);\n            flex: 0 0 calc(100% / 21); } }\n\n@media (min-width: 1808px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 22);\n            flex: 0 0 calc(100% / 22); } }\n\n@media (min-width: 1880px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 23);\n            flex: 0 0 calc(100% / 23); } }\n\n@media (min-width: 1952px) {\n  .cell-xs {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 24);\n            flex: 0 0 calc(100% / 24); } }\n\n.c-search-box__strip {\n  padding: 0px 8px 8px; }\n\n.c-search-box__box {\n  position: relative;\n  color: grey; }\n  .c-search-box__box input {\n    margin: 0;\n    width: 100%;\n    text-align: left;\n    border: 0.5px solid #D0D0D0;\n    padding: 3px 5px 3px 24px;\n    line-height: 15px;\n    border-radius: 4px;\n    font-size: 13px; }\n    .c-search-box__box input:focus {\n      color: #6b6f70;\n      border: 1px solid #D0D0D0;\n      -webkit-box-shadow: 0 0 0 3px rgba(11, 128, 255, 0.3), inset 0 0 0 0.5px rgba(0, 0, 0, 0.05);\n              box-shadow: 0 0 0 3px rgba(11, 128, 255, 0.3), inset 0 0 0 0.5px rgba(0, 0, 0, 0.05); }\n\n@media (-webkit-max-device-pixel-ratio: 1.5) {\n  .c-search-box__box input {\n    border: 1px solid rgba(208, 208, 208, 0.5); } }\n\n.c-search-box__box--searching input {\n  color: #6b6f70;\n  border-color: #D0D0D0; }\n\n.c-search-box__search-icon {\n  position: absolute;\n  width: 16px;\n  left: 3px;\n  top: 3px; }\n\n.c-search-box__clear-button {\n  position: absolute;\n  right: 4px;\n  top: 3.5px; }\n\nh3, h4 {\n  -webkit-margin-before: 0px;\n  -webkit-margin-after: 0px; }\n\n.form-control {\n  display: block;\n  line-height: 1.8;\n  width: 100%;\n  margin: 0px auto;\n  border: 1px solid #E6E6E6;\n  border-radius: 3px; }\n\n.c-sign-up {\n  color: #000000;\n  height: 100vh;\n  width: 100%;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center; }\n  .c-sign-up input:focus {\n    border: 1px solid #E6E6E6; }\n\n.c-collapsible-section.has-divider {\n  border-bottom: 1px solid #dddedb; }\n\n.c-collapsible-section__title {\n  padding: 8px 12px;\n  background: -webkit-gradient(linear, left top, left bottom, from(#efefef), to(#e6e6e6));\n  background: linear-gradient(to bottom, #efefef 0%, #e6e6e6 100%);\n  margin-top: -1px;\n  border-top: 1px solid #ccc;\n  border-bottom: 1px solid #ccc;\n  color: gray;\n  font-weight: bold; }\n\n.c-collapsible-section__content {\n  background-color: #FFFFFF; }\n  .c-collapsible-section__content.is-collapsed {\n    display: none; }\n\n.c-collapsible-section__icon {\n  margin-right: 15px;\n  font-size: 22px;\n  float: left;\n  margin-top: -5px; }\n\n.c-collapsible-section__disclosure-triangle {\n  float: right;\n  margin-top: 3px; }\n\n.c-full-view {\n  height: 100vh;\n  padding: 20px; }\n\n.c-full-view__name, .c-full-view__name input {\n  font-size: 15px;\n  line-height: 18px;\n  width: 100%; }\n\n.c-full-view__description {\n  font-size: 13px;\n  line-height: 16px;\n  padding-bottom: 20px; }\n\n.c-full-view__image-preview {\n  padding: 20px;\n  width: 100%;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center;\n  background-color: #f7f7f7;\n  border: 1px solid rgba(0, 0, 0, 0.06);\n  border-radius: 4px; }\n  .c-full-view__image-preview > img {\n    max-width: 100%;\n    max-height: 100%; }\n\n.c-full-view__label {\n  text-align: right;\n  color: #bcbcbc;\n  font-size: 13px;\n  line-height: 16px; }\n\n.c-fab-button {\n  position: fixed;\n  bottom: 16px;\n  right: 16px;\n  height: 32px;\n  width: 32px;\n  border-radius: 50%;\n  background-color: #FFFFFF;\n  -webkit-box-shadow: 0 0 2px 0 rgba(0, 0, 0, 0.12), 0 2px 2px 0 rgba(0, 0, 0, 0.16);\n          box-shadow: 0 0 2px 0 rgba(0, 0, 0, 0.12), 0 2px 2px 0 rgba(0, 0, 0, 0.16);\n  padding: 4px; }\n\n.c-side-nav {\n  height: 100vh;\n  min-width: 224px;\n  width: 224px;\n  background-color: #f6f6f6; }\n\n.c-button {\n  display: inline-block;\n  text-decoration: none;\n  border-radius: 3px;\n  font-size: 11px;\n  line-height: 16px;\n  font-weight: 500;\n  font-weight: 600;\n  text-transform: uppercase; }\n\n.c-button--x-narrow {\n  min-width: 100px;\n  padding: 8px 16px; }\n\n.c-button--narrow {\n  padding: 12px 32px; }\n\n.c-button--wide {\n  padding: 13px 35px; }\n\n.c-button--secondary {\n  background-color: #f7f7f7;\n  color: rgba(0, 0, 0, 0.87);\n  border: 1px solid #d5d5d5; }\n  .c-button--secondary:hover {\n    background-color: #f2f2f2;\n    border-color: #d0d0d0; }\n  .c-button--secondary:active {\n    background-color: #f6f6f6;\n    border-color: #d5d5d5; }\n  .c-button--secondary.disabled {\n    background-color: #f7f7f7;\n    border-color: #d5d5d5;\n    color: rgba(0, 0, 0, 0.87); }\n\n.c-button--primary {\n  background-color: #121212;\n  color: #FFFFFF;\n  border: 1px solid #121212; }\n  .c-button--primary:hover {\n    color: #FFFFFF;\n    border-color: #050505; }\n  .c-button--primary:active {\n    background-color: #121212;\n    color: #FFFFFF;\n    border-color: #121212; }\n  .c-button--primary.disabled {\n    background-color: #D8D8D8;\n    border-color: #D8D8D8;\n    color: #FFFFFF; }\n\n.c-button--emphasized {\n  background-color: #d1481e;\n  color: #FFFFFF;\n  border: 1px solid #d1481e; }\n  .c-button--emphasized:hover {\n    background-color: #bb401b;\n    color: #FFFFFF;\n    border-color: #bb401b; }\n  .c-button--emphasized:active {\n    background-color: #d1481e;\n    color: #FFFFFF;\n    border-color: #d1481e; }\n  .c-button--emphasized.disabled {\n    background-color: #d1481e;\n    border-color: #d1481e;\n    color: #FFFFFF;\n    cursor: default;\n    opacity: 0.55; }\n\n.c-button--borderless {\n  border-color: transparent; }\n  .c-button--borderless:hover {\n    border-color: transparent; }\n\n/* Buttons with icons\n   ------------------ */\n.c-button__icon {\n  display: inline-block;\n  vertical-align: middle; }\n\n.c-button__text {\n  display: inline-block;\n  vertical-align: baseline;\n  margin-left: 1ex; }\n\n.c-alerts-container {\n  bottom: 8px;\n  left: 8px;\n  position: fixed; }\n\n.c-alert {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  -webkit-box-pack: justify;\n      -ms-flex-pack: justify;\n          justify-content: space-between;\n  background-color: rgba(38, 38, 38, 0.9);\n  font-size: 12px;\n  line-height: 16px;\n  color: #FFFFFF;\n  padding: 8px 10px 8px 16px;\n  border-radius: 3px;\n  opacity: 0; }\n\n.c-alert__text {\n  margin-right: 8px; }\n\n.c-alert__link {\n  font-size: 10px;\n  line-height: 16px;\n  text-align: right;\n  color: #3399ff;\n  text-transform: uppercase;\n  font-style: normal;\n  font-weight: bold;\n  margin-right: 8px; }\n\n.section-head {\n  margin: 0 18px; }\n\n.section-head__title {\n  font-size: 15px;\n  font-weight: 400;\n  color: #000000;\n  text-align: left;\n  line-height: 18px;\n  width: 90%; }\n  .section-head__title input {\n    font-size: 15px;\n    font-weight: 400;\n    color: #000000;\n    text-align: left;\n    line-height: 18px;\n    display: block;\n    width: 100%; }\n  .section-head__title.disabled {\n    color: #a5a6a6; }\n\n.section-description {\n  margin-top: 4px;\n  font-size: 11px; }\n\n.section-head__action {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-pack: justify;\n      -ms-flex-pack: justify;\n          justify-content: space-between; }\n\n.c-base-tile {\n  width: 100%;\n  background-color: #f7f7f7;\n  border: 1px solid rgba(0, 0, 0, 0.06);\n  border-radius: 4px;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center; }\n\n.c-base-tile__container {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center;\n  height: 100%;\n  width: 100%; }\n\n.c-base-tile--md {\n  height: 120px; }\n\n.c-base-tile--sm {\n  height: 90px; }\n\n.c-base-tile--xs {\n  height: 60px; }\n\n.c-base-tile--selected {\n  border: 2px solid #3399ff; }\n\n.c-base-tile__name {\n  color: rgba(0, 0, 0, 0.87);\n  background-color: #FFFFFF;\n  height: 18px;\n  padding: 3px 4px 0;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis; }\n  .c-base-tile__name, .c-base-tile__name input {\n    text-align: left;\n    font-size: 10px;\n    width: 100%; }\n\n.c-text-tile {\n  position: relative;\n  padding: 20px 14px;\n  background-color: #f7f7f7;\n  border: 1px solid rgba(0, 0, 0, 0.06);\n  border-radius: 4px; }\n\n.c-text-row {\n  padding: 12px; }\n\n.c-text-tile__sample {\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  position: relative; }\n\n.c-color-tile__preview--md {\n  width: 100%;\n  height: 100%; }\n\n.c-color-tile__preview--sm {\n  width: 32px;\n  height: 32px; }\n\n.c-color-tile__swatch {\n  height: 100%;\n  width: 100%;\n  border-radius: 4px;\n  text-align: center; }\n\n.c-color-tile__checker-background {\n  /*\n   * 8x8px checkered background for showing behind non-opaque colors.\n   * See http://lea.verou.me/css3patterns/#checkerboard\n   */\n  background-image: linear-gradient(45deg, #eee 25%, transparent 25%, transparent 75%, #eee 75%, #eee), linear-gradient(45deg, #eee 25%, transparent 25%, transparent 75%, #eee 75%, #eee);\n  background-size: 24px 24px;\n  background-position: 0 0, 12px 12px;\n  height: 100%; }\n\n.c-image-tile {\n  padding: 8px;\n  width: 100%;\n  height: 100%; }\n  .c-image-tile > img {\n    max-width: 100%;\n    max-height: 100%; }\n\n.c-text-input--no-gutter input {\n  padding: 0;\n  margin: 0; }\n\n.c-text-input--editable-tree-node {\n  width: 100%; }\n  .c-text-input--editable-tree-node input {\n    font-size: 12px;\n    height: 16px;\n    width: 100%;\n    margin-right: 6px;\n    border: 1px solid #518ccc; }\n\n.c-text-input--editable-tree-node.unselected input {\n  background-color: #f6f6f6;\n  border: none; }\n\n.c-application-header {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  -webkit-box-pack: justify;\n      -ms-flex-pack: justify;\n          justify-content: space-between;\n  padding: 0px 8px;\n  height: 28px;\n  font-size: 12px;\n  line-height: 16px;\n  text-align: start;\n  color: #939699;\n  font-style: normal;\n  font-weight: 400;\n  max-width: 224px;\n  background-color: #f6f6f6; }\n\n.c-application-menu {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  width: 92%; }\n\n.c-application-menu__title {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  margin-left: 4px;\n  margin-right: 2px;\n  max-width: 75%; }\n\n.c-native-app {\n  width: 100vw; }\n\n@media (min-width: 204px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 2);\n            flex: 0 0 calc(100% / 2); } }\n\n@media (min-width: 306px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 3);\n            flex: 0 0 calc(100% / 3); } }\n\n@media (min-width: 408px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 4);\n            flex: 0 0 calc(100% / 4); } }\n\n@media (min-width: 510px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 5);\n            flex: 0 0 calc(100% / 5); } }\n\n@media (min-width: 612px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 6);\n            flex: 0 0 calc(100% / 6); } }\n\n@media (min-width: 714px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 7);\n            flex: 0 0 calc(100% / 7); } }\n\n@media (min-width: 816px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 8);\n            flex: 0 0 calc(100% / 8); } }\n\n@media (min-width: 918px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 9);\n            flex: 0 0 calc(100% / 9); } }\n\n@media (min-width: 1020px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 10);\n            flex: 0 0 calc(100% / 10); } }\n\n@media (min-width: 1122px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 11);\n            flex: 0 0 calc(100% / 11); } }\n\n@media (min-width: 1224px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 12);\n            flex: 0 0 calc(100% / 12); } }\n\n@media (min-width: 1326px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 13);\n            flex: 0 0 calc(100% / 13); } }\n\n@media (min-width: 1428px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 14);\n            flex: 0 0 calc(100% / 14); } }\n\n@media (min-width: 1530px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 15);\n            flex: 0 0 calc(100% / 15); } }\n\n@media (min-width: 1632px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 16);\n            flex: 0 0 calc(100% / 16); } }\n\n@media (min-width: 1734px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 17);\n            flex: 0 0 calc(100% / 17); } }\n\n@media (min-width: 1836px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 18);\n            flex: 0 0 calc(100% / 18); } }\n\n@media (min-width: 1938px) {\n  .cell-native-sm {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 calc(100% / 19);\n            flex: 0 0 calc(100% / 19); } }\n\n.color-section__title {\n  color: #646462;\n  font-size: 11px;\n  font-weight: 600;\n  line-height: 22px;\n  padding: 0px 17px;\n  -webkit-box-shadow: 0 1px 0 0 #C9C9C9;\n          box-shadow: 0 1px 0 0 #C9C9C9; }\n\n.color-tile {\n  margin: 2px;\n  -webkit-box-flex: 1;\n      -ms-flex: 1 1 calc(100% / 40px);\n          flex: 1 1 calc(100% / 40px); }\n\n.color-tile--selected {\n  border: 2px solid #6C9CE4;\n  border-radius: 6px;\n  padding: 1px; }\n\n.color-tile--unselected {\n  border: 2px solid transparent;\n  border-radius: 6px;\n  padding: 1px; }\n\n.react-spinner {\n  position: relative;\n  width: 16px;\n  height: 16px; }\n\n.react-spinner_bar {\n  -webkit-animation: react-spinner_spin 1.2s linear infinite;\n  animation: react-spinner_spin 1.2s linear infinite;\n  border-radius: 5px;\n  background-color: #505050;\n  position: absolute;\n  width: 25%;\n  height: 7.8%;\n  top: 45%;\n  left: 41%; }\n\n@keyframes react-spinner_spin {\n  0% {\n    opacity: 1; }\n  100% {\n    opacity: 0.15; } }\n\n@-webkit-keyframes react-spinner_spin {\n  0% {\n    opacity: 1; }\n  100% {\n    opacity: 0.15; } }\n\n.c-inline__textarea:focus {\n  border: 1px solid transparent !important;\n  -webkit-box-shadow: none;\n          box-shadow: none;\n  outline: 0 none; }\n\n.c-inline__markdown {\n  font-size: inherit;\n  line-height: inherit;\n  padding: 3px 2px; }\n  .c-inline__markdown * {\n    -webkit-margin-before: 0;\n    -webkit-margin-after: 0; }\n\n.c-inline__markdown--placeholder {\n  color: grey; }\n\n.c-full-screen-message {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center;\n  background-color: #f6f6f6;\n  color: #000000;\n  font-size: 15px;\n  line-height: 21px;\n  text-align: center;\n  height: 100vh;\n  -webkit-box-orient: vertical;\n  -webkit-box-direction: normal;\n      -ms-flex-direction: column;\n          flex-direction: column;\n  padding: 35px; }\n\n.c-full-screen-message--light {\n  background-color: #FFFFFF; }\n\n.c-full-screen-message__content {\n  max-width: 243px; }\n\n.c-tooltip:hover {\n  position: relative; }\n\n.c-tooltip-after[data-tooltip]:hover:after {\n  content: attr(data-tooltip);\n  font-size: 12px;\n  line-height: 16px;\n  color: #FFFFFF;\n  background-color: #333335;\n  padding: 6px 8px;\n  position: absolute;\n  top: 20px;\n  white-space: nowrap;\n  z-index: 20;\n  border-radius: 3px; }\n\n.c-tooltip-left:hover:after {\n  left: 0; }\n\n.c-tooltip-right:hover:after {\n  right: 0; }\n\n.c-app-nav__header {\n  position: fixed;\n  top: 0px;\n  left: 0px;\n  height: 58px;\n  width: inherit;\n  background-color: inherit;\n  border-right: 1px solid #d5d5d5; }\n\n.c-app-nav__header-scrolling {\n  -webkit-box-shadow: 0px 2px 3px -1px rgba(0, 0, 0, 0.3);\n          box-shadow: 0px 2px 3px -1px rgba(0, 0, 0, 0.3);\n  z-index: 20; }\n\n.c-app-nav__container {\n  position: fixed;\n  top: 58px;\n  left: 0px;\n  height: calc(100vh - 58px);\n  width: inherit;\n  overflow-y: auto;\n  background-color: inherit;\n  border-right: 1px solid #d5d5d5;\n  padding-bottom: 30px; }\n\n.c-drop-target {\n  position: relative; }\n  .c-drop-target.after-clue--horizontal:after {\n    content: \"\";\n    position: absolute;\n    display: block;\n    background-color: #3399ff;\n    right: -1px;\n    top: 6%;\n    height: 86%;\n    width: 2px; }\n  .c-drop-target.before-clue--horizontal:before {\n    content: \"\";\n    position: absolute;\n    display: block;\n    background-color: #3399ff;\n    left: -1px;\n    top: 6%;\n    height: 86%;\n    width: 2px; }\n  .c-drop-target.before-clue--vertical:before {\n    content: \"\";\n    position: absolute;\n    display: block;\n    left: 0px;\n    top: -1px;\n    height: 2px;\n    background-color: #3399ff;\n    width: 100%; }\n  .c-drop-target.after-clue--vertical:after {\n    content: \"\";\n    position: absolute;\n    display: block;\n    left: 0px;\n    bottom: -1px;\n    height: 2px;\n    background-color: #3399ff;\n    width: 100%; }\n\n.c-login-screen__content {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center;\n  background-color: #f6f6f6;\n  color: #343434;\n  text-align: center;\n  height: 100vh;\n  -webkit-box-orient: vertical;\n  -webkit-box-direction: normal;\n      -ms-flex-direction: column;\n          flex-direction: column;\n  padding: 30px; }\n\n.c-login-screen__illustration {\n  width: 160px;\n  height: 87px; }\n\n.c-login-screen__headline {\n  font-size: 12px;\n  line-height: 18px;\n  margin: 16px 0 16px;\n  max-width: 265px; }\n\n.c-login-screen__button {\n  font-size: 13px;\n  height: 30px;\n  color: #FFFFFF;\n  background-color: #4e95fb;\n  border-color: #2f7def;\n  border-radius: 3px;\n  border: 1px solid;\n  text-align: center;\n  width: 100%;\n  max-width: 260px;\n  min-height: 30px; }\n\n.c-login-screen__register {\n  font-size: 11px;\n  margin-top: 14px; }\n\n.c-login-screen__register-title {\n  color: #a5a6a6; }\n\n.c-style-elements-link {\n  color: #343434; }\n\n.c-add-tree-node {\n  padding-left: 15px;\n  height: 28px;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center; }\n\n.c-add-tree-node--active {\n  background-color: #6C9CE4; }\n\n.c-add-tree-node__container {\n  padding-right: 5px;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center; }\n\n.c-add-tree-node__icon {\n  font-size: 10px; }\n\n.c-add-tree-node__text {\n  line-height: 28px;\n  color: #939699;\n  margin-left: 6px; }\n\n.c-add-tree-node__input {\n  font-size: 12px;\n  height: 16px;\n  width: 100%;\n  margin-right: 6px;\n  border: 1px solid #518ccc;\n  padding-left: 14px; }\n\n/* quill snow overrides */\n/* https://cdn.quilljs.com/1.3.6/quill.snow.css */\n.c-rich-text-editor div.c-rich-text-editor--no-toolbar .ql-editor {\n  padding-left: 0; }\n\n.c-rich-text-editor .ql-container {\n  font-family: inherit; }\n\n.c-rich-text-editor .ql-snow a {\n  color: #3399ff; }\n\n.c-rich-text-editor .ql-snow .ql-editor {\n  font-size: 14px;\n  font-weight: 300;\n  letter-spacing: 0.16px;\n  line-height: 24px;\n  /* reset inline code and code blocks */\n  /* placeholder color */ }\n  .c-rich-text-editor .ql-snow .ql-editor a {\n    text-decoration: none; }\n  .c-rich-text-editor .ql-snow .ql-editor h1, .c-rich-text-editor .ql-snow .ql-editor h2 {\n    font-weight: 600;\n    letter-spacing: -0.12px;\n    text-transform: inherit; }\n  .c-rich-text-editor .ql-snow .ql-editor h1 {\n    font-size: 1.4em; }\n  .c-rich-text-editor .ql-snow .ql-editor h2 {\n    font-size: 1em; }\n  .c-rich-text-editor .ql-snow .ql-editor pre {\n    background-color: #FFFFFF;\n    color: inherit;\n    border: 1px solid #d5d5d5;\n    border-radius: 5px; }\n  .c-rich-text-editor .ql-snow .ql-editor.ql-blank:before {\n    color: rgba(0, 0, 0, 0.38); }\n\n.c-trial-header {\n  padding: 10px 18px;\n  background-color: #f6f6f6;\n  font-size: 12px;\n  line-height: 16px;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-pack: justify;\n      -ms-flex-pack: justify;\n          justify-content: space-between;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center; }\n\n.c-trial-header__link {\n  text-transform: UPPERCASE;\n  color: #3399ff;\n  font-size: 10px;\n  font-weight: 500;\n  text-align: right; }\n\n.u-m0 {\n  margin: 0px; }\n\n.u-mt0 {\n  margin-top: 0px; }\n\n.u-mr0 {\n  margin-right: 0px; }\n\n.u-mb0 {\n  margin-bottom: 0px; }\n\n.u-ml0 {\n  margin-left: 0px; }\n\n.u-mx0 {\n  margin-left: 0px;\n  margin-right: 0px; }\n\n.u-my0 {\n  margin-top: 0px;\n  margin-bottom: 0px; }\n\n.u-p0 {\n  padding: 0px; }\n\n.u-pt0 {\n  padding-top: 0px; }\n\n.u-pr0 {\n  padding-right: 0px; }\n\n.u-pb0 {\n  padding-bottom: 0px; }\n\n.u-pl0 {\n  padding-left: 0px; }\n\n.u-px0 {\n  padding-left: 0px;\n  padding-right: 0px; }\n\n.u-py0 {\n  padding-top: 0px;\n  padding-bottom: 0px; }\n\n.u-b0 {\n  bottom: 0px; }\n\n.u-t0 {\n  top: 0px; }\n\n.u-l0 {\n  left: 0px; }\n\n.u-r0 {\n  right: 0px; }\n\n.u-m1 {\n  margin: 2px; }\n\n.u-mt1 {\n  margin-top: 2px; }\n\n.u-mr1 {\n  margin-right: 2px; }\n\n.u-mb1 {\n  margin-bottom: 2px; }\n\n.u-ml1 {\n  margin-left: 2px; }\n\n.u-mx1 {\n  margin-left: 2px;\n  margin-right: 2px; }\n\n.u-my1 {\n  margin-top: 2px;\n  margin-bottom: 2px; }\n\n.u-p1 {\n  padding: 2px; }\n\n.u-pt1 {\n  padding-top: 2px; }\n\n.u-pr1 {\n  padding-right: 2px; }\n\n.u-pb1 {\n  padding-bottom: 2px; }\n\n.u-pl1 {\n  padding-left: 2px; }\n\n.u-px1 {\n  padding-left: 2px;\n  padding-right: 2px; }\n\n.u-py1 {\n  padding-top: 2px;\n  padding-bottom: 2px; }\n\n.u-b1 {\n  bottom: 2px; }\n\n.u-t1 {\n  top: 2px; }\n\n.u-l1 {\n  left: 2px; }\n\n.u-r1 {\n  right: 2px; }\n\n.u-m2 {\n  margin: 4px; }\n\n.u-mt2 {\n  margin-top: 4px; }\n\n.u-mr2 {\n  margin-right: 4px; }\n\n.u-mb2 {\n  margin-bottom: 4px; }\n\n.u-ml2 {\n  margin-left: 4px; }\n\n.u-mx2 {\n  margin-left: 4px;\n  margin-right: 4px; }\n\n.u-my2 {\n  margin-top: 4px;\n  margin-bottom: 4px; }\n\n.u-p2 {\n  padding: 4px; }\n\n.u-pt2 {\n  padding-top: 4px; }\n\n.u-pr2 {\n  padding-right: 4px; }\n\n.u-pb2 {\n  padding-bottom: 4px; }\n\n.u-pl2 {\n  padding-left: 4px; }\n\n.u-px2 {\n  padding-left: 4px;\n  padding-right: 4px; }\n\n.u-py2 {\n  padding-top: 4px;\n  padding-bottom: 4px; }\n\n.u-b2 {\n  bottom: 4px; }\n\n.u-t2 {\n  top: 4px; }\n\n.u-l2 {\n  left: 4px; }\n\n.u-r2 {\n  right: 4px; }\n\n.u-m3 {\n  margin: 6px; }\n\n.u-mt3 {\n  margin-top: 6px; }\n\n.u-mr3 {\n  margin-right: 6px; }\n\n.u-mb3 {\n  margin-bottom: 6px; }\n\n.u-ml3 {\n  margin-left: 6px; }\n\n.u-mx3 {\n  margin-left: 6px;\n  margin-right: 6px; }\n\n.u-my3 {\n  margin-top: 6px;\n  margin-bottom: 6px; }\n\n.u-p3 {\n  padding: 6px; }\n\n.u-pt3 {\n  padding-top: 6px; }\n\n.u-pr3 {\n  padding-right: 6px; }\n\n.u-pb3 {\n  padding-bottom: 6px; }\n\n.u-pl3 {\n  padding-left: 6px; }\n\n.u-px3 {\n  padding-left: 6px;\n  padding-right: 6px; }\n\n.u-py3 {\n  padding-top: 6px;\n  padding-bottom: 6px; }\n\n.u-b3 {\n  bottom: 6px; }\n\n.u-t3 {\n  top: 6px; }\n\n.u-l3 {\n  left: 6px; }\n\n.u-r3 {\n  right: 6px; }\n\n.u-m4 {\n  margin: 8px; }\n\n.u-mt4 {\n  margin-top: 8px; }\n\n.u-mr4 {\n  margin-right: 8px; }\n\n.u-mb4 {\n  margin-bottom: 8px; }\n\n.u-ml4 {\n  margin-left: 8px; }\n\n.u-mx4 {\n  margin-left: 8px;\n  margin-right: 8px; }\n\n.u-my4 {\n  margin-top: 8px;\n  margin-bottom: 8px; }\n\n.u-p4 {\n  padding: 8px; }\n\n.u-pt4 {\n  padding-top: 8px; }\n\n.u-pr4 {\n  padding-right: 8px; }\n\n.u-pb4 {\n  padding-bottom: 8px; }\n\n.u-pl4 {\n  padding-left: 8px; }\n\n.u-px4 {\n  padding-left: 8px;\n  padding-right: 8px; }\n\n.u-py4 {\n  padding-top: 8px;\n  padding-bottom: 8px; }\n\n.u-b4 {\n  bottom: 8px; }\n\n.u-t4 {\n  top: 8px; }\n\n.u-l4 {\n  left: 8px; }\n\n.u-r4 {\n  right: 8px; }\n\n.u-m5 {\n  margin: 10px; }\n\n.u-mt5 {\n  margin-top: 10px; }\n\n.u-mr5 {\n  margin-right: 10px; }\n\n.u-mb5 {\n  margin-bottom: 10px; }\n\n.u-ml5 {\n  margin-left: 10px; }\n\n.u-mx5 {\n  margin-left: 10px;\n  margin-right: 10px; }\n\n.u-my5 {\n  margin-top: 10px;\n  margin-bottom: 10px; }\n\n.u-p5 {\n  padding: 10px; }\n\n.u-pt5 {\n  padding-top: 10px; }\n\n.u-pr5 {\n  padding-right: 10px; }\n\n.u-pb5 {\n  padding-bottom: 10px; }\n\n.u-pl5 {\n  padding-left: 10px; }\n\n.u-px5 {\n  padding-left: 10px;\n  padding-right: 10px; }\n\n.u-py5 {\n  padding-top: 10px;\n  padding-bottom: 10px; }\n\n.u-b5 {\n  bottom: 10px; }\n\n.u-t5 {\n  top: 10px; }\n\n.u-l5 {\n  left: 10px; }\n\n.u-r5 {\n  right: 10px; }\n\n.u-m6 {\n  margin: 12px; }\n\n.u-mt6 {\n  margin-top: 12px; }\n\n.u-mr6 {\n  margin-right: 12px; }\n\n.u-mb6 {\n  margin-bottom: 12px; }\n\n.u-ml6 {\n  margin-left: 12px; }\n\n.u-mx6 {\n  margin-left: 12px;\n  margin-right: 12px; }\n\n.u-my6 {\n  margin-top: 12px;\n  margin-bottom: 12px; }\n\n.u-p6 {\n  padding: 12px; }\n\n.u-pt6 {\n  padding-top: 12px; }\n\n.u-pr6 {\n  padding-right: 12px; }\n\n.u-pb6 {\n  padding-bottom: 12px; }\n\n.u-pl6 {\n  padding-left: 12px; }\n\n.u-px6 {\n  padding-left: 12px;\n  padding-right: 12px; }\n\n.u-py6 {\n  padding-top: 12px;\n  padding-bottom: 12px; }\n\n.u-b6 {\n  bottom: 12px; }\n\n.u-t6 {\n  top: 12px; }\n\n.u-l6 {\n  left: 12px; }\n\n.u-r6 {\n  right: 12px; }\n\n.u-m7 {\n  margin: 14px; }\n\n.u-mt7 {\n  margin-top: 14px; }\n\n.u-mr7 {\n  margin-right: 14px; }\n\n.u-mb7 {\n  margin-bottom: 14px; }\n\n.u-ml7 {\n  margin-left: 14px; }\n\n.u-mx7 {\n  margin-left: 14px;\n  margin-right: 14px; }\n\n.u-my7 {\n  margin-top: 14px;\n  margin-bottom: 14px; }\n\n.u-p7 {\n  padding: 14px; }\n\n.u-pt7 {\n  padding-top: 14px; }\n\n.u-pr7 {\n  padding-right: 14px; }\n\n.u-pb7 {\n  padding-bottom: 14px; }\n\n.u-pl7 {\n  padding-left: 14px; }\n\n.u-px7 {\n  padding-left: 14px;\n  padding-right: 14px; }\n\n.u-py7 {\n  padding-top: 14px;\n  padding-bottom: 14px; }\n\n.u-b7 {\n  bottom: 14px; }\n\n.u-t7 {\n  top: 14px; }\n\n.u-l7 {\n  left: 14px; }\n\n.u-r7 {\n  right: 14px; }\n\n.u-m8 {\n  margin: 16px; }\n\n.u-mt8 {\n  margin-top: 16px; }\n\n.u-mr8 {\n  margin-right: 16px; }\n\n.u-mb8 {\n  margin-bottom: 16px; }\n\n.u-ml8 {\n  margin-left: 16px; }\n\n.u-mx8 {\n  margin-left: 16px;\n  margin-right: 16px; }\n\n.u-my8 {\n  margin-top: 16px;\n  margin-bottom: 16px; }\n\n.u-p8 {\n  padding: 16px; }\n\n.u-pt8 {\n  padding-top: 16px; }\n\n.u-pr8 {\n  padding-right: 16px; }\n\n.u-pb8 {\n  padding-bottom: 16px; }\n\n.u-pl8 {\n  padding-left: 16px; }\n\n.u-px8 {\n  padding-left: 16px;\n  padding-right: 16px; }\n\n.u-py8 {\n  padding-top: 16px;\n  padding-bottom: 16px; }\n\n.u-b8 {\n  bottom: 16px; }\n\n.u-t8 {\n  top: 16px; }\n\n.u-l8 {\n  left: 16px; }\n\n.u-r8 {\n  right: 16px; }\n\n.u-m9 {\n  margin: 18px; }\n\n.u-mt9 {\n  margin-top: 18px; }\n\n.u-mr9 {\n  margin-right: 18px; }\n\n.u-mb9 {\n  margin-bottom: 18px; }\n\n.u-ml9 {\n  margin-left: 18px; }\n\n.u-mx9 {\n  margin-left: 18px;\n  margin-right: 18px; }\n\n.u-my9 {\n  margin-top: 18px;\n  margin-bottom: 18px; }\n\n.u-p9 {\n  padding: 18px; }\n\n.u-pt9 {\n  padding-top: 18px; }\n\n.u-pr9 {\n  padding-right: 18px; }\n\n.u-pb9 {\n  padding-bottom: 18px; }\n\n.u-pl9 {\n  padding-left: 18px; }\n\n.u-px9 {\n  padding-left: 18px;\n  padding-right: 18px; }\n\n.u-py9 {\n  padding-top: 18px;\n  padding-bottom: 18px; }\n\n.u-b9 {\n  bottom: 18px; }\n\n.u-t9 {\n  top: 18px; }\n\n.u-l9 {\n  left: 18px; }\n\n.u-r9 {\n  right: 18px; }\n\n.u-m10 {\n  margin: 20px; }\n\n.u-mt10 {\n  margin-top: 20px; }\n\n.u-mr10 {\n  margin-right: 20px; }\n\n.u-mb10 {\n  margin-bottom: 20px; }\n\n.u-ml10 {\n  margin-left: 20px; }\n\n.u-mx10 {\n  margin-left: 20px;\n  margin-right: 20px; }\n\n.u-my10 {\n  margin-top: 20px;\n  margin-bottom: 20px; }\n\n.u-p10 {\n  padding: 20px; }\n\n.u-pt10 {\n  padding-top: 20px; }\n\n.u-pr10 {\n  padding-right: 20px; }\n\n.u-pb10 {\n  padding-bottom: 20px; }\n\n.u-pl10 {\n  padding-left: 20px; }\n\n.u-px10 {\n  padding-left: 20px;\n  padding-right: 20px; }\n\n.u-py10 {\n  padding-top: 20px;\n  padding-bottom: 20px; }\n\n.u-b10 {\n  bottom: 20px; }\n\n.u-t10 {\n  top: 20px; }\n\n.u-l10 {\n  left: 20px; }\n\n.u-r10 {\n  right: 20px; }\n\n.u-m11 {\n  margin: 22px; }\n\n.u-mt11 {\n  margin-top: 22px; }\n\n.u-mr11 {\n  margin-right: 22px; }\n\n.u-mb11 {\n  margin-bottom: 22px; }\n\n.u-ml11 {\n  margin-left: 22px; }\n\n.u-mx11 {\n  margin-left: 22px;\n  margin-right: 22px; }\n\n.u-my11 {\n  margin-top: 22px;\n  margin-bottom: 22px; }\n\n.u-p11 {\n  padding: 22px; }\n\n.u-pt11 {\n  padding-top: 22px; }\n\n.u-pr11 {\n  padding-right: 22px; }\n\n.u-pb11 {\n  padding-bottom: 22px; }\n\n.u-pl11 {\n  padding-left: 22px; }\n\n.u-px11 {\n  padding-left: 22px;\n  padding-right: 22px; }\n\n.u-py11 {\n  padding-top: 22px;\n  padding-bottom: 22px; }\n\n.u-b11 {\n  bottom: 22px; }\n\n.u-t11 {\n  top: 22px; }\n\n.u-l11 {\n  left: 22px; }\n\n.u-r11 {\n  right: 22px; }\n\n.u-m12 {\n  margin: 24px; }\n\n.u-mt12 {\n  margin-top: 24px; }\n\n.u-mr12 {\n  margin-right: 24px; }\n\n.u-mb12 {\n  margin-bottom: 24px; }\n\n.u-ml12 {\n  margin-left: 24px; }\n\n.u-mx12 {\n  margin-left: 24px;\n  margin-right: 24px; }\n\n.u-my12 {\n  margin-top: 24px;\n  margin-bottom: 24px; }\n\n.u-p12 {\n  padding: 24px; }\n\n.u-pt12 {\n  padding-top: 24px; }\n\n.u-pr12 {\n  padding-right: 24px; }\n\n.u-pb12 {\n  padding-bottom: 24px; }\n\n.u-pl12 {\n  padding-left: 24px; }\n\n.u-px12 {\n  padding-left: 24px;\n  padding-right: 24px; }\n\n.u-py12 {\n  padding-top: 24px;\n  padding-bottom: 24px; }\n\n.u-b12 {\n  bottom: 24px; }\n\n.u-t12 {\n  top: 24px; }\n\n.u-l12 {\n  left: 24px; }\n\n.u-r12 {\n  right: 24px; }\n\n.u-m13 {\n  margin: 26px; }\n\n.u-mt13 {\n  margin-top: 26px; }\n\n.u-mr13 {\n  margin-right: 26px; }\n\n.u-mb13 {\n  margin-bottom: 26px; }\n\n.u-ml13 {\n  margin-left: 26px; }\n\n.u-mx13 {\n  margin-left: 26px;\n  margin-right: 26px; }\n\n.u-my13 {\n  margin-top: 26px;\n  margin-bottom: 26px; }\n\n.u-p13 {\n  padding: 26px; }\n\n.u-pt13 {\n  padding-top: 26px; }\n\n.u-pr13 {\n  padding-right: 26px; }\n\n.u-pb13 {\n  padding-bottom: 26px; }\n\n.u-pl13 {\n  padding-left: 26px; }\n\n.u-px13 {\n  padding-left: 26px;\n  padding-right: 26px; }\n\n.u-py13 {\n  padding-top: 26px;\n  padding-bottom: 26px; }\n\n.u-b13 {\n  bottom: 26px; }\n\n.u-t13 {\n  top: 26px; }\n\n.u-l13 {\n  left: 26px; }\n\n.u-r13 {\n  right: 26px; }\n\n.u-m14 {\n  margin: 28px; }\n\n.u-mt14 {\n  margin-top: 28px; }\n\n.u-mr14 {\n  margin-right: 28px; }\n\n.u-mb14 {\n  margin-bottom: 28px; }\n\n.u-ml14 {\n  margin-left: 28px; }\n\n.u-mx14 {\n  margin-left: 28px;\n  margin-right: 28px; }\n\n.u-my14 {\n  margin-top: 28px;\n  margin-bottom: 28px; }\n\n.u-p14 {\n  padding: 28px; }\n\n.u-pt14 {\n  padding-top: 28px; }\n\n.u-pr14 {\n  padding-right: 28px; }\n\n.u-pb14 {\n  padding-bottom: 28px; }\n\n.u-pl14 {\n  padding-left: 28px; }\n\n.u-px14 {\n  padding-left: 28px;\n  padding-right: 28px; }\n\n.u-py14 {\n  padding-top: 28px;\n  padding-bottom: 28px; }\n\n.u-b14 {\n  bottom: 28px; }\n\n.u-t14 {\n  top: 28px; }\n\n.u-l14 {\n  left: 28px; }\n\n.u-r14 {\n  right: 28px; }\n\n.u-m15 {\n  margin: 30px; }\n\n.u-mt15 {\n  margin-top: 30px; }\n\n.u-mr15 {\n  margin-right: 30px; }\n\n.u-mb15 {\n  margin-bottom: 30px; }\n\n.u-ml15 {\n  margin-left: 30px; }\n\n.u-mx15 {\n  margin-left: 30px;\n  margin-right: 30px; }\n\n.u-my15 {\n  margin-top: 30px;\n  margin-bottom: 30px; }\n\n.u-p15 {\n  padding: 30px; }\n\n.u-pt15 {\n  padding-top: 30px; }\n\n.u-pr15 {\n  padding-right: 30px; }\n\n.u-pb15 {\n  padding-bottom: 30px; }\n\n.u-pl15 {\n  padding-left: 30px; }\n\n.u-px15 {\n  padding-left: 30px;\n  padding-right: 30px; }\n\n.u-py15 {\n  padding-top: 30px;\n  padding-bottom: 30px; }\n\n.u-b15 {\n  bottom: 30px; }\n\n.u-t15 {\n  top: 30px; }\n\n.u-l15 {\n  left: 30px; }\n\n.u-r15 {\n  right: 30px; }\n\n.u-m16 {\n  margin: 32px; }\n\n.u-mt16 {\n  margin-top: 32px; }\n\n.u-mr16 {\n  margin-right: 32px; }\n\n.u-mb16 {\n  margin-bottom: 32px; }\n\n.u-ml16 {\n  margin-left: 32px; }\n\n.u-mx16 {\n  margin-left: 32px;\n  margin-right: 32px; }\n\n.u-my16 {\n  margin-top: 32px;\n  margin-bottom: 32px; }\n\n.u-p16 {\n  padding: 32px; }\n\n.u-pt16 {\n  padding-top: 32px; }\n\n.u-pr16 {\n  padding-right: 32px; }\n\n.u-pb16 {\n  padding-bottom: 32px; }\n\n.u-pl16 {\n  padding-left: 32px; }\n\n.u-px16 {\n  padding-left: 32px;\n  padding-right: 32px; }\n\n.u-py16 {\n  padding-top: 32px;\n  padding-bottom: 32px; }\n\n.u-b16 {\n  bottom: 32px; }\n\n.u-t16 {\n  top: 32px; }\n\n.u-l16 {\n  left: 32px; }\n\n.u-r16 {\n  right: 32px; }\n\n.u-m17 {\n  margin: 34px; }\n\n.u-mt17 {\n  margin-top: 34px; }\n\n.u-mr17 {\n  margin-right: 34px; }\n\n.u-mb17 {\n  margin-bottom: 34px; }\n\n.u-ml17 {\n  margin-left: 34px; }\n\n.u-mx17 {\n  margin-left: 34px;\n  margin-right: 34px; }\n\n.u-my17 {\n  margin-top: 34px;\n  margin-bottom: 34px; }\n\n.u-p17 {\n  padding: 34px; }\n\n.u-pt17 {\n  padding-top: 34px; }\n\n.u-pr17 {\n  padding-right: 34px; }\n\n.u-pb17 {\n  padding-bottom: 34px; }\n\n.u-pl17 {\n  padding-left: 34px; }\n\n.u-px17 {\n  padding-left: 34px;\n  padding-right: 34px; }\n\n.u-py17 {\n  padding-top: 34px;\n  padding-bottom: 34px; }\n\n.u-b17 {\n  bottom: 34px; }\n\n.u-t17 {\n  top: 34px; }\n\n.u-l17 {\n  left: 34px; }\n\n.u-r17 {\n  right: 34px; }\n\n.u-m18 {\n  margin: 36px; }\n\n.u-mt18 {\n  margin-top: 36px; }\n\n.u-mr18 {\n  margin-right: 36px; }\n\n.u-mb18 {\n  margin-bottom: 36px; }\n\n.u-ml18 {\n  margin-left: 36px; }\n\n.u-mx18 {\n  margin-left: 36px;\n  margin-right: 36px; }\n\n.u-my18 {\n  margin-top: 36px;\n  margin-bottom: 36px; }\n\n.u-p18 {\n  padding: 36px; }\n\n.u-pt18 {\n  padding-top: 36px; }\n\n.u-pr18 {\n  padding-right: 36px; }\n\n.u-pb18 {\n  padding-bottom: 36px; }\n\n.u-pl18 {\n  padding-left: 36px; }\n\n.u-px18 {\n  padding-left: 36px;\n  padding-right: 36px; }\n\n.u-py18 {\n  padding-top: 36px;\n  padding-bottom: 36px; }\n\n.u-b18 {\n  bottom: 36px; }\n\n.u-t18 {\n  top: 36px; }\n\n.u-l18 {\n  left: 36px; }\n\n.u-r18 {\n  right: 36px; }\n\n.u-m19 {\n  margin: 38px; }\n\n.u-mt19 {\n  margin-top: 38px; }\n\n.u-mr19 {\n  margin-right: 38px; }\n\n.u-mb19 {\n  margin-bottom: 38px; }\n\n.u-ml19 {\n  margin-left: 38px; }\n\n.u-mx19 {\n  margin-left: 38px;\n  margin-right: 38px; }\n\n.u-my19 {\n  margin-top: 38px;\n  margin-bottom: 38px; }\n\n.u-p19 {\n  padding: 38px; }\n\n.u-pt19 {\n  padding-top: 38px; }\n\n.u-pr19 {\n  padding-right: 38px; }\n\n.u-pb19 {\n  padding-bottom: 38px; }\n\n.u-pl19 {\n  padding-left: 38px; }\n\n.u-px19 {\n  padding-left: 38px;\n  padding-right: 38px; }\n\n.u-py19 {\n  padding-top: 38px;\n  padding-bottom: 38px; }\n\n.u-b19 {\n  bottom: 38px; }\n\n.u-t19 {\n  top: 38px; }\n\n.u-l19 {\n  left: 38px; }\n\n.u-r19 {\n  right: 38px; }\n\n.u-m20 {\n  margin: 40px; }\n\n.u-mt20 {\n  margin-top: 40px; }\n\n.u-mr20 {\n  margin-right: 40px; }\n\n.u-mb20 {\n  margin-bottom: 40px; }\n\n.u-ml20 {\n  margin-left: 40px; }\n\n.u-mx20 {\n  margin-left: 40px;\n  margin-right: 40px; }\n\n.u-my20 {\n  margin-top: 40px;\n  margin-bottom: 40px; }\n\n.u-p20 {\n  padding: 40px; }\n\n.u-pt20 {\n  padding-top: 40px; }\n\n.u-pr20 {\n  padding-right: 40px; }\n\n.u-pb20 {\n  padding-bottom: 40px; }\n\n.u-pl20 {\n  padding-left: 40px; }\n\n.u-px20 {\n  padding-left: 40px;\n  padding-right: 40px; }\n\n.u-py20 {\n  padding-top: 40px;\n  padding-bottom: 40px; }\n\n.u-b20 {\n  bottom: 40px; }\n\n.u-t20 {\n  top: 40px; }\n\n.u-l20 {\n  left: 40px; }\n\n.u-r20 {\n  right: 40px; }\n\n.u-small {\n  font-size: 12px; }\n\n.u-medium {\n  font-size: 13px; }\n\n.u-large {\n  font-size: 14px; }\n\n.u-xl {\n  font-size: 15px; }\n\n.u-light {\n  font-weight: 300; }\n\n.u-normal {\n  font-weight: 400; }\n\n.u-semi-bold {\n  font-weight: 600; }\n\n.u-bold {\n  font-weight: 700; }\n\n.u-italic {\n  font-style: italic; }\n\n.u-oblique {\n  font-style: oblique; }\n\n.u-text-center {\n  text-align: center; }\n\n.u-text-right {\n  text-align: right; }\n\n.u-section-border {\n  border: 1px solid #dddedb; }\n\n.u-section-border-top {\n  border-top: 1px solid #dddedb; }\n\n.u-section-border-bottom {\n  border-bottom: 1px solid #dddedb; }\n\n.u-section-border-y {\n  border-bottom: 1px solid #dddedb;\n  border-top: 1px solid #dddedb; }\n\n.u-absolute {\n  position: absolute; }\n\n.u-relative {\n  position: relative; }\n\n.u-fixed {\n  position: fixed; }\n\n.u-pull-right {\n  float: right; }\n\n.u-inline-block {\n  display: inline-block; }\n\n.u-text-overflow {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap; }\n\n.u-full-height {\n  height: 100%; }\n\n.u-full-width {\n  width: 100%; }\n\n.u-no-min-width {\n  min-width: 0; }\n\n.u-flex {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex; }\n\n.u-flex-center-viewport {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center;\n  height: 100vh; }\n\n.u-cursor-text {\n  cursor: text; }\n\n* {\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box; }\n\n*:before, *:after {\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box; }\n\nbody {\n  margin: 0;\n  font-family: 'SF UI Text', -apple-system, 'Helvetica Neue', 'Helvetica', sans-serif;\n  font-size: 13px;\n  -webkit-user-select: none;\n  cursor: default;\n  -webkit-font-smoothing: subpixel-antialiased; }\n\n.no-items-message {\n  text-align: center;\n  font-size: 25px;\n  color: #212B36;\n  font-weight: 300;\n  margin-top: -120px; }\n\n.message {\n  color: gray;\n  font-size: 15px; }\n\n.note {\n  font-size: 11px;\n  margin: 10px 10px 5px; }\n\n/* Flex layout */\n.flex {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex; }\n\n.flex-auto {\n  -webkit-box-flex: 1;\n      -ms-flex: 1 1 auto;\n          flex: 1 1 auto; }\n\n.flex-none {\n  -webkit-box-flex: 0;\n      -ms-flex: none;\n          flex: none; }\n\n.items-center {\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center; }\n\n.items-baseline {\n  -webkit-box-align: baseline;\n      -ms-flex-align: baseline;\n          align-items: baseline; }\n\n.self-start {\n  -ms-flex-item-align: start;\n      align-self: flex-start; }\n\n.self-end {\n  -ms-flex-item-align: end;\n      align-self: flex-end; }\n\n.self-center {\n  -ms-flex-item-align: center;\n      align-self: center; }\n\n.self-baseline {\n  -ms-flex-item-align: baseline;\n      align-self: baseline; }\n\n.self-stretch {\n  -ms-flex-item-align: stretch;\n      align-self: stretch; }\n\ninput {\n  font-family: inherit;\n  border: none; }\n  input:focus {\n    outline: none !important;\n    border: none; }\n\ntextarea {\n  font-family: inherit; }\n  textarea:focus {\n    font-family: inherit;\n    font-style: inherit;\n    font-weight: inherit;\n    color: inherit; }\n", ""]);

// exports


/***/ }),
/* 963 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__UserStore__ = __webpack_require__(964);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__StyleguideStore__ = __webpack_require__(983);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__NavigationStore__ = __webpack_require__(986);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__OrganizationStore__ = __webpack_require__(987);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__ApiClientStore__ = __webpack_require__(988);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__ApplicationStore__ = __webpack_require__(989);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__SearchResultsStore__ = __webpack_require__(990);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__SubscribersStore__ = __webpack_require__(991);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__AlertsStore__ = __webpack_require__(993);










/* harmony default export */ __webpack_exports__["default"] = (function () {
  return {
    UserStore: new __WEBPACK_IMPORTED_MODULE_0__UserStore__["a" /* default */](),
    OrganizationStore: new __WEBPACK_IMPORTED_MODULE_3__OrganizationStore__["a" /* default */](),
    StyleguideStore: new __WEBPACK_IMPORTED_MODULE_1__StyleguideStore__["a" /* default */](),
    NavigationStore: new __WEBPACK_IMPORTED_MODULE_2__NavigationStore__["a" /* default */](),
    ApiClientStore: new __WEBPACK_IMPORTED_MODULE_4__ApiClientStore__["a" /* default */](),
    ApplicationStore: new __WEBPACK_IMPORTED_MODULE_5__ApplicationStore__["a" /* default */](),
    SearchResultsStore: new __WEBPACK_IMPORTED_MODULE_6__SearchResultsStore__["a" /* default */](),
    SubscribersStore: new __WEBPACK_IMPORTED_MODULE_7__SubscribersStore__["a" /* default */](),
    AlertsStore: new __WEBPACK_IMPORTED_MODULE_8__AlertsStore__["a" /* default */]()
  };
});

/***/ }),
/* 964 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__brandai_fluxxor__ = __webpack_require__(25);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__brandai_fluxxor___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1__brandai_fluxxor__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__actions_actions_js__ = __webpack_require__(28);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__actions_actions_js___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2__actions_actions_js__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__sketch__ = __webpack_require__(18);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_design_systems_lib__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_design_systems_lib___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_design_systems_lib__);







var UserStore = __WEBPACK_IMPORTED_MODULE_1__brandai_fluxxor___default.a.createStore({
  initialize: function initialize() {

    this.init();

    this