sketchApi.login = function(serviceType, email, password, callback) {
  var callbackID = this.registerCallback(callback);
  SketchApi.getty$_loginWithServiceType_email_password_callbackID_(serviceType, email, password, callbackID);
}

sketchApi.isLoggedIn = function(serviceType) {
  return SketchApi.getty$_isLoggedInWithServiceType_(serviceType);
}

sketchApi.logout = function(serviceType) {
  SketchApi.getty$_logoutWithServiceType_(serviceType);
}

sketchApi.getImages = function(serviceType, type, page, search, callback) {
  var callbackID = this.registerCallback(callback);
  SketchApi.getty$_getImagesWithServiceType_type_page_search_callbackID_(serviceType, type, page, search, callbackID);
}

sketchApi.getUsedImages = function(serviceType, callback) {
  var callbackID = this.registerCallback(callback);
  SketchApi.getty$_getUsedImagesWithServiceType_callbackID_(serviceType, callbackID);
}

sketchApi.getImageData = function(serviceType, imageId, callback) {
  if (typeof imageId !== 'string') {
    imageId = String(imageId);
  }

  var callbackID = this.registerCallback(callback);
  SketchApi.getty$_getImageWithServiceType_imageId_callbackID_(serviceType, imageId, callbackID);
}

sketchApi.placeImage = function(serviceType, imageId, url, callback) {
  var callbackID = this.registerCallback(callback);
  SketchApi.getty$_placeImageWithServiceType_imageId_url_callbackID_(serviceType, imageId, url, callbackID);
}

sketchApi.downloadImage = function(serviceType, imageId, productType, height, callback) {
  if (typeof imageId !== 'string') {
    imageId = String(imageId);
  }

  if (!height) {
    height = -1;
  }

  if (typeof callback !== 'function') {
    callback = function() {};
  }

  var callbackID = this.registerCallback(callback);

  SketchApi.getty$_downloadImageWithServiceType_imageId_productType_height_callbackID_(serviceType, imageId, productType, height, callbackID);
}

sketchApi.registerNotificationHandler = function() {
  SketchApi.getty$_registerNotificationsHandler();
}

sketchApi.getUserProducts = function(serviceType, callback) {
  var callbackID = this.registerCallback(callback);
  SketchApi.getty$_getUserProductsWithServiceType_callbackID_(serviceType, callbackID);
}
