//
//  ICLibraryIndex.h
//  LibrarySync
//
//  Created by Tomáš Hanáček on 6/26/17.
//  Copyright © 2017 InVisionApp Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ICLibraryIndexFile.h"
#import "ICLibraryIndexConflict.h"

@interface ICLibraryIndex : NSObject

- (id)initWithLibraryPath:(NSString *)libraryPath error:(NSError **)error;

- (void)addFile:(ICLibraryIndexFile *)indexFile;
- (void)addOrUpdateFileAtPath:(NSString *)filePath;
- (void)addOrUpdateFileWithSnapshotAtPath:(NSString *)filePath;
- (void)removeFileAtPath:(NSString *)filePath;
- (ICLibraryIndexFile *)fileFromPath:(NSString *)filePath;
- (void)enumerateFilesUsingBlock:(void (^)(NSString *filePath, ICLibraryIndexFile *indexFile, BOOL *stop))block;
- (void)resolveConflict:(ICLibraryIndexConflict *)conflict;
- (void)resolveConflictWithSnapshot:(ICLibraryIndexConflict *)conflict;

- (NSArray *)filesPaths;

- (void)saveIndex;

- (NSDictionary *)dumpTree;
- (NSString *)dumpTreeToJSONString;
- (void)dump;

@end
