//
//  ICLibraryIndexFile.h
//  LibrarySync
//
//  Created by Tomáš Hanáček on 6/26/17.
//  Copyright © 2017 InVisionApp Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface ICLibraryIndexFile : NSObject

@property (nonatomic) BOOL hasConflict;
@property (nonatomic, readonly, getter=isRemoved) BOOL removed;

- (id)initWithLibraryPath:(NSString *)libraryPath filePath:(NSString *)filePath;
- (id)initWithLibraryPath:(NSString *)libraryPath filePath:(NSString *)filePath data:(NSDictionary *)data;
- (id)initWithLibraryPath:(NSString *)libraryPath indexFile:(ICLibraryIndexFile *)indexFile;
- (NSString *)filePath;
- (NSString *)absolutePath;
- (NSString *)snapshotPath;

- (void)calculateChecksum;
- (NSString *)checksum;
- (NSString *)parent;
- (NSArray *)parents;

- (NSData *)data;
- (void)makeSnapshot;
- (void)markAsRemoved;
- (NSString *)snapshotForChecksum:(NSString *)checksum;
- (void)resolveConflictWithRemoteFile:(ICLibraryIndexFile *)remoteFile;
- (void)resolveConflictWithRemoteFile:(ICLibraryIndexFile *)remoteFile withSnapshot:(BOOL)withSnapshot;

- (void)updateFromIndexFile:(ICLibraryIndexFile *)indexFile;
- (BOOL)updateOnFilesystemFromIndexFile:(ICLibraryIndexFile *)indexFile;

- (NSDictionary *)serialize;

@end
