/*
 * Decompiled with CFR 0.152.
 */
package c4.culinaryconstruct.client.model;

import c4.culinaryconstruct.common.util.NBTHelper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public final class ModelSandwich
implements IModel {
    public static final ModelResourceLocation LOCATION = new ModelResourceLocation(new ResourceLocation("culinaryconstruct", "sandwich"), "inventory");
    public static final IModel MODEL = new ModelSandwich();
    @Nullable
    private final List<TextureAtlasSprite> ingredientSprites;
    @Nullable
    private final List<Integer> layers;
    private final int size;

    public ModelSandwich() {
        this(null, null);
    }

    public ModelSandwich(@Nullable List<TextureAtlasSprite> ingredients, @Nullable List<Integer> layers) {
        this.ingredientSprites = ingredients;
        this.layers = layers;
        this.size = ingredients == null ? 0 : ingredients.size() - 1;
    }

    @Nonnull
    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.ingredientSprites != null && this.layers != null) {
            builder.add((Object)new ResourceLocation("culinaryconstruct", "items/bread" + this.size));
            for (TextureAtlasSprite sprite : this.ingredientSprites) {
                builder.add((Object)new ResourceLocation(sprite.func_94215_i()));
            }
            Iterator<Object> iterator = this.layers.iterator();
            while (iterator.hasNext()) {
                int layer = (Integer)iterator.next();
                builder.add((Object)new ResourceLocation("culinaryconstruct", "items/layer" + layer));
            }
        }
        return builder.build();
    }

    @Nonnull
    public IBakedModel bake(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        IBakedModel model = new ItemLayerModel(ImmutableList.of((Object)new ResourceLocation("culinaryconstruct", "items/bread" + this.size))).bake(state, format, bakedTextureGetter);
        builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        TextureAtlasSprite particleSprite = model.func_177554_e();
        if (this.ingredientSprites != null && this.layers != null) {
            for (int i = 0; i < this.ingredientSprites.size(); ++i) {
                IBakedModel model1 = new ItemLayerModel(ImmutableList.of((Object)new ResourceLocation("culinaryconstruct", "items/layer" + this.layers.get(i)))).bake(state, format, bakedTextureGetter);
                List quads = model1.func_188616_a(null, null, 0L);
                for (BakedQuad quad : quads) {
                    ColorTransformer transformer = new ColorTransformer(this.getAverageColorFromSprite(this.ingredientSprites.get(i)), quad.getFormat());
                    quad.pipe((IVertexConsumer)transformer);
                    builder.add((Object)transformer.build());
                }
            }
        }
        return new BakedSandwichModel((ImmutableList<BakedQuad>)builder.build(), particleSprite, format);
    }

    private int getAverageColorFromSprite(TextureAtlasSprite sprite) {
        int[] largestMipMapTextureData;
        int iconWidth = sprite.func_94211_a();
        int iconHeight = sprite.func_94216_b();
        int frameCount = sprite.func_110970_k();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return 0xFFFFFF;
        }
        int rBucket = 0;
        int gBucket = 0;
        int bBucket = 0;
        int passes = 0;
        int[][] frameTextureData = sprite.func_147965_a(0);
        for (int j : largestMipMapTextureData = frameTextureData[0]) {
            if (j == 0) continue;
            Color color = new Color(j);
            color.brighter();
            rBucket += color.getRed();
            gBucket += color.getGreen();
            bBucket += color.getBlue();
            ++passes;
        }
        return new Color(rBucket /= passes, gBucket /= passes, bBucket /= passes).getRGB();
    }

    private static class ColorTransformer
    extends VertexTransformer {
        private final float r;
        private final float g;
        private final float b;
        private final float a;

        public ColorTransformer(int color, VertexFormat format) {
            super((IVertexConsumer)new UnpackedBakedQuad.Builder(format));
            int a = color >> 24;
            if (a == 0) {
                a = 255;
            }
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            this.r = (float)r / 255.0f;
            this.g = (float)g / 255.0f;
            this.b = (float)b / 255.0f;
            this.a = (float)a / 255.0f;
        }

        public void put(int element, float ... data) {
            VertexFormatElement.EnumUsage usage = this.parent.getVertexFormat().func_177348_c(element).func_177375_c();
            if (usage == VertexFormatElement.EnumUsage.COLOR && data.length >= 4) {
                data[0] = this.r;
                data[1] = this.g;
                data[2] = this.b;
                data[3] = this.a;
            }
            super.put(element, data);
        }

        public UnpackedBakedQuad build() {
            return ((UnpackedBakedQuad.Builder)this.parent).build();
        }
    }

    protected static class CacheKey {
        final IBakedModel parent;
        final NBTTagCompound data;

        CacheKey(IBakedModel parent, ItemStack stack) {
            this.parent = parent;
            this.data = NBTHelper.getCompoundSafe(stack);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.parent != null ? this.parent != cacheKey.parent : cacheKey.parent != null) {
                return false;
            }
            return this.data != null ? this.data.equals((Object)cacheKey.data) : cacheKey.data == null;
        }

        public int hashCode() {
            int result = this.parent != null ? this.parent.hashCode() : 0;
            result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
            return result;
        }
    }

    private static final class BakedSandwichModel
    implements IBakedModel {
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final ImmutableList<BakedQuad> quads;
        private final TextureAtlasSprite particle;
        private final VertexFormat format;
        private static final TRSRTransformation flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);

        public BakedSandwichModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format) {
            this.quads = quads;
            this.particle = particle;
            this.format = format;
            this.transforms = BakedSandwichModel.itemTransforms();
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return BakedSandwichItemOverrideHandler.INSTANCE;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> itemTransforms() {
            TRSRTransformation thirdperson = BakedSandwichModel.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
            TRSRTransformation firstperson = BakedSandwichModel.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)BakedSandwichModel.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
            builder.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)BakedSandwichModel.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdperson);
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)BakedSandwichModel.leftify(thirdperson));
            builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)firstperson);
            builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)BakedSandwichModel.leftify(firstperson));
            return builder.build();
        }

        private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
            return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null));
        }

        private static TRSRTransformation leftify(TRSRTransformation transform) {
            return TRSRTransformation.blockCenterToCorner((TRSRTransformation)flipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform)).compose(flipX));
        }

        @Nonnull
        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }
    }

    private static final class BakedSandwichItemOverrideHandler
    extends ItemOverrideList {
        private Cache<CacheKey, IBakedModel> bakedModelCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
        public static final BakedSandwichItemOverrideHandler INSTANCE = new BakedSandwichItemOverrideHandler();

        private BakedSandwichItemOverrideHandler() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            NBTTagCompound data = NBTHelper.getCompoundSafe(stack);
            IBakedModel output = originalModel;
            if (!data.func_82582_d()) {
                BakedSandwichModel original = (BakedSandwichModel)originalModel;
                CacheKey key = this.getCacheKey(stack, original);
                try {
                    output = (IBakedModel)this.bakedModelCache.get((Object)key, () -> this.getBakedModel(stack, original));
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            return output;
        }

        protected IBakedModel getBakedModel(ItemStack stack, BakedSandwichModel original) {
            ImmutableList.Builder builder = ImmutableList.builder();
            NonNullList<ItemStack> ingredients = NBTHelper.getIngredientsList(stack, false);
            for (ItemStack ing : ingredients) {
                builder.add((Object)Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(ing).func_177554_e());
            }
            int size = NBTHelper.getSize(stack);
            ArrayList<Integer> list = new ArrayList<Integer>();
            switch (size) {
                case 1: {
                    list.add(2);
                    break;
                }
                case 2: {
                    list.addAll(Arrays.asList(1, 2));
                    break;
                }
                case 3: {
                    list.addAll(Arrays.asList(1, 2, 3));
                    break;
                }
                case 4: {
                    list.addAll(Arrays.asList(0, 1, 2, 3));
                    break;
                }
                case 5: {
                    list.addAll(Arrays.asList(0, 1, 2, 3, 4));
                }
            }
            ModelSandwich parent = new ModelSandwich((List<TextureAtlasSprite>)builder.build(), list);
            Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
            return parent.bake((IModelState)new SimpleModelState(original.transforms), original.format, textureGetter);
        }

        CacheKey getCacheKey(ItemStack stack, BakedSandwichModel original) {
            return new CacheKey(original, stack);
        }
    }

    public static enum LoaderSandwich implements ICustomModelLoader
    {
        INSTANCE;


        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("culinaryconstruct") && modelLocation.func_110623_a().contains("sandwich") && !modelLocation.func_110623_a().contains("station");
        }

        @Nonnull
        public IModel loadModel(@Nonnull ResourceLocation modelLocation) {
            return MODEL;
        }

        public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        }
    }
}

