/*
 * Decompiled with CFR 0.152.
 */
package c4.culinaryconstruct.common.inventory;

import c4.culinaryconstruct.common.item.ItemSandwich;
import c4.culinaryconstruct.common.tileentity.TileEntitySandwichStation;
import c4.culinaryconstruct.common.util.BreadHelper;
import c4.culinaryconstruct.common.util.NBTHelper;
import c4.culinaryconstruct.proxy.CommonProxy;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.StringUtils;

public class ContainerSandwichStation
extends Container {
    private final InventoryCraftResult outputSlot = new InventoryCraftResult();
    private final IInventory ingredientSlots = new InventoryBasic("Ingredients", true, 6){

        public void func_70296_d() {
            super.func_70296_d();
            ContainerSandwichStation.this.func_75130_a((IInventory)this);
        }
    };
    private final BlockPos pos;
    private final World world;
    private String sandwichName;
    private TileEntitySandwichStation sandwichStation;

    public ContainerSandwichStation(InventoryPlayer playerInventory, World world, BlockPos pos, TileEntitySandwichStation te) {
        this.pos = pos;
        this.world = world;
        this.sandwichStation = te;
        this.initSlots(playerInventory);
        this.initInventory();
    }

    private void initInventory() {
        IItemHandler inventory = (IItemHandler)this.sandwichStation.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH);
        if (inventory != null) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                ((Slot)this.field_75151_b.get(i)).func_75215_d(inventory.extractItem(i, stack.func_190916_E(), false));
            }
        }
    }

    private void initSlots(InventoryPlayer playerInventory) {
        this.addLayerSlots();
        this.func_75146_a(new SlotBread(this.ingredientSlots, 5, 10, 50));
        this.func_75146_a(new SlotSandwich((IInventory)this.outputSlot, 6, 150, 50));
        this.addPlayerSlots(playerInventory);
    }

    private void addLayerSlots() {
        for (int i = 0; i < 5; ++i) {
            this.func_75146_a(new SlotLayeredIngredient(this.ingredientSlots, i, 30 + i * 18, 50));
        }
    }

    private void addPlayerSlots(InventoryPlayer playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, 8 + col * 18, 79 + row * 18));
            }
        }
        for (int hotbar = 0; hotbar < 9; ++hotbar) {
            this.func_75146_a(new Slot((IInventory)playerInventory, hotbar, 8 + hotbar * 18, 137));
        }
    }

    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        return this.world.func_180495_p(this.pos).func_177230_c() == CommonProxy.sandwichStation && playerIn.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!this.world.field_72995_K) {
            this.func_193327_a(playerIn, this.world, this.ingredientSlots);
        }
    }

    protected void func_193327_a(EntityPlayer playerIn, @Nonnull World worldIn, IInventory inventoryIn) {
        IItemHandler inventory = (IItemHandler)this.sandwichStation.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH);
        if (inventory != null) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                inventory.insertItem(i, inventoryIn.func_70304_b(i), false);
            }
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        super.func_75130_a(inventoryIn);
        if (inventoryIn == this.ingredientSlots) {
            this.updateSandwichOutput();
        }
    }

    public void updateSandwichOutput() {
        ItemFood food;
        ItemStack bread = this.ingredientSlots.func_70301_a(5);
        if (bread.func_190926_b()) {
            this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
            return;
        }
        NonNullList ingredientsList = NonNullList.func_191196_a();
        int totalFood = 0;
        float totalSaturation = 0.0f;
        int complexity = 0;
        for (int i = 0; i < this.ingredientSlots.func_70302_i_(); ++i) {
            ItemStack copy;
            ItemStack stack = this.ingredientSlots.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (!(stack.func_77973_b() instanceof ItemFood)) {
                this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
                return;
            }
            food = (ItemFood)stack.func_77973_b();
            totalFood += food.func_150905_g(stack);
            boolean flag = true;
            for (ItemStack existing : ingredientsList) {
                if (existing.func_190926_b() || existing.func_77973_b() != stack.func_77973_b() || stack.func_77981_g() && stack.func_77960_j() != existing.func_77960_j() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existing)) continue;
                flag = false;
                break;
            }
            if (flag && !BreadHelper.isValidBread(stack)) {
                ++complexity;
            }
            if ((copy = stack.func_77946_l()).func_190916_E() > 1) {
                copy.func_190920_e(1);
            }
            ingredientsList.add((Object)copy);
        }
        for (ItemStack stack : ingredientsList) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemFood)) continue;
            food = (ItemFood)stack.func_77973_b();
            double proportion = (double)food.func_150905_g(stack) / (double)totalFood;
            totalSaturation = (float)((double)totalSaturation + proportion * (double)food.func_150906_h(stack));
        }
        if (ingredientsList.size() <= 1 || totalFood <= 0 || totalSaturation < 0.0f) {
            this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
            return;
        }
        double count = 1.0;
        int averageFood = MathHelper.func_76143_f((double)((double)totalFood / count));
        while (averageFood > 10) {
            averageFood = MathHelper.func_76143_f((double)((double)totalFood / (count += 1.0)));
        }
        int size = ingredientsList.size() - 1;
        int bonus = MathHelper.func_76125_a((int)(complexity - (size / 2 + 1)), (int)-2, (int)2);
        ItemStack output = new ItemStack((Item)CommonProxy.sandwich);
        NBTHelper.setTagSize(output, size);
        NBTHelper.setIngredientsList(output, (NonNullList<ItemStack>)ingredientsList);
        NBTHelper.setTagFood(output, averageFood);
        NBTHelper.setTagSaturation(output, totalSaturation *= 1.0f + (float)bonus * 0.2f);
        NBTHelper.setTagBonus(output, bonus);
        if (StringUtils.isBlank((CharSequence)this.sandwichName)) {
            output.func_135074_t();
        } else if (!this.sandwichName.equals(output.func_82833_r())) {
            output.func_151001_c(this.sandwichName);
        }
        output.func_190920_e((int)count);
        this.outputSlot.func_70299_a(0, output);
        this.func_75142_b();
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 6) {
                if (!this.func_75135_a(itemstack1, 7, 43, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= 7 ? index < 43 && !this.func_75135_a(itemstack1, 5, 6, false) && !this.func_75135_a(itemstack1, 0, 5, false) : !this.func_75135_a(itemstack1, 7, 43, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void updateSandwichName(String newName) {
        this.sandwichName = newName;
        this.updateSandwichOutput();
    }

    private class SlotSandwich
    extends Slot {
        public SlotSandwich(IInventory iInventoryIn, int index, int xPosition, int yPosition) {
            super(iInventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        @Nonnull
        public ItemStack func_190901_a(EntityPlayer thePlayer, @Nonnull ItemStack stack) {
            IInventory ingredients = ContainerSandwichStation.this.ingredientSlots;
            for (int i = 0; i < ingredients.func_70302_i_(); ++i) {
                ItemStack slot = ingredients.func_70301_a(i);
                slot.func_190918_g(1);
                if (!slot.func_190926_b()) continue;
                ingredients.func_70299_a(i, ItemStack.field_190927_a);
            }
            ContainerSandwichStation.this.updateSandwichOutput();
            return stack;
        }
    }

    private class SlotLayeredIngredient
    extends Slot {
        public SlotLayeredIngredient(IInventory iInventoryIn, int index, int xPosition, int yPosition) {
            super(iInventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemFood && !(stack.func_77973_b() instanceof ItemSandwich);
        }
    }

    private class SlotBread
    extends Slot {
        public SlotBread(IInventory iInventoryIn, int index, int xPosition, int yPosition) {
            super(iInventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return BreadHelper.isValidBread(stack);
        }
    }
}

