/*
 * Decompiled with CFR 0.152.
 */
package c4.culinaryconstruct.common.item;

import c4.culinaryconstruct.CulinaryConstruct;
import c4.culinaryconstruct.client.model.ModelSandwich;
import c4.culinaryconstruct.common.util.NBTHelper;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Keyboard;

public class ItemSandwich
extends ItemFood {
    private static final Method ON_FOOD_EATEN = ReflectionHelper.findMethod(ItemFood.class, (String)"onFoodEaten", (String)"func_77849_c", (Class[])new Class[]{ItemStack.class, World.class, EntityPlayer.class});

    public ItemSandwich() {
        super(0, false);
        this.setRegistryName("sandwich");
        this.func_77655_b("culinaryconstruct.sandwich");
        this.func_77637_a(CreativeTabs.field_78039_h);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> ModelSandwich.LOCATION);
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ModelSandwich.LOCATION});
    }

    public int func_150905_g(ItemStack stack) {
        return NBTHelper.getFoodAmount(stack);
    }

    public float func_150906_h(ItemStack stack) {
        return NBTHelper.getSaturationModifier(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NonNullList<ItemStack> ingredients = NBTHelper.getIngredientsList(stack, true);
        int bonus = NBTHelper.getBonus(stack);
        tooltip.add(String.format("%s: %s", I18n.func_135052_a((String)"tooltip.culinaryconstruct.quality.name", (Object[])new Object[0]), I18n.func_135052_a((String)("tooltip.culinaryconstruct.quality." + (bonus + 2)), (Object[])new Object[0])));
        tooltip.add("");
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"tooltip.culinaryconstruct.ingredients.name", (Object[])new Object[0]));
            for (ItemStack ing : ingredients) {
                if (ing.func_190926_b()) continue;
                tooltip.add("- " + ing.func_82833_r());
            }
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.culinaryconstruct.ingredients", (Object[])new Object[0]));
        }
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack sub = new ItemStack((Item)this);
            NBTHelper.setTagSize(sub, 5);
            NBTHelper.setIngredientsList(sub, (NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack(Items.field_151156_bN), new ItemStack(Items.field_151156_bN), new ItemStack(Items.field_151156_bN), new ItemStack(Items.field_151156_bN), new ItemStack(Items.field_151156_bN), new ItemStack(Items.field_151025_P)}));
            NBTHelper.setTagFood(sub, 20);
            NBTHelper.setTagSaturation(sub, 1.0f);
            NBTHelper.setTagBonus(sub, 2);
            items.add((Object)sub);
        }
    }

    protected void func_77849_c(ItemStack stack, World worldIn, @Nonnull EntityPlayer player) {
        if (!worldIn.field_72995_K) {
            NonNullList<ItemStack> ingredients = NBTHelper.getIngredientsList(stack, true);
            for (ItemStack ing : ingredients) {
                if (ing.func_190926_b() || !(ing.func_77973_b() instanceof ItemFood)) continue;
                try {
                    ItemFood foodItem = (ItemFood)ing.func_77973_b();
                    ON_FOOD_EATEN.invoke((Object)foodItem, ing, worldIn, player);
                }
                catch (Exception e) {
                    CulinaryConstruct.logger.log(Level.ERROR, "Error invoking onFoodEaten for stack " + ing.toString());
                }
            }
        }
    }
}

