/* 
 * v5 版影音中控
 * Author: Qian Youshi
 */

/*@cc_on
  // conditional IE <= 9 only fix
  @if (@_jscript_version < 10)
  (function(f){
     window.setTimeout =f(window.setTimeout);
     window.setInterval =f(window.setInterval);
  })(function(f){return function(c,t){var a=[].slice.call(arguments,2);return f(function(){c.apply(this,a)},t)}});
  @end
@*/
var DEBUG = false;           // debug 开关
var PARA_NUM = 40;          // 电视剧每40集分一段
var PARA_ARTS = 5;          // 综艺节目需要分段阈值
var SCROLLBAR_MIN_HEIGHT = 20;    // 滚动条最小高度
var FETCH_CHILD_NUM = 200;  // 加载子节点个数

// 本地页面，不加载g.js，定义一些必要的工具函数
if(typeof sohuHD === 'undefined') sohuHD = {};

sohuHD.json=function(value){
	if(typeof value==="string"){
		return this.json.toObject(value);
	}else{
		return this.json.toJSON(value);
	}
}
sohuHD.json.toJSON=function(object){
	var type = typeof object;
	if ('object' == type) {
		if (Array == object.constructor) type = 'array';
		else if (RegExp == object.constructor) type = 'regexp';
		else type = 'object';
	}
	switch (type) {
		case 'undefined':
		case 'unknown':
			return;
		break;
		case 'function':
		case 'boolean':
		case 'regexp':
			return object.toString();
		break;
		case 'number':
			return isFinite(object) ? object.toString() : 'null';
		break;
		case 'string':
			return '"' + object.replace(/(\\|\")/g, "\\$1").replace(/\n|\r|\t/g, function() {
				var a = arguments[0];
				return (a == '\n') ? '\\n': (a == '\r') ? '\\r': (a == '\t') ? '\\t': ""
			}) + '"';
		break;
		case 'object':
			if (object === null) 
				return 'null';
			var results = [];
			for (var property in object) {
				var value = this.toJSON(object[property]);
				if (value !== undefined) 
					results.push(this.toJSON(property) + ':' + value);
			}
			return '{' + results.join(',') + '}';
		break;
		case 'array':
			var results = [];
			for (var i = 0; i < object.length; i++) {
				var value = this.toJSON(object[i]);
				if (value !== undefined) 
					results.push(value);
			}
			return '[' + results.join(',') + ']';
		break;
	}
}
sohuHD.json.toObject=function(strjson){
	return eval("(" + strjson + ")");
}

sohuHD.getUrlParam = function (obj, strParamName) {
    //obj : 获取参数的对象(a , img , document时获取location.href)
    //strParamName : 参数名
    var getQueryStrByName = function (val, name) {
        var result = val.match(new RegExp("[?&]" + name + "=([^&]+)", "i"));
        if (result == null || result.length < 1) {
            return "";
        }
        return result[1];
    };

    strParamName = escape(unescape(strParamName));
    if (Object.prototype.toString.call(obj) == '[object String]') {
        return getQueryStrByName(obj, strParamName);
    } else if (obj.nodeName == '#document') {
        return getQueryStrByName(location.search || '', strParamName);
    } else if (typeof obj.src != 'undefined') {
        return getQueryStrByName(obj.src, strParamName);
    } else if (typeof obj.href != 'undefined') {
        return getQueryStrByName(obj.href, strParamName);
    } else {
        return null;
    }
};

sohuHD.IfoxLog = function(error) {
    try {
        window.external.WriteWebLog(error.message);
    } catch(err) {
        if (window.console != undefined && window.console.log) {
            window.console.log(error.message);
        }
    }
};

// Array.prototype.indexOf
(function () {
    if (!Array.prototype.indexOf) {
        Array.prototype.indexOf = function (searchElement, fromIndex) {
            if ( this === undefined || this === null ) {
                throw new TypeError( '"this" is null or not defined' );
            }    

            var length = this.length >>> 0; // Hack to convert object.length to a UInt32

            fromIndex = +fromIndex || 0;

            if (Math.abs(fromIndex) === Infinity) {
                fromIndex = 0; 
            }    

            if (fromIndex < 0) { 
                fromIndex += length;
                if (fromIndex < 0) { 
                    fromIndex = 0; 
                }    
            }    

            for (;fromIndex < length; fromIndex++) {
                if (this[fromIndex] === searchElement) {
                    return fromIndex;
                }    
            }    

            return -1;
        };   
    } 
})();

// 通过URL参数指定背景色，尽快加载
var theme = sohuHD.getUrlParam(document.location, 'theme') || 'white';
var supportThemes = ['black', 'white'];
if (supportThemes.indexOf(theme) > -1) {
    $('html').addClass(theme);
}

if (DEBUG) { 
    var EXTERNAL = window.test;

    $(document).on('keydown', function(event) {
        if (49 == event.keyCode) {
            ScrollToTop();
        } else if (50 == event.keyCode) {
            UnfoldAll();
        }
    });
} else {
    EXTERNAL = window.external;
}

//log prefix，id自增
var getCount = (function() {
    var count = 1;
    return function() {
        return 'WebLog NO.' + count++ + ':';
    };
})();

var Util = {
    TimeoutSet : {},
    GetMenu : function(ele) {
        var menu = $('#context-menu');
        if (menu.parent()[0] == ele.parent().parent()[0]) {
            return;
        }
        var paddingLeft = parseInt(ele.css('padding-left'));
        paddingLeft += parseInt(ele.parent().css('padding-left')) + 3;

        var handlers = [
            function(event) {
                EXTERNAL.ConsoleDownloadVideo(event.data);
                log(event.data);
            },
            function(event) {
                try{
                    var data = sohuHD.json(event.data);
                    var pos = Util.getPosition(this);
                    // 传给影音关注按钮的在当前屏幕中坐标
                    data.pointx = pos.screenX + 19;
                    data.pointy = pos.screenY;
                    var params = sohuHD.json.toJSON(data);
                } catch (e) {
                    params = event.data;
                }
                EXTERNAL.ConsoleAttention(params);
                log(params);
            },
            function(event) {
                EXTERNAL.ConsolePutOnDesktop(event.data);
                log(event.data);
            },
            function(event) {
                EXTERNAL.ConsoleShowDetailPage(event.data);
                log(event.data);
            }
        ];

        var id = parseInt(ele.attr('data-id'));
        var eventData = sohuHD.json.toJSON({
            "id":id,
            "idtype":parseInt(ele.attr('data-idtype')),
            "parentid":parseInt(ele.attr('data-parentid')),
            "parentidtype":parseInt(ele.attr('data-parentidtype'))
        });

        var classes = ['btn-download', 'btn-fav', 'btn-desk', 'btn-detail'];
        var allowDatas = ['data-allowdownload', 'data-allowattent', 'data-allowput', 'data-allowdetail'];

        if (menu.length) {
            menu.children('span').css('left', paddingLeft);
            var btns = menu.find('a');
            for (var i = 0; i < btns.length; i++) {
                if ($.isFunction(handlers[i])) {
                    $(btns[i]).unbind('click').click(eventData, handlers[i]);
                }
                if (allowDatas[i]) {        // 有些节点禁用下载和详情按钮
                    if (ele.attr(allowDatas[i]) == '0') {
                        $(btns[i]).addClass(classes[i] + '-dis');
                        $(btns[i]).unbind('click');
                    } else {
                        $(btns[i]).removeClass(classes[i] + '-dis');
                    }
                }
            }
            menu.children('div.ln-selBox').remove();
            menu.children('#album-list').remove();
            menu.parent().removeClass('unfold-s1 unfold-s2 unfold-s3');
        } else {
            menu = $('<div></div>');
            menu.attr('id', 'context-menu');
            menu.addClass('ln-con fold-s3');
            var span = $('<span></span>');
            span.addClass('arr');
            span.css('left', paddingLeft);
            var nestedDiv = $('<div></<div>');
            nestedDiv.addClass('ln-btn cfix');
            for(var i = 0; i < 4; i++) {
                var a = $('<a></a>');
                a.addClass(classes[i]);
                if ($.isFunction(handlers[i])) {
                    a.click(eventData, handlers[i]);
                }
                if (allowDatas[i]) {        // 有些节点禁用下载和详情按钮
                    if (ele.attr(allowDatas[i]) == '0') {
                        a.addClass(classes[i] + '-dis');
                        a.unbind('click');
                    }
                }
                nestedDiv.append(a);
            }
            menu.append(span);
            menu.append(nestedDiv);
        }

        var blank = $('#menu-blank');   // 菜单后边需要跟一个没有内容的Div
        if (blank.length == 0) {
            blank = $('<div></div>').addClass('blank10 fold-s2 fold-s3 fold-s4').attr('id', 'menu-blank');
        }

        return [menu, blank];
    },
    BindClick : function(ele, node, level, albumCid) {
        if (node.idtype == 3 || node.idtype == 5 || node.idtype == 7) {   // 叶子节点
            if (!albumCid) {
                ele.css('background-image', 'none');
            }
            ele.click(level, function(event) {
                var div = $(this).parent().parent('div');
                if (div.length && div.hasClass('unfold-s' + (event.data + 1))) {
                    div.removeClass('unfold-s' + (event.data + 1));
                    return;
                } else {
                    div.addClass('unfold-s' + (event.data + 1));
                }
                var id = parseInt(this.getAttribute('data-id'));
                var param = sohuHD.json.toJSON({
                    "id":id, 
                    "idtype":parseInt($(this).attr('data-idtype')),
                    "parentid":parseInt($(this).attr('data-parentid')),
                    "parentidtype":parseInt($(this).attr('data-parentidtype'))
                }); 
                EXTERNAL.ConsolePlayVideo(param);

                event.preventDefault();
                if (albumCid) {
                    if (2 == albumCid || 16 == albumCid) {   // 当前要播放的视频在电视剧或动画专辑中（目前电视剧、动漫和综艺节目传的这个值都是2）
                        $(this).parent().parent().find('a').removeClass('on');
                        $(this).addClass('on');
                    }
                } else {
                    //$(this).parent().parent().append(Util.GetMenu(this));
                    $(this).append.apply($(this).parent().parent(), Util.GetMenu($(this)));
                }
                $('.leftNav').resize();
            });
        } else {
            ele.click(level, function(event) {
                var div = $(this).parent().parent();
                if (div.hasClass('unfold-s' + (event.data + 1))) {
                    div.removeClass('unfold-s' + (event.data + 1));
                    Util.RemoveChildNodes(div);
                } else {
                    // 文件夹节点，且不是热点新闻，有子节点的话，就不再重新请求子节点数据
                    if(1 == node.idtype && -2 != node.id && $(this).parent().siblings('div').length) {
                        div.addClass('unfold-s' + (event.data + 1));
                    } else {
                        var id = parseInt(this.getAttribute('data-id'));

                        Util.AppendTempPrompt(div);
                        
                        var param = { 
                            "id":id,
                            "idtype":parseInt(this.getAttribute('data-idtype')),
                            "parentid":parseInt($(this).attr('data-parentid')),
                            "parentidtype":parseInt($(this).attr('data-parentidtype'))
                        };
                        var isAlbum = 2 == node.idtype || 4 == node.idtype;
                        if (!isAlbum) {
                            var start = (parseInt($(this).attr('data-end')) || 0) + 1;
                            param.start = start;
                            param.end = start + FETCH_CHILD_NUM - 1;
                        } else {
                            // Do nothing, start and end are undefined indicates fetch all child nodes.
                            // param.start = param.end = 0;
                        }
                        var paramStr = sohuHD.json.toJSON(param);
                        EXTERNAL.ConsoleGetChildNodes(paramStr);
                        //log(param);
                    }
                }
                $('.leftNav').resize();
                event.preventDefault();
            });
        }
    },
    ShowChildNodes : function(parent, level, nodes, childnum) {
        Util.RemoveTempPrompt(parent);

        for (var i = 0; i < nodes.length; i++) {
            var child = nodes[i];
            var levelplusone = level + 1;
            var div = document.createElement('div');
            div.className = 'ln-item fold-s' + levelplusone;
            var p = document.createElement('p');
            p.className = 'ln-n ln-n-s' + levelplusone;
            var a = document.createElement('a');
            a.className = 'ln-nBg';
            a.setAttribute('data-id', child.id);
            a.setAttribute('data-idtype', child.idtype);
            a.setAttribute('data-parentid', child.parentid);
            a.setAttribute('data-parentidtype', child.parentidtype);
            a.setAttribute('data-allowdownload', child.allowDownload);
            a.setAttribute('data-allowdetail', child.allowShowDetail);
            a.setAttribute('data-allowattent', child.allowAttent);
            a.setAttribute('data-allowput', child.allowPutonDesktop);
            a.style.cssText = 'overflow:hidden;white-space:nowrap;text-overflow:ellipsis;display:block;';
            a.setAttribute('title' , child.name);
            a.appendChild(document.createTextNode(child.name));

            p.appendChild(a);
            div.appendChild(p);
            parent[0].appendChild(div);
            Util.BindClick($(a), child, level);

            // 默认展开的节点
            if ('1' == '' + child.isOpen) {
                $(a).click();
            }
        }
        
        var showTo = parseInt(parent.attr('data-end')) || 0;
        showTo += nodes.length;
        parent.attr('data-end', showTo);

        if (showTo < childnum) {
            var moreTpl = '<div class="ln-item loadmore"><p class="ln-n ln-n-s' + levelplusone + '"><a class="ln-nBg">点击加载更多</a></p>';
            var more$ = $(moreTpl);
            parent.append(more$);
            more$.find('a.ln-nBg').click(function() {
                var start = (parseInt(parent.attr('data-end')) || 0) + 1;
                var parentAnchor = parent.find('p.ln-n > a.ln-nBg');
                var param = sohuHD.json.toJSON({ 
                    "id":parseInt(parentAnchor.attr('data-id')),
                    "idtype":parseInt(parentAnchor.attr('data-idtype')),
                    "parentid":parseInt(parentAnchor.attr('data-parentid')),
                    "parentidtype":parseInt(parentAnchor.attr('data-parentidtype')),
                    "start":start,
                    "end":start + FETCH_CHILD_NUM - 1
                });
                parent.attr('data-fetching', 1);
                EXTERNAL.ConsoleGetChildNodes(param);

                parent.children('div.loadmore').remove();
                Util.AppendTempPrompt(parent);
            });
        }

        $('.leftNav').resize();
    },
    RemoveChildNodes : function(div) {
        var childDivs = div.children('div');
        if (childDivs.length > 500) {
            childDivs.remove();
            var nodeid = div.find('p a').attr('id');
            if (Util.TimeoutSet[nodeid] != undefined) {
                window.clearTimeout(Util.TimeoutSet[nodeid]);
            }
        }
    },
    AppendTempPrompt : function(div, msg) {
        if (div.find('div.fold-s8').length) {
            return;
        }
        msg = msg || '正在加载内容列表...';
        var tempPrompt = document.createElement('div');
        tempPrompt.className = 'ln-item fold-s8';
        tempPrompt.innerHTML = '<p class="ln-n ln-n-s3">' + msg + '</p>';
        div.append(tempPrompt);
    },
    RemoveTempPrompt : function(div$) {
        div$.find('div.fold-s8').remove();
    },
    /**
     * 获得某元素的坐标信息, only IE
     * @author xwcoder xwcoder@outlook.com
     * @param {HTML DOM} el
     * @return {object} {
         *  screenX : (左上角)相对于屏幕的横坐标
         *  screenY : (左上角)相对于屏幕的纵坐标
         *  clientX : (左上角)相对于浏览器窗口的横坐标
         *  clientY : (左上角)相对于浏览器窗口的纵坐标
         *  clientBottom : (右下角)相对于浏览器窗口的纵坐标
         *  clientRight : (右下角)相对于浏览器窗口的横坐标
         *  winscreenX : 窗口相对于屏幕的横坐标
         *  winscreenY : 窗口相对于屏幕的纵坐标
         *  winHeight : 窗口高度
         *  winWidth : 窗口宽度
         * }
     */
    getPosition : function (el) {
        var client = el.getBoundingClientRect();
        var win = {top : window.screenTop, left : window.screenLeft};
        if (win.top === undefined) {
            win.top = window.screenY;
        }
        if (win.left === undefined) {
            win.left = window.screenX;
        }
        return {
            screenX : win.left + client.left,
            screenY : win.top + client.top,
            clientX : client.left,
            clientY : client.top,
            clientBottom : client.bottom,
            clientRight : client.right, 
            winscreenX : win.left,
            winscreenY : win.top,
            winHeight : document.documentElement ? document.documentElement.clientHeight : document.body.clientHeight,
            winWidth : document.documentElement ? document.documentElement.clientWidth : document.body.clientWidth
        };
    }
};

function log(msg, direction) {
    if (!DEBUG) {
        return;
    }
    if (!direction) {
        msg = 'JS 2 C++:' + msg;
    } else if (1 == direction){
        msg = 'C++ 2 JS:' + msg;
    } else if (2 == direction) {
        //do nothing
    }

    EXTERNAL.WriteWebLog(msg);
}

function ScrollToTop() {
    $('.leftNav').scrollTop(0);
}

function NavigageToNode(ob) {
    var path = ob.Tree;
    if (path) {
        // TODO: 定位到某一结点
    }
}

function UnfoldAll() {
    log(getCount() + 'UnfoldAll invoked');

    var items = $('.leftNav').children('div .ln-item');
    for (var i = 0; i < items.length; i++) {
        if ($(items[i]).hasClass('unfold-s1')) {
            $(items[i]).removeClass('unfold-s1');
            Util.RemoveChildNodes($(items[i]));
        }
    }
    $('.leftNav').resize();
}

function setTheme(params) {
    try {
        params = $.parseJSON(params);
    } catch (e) {
        sohuHD.IfoxLog(e);
        return;
    }
    var color = params.color;

    var themes = {
        'black' : 'blackNav',
        'white' : 'whiteNav'
    };
    var className = themes[color];
    if (className) {
        $('#leftNav').attr('class', className);
    }
}

function RefreshAllNodes() {
    var param = sohuHD.json.toJSON( { "id" : -1, "idtype" : 1, "parentid" : -3, "parentidtype" : -3 } );
    //log(param);

    EXTERNAL.ConsoleGetChildNodes(param);
}

/*
 * idtype 对应关系:
 *      0 : 无效类型
 *      1 : 文件夹 (热点新闻的idtype是1, id是-2，需特殊处理)
 *      2 : 专辑 (需要再通过cid去区分专辑类型) 
 *      3 : 视频 (叶子节点)
 *      4 : 全网专辑 (需要再通过cid去区分专辑类型)
 *      5 : 全网视频 (叶子节点)
 *      6 : KTV专辑
 *      7 : KTV视频 (叶子节点)
 *
 * cid 对应关系:
 *      2 : 电视剧
 *      7 : 综艺
 *      16 : 动画
 *      8 : 记录片
 *      6 : 自制原创
 *      1 : 电影
 *      25 : 社会新闻
 *      13 : 娱乐新闻
 *      9001 : 播客
 *      24 : 时常音乐
 *
 */
function ReturnChildNodes(node) {
    log(getCount() + node.substr(0, 50), 2);

    node = sohuHD.json(node);
    if (node.id == -1 && node.idtype == 1) {
        var parent = $('.leftNav');
        parent.html('');
        var level = 0;
    } else {
        parent = $('[data-id="' + node.id + '"]' + 
                   '[data-idtype="' + node.idtype + '"]' + 
                   '[data-parentid="' + node.parentid + '"]' + 
                   '[data-parentidtype="' + node.parentidtype + '"]' 
                  ).parent().parent(); 

        if (!parent || !parent.length) {
            log('Console error: Can not find parent node:' + 
                'name=' + node.name +
                ',id=' + node.id +
                ',idtype=' + node.idtype + 
                ',parentid=' + node.parentid +
                ',parentidtype=' + node.parentidtype, 2);
            return;
        }

        var className = parent.attr('class');
        var matches = className && className.match(/fold-s(\d)/); 
        if (matches) {
            level = parseInt(matches[1]);
        }
    }
    if (level > 0) {
        parent.addClass('unfold-s' + level);
    }
    if (parent.attr('data-fetching') == 1) {    // 加载更多子节点ing
        parent.attr('data-fetching', 0);
    } else {
        parent.children('div').remove();
    }
    
    if (0 == node.childnum) {
        Util.AppendTempPrompt(parent, '获取数据失败，请刷新重试');
        window.setTimeout(function() {
            parent.children('div').remove;
        }, 1000);
        return;
    }

    if (node.childNodes && $.isArray(node.childNodes)) {
        var isAlbum = 2 == node.idtype || 4 == node.idtype;
        if (isAlbum) {  // 当前节点是专辑
            var menu = Util.GetMenu($('[data-id="' + node.id + '"]' + 
                                      '[data-idtype="' + node.idtype + '"]' + 
                                      '[data-parentid="' + node.parentid + '"]' + 
                                      '[data-parentidtype="' + node.parentidtype + '"]'));
            if (!menu) { return; }

            // 分段 Start
            var isDrama = 2 == node.cid || 16 == node.cid;      // 电视剧和动漫按剧集分段 
            var isArts = 7 == node.cid || 8 == node.cid;        // 综艺节目按月份分段
            menu[0] && menu[0].children().remove('.ln-selBox');
            if ( (isDrama && node.childNodes.length > PARA_NUM) || (isArts && node.childNodes.length > PARA_ARTS) ) {
                var sel = $('<div></div>').addClass('ln-selBox');
                if (isArts) {
                    sel.addClass('select-year');
                }
                var p = $('<p></p>').addClass('ln-selBox-in cfix');
                var span = $('<span></span>');

                var a = $('<a></a>').append(span).append($('<em></em>'));
                span.change({isDrama : isDrama, isArts : isArts}, function(event) {
                    $(this).parents().eq(2).removeClass('ln-selBox_sel');
                    var episodes = $('#album-list').children('li');
                    var currTxt = $(this).text() || '';
                    if (parseInt(currTxt) != NaN) {
                        if (event.data.isDrama) {
                            var matches = currTxt.match(/(\d+)-(\d+)/);
                            var start = parseInt(matches[1]);
                            var end = parseInt(matches[2]);
                        } 
                        for (var i = 0; i < episodes.length; i++) {
                            if (event.data.isDrama) {
                                var episodeNum = parseInt($(episodes[i]).find('a').text());
                            }
                            if ( (event.data.isDrama && episodeNum && episodeNum <= end && episodeNum >= start) || 
                                (event.data.isArts && episodes[i].getAttribute('data-publishtime').indexOf($('#current_year').text() + '-' + $('#current_month').text() + '-') > -1) ) {
                                episodes[i].style.display = '';
                            } else {
                                episodes[i].style.display = 'none';
                            }
                        }
                    }
                });
                a.click(function() {
                    var div = $(this).parent().parent();
                    if (div.hasClass('ln-selBox_sel')) {
                        div.removeClass('ln-selBox_sel');
                    } else {
                        div.addClass('ln-selBox_sel');
                    }
                });

                var tmpl = [
                    '<div class="ln-selBox-opt">',
                    '   <span class="arr"></span>',
                    '   <div class="top cfix">',
                    '       <div class="top-l l">',
                    '       </div>',
                    '       <div class="top-r r">',
                    '       </div>',
                    '       <div class="top-c">',
                    '       </div>',
                    '   </div>',
                    '   <div class="center">',
                    '       <ul class="ln-txt">',
                    '       </ul>',
                    '   </div>',
                    '   <div class="bot cfix">',
                    '       <div class="bot-l l">',
                    '       </div>',
                    '       <div class="bot-r r">',
                    '       </div>',
                    '       <div class="bot-c">',
                    '       </div>',
                    '   </div>',
                    '</div>'
                ];
                var opt = $(tmpl.join(''));
                var selUl = opt.find('.ln-txt');
                var lis = Math.ceil(node.childNodes.length / PARA_NUM);

                // 根据当前选择的年份，筛选应当显示的月份
                var filterMonths = function(yearOption$) {
                    var currentMonth$ = $('#current_month');
                    var monthsOfYear = yearOption$.data('months');
                    var months = currentMonth$.parents('p.ln-selBox-in').siblings('div.ln-selBox-opt').find('ul.ln-txt > li');
                    var preText = currentMonth$.text();
                    var firstShowText;
                    for (var i = 0; i < months.length; i++) {
                        var text = months.eq(i).children('a').text();
                        if (monthsOfYear[text]) {
                            months.eq(i).show();
                            if (!firstShowText) {
                                firstShowText = text;
                            }
                            if (text == preText) {
                                firstShowText = preText;
                            }
                        } else {
                            months.eq(i).hide();
                        }
                    }
                    if (firstShowText != preText) {
                        currentMonth$.text(firstShowText);
                    }
                };
                var opt_a_handler = function() {
                    var selectBox = $(this).parents().eq(4).find('p a span');
                    if (selectBox.length) {
                        if (selectBox.text() != $(this).text()) {
                            // 如果是选择年份，联动月份
                            if ('current_year' == selectBox.attr('id')) {
                                filterMonths($(this));
                            }
                            selectBox.text($(this).text()).change();
                        } else {
                            selectBox.parent().click();
                        }
                    }
                    $('.leftNav').resize();
                };

                if (isDrama) {
                    for (var i = 0; i < lis; i++) {
                        var start = i * PARA_NUM + 1;
                        var end = node.childNodes.length;
                        if (end > start + PARA_NUM - 1) {
                            end = start + PARA_NUM - 1;
                        }
                        var li = $('<li></li>');
                        var opt_a = $('<a></a>').text(start + '-' + end);
                        opt_a.click(opt_a_handler);
                        li.append(opt_a);
                        selUl.append(li);
                    } 
                    if (1 == node.order) {
                        selUl.append(selUl.children().get().reverse());
                    }
                } else if (isArts) {
                    // 综艺按发布时间倒序排序
                    node.childNodes.sort(function(a, b) {
                        try {
                            return new Date(b.publishtime.replace('-', '/')) - new Date(a.publishtime.replace('-', '/'));
                        } catch (e) {
                            return 0;
                        }
                    });

                    var years = {};
                    var months = {};
                    var monthEles = [];
                    for (var i = 0; i < node.childNodes.length; i++) {
                        var child = node.childNodes[i];
                        child.name = child.publishtime + ' ' + child.name;
                        var matches = child.publishtime && child.publishtime.match(/(\d{2,4})-(\d{1,2})-\d{1,2}/);
                        if (!matches || matches.length < 3) {
                            window.external.WriteWebLog('Invalid format: publishtime of node:' + child.name);
                            continue;
                        }
                        var year = matches && matches[1];
                        if (!years[year]) {
                            var li = $('<li></li>');
                            var opt_a = $('<a></a>').text(year);
                            opt_a.click(opt_a_handler);
                            li.append(opt_a);
                            selUl.append(li);
                            years[year] = {};
                            opt_a.data('months', years[year]);
                        }

                        var month = matches && matches[2];
                        if (!months[month]) {
                            var li = $('<li></li>');
                            var opt_a = $('<a></a>').text(month);
                            opt_a.click(opt_a_handler);
                            li.append(opt_a);
                            monthEles.push(li);
                            months[month] = true;
                        }
                        years[year][month] = true;
                    }
                }

                p.append(a);
                sel.append(p);
                sel.append(opt);
                menu[0].append(sel);

                if (monthEles && monthEles.length > 0) {
                    sel.css('float', 'left');
                    var selMonth = sel.clone(true, true);
                    selMonth.removeClass('select-year').addClass('select-month');
                    var selUlMonth = selMonth.find('ul.ln-txt').empty();
                    monthEles.sort(function(a, b) {
                        try {
                            return parseInt(b.children('a').text(), 10) - parseInt(a.children('a').text(), 10);
                        } catch (e) {
                            return 0;
                        }
                    });
                    selUlMonth.append.apply(selUlMonth, monthEles);
                    menu[0].append(selMonth);
                }
            }
            // 分段 End

            var fillList = function(ul, node, level, text, isArts /*optional*/) {
                var li = $('<li></li>');
                var a =  $('<a></a>').attr( {
                    'data-id' : node.id, 
                    'data-idtype' : node.idtype,
                    'data-parentid' : node.parentid,
                    'data-parentidtype' : node.parentidtype,
                    'data-allowdownload' : node.allowDownload,
                    'data-allowdetail' : node.allowShowDetail,
                    'style' : 'overflow:hidden;white-space:nowrap;text-overflow:ellipsis;display:block;', 
                    'title' : text 
                } ).text(text);
                if (isArts) {
                    li.attr('data-publishtime', node.publishtime);
                }

                ul.append(li.append(a));

                Util.BindClick(a, node, level, 2);

                // 默认展开的节点
                if ('1' == '' + node.isOpen) {
                    a.click();
                }
            };

            var ul = $('<ul></ul>').attr('id', 'album-list');
            ul.addClass(isDrama ? 'ln-episode cfix' : 'ln-txt ln-txt-s1');

            // 综艺按月分段
            if (selMonth) {
                ul.css('width', '257px');
            }

            menu[0].append(ul);
            $(parent).append.apply($(parent), menu);

            // node.order 0:表示剧集按正序排序，1：表示按逆序
            for (var i = 0, ln = node.childNodes.length; i < ln; i++) {
                if (isDrama) {
                    var showName = 1 == node.order ? ln - i : i + 1;
                } else {
                    showName = node.childNodes[i].name;
                }
                fillList(ul, node.childNodes[i], level, showName, !isDrama && isArts);
            }

            // 如果有分段
            if (span && selUl) {
                if (isArts) {
                    span.attr('id', 'current_year');
                    // 综艺节目按月分段
                    if (selMonth) {
                        var spanMonth = selMonth.children('p.ln-selBox-in').find('a span');
                        spanMonth.attr('id', 'current_month');
                    }
                }
                selUl.find('li:first > a').click();
            }
        } else {
            Util.ShowChildNodes(parent, level, node.childNodes, node.childnum);
        }
    }

    log(getCount() + 'Create DOM elements complish.', 2);
    if (node.id == -1 && node.idtype == 1) {
        EXTERNAL.ConsoleVideoTreeBuilded(sohuHD.json.toJSON({'result' : 0}));
        EXTERNAL.WriteWebLog('Console log: ConsoleVideoTreeBuilded invoked. node.id=' + node.id + ',node.idtype=' + node.idtype);
    }
    $('.leftNav').resize();
}

(function(window) {
    if (!DEBUG) {
        return;
    }
    EXTERNAL = EXTERNAL || {};
    var apply = function(o, c) {
        for (var p in c) {
            o[p] = c[p];
        }
    };
    /**  
     * An util method to deep clone an object.
     * @param {} obj The object to be cloned.
     * @param {String} preventName The property name do not to be cloned. 
     * @return {}
     */
    var deepClone = function ( obj, preventName ) {
        if ( typeof obj == 'object' ) {
            var res = obj instanceof Array ? [] : {};
            for( var p in obj ) {
                if ( p != preventName ) {
                    res[p] = arguments.callee( obj[p], preventName );
                }    
            }    
            return res; 
        } else if ( toString.call( obj ) === '[object Function]' ) {
            return ( new obj() ).constructor;     
        }    
        return obj; 
    };
    var extend = {
        GetNode : function(cur, node, start, end) {
            if (!cur || !node) {
                return null;
            }
            if (node.id == cur.id && node.idtype == cur.idtype && node.parentid==cur.parentid && node.parentidtype==cur.parentidtype) {
                if (start && end) {
                    var copy = deepClone(cur);
                    copy.childnum = copy.childNodes.length || 0;
                    copy.childNodes = copy.childNodes.filter(function(ele, index) {
                        var serial = index + 1;
                        return serial >= start && serial <= end;
                    });
                    return copy;
                } else {
                    return cur;
                }
            }
            if (cur.childNodes && $.isArray(cur.childNodes)) {
                for (var i = 0; i < cur.childNodes.length; i++) {
                    var found = extend.GetNode(cur.childNodes[i], node, start, end);
                    if (found) return found;
                }
            }
            return null;
        },
        ConsoleGetChildNodes : function(parentNode) {
            parentNode = sohuHD.json(parentNode);
            var theNode = extend.GetNode(fakedata, parentNode, parentNode.start, parentNode.end);
            
            window.setTimeout(ReturnChildNodes, 500, sohuHD.json.toJSON(theNode));
        },
        ConsoleDownloadVideo : function(ob) {
            ob = sohuHD.json(ob);
            alert('Download ' + ob.id + '    ' + ob.idtype);
        },
        ConsolePutOnDesktop : function(ob) {
            ob = sohuHD.json(ob);
            alert('Put ' + ob.id + '    ' + ob.idtype);
        },
        ConsoleRefresh : function() {
            alert('Refresh');
        },
        ConsolePlayVideo : function(ob) {
            ob = sohuHD.json(ob);
            alert('Now play ' + ob.id + '    ' + ob.idtype);
        },
        ConsoleShowDetailPage : function(ob) {
            ob = sohuHD.json(ob);
            alert('Detail ' + ob.id + '    ' + ob.idtype);
        },
        ConsoleAttention : function(ob) {
            ob = sohuHD.json(ob);
            alert('Attention ' + ob.id + '    ' + ob.idtype);
        },
        WriteWebLog : function(msg) {
            //$.post('http://10.7.36.109/log.php', {msg:msg});
            console.log(msg);
        },
        ConsoleShowSepLine : function(ob) {
            ob = sohuHD.json(ob);
            //console.log('ShowSepLine ' + ob.show);
        },
        ConsoleVideoTreeBuilded : function(ob) {
            // do nothing
        }
    };
    apply(EXTERNAL, extend);
})(window);

$(window).ready(function() {
    // 禁用选择
    $(document).on('selectstart', function() {
        return false;
    });
    // 禁用右键
    $(document).on('contextmenu', function() {
        return false;
    });

    InitScroller();
    // 滚动条离开top时通知客户端
    $('.leftNav').on('attop.scroller leavetop.scroller', function(e) {
        if ('attop' == e.type) {
            var show = false;
        } else if ('leavetop' == e.type) {
            show = true;
        }

        EXTERNAL.ConsoleShowSepLine(sohuHD.json.toJSON({'show' : show}));
    });

    // 通过URL参数指定主题
    var theme = sohuHD.getUrlParam(document.location, 'theme') || 'white';
    var supportThemes = ['black', 'white'];
    if (supportThemes.indexOf(theme) > -1) {
        $('#leftNav').attr('class', theme + 'Nav');
    }

    RefreshAllNodes();
});
