//==============================================================================
// 影音播放记录-由页面来实现影音播放记录显示 by xinsong
//
// Modified by Qianyoushi(youshiqian@sohu-inc.com) at 2014-12-8
//==============================================================================

/**
 * es5
 */
( function () {

    if(!String.prototype.trim) {
        String.prototype.trim = function () {
            return this.replace(/^\s+|\s+$/g,'');
        };
    }

     if (!Function.prototype.bind) {
      Function.prototype.bind = function (oThis) {
        if (typeof this !== "function") {
          // closest thing possible to the ECMAScript 5 internal IsCallable function
          throw new TypeError("Function.prototype.bind - what is trying to be bound is not callable");
        }

        var aArgs = Array.prototype.slice.call(arguments, 1), 
            fToBind = this, 
            fNOP = function () {},
            fBound = function () {
              return fToBind.apply(this instanceof fNOP && oThis
                                     ? this
                                     : oThis,
                                   aArgs.concat(Array.prototype.slice.call(arguments)));
            };

        fNOP.prototype = this.prototype;
        fBound.prototype = new fNOP();

        return fBound;
      };
    }   

    if (!Array.prototype.indexOf) {
        Array.prototype.indexOf = function (searchElement, fromIndex) {
            if ( this === undefined || this === null ) {
                throw new TypeError( '"this" is null or not defined' );
            }

            var length = this.length >>> 0; // Hack to convert object.length to a UInt32

            fromIndex = +fromIndex || 0;

            if (Math.abs(fromIndex) === Infinity) {
                fromIndex = 0;
            }

            if (fromIndex < 0) {
                fromIndex += length;
                if (fromIndex < 0) {
                    fromIndex = 0;
                }
            }

            for (;fromIndex < length; fromIndex++) {
                if (this[fromIndex] === searchElement) {
                    return fromIndex;
                }
            }

            return -1;
        };
    }

    if (!Array.prototype.forEach) {
        Array.prototype.forEach = function(callbackfn /*, thisArg */)
        {
            "use strict";

            if (this === void 0 || this === null)
                throw new TypeError();

            var t = Object(this);
            var len = t.length >>> 0;
            if (typeof callbackfn !== "function")
                throw new TypeError();

            var thisArg = arguments.length >= 2 ? arguments[1] : void 0;
            for (var i = 0; i < len; i++)
            {
                if (i in t)
                    callbackfn.call(thisArg, t[i], i, t);
            }
        };
    }

    if (!Array.prototype.map) {
        Array.prototype.map = function(callbackfn /*, thisArg */)
        {
            "use strict";

            if (this === void 0 || this === null)
                throw new TypeError();

            var t = Object(this);
            var len = t.length >>> 0;
            if (typeof callbackfn !== "function")
                throw new TypeError();

            var res = new Array(len);
            var thisArg = arguments.length >= 2 ? arguments[1] : void 0;
            for (var i = 0; i < len; i++)
            {
                // NOTE: Absolute correctness would demand Object.defineProperty
                //       be used.  But this method is fairly new, and failure is
                //       possible only if Object.prototype or Array.prototype
                //       has a property |i| (very unlikely), so use a less-correct
                //       but more portable alternative.
                if (i in t)
                    res[i] = callbackfn.call(thisArg, t[i], i, t);
            }

            return res;
        };
    }

    if (!Array.prototype.filter) {
        Array.prototype.filter = function(fun /*, thisArg */) {
            "use strict";

            if (this === void 0 || this === null)
                throw new TypeError();

            var t = Object(this);
            var len = t.length >>> 0;
            if (typeof fun != "function")
                throw new TypeError();

            var res = [];
            var thisArg = arguments.length >= 2 ? arguments[1] : void 0;
            for (var i = 0; i < len; i++)
            {
                if (i in t)
                {
                    var val = t[i];

                    // NOTE: Technically this should Object.defineProperty at
                    //       the next index, as push can be affected by
                    //       properties on Object.prototype and Array.prototype.
                    //       But that method's new, and collisions should be
                    //       rare, so use the more-compatible alternative.
                    if (fun.call(thisArg, val, i, t))
                        res.push(val);
                }
            }

            return res;
        };
    }
    if (!Array.prototype.some) {
        Array.prototype.some = function(callbackfn /*, thisArg */)
        {
            'use strict';

            if (this === void 0 || this === null)
                throw new TypeError();

            var t = Object(this);
            var len = t.length >>> 0;
            if (typeof callbackfn !== 'function')
                throw new TypeError();

            var thisArg = arguments.length >= 2 ? arguments[1] : void 0;
            for (var i = 0; i < len; i++)
            {
                if (i in t && callbackfn.call(thisArg, t[i], i, t))
                    return true;
            }

            return false;
        };
    }
    if (!Array.prototype.every) {
      Array.prototype.every = function(fun /*, thisArg */)
      {
        'use strict';

        if (this === void 0 || this === null)
          throw new TypeError();

        var t = Object(this);
        var len = t.length >>> 0;
        if (typeof fun !== 'function')
            throw new TypeError();

        var thisArg = arguments.length >= 2 ? arguments[1] : void 0;
        for (var i = 0; i < len; i++)
        {
          if (i in t && !fun.call(thisArg, t[i], i, t))
            return false;
        }

        return true;
      };
    }

} )();


(function(window, $) {
    //window.onerror = function(errorMessage, scriptURI, lineNumber,columnNumber,errorObj) {
    //    alert(lineNumber + ' ' + errorMessage);
    //    window.external.WriteWebLog("错误信息：" + errorMessage);
    //    window.external.WriteWebLog("出错文件：" + scriptURI);
    //    window.external.WriteWebLog("出错行号：" + lineNumber);
    //    window.external.WriteWebLog("出错列号：" + columnNumber);
    //    window.external.WriteWebLog("错误详情：" + errorObj);
    //};
    
    if (!/^file:\/\/\//.test(location.href)) {
        return;
    }
    /* 扩展sohuHD for console-history （重构时写到公共文件里, 有些工具函数可能会共用）*/
    var each = function(obj, fn) {
        if (!obj || obj.nodeType) {
        // 一个dom对象
        // ie6/7 中 Object.prototype.toString.call() == '[object Object]';
        //          instanceof Object == false
        //          nodeType == undefined
        // FF 中    instanceof Object == true
        //          nodeType == undefined
            fn.call(obj, 0, obj);
        } else if (obj instanceof Array || window.jQuery && obj instanceof jQuery) {
            var i = 0;
            var d = null;
            while (i < obj.length) {
                d = obj[i];
                if (fn.call(d, i, d) == false){
                    break;
                }
                ++i;
            }
        } else {
            for (var i in obj) {
                if (fn.call(obj[i], i, obj[i]) == false) {
                    break;
                }
            }
        }
    };
    
    sohuHD.hide = function(target) {
        if (target instanceof $) {
            target.hide();
        } else {
            $(target).hide();
        }
    };
    sohuHD.show = function(target) {
        if (target instanceof $) {
            target.show();
        } else {
            $(target).show();
        }
    };
    sohuHD.each = each;

    var _e = function(msg) {
        external.WriteWebLog('Javascript error: ' + msg);
    };

    var trigger = function(elem, events, event) {
        if (!elem || !events) {
            _e('sohuHD.trigger need elem and events');
            return;
        }

        if (Object.prototype.toString.call(events) != '[object String]') {
            _e('events name must be string');
        }
        var ev = events.split('.');
        var type = ev[0] || '';
        var name = ev[1] || '';

        var eventsArr = elem.eventsArr || {};
        eventsArr = eventsArr[type] || [];

        if (!eventsArr.length) {
            return;
        }

        sohuHD.each(eventsArr, function(i, o){
            if ( !name || this.name == name) {
                if (this.fn) {
                    this.fn.call(elem, event);
                } else {
                    eventsArr.splice(i, 1);
                }
            }
        });
    };
    var fixEvent = function(event){
    //copy from jquery 
        if (!event.preventDefault) {
            event.preventDefault = function(){
                event.returnValue = false;
            };
        }

        if (!event.stopPropagation) {
            event.stopPropagation = function() {
                event.cancelBubble = true;
            };
        }

		if ( !event.target ) {
			event.target = event.srcElement || document;
		}

		if ( !event.relatedTarget && event.fromElement ) {
			event.relatedTarget = event.fromElement === event.target ? event.toElement : event.fromElement;
		}

		if ( event.pageX == null && event.clientX != null ) {
			var eventDocument = event.target.ownerDocument || document;
            var doc = eventDocument.documentElement;
            var body = eventDocument.body;

			event.pageX = event.clientX + (doc && doc.scrollLeft || body && body.scrollLeft || 0) - (doc && doc.clientLeft || body && body.clientLeft || 0);
			event.pageY = event.clientY + (doc && doc.scrollTop  || body && body.scrollTop  || 0) - (doc && doc.clientTop  || body && body.clientTop  || 0);
		}
		if ( event.which == null && (event.charCode != null || event.keyCode != null) ) {
			event.which = event.charCode != null ? event.charCode : event.keyCode;
		}
		if ( !event.metaKey && event.ctrlKey ) {
			event.metaKey = event.ctrlKey;
		}
		if ( !event.which && event.button !== undefined ) {
			event.which = (event.button & 1 ? 1 : ( event.button & 2 ? 3 : ( event.button & 4 ? 2 : 0 ) ));
		}

        return event;
    };
    var bind = function(elem, events, fn, opts) {
        if (!elem || !events) {
            _e('sohuHD.bind need elem and events');
            return;
        }

        if (Object.prototype.toString.call(events) != '[object String]') {
            _e('events name must be string');
            return;
        }

        var ev = events.split('.');
        var type = ev[0] || '';
        var name = ev[1] || '';

        if (!elem.eventsArr) {
            elem.eventsArr = {};
        }

        sohuHD.each(type.split(' '), function(i, name){

            var eventsArr = elem.eventsArr;
            if (!eventsArr[name]) {
                eventsArr[name] = [];
            }
            eventsArr = eventsArr[name] || [];

            opts = opts || {};

            if (!eventsArr.length) {
                if (elem.addEventListener) {
                    elem.addEventListener(name, function(e){
                        trigger(elem, name, fixEvent(e));
                    }, false);//DOM2.0
                } else if (elem.attachEvent) {
                    elem.attachEvent('on' + name, function(e){
                        trigger(elem, name, fixEvent(e));
                    });//IE5+
                } else {
                    elem['on' + name] = function(e){
                        trigger(elem, name, fixEvent(e));
                    };//DOM 0
                }
            }
            eventsArr.push({
                'name' : name,
                'fn' : fn
            });
        });
    };
    sohuHD.bind = function(elem, events, fn, opts) {
        var isHover = (events == 'hover' && Object.prototype.toString.call(opts) == '[object Function]');
        if (isHover) {
            sohuHD.each(elem, function(i, o){
                bind(o, 'mouseover', fn);
                bind(o, 'mouseout', opts);
            });
        } else {
            sohuHD.each(elem, function(i, o){
                bind(this, events, fn, opts);
            });
        }
    };
    sohuHD.switchTab = function (tabs, opts) {
		//TODO: remove jquery
        /* @tabs: the nav tabs[array]
          @opts: {
            event : 'click'/'mouseover' 默认mouseover
            , cssName : className(current)
            , boxs : switch boxs[array]
            , start : 0 / -1
                        whitch box to start
                        if -1 ,all of boxs hide
            , callback : function(){
            }
            , no
          }
          example: 
          sohuHD.switchTab($("#navTab>li"),{
            boxs : $("#boxs>div")
            ,start : 0
            ,callback : function(o){
                 
            }
          });
          */
        if (!tabs) {
            _e('sohuHD.switchTab need tabs');
            return;
        }
        opts = opts || {};
        var type = opts.event || 'mouseover';
        var cssName = opts.cssName || 'current';

        var callback = opts.callback || null;
        var before = opts.before || null;
        var boxs = opts.boxs || [];
        var next = opts.next || '';
        var prev = opts.prev || '';
        var multiBox = boxs.length > 1 ? true : false;
        var start = 0;

        if (Math.abs(opts.start) > 0) {
            start = opts.start;
        }

        var auto = opts.auto || false;

        tabs.n = 0;
        if (multiBox) {
            sohuHD.hide(boxs);
        }

        var autoNext = function () {
            eventHandler(tabs[(tabs.n >= tabs.length - 1) ? 0 : tabs.n + 1]);
        };

        var autoPrev = function () {
            eventHandler(tabs[(tabs.n <= 0) ? tabs.length - 1 : tabs.n - 1]);
        };

        if (next) {
            sohuHD.bind(next, 'click', function () {
                eventHandler(tabs[(tabs.n >= tabs.length - 1) ? 0 : tabs.n + 1]);
            });
        }
        if (prev) {
            sohuHD.bind(prev, 'click', function () {
                eventHandler(tabs[(tabs.n <= 0) ? tabs.length - 1 : tabs.n - 1]);
            });
        }

        var go;
        if (auto) {
			//auto 支持boolean和int
			var gap = typeof auto == "boolean" ? 5000 : auto;
            go = setInterval(autoNext, gap);
            sohuHD.bind(tabs, 'hover', function(){
                clearInterval(go);
            }, function(){
                go = setInterval(autoNext, gap);
            });
        }

        var eventHandler = function (tab) {

            if (typeof before === 'function') {
                if(!before(tab, multiBox ? boxs[n] : boxs)) {
                    return false;
                }
            }
            var n = tab.n;
			
            if ($(tab).hasClass(cssName)) {
                return;
            }
            $(tab).addClass(cssName);
            if (n != tabs.n) {
                $(tabs[tabs.n]).removeClass(cssName);
            }
            if (multiBox) {
                sohuHD.hide(boxs[tabs.n]);
                sohuHD.show(boxs[n]);
            }
            tabs.n = n;
            trigger(tab, 'blur');
            if (callback) {
                callback(tab, multiBox ? boxs[n] : boxs);
            }
        };

        sohuHD.each(tabs, function (i, o) {
            $(o).removeClass(cssName);
            o.n = i;
            if (i == start) {
                eventHandler(o);
            }
        });

        if (type == 'mouseover') {
            sohuHD.bind(tabs, 'hover', function(){
                var me = this;
                me.timer = setTimeout(function () {
                    eventHandler(me);
                }, 100);
            }, function () {
                clearTimeout(this.timer);
                this.timer = null;
            });
        } else {
			sohuHD.bind(tabs, 'click', function(e){
				if (!this.getAttribute('disabled')) {
					eventHandler(this);
					e.preventDefault();
				}
			});
		}
    };
    /* 扩展sohuHD 结束 */

    var counter = (function() {
        var count = 0;
        return function() {
            return count++;
        };
    })();

    window.AjaxCallBack = function(res) {
        try {
            res = $.parseJSON(res);
            if (200 == res.statecode && res.uuid) {
                var callback = window._callback_pool[ res.uuid ];
                if (callback && $.isFunction(callback)) {
                    callback(res.data);
                    delete window._callback_pool[ res.uuid ];
                }
            }
        } catch (e) {
            window.external.WriteWebLog(e.message);
        }
    };

    $.ajax = function(url, options) {
		// If url is an object, simulate pre-1.5 signature
		if ( typeof url === "object" ) {
			options = url;
			url = undefined;
		}

		// Force options to be an object
		options = options || {};

        window._callback_pool =  window._callback_pool || {}
        var uuid = '_hisCallback_' + counter();
        window._callback_pool[ uuid ] = function(data) {
            try {
                // 影音传过来的结果本身是String，parseJSON后data字段的内容（http响应体）还是String
                // 所以需要再parseJSON一次
                options.success($.parseJSON(data));
            } catch (e) {
                window.external.WriteWebLog(e.message);
            }
        };
        url = url || options.url;
        url = url.replace(/callback=[^&]*/, '');
        if (options.data && typeof options.data == 'object') {
            var rquery = /\?/;
            for (key in options.data) {
                url += ( rquery.test( url ) ? "&" : "?" ) + key + '=' + options.data[ key ];
            }
        }
        var params = {
            url: url,
            method: 'Get',
            uuid: uuid,
            callback: 'AjaxCallBack'
        };
        window.external.SendRequest(JSON.stringify(params));
    };

    sohuHD.ifox = sohuHD.ifox || {};
    $.extend(sohuHD.ifox, {
        play: function(obj){
            var arg = {
                vid : null,
                start : 0,
                version:-1,
                isMyTv :false,
                playSrc :-1
            };
            arg = $.extend(arg,obj);
            return window.external.Play(JSON.stringify(arg));
        },
        oplay: function(obj){
            var arg = {
                "uid":0,
                "rid" : 0,
                "domain" : '',
                "mode" : 0
            };
            arg = $.extend(arg, obj);
            return window.external.WholeNetPlay(JSON.stringify(arg));
        },
        log: function(msg) {
            return window.external.WriteWebLog(msg);
        },
        getUserData : function(key){
            var arg = {
                'key': key
            };
            return window.external.GetUserData(JSON.stringify(arg));
        }
    });
    
})(window, jQuery);

;(function (window, undefined) {
    var isIE6 = !!window.ActiveXObject&&!window.XMLHttpRequest;
    var map = {
        clientType : {
            '1' : '网页',
            '2' : 'iPad',
            '3' : 'iPhone手机',
            '5' : 'Symbian手机',
            '6' : 'ifox',
            '7' : 'IePad',
            '8' : '360桌面',
            '9' : 'Q+',
            '10' : 'Android手机',
            '11' : 'Android Pad',
            '12' : '搜狐影音',
            '13' : 'Windows Phone',
            '14' : 'Windows Pad',
            '15' : '电视端',
            '16' : 'iPad网页',
            '-2' : '其他',
            '21' : 'Mac浏览器',
            '26' : '狐聊',
            '27' : '电视端'
        },
        clearUrl: 'http://his.tv.sohu.com/his/delAll.do?plat=12'
    };
    var passportUtil = {
        getSavedEmail : function() {
            var savedEmail = '';
            try {
                savedEmail = window.external.GetPassport();
            } catch(e) {
                savedEmail = '';
            }
            return savedEmail;
        },
        getPassport : function () {
            var cookiePassport = typeof window.PassportSC != 'undefined' ? PassportSC.cookieHandle() : '';
            var savedEmail = this.getSavedEmail();
            return savedEmail || cookiePassport;
        },
        isLogin : function () {
            return !!this.getPassport();
        }
    };
    /**
    * 业务逻辑
    */
    // var type = 0;
    var history = {
        delUrl : 'http://his.tv.sohu.com/his/del.do',
        cleanUrl : 'http://his.tv.sohu.com/his/delAll.do?plat=12',
        getUrl : 'http://his.tv.sohu.com/his/get.do?videotype=2&c=1&pagesize=60&callback=?&passport=',
        encode : 'gbk',
        /**
         * @description 获得本站的本地历史记录
         */
        getHistory : function () {
            var his = $.cookie( 'savehistory' );
            if ( !his ) {
                return [];
            }
            his = his.split( '%2C' );
            var array = [];

            $.each( his, function ( index, h ) {
                h = h.split( '^' );
                if ( h.length > 1) {
                    array.push( { plid : h[0], vid : h[1], order : h[2], newTime : h[3], mix : h[4],/**不知道h[4]是啥**/
                            url : h[5], title : unescape( h[6] ), playTime : parseInt( h[7] ), nurl : h[8] } );
                }
            } );
            return array.reverse();
        },
        /**
         * @description 获得全网的本地历史记录
         */
        getLocalHistory : function () {
            return this.getHistory().concat( ifoxHistory.getRecords() ).sort( function ( a, b ) {
                if ( a && a.playTime && b && b.playTime ) {
                    return ( a.playTime - b.playTime ) * -1;
                }
                return 0;
            });
        },
        getRemoteHistory : function ( passport, callback ) {
            passport = passport || passportUtil.getPassport();
            if ( passport ) {
                $.getJSON( this.getUrl + passport + '&encode=' + this.encode, function ( data ) {
                    callback( data );
                } );
            }
        },
        /**
         * @description 删除本站本地历史记录
         */
        delLocalItem : function () {
            var vids = arguments;
            if ( vids.length == 0 ) {
                $.cookie( 'savehistory', null, { path : '/', domain : 'tv.sohu.com' } );
                return;
            }
            var his = $.cookie('savehistory');
            var aHis = his.split('%2C');
            var i,len,vid,h,j,hlen;
            for ( i = 0, len = vids.length; i < len; i++) {
                vid = vids[i];
                for ( j = 0, hlen = aHis.length; j < hlen; j++) {
                    h = aHis[j];
                    if ( new RegExp('\\w*\\^' + vid + '\\^\\w*').test(h) ) {
                        if ( aHis.length != 1 ) {
                            if ( j != hlen - 1) {
                                h = h + '%2C';
                            } else {
                                h = '%2C' + h;
                            }
                        }
                        his = his.replace(h, '');
                    }
                }
            }
            $.cookie('savehistory', his, { path : '/', domain : 'tv.sohu.com' } );
        },
        delRemoteItem : function ( vs, callback ) {
            if ( passportUtil.isLogin() && vs ) {
                callback = callback || function () {};
                try {
                    $.getJSON( this.delUrl + '?callback=?&passport=' + passportUtil.getPassport() + '&vs=' + vs + '&c=1', function ( data ) {
                        // alert(1)
                        callback( data );
                    } );
                } catch ( e ) {}
            }
        },

        clear : function ( type ) {
            if ( type == 'unlogged' ) {
                this.delLocalItem();
                ifoxHistory && ifoxHistory.clear();
            } else if ( passportUtil.isLogin() && type == 'logged' ) {
               try {
                    if ( $( '#hiddenPostFrame' ).length == 0 ) {
                        $('body').append('<iframe name="hiddenPostFrame" id="hiddenPostFrame" style="display:none;"></iframe>');
                    }
                    if( $('#hiddenPostForm').length == 0 ) {
                        $('body').append(['<form id="hiddenPostForm" method="post" target="hiddenPostFrame"',
                                ' action="',sohuHD.history.cleanUrl,'"></form>'].join(''));
                    }
                    $('#hiddenPostForm')[0].submit();
               }catch(e){}
            }
        }
    };
    var localHandlers = {
        del : function ( e, data ) {//删除站内历史记录
            e.fadeIn('fast', function() {
                var wrap = e.parent();
                e.remove();
                if (!wrap.children('li').length) {
                    wrap.html('<p class="nothing">您目前还没有观看过视频节目！</p>')
                }
            });
            var params = {
                'id' : data.id,
                'idtype' : data.idtype,
                'playlistId' : data.playlistId,
                'name' : data.name
            };
            try {
                window.external.DeleteOnlineHistory(JSON.stringify(params));
            } catch (e) {
                sohuHD.ifox.log(e.message);
            }
            // history.delLocalItem( rev );
        },
        odel : function ( e, data ) {//删除站外记录
            // var value = rev.split(',');
            e.fadeIn('fast', function() {
                var wrap = e.parent();
                e.remove();
                if (!wrap.children('li').length) {
                    wrap.html('<p  class="nothing">您目前还没有观看过视频节目！</p>')
                }
            });
            var params = {
                'id' : data.id,
                'idtype' : data.idtype,
                'playlistId' : data.playlistId,
                'name' : data.name
            };
            try {
                window.external.DeleteOnlineHistory(JSON.stringify(params));
            } catch (e) {
                sohuHD.ifox.log(e.message);
            }
            // ifoxHistory.deleteRecord( value[0], value[1] );
        }
    };
    var remoteHandlers = {
        del : function ( e, rev ) {
            history.delRemoteItem( rev, function () {
                e.fadeIn('fast', function() {
                    var wrap = e.parent();
                    e.remove();
                    if (!wrap.children('li').length) {
                        wrap.html('<p class="nothing">您目前还没有观看过视频节目！</p>')
                    }
                });
            });
        }
    };
    var process = {
        allTv: function (data, mold) {
            // console.log(data);
            if (mold == 0) {
                wrap = $('#history_all');
            } else {
                wrap = $('#history_tv');
            }
            this.drawAllTv(wrap, data, mold);
            // this.bindAllTv(wrap);
        },
        drawAllTvItem: function (wrap, v, mold, isLocal, playlistIds, isPlaying ,start) {
            var yingshiMap = {
                1: 1,//电影
                2: 1, //电视剧
                7: 1, //综艺
                16: 1, //动漫
                8: 1 //纪录片
            };
            if (v.cid == 24 ) {
                return false;
            }else if(v.isMyTv == undefined && v.cid == 9001){
                v.isMyTv = 1;
            }

            var that = this;
            var from, next, name, playlistId, t, m, s, newTip = '';
            var time = '';
            if (!isPlaying || typeof start != 'undefined') {
                t = isLocal ? v.start : v.t;
                m = t / 60 >> 0;
                s = t % 60;
                // alert(t);
                m = m < 10 ? '0' + m : m;
                s = s < 10 ? '0' + s : s;
                time = '<span class="content-time">已看到</span><span class="realTime">'+m+':'+s+'</span>'
            }
            if (isLocal) { //本地
                // v.isNew = true;
                var isSohu = !!(v.idtype == 107);
                v.isSohu = isSohu;
                v.isLocal = true;
                v.client = 12; //本地播放源均为搜狐影音
                if (v.isSohu) { //站内
                    from = ['<span>搜狐影音</span><span class="content-time">已看到</span><span class="realTime">',m,':',s,'</span>'].join('');
                    if (v.cid == 2) {
                        // alert(v.playlistId)
                        playlistIds.push(v.playlistId); //站内有更新值 电视剧类型
                    }
                } else { //站外
                    from = '来自搜狐视频浏览器';
                }
                next = v.nextVid ? '<a class="l hover-next" href="#" onclick="return false;">&nbsp;&nbsp;&nbsp;播放下集</a>' : '';
                name = escape(v.name).indexOf('%u7B2C') ? v.name : v.albumName + '\u3000' + v.name;
                playlistId = v.playlistId;
                if (v.isNew) {
                    newTip = '<span class="new-tip"></span>';
                }
            } else { //云迹
                if (mold == 1) {
                    // console.log(v.cid, v.title);
                    if (!(v.cid in yingshiMap)) {
                        return true;
                    }
                }
                from = ['<span>',map.clientType[v.client],'</span>',time].join('');
                next = v.nextVid ? '<a class="l hover-next" href="#" onclick="return false;">&nbsp;&nbsp;&nbsp;播放下集</a>' : '';
                name = v.title;
                playlistId = v.sid;
                if (v.cid == 2) {
                    playlistIds.push(v.playlistId); //云迹有更行值
                }
            }

            var clientClass;
            switch ( v.client ){
                case 3:
                case 5:
                case 10:
                    clientClass = 'ico-tel';
                    break;
                case 2:
                case 7:
                case 11:
                    clientClass = 'ico-ipad';
                    break;
                default:
                    clientClass = 'ico-pc';
            }
            var tmp = [
                '<li class="content-wrap" id="',mold ? 'tv' : 'all','_',playlistId,'"  vid="',mold ? 'tv' : 'all','_',v.vid,'">'
                ,'    <h3 class="',clientClass,'"><a class="v-title hover-continue" onclick="return false;" href="#" style="overflow:hidden;white-space:nowrap;text-overflow:ellipsis;width:215px;display:block;" title="',name,'">',name,'</a>',newTip,'</h3>'
                ,'    <p class="hisTip" >'
                ,         from
                ,'        <span class="drama-update"></span>'
                ,'    </p>'
                ,'    <p class="hisHand cfix">'
                ,'        <a class="if-red l" href="#" onclick="return false;">继续播放</a>',next
                ,'        <a href="#" onclick="return false;" class="his-close r"></a>'
                ,'    </p>'
                ,'</li>'
            ];
//            alert(tmp.join(''));
            var tmpS = $(tmp.join(''));
            if (isPlaying) {
                wrap.prepend(tmpS.data('data', v));
            } else {
                wrap.append(tmpS.data('data', v));
            }
            var $title = tmpS.find('.content-top');
            var titleW = $title.find('span').width();
            if (v.isNew && titleW > 200) {
                $title.find('span').width(200);
                $('.new-tip').width(25);
            }
        },
        drawAllTv: function (wrap, data, mold) {
            var that = this;
            var videos = data.videos ? data.videos : [];
            var playlistIds = [];
            var list = [];
            wrap.empty();//首先清空
            if (!videos.length) {
                wrap.html('<p class="nothing">您目前还没有观看过视频节目！</p>');
                return false;
            }
            $.each(videos, function (i, v) {
                v.vid = v.vid || v.id ;
                that.drawAllTvItem(wrap, v, mold, data.isLocal, playlistIds);
            });
            if (!data.isLocal) {
                window.playingType = mold;
                // alert('playing')
                try{
                    window.external.GetPlayingState();
                }catch(e){}
            }
            //云迹的话取正在播放的数据
            if (!playlistIds.length) {
                return false;
            }
            this.getUpdate(playlistIds.join(','),mold);
            $(window).resize();
        },
        getUpdate: function (playlistIds , type) {
            $.ajax({
                url: 'http://pl.hd.sohu.com/playlist_set_status',
                dataType: 'jsonp',
                data: {
                    playlistids: playlistIds
                },
                success: function (ret) {
                    if (ret.status !== 1) {
                        return false;
                    }
                    delete ret.status;
                    $.each(ret, function (i, v) {
                        var videoLastTimeStamp = v.videoLastTimeStamp;
                        var listStatus = v.listStatus;
                        var $el = $('#' + ( type ? 'tv' : 'all') + '_' + i).find('.hisTip>.drama-update');

                        if (listStatus == 0) {//更新中
                            var current = new Date();
                            current.setDate(current.getDate() - current.getDay() +1);
                            current.setHours(0);
                            current = current.getTime();
                            var updateSets = v.updateSets;

                            if (current < videoLastTimeStamp) {
                                $el.html('&nbsp;更新至' + updateSets +'集');
                            } else {
                                $el.html('&nbsp;将更新' + (updateSets + 1) +'集');
                            }
                        } else if (listStatus == 1) {
                            $el.html('&nbsp;' + v.totalSets +'集全');
                        }
                    });
                }
            });
        },
        bindAllTv: function () {
            var that = this;
            var wrap = $('#history_all,#history_tv');
            wrap.delegate('.content-wrap', 'hover', function(event) {
                $(this).toggleClass('hover');
            }).delegate('.hover-continue,.if-red,.hover-next,.his-close', 'click', function(event) { //删除
                var $bt = $(this);
                var clickType;
                if ($bt.hasClass('hover-continue') || $bt.hasClass('if-red')) {
                    clickType = 0; //继续
                } else if ($bt.hasClass('hover-next')) {
                    clickType = 1; //下一集
                } else {
                    clickType = 2; //删除
                }
                that.processClick($bt, clickType);
            }).delegate('.hisHand>.his-close', 'hover', function(event) { //关闭按钮滑过时变色
                $(this).toggleClass('hover');
            });
        },
        processClick: function ($bt, clickType) {
            var $el = $bt.parents('.content-wrap');
            var data = $el.data('data');
            var isLocal = data.isLocal;
            if (isLocal) { //本地记录
                this.processLocal($el, clickType);
            } else { //云迹
                this.processRemote($el, clickType);
            }
        },
        processRemote: function ($el, clickType) { //处理云迹历史记录 操作
            var data = $el.data('data');
            var rec;
            if (clickType == 0) { //继续观看
                try{
                    sohuHD.ifox.play({
                        'vid' : data.vid,
                        'start' : data.t,
                        'isMyTv' : !!data.hType,
                        'version' : data.definition || -1,
                        'playSrc' : 7
                    });
                }catch(e){}
            } else if (clickType == 1) { //下一集
                try{
                    sohuHD.ifox.play({
                        'vid' : data.nextVid,
                        'start' : 0,
                        'isMyTv' : !!data.hType,
                        'version' : data.definition || -1,
                        'playSrc' : 7
                    });
                }catch(e){}
            } else if (clickType == 2) { //删除
                rec = [data.vid, '|', data.sid].join('');
                remoteHandlers.del($el, rec);
            }
        },
        processLocal: function ($el, clickType) { //处理本地历史记录 操作
            var data = $el.data('data');
            var isSohu = data.isSohu;
            var rec;
            var wrap = $el.parent();

            try{
                if (clickType == 0) { //继续观看
                    if (isSohu) { //站内
                        sohuHD.ifox.play({
                            'vid' : data.id,
                            'start' : data.start,
                            'isMyTv' : !!data.isMyTv,
                            'version' : data.definition || -1,
                            'playSrc' : 7
                        });
                    } else { //站外
                        var params = {
                            'vid' : data.id,
                            'rid' : data.playlistId,
                            'domain' : data.domain
                        };
                        try {
                            sohuHD.ifox.oplay(params);
                        } catch (e) {
                            sohuHD.ifox.log(e.message);
                        }
                    }
                } else if (clickType == 1) { //下一集
                    if (isSohu) {
                        sohuHD.ifox.play({
                            'vid' : data.nextVid,
                            'start' : 0,
                            'isMyTv' : !!data.isMyTv,
                            'version' : data.definition || -1,
                            'playSrc' : 7
                        });
                    } else {
                        params = {
                            'uid' : data.nextVid,
                            'rid' : data.playlistId,
                            'domain' : data.domain
                        };
                        try {
                            sohuHD.ifox.oplay(params);
                        } catch (e) {
                            sohuHD.ifox.log(e.message);
                        }
                    }
                } else if (clickType == 2) { //删除
                    params = {
                        'id' : data.id || data.vid,
                        'idtype' : data.idtype
                    };
                    try {
                        window.external.DeleteOnlineHistory(JSON.stringify(params));
                    } catch (e) {
                        sohuHD.ifox.log(e.message);
                    }
                    $el.fadeIn('fast', function() {
                        $el.remove();
                        if (!wrap.children('li').length) {
                            wrap.html('<p class="nothing">您目前还没有观看过视频节目！</p>')
                        }
                    });
                }
            }catch(e){

            }

        },
        allLocal: function (data) {
            var wrap = $('#history_local');

            if (!data.videos || !data.videos.length) {
                wrap.html('<p style="margin-left:-76px;" class="nothing">此处空空如也!<br/>您还没有添加本地播放记录</p>');
                return false;
            }
            wrap.empty();
            $.each(data.videos, function (i, v) {
                var contentWrap;
                var movieTmp = [
                    '<div class="local-wrap local-item cfix">'
                    ,'    <div class="local-title local-c-l tfont" style="margin-left:7px;margin-right:17px;"><a href="#" onclick="return false;" title="',v.name,'">',v.name,'</a></div>'
                    ,'        <div class="local-c-r">'
                    ,'            <a href="#" onclick="return false;" class="his-close" style="display:none"></a>'
                    ,'        </div>'
                    ,'</div>'
                ];
                contentWrap = $(movieTmp.join('')).data('data', v);
                wrap.append(contentWrap);
            });
            // this.bindDownLoad(wrap);
        },
        bindDownLoad: function () {
            var that = this;
            var wrap = $('#history_local');
            wrap.delegate('.local-item', 'hover', function() { //hover
                $(this).toggleClass('hover-grey').find('.his-close').toggle();
            }).delegate('.his-close', 'click', function(event) { //删除
                that.processDownLoadClick($(this), 1);
            }).delegate('.his-close', 'hover', function(event) {
                $(this).toggleClass('hover');
            }).delegate('.local-title>a', 'click', function(event) {
                that.processDownLoadClick($(this), 0);
            });
        },
        processDownLoadClick: function ($bt, type) {
            var item = $bt.parents('.local-wrap');
            var data = item.data('data');

            try{
                var params = {
                    'name' : data.name,
                    'path' : data.path
                };
                if (type == 1) { //删除下载
                    // alert(1)
                    try {
                        window.external.DeleteLocalHistory(JSON.stringify(params));
                    } catch (e) {
                        sohuHD.ifox.log(e.message);
                    }
                    item.fadeIn('fast', function() {
                        item.remove();
                    });
                } else { //播放下载
                    // alert(data.name + '+' + data.path)
                    try {
                        window.external.PlayDownload(JSON.stringify(params));
                    } catch (e) {
                        sohuHD.ifox.log(e.message);
                    }
                }
            }catch(e){}
        }
    };
    window.historyProcessData = function (params) {
        sohuHD.ifox.log('historyProcessData called!, params=' + params);
        try {
            params = $.parseJSON(params);
        } catch (e) {
            sohuHD.ifox.log(e.message);
            return;
        }
        var data = params.data;
        var index = params.index;

        try {
            data.isLocal = true;
            var type = '' + index;//window.type;
            if (data.videos && data.videos.length) {
                data.videos = data.videos.reverse();
            }
            // alert(type);
            switch (type) {
                case '0':
                    // alert(1)
                    process.allTv(data, 0);
                    break;
                case '1':
                    process.allTv(data, 1);
                    break;
                case '2':
                    process.allLocal(data);
                    break;
            }
        } catch (e) {
            // alert(e.message);
        }
    };
    window.processLogin = function (params) {
        try {
            paramsObj = $.parseJSON(params);
        } catch (e) {
            sohuHD.ifox.log(e.message);
            return;
        }
        var isLogin = paramsObj.isLogin;
        if( typeof isLogin == 'undefined'){
            //以前的影音这里有bug，isLogin给的undefined
            //alert('isLoginUndefined : '+passportUtil.getPassport()+', isLogin= '+isLogin);
            foo(window.type, isLogin);
        }else{
            window.getNewPlayHistory(params);
        }
    };
    window.setPlaying = function (params) {
        sohuHD.ifox.log('setPlaygin log--->' + params);
        try {
            params = $.parseJSON(params);
        } catch (e) {
            sohuHD.ifox.log(e.message);
            return;
        }
        var vid = params.id;
        var playlistId = params.playlistId;
        var name = params.name;
        var cid = params.cid;
        var nextVid = params.nextVid;
        var start = params.start;
        var isMyTv = params.type == undefined ? cid == 9001 : params.type == 1;
        var longVideo = params.longVideo == 1;

        if (vid == 0 || !name || cid == 24 ) {
            return false;
        }
        var v = {
            vid: vid,
            id: vid,
            idtype : params.idtype,
            sid: playlistId,
            playlistId: playlistId,
            title: name,
            cid: cid,
            nextVid: nextVid,
            isPlaying: true,
            client: 12,
            start : start,
            t : start,
            isLocal: true,
            isSohu : !!(params.idtype == 107),
            domain : params.domain,
            isMyTv : isMyTv,
            longVideo : longVideo
        };
        var wrap = window.playingType ? $('#history_tv') : $('#history_all');
        var playlistIds = [];

        if(playlistId){
            var vidPosfix = longVideo ? '' : '[vid$="' + vid + '"]';
            $('#tv_'+playlistId + vidPosfix).hide();
            $('#all_'+playlistId + vidPosfix).hide();
        }
        process.drawAllTvItem($('#history_all'), v, 0, false, playlistIds, true , start );
        $('#history_all').find('.nothing').remove();
        process.getUpdate(playlistIds.join(','), 0);
        var yingshiMap = {
            1: 1,//电影
            2: 1, //电视剧
            7: 1, //综艺
            16: 1, //动漫
            8: 1 //纪录片
        };
        if (v.cid in yingshiMap) {
            process.drawAllTvItem($('#history_tv'), v, 1, false, playlistIds, true , start );
            $('#history_tv').find('.nothing').remove();
            process.getUpdate(playlistIds.join(','), 1);
        }
        $(window).resize();
    };
    window.getVrsPlayerHistory = function (params) {
        try {
            params = $.parseJSON(params);
        } catch (e) {
            sohuHD.ifox.log(e.message);
            return;
        }

        var vid = params.vid;
        var plid = params.playlistId;
        var newTime = params.newTime;
        var countTime = params.countTime;
        var vtitle = params.vtitle;
        var accountTime = params.accountTime;
        var type = params.type;
 
        try {
            if ( passportUtil.isLogin() ) {
                var typeStr = (typeof type == 'undefined' ? '' :(type == 0 ? '&type=vrs' : '&type=my' ));
                new Image().src = ['http://his.tv.sohu.com/his/ping.do?passport=', passportUtil.getPassport(), '&c=12&vid=', vid, '&sid=', plid, '&sig=', faultylabs.MD5(passportUtil.getPassport() + vid), '&t=',parseInt(newTime),'&_=',new Date().getTime(), '&account_time=', accountTime , typeStr ].join('');
            }    
        } catch ( eeee ) {
            sohuHD.ifox.log('JS异常:' + eeee.message);
        }

        // var historyUI = sohuHD.historyUI;
        
        var nowTime = new Date().getTime();
        var expires = new Date(nowTime + 7*24*60*60*1000).toUTCString();

        var setCookie = function ( name, value ) {
            if ( name && value ) {
                document.cookie = [name ,'=', value, '; expires=', expires , '; path=/; domain=tv.sohu.com;'].join('');
            }
        };
        var getCookie = function ( name ) {
            return new RegExp('\\b' + name + '\\b=(.*?)(?:$|;)').exec(document.cookie);
        };

        var trim = function ( s ) {
            return s ? s.replace( /^\s+/, '' ).replace( /\s+$/, '' ) : '';
        };
        var record = function ( listInfo ) {
            listInfo = listInfo || [];
            var videolist = listInfo.videos || [];
            var config = function () {
                var config = {
                    vid : vid,
                    plid : plid,
                    newTime : newTime || 0,
                    countTime : countTime || 0,
                    writeThreshold : 0,
                    hs : [],
                    hisSeparator : '^',
                    nameSeparator : ''
                };
                
                var i, len, v;
                for ( i = 0, len = videolist.length; i < len; i++ ) {
                    v = videolist[i];
                    if ( v.vid == vid ) {
                        config.order = v.order || 0;
                        config.url = v.pageUrl || '';
                        config.name = v.name || vtitle;
                        config.vlen = videolist.length;

                        v = videolist[i+1];
                        if (v) {
                            config.nexturl  = v.pageUrl || '';
                            config.nextname = v.name || '';
                        }
                        break;
                    }
                }

                config.simpleName = config.name;

                var regName = /(.*?)([-|\u7b2c|:|\u2014|\uff1a|\u4e4b])/i;
                var nameMatch = regName.exec(config.simpleName);

                if ( nameMatch && nameMatch.length ) {
                    config.simpleName = nameMatch[1];
                    config.nameSeparator = nameMatch[2];
                }

                var hs = getCookie('savehistory');

                if ( hs && hs.length ) {
                    hs = hs[1].split('%2C');
                    var _hs = [];
                    for ( var i = 0; i < hs.length; i++ ) {
                        if ( hs[i] ) {
                            _hs.push( hs[i] );
                        }
                    }
                    config.hs = _hs;
                    //config.hs = hs[1].split('%2C');
                }
                return config;
            }();

            ( function () {
                var h, title, sameAlbum, max = 6, hisArray = [];
                var hs = config.hs;
                var playTime = Math.ceil(config.newTime);
                var url = config.url.split('#')[0] + '#' + playTime;
                var threshold = config.writeThreshold;
                
                for ( var i = 0, len = hs.length; i < len; i++ ) {

                    h = hs[i].split( config.hisSeparator );

                    title = unescape( h[6] );
                    config.nameSeparator && ( title = title.split(config.nameSeparator)[0] );
                    config.simpleName = trim( config.simpleName );
                    title = trim( title );
                    if ( h[0] == config.plid && config.simpleName == title ) {
                        if ( playTime >= threshold ) {
                            sameAlbum = [config.plid, config.vid, config.order, playTime, 0, url, escape(config.name)
                                ,nowTime, config.nexturl, config.countTime].join('^');
                        } else {
                            sameAlbum = hs[i];
                        }
                    } else {
                        hisArray.push(hs[i]);
                    }
                }

                if ( !sameAlbum && playTime >= threshold ) {
                    hisArray.push([config.plid, config.vid, config.order, playTime, 0, url, escape(config.name)
                        ,nowTime, config.nexturl, config.countTime].join('^'));
                }
                
                sameAlbum && hisArray.push( sameAlbum );
                
                while ( hisArray.length > max ) {
                    hisArray.shift();
                }
                hisArray.length && setCookie( 'savehistory', hisArray.join( escape(',') ) );
            } )();
            // if ( historyUI.lastvid != vid ) {
            //     historyUI.lastvid = vid;
            //     historyUI.localPlayingVid = null;
            //     historyUI.remotePlayingVid = null;
            //     historyUI.remoteInited = false;
            //     historyUI.initListUnlogged();
            //     historyUI.initListLogged();
            // }
            // toGetPlayingState();
        };
        window.cache = window.cache || [];
        if ( window.cache[ '' + plid ] && window.cache[ '' + plid ].videos ) {
            record( window.cache[ '' + plid ] );
        } else {
            if(plid == 0) {
                return; 
            }
            ( function ( token ) {
                $.get('http://pl.hd.sohu.com/videolist?playlistid='+plid+'&pagenum=1&pagesize=10000',function(data){
                    if(token != gid){
                        return;
                    }
                    window.cache[''+plid] = data ||{};
                    record( window.cache[ '' + plid ] );
                },'jsonp');
            })( ++gid );
        }
    };

    // 设置主题接口
    window.setTheme = function ( params ) {
        try {
            params = $.parseJSON(params);
        } catch (e) {
            sohuHD.ifox.log(e.message);
            return;
        }
        var color = params.color;

        var themes = {
            'black' : 'blackNav',
            'white' : 'whiteNav'
        };
        var className = themes[color];
        if (className) {
            $('#leftNav').attr('class', className);
        }
    };

    function foo(index, isLogin) {
        if(typeof isLogin == 'undefined') {
            isLogin = passportUtil.isLogin();
        }

        if (index == 2) { //本地
            // var data;
            try{
                window.external.GetHistory(JSON.stringify({'index':index}));
            }catch(e){
                sohuHD.ifox.log(e.message);
            }
        } else { //全部 影视
            if (Number(isLogin)) {
                var passport = passportUtil.getPassport();
                $.ajax({
                    url: 'http://his.tv.sohu.com/his/get.do',
                    dataType: 'jsonp',
                    data: {
                        videotype: 2,
                        pagesize: 60,
                        passport: passport,
                        encode: 'utf-8'
                    },
                    success: function (ret) {
                        if (ret.status == 1) {
                            process.allTv(ret, index);
                            // 优化：刷新页面时两次一模一样的请求优化成一个
                            if (1 == index) {
                                process.allTv(ret, 0);
                            }
                        }
                    }
                });
            } else {
                try{
                    window.external.GetHistory(JSON.stringify({'index':index}));
                }catch(e){
                    sohuHD.ifox.log(e.message);
                }
            }
        }
    }
    // window.onerror = function (a,b,c) {
    //     alert(a)
    //     alert(b)
    //     alert(c)c
    // };
    $(function () { //程序入口
        var tabs = $('.hisTab>a');
        var boxs = $('.hisList>ul');
        sohuHD.switchTab(tabs, {
            'event': 'click',
            'boxs': boxs,
            'cssName': 'on',
            'start': 0,
            'callback': function (bt, box) {
                var bt$ = bt instanceof $ ? bt : $(bt);
                var type = bt$.index();
                if (type == 0) {
                    type = 1;
                } else if (type == 1) {
                    type = 0;
                }

                window.type = type;
                window.currentBox = box;

                $(window).resize();
            }
        });
        process.bindAllTv();
        process.bindDownLoad();

        $(document).bind('contextmenu', function () {
            return false;
        });
        $(document).bind('selectstart', function () {
            return false;
        });

        InitScroller();
    });

    window.DeleteAllHistory =  function () {
        var type = window.type;
        var isLogin = passportUtil.isLogin();
        if (isLogin) {
            if (type == 2) {
                try {
                    window.external.DeleteAllHistory(JSON.stringify({'type':type}));
                } catch (e) {
                    sohuHD.ifox.log(e.message);
                }
            } else {
                try {
                    if ( $( '#hiddenPostFrame' ).length == 0 ) {
                        $('body').append('<iframe name="hiddenPostFrame" id="hiddenPostFrame" style="display:none;"></iframe>');
                    }
                    if( $('#hiddenPostForm').length == 0 ) {
                        $('body').append(['<form id="hiddenPostForm" method="post" target="hiddenPostFrame"',
                                ' action="',map.clearUrl,'"></form>'].join(''));
                    }
                    $('#hiddenPostForm')[0].submit();
                }catch(e){}
            }
        } else {
            try {
                window.external.DeleteAllHistory(JSON.stringify({'type':type}));
            } catch (e) {
                sohuHD.ifox.log(e.message);
            }
        }
        var currentBox$ = currentBox instanceof $ ? currentBox : $(currentBox);
        if (type == 0 || type == 1) {
            currentBox$.html('<p class="nothing">您目前还没有观看过视频节目！</p>');
        } else {
            currentBox$.html('<p style="margin-left:-76px;" class="nothing">此处空空如也!<br/>您还没有添加本地播放记录</p>');
        }
    };

    window.getNewPlayHistory = function( params ){
        sohuHD.ifox.log('getNewPlayHistory called!, params=' + params);
        try {
            params = $.parseJSON(params);
        } catch (e) {
            sohuHD.ifox.log(e.message);
            return;
        }

        if (params && params.isLogin) {
            var i = 1;
        } else {
            i = 0;
        }
        for( i; i < 3 ; i ++){
            foo( i , params.isLogin );
        }
    };
    window.getNewPlayHistory( JSON.stringify( { 'isLogin' : passportUtil.isLogin() } ) );
})(window);
