/* 
 * 初始化滚动条
 * Author: Qianyoushi(youshiqian@sohu-inc.com)
 */

var SCROLLBAR_MIN_HEIGHT = 20;

// Main init method
var InitScroller = function (config, that /*optional*/) {
    var defaultConfig = {
        contentClass : 'leftNav',
        wrapperID : 'leftNav',
        barWrapperClass : 'scroll',
        barClass : 'scroll-bar',
        pathClass : 'scroll-bg',
        innerBarClass: 'scroll-barBot',
        autoAdaptWidth: false,
        //theme: 'white',
        marginTop:0         // scroll bar margin-top pixels, for fixed div
    };
    
    defaultConfig = $.extend(defaultConfig, config);

    if (that) {
        that.config = defaultConfig;
    }

    $('body').attr('scroll', 'no');
    // Create the html elements of wrapper if needed.
    if (0 == $('#' + defaultConfig.wrapperID).length) {
        // To avoid reduplicate xhrs (such as <script> tag), use DOM instead of jQuery. 
        var wrapperDiv = document.createElement('div');
        wrapperDiv.setAttribute('id', defaultConfig.wrapperID);
        //wrapperDiv.className = defaultConfig.theme + 'Nav';
        var contentDiv = document.createElement('div');
        contentDiv.className = defaultConfig.contentClass;
        var body = document.body;
        while(body.childNodes.length) {
            contentDiv.appendChild(body.childNodes[0]);
        }
        wrapperDiv.appendChild(contentDiv);
        body.appendChild(wrapperDiv);
    } // else {
    //    var wrapper$ = $('#' + defaultConfig.wrapperID);
    //    if (!wrapper$.hasClass('blackNav') && !wrapper$.hasClass('whiteNav')) {
    //        wrapper$.addClass(defaultConfig.theme + 'Nav');
    //    }
    //}
    // Create the html elements of scroller.
    if (0 == $('.' + defaultConfig.barClass).length) {
        var scrollBarTpl = '\
            <div class="scroll" style="z-index:998">\
                <div class="scroll-bg"></div>\
                <div class="scroll-bar">\
                    <div class="scroll-barBot"></div>\
                </div>\
            </div>';
       var scrollBar$ = $(scrollBarTpl);
       $('#' + defaultConfig.wrapperID).append(scrollBar$);
    }
    // load css file when needed
    var leftCssloaded = false;
    $('head > link').each(function(index) {
        var this$ = $(this);
        if (this$.attr('type') == 'text/css' && this$.attr('href').indexOf('ifox/v5/left.css') > -1) {
            leftCssloaded = true;
        }
    });
    if (!leftCssloaded) {
        $('<link/>', {
           rel: 'stylesheet',
           type: 'text/css',
           href: 'http://css.tv.itc.cn/ifox/v5/scroller.css'
        }).appendTo('head');
    }

    var content$ = $('.' + defaultConfig.contentClass);
    var wrapper$ = $('#' + defaultConfig.wrapperID);
    var barWrapper$ = $('.' + defaultConfig.barWrapperClass);
    var bar$ = $('.' + defaultConfig.barClass);
    var path$ = $('.' + defaultConfig.pathClass);
    var innerBar$ = $('.' + defaultConfig.innerBarClass);

    var ScrollMaxTop, LastContentHeight, LastWindowHeight;

    var lastScrolled = 0;
    var scrollHandler = function() {
        if (LastContentHeight === LastWindowHeight) return;
        var scrolled = content$.scrollTop();
        var top = scrolled * ScrollMaxTop / (LastContentHeight - LastWindowHeight);
        top += 'px';
        bar$.css('top', top);

        if (0 == scrolled && lastScrolled > 0) {
            content$.trigger('attop.scroller');
        } else if (0 == lastScrolled && scrolled > 0) {
            content$.trigger('leavetop.scroller');
        }
        lastScrolled = scrolled;
    };

    // Auto adapt width of wrapper
    if (defaultConfig.autoAdaptWidth) {
        wrapper$.css('width', '100%');
        content$.css('width', '100%');
    }

    var delayAdjust;
    var retrieveTimes = 0;
    var adjustScrollBar = function() {
        var windowHeight = $(window).height();
        var contentHeight = content$.prop('scrollHeight');
        if (windowHeight == LastWindowHeight && contentHeight == LastContentHeight) {
            retrieveTimes = 0;
            return;
        } else if (contentHeight === windowHeight && retrieveTimes <= 5) {
            /* 
             * 在IE7 下，有时在浏览器重新渲染时会暂时导致scrollHeight不正确，
             * 取到的值和windowHeight一致，所以延时再取，最多取5次
             * 目前发现在替换body的className时会造成上述情况，即使className相同
             */
            if (delayAdjust) {
                clearTimeout(delayAdjust);
            }
            delayAdjust = setTimeout(adjustScrollBar, 120);
            retrieveTimes++;
            return;
        } else {
            retrieveTimes = 0;
            if (windowHeight != LastWindowHeight) {
                wrapper$.css('height', windowHeight);
                content$.css('height', windowHeight);
                barWrapper$.css('height', windowHeight - defaultConfig.marginTop);
                path$.css('height', windowHeight);
            }

            LastContentHeight = contentHeight;
            LastWindowHeight = windowHeight;
        }

        contentHeight = content$.prop('scrollHeight');
        if (contentHeight > windowHeight) {
            windowHeight -= defaultConfig.marginTop;        // sub the margin-top
            var ratio = windowHeight / contentHeight;
            var barHeight = windowHeight * ratio;
            if (barHeight < SCROLLBAR_MIN_HEIGHT) {
                barHeight = SCROLLBAR_MIN_HEIGHT;
            }
            ScrollMaxTop = windowHeight - barHeight - 1;
            barWrapper$.show();
            bar$.css('height', barHeight + 'px');
            innerBar$.css('height', (barHeight - 2) + 'px');
            scrollHandler();
        } else {
            barWrapper$.hide();
        }
    };
    $(window).resize(adjustScrollBar);
    adjustScrollBar();

    bar$.css('top', '0');

    content$.on('scroll', scrollHandler);
    
    // Handle the marginTop option
    defaultConfig.marginTop = parseInt(defaultConfig.marginTop);
    if (defaultConfig.marginTop) {
        barWrapper$.css('margin-top', defaultConfig.marginTop);
    }
    // Handle scroll on the fixed div
    if (content$.children('div.header,div.hisTab').length > 0) {
        if (!defaultConfig.marginTop) {
            content$.children('div.header,div.hisTab').on('mousewheel', function(e){
                var delta = e.originalEvent.wheelDelta;
                content$.scrollTop(content$.scrollTop() - delta / 3);
                scrollHandler();
            });
        }
    }

    bar$.on('mousedown', function(event) {
        var lastClientY = event.clientY;
        var offset = parseInt(bar$.css('top'));

        var count = 0;
        var moveHandler = function(event) {
            var movement = event.clientY - lastClientY;
            count++;
            if(1 == count % 2) {
                return;
            }
            if (0 == movement) { 
               return;
            }
            var newTop = offset + movement;
            if (newTop < 0) newTop = 0; 
            if (newTop > ScrollMaxTop) newTop = ScrollMaxTop;
            
            bar$.css('top', newTop + 'px');
            var scrollTopValue = (LastContentHeight - LastWindowHeight ) * newTop / ScrollMaxTop;
            content$.scrollTop(scrollTopValue);

            if ( event.stopPropagation ){
                event.stopPropagation();
            }
            else if ( event.cancleBubble ) {
                event.cancleBubble = true;
            }
            event.preventDefault();
        };

        var upHandler = function(event) {
            if (document.addEventListener) {
                $(document).off('mousemove');
                $(document).off('mouseup');
            } else if (document.attachEvent) {
                bar$.off('mousemove');
                bar$.off('mousup');
                bar$.off('losecapture');
                document.releaseCapture();
            }
            if ( event.stopPropagation ){
                event.stopPropagation();
            }
            else if ( event.cancleBubble ) {
                event.cancleBubble = true;
            }
            event.preventDefault();
        };

        if (document.addEventListener) {
            $(document).on('mousemove', moveHandler);
            $(document).on('mouseup', upHandler);
        } else if (document.attachEvent) {
            bar$[0].setCapture();
            bar$.on('mousemove', moveHandler);
            bar$.on('mouseup', upHandler);
            bar$.on('losecapture', upHandler);
        }
        event.preventDefault();
        event.stopPropagation();
    });
};

/*
 * Constructor 
 */

function FakeScroller(config) {
    InitScroller(config, this);
}

FakeScroller.prototype = {
    setTheme : function(theme) {
        document.body.className = theme + 'Body';
    }
};
