/*
 * Decompiled with CFR 0.152.
 */
package georgetsak.opcraft.entities.meramera;

import georgetsak.opcraft.misc.OPUtils;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityFireFist
extends EntityFlying {
    private double x;
    private double y;
    private double z;
    private double startY;
    private double scale;
    private float yaw;
    private float pitch;
    private int type = 0;
    private Vec3d direction = new Vec3d(0.0, 0.0, 0.0);
    private EntityPlayer ep;
    private Random r = new Random();

    public EntityFireFist(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityFireFist(World worldIn, double x, double y, double z, float yaw, float pitch, EntityPlayer owner, int type) {
        this(worldIn);
        this.type = type;
        this.ep = owner;
        this.x = x;
        this.y = this.startY = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.direction = OPUtils.convertRotation(yaw, pitch);
        this.scale = this.getScale(this.type);
        this.func_70080_a(x, y, z, yaw, pitch);
        this.func_70105_a(0.5f, 0.5f);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70764_aw <= (float)this.getMaxDistance("x") && Math.abs(this.startY - this.field_70163_u) <= (double)this.getMaxDistance("y")) {
            this.field_70159_w = this.direction.field_72450_a * this.scale;
            this.field_70181_x = this.direction.field_72448_b * this.scale;
            this.field_70179_y = this.direction.field_72449_c * this.scale;
        }
    }

    public void func_70071_h_() {
        boolean flag1;
        super.func_70071_h_();
        this.spawnParticles();
        boolean bl = flag1 = this.type != 1 && this.type != 0;
        if (this.field_70132_H && flag1) {
            this.field_70170_p.func_72885_a((Entity)this.ep, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getExplosionSize(), true, true);
            this.func_70106_y();
        }
        if (this.type != 0 && this.field_70173_aa >= this.getLifetime()) {
            this.func_70106_y();
        }
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (this.ep != entityIn && this.ep != null && this.type != 0) {
            entityIn.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.ep), OPUtils.damageCalculation(entityIn, this.getDamageValue()));
            entityIn.func_70015_d(this.getFireTimeValue());
        }
    }

    public void func_82167_n(Entity entityIn) {
        if (entityIn instanceof EntityLiving && this.type != 0) {
            entityIn.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.ep), this.getDamageValue());
            entityIn.func_70015_d(this.getFireTimeValue());
        }
    }

    private void spawnParticles() {
        for (int i = 0; i < 25; ++i) {
            double offsetX = ((double)this.r.nextInt(20) + 1.0 - 10.0) / 20.0;
            double offsetY = ((double)this.r.nextInt(20) + 1.0 - 10.0) / 20.0 + 0.5;
            double offsetZ = ((double)this.r.nextInt(20) + 1.0 - 10.0) / 20.0;
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + offsetX, this.field_70163_u + offsetY, this.field_70161_v + offsetZ, 0.0, 0.0, 0.0, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + offsetX, this.field_70163_u + offsetY, this.field_70161_v + offsetZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private int getLifetime() {
        switch (this.type) {
            case 1: {
                return 80;
            }
            case 2: {
                return 80;
            }
            case 3: {
                return 160;
            }
            case 4: {
                return 60;
            }
        }
        return 0;
    }

    private float getExplosionSize() {
        switch (this.type) {
            case 1: {
                return 0.0f;
            }
            case 2: {
                return 1.5f;
            }
            case 3: {
                return 2.0f;
            }
            case 4: {
                return 4.0f;
            }
        }
        return 0.0f;
    }

    private int getFireTimeValue() {
        switch (this.type) {
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 10;
            }
        }
        return 0;
    }

    private float getDamageValue() {
        switch (this.type) {
            case 1: {
                return 3.0f;
            }
            case 2: {
                return 7.0f;
            }
            case 3: {
                return 5.0f;
            }
            case 4: {
                return 10.0f;
            }
        }
        return 0.0f;
    }

    private int getMaxDistance(String string) {
        if (string.equals("x")) {
            switch (this.type) {
                case 1: {
                    return 70;
                }
                case 2: {
                    return 60;
                }
                case 3: {
                    return 200;
                }
                case 4: {
                    return 100;
                }
            }
        }
        if (string.equals("y")) {
            switch (this.type) {
                case 1: {
                    return 40;
                }
                case 2: {
                    return 40;
                }
                case 3: {
                    return 100;
                }
                case 4: {
                    return 60;
                }
            }
        }
        return 0;
    }

    private double getScale(int type2) {
        switch (this.type) {
            case 1: {
                return 1.0;
            }
            case 2: {
                return 1.0;
            }
            case 3: {
                return 1.5;
            }
            case 4: {
                return 3.5;
            }
        }
        return 0.0;
    }

    public void func_70108_f(Entity entityIn) {
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public boolean func_180431_b(DamageSource source) {
        return true;
    }

    public float getDistanceMoved() {
        return this.field_70764_aw;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }
}

