/*
 * Decompiled with CFR 0.152.
 */
package georgetsak.opcraft.misc.capabilities.stats.normal;

import georgetsak.opcraft.misc.OPUtils;
import georgetsak.opcraft.misc.capabilities.stats.normal.IStatsNormalCap;
import georgetsak.opcraft.misc.capabilities.stats.normal.StatsNormalCapProvider;
import georgetsak.opcraft.network.PacketDispatcher;
import georgetsak.opcraft.network.packets.StatsNormalPacket;
import georgetsak.opcraft.network.packets.StatsNormalServerPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class StatsNormalCap
implements IStatsNormalCap {
    int health = 0;
    int attack = 0;
    int defence = 0;
    int speed = 0;

    @Override
    public void setHealthLevel(int level) {
        this.health = level;
    }

    @Override
    public void setAttackLevel(int level) {
        this.attack = level;
    }

    @Override
    public void setDefenceLevel(int level) {
        this.defence = level;
    }

    @Override
    public void setSpeedLevel(int level) {
        this.speed = level;
    }

    @Override
    public int getHealthLevel() {
        return this.health;
    }

    @Override
    public int getAttackLevel() {
        return this.attack;
    }

    @Override
    public int getDefenceLevel() {
        return this.defence;
    }

    @Override
    public int getSpeedLevel() {
        return this.speed;
    }

    @Override
    public int getUpgradeCost(int statID) {
        switch (statID) {
            case 1: {
                return 10 + this.health * 2;
            }
            case 2: {
                return 15 + this.attack * 4;
            }
            case 3: {
                return 15 + this.defence * 4;
            }
            case 4: {
                return 10 + this.speed * 2;
            }
        }
        return 0;
    }

    @Override
    public boolean canUpgrade(int statID, EntityPlayer entityPlayer) {
        int xp = entityPlayer.field_71068_ca;
        switch (statID) {
            case 1: {
                return this.health < 10 && xp >= this.getUpgradeCost(1);
            }
            case 2: {
                return this.attack < 10 && xp >= this.getUpgradeCost(2);
            }
            case 3: {
                return this.defence < 10 && xp >= this.getUpgradeCost(3);
            }
            case 4: {
                return this.speed < 10 && xp >= this.getUpgradeCost(4);
            }
        }
        return false;
    }

    @Override
    public void resetAll() {
        this.setHealthLevel(0);
        this.setAttackLevel(0);
        this.setDefenceLevel(0);
        this.setSpeedLevel(0);
    }

    public static IStatsNormalCap get(EntityPlayer player) {
        return (IStatsNormalCap)player.getCapability(StatsNormalCapProvider.SN_CAP, null);
    }

    @Override
    public void updateToSever(IStatsNormalCap stats) {
        PacketDispatcher.sendToServer(new StatsNormalServerPacket(stats));
    }

    @Override
    public void copy(IStatsNormalCap old_ns, EntityPlayer ep) {
        this.setHealthLevel(old_ns.getHealthLevel());
        this.setAttackLevel(old_ns.getAttackLevel());
        this.setDefenceLevel(old_ns.getDefenceLevel());
        this.setSpeedLevel(old_ns.getSpeedLevel());
        OPUtils.updateStats(ep, this);
        PacketDispatcher.sendTo(new StatsNormalPacket(old_ns), (EntityPlayerMP)ep);
    }
}

