/*
 * Decompiled with CFR 0.152.
 */
package georgetsak.opcraft.network.packets;

import georgetsak.opcraft.entities.gomugomuno.EntityLuffyPistol;
import georgetsak.opcraft.entities.hiehie.EntityIcePhoenix;
import georgetsak.opcraft.entities.hiehie.EntityIceSaber;
import georgetsak.opcraft.entities.meramera.EntityEntei;
import georgetsak.opcraft.entities.meramera.EntityFireFist;
import georgetsak.opcraft.entities.nikyu.EntityUrsusBubble;
import georgetsak.opcraft.entities.noronoro.EntitySlowBeam;
import georgetsak.opcraft.entities.noronoro.EntitySlowBeamSpawner;
import georgetsak.opcraft.main.OPCraft;
import georgetsak.opcraft.main.Registry.OPBlocks;
import georgetsak.opcraft.misc.OPSoundEvent;
import georgetsak.opcraft.misc.OPUtils;
import georgetsak.opcraft.network.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class OPMessage
extends AbstractMessage<OPMessage> {
    private String text = null;

    public OPMessage() {
    }

    public OPMessage(String text) {
        this.text = text;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.text = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.text);
    }

    @Override
    public void process(EntityPlayer ep, Side side) {
        if (side.isServer()) {
            RayTraceResult rayTraceResult;
            EntityFlying e;
            EntityFlying esb;
            EntityFireFist eff;
            EntityLuffyPistol elp;
            int multiplier = OPCraft.config.cooldownSpeed;
            World world = ep.func_184102_h().func_130014_f_();
            if (this.text.contains("GomuPistolA")) {
                elp = new EntityLuffyPistol(world, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, ep, false);
                world.func_72838_d((Entity)elp);
                world.func_184148_a((EntityPlayer)null, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, OPSoundEvent.gomu_stretch, SoundCategory.NEUTRAL, 10.0f, 1.0f);
            }
            if (this.text.contains("GomuGear2A")) {
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.gomu_gear2, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                ep.func_70690_d(new PotionEffect(MobEffects.field_76424_c, (int)(10.0f * (float)multiplier), 2));
                ep.func_70690_d(new PotionEffect(MobEffects.field_76420_g, (int)(10.0f * (float)multiplier), 1));
                ep.func_70690_d(new PotionEffect(MobEffects.field_76430_j, (int)(10.0f * (float)multiplier), 1));
                ep.func_70690_d(new PotionEffect(MobEffects.field_76428_l, (int)(10.0f * (float)multiplier), 1));
                for (int i = 0; i < 50; ++i) {
                    Minecraft.func_71410_x().field_71441_e.func_175688_a(EnumParticleTypes.SMOKE_LARGE, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v, (Math.random() - 0.5) * 0.2, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.2, new int[0]);
                }
            }
            if (this.text.contains("GomuGear3A")) {
                elp = new EntityLuffyPistol(world, ep.field_70165_t, ep.field_70163_u + 0.5, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, ep, true);
                world.func_72838_d((Entity)elp);
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.gomu_stretch, SoundCategory.NEUTRAL, 10.0f, 1.0f);
            }
            if (this.text.contains("GomuGear4A")) {
                ep.func_70690_d(new PotionEffect(MobEffects.field_76420_g, (int)(20.0f * (float)multiplier), 2));
                ep.func_70690_d(new PotionEffect(MobEffects.field_76424_c, (int)(20.0f * (float)multiplier), 2));
                ep.func_70690_d(new PotionEffect(MobEffects.field_76428_l, (int)(20.0f * (float)multiplier), 2));
            }
            if (this.text.contains("MeraHiganA")) {
                eff = new EntityFireFist(world, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, ep, 1);
                world.func_72838_d((Entity)eff);
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.fire_fist, SoundCategory.NEUTRAL, 10.0f, 1.0f);
            }
            if (this.text.contains("MeraShinkaA")) {
                world.func_72838_d((Entity)new EntityFireFist(world, ep.field_70165_t, ep.field_70163_u + 2.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, ep, 2));
                world.func_72838_d((Entity)new EntityFireFist(world, ep.field_70165_t + 0.5, ep.field_70163_u + 0.5 + 2.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, ep, 2));
                world.func_72838_d((Entity)new EntityFireFist(world, ep.field_70165_t, ep.field_70163_u + 0.5 + 2.0, ep.field_70161_v + 1.0, ep.field_70177_z, ep.field_70125_A, ep, 2));
                world.func_72838_d((Entity)new EntityFireFist(world, ep.field_70165_t - 0.5, ep.field_70163_u - 0.5 + 2.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, ep, 2));
                world.func_72838_d((Entity)new EntityFireFist(world, ep.field_70165_t, ep.field_70163_u - 0.5 + 2.0, ep.field_70161_v - 1.0, ep.field_70177_z, ep.field_70125_A, ep, 2));
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.fire_fist, SoundCategory.NEUTRAL, 10.0f, 1.0f);
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.fire_fist, SoundCategory.NEUTRAL, 10.0f, 1.0f);
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.fire_fist, SoundCategory.NEUTRAL, 10.0f, 1.0f);
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.fire_fist, SoundCategory.NEUTRAL, 10.0f, 1.0f);
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.fire_fist, SoundCategory.NEUTRAL, 10.0f, 1.0f);
            }
            if (this.text.contains("MeraHikenA")) {
                eff = new EntityFireFist(world, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, ep, 4);
                world.func_72838_d((Entity)eff);
            }
            if (this.text.contains("MeraEnteiA")) {
                EntityEntei ee = new EntityEntei(world, ep.field_70165_t, ep.field_70163_u + 5.0, ep.field_70161_v, ep);
                world.func_72838_d((Entity)ee);
                world.func_184148_a((EntityPlayer)null, ep.field_70165_t, ep.field_70163_u + 5.0, ep.field_70161_v, OPSoundEvent.entei_charge, SoundCategory.NEUTRAL, 15.0f, 1.0f);
            }
            if (this.text.contains("SlowBeamA")) {
                esb = new EntitySlowBeam(world, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, ep);
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.slow_beam, SoundCategory.NEUTRAL, 10.0f, 1.0f);
                world.func_72838_d((Entity)esb);
            }
            if (this.text.contains("SlowBallA")) {
                esb = new EntitySlowBeamSpawner(world, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, ep, true, 60, 10);
                world.func_72838_d((Entity)esb);
            }
            if (this.text.contains("SlowMashiA")) {
                esb = new EntitySlowBeamSpawner(world, ep.field_70165_t, ep.field_70163_u + 0.5, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, ep, false, 120, 5);
                world.func_72838_d((Entity)esb);
            }
            if (this.text.contains("ClearSkatingA")) {
                ep.func_70690_d(new PotionEffect(MobEffects.field_76441_p, (int)(25.0f * (float)multiplier), 0));
            }
            if (this.text.contains("RoomA")) {
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.dome_appear, SoundCategory.NEUTRAL, 40.0f, 1.0f);
                world.func_175656_a(new BlockPos(ep.func_180425_c().func_177958_n(), ep.func_180425_c().func_177956_o(), ep.func_180425_c().func_177952_p()), OPBlocks.BlockLawDomeCenter.func_176223_P());
            }
            if (this.text.contains("Shambles")) {
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.shambles, SoundCategory.NEUTRAL, 40.0f, 1.0f);
                OPMessage.OPShambles(ep);
            }
            if (this.text.contains("InjectionShot")) {
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.shambles, SoundCategory.NEUTRAL, 40.0f, 1.0f);
                OPMessage.OPInjectionShot(ep);
            }
            if (this.text.contains("Takt")) {
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.takt, SoundCategory.NEUTRAL, 40.0f, 1.0f);
                OPMessage.OPTakt(ep);
            }
            if (this.text.contains("IceSaberA")) {
                OPMessage.destroyNearbyCropsAndGrass(ep, 5);
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.ice_saber, SoundCategory.NEUTRAL, 20.0f, 1.0f);
                e = new EntityIceSaber(world, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, ep);
                EntityIceSaber e1 = new EntityIceSaber(world, ep.field_70165_t, ep.field_70163_u + 2.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, ep);
                EntityIceSaber e2 = new EntityIceSaber(world, ep.field_70165_t + 1.0, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, ep);
                EntityIceSaber e3 = new EntityIceSaber(world, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v + 1.0, ep.field_70177_z, ep.field_70125_A, ep);
                EntityIceSaber e4 = new EntityIceSaber(world, ep.field_70165_t - 1.0, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, ep);
                EntityIceSaber e5 = new EntityIceSaber(world, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v - 1.0, ep.field_70177_z, ep.field_70125_A, ep);
                world.func_72838_d((Entity)e);
                world.func_72838_d((Entity)e1);
                world.func_72838_d((Entity)e2);
                world.func_72838_d((Entity)e3);
                world.func_72838_d((Entity)e4);
                world.func_72838_d((Entity)e5);
            }
            if (this.text.contains("IceBallA")) {
                // empty if block
            }
            if (this.text.contains("IceAgeA")) {
                OPMessage.createIceSeaRoad(ep.func_174811_aO(), new BlockPos(ep.field_70165_t, ep.field_70163_u, ep.field_70161_v), ep);
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.ice_age, SoundCategory.NEUTRAL, 50.0f, 1.0f);
            }
            if (this.text.contains("IceBlockPhBeakA")) {
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.ice_phoenix, SoundCategory.NEUTRAL, 20.0f, 1.0f);
                e = new EntityIcePhoenix(world, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, ep);
                world.func_72838_d((Entity)e);
            }
            if (this.text.contains("PadHoA")) {
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.pad_ho, SoundCategory.NEUTRAL, 15.0f, 1.0f);
                OPMessage.damageNearbyPlayers(ep, 15, 6.0f, 0.2f);
            }
            if (this.text.contains("TsuppariPadHoA")) {
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.pad_ho, SoundCategory.NEUTRAL, 30.0f, 1.0f);
                OPMessage.damageNearbyPlayers(ep, 30, 12.0f, 0.5f);
            }
            if (this.text.contains("UrsusShockA")) {
                e = new EntityUrsusBubble(world, ep.field_70165_t, ep.field_70163_u + 1.0, ep.field_70161_v, ep.field_70177_z, ep.field_70125_A, ep);
                world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), OPSoundEvent.ursus_shock, SoundCategory.NEUTRAL, 90.0f, 1.0f);
                world.func_72838_d((Entity)e);
            }
            if (this.text.contains("ElThorA") && (rayTraceResult = ep.func_174822_a(300.0, 1.0f)) != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos spawnPosition = rayTraceResult.func_178782_a();
                double x = spawnPosition.func_177958_n();
                double y = spawnPosition.func_177956_o();
                double z = spawnPosition.func_177952_p();
                for (int i = 0; i < 6; ++i) {
                    EntityLightningBolt lightningBolt = new EntityLightningBolt(world, x, y, z, false);
                    world.func_72942_c((Entity)lightningBolt);
                }
            }
            if (this.text.contains("SangoA")) {
                OPMessage.createLightnings(ep, 150, 80.0);
            }
            if (this.text.contains("DeathpieaA")) {
                OPMessage.createLightnings(ep, 400, 100.0);
            }
            if (OPCraft.config.enableSideEffects) {
                if (this.text.contains("GomuGear2B")) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)(5.0f * (float)multiplier), 1));
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(5.0f * (float)multiplier), 1));
                    world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), SoundEvents.field_187646_bt, SoundCategory.NEUTRAL, 3.0f, 1.0f);
                }
                if (this.text.contains("GomuGear3B")) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)(10.0f * (float)multiplier), 1));
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(10.0f * (float)multiplier), 2));
                }
                if (this.text.contains("GomuGear4B")) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(17.0f * (float)multiplier), 2));
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)(17.0f * (float)multiplier), 1));
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76438_s, (int)(17.0f * (float)multiplier), 1));
                    world.func_184133_a((EntityPlayer)null, ep.func_180425_c(), SoundEvents.field_187646_bt, SoundCategory.NEUTRAL, 3.0f, 1.0f);
                }
                if (this.text.contains("MeraShinkaB")) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(8.0f * (float)multiplier), 0));
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)(8.0f * (float)multiplier), 0));
                }
                if (this.text.contains("MeraHikenB")) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(8.0f * (float)multiplier), 1));
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)(8.0f * (float)multiplier), 1));
                }
                if (this.text.contains("MeraEnteiB")) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(19.0f * (float)multiplier), 2));
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)(19.0f * (float)multiplier), 2));
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76438_s, (int)(19.0f * (float)multiplier), 0));
                }
                if (this.text.contains("SlowBallB")) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(15.0f * (float)multiplier), 0));
                }
                if (this.text.contains("SlowMashiB")) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(15.0f * (float)multiplier), 0));
                }
                if (this.text.contains("IceBallB")) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(10.0f * (float)multiplier), 0));
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)(10.0f * (float)multiplier), 0));
                }
                if (this.text.contains("IceBlockPhBeakB")) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(10.0f * (float)multiplier), 0));
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)(10.0f * (float)multiplier), 0));
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76438_s, (int)(10.0f * (float)multiplier), 1));
                }
                if (this.text.contains("TsuppariPadHoB")) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(5.0f * (float)multiplier), 1));
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)(5.0f * (float)multiplier), 0));
                }
                if (this.text.contains("UrsusShockB")) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(20.0f * (float)multiplier), 2));
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)(20.0f * (float)multiplier), 2));
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76438_s, (int)(20.0f * (float)multiplier), 2));
                }
                if (this.text.contains("SangoB")) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(4.0f * (float)multiplier), 1));
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)(4.0f * (float)multiplier), 1));
                }
                if (this.text.contains("DeathpieaB")) {
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(15.0f * (float)multiplier), 2));
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)(15.0f * (float)multiplier), 2));
                    ep.func_70690_d(new PotionEffect(MobEffects.field_76438_s, (int)(15.0f * (float)multiplier), 2));
                }
            }
            if (this.text.contains("DISABLEDAMAGE")) {
                ep.func_184224_h(true);
            }
            if (this.text.contains("ENABLEDAMAGE")) {
                ep.func_184224_h(false);
            }
            if (this.text.contains("KairosekiItem")) {
                ep.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20, 3));
                ep.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 20, 1));
            }
        }
    }

    static void createLightnings(EntityPlayer ep, int repeatTimes, double radius) {
        double x = ep.field_70165_t;
        double z = ep.field_70161_v;
        Random r = new Random();
        double x1 = x - radius;
        double x2 = x + radius;
        double y1 = ep.field_70163_u - 20.0;
        double y2 = ep.field_70163_u + 20.0;
        double z1 = z - radius;
        double z2 = z + radius;
        World world = ep.func_184102_h().func_130014_f_();
        List entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(x1, y1, z1, x2, y2, z2));
        List players = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(x1, y1, z1, x2, y2, z2));
        for (int i = 0; i < repeatTimes; ++i) {
            if (r.nextInt(20) == 1) {
                EntityLiving entity;
                if (r.nextBoolean()) {
                    int num = r.nextInt(entities.size());
                    if (!(entities.get(num) instanceof EntityLiving)) continue;
                    entity = (EntityLiving)entities.get(num);
                    world.func_72942_c((Entity)new EntityLightningBolt(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, false));
                    continue;
                }
                int num = r.nextInt(players.size());
                if (!(players.get(num) instanceof EntityPlayer)) continue;
                entity = (EntityPlayer)players.get(num);
                world.func_72942_c((Entity)new EntityLightningBolt(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, false));
                continue;
            }
            double finalX = x + (r.nextDouble() * (radius * 2.0) - radius);
            double finalZ = z + (r.nextDouble() * (radius * 2.0) - radius);
            double finalY = world.func_175672_r(new BlockPos(finalX, 255.0, finalZ)).func_177956_o();
            world.func_72942_c((Entity)new EntityLightningBolt(world, finalX, finalY, finalZ, false));
        }
    }

    static void damageNearbyPlayers(EntityPlayer ep, int range, float damage, float velMul) {
        double x1 = ep.field_70165_t - (double)range;
        double x2 = ep.field_70165_t + (double)range;
        double y1 = ep.field_70163_u - (double)range;
        double y2 = ep.field_70163_u + (double)range;
        double z1 = ep.field_70161_v - (double)range;
        double z2 = ep.field_70161_v + (double)range;
        List entities = ep.func_184102_h().func_130014_f_().func_72839_b((Entity)ep, new AxisAlignedBB(x1, y1, z1, x2, y2, z2));
        for (int i = 0; i < entities.size(); ++i) {
            if (entities.get(i) == null) continue;
            if (entities.get(i) instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)entities.get(i);
                entityPlayer.func_70097_a(DamageSource.func_76365_a((EntityPlayer)ep), OPUtils.damageCalculation(entityPlayer, damage));
            } else if (entities.get(i) instanceof EntityLiving) {
                Entity e = (Entity)entities.get(i);
                e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)ep), damage);
            }
            if (!(entities.get(i) instanceof EntityLiving) && !(entities.get(i) instanceof EntityPlayer)) continue;
            double distanceX = ((Entity)entities.get((int)i)).field_70165_t - ep.field_70165_t;
            double distanceY = ((Entity)entities.get((int)i)).field_70163_u - ep.field_70163_u;
            double distanceZ = ((Entity)entities.get((int)i)).field_70161_v - ep.field_70161_v;
            double velocityX = (double)range / distanceX * (double)velMul;
            double velocityY = (double)range / distanceY * (double)velMul;
            double velocityZ = (double)range / distanceZ * (double)velMul;
            if (distanceX == 0.0) {
                velocityX = 0.0;
            }
            if (distanceY == 0.0) {
                velocityY = 0.0;
            }
            if (distanceZ == 0.0) {
                velocityZ = 0.0;
            }
            if (velocityX > (double)range) {
                velocityX = range;
            }
            if (velocityX < (double)(-range)) {
                velocityX = -range;
            }
            if (velocityY > (double)range) {
                velocityY = range;
            }
            if (velocityY < (double)(-range)) {
                velocityY = -range;
            }
            if (velocityZ > (double)range) {
                velocityZ = range;
            }
            if (velocityZ < (double)(-range)) {
                velocityZ = -range;
            }
            ((Entity)entities.get(i)).func_70024_g(velocityX, velocityY, velocityZ);
        }
    }

    static void createIceSeaRoad(EnumFacing ef, BlockPos startPoint, EntityPlayer ep) {
        Block roadMat = OPBlocks.BlockIceAge;
        World world = ep.field_70170_p;
        switch (ef) {
            case EAST: {
                for (int i = 0; i < 200; ++i) {
                    for (int h = -2; h < 2; ++h) {
                        if (OPMessage.isBlockWater(ep, startPoint.func_177982_a(i, h, 0))) {
                            world.func_175656_a(startPoint.func_177982_a(i, h, 0), roadMat.func_176223_P());
                        }
                        if (OPMessage.isBlockWater(ep, startPoint.func_177982_a(i, h, 1))) {
                            world.func_175656_a(startPoint.func_177982_a(i, h, 1), roadMat.func_176223_P());
                        }
                        if (!OPMessage.isBlockWater(ep, startPoint.func_177982_a(i, h, -1))) continue;
                        world.func_175656_a(startPoint.func_177982_a(i, h, -1), roadMat.func_176223_P());
                    }
                }
                break;
            }
            case WEST: {
                for (int i = 0; i < 200; ++i) {
                    for (int h = -2; h < 2; ++h) {
                        if (OPMessage.isBlockWater(ep, startPoint.func_177982_a(-i, h, 0))) {
                            world.func_175656_a(startPoint.func_177982_a(-i, h, 0), roadMat.func_176223_P());
                        }
                        if (OPMessage.isBlockWater(ep, startPoint.func_177982_a(-i, h, 1))) {
                            world.func_175656_a(startPoint.func_177982_a(-i, h, 1), roadMat.func_176223_P());
                        }
                        if (!OPMessage.isBlockWater(ep, startPoint.func_177982_a(-i, h, -1))) continue;
                        world.func_175656_a(startPoint.func_177982_a(-i, h, -1), roadMat.func_176223_P());
                    }
                }
                break;
            }
            case SOUTH: {
                for (int i = 0; i < 200; ++i) {
                    for (int h = -2; h < 2; ++h) {
                        if (OPMessage.isBlockWater(ep, startPoint.func_177982_a(0, h, i))) {
                            world.func_175656_a(startPoint.func_177982_a(0, h, i), roadMat.func_176223_P());
                        }
                        if (OPMessage.isBlockWater(ep, startPoint.func_177982_a(1, h, i))) {
                            world.func_175656_a(startPoint.func_177982_a(1, h, i), roadMat.func_176223_P());
                        }
                        if (!OPMessage.isBlockWater(ep, startPoint.func_177982_a(-1, h, i))) continue;
                        world.func_175656_a(startPoint.func_177982_a(-1, h, i), roadMat.func_176223_P());
                    }
                }
                break;
            }
            case NORTH: {
                for (int i = 0; i < 200; ++i) {
                    for (int h = -2; h < 2; ++h) {
                        if (OPMessage.isBlockWater(ep, startPoint.func_177982_a(0, h, -i))) {
                            world.func_175656_a(startPoint.func_177982_a(0, h, -i), roadMat.func_176223_P());
                        }
                        if (OPMessage.isBlockWater(ep, startPoint.func_177982_a(1, h, -i))) {
                            world.func_175656_a(startPoint.func_177982_a(1, h, -i), roadMat.func_176223_P());
                        }
                        if (!OPMessage.isBlockWater(ep, startPoint.func_177982_a(-1, h, -i))) continue;
                        world.func_175656_a(startPoint.func_177982_a(-1, h, -i), roadMat.func_176223_P());
                    }
                }
                break;
            }
        }
    }

    private static boolean isBlockWater(EntityPlayer ep, BlockPos blockPos) {
        World world = ep.func_184102_h().func_130014_f_();
        return world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150358_i;
    }

    static void destroyNearbyCropsAndGrass(EntityPlayer ep, int radius) {
        BlockPos playerPos = new BlockPos(ep.field_70165_t, ep.field_70163_u, ep.field_70161_v);
        World world = ep.func_184102_h().func_130014_f_();
        for (int x = -radius; x < radius; ++x) {
            for (int y = -radius; y < radius; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    BlockPos pos = playerPos.func_177982_a(x, y, z);
                    Block blockFound = world.func_180495_p(pos).func_177230_c();
                    if (blockFound != Blocks.field_150330_I && blockFound != Blocks.field_150398_cm && blockFound != Blocks.field_150327_N && blockFound != Blocks.field_150328_O && blockFound != Blocks.field_150345_g && blockFound != Blocks.field_150464_aj && blockFound != Blocks.field_150459_bM && blockFound != Blocks.field_150469_bN && blockFound != Blocks.field_185773_cZ && blockFound != Blocks.field_150338_P && blockFound != Blocks.field_150337_Q && blockFound != Blocks.field_150395_bd && blockFound != Blocks.field_150392_bi) continue;
                    world.func_175655_b(pos, false);
                }
            }
        }
    }

    static BlockPos findCenterOfDome(EntityPlayer ep) {
        BlockPos DomeCenter = new BlockPos(0, 0, 0);
        boolean foundCenter = false;
        BlockPos center = new BlockPos(ep.field_70165_t, ep.field_70163_u, ep.field_70161_v);
        int x = center.func_177958_n();
        int y = center.func_177956_o();
        int z = center.func_177952_p();
        int radius = 40;
        for (int i = x - radius; i < x + radius; ++i) {
            block1: for (int j = y - radius; j < y + radius; ++j) {
                for (int k = z - radius; k < z + radius; ++k) {
                    if (ep.func_184102_h().func_130014_f_().func_180495_p(new BlockPos(i, j, k)).func_177230_c() != OPBlocks.BlockLawDomeCenter) continue;
                    foundCenter = true;
                    DomeCenter = new BlockPos(i, j, k);
                    continue block1;
                }
            }
        }
        if (foundCenter) {
            return DomeCenter;
        }
        return null;
    }

    static void OPTakt(EntityPlayer ep) {
        BlockPos DomeCenter = new BlockPos((Vec3i)OPMessage.findCenterOfDome(ep));
        if (DomeCenter != null) {
            Random r = new Random();
            int radius = 6;
            int x = DomeCenter.func_177958_n();
            int y = DomeCenter.func_177956_o();
            int z = DomeCenter.func_177952_p();
            World world = ep.func_184102_h().func_130014_f_();
            for (int i = x - radius; i < x + radius; ++i) {
                for (int j = y - 4; j < y + 4; ++j) {
                    for (int k = z - radius; k < z + radius; ++k) {
                        Block blockFound = world.func_180495_p(new BlockPos(i, j, k)).func_177230_c();
                        if (blockFound == OPBlocks.BlockLawDomeCenter || blockFound == OPBlocks.BlockLawDome || blockFound == Blocks.field_150350_a || blockFound == Blocks.field_150357_h || blockFound == Blocks.field_150427_aO || blockFound == Blocks.field_185775_db || blockFound == Blocks.field_150384_bq || blockFound == Blocks.field_150378_br || blockFound == Blocks.field_150486_ae || blockFound == Blocks.field_150477_bB || blockFound == Blocks.field_150447_bR || blockFound == Blocks.field_150355_j || blockFound == Blocks.field_150358_i || blockFound == Blocks.field_150353_l || blockFound == Blocks.field_150356_k || blockFound == Blocks.field_150464_aj || blockFound == Blocks.field_150459_bM || blockFound == Blocks.field_150469_bN || blockFound == Blocks.field_150393_bb || blockFound == Blocks.field_150394_bc || blockFound == Blocks.field_150448_aq || blockFound == Blocks.field_150408_cc || blockFound == Blocks.field_150319_E || blockFound == Blocks.field_150318_D || blockFound == Blocks.field_185766_cS || blockFound == Blocks.field_150328_O || blockFound == Blocks.field_150327_N || blockFound == Blocks.field_150338_P || blockFound == Blocks.field_150337_Q || blockFound == Blocks.field_150329_H || blockFound == Blocks.field_150345_g || blockFound == Blocks.field_150488_af || blockFound == Blocks.field_185773_cZ || blockFound == Blocks.field_150398_cm || blockFound == Blocks.field_150473_bD || blockFound == Blocks.field_150479_bC || !OPMessage.canBlockSeeSky(new BlockPos(i, j, k), ep)) continue;
                        world.func_175698_g(new BlockPos(i, j, k));
                        EntityFallingBlock entityFallingBlock = new EntityFallingBlock(world, (double)i + (double)r.nextInt(radius * 5) - (double)r.nextInt(radius * 5), (double)y + (double)r.nextInt(30), (double)k + (double)r.nextInt(radius * 5) - (double)r.nextInt(radius * 5), blockFound.func_176194_O().func_177621_b());
                        entityFallingBlock.field_145812_b = 2;
                        world.func_72838_d((Entity)entityFallingBlock);
                    }
                }
            }
        }
    }

    static boolean canBlockSeeSky(BlockPos blockPos, EntityPlayer ep) {
        int y = blockPos.func_177956_o();
        int x = blockPos.func_177958_n();
        int z = blockPos.func_177952_p();
        World world = ep.func_184102_h().func_130014_f_();
        for (int i = 256; i > y; --i) {
            if (world.func_180495_p(new BlockPos(x, i, z)) == Blocks.field_150350_a.func_176223_P() || world.func_180495_p(new BlockPos(x, i, z)) == Blocks.field_150480_ab.func_176223_P() || world.func_180495_p(new BlockPos(x, i, z)) == OPBlocks.BlockLawDome.func_176223_P() || world.func_180495_p(new BlockPos(x, i, z)) == OPBlocks.BlockLawDomeCenter.func_176223_P()) continue;
            return false;
        }
        return true;
    }

    static void OPShambles(EntityPlayer ep) {
        BlockPos DomeCenter = new BlockPos((Vec3i)OPMessage.findCenterOfDome(ep));
        if (DomeCenter != null) {
            int tpZ;
            int tpX;
            Random r;
            int i;
            World world = ep.func_184102_h().func_130014_f_();
            double distance = 19.0;
            double x1 = (double)DomeCenter.func_177958_n() - distance;
            double x2 = (double)DomeCenter.func_177958_n() + distance;
            double y1 = (double)DomeCenter.func_177956_o() - distance;
            double y2 = (double)DomeCenter.func_177956_o() + distance;
            double z1 = (double)DomeCenter.func_177952_p() - distance;
            double z2 = (double)DomeCenter.func_177952_p() + distance;
            List entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(x1, y1, z1, x2, y2, z2));
            List players = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(x1, y1, z1, x2, y2, z2));
            if (!players.isEmpty()) {
                for (i = 0; i < players.size(); ++i) {
                    if (players.get(i) == null || !(players.get(i) instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)players.get(i);
                    r = new Random();
                    tpX = r.nextInt(37);
                    tpZ = r.nextInt(37);
                    if (player == ep) continue;
                    player.func_70107_b(x1 + (double)tpX, (double)player.func_180425_c().func_177956_o(), z1 + (double)tpZ);
                }
            }
            if (!entities.isEmpty()) {
                for (i = 0; i < entities.size(); ++i) {
                    if (entities.get(i) == null || !(entities.get(i) instanceof EntityLiving)) continue;
                    EntityLiving el = (EntityLiving)entities.get(i);
                    r = new Random();
                    tpX = r.nextInt(37);
                    tpZ = r.nextInt(37);
                    el.func_70107_b(x1 + (double)tpX, (double)el.func_180425_c().func_177956_o(), z1 + (double)tpZ);
                }
            }
        }
    }

    static void OPInjectionShot(EntityPlayer ep) {
        BlockPos DomeCenter = new BlockPos((Vec3i)OPMessage.findCenterOfDome(ep));
        if (DomeCenter != null) {
            double distance = 19.0;
            double x1 = (double)DomeCenter.func_177958_n() - distance;
            double x2 = (double)DomeCenter.func_177958_n() + distance;
            double y1 = (double)DomeCenter.func_177956_o() - distance;
            double y2 = (double)DomeCenter.func_177956_o() + distance;
            double z1 = (double)DomeCenter.func_177952_p() - distance;
            double z2 = (double)DomeCenter.func_177952_p() + distance;
            World world = ep.func_184102_h().func_130014_f_();
            List players = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(x1, y1, z1, x2, y2, z2));
            if (!players.isEmpty()) {
                for (int i = 0; i < players.size(); ++i) {
                    EntityPlayer player;
                    if (players.get(i) == null || !(players.get(i) instanceof EntityPlayer) || (player = (EntityPlayer)players.get(i)) == ep) continue;
                    ep.func_184595_k(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    player.func_70097_a(DamageSource.func_76365_a((EntityPlayer)ep), OPUtils.damageCalculation(player, 8.0f));
                    break;
                }
            }
        }
    }
}

