/*
 * Decompiled with CFR 0.152.
 */
package georgetsak.opcraft.network.packets;

import georgetsak.opcraft.misc.OPUtils;
import georgetsak.opcraft.misc.capabilities.stats.normal.IStatsNormalCap;
import georgetsak.opcraft.misc.capabilities.stats.normal.StatsNormalCapProvider;
import georgetsak.opcraft.network.AbstractMessage;
import java.io.IOException;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;

public class StatsNormalServerPacket
extends AbstractMessage.AbstractServerMessage<StatsNormalServerPacket> {
    int health;
    int attack;
    int defence;
    int speed;

    public StatsNormalServerPacket() {
    }

    public StatsNormalServerPacket(IStatsNormalCap stats) {
        this.health = stats.getHealthLevel();
        this.attack = stats.getAttackLevel();
        this.defence = stats.getDefenceLevel();
        this.speed = stats.getSpeedLevel();
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.health = buffer.readInt();
        this.attack = buffer.readInt();
        this.defence = buffer.readInt();
        this.speed = buffer.readInt();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.health);
        buffer.writeInt(this.attack);
        buffer.writeInt(this.defence);
        buffer.writeInt(this.speed);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (side.isServer()) {
            IStatsNormalCap stats = (IStatsNormalCap)player.getCapability(StatsNormalCapProvider.SN_CAP, null);
            stats.setHealthLevel(this.health);
            stats.setAttackLevel(this.attack);
            stats.setDefenceLevel(this.defence);
            stats.setSpeedLevel(this.speed);
            player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(20 + stats.getHealthLevel() * 2));
            OPUtils.updateStats(player, stats);
        }
    }
}

