<?php

/*

 * 腾讯云存储视频管理

 * ============================================================================

 * 源码来自凯美乐源码网整理

 * 网站地址: http://bbs.kaimle.com

 * ----------------------------------------------------------------------------

 * 这不是一个自由软件！不允许对程序代码以任何形式任何目的的再发布，作者将保留

 * 追究法律责任的权力和最终解释权。

 * ============================================================================

 */





/* 配置信息 */

$setting = pdo_fetch("SELECT qcloud FROM " .tablename($this->table_setting). " WHERE uniacid=:uniacid LIMIT 1", array(':uniacid'=>$uniacid));

/* 参数设置 */

$config = $this->module['config'];



$qcloud = unserialize($setting['qcloud']);

if(!empty($qcloud['url'])){

	$qcloud['url'] = "http://".$qcloud['url'];

}

$qcloud['region'] = $config['tencent_area'];





if($config['tencent_switch'] != 1){

	message("当前系统未开启腾讯云对象存储，如有疑问，请联系管理员");

}





/* 引入腾讯云存储API接口 */

require_once(MODULE_ROOT.'/mobile/Qcloud/include.php');

$bucketName = $qcloud['bucket'];





/* 讲师信息 */

$teacher = pdo_fetch("SELECT * FROM " .tablename($this->table_teacher). " WHERE uniacid=:uniacid AND id=:id LIMIT 1", array(':uniacid'=>$uniacid, ':id'=>$_SESSION[$uniacid.'_teacher_id']));



if($op=='display'){

	$linkNav = array(

		'0'	=> array(

			'title'	=> "视频管理",

			'link'	=> $this->createMobileUrl('tencent')

		)

	);



	QcloudCos\Cosapi::setRegion($qcloud['region']);



	/* 查询以讲师id为目录名，如果不存在则创建 */

	$dstFolder = '/'.$teacher['id'].'/';

	$statRet = QcloudCos\Cosapi::statFolder($bucketName, $dstFolder, $qcloud);



	if($statRet['code'] !=0 ){

		$createFolderRet = QcloudCos\Cosapi::createFolder($bucketName, $dstFolder, $bizAttr = null, $qcloud);

	}



	/* 列出文件 */

	$prefix = trim($_GPC['keyword']);

	$listnum = 8;

	$pattern = "eListBoth";

	$order = $_GPC['order']=='' ? 1 : $_GPC['order'];

	$content = $_GPC['context'];



	if(empty($prefix)){

		$list = QcloudCos\Cosapi::listFolder($bucketName, $dstFolder, $listnum, $pattern, $order, $content, $qcloud);

	}else{

		$dstFolder .= $prefix;

		$list = QcloudCos\Cosapi::prefixSearch($bucketName, $dstFolder, $listnum, $pattern, $order, $content, $qcloud);

	}



	foreach($list['data']['infos'] as $key=>$value){

		if(!empty($qcloud['url'])){

			$tmp_url = explode("myqcloud.com", $value['access_url']);

			$video_url = $qcloud['url'].$tmp_url[1];

		}else{

			$video_url = $value['access_url'];

		}



		$list['data']['infos'][$key]['video_url'] = $video_url;

		$list['data']['infos'][$key]['play_url'] = $this->tencentDownloadUrl($qcloud, $video_url);

		$tmp = explode('.', $value['name']);

		$list['data']['infos'][$key]['suffix'] = $tmp[count($tmp)-1];

	}



}else if($op=='upload'){

	$linkNav = array(

		'0'	=> array(

			'title'	=> "视频管理",

			'link'	=> $this->createMobileUrl('tencent')

		),

		'1'	=> array(

			'title'	=> "上传视频",

			'link'	=> $this->createMobileUrl('tencent', array('op'=>'upload'))

		),

	);



	if($teacher['upload'] !=1){

		message("抱歉，您没有上传课程的权限，如有疑问，请联系管理员!", "", "error");

	}



	if(!empty($config['starttime']) && !empty($config['endtime'])){

		if($config['starttime'] < $config['endtime']){//时间跨度为一天

			$today = date('Y-m-d ');

			$starttime = strtotime($today.$config['starttime']);

			$endtime = strtotime($today.$config['endtime']);

			if(time() < $starttime || time() > $endtime){

				message("上传时间为每天{$config['starttime']}~{$config['endtime']}");

			}

		}else{//时间跨度为两天

			$now = date('H:i');

			if($now > $config['starttime']){

				$today = date('Y-m-d ');

				$starttime = strtotime($today.$config['starttime']);

				$endtime = strtotime($today.$config['endtime'])+86400;

			}elseif($now < $config['starttime']){

				$today = date('Y-m-d ');

				$starttime = strtotime($today.$config['starttime'])-86400;

				$endtime = strtotime($today.$config['endtime']);

			}

			if(time() < $starttime || time() > $endtime){

				message("上传时间为每天{$config['starttime']}~第二天{$config['endtime']}");

			}

		}

	}



	/* 允许上传视频格式 */

	if(!empty($config['video_type']))

	$allowVideo = explode(",", $config['video_type']);

	foreach($allowVideo as $type){

		$video_type .= "video/".$type.",";

	}

	$video_type = trim($video_type,",");



	$expired = time() + 180;

	$signature = QcloudCos\Auth::createReusableSignature($expired, $bucketName, $filepath = null, $qcloud);



}



if($op!='getSign'){

	include $this->template('tencent');

}