//
//  YNESDKEditorView.h
//  editorSDK
//
//  Created by 金鑫 on 2017/12/1.
//  Copyright © 2017年 NetEase Youdao. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "YNESDKEditorRegister.h"
@class YNESDKEditorView;

typedef NS_ENUM(NSUInteger, YNESDKEditorContentType) {
    YNESDKEditorContentTypeXML,
    YNESDKEditorContentTypeJSON
};

const static NSInteger attachmentProgressBase = 100;
const static NSInteger attachmentProgressNotStart = 0 * attachmentProgressBase - 1;      //未下载
const static NSInteger attachmentProgressComplete = 1 * attachmentProgressBase + 1;       //本地存在，等同于下载完成和上传完成

@protocol YNESDKEditorDelegate <NSObject>
@optional
-(void)editorView:(YNESDKEditorView *)editorView initIsSuccess:(BOOL)isSuccess withError:(NSError *)error;
-(void)editorView:(YNESDKEditorView*)editorView clickImageList:(NSArray*)imageList atIndex:(NSUInteger)index;
-(void)editorView:(YNESDKEditorView*)editorView clickAttachment:(NSString*)filePath;
-(NSInteger)editorView:(YNESDKEditorView*)editorView getAttachmentInitProgress:(NSString*)filePath;
-(void)editorView:(YNESDKEditorView*)editorView clickLink:(NSString*)url;
-(void)editorViewClickPhotoButton:(YNESDKEditorView *)editorView;
-(void)editorViewClickCameraButton:(YNESDKEditorView *)editorView;
-(void)editorViewClickVideoButton:(YNESDKEditorView *)editorView;
-(void)editorViewClickLinkButton:(YNESDKEditorView *)editorView;
-(void)editorView:(YNESDKEditorView *)editorView undoStatusDidChange:(BOOL)undo;
-(void)editorView:(YNESDKEditorView *)editorView redoStatusDidChange:(BOOL)redo;

@end

@interface YNESDKEditorView : UIView

@property(nonatomic, weak) id<YNESDKEditorDelegate> delegate;

+ (NSString*)resourcePath;
+ (NSString*)copyToResourcePath:(NSString*)originalPath;

- (instancetype)initWithContent:(NSString *)content withType:(YNESDKEditorContentType)type;
- (void) setContent:(NSString*)content withType:(YNESDKEditorContentType)type;
- (NSString*)getContentWithType:(YNESDKEditorContentType)type;
- (void)updateProgress:(NSInteger)progress ofAttachment:(NSString*)filePath;
- (void)insertURL:(NSString*)src;
- (void)insertImage:(NSString*)path;
- (void)insertAttachmentWithPath:(NSString*)path length:(NSUInteger)length;
- (BOOL)canUndo;
- (BOOL)canRedo;
- (void)redo;
- (void)undo;

@end
